<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class SubAccountModel extends BaseModel
{

	public function getSubAccountData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_sub_account as tsl');
        $builder->select("tsl.*,tsloc.society_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tsl.updated_by AND tupdate.society_id = tsl.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tsl.created_by AND tcreate.society_id = tsl.society_id","left");
        $builder->join(MASTER_DB.".tbl_society as tsloc","tsloc.society_id = tsl.society_id","left");

        if (isset($filterData['sub_account_id']) && !empty($filterData['sub_account_id'])) {
            if (is_array($filterData['sub_account_id'])) {
                $builder->whereIn('tsl.sub_account_id', $filterData['sub_account_id']);
            } else {
                $builder->where('tsl.sub_account_id', $filterData['sub_account_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tsl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tsl.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['sub_account_code']) && !empty($filterData['sub_account_code'])) {
            if (is_array($filterData['sub_account_code'])) {
                $builder->whereIn('tsl.sub_account_code', $filterData['sub_account_code']);
            } else {
                $builder->where('tsl.sub_account_code', $filterData['sub_account_code']);
            }
        }
        if (isset($filterData['sub_account_name']) && !empty($filterData['sub_account_name'])) {
            if (is_array($filterData['sub_account_name'])) {
                $builder->whereIn('tsl.sub_account_name', $filterData['sub_account_name']);
            } else {
                $builder->where('tsl.sub_account_name', $filterData['sub_account_name']);
            }
        }

        if (isset($filterData['start'])) {
            if ($filterData['start'] != '1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
            $builder->where('tsl.is_active', $filterData['is_active']);
        }


        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tsl.sub_account_code', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tsl.sub_account_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($subAccountId)
    {
        $subAccountIdArray = is_array($subAccountId) ? $subAccountId : array($subAccountId);
        $builder = $this->db->table('tbl_sub_account');
        $builder->whereIn('sub_account_id', $subAccountIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($subAccountId)){
                foreach($subAccountId as $documentElement){
                    $deleteDataArray['module'] = 'SubAccount';
                    $deleteDataArray['activity'] = "SubAccount Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('SubAccount Deleted [SubAccountID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'SubAccount',$documentElement,json_encode($deleteDataArray),'','SubAccount',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getSubAccount($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_sub_account as tsl');
        //$builder->startCache();
        $builder->select("tsl.sub_account_id as id,COALESCE(tsl.sub_account_name,'')  as text");
        if(isset($filterData['sub_account_id']) && !empty($filterData['sub_account_id'])) {
            if (is_array($filterData['sub_account_id'])) {
                $builder->whereIn('tsl.sub_account_id', $filterData['sub_account_id']);
            } else {
                $builder->where('tsl.sub_account_id', $filterData['sub_account_id']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tsl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tsl.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tsl.sub_account_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tsl.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getSubAccountAccountData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_account_sub_account as tslsl');
        $builder->select("tslsl.account_sub_account_id,tslsl.account_id");
        $builder->select("concat(COALESCE(tsl.account_code,''),'-',COALESCE(tsl.account_name,'')) as account_code_name");
        $builder->join('tbl_account tsl', 'tsl.account_id = tslsl.account_id', 'left');

        if(isset($filterData['sub_account_id']) && !empty($filterData['sub_account_id'])) {
            if (is_array($filterData['sub_account_id'])) {
                $builder->whereIn('tslsl.sub_account_id', $filterData['sub_account_id']);
            } else {
                $builder->where('tslsl.sub_account_id', $filterData['sub_account_id']);
            }
        }

        // if (isset($filterData['sub_account_image_id']) && $filterData['sub_account_image_id'] != '') {
        //     $builder->where("tmi.sub_account_image_id", $filterData['sub_account_image_id']);
        // }

        $builder->orderBy("tslsl.sub_account_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteAccountRecord($subAccountId){
        $builder = $this->db->table('tbl_account_sub_account');
        $subAccountIdArray = is_array($subAccountId) ? $subAccountId : array($subAccountId);
        $builder->whereIn('sub_account_id', $subAccountIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

}
?>
