<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class StatusModel extends BaseModel
{

    public function getStatusData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_status as ts');
        $builder->select("ts.*");

        if(isset($filterData['status_id']) && !empty($filterData['status_id'])) {
            if (is_array($filterData['status_id'])) {
                $builder->whereIn('ts.status_id', $filterData['status_id']);
            } else {
                $builder->where('ts.status_id', $filterData['status_id']);
            }
        }

        if(isset($filterData['status_for']) && !empty($filterData['status_for'])) {
            if (is_array($filterData['status_for'])) {
                $builder->whereIn('ts.status_for', $filterData['status_for']);
            } else {
                $builder->where('ts.status_for', $filterData['status_for']);
            }
        }

        if(isset($filterData['status_name']) && !empty($filterData['status_name'])) {
            if (is_array($filterData['status_name'])) {
                $builder->whereIn('ts.status_name', $filterData['status_name']);
            } else {
                $builder->where('ts.status_name', $filterData['status_name']);
            }
        }

        if(isset($filterData['is_default']) && !empty($filterData['is_default'])) {
            if (is_array($filterData['is_default'])) {
                $builder->whereIn('ts.is_default', $filterData['is_default']);
            } else {
                $builder->where('ts.is_default', $filterData['is_default']);
            }
        }


        if(isset($filterData['is_open']) && !empty($filterData['is_open'])) {
            if (is_array($filterData['is_open'])) {
                $builder->whereIn('ts.is_open', $filterData['is_open']);
            } else {
                $builder->where('ts.is_open', $filterData['is_open']);
            }
        }

        if(isset($filterData['is_resolved']) && !empty($filterData['is_resolved'])) {
            if (is_array($filterData['is_resolved'])) {
                $builder->whereIn('ts.is_resolved', $filterData['is_resolved']);
            } else {
                $builder->where('ts.is_resolved', $filterData['is_resolved']);
            }
        }


        if(isset($filterData['is_close']) && !empty($filterData['is_close'])) {
            if (is_array($filterData['is_close'])) {
                $builder->whereIn('ts.is_close', $filterData['is_close']);
            } else {
                $builder->where('ts.is_close', $filterData['is_close']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('ts.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('status_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('ts.status_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($statusId)
    {
        $builder = $this->db->table('tbl_status');
        $statusIdArray = is_array($statusId) ? $statusId : array($statusId);
        $builder->whereIn('status_id', $statusIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($statusId)){
                foreach($statusId as $status){
                    $deleteDataArray['module'] = 'Status';
                    $deleteDataArray['activity'] = "Status Deleted";
                    $deleteDataArray['module_id'] = $status;
                    logActivity('Status Deleted [StatusID: ' . $status . ']',$this->ionAuth->getUserId(),'Status',$status,json_encode($deleteDataArray),'','Status',$status);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getStatus($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_status as ts');
        //$builder->startCache();
        $builder->select("ts.status_id as id,COALESCE(ts.status_name,'') as text");

        if(isset($filterData['status_id']) && !empty($filterData['status_id'])) {
            if (is_array($filterData['status_id'])) {
                $builder->whereIn('ts.status_id', $filterData['status_id']);
            } else {
                $builder->where('ts.status_id', $filterData['status_id']);
            }
        }

        if(isset($filterData['status_for']) && !empty($filterData['status_for'])) {
            if (is_array($filterData['status_for'])) {
                $builder->whereIn('ts.status_for', $filterData['status_for']);
            } else {
                $builder->where('ts.status_for', $filterData['status_for']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ts.status_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ts.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function checkStatusNameExist($filterData = array())
    {

        $builder = $this->db->table('tbl_status as ts');
        $builder->select("ts.*");

        if(isset($filterData['status_id']) && !empty($filterData['status_id'])) {
            if (is_array($filterData['status_id'])) {
                $builder->whereNotIn('ts.status_id', $filterData['status_id']);
            } else {
                $builder->where('ts.status_id !=', $filterData['status_id']);
            }
        }
        if(isset($filterData['status_for']) && !empty($filterData['status_for'])) {
            if (is_array($filterData['status_for'])) {
                $builder->whereIn('ts.status_for', $filterData['status_for']);
            } else {
                $builder->where('ts.status_for', $filterData['status_for']);
            }
        }
        if(isset($filterData['status_name']) && !empty($filterData['status_name'])) {
            if (is_array($filterData['status_name'])) {
                $builder->whereIn('ts.status_name', $filterData['status_name']);
            } else {
                $builder->where('ts.status_name', $filterData['status_name']);
            }
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
}