<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class StaffModel extends BaseModel
{

	public function getStaffData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_staff as ts');
        $builder->select("ts.*,tsoc.society_name,COALESCE(tt.tower_name,'') as tower_name,COALESCE(tv.vendor_name,'') as vendor_name,tg.gate_type");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,staffImage.staff_image");
        $builder->join("tbl_users as tupdate","tupdate.id = ts.updated_by","left");
        $builder->join("tbl_users as tcreate","tcreate.id = ts.created_by","left");
        $builder->join("tbl_society as tsoc","tsoc.society_id = ts.society_id","left");
        $builder->join("tbl_staff_guard as tsg","tsg.staff_id = ts.staff_id","left");
        $builder->join("tbl_gate as tg","tg.gate_id = tsg.gate_id","left");
        $builder->join("tbl_vendor as tv","tv.vendor_id = ts.vendor_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tg.tower_id","left");

        $builder->join("(SELECT tsi.staff_image AS staff_image,tsi.staff_id  from tbl_staff_image tsi  ORDER BY tsi.updated_at DESC) AS staffImage",  "staffImage.staff_id = ts.staff_id", "left");

        if (isset($filterData['staff_id']) && !empty($filterData['staff_id'])) {
            if (is_array($filterData['staff_id'])) {
                $builder->whereIn('ts.staff_id', $filterData['staff_id']);
            } else {
                $builder->where('ts.staff_id', $filterData['staff_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ts.society_id', $filterData['society_id']);
            } else {
                $builder->where('ts.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['staff_type']) && !empty($filterData['staff_type'])) {
            if (is_array($filterData['staff_type'])) {
                $builder->whereIn('ts.staff_type', $filterData['staff_type']);
            } else {
                $builder->where('ts.staff_type', $filterData['staff_type']);
            }
        }

        if (isset($filterData['start'])) {
            if ($filterData['start'] != '1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
            $builder->where('ts.is_active', $filterData['is_active']);
        }


        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('ts.staff_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('ts.staff_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($staffId)
    {
        $staffIdArray = is_array($staffId) ? $staffId : array($staffId);
        $builder = $this->db->table('tbl_staff_image');
        $builder->whereIn('staff_id', $staffIdArray);
        $builder->delete();
        $builder = $this->db->table('tbl_staff');
        $builder->whereIn('staff_id', $staffIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($staffId)){
                foreach($staffId as $documentElement){
                    $deleteDataArray['module'] = 'Staff';
                    $deleteDataArray['activity'] = "Staff Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Staff Deleted [StaffID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Staff',$documentElement,json_encode($deleteDataArray),'','Staff',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getStaff($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_staff as ts');
        //$builder->startCache();
        $builder->select("ts.staff_id as id,COALESCE(ts.staff_name,'')  as text");
        if(isset($filterData['staff_id']) && !empty($filterData['staff_id'])) {
            if (is_array($filterData['staff_id'])) {
                $builder->whereIn('ts.staff_id', $filterData['staff_id']);
            } else {
                $builder->where('ts.staff_id', $filterData['staff_id']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ts.society_id', $filterData['society_id']);
            } else {
                $builder->where('ts.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ts.staff_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ts.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getStaffImageData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_staff_image as tmi');
        $builder->select("tmi.staff_image_id, tmi.staff_image,tmi.staff_id");
        $builder->join('tbl_staff tm', 'tm.staff_id = tmi.staff_id', 'left');

        if(isset($filterData['staff_id']) && !empty($filterData['staff_id'])) {
            if (is_array($filterData['staff_id'])) {
                $builder->whereIn('tmi.staff_id', $filterData['staff_id']);
            } else {
                $builder->where('tmi.staff_id', $filterData['staff_id']);
            }
        }

        if (isset($filterData['staff_image_id']) && $filterData['staff_image_id'] != '') {
            $builder->where("tmi.staff_image_id", $filterData['staff_image_id']);
        }

        if (isset($filterData['is_order_by_staff_id']) ) {
            $builder->orderBy("tmi.staff_image_id","DESC");
        } else {
            $builder->orderBy("tmi.staff_id");
        }



        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
//lastQuery();
        return $query;
    }

    public function deleteStaffImage($staffImageId)
    {
        $builder = $this->db->table('tbl_staff_image');
        $staffImageIdArray = is_array($staffImageId) ? $staffImageId : array($staffImageId);
        $builder->whereIn('staff_image_id', $staffImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getStaffGuardData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_staff_guard as tsg');
        $builder->select("tsg.staff_guard_id,tsg.gate_id,tsg.staff_id");
        $builder->select("tg.gate_name");
        $builder->join('tbl_staff ts', 'ts.staff_id = tsg.staff_id', 'left');
        $builder->join('tbl_gate tg', 'tg.gate_id = tsg.gate_id', 'left');

        if(isset($filterData['staff_id']) && !empty($filterData['staff_id'])) {
            if (is_array($filterData['staff_id'])) {
                $builder->whereIn('tsg.staff_id', $filterData['staff_id']);
            } else {
                $builder->where('tsg.staff_id', $filterData['staff_id']);
            }
        }

        // if (isset($filterData['staff_image_id']) && $filterData['staff_image_id'] != '') {
        //     $builder->where("tmi.staff_image_id", $filterData['staff_image_id']);
        // }

        $builder->orderBy("tsg.staff_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteGuardRecord($staffId){
        $builder = $this->db->table('tbl_staff_guard');
        $staffIdArray = is_array($staffId) ? $staffId : array($staffId);
        $builder->whereIn('staff_id', $staffIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getDocument($filterData)
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_module_document as tmd');
        $builder->select("tmd.*,tdoc.document_name");
        $builder->join('tbl_document tdoc','tdoc.document_id = tmd.document_id','left');

        if(isset($filterData['module']) && !empty($filterData['module'])) {
            if (is_array($filterData['module'])) {
                $builder->whereIn('tmd.module', $filterData['module']);
            } else {
                $builder->where('tmd.module', $filterData['module']);
            }
        }
        if(isset($filterData['document_id']) && !empty($filterData['document_id'])) {
            if (is_array($filterData['document_id'])) {
                $builder->whereIn('tmd.document_id', $filterData['document_id']);
            } else {
                $builder->where('tmd.document_id', $filterData['document_id']);
            }
        }


        if(isset($filterData['module_id']) && !empty($filterData['module_id'])) {
            if (is_array($filterData['module_id'])) {
                $builder->whereIn('tmd.module_id', $filterData['module_id']);
            } else {
                $builder->where('tmd.module_id', $filterData['module_id']);
            }
        }

        if(isset($filterData['module_document_id']) && !empty($filterData['module_document_id'])) {
            if (is_array($filterData['module_document_id'])) {
                $builder->whereIn('tmd.module_document_id', $filterData['module_document_id']);
            } else {
                $builder->where('tmd.module_document_id', $filterData['module_document_id']);
            }
        }


        $builder->orderBy("tmd.module_document_id");
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function getDocumentImage($filterData)
    {
        $builder = $this->db->table('tbl_module_document_image as tmdi');
        $builder->select("tmdi.*");

        if(isset($filterData['module']) && !empty($filterData['module'])) {
            if (is_array($filterData['module'])) {
                $builder->whereIn('tmdi.module', $filterData['module']);
            } else {
                $builder->where('tmdi.module', $filterData['module']);
            }
        }

        if(isset($filterData['document_id']) && !empty($filterData['document_id'])) {
            if (is_array($filterData['document_id'])) {
                $builder->whereIn('tmdi.document_id', $filterData['document_id']);
            } else {
                $builder->where('tmdi.document_id', $filterData['document_id']);
            }
        }


        if(isset($filterData['module_id']) && !empty($filterData['module_id'])) {
            if (is_array($filterData['module_id'])) {
                $builder->whereIn('tmdi.module_id', $filterData['module_id']);
            } else {
                $builder->where('tmdi.module_id', $filterData['module_id']);
            }
        }

        if(isset($filterData['module_document_image_id']) && !empty($filterData['module_document_image_id'])) {
            if (is_array($filterData['module_document_image_id'])) {
                $builder->whereIn('tmdi.module_document_image_id', $filterData['module_document_image_id']);
            } else {
                $builder->where('tmdi.module_document_image_id', $filterData['module_document_image_id']);
            }
        }

        if(isset($filterData['module_document_id']) && !empty($filterData['module_document_id'])) {
            if (is_array($filterData['module_document_id'])) {
                $builder->whereIn('tmdi.module_document_id', $filterData['module_document_id']);
            } else {
                $builder->where('tmdi.module_document_id', $filterData['module_document_id']);
            }
        }

        $builder->orderBy("tmdi.module_document_image_id");
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteModuleDocumentImage($moduleDocumentImageId,$module,$moduleId = 0)
    {
        $builder = $this->db->table('tbl_module_document_image');
        $moduleDocumentImageIdArray = is_array($moduleDocumentImageId) ? $moduleDocumentImageId : array($moduleDocumentImageId);

        $ids = is_array($moduleDocumentImageId) ? implode(',',$moduleDocumentImageId) : $moduleDocumentImageId;
        $builder->whereIn('module_document_image_id',$moduleDocumentImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {

            $deleteDataArray['module'] = underscoreToUcWord($module).' Document Image';
            $deleteDataArray['activity'] = underscoreToUcWord($module)." Document Image Deleted";
            $deleteDataArray['module_id'] = $moduleDocumentImageId;

            logActivity(underscoreToUcWord($module).' Document Image Deleted ['.underscoreToUcWord($module).'ID: ' . $ids . ']',$this->ionAuth->getUserId(),underscoreToUcWord($module).' Document Image',$ids,json_encode($deleteDataArray),'',underscoreToUcWord($module),$moduleId );
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}
?>
