<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class SinkingFundModel extends BaseModel
{

    public function getSinkingFundData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_sinking_fund as tsf');
        $builder->select("tsf.*,tm.name");
        $builder->select("concat(COALESCE(tto.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->select("(select (COALESCE(SUM(tsfi.amount),0)) from tbl_sinking_fund_investment as tsfi where tsfi.sinking_fund_id = tsf.sinking_fund_id) as investment_amount");
        $builder->select("COALESCE(tfy.financial_year_prefix,'') as financial_year_prefix");
        $builder->join("tbl_flat as tf","tf.flat_id = tsf.flat_id","left");
        $builder->join("tbl_tower as tto","tto.tower_id = tf.tower_id","left");
        $builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tsf.ownership_flat_member_id","left");
        $builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");
        $builder->join("tbl_financial_year as tfy","tfy.financial_year_id = tsf.financial_year_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tsf.updated_by AND tupdate.society_id = tsf.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tsf.created_by AND tcreate.society_id = tsf.society_id","left");

        if (isset($filterData['sinking_fund_investment_id_not']) && !empty($filterData['sinking_fund_investment_id_not'])) {
            $excludeId = $filterData['sinking_fund_investment_id_not'];
            $builder->select("(SELECT COALESCE(SUM(tsfi.amount), 0) FROM tbl_sinking_fund_investment AS tsfi WHERE tsfi.sinking_fund_id = tsf.sinking_fund_id AND tsfi.sinking_fund_investment_id != {$excludeId}) AS investment_amount");
        } else {
            $builder->select("(SELECT COALESCE(SUM(tsfi.amount), 0) FROM tbl_sinking_fund_investment AS tsfi WHERE tsfi.sinking_fund_id = tsf.sinking_fund_id) AS investment_amount");
        }
        if (isset($filterData['sinking_fund_id']) && !empty($filterData['sinking_fund_id'])) {
            if (is_array($filterData['sinking_fund_id'])) {
                $builder->whereIn('tsf.sinking_fund_id', $filterData['sinking_fund_id']);
            } else {
                $builder->where('tsf.sinking_fund_id', $filterData['sinking_fund_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tsf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tsf.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tsf.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tsf.flat_id', $filterData['flat_id']);
            }
        }

        if (isset($filterData['sinking_fund_id_not']) && !empty($filterData['sinking_fund_id_not'])) {
            if (is_array($filterData['sinking_fund_id_not'])) {
                $builder->whereNotIn('tsf.sinking_fund_id', $filterData['sinking_fund_id_not']);
            } else {
                $builder->where('tsf.sinking_fund_id !=', $filterData['sinking_fund_id_not']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like("concat(COALESCE(tto.tower_name,''),'-',COALESCE(tf.flat_no,'') )", $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tsf.sinking_fund_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getSinkingFundInvestmentData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_sinking_fund_investment as tsfi');
        $builder->select("tsfi.*,tb.bank_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("tbl_bank as tb","tb.bank_id = tsfi.bank_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tsfi.updated_by AND tupdate.society_id = tsfi.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tsfi.created_by AND tcreate.society_id = tsfi.society_id","left");

        if (isset($filterData['sinking_fund_id']) && !empty($filterData['sinking_fund_id'])) {
            if (is_array($filterData['sinking_fund_id'])) {
                $builder->whereIn('tsfi.sinking_fund_id', $filterData['sinking_fund_id']);
            } else {
                $builder->where('tsfi.sinking_fund_id', $filterData['sinking_fund_id']);
            }
        }

        if (isset($filterData['sinking_fund_investment_id']) && !empty($filterData['sinking_fund_investment_id'])) {
            if (is_array($filterData['sinking_fund_investment_id'])) {
                $builder->whereIn('tsfi.sinking_fund_investment_id', $filterData['sinking_fund_investment_id']);
            } else {
                $builder->where('tsfi.sinking_fund_investment_id', $filterData['sinking_fund_investment_id']);
            }
        }

        $builder->groupBy('tsfi.sinking_fund_investment_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getSinkingFundWithdrawnData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_sinking_fund_withdrawn as tsfw');
        $builder->select("tsfw.*");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tsfw.updated_by AND tupdate.society_id = tsfw.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tsfw.created_by AND tcreate.society_id = tsfw.society_id","left");

        if (isset($filterData['sinking_fund_id']) && !empty($filterData['sinking_fund_id'])) {
            if (is_array($filterData['sinking_fund_id'])) {
                $builder->whereIn('tsfw.sinking_fund_id', $filterData['sinking_fund_id']);
            } else {
                $builder->where('tsfw.sinking_fund_id', $filterData['sinking_fund_id']);
            }
        }

        if (isset($filterData['sinking_fund_withdrawn_id']) && !empty($filterData['sinking_fund_withdrawn_id'])) {
            if (is_array($filterData['sinking_fund_withdrawn_id'])) {
                $builder->whereIn('tsfw.sinking_fund_withdrawn_id', $filterData['sinking_fund_withdrawn_id']);
            } else {
                $builder->where('tsfw.sinking_fund_withdrawn_id', $filterData['sinking_fund_withdrawn_id']);
            }
        }

        $builder->groupBy('tsfw.sinking_fund_withdrawn_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($sinkingFundId)
    {
        $sinkingFundIdArray = is_array($sinkingFundId) ? $sinkingFundId : array($sinkingFundId);

        $builder = $this->db->table('tbl_sinking_fund_investment');
        $builder->whereIn('sinking_fund_id', $sinkingFundIdArray);
        $builder->delete();

        $builder = $this->db->table('tbl_sinking_fund_withdrawn');
        $builder->whereIn('sinking_fund_id', $sinkingFundIdArray);
        $builder->delete();

        $builder = $this->db->table('tbl_sinking_fund');
        $builder->whereIn('sinking_fund_id', $sinkingFundIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($sinkingFundId)){
                foreach($sinkingFundId as $sinkingFund){
                    $deleteDataArray['module'] = 'Sinking Fund';
                    $deleteDataArray['activity'] = "Sinking Fund Deleted";
                    $deleteDataArray['module_id'] = $sinkingFund;
                    logActivity('Sinking Fund Deleted [SinkingFundID: ' . $sinkingFund . ']',$this->ionAuth->getUserId(),'Sinking Fund',$sinkingFund,json_encode($deleteDataArray),'','Sinking Fund',$sinkingFund);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteInvestmentRecord($sinkingFundInvestmentId)
    {
        $builder = $this->db->table('tbl_sinking_fund_investment');
        $sinkingFundInvestmentIdArray = is_array($sinkingFundInvestmentId) ? $sinkingFundInvestmentId : array($sinkingFundInvestmentId);
        $builder->whereIn('sinking_fund_investment_id', $sinkingFundInvestmentIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteWithdrawnRecord($sinkingFundWithdrawnId)
    {
        $builder = $this->db->table('tbl_sinking_fund_withdrawn');
        $sinkingFundWithdrawnIdArray = is_array($sinkingFundWithdrawnId) ? $sinkingFundWithdrawnId : array($sinkingFundWithdrawnId);
        $builder->whereIn('sinking_fund_withdrawn_id', $sinkingFundWithdrawnIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}