<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ResourceModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getResourceData($filterData = array())
	{
		$ownershipFlatMemberId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : 0;
		$ownershipFlatId = isset($filterData['ownership_flat_id']) ? $filterData['ownership_flat_id'] : 0;
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_resource as tr');
        $builder->select("tr.*,tr.resource_name as full_name,tsoc.society_name,COALESCE(tt.tower_name,'') as tower_name,COALESCE(tvendor.vendor_name,'') as vendor_name,GROUP_CONCAT(distinct(tg.gate_type) SEPARATOR ', ') as gate_type,resourceImage.resource_image,trt.resource_type_name,trt.resource_type_name as resource_type_display");
		$builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,COALESCE(tupdate.first_name,'') as updated_by_name");
		//$builder->select("COALESCE(tv.visitor_id,'') as visitor_id,COALESCE(tv.status,'') as visitor_status");
		$builder->select("COALESCE(vtv.visitor_id,'') as visitor_id,COALESCE(vtv.status,'approved') as visitor_status, COALESCE(vtv.start_date,'') as start_date,COALESCE(vtv.end_date,'') as end_date,trt.is_login,trt.group_id,tus.user_society_id,trt.is_guard");

		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tr.updated_by AND tupdate.society_id = tr.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tr.created_by AND tcreate.society_id = tr.society_id","left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.phone = tr.resource_mobile_no AND tus.society_id = tr.society_id","left");

		$builder->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = tr.society_id","left");
        $builder->join("tbl_resource_guard as trg","trg.resource_id = tr.resource_id","left");
        $builder->join("tbl_gate as tg","tg.gate_id = trg.gate_id","left");
        $builder->join("tbl_vendor as tvendor","tvendor.vendor_id = tr.vendor_id","left");
        // $builder->join("tbl_groups as tgroup","tgroup.id = tr.group_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tg.tower_id","left");
        $builder->join("tbl_resource_type as trt","trt.resource_type_id = tr.resource_type_id","left");

        $builder->join("(SELECT tri.document_image AS resource_image,tri.document_image_id,tri.document_type_id FROM tbl_document_image tri WHERE tri.document_type = 'resource' ORDER BY tri.updated_at DESC) AS resourceImage", "resourceImage.document_type_id = tr.resource_id", "left");

		if(!empty($ownershipFlatMemberId)){
			$builder->select("(SELECT count(*) FROM tbl_resource_flat as trf WHERE trf.resource_id = tr.resource_id AND trf.is_deleted = 0 AND trf.ownership_flat_id = '". $ownershipFlatId ."') as is_added");
		}
		$builder->join("tbl_visitor as tv","tv.resource_id = tr.resource_id","left");

//		$builder->join("(SELECT tv.resource_id,tv.visitor_id as visitor_id,tv.status  as status,tv.start_date,tv.end_date
//                                   FROM  tbl_visitor as tv
//                                   WHERE tv.resource_id != 0
//                                   AND tv.visitor_id IN (SELECT MAX(tvv.visitor_id) FROM  tbl_visitor as tvv WHERE tvv.resource_id != 0)
//                                   GROUP BY tv.resource_id ) AS vtv", 'vtv.resource_id = tr.resource_id', "left");

		$builder->join("(SELECT tv.resource_id,tv.visitor_id as visitor_id,tv.status  as status,tv.start_date,tv.end_date
                                   FROM  tbl_visitor as tv
                                   WHERE tv.resource_id != 0
                                   AND tv.start_date IN (SELECT MAX(tvv.start_date) FROM  tbl_visitor as tvv WHERE   tvv.resource_id = tv.resource_id)
                                   GROUP BY tv.resource_id ) AS vtv", 'vtv.resource_id = tr.resource_id', "left");

        // $builder->join("tbl_category as tc","tc.category_id = tr.category_id","left");
		if (isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
			if (is_array($filterData['resource_id'])) {
				$builder->whereIn('tr.resource_id', $filterData['resource_id']);
			} else {
				$builder->where('tr.resource_id', $filterData['resource_id']);
			}
		}

		if (isset($filterData['resource_id_not']) && !empty($filterData['resource_id_not'])) {
			if (is_array($filterData['resource_id_not'])) {
				$builder->whereNotIn('tr.resource_id', $filterData['resource_id_not']);
			} else {
				$builder->where('tr.resource_id != ', $filterData['resource_id_not']);
			}
		}

		if (isset($filterData['status']) && !empty($filterData['status'])) {
			if (is_array($filterData['status'])) {
				$builder->whereIn('vtv.status', $filterData['status']);
			} else {
				$builder->where('vtv.status', $filterData['status']);
			}
		}

		if (isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
			if (is_array($filterData['resource_type_id'])) {
				$builder->whereIn('tr.resource_type_id', $filterData['resource_type_id']);
			} else {
				$builder->where('tr.resource_type_id', $filterData['resource_type_id']);
			}
		}

		if (isset($filterData['resource_mobile_no']) && !empty($filterData['resource_mobile_no'])) {
			if (is_array($filterData['resource_mobile_no'])) {
				$builder->whereIn('tr.resource_mobile_no', $filterData['resource_mobile_no']);
			} else {
				$builder->where('tr.resource_mobile_no', $filterData['resource_mobile_no']);
			}
		}

		if (isset($filterData['qr_code_number']) && !empty($filterData['qr_code_number'])) {
			if (is_array($filterData['qr_code_number'])) {
				$builder->whereIn('tr.qr_code_number', $filterData['qr_code_number']);
			} else {
				$builder->where('tr.qr_code_number', $filterData['qr_code_number']);
			}
			$builder->where('tr.qr_code_number !=', 0);
		}

//		if (isset($filterData['status']) && !empty($filterData['status'])) {
//			if (is_array($filterData['status'])) {
//				$builder->whereIn('tr.status', $filterData['status']);
//			} else {
//				$builder->where('tr.status', $filterData['status']);
//			}
//		}

		if(isset($filterData['is_deleted'])){
			$builder->where('tr.is_deleted', $filterData['is_deleted']);
		}

		if(isset($filterData['is_helper'])){
			$builder->where('trt.is_helper', $filterData['is_helper']);
		}
		
		if(isset($filterData['is_login'])){
			$builder->where('trt.is_login', $filterData['is_login']);
		}

		if(isset($filterData['is_active'])){
			$builder->where('trt.is_active', $filterData['is_active']);
		}
		
		if(isset($filterData['is_guard'])){
			$builder->where('trt.is_guard', $filterData['is_guard']);
		}

		// if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
		// 	if (is_array($filterData['category_id'])) {
		// 		$builder->whereIn('tr.category_id', $filterData['category_id']);
		// 	} else {
		// 		$builder->where('tr.category_id', $filterData['category_id']);
		// 	}
		// }

		if (isset($filterData['is_today_exit_visitor']) && !empty($filterData['is_today_exit_visitor'])) {
			$builder->where('COALESCE(DATE(vtv.end_date),"")', TODAY_DATE_YMD);
		}

		if (isset($filterData['is_today_enter_visitor']) && !empty($filterData['is_today_enter_visitor'])) {
			$builder->where('COALESCE(DATE(vtv.start_date),"")', TODAY_DATE_YMD);
		}

		// if (isset($filterData['category_name']) && !empty($filterData['category_name'])) {
		// 	if (is_array($filterData['category_name'])) {
		// 		$builder->whereIn('tc.category_name', $filterData['category_name']);
		// 	} else {
		// 		$builder->where('tc.category_name', $filterData['category_name']);
		// 	}
		// }
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tr.society_id', $filterData['society_id']);
			} else {
				$builder->where('tr.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('tr.resource_name', $filterData['search'], 'both');
			$builder->orLike("COALESCE(trt.resource_type_name,'')", $filterData['search'], 'both');
			$builder->orLike("COALESCE(tr.resource_mobile_no,'')", $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tr.resource_id",'desc');
		$builder->groupBy('tr.resource_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		//lastQuery();
		return $queryData;
	}

//	public function getResourceFlatData($filterData = array())
//    {
//
//    	// printArray($filterData,1);
//        $builder = $this->db->table('tbl_resource as tr');
//        $builder->select("tofm.name as owner_name,tofm.mobile_no as owner_mobile_no,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name,tr.resource_id,tr.category_id,tr.created_at");
//       	$builder->join("tbl_flat as tf","tf.flat_id = tr.flat_id","left");
//       	$builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tr.ownership_flat_member_id","left");
//       	$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
//        $builder->groupBy('tr.flat_id');
//
//        if(isset($filterData['is_deleted'])){
//			$builder->where('tr.is_deleted', $filterData['is_deleted']);
//		}
//
//        if (isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
//            if (is_array($filterData['resource_id'])) {
//                $builder->whereIn('tr.resource_id', $filterData['resource_id']);
//            } else {
//                $builder->where('tr.resource_id', $filterData['resource_id']);
//            }
//        }
//
//        if (isset($filterData['resource_name']) && !empty($filterData['resource_name'])) {
//            if (is_array($filterData['resource_name'])) {
//                $builder->whereIn('tr.resource_name', $filterData['resource_name']);
//            } else {
//                $builder->where('tr.resource_name', $filterData['resource_name']);
//            }
//        }
//
//        if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
//            if (is_array($filterData['category_id'])) {
//                $builder->whereIn('tr.category_id', $filterData['category_id']);
//            } else {
//                $builder->where('tr.category_id', $filterData['category_id']);
//            }
//        }
//
//        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
//            if (is_array($filterData['society_id'])) {
//                $builder->whereIn('tr.society_id', $filterData['society_id']);
//            } else {
//                $builder->where('tr.society_id', $filterData['society_id']);
//            }
//        }
//
//        if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
//			if (is_array($filterData['category_id'])) {
//				$builder->whereIn('tr.category_id', $filterData['category_id']);
//			} else {
//				$builder->where('tr.category_id', $filterData['category_id']);
//			}
//		}
//
//
//        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
//            $queryData = $builder->get()->getResultArray();
//        } else {
//            $queryData = $builder->get()->getRowArray();
//        }
//
//        return $queryData;
//    }

	public function deleteRecord($resourceId)
	{

        $builder = $this->db->table('tbl_resource_guard');
        $builder->whereIn('resource_id', $resource_idArray);
        $builder->delete();

        $builder = $this->db->table('tbl_resource');
        $builder->whereIn('resource_id', $resource_idArray);
        $builder->delete();

		if ($this->db->affectedRows()) {
			if(!empty($resourceId)){
				foreach($resourceId as $resource){
					$deleteDataArray['module'] = 'Resource';
            		$deleteDataArray['activity'] = "Resource Deleted";
					$deleteDataArray['module_id'] = $resource;
					logActivity('Resource Deleted [ResourceID: ' . $resource . ']',$this->ionAuth->getUserId(),'Resource',$resource,json_encode($deleteDataArray),'','Resource',$resource);
				}
			}
			$response['success'] = true;
			return $response;
		}
		$response['success'] = false;
		return $response;
	}

	public function getResourceWorkingDayData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_resource_working_day as trwd');
		$builder->select("trwd.*,trwd.resource_working_day_id, trwd.working_day_id, trwd.working_day_name,trwd.resource_id,trwd.resource_flat_id");
		$builder->join('tbl_resource tr', 'tr.resource_id = trwd.resource_id', 'left');
		if(isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
            if (is_array($filterData['resource_id'])) {
                $builder->whereIn('trwd.resource_id', $filterData['resource_id']);
            } else {
                $builder->where('trwd.resource_id', $filterData['resource_id']);
            }
        }
		if(isset($filterData['resource_flat_id']) && !empty($filterData['resource_flat_id'])) {
            if (is_array($filterData['resource_flat_id'])) {
                $builder->whereIn('trwd.resource_flat_id', $filterData['resource_flat_id']);
            } else {
                $builder->where('trwd.resource_flat_id', $filterData['resource_flat_id']);
            }
        }
		if (isset($filterData['resource_working_day_id']) && $filterData['resource_working_day_id'] != '') {
			$builder->where("trwd.resource_working_day_id", $filterData['resource_working_day_id']);
		}
		if(isset($filterData['is_deleted'])){
			$builder->where('trwd.is_deleted', 0);
		}
		$builder->orderBy("trwd.resource_id");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function getResourceCountData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$societyId = isset($filterData['society_id']) ? $filterData['society_id'] : 0;
		$builder = $this->db->table('tbl_resource_type as trt');
		$builder->select("trt.*");
		$builder->select("(select count(*) from tbl_resource as tr where tr.resource_type_id = trt.resource_type_id AND tr.is_deleted = 0 AND tr.society_id = '". $societyId ."') as resource_count");

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
           	if (is_array($filterData['society_id'])) {
              	$builder->whereIn('trt.society_id', $filterData['society_id']);
           	} else {
               	$builder->where('trt.society_id', $filterData['society_id']);
           	}
       	}

       	if(isset($filterData['is_helper'])){
			$builder->where('trt.is_helper', $filterData['is_helper']);
		}
		
		$builder->groupBy("trt.resource_type_id");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteResourceRecord($filterData  = array())
    {
        $resourceId = isset($filterData['resource_id']) ? $filterData['resource_id'] : array();
        $userId = isset($filterData['user_society_id']) ? $filterData['user_society_id'] : 0;
        $builder = $this->db->table('tbl_resource');
        $data = [
            'is_deleted' => 1,
            'updated_at'  => date("Y-m-d H:i:s"),
            'updated_by'  => $userId,
        ];

        $builder->where('resource_id', $resourceId);
        $builder->update($data);

        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        }
        $response['success'] = false;
        return $response;
    }


	public function deleteResourceFaltRecord($filterData  = array())
	{
		$resourceId = isset($filterData['resource_id']) ? $filterData['resource_id'] : array();
		$resourceFlatId = isset($filterData['resource_flat_id']) ? $filterData['resource_flat_id'] : array();
		$userId = isset($filterData['user_society_id']) ? $filterData['user_society_id'] : 0;
		$builder = $this->db->table('tbl_resource_flat');
		$data = [
			'is_deleted' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $userId,
		];

		$builder->where('resource_flat_id', $resourceFlatId);
		$builder->where('resource_id', $resourceId);
		$builder->update($data);

		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		}
		$response['success'] = false;
		return $response;
	}
	public function deleteResourceFaltWorkingDayRecord($filterData  = array())
	{
		$resourceId = isset($filterData['resource_id']) ? $filterData['resource_id'] : array();
		$resourceFlatId = isset($filterData['resource_flat_id']) ? $filterData['resource_flat_id'] : array();
		$userId = isset($filterData['user_society_id']) ? $filterData['user_society_id'] : 0;
		$builder = $this->db->table('tbl_resource_working_day');
		$data = [
			'is_deleted' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $userId,
		];

		$builder->where('resource_flat_id', $resourceFlatId);
		$builder->where('resource_id', $resourceId);
		$builder->update($data);
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		}
		$response['success'] = false;
		return $response;
	}

	public function deleteRecordResourceFlat($resourceFlatId,$resourceId,$userId = 0,$societyId = 0)
	{
		$resourceFlatIdArray = is_array($resourceFlatId) ? $resourceFlatId : array($resourceFlatId);
		$builder = $this->db->table('tbl_resource_flat');
		$builder->whereIn('resource_flat_id', $resourceFlatIdArray);
		$builder->where('resource_id', $resourceId);
		$builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($resourceFlatId)){
				$deleteDataArray['module'] = 'Resource Member Flat';
				$deleteDataArray['activity'] = "Resource Member Flat Deleted";
				$deleteDataArray['module_id'] = $resourceFlatId;
				$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
				logActivity('Resource Member Flat Deleted [ResourceFlatID: ' . $resourceFlatId . ']',$userId,'Resource Member Flat',$resourceId,json_encode($deleteDataArray),'','Resource',$resourceId,$societyId);
			}
			return true;
		}
		return false;
	}

	public function deleteRecordWorkingDay($resourceFlatId,$resourceId,$userId = 0,$societyId = 0)
	{
		$resourceFlatIdArray = is_array($resourceFlatId) ? $resourceFlatId : array($resourceFlatId);
		$builder = $this->db->table('tbl_resource_working_day');
        $builder->whereIn('resource_flat_id', $resourceFlatIdArray);
        $builder->where('resource_id', $resourceId);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($resourceFlatId)){
				$deleteDataArray['module'] = 'Resource Working Day';
				$deleteDataArray['activity'] = "Resource Working Day Deleted";
				$deleteDataArray['module_id'] = $resourceFlatId;
				$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
				logActivity('Resource Working Day Deleted [ResourceWorkingDayID: ' . $resourceFlatId . ']',$userId,'Resource Working Day',$resourceId,json_encode($deleteDataArray),'','Resource',$resourceId,$societyId);
			}
			return true;
		}
		return false;
	}

	public function getResourceFlatData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_resource_flat as trf');
		$builder->select("tr.*,trf.*");
		$builder->select("COALESCE(tm.name,'') as name,COALESCE(tus.phone,'') as mobile_no,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name,tofm.type");
		$builder->join('tbl_resource tr', 'tr.resource_id = trf.resource_id', 'left');
		$builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = trf.ownership_flat_member_id","left");
		$builder->join("tbl_flat as tf","tf.flat_id = trf.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = trf.tower_id","left");
		$builder->join("tbl_resource_type as trt","trt.resource_type_id = tr.resource_type_id","left");
		$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.ownership_flat_id","left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
		// $builder->join("tbl_category as tc","tc.category_id = tr.category_id","left");


		if(isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
			if (is_array($filterData['resource_id'])) {
				$builder->whereIn('trf.resource_id', $filterData['resource_id']);
			} else {
				$builder->where('trf.resource_id', $filterData['resource_id']);
			}
		}

		if(isset($filterData['resource_name']) && !empty($filterData['resource_name'])) {
			if (is_array($filterData['resource_name'])) {
				$builder->whereIn('tr.resource_name', $filterData['resource_name']);
			} else {
				$builder->where('tr.resource_name', $filterData['resource_name']);
			}
		}

		if(isset($filterData['resource_mobile_no']) && !empty($filterData['resource_mobile_no'])) {
			if (is_array($filterData['resource_mobile_no'])) {
				$builder->whereIn('tr.resource_mobile_no', $filterData['resource_mobile_no']);
			} else {
				$builder->where('tr.resource_mobile_no', $filterData['resource_mobile_no']);
			}
		}

		if(isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
			if (is_array($filterData['resource_type_id'])) {
				$builder->whereIn('tr.resource_type_id', $filterData['resource_type_id']);
			} else {
				$builder->where('tr.resource_type_id', $filterData['resource_type_id']);
			}
		}

		// if(isset($filterData['category_id']) && !empty($filterData['category_id'])) {
		// 	if (is_array($filterData['category_id'])) {
		// 		$builder->whereIn('tr.category_id', $filterData['category_id']);
		// 	} else {
		// 		$builder->where('tr.category_id', $filterData['category_id']);
		// 	}
		// }

		if(isset($filterData['resource_flat_id']) && !empty($filterData['resource_flat_id'])) {
			if (is_array($filterData['resource_flat_id'])) {
				$builder->whereIn('trf.resource_flat_id', $filterData['resource_flat_id']);
			} else {
				$builder->where('trf.resource_flat_id', $filterData['resource_flat_id']);
			}
		}

		if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
			if (is_array($filterData['ownership_flat_member_id'])) {
				$builder->whereIn('trf.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			} else {
				$builder->where('trf.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			}
		}

		if(isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereIn('trf.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('trf.ownership_flat_id', $filterData['ownership_flat_id']);
			}
		}

		if(isset($filterData['is_deleted'])){
			$builder->where('trf.is_deleted', 0);
		}

		if(isset($filterData['is_helper'])){
			$builder->where('trt.is_helper', $filterData['is_helper']);
		}

		$builder->orderBy("trf.resource_flat_id");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}


	public function getFlatToGetOwnerFlatData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_ownership_flat as tof');
		$builder->select("tofm.ownership_flat_member_id, tof.ownership_flat_id,tf.tower_id");
		$builder->join('tbl_ownership_flat_member as tofm', 'tofm.ownership_flat_id = tof.ownership_flat_id AND tofm.is_owner = 1', 'left');
		$builder->join('tbl_flat as tf', 'tf.flat_id = tof.flat_id', 'left');

		if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		}
		$builder->where('tof.is_latest', 1);
		$builder->orderBy("tof.ownership_flat_id");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}


	public function deleteResourceFlatWorkingDay($resourceId)
	{
		$resourceIdArray = is_array($resourceId) ? $resourceId : array($resourceId);
		$builder = $this->db->table('tbl_resource_working_day');
		$builder->whereIn('resource_id', $resourceIdArray);
		$builder->where('is_deleted', 0);
		$builder->delete();
		if ($this->db->affectedRows()) {
			return true;
		}
		return false;
	}


	public function deleteAdminPanelFlatRecord($resourceFlatId,$userId)
	{
		$builder = $this->db->table('tbl_resource_flat');
		$resourceFlatIdArray = is_array($resourceFlatId) ? $resourceFlatId : array($resourceFlatId);		
		$data = [
			'is_deleted' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $userId,
		];
		$builder->whereIn('resource_flat_id',$resourceFlatIdArray);
		$builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	public function deleteAdminPanelFlatWeekDayRecord($resourceFlatId,$userId)
	{
		$builder = $this->db->table('tbl_resource_working_day');
		$resourceFlatIdArray = is_array($resourceFlatId) ? $resourceFlatId : array($resourceFlatId);
		$data = [
			'is_deleted' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $userId,
		];
		$builder->whereIn('resource_flat_id',$resourceFlatIdArray);
		$builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	public function getResourceImageData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_resource_image as tri');
        $builder->select("tri.resource_image_id, tri.resource_image,tri.resource_id");
        $builder->join('tbl_resource tr', 'tr.resource_id = tri.resource_id', 'left');

        if(isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
            if (is_array($filterData['resource_id'])) {
                $builder->whereIn('tri.resource_id', $filterData['resource_id']);
            } else {
                $builder->where('tri.resource_id', $filterData['resource_id']);
            }
        }

        if (isset($filterData['resource_image_id']) && $filterData['resource_image_id'] != '') {
            $builder->where("tri.resource_image_id", $filterData['resource_image_id']);
        }

        if (isset($filterData['is_order_by_resource_id']) ) {
            $builder->orderBy("tri.resource_image_id","DESC");
        } else {
            $builder->orderBy("tri.resource_id");
        }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteResourceImage($resourceImageId)
    {
        $builder = $this->db->table('tbl_resource_image');
        $resourceImageIdArray = is_array($resourceImageId) ? $resourceImageId : array($resourceImageId);
        $builder->whereIn('resource_image_id', $resourceImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getResourceGuardData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_resource_guard as trg');
        $builder->select("trg.resource_guard_id,trg.gate_id,trg.resource_id");
        $builder->select("tg.gate_name");
        $builder->join('tbl_resource tr', 'tr.resource_id = trg.resource_id', 'left');
        $builder->join('tbl_gate tg', 'tg.gate_id = trg.gate_id', 'left');

        if(isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
            if (is_array($filterData['resource_id'])) {
                $builder->whereIn('trg.resource_id', $filterData['resource_id']);
            } else {
                $builder->where('trg.resource_id', $filterData['resource_id']);
            }
        }
        $builder->orderBy("trg.resource_id");
        $builder->groupBy("trg.resource_guard_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteGuardRecord($resourceId){
        $builder = $this->db->table('tbl_resource_guard');
        $resourceIdArray = is_array($resourceId) ? $resourceId : array($resourceId);
        $builder->whereIn('resource_id', $resourceIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getResource($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_resource as tr');
        //$builder->startCache();
        $builder->select("tr.resource_id as id,COALESCE(tr.resource_name,'')  as text");
        $builder->where('tr.is_deleted',0);
        if(isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
            if (is_array($filterData['resource_id'])) {
                $builder->whereIn('tr.resource_id', $filterData['resource_id']);
            } else {
                $builder->where('tr.resource_id', $filterData['resource_id']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tr.society_id', $filterData['society_id']);
            } else {
                $builder->where('tr.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
            if (is_array($filterData['resource_type_id'])) {
                $builder->whereIn('tr.resource_type_id', $filterData['resource_type_id']);
            } else {
                $builder->where('tr.resource_type_id', $filterData['resource_type_id']);
            }
        }

        if(isset($filterData['filter_resource_type_id']) && !empty($filterData['filter_resource_type_id'])) {
            if (is_array($filterData['filter_resource_type_id'])) {
                $builder->whereIn('tr.resource_type_id', $filterData['filter_resource_type_id']);
            } else {
                $builder->where('tr.resource_type_id', $filterData['filter_resource_type_id']);
            }
        }
        
        // if(isset($filterData['category_id']) && !empty($filterData['category_id'])) {
        //     if (is_array($filterData['category_id'])) {
        //         $builder->whereIn('tr.category_id', $filterData['category_id']);
        //     } else {
        //         $builder->where('tr.category_id', $filterData['category_id']);
        //     }
        // }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tr.resource_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        // if(isset($filterData['is_active'])){
        //     $builder->where('tr.is_active', $filterData['is_active']);
        // }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}
?>
