<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class RentalsModel extends BaseModel
{

	public function getRentalsData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_rentals as tr');
		$builder->select("tr.*");
		$builder->select("concat(tr.prefix,tr.series) as document_number");
		$builder->select("COALESCE(ts.society_name,'') as society_name");
		$builder->select("COALESCE(tm.name,'') as owner_member_name");
		$builder->select("COALESCE(tt.tower_name,'') as tower_name");
		$builder->select("COALESCE(tb.broker_name,'') as broker_name");
		$builder->select("COALESCE(tf.flat_no,'') as flat_nos,tf.bhk,tf.sqr_ft");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
		$builder->select("COALESCE(tstatus.status_name,'') as status_name,tstatus.is_open,tstatus.is_close");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
		$builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->select("COALESCE(ti.number,'') as intercom_no");
		$builder->select("GROUP_CONCAT(distinct(COALESCE(trfm.owner_name,'')) SEPARATOR ', ') as owner_member_name");
		$builder->select("GROUP_CONCAT(distinct(COALESCE(trfm.mobile_no,'')) SEPARATOR ', ') as owner_contact_no");
		$builder->select("(SELECT count(*) FROM tbl_ownership_flat_member as ctofm WHERE ctofm.type_id = tr.rentals_id AND ctofm.is_delete = 0 AND ctofm.type = 'rentals') as total_member,tstatus.is_close");

		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tr.society_id","left");
		$builder->join("tbl_flat as tf","tf.flat_id = tr.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tr.owner_member_id AND tofm.is_delete = 0","left");
		$builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id AND tofm.is_delete = 0","left");
		$builder->join(MASTER_DB.".tbl_broker as tb","tb.broker_id = tr.broker_id","left");

		$builder->join("tbl_status as tstatus","tstatus.status_id = tr.status_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tr.updated_by AND tupdate.society_id = tr.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tr.created_by AND tcreate.society_id = tr.society_id","left");
		$builder->join("tbl_rentals_flat_owner as trfm","trfm.rentals_id = tr.rentals_id","left");
		$builder->join("tbl_intercom as ti","ti.flat_id = tr.flat_id","left");

		if(isset($filterData['check_flat_rent']) && $filterData['check_flat_rent'] == 1) {
		    $builder->groupStart();
		    $builder->where("tr.rent_agreement_period_from <=", TODAY_DATE_YMD);
		    $builder->where("(tr.rental_closing_date IS NULL AND tr.rent_agreement_period_to >= '" . TODAY_DATE_YMD . "') 
		                      OR (tr.rental_closing_date IS NOT NULL AND tr.rental_closing_date >= '" . TODAY_DATE_YMD . "')", null, false);
		    $builder->where("tr.status_id NOT IN (SELECT status_id FROM tbl_status WHERE is_close = 1 AND status_for = 'rentals')", null, false);
		    $builder->groupEnd();
		}

		if (isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('tr.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('tr.rentals_id', $filterData['rentals_id']);
			}
		}


		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tr.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tr.flat_id', $filterData['flat_id']);
			}
		}

		if (isset($filterData['rentals_id_not']) && !empty($filterData['rentals_id_not'])) {
			if (is_array($filterData['rentals_id_not'])) {
				$builder->whereNotIn('tr.rentals_id', $filterData['rentals_id_not']);
			} else {
				$builder->where('tr.rentals_id !', $filterData['rentals_id_not']);
			}
		}

		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			//$this->db->like('member_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tr.is_active', $filterData['is_active']);
		}
		$builder->where('tr.is_delete', 0);
		if(!isset($filterData['is_api_call'])){
			accessFilter($builder, array("society" => "tr.society_id"));
		}

		$builder->groupBy('tr.rentals_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($rentalsId)
	{

		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
		$rentalsIdArray = is_array($rentalsId) ? $rentalsId : array($rentalsId);

		$builderModuleImage = $this->db->table('tbl_module_document_image');
		$builderModuleImage->whereIn('module_id', $rentalsIdArray);
		$builderModuleImage->where('module', 'rentals');
		$builderModuleImage->delete();


		$builderModule = $this->db->table('tbl_module_document');
		$builderModule->whereIn('module_id', $rentalsIdArray);
		$builderModule->where('module', 'rentals');
		$builderModule->delete();

		$builderModuleEmergencyContact = $this->db->table('tbl_ownership_flat_emergency_contact');
		$builderModuleEmergencyContact->whereIn('type_id', $rentalsIdArray);
		$builderModuleEmergencyContact->where('type', 'rentals');
        $builderModuleEmergencyContact->update($data);
		// $builderModuleEmergencyContact->delete();

		$builderModuleMember = $this->db->table('tbl_ownership_flat_member');
		$builderModuleMember->whereIn('type_id', $rentalsIdArray);
		$builderModuleMember->where('type', 'rentals');
		$builderModuleMember->update($data);
		// $builderModuleMember->delete();

		$builderModuleParking = $this->db->table('tbl_ownership_flat_parking');
		$builderModuleParking->whereIn('type_id', $rentalsIdArray);
		$builderModuleParking->where('type', 'rentals');
		$builderModuleParking->update($data);
		// $builderModuleParking->delete();

		$builder = $this->db->table('tbl_rentals');
		$builder->whereIn('rentals_id', $rentalsIdArray);
		$builder->update($data);
		// $builder->delete();

		if ($this->db->affectedRows()) {

			if(!empty($rentalsId)){
				foreach($rentalsId as $documentElement){
					$deleteDataArray['module'] = 'Rentals';
					$deleteDataArray['activity'] = "Rentals Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Rentals Deleted [RentalsID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Rentals',$documentElement,json_encode($deleteDataArray),'','Rentals',$documentElement);
				}
			}
			return true;
		}
		return false;
	}

	public function getRentalsFlatOwnerData($filterData)
	{
		$builder = $this->db->table('tbl_rentals_flat_owner as trfo');
		$builder->select("trfo.*,COALESCE(trfo.owner_id,'') as  ownership_flat_member_id,COALESCE(trfo.owner_name,'') as name");

		if(isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('trfo.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('trfo.rentals_id', $filterData['rentals_id']);
			}
		}

		$builder->where('trfo.is_delete', 0);
		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function getRentalsMemberData($filterData)
	{
		if(isset($filterData['is_db_connect']) && $filterData['is_db_connect'] == 1){
			$this->setTenantDBFromFilter($filterData['society_id']);
		} 
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.*,tr.flat_id,ts.society_name,tr.society_id,tm.*");
		$builder->select("COALESCE(tt.tower_name,'') as tower_name");
		$builder->select("tm.member_id,tm.is_otp_verified");
		$builder->select("tus.phone as mobile_no");
		$builder->select("tus.user_society_id,tus.user_id");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
		$builder->join("tbl_rentals as tr","tr.rentals_id = tofm.type_id AND tofm.type='rentals'","left");
		$builder->join("tbl_flat as tf","tf.flat_id = tr.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tf.society_id","left");
		$builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");
		// $builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.type_id AND tofm.type = 'rentals'","left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tr.society_id","left");
		$builder->where('tofm.is_delete', 0);

		if(isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('tr.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('tr.rentals_id', $filterData['rentals_id']);
			}
		}

		if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
			if (is_array($filterData['ownership_flat_member_id'])) {
				$builder->whereIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			} else {
				$builder->where('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			}
		}

		if(isset($filterData['is_active']) && !empty($filterData['is_active'])) {
			$builder->where('tofm.is_active', $filterData['is_active']);
		}

		if(isset($filterData['member_id']) && !empty($filterData['member_id'])) {
			if (is_array($filterData['member_id'])) {
				$builder->whereIn('tm.member_id', $filterData['member_id']);
			} else {
				$builder->where('tm.member_id', $filterData['member_id']);
			}
		}

		if(isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
			if (is_array($filterData['tower_id'])) {
				$builder->whereIn('tt.tower_id', $filterData['tower_id']);
			} else {
				$builder->where('tt.tower_id', $filterData['tower_id']);
			}
		}


		if(isset($filterData['ownership_flat_member_id_not']) && !empty($filterData['ownership_flat_member_id_not'])) {
			if (is_array($filterData['ownership_flat_member_id_not'])) {
				$builder->whereNotIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id_not']);
			} else {
				$builder->where('tofm.ownership_flat_member_id !=', $filterData['ownership_flat_member_id_not']);
			}
		}

		if (isset($filterData['ownership_flat_member_id_not']) && !empty($filterData['ownership_flat_member_id_not'])) {
			if (is_array($filterData['ownership_flat_member_id_not'])) {
				$builder->whereNotIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id_not']);
			} else {
				$builder->where('tofm.ownership_flat_member_id !=', $filterData['ownership_flat_member_id_not']);
			}
		}

		if(isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tofm.type', $filterData['type']);
			} else {
				$builder->where('tofm.type', $filterData['type']);
			}
		}
		if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tofm.type_id', $filterData['type_id']);
			} else {
				$builder->where('tofm.type_id', $filterData['type_id']);
			}
		}

		if(isset($filterData['member_id_not']) && !empty($filterData['member_id_not'])) {
            if (is_array($filterData['member_id_not'])) {
                $builder->whereNotIn('tofm.member_id', $filterData['member_id_not']);
            } else {
                $builder->where('tofm.member_id !=', $filterData['member_id_not']);
            }
        }

        if(isset($filterData['mobile_no']) && !empty($filterData['mobile_no'])) {
			if (is_array($filterData['mobile_no'])) {
				$builder->whereIn('tus.phone', $filterData['mobile_no']);
			} else {
				$builder->where('tus.phone', $filterData['mobile_no']);
			}
		}

		if(isset($filterData['check_rental_start'])){
			//$builder->Where('tr.rent_agreement_period_from  >= "'.TODAY_DATE_YMD.'" AND IF(tr.rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) <= "'.TODAY_DATE_YMD.'"  ) OR (tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr where status_id != (SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1 AND tstatus.status_for="rentals") AND rent_agreement_period_from  <= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) >= "'.TODAY_DATE_YMD.'" )))',null,false);
			$builder->Where('((tr.rent_agreement_period_from  >= "'.TODAY_DATE_YMD.'" AND IF(tr.rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) <= "'.TODAY_DATE_YMD.'")  OR (tr.status_id NOT IN(SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1 AND tstatus.status_for="rentals") AND rent_agreement_period_from  <= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) >= "'.TODAY_DATE_YMD.'" ))',null,false);
		}

		if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tr.society_id', $filterData['society_id']);
			} else {
				$builder->where('tr.society_id', $filterData['society_id']);
			}
		}

		if(isset($filterData['mobile_no']) && !empty($filterData['mobile_no'])) {
			if (is_array($filterData['mobile_no'])) {
				$builder->whereIn('tus.phone', $filterData['mobile_no']);
			} else {
				$builder->where('tus.phone', $filterData['mobile_no']);
			}
		}


		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteRentalsMemberRecord($ownershipFlatMemberId)
	{
		$builder = $this->db->table('tbl_ownership_flat_member');
		$ownershipFlatMemberIdArray = is_array($ownershipFlatMemberId) ? $ownershipFlatMemberId : array($ownershipFlatMemberId);
		$builder->whereIn('ownership_flat_member_id',$ownershipFlatMemberIdArray);
		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
        $builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	public function getRentalsEmergencyData($filterData)
	{
		$builder = $this->db->table('tbl_ownership_flat_emergency_contact as tofec');
		$builder->select("tofec.*");

		if(isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('tofec.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('tofec.rentals_id', $filterData['rentals_id']);
			}
		}

		if(isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tofec.type', $filterData['type']);
			} else {
				$builder->where('tofec.type', $filterData['type']);
			}
		}
		if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tofec.type_id', $filterData['type_id']);
			} else {
				$builder->where('tofec.type_id', $filterData['type_id']);
			}
		}

		if(isset($filterData['rentals_emergency_contact_id']) && !empty($filterData['rentals_emergency_contact_id'])) {
			if (is_array($filterData['rentals_emergency_contact_id'])) {
				$builder->whereIn('tofec.rentals_emergency_contact_id', $filterData['rentals_emergency_contact_id']);
			} else {
				$builder->where('tofec.rentals_emergency_contact_id', $filterData['rentals_emergency_contact_id']);
			}
		}
		$builder->where('tofec.is_delete', 0);

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}


	public function deleteRentalsContactRecord($ownershipFlatEmergencyContactId)
	{
		$builder = $this->db->table('tbl_ownership_flat_emergency_contact');
		$ownershipFlatEmergencyContactIdArray = is_array($ownershipFlatEmergencyContactId) ? $ownershipFlatEmergencyContactId : array($ownershipFlatEmergencyContactId);
		$builder->whereIn('ownership_flat_emergency_contact_id',$ownershipFlatEmergencyContactIdArray);
		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
        $builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	public function getRentalsParkingData($filterData)
	{
		$builder = $this->db->table('tbl_ownership_flat_parking as tofp');
		$builder->select("tofp.*");
		$builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as parking_area");
		$builder->join("tbl_parking_slot as tpp","tpp.parking_slot_id = tofp.parking_slot_id","left");
		$builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");
		$builder->where('tofp.is_delete', 0);

		if(isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('tofp.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('tofp.rentals_id', $filterData['rentals_id']);
			}
		}

		if(isset($filterData['rentals_parking_id']) && !empty($filterData['rentals_parking_id'])) {
			if (is_array($filterData['rentals_parking_id'])) {
				$builder->whereIn('tofp.rentals_parking_id', $filterData['rentals_parking_id']);
			} else {
				$builder->where('tofp.rentals_parking_id', $filterData['rentals_parking_id']);
			}
		}
		if(isset($filterData['ownership_flat_parking_id']) && !empty($filterData['ownership_flat_parking_id'])) {
			if (is_array($filterData['ownership_flat_parking_id'])) {
				$builder->whereIn('tofp.ownership_flat_parking_id', $filterData['ownership_flat_parking_id']);
			} else {
				$builder->where('tofp.ownership_flat_parking_id', $filterData['ownership_flat_parking_id']);
			}
		}

		if(isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tofp.type', $filterData['type']);
			} else {
				$builder->where('tofp.type', $filterData['type']);
			}
		}
		if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tofp.type_id', $filterData['type_id']);
			} else {
				$builder->where('tofp.type_id', $filterData['type_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteRentalsParkingRecord($ownershipFlatParkingId)
	{
		$builder = $this->db->table('tbl_ownership_flat_parking');
		$ownershipFlatParkingIdArray = is_array($ownershipFlatParkingId) ? $ownershipFlatParkingId : array($ownershipFlatParkingId);
		$builder->whereIn('ownership_flat_parking_id',$ownershipFlatParkingIdArray);
		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
        $builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}



	function getRentals($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		//$this->db->start_cache();
		$builder = $this->db->table(MASTER_DB.'.tbl_member as tm');
		$builder->select("tm.member_id as id,COALESCE(tm.member_name,'') as text");
		$builder->where("tm.is_active", 1);
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("COALESCE(tm.member_name,'')", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}
		//$this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();
		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		//$this->db->flush_cache();
		return json_encode($result);
	}


	function getRentalsMember($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		//$this->db->start_cache();
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.ownership_flat_member_id as id,tm.name as text");
		$builder->join("tbl_rentals as tr","tr.rentals_id = tofm.type_id AND tof.type='rentals'","left");
		$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		$builder->where('tofm.is_delete', 0);
		//$builder->where("tofm.is_owner", 1);
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tm.name", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}

		if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tr.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tr.flat_id', $filterData['flat_id']);
			}
		}
		//$this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();
		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		//$this->db->flush_cache();
		return json_encode($result);
	}


	public function getFlatRentalDate($filterData = array())
	{
		$builder = $this->db->table('tbl_rentals as tr');
		$builder->select("tr.*");
		$builder->select("concat(tr.prefix,tr.series) as document_number");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
		$builder->where('tr.is_delete',0);

		$builder->join("tbl_flat as tf","tf.flat_id = tr.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		if ((isset($filterData['rent_agreement_period_from']) && $filterData['rent_agreement_period_from'] != '') && (isset($filterData['rent_agreement_period_to']) && $filterData['rent_agreement_period_to'] != '')
		) {
			$builder->where("tr.rent_agreement_period_from <= '" . DMYToYMD($filterData['rent_agreement_period_to']) . "' AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) >= '" . DMYToYMD($filterData['rent_agreement_period_from']) . "'", NULL, FALSE);
		}

		if (isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereNotIn('tr.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('tr.rentals_id !=', $filterData['rentals_id']);
			}
		}


		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereNotIn('tr.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tr.flat_id', $filterData['flat_id']);
			}
		}


		accessFilter($builder, array("society" => "tr.society_id"));
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		//lastQuery();
		return $queryData;
	}


	// public function getNextSeries($type, $prefix = '', $societyId = '')
	// {
	// 	// $query = $this->db->query("select getNextSeries('" . $type . "','" . $prefix . "','" . $societyId . "') as nextSeries");
	// 	$query = $this->centralDB->query("select getNextSeriesNumber('" . $type . "','" . $prefix . "','" . $societyId . "') as nextSeries");
	// 	$return = $query->getRowArray();
	// 	return isset($return['nextSeries']) ? $return['nextSeries'] : 1;
	// }

	public function getNextSeries($type, $prefix = '', $societyDb = '')
	{
		// Ensure centralDB is connected to the master (central) DB
		$this->centralDB->query("CALL getNextSeriesNumber(?, ?, ?, @nextSeries)", [$type, $prefix, $societyDb]);

		// Fetch the OUT parameter
		$query = $this->centralDB->query("SELECT @nextSeries as nextSeries");
		$result = $query->getRowArray();

		return isset($result['nextSeries']) ? $result['nextSeries'] : 1;
	}


	public function getRentalCloseDateData($filterData)
	{
		$builder = $this->db->table('tbl_rentals as tr');
		$builder->select("tr.*");


		if(isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('tr.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('tr.rentals_id', $filterData['rentals_id']);
			}
		}

		if(isset($filterData['rent_agreement_period_to']) && !empty($filterData['rent_agreement_period_to'])) {
			if (is_array($filterData['rent_agreement_period_to'])) {
				$builder->whereIn('tr.rent_agreement_period_to <=', $filterData['rent_agreement_period_to']);
			} else {
				$builder->where('tr.rent_agreement_period_to <=', $filterData['rent_agreement_period_to']);
			}
		}

		$builder->where('tr.rental_closing_date is NULL', NULL, FALSE);
		$builder->where('tr.is_active',1);
		$builder->groupBy('tr.rentals_id');
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}


	public function getFlatOwnerData($filterData)
	{
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.*,tm.*,tus.phone as mobile_no");
		$builder->join("tbl_ownership_flat as tof", "tof.ownership_flat_id = tofm.type_id AND tofm.type='ownership_flat'", "left");
		$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id AND tofm.type='ownership_flat'", "left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
		$builder->where('tofm.is_delete', 0);
		if (isset($filterData['is_owner']) && !empty($filterData['is_owner'])) {
			$builder->where("tofm.is_owner", 1);
		}

		if (isset($filterData['is_latest']) && !empty($filterData['is_latest'])) {
			$builder->where("tof.is_latest", 1);
		}

		accessFilter($builder, array("society" => "tof.society_id"));
		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		}

		// if(isset($filterData['is_active']) && !empty($filterData['is_active'])) {
		// 	$builder->where('tofm.is_active', $filterData['is_active']);
		// }


		if ((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)) {
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}


	public function deleteRentalsFlatOwnerRecord($rentalsId)
	{
		$builder = $this->db->table('tbl_rentals_flat_owner');
		$rentalsIdArray = is_array($rentalsId) ? $rentalsId : array($rentalsId);
		$builder->whereIn('rentals_id',$rentalsIdArray);
		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
        $builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	function getAllRentalsMember($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		//$this->db->start_cache();
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.ownership_flat_member_id as id,tm.name as text,tus.phone");
		$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.type_id AND tofm.type='rentals'","left");
		$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
		$builder->where('tofm.is_delete', 0);

		accessFilter($builder, array("society" => "tof.society_id"));
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tm.name", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}

		if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		}

		$builder->groupStart();

		$builder->where('EXISTS (
		    SELECT 1
		    FROM tbl_rentals as tr
		    WHERE tr.rent_agreement_period_from <= "'.TODAY_DATE_YMD.'"
		    AND IF(tr.rental_closing_date IS NULL, tr.rent_agreement_period_to, tr.rental_closing_date) >= "'.TODAY_DATE_YMD.'"
		    AND tr.status_id IN (
		        SELECT tstatus.status_id
		        FROM tbl_status as tstatus
		        WHERE tstatus.is_close = 0
		        AND tstatus.status_for = "rentals"
		    )
		)');


		$builder->groupEnd();
		 $builder->groupBy("tofm.ownership_flat_member_id");
		//$this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();

		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		//$this->db->flush_cache();
//		$query = $this->db->getLastQuery();
//		echo (string)$query;
		return json_encode($result);
	}

	public function checkAssignedParking($filterData = array())
	{
		$builder = $this->db->table('tbl_ownership_flat_parking as tofp');
		$builder->select("tofp.*");
		$builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as parking_area");
		$builder->join("tbl_parking_slot as tpp","tpp.parking_slot_id = tofp.parking_slot_id","left");
		$builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");
		// $builder->join("tbl_rentals as tr","tr.rentals_id = tofp.type_id AND tofp.type='rentals'","left");
		// $builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tpp.ownership_flat_id","left");
		$builder->where('tofp.is_delete', 0);

		if(isset($filterData['parking_slot_id']) && !empty($filterData['parking_slot_id'])) {
			if (is_array($filterData['parking_slot_id'])) {
				$builder->whereIn('tofp.parking_slot_id', $filterData['parking_slot_id']);
			} else {
				$builder->where('tofp.parking_slot_id', $filterData['parking_slot_id']);
			}
		}

		// // Check active rental period
		// if (isset($filterData['check_rental_start'])) {
		// 	$builder->where('(
		// 		(tr.rent_agreement_period_from <= "'.TODAY_DATE_YMD.'" 
		// 		AND (tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to >= "'.TODAY_DATE_YMD.'"))
		// 	)', null, false);

		// 	$builder->where('(tr.status_id IS NULL OR tr.status_id NOT IN (
		// 		SELECT tstatus.status_id 
		// 		FROM tbl_status as tstatus 
		// 		WHERE tstatus.is_close = 1 
		// 		AND tstatus.status_for="rentals"
		// 	))', null, false);
		// }

		// // Check for rentals type
		// if (isset($filterData['check_rental_start'])) {
		// 	$builder->groupStart();  // Group the next conditions
		// 	$builder->where('tofp.type', 'rentals');  // Only apply this logic for rentals
	
		// 	// Check active rental period for rentals type
		// 	$builder->where('(
		// 		(tr.rent_agreement_period_from <= "'.TODAY_DATE_YMD.'" 
		// 		AND (tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to >= "'.TODAY_DATE_YMD.'"))
		// 	)', null, false);
	
		// 	// Exclude records with closed rental status
		// 	$builder->where('(tr.status_id IS NULL OR tr.status_id NOT IN (
		// 		SELECT tstatus.status_id 
		// 		FROM tbl_status as tstatus 
		// 		WHERE tstatus.is_close = 1 
		// 		AND tstatus.status_for="rentals"
		// 	))', null, false);
		// 	$builder->groupEnd();  // Close the grouped conditions
		// }

		if(isset($filterData['ownership_flat_parking_not_id']) && !empty($filterData['ownership_flat_parking_not_id'])) {
			if (is_array($filterData['ownership_flat_parking_not_id'])) {
				$builder->whereNotIn('tofp.ownership_flat_parking_id', $filterData['ownership_flat_parking_not_id']);
			} else {
				$builder->where('tofp.ownership_flat_parking_id !=', $filterData['ownership_flat_parking_not_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function getAggrementNotClosed($filterData = array())
	{
		$builder = $this->db->table('tbl_rentals as tr');
		$builder->select("tr.*");
		
		$builder->where('tr.is_delete', 0);

		$builder->groupStart()
    			->where('(tr.rental_closing_date IS NULL AND tr.rent_agreement_period_to < "'.TODAY_DATE_YMD.'")', null, false)
    			->Where('(tr.status_id IS NULL OR tr.status_id IN (
		        SELECT tstatus.status_id 
		        FROM tbl_status as tstatus 
		        WHERE tstatus.is_close != 1 
		        AND tstatus.status_for="rentals"
		    ))', null, false)
		->groupEnd();

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();
			$builder->groupEnd();
		}
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}
}
?>
