<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ParkingPlaceModel extends BaseModel
{
	public function getParkingPlaceData($filterData = array())
    {
        // printArray($filterData,1);
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_parking_place as tpp');
        $builder->select("tpp.*,ta.parking_area_name,ta.vehicle_type ");
        $builder->select("COALESCE(tpp.number,'') as display_block");
        $builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as parking_block_display");
        $builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");

        if(isset($filterData['parking_place_id']) && !empty($filterData['parking_place_id'])) {
            if (is_array($filterData['parking_place_id'])) {
                $builder->whereIn('tpp.parking_place_id', $filterData['parking_place_id']);
            } else {
                $builder->where('tpp.parking_place_id', $filterData['parking_place_id']);
            }
        }

        if(isset($filterData['is_visitor_parking']) && $filterData['is_visitor_parking'] == 1) {
            $builder->where('tpp.is_visitor_parking', 1);
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tpp.society_id', $filterData['society_id']);
            } else {
                $builder->where('tpp.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tpp.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tpp.flat_id', $filterData['flat_id']);
            }
        }

        if(isset($filterData['assigned_flat_id'])) {
            if (is_array($filterData['assigned_flat_id'])) {
                $builder->whereIn('tpp.flat_id', $filterData['assigned_flat_id']);
            } else {
                $builder->where('tpp.flat_id', $filterData['assigned_flat_id']);
            }
        }

        if(isset($filterData['vehicle_type']) && !empty($filterData['vehicle_type'])) {
            if (is_array($filterData['vehicle_type'])) {
                $builder->whereIn('ta.vehicle_type', $filterData['vehicle_type']);
            } else {
                $builder->where('ta.vehicle_type', $filterData['vehicle_type']);
            }
        }


        if(isset($filterData['parking_area_id']) && !empty($filterData['parking_area_id'])) {
            if (is_array($filterData['parking_area_id'])) {
                $builder->whereIn('tpp.parking_area_id', $filterData['parking_area_id']);
            } else {
                $builder->where('tpp.parking_area_id', $filterData['parking_area_id']);
            }
        }
    
        if(isset($filterData['number']) && !empty($filterData['number'])) {
            if (is_array($filterData['number'])) {
                $builder->whereIn('tpp.number', $filterData['number']);
            } else {
                $builder->where('tpp.number', $filterData['number']);
            }
        }
        if (isset($filterData['is_available_flat'])) {
           // $builder->where('tpp.flat_id', 0);
            $builder->where('tpp.parking_place_id NOT IN(SELECT tv.parking_place_id FROM tbl_visitor as tv where (tv.status ="entered") AND (tv.is_deleted = 0))',null,false);
        }

        if (isset($filterData['is_available_visitor_approval_pending'])) {
           // $builder->where('tpp.flat_id', 0);
            $builder->where('tpp.parking_place_id NOT IN(SELECT tv.parking_place_id FROM tbl_visitor as tv where (tv.status ="entry_pre_approve" OR tv.status ="approval_pending" OR tv.status = "waiting_for_approval") AND (tv.is_deleted = 0))',null,false);
        }

        if(isset($filterData['parking_place_id_not']) && !empty($filterData['parking_place_id_not'])) {
            if (is_array($filterData['parking_place_id_not'])) {
                $builder->whereNotIn('tpp.parking_place_id', $filterData['parking_place_id_not']);
            } else {
                $builder->where('tpp.parking_place_id !=', $filterData['parking_place_id_not']);
            }
        }


        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tpp.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('ta.parking_area_name', $filterData['search'], 'both');
            $builder->orLike('tpp.number', $filterData['search'], 'both');
            $builder->orLike('ta.vehicle_type', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tpp.parking_place_id');
        $builder->orderBy('tpp.parking_place_id','DESC');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($parkingPlaceId)
    {
        $builder = $this->db->table('tbl_parking_place');
        $parkingPlaceIdArray = is_array($parkingPlaceId) ? $parkingPlaceId : array($parkingPlaceId);
        $builder->whereIn('parking_place_id', $parkingPlaceIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($parkingPlaceId)){
                foreach($parkingPlaceId as $parkingPlace){
                    $deleteDataArray['module'] = 'Parking Place';
                    $deleteDataArray['activity'] = "Parking Place Deleted";
                    $deleteDataArray['module_id'] = $parkingPlace;
                    logActivity('Parking Place Deleted [ParkingPlaceID: ' . $parkingPlace . ']',$this->ionAuth->getUserId(),'Parking Place',$parkingPlace,json_encode($deleteDataArray),'','Parking Place',$parkingPlace);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getParkingPlace($filterData)
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_parking_place as tpp');
        //$builder->startCache();
        $builder->select("tpp.parking_place_id as id,CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as text,tpp.number");
        $builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");

        if(isset($filterData['parking_place_id']) && !empty($filterData['parking_place_id'])) {
            if (is_array($filterData['parking_place_id'])) {
                $builder->whereIn('tpp.parking_place_id', $filterData['parking_place_id']);
            } else {
                $builder->where('tpp.parking_place_id', $filterData['parking_place_id']);
            }
        }

        if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tpp.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tpp.flat_id', $filterData['flat_id']);
            }
        }
        if(isset($filterData['vehicle_type']) && !empty($filterData['vehicle_type'])) {
            if (is_array($filterData['vehicle_type'])) {
                $builder->whereIn('ta.vehicle_type', $filterData['vehicle_type']);
            } else {
                $builder->where('ta.vehicle_type', $filterData['vehicle_type']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ta.parking_area_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tpp.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getTotalAreaParkingData($filterData = array())
    {

        $builder = $this->db->table('tbl_parking_place as tpp');
        $builder->select("COUNT(tpp.parking_place_id) + 1 AS total_assign_slot");

        if (isset($filterData['parking_area_id']) && !empty($filterData['parking_area_id'])) {
            if (is_array($filterData['parking_area_id'])) {
                $builder->whereIn('tpp.parking_area_id', $filterData['parking_area_id']);
            } else {
                $builder->where('tpp.parking_area_id', $filterData['parking_area_id']);
            }
        }


        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tpp.society_id', $filterData['society_id']);
            } else {
                $builder->where('tpp.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['parking_place_id_not']) && !empty($filterData['parking_place_id_not'])) {
            if (is_array($filterData['parking_place_id_not'])) {
                $builder->whereNotIn('tpp.parking_place_id', $filterData['parking_place_id_not']);
            } else {
                $builder->where('tpp.parking_place_id !=', $filterData['parking_place_id_not']);
            }
        }

        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }

        return $queryData;
    }


    public function getAllOwnerParkingData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_parking_place as tpp');
        $builder->select("tpp.*,ta.parking_area_name,ta.vehicle_type");
        $builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as number");
        $builder->select("COALESCE(tpp.number,'') as display_block");
        $builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as parking_block_display");
        $builder->select("(CASE
								WHEN
									COALESCE(tofp.vehicle_type,'') !='' THEN COALESCE(tofp.vehicle_type,'')
								WHEN
									COALESCE(tv.vehicle_type,'') !='' THEN if(tv.vehicle_type = 'car','4_wheelers','2_wheelers')
							    ELSE ''
							END) as vehicle_type");
        $builder->select("(CASE
								WHEN
									COALESCE(tofp.vehicle_no,'') !='' THEN COALESCE(tofp.vehicle_no,'')
								WHEN
									COALESCE(tv.vehicle_no,'') !='' THEN COALESCE(tv.vehicle_no,'')
							    ELSE ''
							END) as vehicle_no");
        $builder->select("(CASE
								WHEN
									COALESCE(tus.phone,'') !='' THEN COALESCE(tus.phone,'')
								WHEN
									COALESCE(tv.visitor_mobile_no,'') !='' THEN COALESCE(tv.visitor_mobile_no,'')
							    ELSE ''
							END) as mobile_no");
        $builder->select("(CASE
								WHEN
									COALESCE(tm.name,'') !='' THEN COALESCE(tm.name,'')
								WHEN
									COALESCE(tv.visitor_name,'') !='' THEN COALESCE(tv.visitor_name,'')
							    ELSE ''
							END) as name");
        $builder->select("(CASE
								WHEN
									COALESCE(tpp.flat_id,'') !=0 THEN COALESCE(tpp.flat_id,'')
								WHEN
									COALESCE(tofv.flat_id,'') !=0 THEN COALESCE(tofv.flat_id,'')
							    ELSE ''
							END) as flat_id");
        $builder->select("(CASE
								WHEN
									COALESCE(tpp.flat_id,'') !=0 THEN COALESCE(concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ),'')
								WHEN
									COALESCE(tofv.flat_id,'') !=0 THEN COALESCE(concat(COALESCE(ttv.tower_name,''),'-',COALESCE(tfv.flat_no,'') ),'')
							    ELSE ''
							END) as flat_no");

        $builder->select("(CASE
								WHEN
									COALESCE(NULLIF(tpp.flat_id,0),'') !='' THEN 'flat_owner'
								WHEN
									COALESCE(NULLIF(tofv.flat_id,0),'') !='' THEN 'visitor'
							    ELSE 'free_slot'
							END) as allocated_parking");

         $builder->select("COALESCE(tofp.type,'') as type,COALESCE(tofp.type_id,'') as type_id,tofp.ownership_flat_id");

        $builder->join("tbl_parking_vehicle as tpv","tpv.parking_vehicle_id = tpp.parking_vehicle_id","left");
        $builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");

        $builder->join("tbl_ownership_flat_parking as tofp","tofp.parking_place_id = tpp.parking_place_id AND tofp.is_delete = 0","left");
        // $builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_id = tofp.ownership_flat_id AND tofm.is_owner='1' ","left");
        $builder->join("tbl_ownership_flat_member as tofm", "tofm.ownership_flat_id = tofp.ownership_flat_id AND tofp.type = tofm.type ",  "left");
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        // $builder->join("tbl_rentals as tr", "tr.rentals_id = tofm.type_id AND tofp.type = 'rental' AND tr.rent_agreement_period_from <= CURDATE() AND tr.rent_agreement_period_to >= CURDATE()", "left");
        $builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tpp.society_id","left");



        $builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofp.ownership_flat_id","left");

        $builder->join("tbl_flat as tf","tf.flat_id = tpp.flat_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");


        $builder->join("tbl_visitor as tv","tv.parking_place_id = tpp.parking_place_id AND tv.status='entered'","left");
        $builder->join("tbl_ownership_flat as tofv","tofv.ownership_flat_id = tv.ownership_flat_id","left");
        $builder->join("tbl_flat as tfv","tfv.flat_id = tofv.flat_id","left");
        $builder->join("tbl_tower as ttv","ttv.tower_id = tfv.tower_id","left");
        // $builder->where('tofm.is_delete', 0);


        if(isset($filterData['parking_place_id']) && !empty($filterData['parking_place_id'])) {
            if (is_array($filterData['parking_place_id'])) {
                $builder->whereIn('tpp.parking_place_id', $filterData['parking_place_id']);
            } else {
                $builder->where('tpp.parking_place_id', $filterData['parking_place_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tpp.society_id', $filterData['society_id']);
            } else {
                $builder->where('tpp.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tpp.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tpp.flat_id', $filterData['flat_id']);
            }
        }

        if(isset($filterData['parking_area_id']) && !empty($filterData['parking_area_id'])) {
            if (is_array($filterData['parking_area_id'])) {
                $builder->whereIn('tpp.parking_area_id', $filterData['parking_area_id']);
            } else {
                $builder->where('tpp.parking_area_id', $filterData['parking_area_id']);
            }
        }

        if(isset($filterData['number']) && !empty($filterData['number'])) {
            if (is_array($filterData['number'])) {
                $builder->whereIn('tpp.number', $filterData['number']);
            } else {
                $builder->where('tpp.number', $filterData['number']);
            }
        }


        if(isset($filterData['parking_place_id_not']) && !empty($filterData['parking_place_id_not'])) {
            if (is_array($filterData['parking_place_id_not'])) {
                $builder->whereNotIn('tpp.parking_place_id', $filterData['parking_place_id_not']);
            } else {
                $builder->where('tpp.parking_place_id !=', $filterData['parking_place_id_not']);
            }
        }


        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tpp.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like("(CASE
								WHEN
									COALESCE(tofp.vehicle_type,'') !='' THEN COALESCE(tofp.vehicle_type,'')
								WHEN
									COALESCE(tv.vehicle_type,'') !='' THEN if(tv.vehicle_type = 'car','4_wheelers','2_wheelers')
							END)", $filterData['search'], 'both');
            $builder->orLike("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,''))", $filterData['search'], 'both');


            $builder->orLike("(CASE
								WHEN
									COALESCE(tofp.vehicle_no,'') !='' THEN COALESCE(tofp.vehicle_no,'')
								WHEN
									COALESCE(tv.vehicle_no,'') !='' THEN COALESCE(tv.vehicle_no,'')
							END)", $filterData['search'], 'both');

            $builder->orLike("(CASE
								WHEN
									COALESCE(tofm.mobile_no,'') !='' THEN COALESCE(tofm.mobile_no,'')
								WHEN
									COALESCE(tv.visitor_mobile_no,'') !='' THEN COALESCE(tv.visitor_mobile_no,'')
							    ELSE ''
							END)", $filterData['search'], 'both');


            $builder->orLike("(CASE
								WHEN
									COALESCE(tm.name,'') !='' THEN COALESCE(tm.name,'')
								WHEN
									COALESCE(tv.visitor_name,'') !='' THEN COALESCE(tv.visitor_name,'')
							END) ", $filterData['search'], 'both');

            $builder->orLike("(CASE
								WHEN
									COALESCE(tpp.flat_id,'') !='' THEN COALESCE(concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ),'')
								WHEN
									COALESCE(tofv.flat_id,'') !='' THEN COALESCE(concat(COALESCE(ttv.tower_name,''),'-',COALESCE(tfv.flat_no,'') ),'')
							END)", $filterData['search'], 'both');

            $builder->groupEnd();
        }

        $builder->groupBy('tpp.parking_place_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function getAllVisitorParkingData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_visitor as tv');
        $builder->select("tpp.*,ta.parking_area_name");
        $builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as number");
        $builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as parking_block_display");
        $builder->select("if(tv.vehicle_type = 'car','4_wheelers','2_wheelers') as vehicle_type");
        $builder->select("COALESCE(tv.vehicle_no,'') as vehicle_no");
        $builder->select("COALESCE(tv.visitor_mobile_no,'') as mobile_no,COALESCE(tv.visitor_name,'') as name");

        $builder->select("tof.flat_id,concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $builder->join("tbl_parking_place as tpp","tpp.parking_place_id = tv.parking_place_id","left");
        $builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");

        $builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tv.ownership_flat_id","left");
        $builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");

        if(isset($filterData['parking_place_id']) && !empty($filterData['parking_place_id'])) {
            if (is_array($filterData['parking_place_id'])) {
                $builder->whereIn('tv.parking_place_id', $filterData['parking_place_id']);
            } else {
                $builder->where('tv.parking_place_id', $filterData['parking_place_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tv.society_id', $filterData['society_id']);
            } else {
                $builder->where('tv.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tv.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tv.flat_id', $filterData['flat_id']);
            }
        }

        if(isset($filterData['status']) && !empty($filterData['status'])) {
            if (is_array($filterData['status'])) {
                $builder->whereIn('tv.status', $filterData['status']);
            } else {
                $builder->where('tv.status', $filterData['status']);
            }
        }


        if(isset($filterData['parking_area_id']) && !empty($filterData['parking_area_id'])) {
            if (is_array($filterData['parking_area_id'])) {
                $builder->whereIn('tpp.parking_area_id', $filterData['parking_area_id']);
            } else {
                $builder->where('tpp.parking_area_id', $filterData['parking_area_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tpp.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like("COALESCE(tv.visitor_mobile_no,'')", $filterData['search'], 'both');
            $builder->orLike("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,''))", $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tpp.parking_place_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

}
?>
