<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ParkingAreaModel extends BaseModel
{

    public function getParkingAreaData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_parking_area as ta');
        $builder->select("ta.*,ta.parking_area_name as parking_area");
        $builder->select("((
            (
                SELECT COUNT(tpp.parking_slot_id) 
                FROM tbl_parking_slot AS tpp 
                WHERE tpp.parking_area_id = ta.parking_area_id 
                AND tpp.flat_id = 0 
                AND tpp.is_visitor_parking = 1
            ) - 
            (
                SELECT COUNT(tpp.parking_slot_id) 
                FROM tbl_parking_slot AS tpp 
                WHERE tpp.parking_area_id = ta.parking_area_id
                AND tpp.parking_slot_id IN (
                    SELECT tv.parking_slot_id 
                    FROM tbl_visitor AS tv 
                    WHERE tv.status = 'entered'
                )
            )
        )) AS available_slots");
        $builder->join("tbl_parking_vehicle as tpv","ta.parking_area_id = tpv.parking_area_id","left");
        if(isset($filterData['parking_area_id']) && !empty($filterData['parking_area_id'])) {
            if (is_array($filterData['parking_area_id'])) {
                $builder->whereIn('ta.parking_area_id', $filterData['parking_area_id']);
            } else {
                $builder->where('ta.parking_area_id', $filterData['parking_area_id']);
            }
        }


        if(isset($filterData['parking_area_name']) && !empty($filterData['parking_area_name'])) {
            if (is_array($filterData['parking_area_name'])) {
                $builder->whereIn('ta.parking_area_name', $filterData['parking_area_name']);
            } else {
                $builder->where('ta.parking_area_name', $filterData['parking_area_name']);
            }
        }

        if(isset($filterData['parking_area_id_not']) && !empty($filterData['parking_area_id_not'])) {
            if (is_array($filterData['parking_area_id_not'])) {
                $builder->whereNotIn('ta.parking_area_id', $filterData['parking_area_id_not']);
            } else {
                $builder->where('ta.parking_area_id !=', $filterData['parking_area_id_not']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ta.society_id', $filterData['society_id']);
            } else {
                $builder->where('ta.society_id', $filterData['society_id']);
            }
        }


        if(isset($filterData['vehicle_type']) && !empty($filterData['vehicle_type'])) {
            if (is_array($filterData['vehicle_type'])) {
                $builder->whereIn('tpv.vehicle_type', $filterData['vehicle_type']);
            } else {
                $builder->where('tpv.vehicle_type', $filterData['vehicle_type']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('ta.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('parking_area_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('ta.parking_area_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        // lastQuery();
        return $queryData;
    }


    public function deleteRecord($parkingAreaId)
    {
        $parkingAreaIdArray = is_array($parkingAreaId) ? $parkingAreaId : array($parkingAreaId);
        $builder = $this->db->table('tbl_parking_vehicle');
        $builder->whereIn('parking_area_id', $parkingAreaIdArray);
        $builder->delete();
        
        $builder = $this->db->table('tbl_parking_area');
        $builder->whereIn('parking_area_id', $parkingAreaIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($parkingAreaId)){
                foreach($parkingAreaId as $parkingArea){
                    $deleteDataArray['module'] = 'Parking Area';
                    $deleteDataArray['activity'] = "Parking Area Deleted";
                    $deleteDataArray['module_id'] = $parkingArea;
                    logActivity('Parking Area Deleted [ParkingAreaID: ' . $parkingArea . ']',$this->ionAuth->getUserId(),'Parking Area',$parkingArea,json_encode($deleteDataArray),'','Parking Area',$parkingArea);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getParkingVehicleData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_parking_vehicle as tpv');
        $builder->select("tpv.*,ConvertToTitleCase(tpv.vehicle_type) as display_vehicle_type");
        $builder->join("tbl_parking_area as tpa","tpa.parking_area_id = tpv.parking_area_id","left");
        if(isset($filterData['parking_area_id']) && !empty($filterData['parking_area_id'])) {
            if (is_array($filterData['parking_area_id'])) {
                $builder->whereIn('tpv.parking_area_id', $filterData['parking_area_id']);
            } else {
                $builder->where('tpv.parking_area_id', $filterData['parking_area_id']);
            }
        }


        
        if(isset($filterData['parking_area_id_not']) && !empty($filterData['parking_area_id_not'])) {
            if (is_array($filterData['parking_area_id_not'])) {
                $builder->whereNotIn('tpa.parking_area_id', $filterData['parking_area_id_not']);
            } else {
                $builder->where('tpa.parking_area_id !=', $filterData['parking_area_id_not']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tpa.society_id', $filterData['society_id']);
            } else {
                $builder->where('tpa.society_id', $filterData['society_id']);
            }
        }


        if(isset($filterData['vehicle_type']) && !empty($filterData['vehicle_type'])) {
            if (is_array($filterData['vehicle_type'])) {
                $builder->whereIn('tpv.vehicle_type', $filterData['vehicle_type']);
            } else {
                $builder->where('tpv.vehicle_type', $filterData['vehicle_type']);
            }
        }

        $builder->groupBy('tpv.parking_vehicle_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        // lastQuery();
        return $queryData;
    }

    function getParkingArea($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_parking_area as ta');
        //$builder->startCache();
        $builder->select("ta.parking_area_id as id,COALESCE(ta.parking_area_name,'') as text");
        // $builder->select("ta.parking_area_id as id,concat(COALESCE(ta.parking_area_name,''),'-',ConvertToTitleCase(ta.vehicle_type)) as text");
        

        if(isset($filterData['parking_area_id']) && !empty($filterData['parking_area_id'])) {
            if (is_array($filterData['parking_area_id'])) {
                $builder->whereIn('ta.parking_area_id', $filterData['parking_area_id']);
            } else {
                $builder->where('ta.parking_area_id', $filterData['parking_area_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ta.parking_area_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ta.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResulta(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }


    function getParkingVehicle($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_parking_vehicle as tpv');
        $builder->select("tpv.parking_vehicle_id as id, concat(COALESCE(ta.parking_area_name,'') ,'-', ConvertToTitleCase(tpv.vehicle_type)) as text,tpv.vehicle_type");
        $builder->join("tbl_parking_area as ta","ta.parking_area_id = tpv.parking_area_id","left");

        if(isset($filterData['parking_area_id']) && !empty($filterData['parking_area_id'])) {
            if (is_array($filterData['parking_area_id'])) {
                $builder->whereIn('ta.parking_area_id', $filterData['parking_area_id']);
            } else {
                $builder->where('ta.parking_area_id', $filterData['parking_area_id']);
            }
        }

        if(isset($filterData['parking_vehicle_id']) && !empty($filterData['parking_vehicle_id'])) {
            if (is_array($filterData['parking_vehicle_id'])) {
                $builder->whereIn('tpv.parking_vehicle_id', $filterData['parking_vehicle_id']);
            } else {
                $builder->where('tpv.parking_vehicle_id', $filterData['parking_vehicle_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ta.parking_area_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ta.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResulta(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function deleteParkingVehicleRecord($parkingVehicleId)
    {
        $builder = $this->db->table('tbl_parking_vehicle');
        $parkingVehicleIdArray = is_array($parkingVehicleId) ? $parkingVehicleId : array($parkingVehicleId);
        $builder->whereIn('parking_vehicle_id',$parkingVehicleIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}