<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class NotificationModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getNotificationData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_notification as tn');
        $builder->select("tn.*");
        $builder->select("(CASE WHEN tn.receive_for_notification = 'gate_keeper' THEN COALESCE(tresource.resource_name, '') 
								 WHEN tn.receive_for_notification = 'member' THEN  COALESCE(tm.name, '') 
								 WHEN tn.receive_for_notification = 'admin' THEN  COALESCE(tuser.first_name, '') 
								 WHEN tn.receive_for_notification = 'manager' THEN  COALESCE(tuser.first_name, '') 
          						 END) as member_name");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tn.updated_by AND tupdate.society_id = tn.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tn.created_by AND tcreate.society_id = tn.society_id","left");
        $builder->join("tbl_resource as tresource","tresource.resource_id = tn.receive_for_notification_id AND tn.receive_for_notification='gate_keeper'","left");
        $builder->join(MASTER_DB.".tbl_users_info as tuser","tuser.id = tn.receive_for_notification_id AND tn.receive_for_notification='manager' AND tuser.society_id = tn.society_id","left");
        $builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tn.receive_for_notification_id AND tn.receive_for_notification='member'","left");
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		if (isset($filterData['notification_id']) && !empty($filterData['notification_id'])) {
			if (is_array($filterData['notification_id'])) {
				$builder->whereIn('tn.notification_id', $filterData['notification_id']);
			} else {
				$builder->where('tn.notification_id', $filterData['notification_id']);
			}
		}

		if (isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tn.type', $filterData['type']);
			} else {
				$builder->where('tn.type', $filterData['type']);
			}
		}

		if (isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tn.type_id', $filterData['type_id']);
			} else {
				$builder->where('tn.type_id', $filterData['type_id']);
			}
		}

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tn.society_id', $filterData['society_id']);
			} else {
				$builder->where('tn.society_id', $filterData['society_id']);
			}
		}

		if (isset($filterData['receive_for_notification']) && !empty($filterData['receive_for_notification'])) {
			if (is_array($filterData['receive_for_notification'])) {
				$builder->whereIn('tn.receive_for_notification', $filterData['receive_for_notification']);
			} else {
				$builder->where('tn.receive_for_notification', $filterData['receive_for_notification']);
			}
		}

		if (isset($filterData['receive_for_notification_id']) && !empty($filterData['receive_for_notification_id'])) {
			if (is_array($filterData['receive_for_notification_id'])) {
				$builder->whereIn('tn.receive_for_notification_id', $filterData['receive_for_notification_id']);
			} else {
				$builder->where('tn.receive_for_notification_id', $filterData['receive_for_notification_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('notification_title', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tn.notification_id",'desc');
		$builder->groupBy('tn.notification_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}
}
?>
