<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class MeetingModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getMeetingData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_meeting as tm');
        $builder->select("tm.*");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tm.updated_by AND tupdate.society_id = tm.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tm.created_by AND tcreate.society_id = tm.society_id","left");
		if (isset($filterData['meeting_id']) && !empty($filterData['meeting_id'])) {
			if (is_array($filterData['meeting_id'])) {
				$builder->whereIn('tm.meeting_id', $filterData['meeting_id']);
			} else {
				$builder->where('tm.meeting_id', $filterData['meeting_id']);
			}
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tm.society_id', $filterData['society_id']);
			} else {
				$builder->where('tm.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('meeting_title', $filterData['search'], 'both');
			$builder->orLike('meeting_agenda', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tm.is_active', $filterData['is_active']);
		}
		$builder->orderBy("tm.meeting_id",'desc');
		$builder->groupBy('tm.meeting_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($meetingId,$userId = 0,$societyId = 0)
	{
		$meetingRecordIdArray = is_array($meetingId) ? $meetingId : array($meetingId);
		foreach ($meetingRecordIdArray as $meetingIds){
			$getRecordData = $this->getMeetingRecordData(array("meeting_id" => $meetingIds));
			// printArray($meetingId);
			// printArray($getRecordData,1);
			$fileUrl = '';
			if(!empty($getRecordData)){
				if($getRecordData['meeting_record'] != '') {
					$fileUrl = MEETING_RECORD_PATH . $getRecordData['meeting_record'];
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}
			}
		}

		$builder = $this->db->table('tbl_meeting_record');
        $builder->whereIn('meeting_id', $meetingId);
        $builder->delete();
        $builder = $this->db->table('tbl_meeting');
        $builder->whereIn('meeting_id', $meetingId);
		$ids = is_array($meetingId) ? implode(',',$meetingId) : $meetingId;
		$builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($meetingId)){
				foreach($meetingId as $meeting){
					$deleteDataArray['module'] = 'Meeting';
            		$deleteDataArray['activity'] = "Meeting Deleted";
					$deleteDataArray['module_id'] = $meeting;
					$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
					logActivity('Meeting Deleted [MeetingID: ' . $meeting . ']',$userId,'Meeting',$meeting,json_encode($deleteDataArray),'','Meeting',$meeting,$societyId);
				}
			}
			return true;
		}
		return false;
	}

	public function getMeetingRecordData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_meeting_record as tmr');
		$builder->select("tmr.meeting_record_id, tmr.meeting_record,tmr.meeting_id");
		$builder->join('tbl_meeting tm', 'tm.meeting_id = tmr.meeting_id', 'left');
		if(isset($filterData['meeting_id']) && !empty($filterData['meeting_id'])) {
            if (is_array($filterData['meeting_id'])) {
                $builder->whereIn('tmr.meeting_id', $filterData['meeting_id']);
            } else {
                $builder->where('tmr.meeting_id', $filterData['meeting_id']);
            }
        }

		if (isset($filterData['meeting_record_id']) && $filterData['meeting_record_id'] != '') {
			$builder->where("tmr.meeting_record_id", $filterData['meeting_record_id']);
		}
		
		$builder->orderBy("tmr.meeting_id");

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}

		return $query;
	}

	public function deleteMeetingRecord($meetingRecordId)
	{
		$builder = $this->db->table('tbl_meeting_record');
        $meetingRecordIdArray = is_array($meetingRecordId) ? $meetingRecordId : array($meetingRecordId);
        $builder->whereIn('meeting_record_id', $meetingRecordIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

	public function deleteRecordMeetingRecord($meetingId,$userId = 0,$societyId = 0)
	{	
		$meetingIdArray = is_array($meetingId) ? $meetingId : array($meetingId);
		foreach ($meetingIdArray as $meetingIds){
			$getImageData = $this->getMeetingRecordData(array("meeting_id" => $meetingIds));
			$fileUrl = '';
			if(!empty($getImageData)){
				if($getImageData['meeting_record'] != '') {
					$fileUrl = MEETING_RECORD_PATH . $getImageData['meeting_record'];
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}
			}
			
		}
		$builder = $this->db->table('tbl_meeting_record');
        $builder->whereIn('meeting_id', $meetingIdArray);

		$ids = is_array($meetingId) ? implode(',',$meetingId) : $meetingId;

		if ($this->db->affectedRows()) {

			if(!empty($meetingId)){
				
				$deleteDataArray['module'] = 'Meeting Record';
				$deleteDataArray['activity'] = "Meeting Record Deleted";
				$deleteDataArray['module_id'] = $meetingId;
				$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
				logActivity('Meeting Record Deleted [MeetingID: ' . $meetingId . ']',$userId,'Meeting Record',$meetingId,json_encode($deleteDataArray),'','Meeting',$meetingId,$societyId);
			}
			return true;
		}
		return false;
	}
}
?>
