<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class MediaModel extends BaseModel
{

    public function getMediaData($filterData = array())
    {
        $builder = $this->db->table('tbl_media as tm');
        $builder->select("tm.*");
        if(isset($filterData['media_id']) && $filterData['media_id'] != '') {
            if(is_array($filterData['media_id'])){
                $builder->whereIn('tm.media_id', $filterData['media_id']);
            } else {
                $builder->where('tm.media_id', $filterData['media_id']);
            }
        }
        if(isset($filterData['media_for']) && $filterData['media_for'] != '') {
            if(is_array($filterData['media_for'])){
                $builder->whereIn('tm.media_for', $filterData['media_for']);
            } else {
                $builder->where('tm.media_for', $filterData['media_for']);
            }
        }
        if(isset($filterData['media_for_id']) && $filterData['media_for_id'] != '') {
            if(is_array($filterData['media_for_id'])){
                $builder->whereIn('tm.media_for_id', $filterData['media_for_id']);
            } else {
                $builder->where('tm.media_for_id', $filterData['media_for_id']);
            }
        }
        $builder->orderBy("tm.media_sort_order",'desc');
        $query = $builder->get();
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)) {
            $result = $query->getResultArray();
        } else {
            $result = $query->getRowArray();
        }
        return $result;
    }

    public function deleteMediaRecord($mediaId)
    {
        $builder = $this->db->table('tbl_media');
        $builder->where('media_id',$mediaId);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteRecordMedia($filterData = array())
    {
        $builder = $this->db->table('tbl_media');
        $mediaForIdArray = is_array($filterData['media_for_id']) ? $filterData['media_for_id'] : array($filterData['media_for_id']);
        $builder->where('media_for',$filterData['media_for']);
        $builder->whereIn('media_for_id',$mediaForIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}