<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ManufacturerModel extends BaseModel
{

    public function getManufacturerData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_manufacturer as tm');
        $builder->select("tm.*");

        if(isset($filterData['manufacturer_id']) && !empty($filterData['manufacturer_id'])) {
            if (is_array($filterData['manufacturer_id'])) {
                $builder->whereIn('tm.manufacturer_id', $filterData['manufacturer_id']);
            } else {
                $builder->where('tm.manufacturer_id', $filterData['manufacturer_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tm.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('manufacturer_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tm.manufacturer_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($manufacturerId)
    {
        $builder = $this->db->table('tbl_manufacturer');
        $manufacturerIdArray = is_array($manufacturerId) ? $manufacturerId : array($manufacturerId);
        $builder->whereIn('manufacturer_id', $manufacturerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($manufacturerId)){
                foreach($manufacturerId as $manufacturer){
                    $deleteDataArray['module'] = 'Manufacturer';
                    $deleteDataArray['activity'] = "Manufacturer Deleted";
                    $deleteDataArray['module_id'] = $manufacturer;
                    logActivity('Manufacturer Deleted [ManufacturerID: ' . $manufacturer . ']',$this->ionAuth->getUserId(),'Manufacturer',$manufacturer,json_encode($deleteDataArray),'','Manufacturer',$manufacturer);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getManufacturer($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_manufacturer as tm');
        //$builder->startCache();
        $builder->select("tm.manufacturer_id as id,COALESCE(tm.manufacturer_name,'') as text");

        if(isset($filterData['manufacturer_id']) && !empty($filterData['manufacturer_id'])) {
            if (is_array($filterData['manufacturer_id'])) {
                $builder->whereIn('tm.manufacturer_id', $filterData['manufacturer_id']);
            } else {
                $builder->where('tm.manufacturer_id', $filterData['manufacturer_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tm.society_id', $filterData['society_id']);
            } else {
                $builder->where('tm.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tm.manufacturer_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tm.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResultm(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}