<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class LetterHeadModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getLetterHeadData($filterData = array())
	{
		$limit = DATA_LIMIT;
		
		$builder = $this->db->table('tbl_letter_head as tlh');
        $builder->select("tlh.*");
        
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tlh.updated_by AND tupdate.society_id = tlh.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tlh.created_by AND tcreate.society_id = tlh.society_id","left");

        
		if (isset($filterData['letter_head_id']) && !empty($filterData['letter_head_id'])) {
			if (is_array($filterData['letter_head_id'])) {
				$builder->whereIn('tlh.letter_head_id', $filterData['letter_head_id']);
			} else {
				$builder->where('tlh.letter_head_id', $filterData['letter_head_id']);
			}
		}

		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('letter_head_title', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tlh.letter_head_id",'desc');
		$builder->groupBy('tlh.letter_head_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		//lastQuery();
		return $queryData;
	}

	public function deleteRecord($letterHeadId)
    {
        $letterHeadIdArray = is_array($letterHeadId) ? $letterHeadId : array($letterHeadId);
        $builder = $this->db->table('tbl_letter_head');
        $builder->whereIn('letter_head_id', $letterHeadIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($letterHeadId)){
                foreach($letterHeadId as $documentElement){
                    $deleteDataArray['module'] = 'Letter Head';
                    $deleteDataArray['activity'] = "Letter Head Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Letter Head Deleted [LetterHeadID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Letter Head',$documentElement,json_encode($deleteDataArray),'','Letter Head',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}
?>
