<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class LedgerModel extends BaseModel
{

	public function getLedgerData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_ledger as tl');
        $builder->select("tl.*,tloc.society_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tl.updated_by AND tupdate.society_id = tl.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tl.created_by AND tcreate.society_id = tl.society_id","left");
        $builder->join(MASTER_DB.".tbl_society as tloc","tloc.society_id = tl.society_id","left");
        // $builder->join("tbl_ledger_guard as tlg","tlg.ledger_id = tl.ledger_id","left");

        if (isset($filterData['ledger_id']) && !empty($filterData['ledger_id'])) {
            if (is_array($filterData['ledger_id'])) {
                $builder->whereIn('tl.ledger_id', $filterData['ledger_id']);
            } else {
                $builder->where('tl.ledger_id', $filterData['ledger_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tl.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['ledger_code']) && !empty($filterData['ledger_code'])) {
            if (is_array($filterData['ledger_code'])) {
                $builder->whereIn('tl.ledger_code', $filterData['ledger_code']);
            } else {
                $builder->where('tl.ledger_code', $filterData['ledger_code']);
            }
        }
        if (isset($filterData['ledger_name']) && !empty($filterData['ledger_name'])) {
            if (is_array($filterData['ledger_name'])) {
                $builder->whereIn('tl.ledger_name', $filterData['ledger_name']);
            } else {
                $builder->where('tl.ledger_name', $filterData['ledger_name']);
            }
        }

        if (isset($filterData['start'])) {
            if ($filterData['start'] != '1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
            $builder->where('tl.is_active', $filterData['is_active']);
        }


        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tl.ledger_code', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tl.ledger_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($ledgerId)
    {
        $ledgerIdArray = is_array($ledgerId) ? $ledgerId : array($ledgerId);
        $builder = $this->db->table('tbl_ledger');
        $builder->whereIn('ledger_id', $ledgerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($ledgerId)){
                foreach($ledgerId as $documentElement){
                    $deleteDataArray['module'] = 'Ledger';
                    $deleteDataArray['activity'] = "Ledger Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Ledger Deleted [LedgerID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Ledger',$documentElement,json_encode($deleteDataArray),'','Ledger',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getLedger($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_ledger as tl');
        //$builder->startCache();
        $builder->select("tl.ledger_id as id,COALESCE(tl.ledger_name,'')  as text");
        if(isset($filterData['ledger_id']) && !empty($filterData['ledger_id'])) {
            if (is_array($filterData['ledger_id'])) {
                $builder->whereIn('tl.ledger_id', $filterData['ledger_id']);
            } else {
                $builder->where('tl.ledger_id', $filterData['ledger_id']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tl.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tl.ledger_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tl.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getLedgerSubLedgerData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_ledger_sub_ledger as tlsl');
        $builder->select("tlsl.ledger_sub_ledger_id,tlsl.sub_ledger_id");
        $builder->select("concat(COALESCE(tl.sub_ledger_code,''),'-',COALESCE(tl.sub_ledger_name,'')) as sub_ledger_code_name");
        $builder->join('tbl_sub_ledger tl', 'tl.sub_ledger_id = tlsl.sub_ledger_id', 'left');

        if(isset($filterData['ledger_id']) && !empty($filterData['ledger_id'])) {
            if (is_array($filterData['ledger_id'])) {
                $builder->whereIn('tlsl.ledger_id', $filterData['ledger_id']);
            } else {
                $builder->where('tlsl.ledger_id', $filterData['ledger_id']);
            }
        }

        // if (isset($filterData['ledger_image_id']) && $filterData['ledger_image_id'] != '') {
        //     $builder->where("tmi.ledger_image_id", $filterData['ledger_image_id']);
        // }

        $builder->orderBy("tlsl.ledger_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteSubLedgerRecord($ledgerId){
        $builder = $this->db->table('tbl_ledger_sub_ledger');
        $ledgerIdArray = is_array($ledgerId) ? $ledgerId : array($ledgerId);
        $builder->whereIn('ledger_id', $ledgerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

}
?>
