<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class GeneratorModel extends BaseModel
{
	public function getGeneratorData($filterData = array())
	{
		$limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_generator as tg');
        $builder->select("tg.*");

		if(isset($filterData['generator_id']) && !empty($filterData['generator_id'])) {
			if (is_array($filterData['generator_id'])) {
				$builder->whereIn('tg.generator_id', $filterData['generator_id']);
			} else {
				$builder->where('tg.generator_id', $filterData['generator_id']);
			}
		}

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tg.society_id', $filterData['society_id']);
            } else {
                $builder->where('tg.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['water_meter_reading_id_not']) && !empty($filterData['water_meter_reading_id_not'])) {
			if (is_array($filterData['water_meter_reading_id_not'])) {
				$builder->whereNotIn('twmr.water_meter_reading_id', $filterData['water_meter_reading_id_not']);
			} else {
				$builder->where('twmr.water_meter_reading_id !=', $filterData['water_meter_reading_id_not']);
			}
		}

		if(isset($filterData['generator_name']) && !empty($filterData['generator_name'])) {
			if (is_array($filterData['generator_name'])) {
				$builder->whereIn('tg.generator_name', $filterData['generator_name']);
			} else {
				$builder->where('tg.generator_name', $filterData['generator_name']);
			}
		}

		if(isset($filterData['start'])){
			if($filterData['start'] != '-1'){
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();
			$builder->like('tg.generator_name', $filterData['search'], 'both');
			$builder->groupEnd();

		}
		$builder->groupBy('tg.generator_id');

		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		}else{
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}



	function getGenerator($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_generator as tg');
        $builder->select("tg.generator_id as id,COALESCE(tg.generator_name,'') as text");

        if(isset($filterData['generator_id']) && !empty($filterData['generator_id'])) {
            if (is_array($filterData['generator_id'])) {
                $builder->whereIn('tg.generator_id', $filterData['generator_id']);
            } else {
                $builder->where('tg.generator_id', $filterData['generator_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tg.generator_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }

		accessFilter($builder, array("society" => "tg.society_id"));
        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }


    public function deleteRecord($generatorId,$userId = 0,$societyId = 0)
	{
		$builder = $this->db->table('tbl_generator');
        $generatorIdArray = is_array($generatorId) ? $generatorId : array($generatorId);
        $builder->whereIn('generator_id', $generatorIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {

			if(!empty($generatorId)){
				foreach($generatorId as $generator){
					$deleteDataArray['module'] = 'Generator';
            		$deleteDataArray['activity'] = "Generator Deleted";
					$deleteDataArray['module_id'] = $generator;
					$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
					logActivity('Generator Deleted [GeneratorID: ' . $generator . ']',$userId,'Generator',$generator,json_encode($deleteDataArray),'','Generator',$generator,$societyId);
				}
			}
			return true;
		}
		return false;
	}
}
?>
