<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class GateModel extends BaseModel
{

    public function getGateData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_gate as tg');
        $builder->select("tg.*,tt.tower_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("tbl_tower as tt","tt.tower_id = tg.tower_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tg.updated_by AND tupdate.society_id = tg.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tg.created_by AND tcreate.society_id = tg.society_id","left");

        if (isset($filterData['gate_id']) && !empty($filterData['gate_id'])) {
            if (is_array($filterData['gate_id'])) {
                $builder->whereIn('tg.gate_id', $filterData['gate_id']);
            } else {
                $builder->where('tg.gate_id', $filterData['gate_id']);
            }
        }

        if (isset($filterData['gate_name']) && !empty($filterData['gate_name'])) {
            if (is_array($filterData['gate_name'])) {
                $builder->whereIn('tg.gate_name', $filterData['gate_name']);
            } else {
                $builder->where('tg.gate_name', $filterData['gate_name']);
            }
        }

        if (isset($filterData['gate_type']) && !empty($filterData['gate_type'])) {
            if (is_array($filterData['gate_type'])) {
                $builder->whereIn('tg.gate_type', $filterData['gate_type']);
            } else {
                $builder->where('tg.gate_type', $filterData['gate_type']);
            }
        }

        if(isset($filterData['gate_id_not']) && !empty($filterData['gate_id_not'])) {
            if (is_array($filterData['gate_id_not'])) {
                $builder->whereNotIn('tg.gate_id', $filterData['gate_id_not']);
            } else {
                $builder->where('tg.gate_id !=', $filterData['gate_id_not']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tg.society_id', $filterData['society_id']);
            } else {
                $builder->where('tg.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('tg.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('tg.tower_id', $filterData['tower_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['is_active'])){
            $builder->where('tg.is_active', $filterData['is_active']);
        }

        if(isset($filterData['is_delete'])){
            $builder->where('tg.is_delete', $filterData['is_delete']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('gate_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tg.gate_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($gateId)
    {
        $builder = $this->db->table('tbl_gate');
        $gateIdArray = is_array($gateId) ? $gateId : array($gateId);
        $builder->whereIn('gate_id', $gateIdArray);
        $data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
        // $builder->delete();
        $builder->update($data);
        if ($this->db->affectedRows()) {
            if(!empty($gateId)){
                foreach($gateId as $gate){
                    $deleteDataArray['module'] = 'Gate';
                    $deleteDataArray['activity'] = "Gate Deleted";
                    $deleteDataArray['module_id'] = $gate;
                    logActivity('Gate Deleted [GateID: ' . $gate . ']',$this->ionAuth->getUserId(),'Gate',$gate,json_encode($deleteDataArray),'','Gate',$gate);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getGate($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_gate as tg');
        //$builder->startCache();
        $builder->select("tg.gate_id as id,tg.gate_name as text,tg.tower_id");
        $builder->join("tbl_tower as tt","tt.tower_id = tg.tower_id","left");

        if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('tg.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('tg.tower_id', $filterData['tower_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tg.society_id', $filterData['society_id']);
            } else {
                $builder->where('tg.society_id', $filterData['society_id']);
            }
        }

        accessFilter($builder, array("society" => "tg.society_id"));
        $builder->groupBy("tg.gate_id");
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("tg.gate_name", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tg.is_active', $filterData['is_active']);
        }
        if(isset($filterData['is_delete'])){
            $builder->where('tg.is_delete', $filterData['is_delete']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        // $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        // $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}