<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class BrokerModel extends BaseModel
{

    public function getBrokerData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table(MASTER_DB.'.tbl_broker as tb');
        $builder->select("tb.*");

        if(isset($filterData['broker_id']) && !empty($filterData['broker_id'])) {
            if (is_array($filterData['broker_id'])) {
                $builder->whereIn('tb.broker_id', $filterData['broker_id']);
            } else {
                $builder->where('tb.broker_id', $filterData['broker_id']);
            }
        }
        if(isset($filterData['broker_phone_number']) && !empty($filterData['broker_phone_number'])) {
            if (is_array($filterData['broker_phone_number'])) {
                $builder->whereIn('tb.broker_phone_number', $filterData['broker_phone_number']);
            } else {
                $builder->where('tb.broker_phone_number', $filterData['broker_phone_number']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tb.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('broker_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tb.broker_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($brokerId)
    {
        $builder = $this->db->table('tbl_broker');
        $brokerIdArray = is_array($brokerId) ? $brokerId : array($brokerId);
        $builder->whereIn('broker_id', $brokerIdArray);
        $builder->delete();
        $builder = $this->db->table('tbl_broker_society');
        $builder->whereIn('broker_id', $brokerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($brokerId)){
                foreach($brokerId as $bank){
                    $deleteDataArray['module'] = 'Broker';
                    $deleteDataArray['activity'] = "Broker Deleted";
                    $deleteDataArray['module_id'] = $bank;
                    logActivity('Broker Deleted [BrokerID: ' . $bank . ']',$this->ionAuth->getUserId(),'Broker',$bank,json_encode($deleteDataArray),'','Broker',$bank);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }


    public function deleteFromSocietyRecord($brokerId, $societyId) {
    
        $builder = $this->db->table(MASTER_DB.'.tbl_broker_society');
        $brokerIdArray = is_array($brokerId) ? $brokerId : array($brokerId);
        $builder->whereIn('broker_id', $brokerIdArray);
        $builder->where('society_id', $societyId);
        $builder->delete();

    //    if ($this->db->affectedRows()) {
    //         if(!empty($brokerId)){
    //             foreach($brokerId as $broker){
    //                 $deleteDataArray['module'] = 'Broker Society';
    //                 $deleteDataArray['activity'] = "Broker Society Deleted";
    //                 $deleteDataArray['module_id'] = $broker;
    //                 logActivity('Broker Society Deleted [BrokerSocietyID: ' . $broker . ']',$this->ionAuth->getUserId(),'Broker',$broker,json_encode($deleteDataArray),'','Broker',$broker);
    //             }
    //         }
    //     }

        $response['success'] = false;
        // $logData = [];

        foreach ($brokerIdArray as $broker) {
            $builder = $this->db->table(MASTER_DB.'.tbl_broker_society');
            $builder->where('broker_id', $broker);
            $remainingRecords = $builder->countAllResults();

            if ($remainingRecords == 0) {
                $brokerBuilder = $this->db->table('tbl_broker');
                $brokerBuilder->where('broker_id', $broker);
                $brokerBuilder->delete();

                if ($this->db->affectedRows()) {
                    $deleteDataArray['module'] = 'Broker';
                    $deleteDataArray['activity'] = "Broker Deleted";
                    $deleteDataArray['module_id'] = $broker;
                    logActivity('Broker Deleted [BrokerID: ' . $broker . ']',$this->ionAuth->getUserId(),'Broker',$broker,json_encode($deleteDataArray),'','Broker',$broker);
                }
                $response['success'] = true;
            }
        }
        return $response;
    }


    function getBroker($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table(MASTER_DB.'.tbl_broker as tb');
        //$builder->startCache();
        $builder->select("tb.broker_id as id,COALESCE(tb.broker_name,'') as text,tb.broker_phone_number");
        $builder->join(MASTER_DB.".tbl_broker_society as tbs","tbs.broker_id = tb.broker_id","left");

        if(isset($filterData['broker_id']) && !empty($filterData['broker_id'])) {
            if (is_array($filterData['broker_id'])) {
                $builder->whereIn('tb.broker_id', $filterData['broker_id']);
            } else {
                $builder->where('tb.broker_id', $filterData['broker_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tb.broker_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tb.is_active', $filterData['is_active']);
        }
        accessFilter($builder, array("society" => "tbs.society_id"));
        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
    public function getBrokerSocietyData($filterData)
    {
        $builder = $this->db->table(MASTER_DB.'.tbl_broker_society as tbs');
        $builder->select("tbs.*,ts.society_name");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tbs.society_id","left");

        if(isset($filterData['broker_id']) && !empty($filterData['broker_id'])) {
            if (is_array($filterData['broker_id'])) {
                $builder->whereIn('tbs.broker_id', $filterData['broker_id']);
            } else {
                $builder->where('tbs.broker_id', $filterData['broker_id']);
            }
        }
        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();

            $builder->groupEnd();
        }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteSocietyRecord($brokerId){

        $builder = $this->db->table(MASTER_DB.'.tbl_broker_society');
        $brokerIdArray = is_array($brokerId) ? $brokerId : array($brokerId);
        $builder->whereIn('broker_id', $brokerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}