<?php
namespace App\Models;
use CodeIgniter\Model;
use Config\Database;
use App\Services\DatabaseService;

class BaseModel extends Model
{

    protected $db;
    protected $databaseService;
    protected $ionAuth;

    public function __construct()
    {
        parent::__construct();
        $this->session  = \Config\Services::session();
        $this->ionAuth  = new \App\Libraries\IonAuth();
        $filters = service('request')->getVar();
        $this->databaseService = new DatabaseService();


       
        $societyId = (!empty($filters['society_id']) && isset($filters['society_id'])) ? $filters['society_id'] : session()->get('society_id');
        $this->centralDB = \Config\Database::connect();
        if ($societyId) {
            $this->db = $this->databaseService->getTenantConnection($societyId);
        }
        // printArray($societyId,1);
        // if (!empty($filters['society_id']) && !empty($filters['is_db_connect'])) {
        //     $this->setTenantDBConnectionFromSociety($filters['society_id']);
        // }
    }

    protected function setTenantDBFromFilter($societyId)
    {
        if (!empty($societyId)) {
            $centralDB = \Config\Database::connect('default');
            $society = $centralDB->table('tbl_society')
                ->where('society_id', $societyId)
                ->get()
                ->getRow();

            if ($society) {
                $dbConfig = [
                    'DSN'      => '',
                    // 'hostname' => $society->db_host ?? 'localhost',
                    // 'username' => $society->db_user ?? 'root',
                    // 'password' => $society->db_pass ?? '',
               
                    'hostname' => DB_HOST,
                    'username' => DB_USER,
                    'password' => DB_PASS,
                    'database' => $society->db_name,
                    'DBDriver' => 'MySQLi',
                    'DBPrefix' => '',
                    'pConnect' => false,
                    'DBDebug'  => true,
                    'charset'  => 'utf8',
                    'DBCollat' => 'utf8_general_ci',
                    'swapPre'  => '',
                    'encrypt'  => false,
                    'compress' => false,
                    'strictOn' => false,
                    'failover' => [],
                    'port'     => 3306,
                ];
                $tenantDB = \Config\Database::connect($dbConfig, false);
                $this->db = $tenantDB;
            }
        }
    }

    public function insertUpdateRecord($dataArray, $columnName, $tableName, $returnWithId = 0, $returnCol = "", $escapedColumns = array(), $extraData = array(),$activityLogDataArray = array())
    {
        
        // printArray( $this->db,1);
        // printArray( $this->db,1);
        // $this->db->transStart();
        if(isset($extraData['is_api_data']) && !empty($extraData['is_api_data'])){
            $userId = isset($extraData['is_api_data']['api_user_id']) ? $extraData['is_api_data']['api_user_id'] : 0;
            $societyId = isset($extraData['is_api_data']['society_id']) ? $extraData['is_api_data']['society_id'] : 0;
        } else {
            $userId = $this->ionAuth->getUserId();
            $societyId = $this->session->get('society_id');
        }

        // printArray($this->db,1);
        $insertDataArray = $dataArray;
        $builder = $this->db->table($tableName);
        if ($dataArray[$columnName] != '') {
            updatedInfoMerge($dataArray, $userId);
            if(count($escapedColumns) > 0){
                foreach($escapedColumns as $escapedColumnName){
                    if(array_key_exists($escapedColumnName,$dataArray)){
                        $builder->set($escapedColumnName,$dataArray[$escapedColumnName],false);
                        unset($dataArray[$escapedColumnName]);
                    }
                }
            }
            $builder->where($columnName, $dataArray[$columnName]);
            $builder->update($dataArray);
            $response['lastInsertedId'] = $dataArray[$columnName];
            $affectedRows = $this->db->affectedRows();
            $dataArray = array_filter($dataArray);
            $logDetails = implode("",$dataArray);
            $logId =  $dataArray[$columnName];
            $logColumn = (isset($columnName)) ? ucwords(str_replace("_","",$columnName)) : "";
            $logModule = (isset($tableName) && $tableName != '') ? ucwords(str_replace("_"," ",str_replace("tbl_","",$tableName))) : "";
            if(!empty($activityLogDataArray)){
                $updateArray['old_data'] = $activityLogDataArray;
                $updateArray['new_data'] = $insertDataArray;
                $updateArray['module'] = $logModule;
                $updateArray['activity'] = $logModule . " Updated";
                $updateArray['module_id'] = $logId;
                $compareData = compareAndCreateNewArray($activityLogDataArray,$insertDataArray);
                $type = $logModule;
                $typeId = $logId;
                logActivity("".$logModule." Updated [$logColumn: $logId, $logDetails ]",$userId,$logModule,$logId,json_encode($updateArray),json_encode($compareData),$type,$typeId,$societyId);
            }
            else{
//                $type = $logModule;
//                $typeId = $logId;
//                logActivity("".$logModule." Updated [$logColumn: $logId, $logDetails ]",$userId,$logModule,$logId,'','',$type,$typeId,$societyId);
            }
        } else {
            createdInfoMerge($dataArray, $userId);
            if(count($escapedColumns) > 0){
                foreach($escapedColumns as $escapedColumnName){
                    if(array_key_exists($escapedColumnName,$dataArray)){
                        $builder->set($escapedColumnName,$dataArray[$escapedColumnName],false);
                        unset($dataArray[$escapedColumnName]);
                    }
                }
            }
            $builder->insert($dataArray);
            if ($returnWithId == 1 && $returnCol != '') {
                $response['lastInsertedId'] = $this->db->insertID();
                $response['DataValue'] = $dataArray[$returnCol];
            } else if ($returnWithId == 1) {
                $response['lastInsertedId'] = $this->db->insertID();
            }
            $affectedRows = $this->db->affectedRows();
            $dataArray = array_filter($dataArray);
            $logDetails = implode('',$dataArray);
            $logId =  $this->db->insertID();
            $logColumn = (isset($columnName)) ? ucwords(str_replace("_","",$columnName)) : "";
            $logModule = (isset($tableName) && $tableName != '') ? ucwords(str_replace("_"," ",str_replace("tbl_","",$tableName))) : "";
            $createArray['new_data'] = $insertDataArray;
            $createArray['module'] = $logModule;
            $createArray['activity'] = "New ". $logModule . " Created";
            $createArray['module_id'] = $logId;
            $type = $logModule;
            $typeId = $logId;
            logActivity("".$logModule." Add [$logColumn: $logId, $logDetails ]",$userId,$logModule,$logId,json_encode($createArray),'',$type,$typeId,$societyId);
        }
        if ($affectedRows > 0) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function statusChange($columnId, $status, $columnName, $tableName)
    {
        $data['is_active'] = $status;
        $builder = $this->db->table($tableName);
        $builder->where($columnName, $columnId);
        $return = $builder->update($data);
        //echo $this->db->getLastQuery();
        $logColumn = (isset($columnName)) ? ucwords(str_replace("_","",$columnName)) : "";
        $logModule = (isset($tableName) && $tableName != '') ? ucwords(str_replace("_"," ",str_replace("tbl_","",$tableName))) : "";
        $message = ($status == 1 ? 'Status Change From Inactive To Active' : 'Status Change From Active To Inactive');
        $statusChangeArray['module'] = $logModule;
        $statusChangeArray['activity'] = $logModule . " " . $message;
        $statusChangeArray['module_id'] = $columnId;
        $type = $logModule;
        $typeId = $columnId;
        logActivity($logModule." ".$message." [$logColumn: $columnId]",$this->ionAuth->getUserId(),$logModule,$columnId,json_encode($statusChangeArray),'',$type,$typeId);
        return $return;
    }

    public function batchInsert($dataArray, $tableName,$activityLogData = array())
    {
        // printArray($this->db,1);
        $builder = $this->db->table($tableName);
        $builder->insertBatch($dataArray);
        $lastId['lastInsertedId'] = $this->db->insertID();
        $firstId = $this->db->insertID();
        $affectedRows = $this->db->affectedRows();
        $lastsId = $firstId + ($affectedRows - 1);
        if ($this->db->affectedRows()) {
            if(!empty($activityLogData) && ( isset($activityLogData['module_id']) && $activityLogData['module_id'] != 0)) {
                foreach ($dataArray as $key => $value) {
                    $addData = $value;
                    $logModule = isset($activityLogData['module']) ? $activityLogData['module'] : '';
                    $userId = isset($activityLogData['user_id']) ? $activityLogData['user_id'] : '';
                    $newDataArray['module'] = $logModule;
                    $newDataArray['activity'] = "New " . $logModule . " Created";
                    $newDataArray['module_id'] = $firstId . "-" . $lastsId;
                    $newDataArray['new_data'] = $addData;
                    $dataArrayForActivityLog = json_encode($newDataArray);
                    //printArray($dataArrayForActivityLog,1);
                    $type = isset($activityLogData['type']) ? $activityLogData['type'] : '';
                    $typeId = isset($activityLogData['module_id']) ? $activityLogData['module_id'] : '';
                    $societyId = isset($activityLogData['society_id']) ? $activityLogData['society_id'] : '';
                    logActivity("Inserted Id " . $tableName . " From ID:[" . $firstId . "-" . $lastsId . "] Data[" . $dataArrayForActivityLog . "]", $userId, $logModule, $typeId, $dataArrayForActivityLog,'',$type,$typeId,$societyId);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function batchUpdate($dataArray, $columnName, $tableName,$activityLogData = array())
    {
        // printArray($this->db,1);
        $builder = $this->db->table($tableName);
        $builder->updateBatch($dataArray, $columnName);
        if ($this->db->affectedRows()) {
            if(!empty($activityLogData) && ( isset($activityLogData['module_id']) && $activityLogData['module_id'] != 0)) {
                $oldDataArrayIdWise = array();
                if (!empty($activityLogData['old_data'])) {
                    foreach ($activityLogData['old_data'] as $oldDataElement) {
                        $oldDataArrayIdWise[$oldDataElement[$columnName]] = $oldDataElement;
                    }
                }
                foreach ($dataArray as $key => $value) {
                    $documentUpdateData = array_key_exists($value[$columnName], $oldDataArrayIdWise) ? $oldDataArrayIdWise[$value[$columnName]] : array();
                    $documentUpdateArray = compareArray($value, $documentUpdateData);
                    $addNewDataArray = $value;
                    $dataArray = array_filter($value);
                    $logId = $dataArray[$columnName];
                    $logColumn = (isset($columnName)) ? ucwords(str_replace("_", "", $columnName)) : "";
                    $logModule = isset($activityLogData['module']) ? $activityLogData['module'] : '';
                    $updateDataArray['module'] = $logModule;
                    $updateDataArray['activity'] = $logModule . " Updated";
                    $updateDataArray['module_id'] = $logId;
                    $updateDataArray['old_data'] = $documentUpdateArray;
                    $updateDataArray['new_data'] = $addNewDataArray;
                    $dataArrayPreviousForActivityLog = json_encode($updateDataArray);
                    $compareData = compareAndCreateNewArray($documentUpdateArray, $addNewDataArray);
                    $type = isset($activityLogData['type']) ? $activityLogData['type'] : '';
                    $typeId =  isset($activityLogData['module_id']) ? $activityLogData['module_id'] : '';
                    $userId = isset($activityLogData['user_id']) ? $activityLogData['user_id'] : '';
                    logActivity("" . $logModule . " Updated [$logColumn: $logId, OldData : [ $dataArrayPreviousForActivityLog ] ] ", $userId, $logModule, $logId, $dataArrayPreviousForActivityLog, json_encode($compareData),$type,$typeId);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function insertUpdate($dataArray, $columnName, $tableName, $returnWithId = 0,$updateDataArray = array())
    {
        $insertDataArray = $dataArray;
        $builder = $this->db->table($tableName);
        if ($dataArray[$columnName] != '') {
            $builder->where($columnName, $dataArray[$columnName]);
            $builder->update($dataArray);
            if ($returnWithId == 1) {
                $response['lastInsertedId'] = $dataArray[$columnName];
            }
            $dataArray = array_filter($dataArray);
            $logDetails = implode("",$dataArray);
            $logId =  $dataArray[$columnName];
            $logColumn = (isset($columnName)) ? ucwords(str_replace("_","",$columnName)) : "";
            $logModule = (isset($tableName) && $tableName != '') ? ucwords(str_replace("_"," ",str_replace("tbl_","",$tableName))) : "";
            if(!empty($updateDataArray)){
                $updateArray['old_data'] = $updateDataArray;
                $updateArray['new_data'] = $insertDataArray;
                $updateArray['module'] = $logModule;
                $updateArray['activity'] = $logModule . " Updated";
                $updateArray['module_id'] = $logId;
                $compareData = compareAndCreateNewArray($updateDataArray,$insertDataArray);
                // $type = isset($updateDataArray['type']) ? $updateDataArray['type'] : '';
                // $typeId = isset($updateDataArray['type_id']) ? $updateDataArray['type_id'] : '';
                $type = $logModule;
                $typeId = $logId;
                logActivity("".$logModule." Updated [$logColumn: $logId, $logDetails ]",$this->ionAuth->getUserId(),$logModule,$logId,json_encode($updateArray),json_encode($compareData),$type,$typeId);
            }
        } else {
            $builder->insert($dataArray);
            if ($returnWithId == 1) {
                $response['lastInsertedId'] = $this->db->insertID();
            }
            $logDetails = implode("",$dataArray);
            $logId = $this->db->insertID();;
            $logColumn = (isset($columnName)) ? ucwords(str_replace("_","",$columnName)) : "";
            $logModule = (isset($tableName) && $tableName != '') ? ucwords(str_replace("_"," ",str_replace("tbl_","",$tableName))) : "";
            $insertDataArray = array_filter($dataArray);
            $createArray['new_data'] = $insertDataArray;
            $createArray['module'] = $logModule;
            $createArray['activity'] = "New ". $logModule . " Created";
            $createArray['module_id'] = $logId;
            // $type = isset($updateDataArray['type']) ? $updateDataArray['type'] : '';
            // $typeId = isset($updateDataArray['type_id']) ? $updateDataArray['type_id'] : '';
            $type = $logModule ;
            $typeId = $logId;
            // printArray($dataArray,1);
            logActivity("".$logModule." Add [$logColumn: $logId, $logDetails ]",$this->ionAuth->getUserId(),$logModule,$logId,json_encode($createArray),'',$type,$typeId);
        }
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}