<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class BannerModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getBannerData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_banner as tb');
        $builder->select("tb.*");
		if (isset($filterData['banner_id']) && !empty($filterData['banner_id'])) {
			if (is_array($filterData['banner_id'])) {
				$builder->whereIn('tb.banner_id', $filterData['banner_id']);
			} else {
				$builder->where('tb.banner_id', $filterData['banner_id']);
			}
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tb.society_id', $filterData['society_id']);
			} else {
				$builder->where('tb.society_id', $filterData['society_id']);
			}
		}

		if (isset($filterData['date_greater_than_equal_to']) && !empty($filterData['date_greater_than_equal_to'])) {
			if (is_array($filterData['date_greater_than_equal_to'])) {
				$builder->whereIn('tb.end_date  >= ', $filterData['date_greater_than_equal_to']);
			} else {
				$builder->where('tb.end_date  >= ', $filterData['date_greater_than_equal_to']);
			}
		}
		
		if(isset($filterData['is_active'])){
			$builder->where('tb.is_active', $filterData['is_active']);
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('banner_title', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tb.banner_id",'desc');
		$builder->groupBy('tb.banner_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($bannerId)
	{
		$builder = $this->db->table('tbl_banner');
        $bannerIdArray = is_array($bannerId) ? $bannerId : array($bannerId);
        $builder->whereIn('banner_id', $bannerIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($bannerId)){
				foreach($bannerId as $documentElement){
					$deleteDataArray['module'] = 'Banner';
					$deleteDataArray['activity'] = "Banner Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Banner Deleted [BannerID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Banner',$documentElement,json_encode($deleteDataArray),'','Banner',$documentElement);
				}
			}
			return true;
		}
		return false;
	}

	public function deleteBannerImage($bannerImageId)
    {
        $builder = $this->db->table('tbl_banner_image');
        $bannerImageIdArray = is_array($bannerImageId) ? $bannerImageId : array($bannerImageId);
        $builder->whereIn('banner_image_id', $bannerImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteDocumentImageRecord($filterData = array())
    {
        $builder = $this->db->table('tbl_document_image');
        $documentTypeIdArray = is_array($filterData['document_type_id']) ? $filterData['document_type_id'] : array($filterData['document_type_id']);
        $builder->where('document_type',$filterData['document_type']);
        $builder->whereIn('document_type_id',$documentTypeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}
?>
