<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class BankAccountModel extends BaseModel
{

    public function getBankAccountData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_bank_account as tba');
        $builder->select("tba.*,tb.bank_name");
        $builder->join("tbl_bank as tb","tb.bank_id = tba.bank_id","left");
        accessFilter($builder, array("society" => "tba.society_id"));

        if(isset($filterData['bank_account_id']) && !empty($filterData['bank_account_id'])) {
            if (is_array($filterData['bank_account_id'])) {
                $builder->whereIn('tba.bank_account_id', $filterData['bank_account_id']);
            } else {
                $builder->where('tba.bank_account_id', $filterData['bank_account_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tba.society_id', $filterData['society_id']);
            } else {
                $builder->where('tba.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tba.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tb.bank_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tba.bank_account_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($bankAccountId)
    {
        $builder = $this->db->table('tbl_bank_account');
        $bankAccountIdArray = is_array($bankAccountId) ? $bankAccountId : array($bankAccountId);
        $builder->whereIn('bank_account_id', $bankAccountIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($bankAccountId)){
                foreach($bankAccountId as $bankAccount){
                    $deleteDataArray['module'] = 'Bank Account';
                    $deleteDataArray['activity'] = "Bank Account Deleted";
                    $deleteDataArray['module_id'] = $bankAccount;
                    logActivity('Bank Account Deleted [BankAccountID: ' . $bankAccount . ']',$this->ionAuth->getUserId(),'Bank Account',$bankAccount,json_encode($deleteDataArray),'','Bank Account',$bankAccount);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getBankAccount($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_bank_account as tba');
        //$builder->startCache();
        $builder->select("tba.bank_account_id as id,CONCAT(COALESCE(tb.bank_name,''),'-',COALESCE(tba.bank_account_no,'')) as text,tb.bank_name,tba.branch,tba.ifsc_code");
        $builder->join("tbl_bank as tb","tb.bank_id = tba.bank_id","left");

        if(isset($filterData['bank_account_id']) && !empty($filterData['bank_account_id'])) {
            if (is_array($filterData['bank_account_id'])) {
                $builder->whereIn('tba.bank_account_id', $filterData['bank_account_id']);
            } else {
                $builder->where('tba.bank_account_id', $filterData['bank_account_id']);
            }
        }
        accessFilter($builder, array("society" => "tba.society_id"));
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("CONCAT(COALESCE(tb.bank_name,''),'-',COALESCE(tba.bank_account_no,''))", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tba.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        // printArray($result,1);
        return json_encode($result);
    }
}