<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class AMCModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getAmcData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_amc_detail as tad');

		$builder->select("tad.*");
		$builder->select("COALESCE(ts.society_name,'') as society_name");
		$builder->select("COALESCE(ti.item_name,'') as item_name");
		$builder->select("COALESCE(ta.amenities_name,'') as amenities_name");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->select("COALESCE(tfy.financial_year_prefix,'') as financial_year_prefix");
		$builder->select("COALESCE(tv.vendor_name,'') as vendor_name");
		$builder->select("GROUP_CONCAT(distinct(tvm.vendor_mobile_no) SEPARATOR ',') as vendor_mobile_no");
		
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tad.society_id","left");
		$builder->join("tbl_financial_year as tfy","tfy.financial_year_id = tad.financial_year_id","left");
		$builder->join("tbl_vendor as tv","tv.vendor_id = tad.vendor_id","left");
		$builder->join("tbl_vendor_mobile as tvm","tvm.vendor_id = tv.vendor_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tad.updated_by AND tupdate.society_id = tad.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tad.created_by AND tcreate.society_id = tad.society_id","left");

        $builder->join("tbl_amenities as ta","ta.amenities_id = tad.amenities_id","left");
        $builder->join("tbl_item as ti","ti.item_id = tad.item_id","left");

		if (isset($filterData['amc_id']) && !empty($filterData['amc_id'])) {
			if (is_array($filterData['amc_id'])) {
				$builder->whereIn('tad.amc_id', $filterData['amc_id']);
			} else {
				$builder->where('tad.amc_id', $filterData['amc_id']);
			}
		}

		if (isset($filterData['financial_year_id']) && !empty($filterData['financial_year_id'])) {
			if (is_array($filterData['financial_year_id'])) {
				$builder->whereIn('tad.financial_year_id', $filterData['financial_year_id']);
			} else {
				$builder->where('tad.financial_year_id', $filterData['financial_year_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			//$builder->like('member_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tad.is_active', $filterData['is_active']);
		}
		accessFilter($builder, array("society" => "tad.society_id"));
		$builder->groupBy('tad.amc_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($amcId)
	{
		$builder = $this->db->table('tbl_amc_detail');
        $amcIdArray = is_array($amcId) ? $amcId : array($amcId);
        $builder->whereIn('amc_id', $amcIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($amcId)){
				foreach($amcId as $documentElement){
					$deleteDataArray['module'] = 'AMC';
					$deleteDataArray['activity'] = "AMC Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('AMC Deleted [AMCID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'AMC',$documentElement,json_encode($deleteDataArray),'','AMC',$documentElement);
				}
			}
			return true;
		}
		return false;
	}

	function getAmc($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		// $this->db->start_cache();
		$builder = $this->db->table('tbl_amc_detail as tad');
		$builder->select("tad.amc_id as id,tad.particular as text,tad.period_from,tad.period_upto");
		$builder->where("tad.is_active", 1);

		if(isset($filterData['vendor_id']) && !empty($filterData['vendor_id'])) {
            if (is_array($filterData['vendor_id'])) {
                $builder->whereIn('tad.vendor_id', $filterData['vendor_id']);
            } else {
                $builder->where('tad.vendor_id', $filterData['vendor_id']);
            }
        }

		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tad.particular", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tad.amc_id","Desc");
		accessFilter($builder, array("society" => "tad.society_id"));
		// $builder->stop_cache();
		$totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
		// $builder->flush_cache();
		return json_encode($result);
	}




}
?>
