<?php
namespace App\Libraries;
class Dt_ci_file_upload
{
	public function UploadMultipleFile($fieldname, $maxsize, $uploadpath, $get_real_name = true, $ref_name = true, $extensions = false,$isUpload = true,$isCompress = false){
        $request    = \Config\Services::request();
		$uploadData = array();

		$filesCount = count($_FILES[$fieldname]['name']);
		$start = arrayKeyFirst($_FILES[$fieldname]['name']);
		$filesCount = ($start == 0) ? $filesCount : $start + $filesCount;
		if ($filesCount == 0) {
			return array('success' => false, 'title' => 'unsuccessful', 'message' => 'Please upload a file');
		}
		for ($i = $start; $i < $filesCount; $i++) {
			$_FILES['userFile']['name'] = $_FILES[$fieldname]['name'][$i];
			$_FILES['userFile']['type'] = $_FILES[$fieldname]['type'][$i];
			$_FILES['userFile']['tmp_name'] = $_FILES[$fieldname]['tmp_name'][$i];
			$_FILES['userFile']['error'] = $_FILES[$fieldname]['error'][$i];
			$_FILES['userFile']['size'] = $_FILES[$fieldname]['size'][$i];
//           File Extension Checking
			$file_extension = strtolower(pathinfo($_FILES['userFile']['name'], PATHINFO_EXTENSION));
//            echo $file_extension;
			if ($extensions !== false && is_array($extensions)) {
				if (!in_array($file_extension, $extensions)) {
					return array('title' => $_FILES['userFile']['name'], 'success' => false, 'message' => 'Please upload valid file');
				}
			}
//           File Size Checking
			$file_size = $_FILES['userFile']['size'];
			if ($file_size > $maxsize) {
				$uploadData['success'] = false;
				$uploadData['title'] = 'Error';
				$uploadData['message'] = 'File Exceeds maximum limit';
				return $uploadData;
			}
		}


		if($isUpload == true) {
            if ($imagefile = $request->getFiles()) {
                foreach ($imagefile[$fieldname] as $imgKey => $img) {
                    if ($img->isValid() && !$img->hasMoved()) {
                        $uploadData['success'] = true;
                        // $randomImgName = $img->getRandomName();
                        $ext = $img->getClientExtension(); // Preserve original extension
                        $randomImgName = time() . '_' . uniqid() . '.' . $ext;
                        $uploadData[$imgKey]['file_realname'] = $img->getName();
                        $uploadData[$imgKey]['file_name'] = $randomImgName;
                        $uploadData[$imgKey]['file_size'] = $img->getSize();
                        $img->move($uploadpath, $randomImgName);
                        if(!empty($isCompress)){
                            // Get original dimensions
                            $imagePath = $uploadpath . $randomImgName;
                            list($width, $height) = getimagesize($imagePath);
                            // Set new dimensions, adjust to desired size (50% reduction in this case)
                            $newWidth = $width * 0.5;
                            $newHeight = $height * 0.5;
                            // Compress the image
                            $imageService = \Config\Services::image();
                            try {
                                $imageService->withFile($imagePath)
                                             ->resize($newWidth, $newHeight, true, 'height') // Dynamically resize
                                             ->save($imagePath, 70); // Save with quality
                                $uploadData['message'] = 'File uploaded and compressed successfully.';
                            } catch (\Exception $e) {
                                $uploadData['success'] = false;
                                $uploadData['message'] = $e->getMessage();
                            }
                        }
                    } else {
                        $uploadData['success'] = false;
                        $uploadData['message'] = $img->getErrorString() . '(' . $img->getError() . ')';
                    }
                }
            }
		}
		return $uploadData;
	}

    public function ThumbnailMultipleUploadFile(array $fieldname, string $filepath, string $uploadpath) 
    {
        $response = []; // Initialize the response array outside the loop

        foreach ($fieldname as $field) {
            $file_path = $filepath . $field['file_name'];
            list($width, $height) = getimagesize($file_path);

            $x = $width - (int)($width * 0.5);
            $y = $height - (int)($height * 0.5);

            // Configuration for resizing to create thumbnail
            $resize_config = [
                'imageLibrary'  => 'gd2',
                'sourceImage'   => $file_path,
                'newImage'      => $uploadpath . $field['file_name'],
                'createThumb'   => true,
                'maintainRatio' => true,
                'thumbMarker'   => '',
                'width'         => $x,
                'height'        => $y
            ];

            // Load the image manipulation service
            $image = \Config\Services::image('gd'); // You can specify 'gd' or 'imagick' based on your server setup

            // Initialize the service with the current configuration
            if (!$image->withFile($file_path)
                        ->resize($x, $y, true)
                        ->save($uploadpath . $field['file_name'])) {
                // Handle resize error for each image
                $response[] = [
                    'status' => 'error',
                    'file_name' => $field['file_name'],
                    'errors' => $image->getError()
                ];
            } else {
                $response[] = [
                    'status' => 'success',
                    'file_name' => $field['file_name']
                ];
            }
        }

        return $response;
    }

    public function ThumbnailUploadFile(array $fileData, string $filepath, string $uploadpath) 
    {
        // Get the file path for the uploaded file
        $file_path = $filepath . $fileData['file_name'];
        
        // Get the image dimensions
        list($width, $height) = getimagesize($file_path);

        // Calculate new dimensions for the thumbnail
        $x = $width - (int)($width * 0.5); // 50% of the original width
        $y = $height - (int)($height * 0.5); // 50% of the original height

        // Configuration for resizing to create thumbnail
        $resize_config = [
            'imageLibrary'  => 'gd2',
            'sourceImage'   => $file_path,
            'newImage'      => $uploadpath . $fileData['file_name'],
            'createThumb'   => true,
            'maintainRatio' => true,
            'thumbMarker'   => '', // No additional marker for thumbnail
            'width'         => $x,
            'height'        => $y
        ];

        // Load the image manipulation service
        $image = \Config\Services::image('gd'); // 'gd' or 'imagick' can be used based on server setup

        // Try to resize and save the thumbnail
        if (!$image->withFile($file_path)
                    ->resize($x, $y, true) // Maintain aspect ratio while resizing
                    ->save($uploadpath . $fileData['file_name'])) {
            // Handle resize error
            return [
                'status' => 'error',
                'file_name' => $fileData['file_name'],
                'errors' => $image->getError() // Return error details
            ];
        }

        // Return success response if no errors occurred
        return [
            'status' => 'success',
            'file_name' => $fileData['file_name']
        ];
    }

    public function uploadFile($fieldname, $maxsize, $uploadpath, $get_real_name = true, $ref_name = true, $extensions = false,$isUpload = true,$isCompress = false){
        
        $request    = \Config\Services::request();
        $uploadData = array();

        $filesCount = count($_FILES);
        if ($filesCount == 0) {
            return array('success' => false, 'title' => 'unsuccessful', 'message' => 'Please upload a file');
        }

        $_FILES['userFile']['name'] = $_FILES[$fieldname]['name'];
        $_FILES['userFile']['type'] = $_FILES[$fieldname]['type'];
        $_FILES['userFile']['tmp_name'] = $_FILES[$fieldname]['tmp_name'];
        $_FILES['userFile']['error'] = $_FILES[$fieldname]['error'];
        $_FILES['userFile']['size'] = $_FILES[$fieldname]['size'];
        $file_extension = strtolower(pathinfo($_FILES['userFile']['name'], PATHINFO_EXTENSION));

        if ($extensions !== false && is_array($extensions)) {
            if (!in_array($file_extension, $extensions)) {
                return array('title' => $_FILES['userFile']['name'], 'success' => false, 'message' => 'Please upload valid file');
            }
        }

        if ($isUpload == true) {
            if ($img = $request->getFiles()) {
                if ($img[$fieldname]->isValid() && !$img[$fieldname]->hasMoved()) {
                    $uploadData['success'] = true;
                    $randomImgName = $img[$fieldname]->getRandomName();
                    $uploadData['file_realname'] = $img[$fieldname]->getName();
                    $uploadData['file_name'] = $randomImgName;
                    $uploadData['file_size'] = $img[$fieldname]->getSize();
                    $img[$fieldname]->move($uploadpath, $randomImgName);
                    if(!empty($isCompress)){
                        // Get original dimensions
                        $imagePath = $uploadpath . $randomImgName;
                        list($width, $height) = getimagesize($imagePath);
                        // Set new dimensions, adjust to desired size (50% reduction in this case)
                        $newWidth = $width * 0.5;
                        $newHeight = $height * 0.5;
                        // Compress the image
                        $imageService = \Config\Services::image();
                        try {
                            $imageService->withFile($imagePath)
                                         ->resize($newWidth, $newHeight, true, 'height') // Dynamically resize
                                         ->save($imagePath, 70); // Save with quality
                            $uploadData['message'] = 'File uploaded and compressed successfully.';
                        } catch (\Exception $e) {
                            $uploadData['success'] = false;
                            $uploadData['message'] = $e->getMessage();
                        }
                    }
                } else {
                    $uploadData['success'] = false;
                    $uploadData['message'] = $img->getErrorString() . '(' . $img->getError() . ')';
                }
            }
        }
        return $uploadData;
    }

    public function MultipleFileUpload($fieldName, $maxsize, $uploadPath, $getRealName = true, $refName = true, $extensions = false)
    {
        $request    = \Config\Services::request();
        $uploadData = array();
        $file = $_FILES[$fieldName];
        $filesCount = count($file['name']);

        if ($filesCount == 0) {
            return array('success' => false, 'title' => 'unsuccessful', 'msg' => 'Please upload a file');
        }

        foreach ($file['name'] as $key => $image) {
            if (is_array($image)) {
                foreach ($image as $imageKey => $imageElement) {
                    $_FILES['userFile']['name'][$key . "_" . $imageKey] = $file['name'][$key][$imageKey];
                    $_FILES['userFile']['type'][$key . "_" . $imageKey] = $file['type'][$key][$imageKey];
                    $_FILES['userFile']['tmp_name'][$key . "_" . $imageKey] = $file['tmp_name'][$key][$imageKey];
                    $_FILES['userFile']['error'][$key . "_" . $imageKey] = $file['error'][$key][$imageKey];
                    $_FILES['userFile']['size'][$key . "_" . $imageKey] = $file['size'][$key][$imageKey];
                    //           File Extension Checking
                    $file_extension = strtolower(pathinfo($_FILES['userFile']['name'][$key . "_" . $imageKey], PATHINFO_EXTENSION));

                    if ($extensions !== false && is_array($extensions)) {
                        if (!in_array($file_extension, $extensions)) {
                            return array('title' => $_FILES['userFile']['name'][$key . "_" . $imageKey], 'success' => false, 'message' => 'Please upload valid file');
                        }
                    }
                    //           File Size Checking
                    $file_size = $_FILES['userFile']['size'][$key . "_" . $imageKey];
                    if ($file_size > $maxsize) {
                        $uploadData['success'] = false;
                        $uploadData['title'] = 'Error';
                        $uploadData['message'] = 'File Exceeds maximum limit';
                        return $uploadData;
                    }
                }
            }
        }
        if ($imagefile = $request->getFiles($fieldName)) {
            foreach ($imagefile[$fieldName] as $imgKey => $imgElement) {
                if (!empty($imgElement)) {
                    foreach ($imgElement as $imageKey => $img) {
                        if ($img->isValid() && !$img->hasMoved()) {
                            $uploadData['success'] = true;
                            $randomImgName = $img->getRandomName();
                            $uploadData[$imgKey . "_" . $imageKey]['file_realname'] = $img->getName();
                            $uploadData[$imgKey . "_" . $imageKey]['file_name'] = $randomImgName;
                            $uploadData[$imgKey . "_" . $imageKey]['file_size'] = $img->getSize();
                            $img->move($uploadPath, $randomImgName);
                        } else {
                            $uploadData['success'] = false;
                            $uploadData['message'] = $img->getErrorString() . '(' . $img->getError() . ')';
                        }
                    }
                }
            }
        }
        return $uploadData;
    }
}
