<?php
namespace App\Libraries;
use CodeIgniter\Database\BaseConnection;
/**
 * Ignited Datatables
 *
 * This is a wrapper class/library based on the native Datatables server-side implementation by Allan Jardine
 * found at http://datatables.net/examples/data_sources/server_side.html for CodeIgniter
 *
 * @package    CodeIgniter
 * @subpackage libraries
 * @category   library
 * @version    2.0 <beta>
 * @author     Vincent Bambico <metal.conspiracy@gmail.com>
 *             Yusuf Ozdemir <yusuf@ozdemir.be>
 * @link       http://ellislab.com/forums/viewthread/160896/
 */
class Datatables
{
	/**
	 * Global container variables for chained argument results
	 *
	 */
	private $ci;
	private $db;
	private $builder;
	private $table;
	private $distinct;
	private $groupBy       = array();
	private $groupStart    = array();
	private $orGroupStart  = array();
	private $groupEnd      = array();

	private $select         = array();
	private $joins          = array();
	private $columns        = array();
	private $where          = array();
	private $having          = array();
	private $orWhere       = array();
	private $whereIn       = array();
	private $orWhereIn       = array();
	private $like           = array();
	private $orLike        = array();
	private $filter         = array();
	private $addColumns    = array();
	private $editColumns   = array();
	private $unsetColumns  = array();
	private $request;

	/**
	 * Copies an instance of CI
	 */
	// public function __construct()
	// {
	// 	//$this->ci =& get_instance();
	// 	$this->db = \Config\Database::connect();
    //     //$this->builder = $this->db->table('tbl_product_category as tpc');
    //     $this->builder = '';
    //     $this->request = \Config\Services::request();
	// }
	// protected $db;
	// public function __construct(BaseConnection $db = null)
    // {
    //     $this->db = $db ?? \Config\Database::connect(); // fallback to default
    //     $this->builder = '';
    //     $this->request = \Config\Services::request();
    // }

    public function __construct(BaseConnection $db = null)
    {
        $this->db = $db ?? \Config\Database::connect(); // default tenant db


        // printArray($this->db,1);
        $this->builder = null;
        $this->request = \Config\Services::request();
    }


    /**
     * Generates the FROM portion of the query
     *
     * @param string $table
     * @return mixed
     */
    public function table($table)
    {
        // printArray($table,1);
        //$this->table = $table;
        $this->builder = $this->db->table($table);
        return $this;
    }

	/**
	 * If you establish multiple databases in config/database.php this will allow you to
	 * set the database (other than $active_group) - more info: http://ellislab.com/forums/viewthread/145901/#712942
	 */
	public function set_database($db_name)
	{
		$db_data = $this->ci->load->database($db_name, TRUE);
		$this->ci->db = $db_data;
	}




	/**
	 * Generates the SELECT portion of the query
	 *
	 * @param string $columns
	 * @param bool $backtick_protect
	 * @return mixed
	 */
	public function select($columns, $backtick_protect = TRUE)
	{

		foreach($this->explode(',', $columns) as $val)
		{

			/*GROUP CONCAT FIX DIGITATTVA*/
			$finder = strpos($val,"GROUP_CONCAT");

			$column = trim(preg_replace('/(.*)\s+as\s+(\w*)/i', '$2', $val));
			$column = preg_replace('/.*\.(.*)/i', '$1', $column); // get name after `.`
			$this->columns[] =  $column;
//        $this->select[$column] =  trim(preg_replace('/(.*)\s+as\s+(\w*)/i', '$1', $val));

			if ($finder !== false){
				$this->select[$column] =  trim(preg_replace('/(.*)\s+as\s+(\w*)/i', '$2', $val));
			}else{
				$this->select[$column] =  trim(preg_replace('/(.*)\s+as\s+(\w*)/i', '$1', $val));
			}

		}

		$this->builder->select($columns, $backtick_protect);
		return $this;
	}

	/**
	 * Generates the DISTINCT portion of the query
	 *
	 * @param string $column
	 * @return mixed
	 */
	public function distinct($column)
	{
		$this->distinct = $column;
		$this->builder->distinct($column);
		return $this;
	}

	/**
	 * Generates a custom GROUP BY portion of the query
	 *
	 * @param string $val
	 * @return mixed
	 */
	public function groupBy($val)
	{
		$this->groupBy[] = $val;
		$this->builder->groupBy($val);
		return $this;
	}


	/**
	 * Generates the JOIN portion of the query
	 *
	 * @param string $table
	 * @param string $fk
	 * @param string $type
	 * @return mixed
	 */
	public function join($table, $fk, $type = NULL)
	{
		$this->joins[] = array($table, $fk, $type);
		$this->builder->join($table, $fk, $type);
		return $this;
	}

	// public function join($table, $fk, $type = null)
	// {
	//     $masterDBTables = ['tbl_users', 'tbl_society'];

	//     // Extract base table name and alias
	//     if (stripos($table, ' as ') !== false) {
	//         [$realTable, $alias] = preg_split('/\s+as\s+/i', $table);
	//     } else {
	//         $realTable = $table;
	//         $alias = $realTable;
	//     }

	//     // Trim and lowercase for consistent comparison
	//     $realTableTrimmed = strtolower(trim($realTable));

	//     if (in_array($realTableTrimmed, array_map('strtolower', $masterDBTables))) {
	//         $qualifiedTable = MASTER_DB . '.' . trim($realTable);
	//         if (strtolower($alias) !== $realTableTrimmed) {
	//             $qualifiedTable .= ' AS ' . trim($alias);
	//         }
	//         $this->builder->join($qualifiedTable, $fk, $type);
	//     } else {
	//         // For tables in the current (tenant) database
	//         $this->builder->join($table, $fk, $type);
	//     }
	//     return $this;
	// }


	/**
	 * Generates the WHERE portion of the query
	 *
	 * @param mixed $key_condition
	 * @param string $val
	 * @param bool $backtick_protect
	 * @return mixed
	 */
	public function where($key_condition, $val = NULL, $backtick_protect = TRUE)
	{
		$this->where[] = array($key_condition, $val, $backtick_protect);
		$this->builder->where($key_condition, $val, $backtick_protect);
		return $this;
	}

	public function having($key_condition, $val = NULL, $backtick_protect = TRUE)
	{
		$this->having[] = array($key_condition, $val, $backtick_protect);
		$this->builder->having($key_condition, $val, $backtick_protect);
		return $this;
	}

	/**
	 * Generates the WHERE portion of the query
	 *
	 * @param mixed $key_condition
	 * @param string $val
	 * @param bool $backtick_protect
	 * @return mixed
	 */
	public function orWhere($key_condition, $val = NULL, $backtick_protect = TRUE)
	{
		$this->orWhere[] = array($key_condition, $val, $backtick_protect);
		$this->builder->orWhere($key_condition, $val, $backtick_protect);
		return $this;
	}

	/**
	 * Generates the WHERE IN portion of the query
	 *
	 * @param mixed $key_condition
	 * @param string $val
	 * @param bool $backtick_protect
	 * @return mixed
	 */
	public function whereIn($key_condition, $val = NULL)
	{
		$this->whereIn[] = array($key_condition, $val);
		$this->builder->whereIn($key_condition, $val);
		return $this;
	}


	public function orWhereIn($key_condition, $val = NULL)
	{
		$this->orWhereIn[] = array($key_condition, $val);
		$this->builder->orWhereIn($key_condition, $val);
		return $this;
	}

	/**
	 * Generates the WHERE portion of the query
	 *
	 * @param mixed $key_condition
	 * @param string $val
	 * @param bool $backtick_protect
	 * @return mixed
	 */
	public function filter($key_condition, $val = NULL, $backtick_protect = TRUE)
	{
		$this->filter[] = array($key_condition, $val, $backtick_protect);
		return $this;
	}

	/**
	 * Generates a %LIKE% portion of the query
	 *
	 * @param mixed $key_condition
	 * @param string $val
	 * @param bool $backtick_protect
	 * @return mixed
	 */
	public function like($key_condition, $val = NULL, $side = 'both')
	{
		$this->like[] = array($key_condition, $val, $side);
		$this->builder->like($key_condition, $val, $side);
		return $this;
	}

	/**
	 * Generates the OR %LIKE% portion of the query
	 *
	 * @param mixed $key_condition
	 * @param string $val
	 * @param bool $backtick_protect
	 * @return mixed
	 */
	public function orLike($key_condition, $val = NULL, $side = 'both')
	{
		$this->orLike[] = array($key_condition, $val, $side);
		$this->builder->orLike($key_condition, $val, $side);
		return $this;
	}

	/**
	 * Sets additional column variables for adding custom columns
	 *
	 * @param string $column
	 * @param string $content
	 * @param string $match_replacement
	 * @return mixed
	 */
	public function addColumn($column, $content, $match_replacement = NULL)
	{
		$this->addColumns[$column] = array('content' => $content, 'replacement' => $this->explode(',', $match_replacement));
		return $this;
	}

	/**
	 * Sets additional column variables for editing columns
	 *
	 * @param string $column
	 * @param string $content
	 * @param string $match_replacement
	 * @return mixed
	 */
	public function editColumn($column, $content, $match_replacement)
	{
		$this->editColumns[$column][] = array('content' => $content, 'replacement' => $this->explode(',', $match_replacement));
		return $this;
	}

	/**
	 * Unset column
	 *
	 * @param string $column
	 * @return mixed
	 */
	public function unsetColumn($column)
	{
		$column=explode(',',$column);
		$this->unsetColumns=array_merge($this->unsetColumns,$column);
		return $this;
	}

	/**
	 * Builds all the necessary query segments and performs the main query based on results set from chained statements
	 *
	 * @param string $output
	 * @param string $charset
	 * @return string
	 */
	public function generate($output = 'json', $charset = 'UTF-8')
	{
		if(strtolower($output) == 'json')
			$this->get_paging();

		$this->get_ordering();
		$this->get_filtering();

		return $this->produce_output(strtolower($output), strtolower($charset));
	}

	/**
	 * Generates the LIMIT portion of the query
	 *
	 * @return mixed
	 */
	private function get_paging()
	{
		//$iStart = $this->ci->input->post('start');
		//$iLength = $this->ci->input->post('length');

        $iStart = $this->request->getPost('start');
        $iLength = $this->request->getPost('length');

		if($iLength != '' && $iLength != '-1')
		{
//          echo "HHHHHH";
			$this->builder->limit($iLength, ($iStart)? $iStart : 0);
		}
	}

	/**
	 * Generates the ORDER BY portion of the query
	 *
	 * @return mixed
	 */
	private function get_ordering()
	{

		//$Data = $this->ci->input->post('columns');
		$Data = $this->request->getPost('columns');


//		if ($this->ci->input->post('order'))
//			foreach ($this->ci->input->post('order') as $key)

                if ($this->request->getPost('order'))
                    foreach ($this->request->getPost('order') as $key)

				if($this->check_cType())
					$this->builder->orderBy($Data[$key['column']]['data'], $key['dir']);
				else
					$this->builder->orderBy($this->columns[$key['column']] , $key['dir']);

	}

	/**
	 * Generates a %LIKE% portion of the query
	 *
	 * @return mixed
	 */
	private function get_filtering()
	{

		//$mColArray = $this->ci->input->post('columns');
		$mColArray = $this->request->getPost('columns') ?? $this->request->getGet('columns');
		$sWhere = '';
		$qHaving = '';
		//$search = $this->ci->input->post('search');
		$search = $this->request->getPost('search');
		$sSearch = trim($search['value'] ?? '');
		$columns = array_values(array_diff($this->columns, $this->unsetColumns));

		if($sSearch != ''){
			for($i = 0; $i < count($mColArray); $i++){
				if($mColArray[$i]['searchable'] == 'true')
					if($this->check_cType())
						$sWhere .= $this->select[$mColArray[$i]['data']] . " LIKE '%" . $sSearch . "%' OR ";
					else
						$sWhere .= $this->select[$this->columns[$i]] . " LIKE '%" . $sSearch . "%' OR ";
				//  if($this->check_cType()) {
//                            if( strpos($this->select[$mColArray[$i]['data']], 'CONCAT') !== false ) continue;
//                            $sWhere .= $this->select[$mColArray[$i]['data']] . " LIKE '%" . $sSearch . "%' OR ";
//                        } else {
//                            if (strpos($this->select[$mColArray[$i]['data']], 'CONCAT') !== false ) continue;
//                            $sWhere .= $this->select[$this->columns[$i]] . " LIKE '%" . $sSearch . "%' OR ";
//                        }

//                    if (strpos($this->select[$mColArray[$i]['data']],"GROUP_CONCAT") === false) {
//                        $sWhere .= $this->select[$mColArray[$i]['data']] . " LIKE '%" . $sSearch . "%' OR ";
//                    } else {
//                        $qHaving .= $this->select[$mColArray[$i]['data']] . " LIKE '%" . $sSearch . "%' OR ";
//                    }


			}
			$sWhere = substr_replace($sWhere, '', -3);
			//  $qHaving = substr_replace($qHaving, '', -3);
			if($sWhere != '')
				$this->builder->where('(' . $sWhere . ')');


//            if($qHaving != '') {
//                $this->builder->having('(' . $qHaving . ')');
//                $sWhere = '';
//            }

		}

		$sWhere = '';
		for($i = 0; $i < count($mColArray); $i++){
			$sSearch = (trim($mColArray[$i]['search']['value']));
			if($mColArray[$i]['searchable'] == 'true' && !empty($sSearch) )
				if($this->check_cType())
					$sWhere .= $this->select[$mColArray[$i]['data']] . " LIKE '%" . $sSearch . "%' AND ";
				else
					$sWhere .= $this->select[$this->columns[$i]] . " LIKE '%" . $sSearch . "%' AND ";
		}
		$sWhere = substr_replace($sWhere, '', -4);

		if($sWhere != '')
			$this->builder->where('(' . $sWhere . ')');

		// TODO : sRangeSeparator

		foreach($this->filter as $val)
			$this->builder->where($val[0], $val[1], $val[2]);

	}

	/**
	 * Compiles the select statement based on the other functions called and runs the query
	 *
	 * @return mixed
	 */
	private function get_display_result()
	{
		return $this->builder->get();
	}

	/**
	 * Builds an encoded string data. Returns JSON by default, and an array of aaData if output is set to raw.
	 *
	 * @param string $output
	 * @param string $charset
	 * @return mixed
	 */
	private function produce_output($output, $charset)
	{
		$aaData = array();
		$rResult = $this->get_display_result();
//		echo "<pre>"; printArray($rResult); die();
		 // echo "<pre>";echo  $this->last_query();die();

		if($output == 'json')
		{
			$iTotal = $this->get_total_results();
			$iFilteredTotal = $this->get_total_results(TRUE);
		}



		foreach($rResult->getResultArray() as $row_key => $row_val)
		{
			$aaData[$row_key] =  ($this->check_cType())? $row_val : array_values($row_val);

			foreach($this->addColumns as $field => $val)
				if($this->check_cType())
					$aaData[$row_key][$field] = $this->exec_replace($val, $aaData[$row_key]);
				else
					$aaData[$row_key][] = $this->exec_replace($val, $aaData[$row_key]);


			foreach($this->editColumns as $modkey => $modval)
				foreach($modval as $val)
					$aaData[$row_key][($this->check_cType())? $modkey : array_search($modkey, $this->columns)] = $this->exec_replace($val, $aaData[$row_key]);

			$aaData[$row_key] = array_diff_key($aaData[$row_key], ($this->check_cType())? $this->unsetColumns : array_intersect($this->columns, $this->unsetColumns));

			if(!$this->check_cType())
				$aaData[$row_key] = array_values($aaData[$row_key]);

		}

		if($output == 'json')
		{
			$sOutput = array
			(
				//'draw'                => intval($this->ci->input->post('draw')),
				'draw'                => intval($this->request->getPost('draw')),
				'recordsTotal'        => $iTotal,
//				'recordsTotal'        =>5,
				'recordsFiltered'     => $iFilteredTotal,
				'data'                => $aaData
			);

			if($charset == 'utf-8')
				return json_encode($sOutput);
			else
				return $this->jsonify($sOutput);
		}
		else
			return array('aaData' => $aaData);
	}

	/**
	 * Get result count
	 *
	 * @return integer
	 */
	private function get_total_results($filtering = FALSE)
	{
		if($filtering){
            $this->get_filtering();
        }


		foreach($this->joins as $val)
			$this->builder->join($val[0], $val[1], $val[2]);

		foreach($this->where as $val)
			$this->builder->where($val[0], $val[1], $val[2]);

		foreach($this->having as $val)
			$this->builder->having($val[0], $val[1], $val[2]);

		foreach($this->orWhere as $val)
			$this->builder->orWhere($val[0], $val[1], $val[2]);

		foreach($this->whereIn as $val)
			$this->builder->whereIn($val[0], $val[1]);

		foreach($this->orWhereIn as $val)
			$this->builder->orWhereIn($val[0], $val[1]);

		foreach($this->groupBy as $val)
			$this->builder->groupBy($val);


		foreach($this->like as $val)
			$this->builder->like($val[0], $val[1], $val[2]);

		foreach($this->orLike as $val)
			$this->builder->orLike($val[0], $val[1], $val[2]);

		if(strlen($this->distinct) > 0)
		{
			$this->builder->distinct($this->distinct);
			$this->builder->select($this->columns);
		}

		//$query = $this->builder->get($this->table, NULL, NULL, FALSE);
       // $totalRows = $this->builder->countAllResults(false);
		$query = $this->builder->get();

////
//        echo "<pre>";
//        printArray($query->getNumRows());
//        echo "</pre>";
//
//        ///echo  "dsdsdd".$this->builder->countAllResults(false);
////        echo  "dsdsdd".$this->builder->countAll();
////        $totalRows = $this->builder->countAll();
//
//        echo "<pre>";
//        echo $this->db->getLastQuery();
//        echo "</pre>";
//
//		return 5;
		return $query->getNumRows();
	}

	/**
	 * Runs callback functions and makes replacements
	 *
	 * @param mixed $custom_val
	 * @param mixed $row_data
	 * @return string $custom_val['content']
	 */
	private function exec_replace($custom_val, $row_data)
	{
		//echo "<pre>";print_r($custom_val)." ";
		$replace_string = '';

		// Go through our array backwards, else $1 (foo) will replace $11, $12 etc with foo1, foo2 etc
		$custom_val['replacement'] = array_reverse($custom_val['replacement'], true);

		if(isset($custom_val['replacement']) && is_array($custom_val['replacement']))
		{
			//Added this line because when the replacement has over 10 elements replaced the variable "$1" first by the "$10"
			$custom_val['replacement'] = array_reverse($custom_val['replacement'], true);
			foreach($custom_val['replacement'] as $key => $val)
			{
				$sval = preg_replace("/(?<!\w)([\'\"])(.*)\\1(?!\w)/i", '$2', trim($val));

				if(preg_match('/(\w+::\w+|\w+)\((.*)\)/i', $val, $matches) && is_callable($matches[1]))
				{
					$func = $matches[1];
					$args = preg_split("/[\s,]*\\\"([^\\\"]+)\\\"[\s,]*|" . "[\s,]*'([^']+)'[\s,]*|" . "[,]+/", $matches[2], 0, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE);

					foreach($args as $args_key => $args_val)
					{
						$args_val = preg_replace("/(?<!\w)([\'\"])(.*)\\1(?!\w)/i", '$2', trim($args_val));
						$args[$args_key] = (in_array($args_val, $this->columns))? ($row_data[($this->check_cType())? $args_val : array_search($args_val, $this->columns)]) : $args_val;
					}

					$replace_string = call_user_func_array($func, $args);
				}
				elseif(in_array($sval, $this->columns))
					$replace_string = $row_data[($this->check_cType())? $sval : array_search($sval, $this->columns)];
				else
					$replace_string = $sval;

				$custom_val['content'] = str_ireplace('$' . ($key + 1), $replace_string, $custom_val['content']);
			}
		}

		$customValConArr = explode('|', $custom_val['content']);
		if(count($customValConArr) >  0 && $customValConArr[0] == "evaluate"){
			$custom_val['content'] = eval($customValConArr[1]);
		}

		return $custom_val['content'];
	}

	/**
	 * Check column type -numeric or column name
	 *
	 * @return bool
	 */
	private function check_cType()
	{
		//$column = $this->ci->input->post('columns');
        $column = $this->request->getPost('columns') ?? $this->request->getGet('columns');
		if(is_numeric($column[0]['data']))
			return FALSE;
		else
			return TRUE;
	}


	/**
	 * Return the difference of open and close characters
	 *
	 * @param string $str
	 * @param string $open
	 * @param string $close
	 * @return string $retval
	 */
	private function balanceChars($str, $open, $close)
	{
		$openCount = substr_count($str, $open);
		$closeCount = substr_count($str, $close);
		$retval = $openCount - $closeCount;
		return $retval;
	}

	/**
	 * Explode, but ignore delimiter until closing characters are found
	 *
	 * @param string $delimiter
	 * @param string $str
	 * @param string $open
	 * @param string $close
	 * @return mixed $retval
	 */
	private function explode($delimiter, $str, $open = '(', $close=')')
	{
		$retval = array();
		$hold = array();
		$balance = 0;
		$parts = explode($delimiter, $str);

		foreach($parts as $part)
		{
			$hold[] = $part;
			$balance += $this->balanceChars($part, $open, $close);

			if($balance < 1)
			{
				$retval[] = implode($delimiter, $hold);
				$hold = array();
				$balance = 0;
			}
		}

		if(count($hold) > 0)
			$retval[] = implode($delimiter, $hold);

		return $retval;
	}

	/**
	 * Workaround for json_encode's UTF-8 encoding if a different charset needs to be used
	 *
	 * @param mixed $result
	 * @return string
	 */
	private function jsonify($result = FALSE)
	{
		if(is_null($result))
			return 'null';

		if($result === FALSE)
			return 'false';

		if($result === TRUE)
			return 'true';

		if(is_scalar($result))
		{
			if(is_float($result))
				return floatval(str_replace(',', '.', strval($result)));

			if(is_string($result))
			{
				static $jsonReplaces = array(array('\\', '/', '\n', '\t', '\r', '\b', '\f', '"'), array('\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'));
				return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $result) . '"';
			}
			else
				return $result;
		}

		$isList = TRUE;

		for($i = 0, reset($result); $i < count($result); $i++, next($result))
		{
			if(key($result) !== $i)
			{
				$isList = FALSE;
				break;
			}
		}

		$json = array();

		if($isList)
		{
			foreach($result as $value)
				$json[] = $this->jsonify($value);

			return '[' . join(',', $json) . ']';
		}
		else
		{
			foreach($result as $key => $value)
				$json[] = $this->jsonify($key) . ':' . $this->jsonify($value);

			return '{' . join(',', $json) . '}';
		}
	}

	/**
	 * returns the sql statement of the last query run
	 * @return type
	 */
	public function last_query()
	{
		return  $this->db->getLastQuery();
	}
	public function groupStart($not = '', $type = 'AND ')
	{
		$this->builder->groupStart($not, $type);
		return $this;
	}

	public function orGroupStart()
	{
		$this->builder->orGroupStart();
		return $this;
	}

	public function groupEnd()
	{
		$this->builder->groupEnd();
		return $this;
	}

}
/* End of file Datatables.php */
/* Location: ./application/libraries/Datatables.php */
