<?php
use CodeIgniter\Database\Config;
use CodeIgniter\Database\BaseConnection;

function getTenantDB(): BaseConnection
{
    $request = \Config\Services::request();
    $session = \Config\Services::session();
    $sessionSocietyId = $session->get('society_id');

    $apiSocietyId = $request->getPost('society_id'); 
   
    if(!empty($sessionSocietyId)){
        $societyId = $sessionSocietyId;
    }
    else if(!empty($apiSocietyId)){
        $societyId = $apiSocietyId;
    }
    else{
         return  \Config\Database::connect();
    }

    if(!empty($societyId)){
        $centralDB = \Config\Database::connect();

        $society = $centralDB->table('tbl_society')
            ->where('society_id', $societyId)
            ->get()
            ->getRowArray();
        $dbConfig = [
            'DSN'      => '',
            // 'hostname' => $society['db_host'] ?? 'localhost:3310',
            // 'username' => $society['db_user'] ?? 'root',
            // 'password' => $society['db_pass'] ?? '',
            'hostname' => DB_HOST,
            'username' => DB_USER,
            'password' => DB_PASS,
       
            'database' => $society['db_name'],
            'DBDriver' => 'MySQLi',
            'DBPrefix' => '',
            'pConnect' => false,
            'DBDebug'  => true,
            'charset'  => 'utf8',
            'DBCollat' => 'utf8_general_ci',
            'swapPre'  => '',
            'encrypt'  => false,
            'compress' => false,
            'strictOn' => false,
            'failover' => [],
            'port'     => 3306,
            'numberNative' => false,
            'dateFormat'   => [
                'date'     => 'Y-m-d',
                'datetime' => 'Y-m-d H:i:s',
                'time'     => 'H:i:s',
            ],
        ];

        return \Config\Database::connect($dbConfig, false); // false = don't override default
    }
    else{
       return  \Config\Database::connect(); 
    }
}
