<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use OneSignal\Config;
use OneSignal\OneSignal;
use App\Models\ResourceTypeModel;

//$CI4 = new \App\Controllers\BaseController;
if (!function_exists('printArray')) {
    function printArray($array, $die = false)
    {
        echo "<pre>";
        print_r($array);
        echo "</pre>";
        if ($die) {
            die();
        }
    }
}

if (!function_exists('updatedInfoMerge')) {
    function updatedInfoMerge(&$data, $userId, $escape = false)
    {
        $data = array_map('trim', $data);
        $data['updated_by'] = $userId;
        if ($escape == true) {
            $data['updated_at'] = "'" . date('Y-m-d H:i:s') . "'";
        } else {
            $data['updated_at'] = date('Y-m-d H:i:s');
        }
    }
}

if (!function_exists('createdInfoMerge')) {
    function createdInfoMerge(&$data, $userId, $escape = false)
    {
        $data = array_map('trim', $data);
        $data = array_map('trim', $data);
        $data['created_by'] = $userId;
        $data['updated_by'] = $userId;
        if ($escape == true) {
            $data['created_at'] = "'" . date('Y-m-d H:i:s') . "'";
            $data['updated_at'] = "'" . date('Y-m-d H:i:s') . "'";
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['updated_at'] = date('Y-m-d H:i:s');
        }
    }
}

if (!function_exists('lastQuery')) {
    function lastQuery($die = true)
    {
        $db = \Config\Database::connect();
        echo "<pre>";
        echo $db->getLastQuery();
        echo "</pre>";
        if($die)
            die();
    }
}

if (!function_exists('lastQueryTenent')) {
    function lastQueryTenent($obj  = '',$die = true)
    {
        echo "<pre>";
        echo $obj->getLastQuery();
        echo "</pre>";
        if($die)
            die();
    }
}

if(!function_exists('transactionType')){
    function transactionType()
    {
        $transactionTypes = array(
            "debit" => 'Debit',
            "credit"=> 'Credit'

        );
        return $transactionTypes;
    }
}

if(!function_exists('accountType')){
    function accountType()
    {
        $accountTypes = array(
            "expense" => 'Expense',
            "income"=> 'Income'

        );
        return $accountTypes;
    }
}

if(!function_exists('taxType')){
    function taxType()
    {
        $taxType = array(
          "fixed" => "Fixed",
          "percentage"=>"Precentage",
    );
    return $taxType;
    }
}

if(!function_exists('dayType')){
    function dayType()
    {
        $dayType = array(
          "days" => "Days",
          "hours"=> "Hours",
    );
    return $dayType;
    }
}

if(!function_exists('timeType')){
    function timeType()
    {
        $timeType = array(
          "minutes" => "Minutes",
          "hours"=> "Hours",
    );
    return $timeType;
    }
}

if(!function_exists('amenitiesStatus')){
    function amenitiesStatus()
    {
        $amenitiesStatus = array(
          "approved" => "Approved",
          "pending"=> "Pending",
          "rejected"=> "Rejected",
    );
    return $amenitiesStatus;
    }
}

if(!function_exists('weekDay')){
    function weekDay()
    {
        $weekDay = array(
            "everyday" => 'Everyday',
            "monday"=> "Monday",
            "tuesday"=> "Tuesday",
            "wednesday"=> "Wednesday",
            "thrusday"=> "Thrusday",
            "friday"=> "Friday",
            "saturday"=> "Saturday",
            "sunday"=> "Sunday",
    );
    return $weekDay;
    }
}

if(!function_exists('anElectricVehicle')){
    function anElectricVehicle()
    {
        $anElectricVehicle = array(
          "1"=> "Yes",
          "0"=> "No",
    );
    return $anElectricVehicle;
    }
}

if(!function_exists('faqType')){
    function faqType()
    {
        $faqType = array(
          "getting" => "Getting",
          "getting_started"=>"Getting Started",
    );
    return $faqType;
    }
}

if(!function_exists('complainType')){
    function complainType()
    {
        $complainType = array(
          "personal" => "Personal (Only Me)",
          "community"=>"Community (All)",
    );
    return $complainType;
    }
}

if(!function_exists('complainantType')){
    function complainantType()
    {
        $complainantType = array(
          "member"=>"Owner Flat Member",
          "manager"=>"Manager",
    );
    return $complainantType;
    }
}


if(!function_exists('tagType')){
    function tagType()
    {
        $tagType = array(
          "parking_tag" => "Parking Tag",
    );
    return $tagType;
    }
}

if(!function_exists('underscoreToUcWord')) {
    function underscoreToUcWord($string)
    {
        
        $str =  ucwords(preg_replace("/_+/"," ", $string));
        return $str;
    }
}

if (!function_exists('CreateOptions')) {
    /**
     * @param $format
     * @param $table
     * @param $columns
     * @param null $selected
     * @param null $sort_by insert array
     * @param null $whereCondition
     * @param null $whereInCondition
     * @param null $limit
     * @param null $group_by
     * @return mixed
     */

    function createOptions($format, $table, $columns, $selected = null, $sort_by = null, $whereCondition = null, $limit = null, $group_by = null)
    {
        $db = getTenantDB();;

        $masterTables = ['tbl_users', 'tbl_society'];

        // If the table is a master table, add the database prefix
        if (in_array($table, $masterTables)) {
            $table = MASTER_DB . '.' . $table;
        }
        


        $builder = $db->table($table);
        $columns = is_array($columns) ? implode(", ", $columns) : $columns;

        if ($whereCondition == null && $whereCondition == '' && !is_array($whereCondition)) {
            $whereCondition = "1=1";
        }


        if ($sort_by != null && $sort_by != '' && is_array($sort_by)) {
            if (count($sort_by) > 0) {
                foreach ($sort_by as $key => $value) {
                    $builder->orderBy($key, $value);
                }
            }
        }


        if ($group_by != '' && $group_by != null) {

            $builder->groupBy($group_by);
        }

        if (is_array($limit) && $limit != null && $limit != '') {
            var_dump($limit);
            $builder->limit($limit[0], $limit[1]);
        }

        $builder->select($columns);
        $builder->where($whereCondition);



        $option_result = $builder->get();
        //echo $CI->db->last_query();

        $options = createOptionsFromResultSet($option_result, $format, $selected);
        return $options;
    }
}


if (!function_exists('createOptionsFromResultSet')) {
    /**
     * @param $option_result
     * @param string $format
     * @param null $selected
     * @return array|string
     */
    function createOptionsFromResultSet($option_result, $format = 'html', $selected = null)
    {

        $options = array();
        $columns = array();

        $fields = $option_result->getFieldData();

        foreach ($fields as $key => $fieldData) {
            $columns[$key] = $fieldData->name;
        }

        $optionArray = $option_result->getResultArray();
        foreach ($optionArray as $key => $option_data) {
            $option_data[$columns[1]] = stripslashes($option_data[$columns[1]]);

            switch ($format) {
                case "array":
                    $options[$option_data[$columns[0]]] = $option_data[$columns[1]];
                    break;
                case "json":
                    $options[] = array(
                        "$columns[0]" => $option_data[$columns[0]],
                        "$columns[1]" => $option_data[$columns[1]],
                    );
                    break;
                default:
                case "html":
                    if (!is_null($selected)) {

                        if (is_array($selected)) {
                            $options[] = (in_array($option_data[$columns[0]], $selected)) ? "<option value='{$option_data[$columns[0]]}' selected='selected'>{$option_data[$columns[1]]}</option>" : "<option value='{$option_data[$columns[0]]}'>{$option_data[$columns[1]]}</option>";
                        } else {
                            $options[] = ($option_data[$columns[0]] == $selected) ? "<option value='{$option_data[$columns[0]]}' selected='selected'>{$option_data[$columns[1]]}</option>" : "<option value='{$option_data[$columns[0]]}'>{$option_data[$columns[1]]}</option>";
                        }
                    } else {
                        $options[] = "<option value='{$option_data[$columns[0]]}'>{$option_data[$columns[1]]}</option>";
                    }
                    break;
            }
        }
        switch ($format) {
            case "array":
                $options = $options;
                break;
            case "json":
                $options = json_encode($options);
                break;
            default:
            case "html":
                $options = implode("", $options);
                break;
        }
        return $options;
    }
}

if(!function_exists('groupType')){
    function groupType()
    {
        $groupType = array(
          "supplier" => "Supplier",
          "customer"=>"Customer",
    );
    return $groupType;
    }
}

if(!function_exists('documentFor')){
    function documentFor()
    {
        $documentFors = array(
            // "staff" => "Staff",
            "ownership_flat" => "Ownership Flat",
            "rentals" => "Rentals",
            "resource" => "Resource",
    );
    return $documentFors;
    }
}

if (!function_exists('DMYToYMD')) {
    function DMYToYMD($date, $show_his = false, $hour24format = false)
    {
        if ($hour24format) {
            return ($show_his) ? date('Y-m-d H:i:s', strtotime($date)) : date('Y-m-d', strtotime($date));
        } else {
            return ($show_his) ? date('Y-m-d h:i:s A', strtotime($date)) : date('Y-m-d', strtotime($date));
        }
    }
}

if (!function_exists('YMDToDMY')) {
    function YMDToDMY($date, $show_his = false, $hour24format = false)
    {
        if ($hour24format) {
            return ($show_his) ? date('d-m-Y H:i:s', strtotime($date)) : date('d-m-Y', strtotime($date));
        } else {
            return ($show_his) ? date('d-m-Y h:i:s A', strtotime($date)) : date('d-m-Y', strtotime($date));
        }
    }
}

if (!function_exists('siteDateFormat')) {
    function siteDateFormat($date,$show_time = '',$hour24format = ''){
        if ($hour24format) {
            return ($show_time) ? date('d-m-Y H:i:s', strtotime($date)) : date('d-m-Y', strtotime($date));
        } else {
            return ($show_time) ? date('d-m-Y h:i:s A', strtotime($date)) : date('d-m-Y', strtotime($date));
        }
    }
}

if (!function_exists('extractMonth')) {
    function extractMonth($date){
       return date('M', strtotime($date));
    }
}

if (!function_exists('checkFormStatus')) {
    function checkFormStatus($tableName,$tableId,$idValue,$status){
        $db = getTenantDB();
        $builder = $db->table($tableName);
        $builder->select($tableId);

        if (is_array($idValue)) {
            $builder->whereIn($tableId,$idValue);
        } else {
            $builder->where($tableId,$idValue);
        }
        $builder->where("form_submit",$status);
        $builder->limit(1);
        $result = $builder->get();
        if($result->getNumRows() === 0){
            return true;
        } else {
            return false;
        }
    }
}

if(!function_exists('addressType')){
    function addressType()
    {
        $addressType = array(
          "billing" => "Billing",
          "shipping"=>"Shipping",
    );
    return $addressType;
    }
}
if(!function_exists('customerAppPermission')){
    function customerAppPermission()
    {
        $customerAppPermission = array(
            "addVisitor" => "Add Visitor",
            "viewBanner" => "View Banner",
            "viewQuickAccess" => "View Quick Access",
            "viewVisitor" => "View Visitor",
            "viewForum" => "View Forum",
            "viewPoll" => "View Poll",
            "viewResidentDirectory" => "View Resident Directory",
            "viewServiceDirectory" => "View Service Directory",
            "viewSocietyCommitte" => "View Society Committee",
            "viewEmergencyDirectory" => "View Emergency Directory",
            "viewGuardDirectory" => "View Guard Directory",
            "viewNotice" => "View Notice",
            "viewResource" => "View Resource",
            "viewParking" => "View Parking",
            "viewAmenities" => "View Amenities",
            "viewSos" => "View SOS",
            "viewEmergency" => "View Emergency",
            "viewComplainTicket" => "View Complain Ticket",
            "viewNotification" => "View Notification",
            "viewNotificationSetting" => "View Notification Setting",
            "viewMaintenance" => "View Maintenance",
            "viewStatement" => "View Statement",
            "viewPaymentHistory" => "View Payment History",
            "viewMember" => "View Member",
            "viewVehicle" => "View Vehicle",
            "viewMyMember" => "View My Member",
            "viewMyVehicle" => "View My Vehicle",
            "addResource" => "Add Resource",
            "addPreApproveCab" => "Add Pre Approve Cab",
            "addPreApproveDeliveryBoy" => "Add Pre Approve Delivery Boy",
            "addPreApproveGuest" => "Add Pre Approve Guest",
            "addVehicle" => "Add Vehicle",
            "addMember" => "Add Member",
            "viewEvents" => "View Events",
            "viewDocument" => "View Document",
    );
    return $customerAppPermission;
    }
}

if(!function_exists('gatekeeperAppPermission')){
    function gatekeeperAppPermission()
    {
        $gatekeeperAppPermission = array(
            "addVisitor" => "Add Visitor",
            "addGuest" => "Add Guest",
            "addDeliveryBoy" => "Add Delivery Boy",
            "addCab" => "Add Cab",
            "viewVisitor" => "View Visitor",
            "viewHistory" => "View History",
            "viewResident" => "View Resident",
            "viewResource" => "View Resource",
            "viewParking" => "View Parking",
            "viewSos" => "View SOS",
            "viewEvents" => "View Events",
            "viewScanner" => "View Scanner",
            "viewNotification" => "View Notification",
    );
    return $gatekeeperAppPermission;
    }
}

if(!function_exists('managerAppPermission')){
    function managerAppPermission()
    {
        $managerAppPermission = array(
            "viewComplainTicket" => "View Complain Ticket",
            "viewOrganicWaste" => "View Organic Waste",
            "viewWaterMeterReading" => "View Water Meter Reading",
            "viewGenerator" => "View Generator",
            "viewDocument" => "View Document",
            "viewParking" => "View Parking",
            "viewEvents" => "View Events",
            "viewNotification" => "View Notification",
            "viewSos" => "View SOS",
            "viewAmenities" => "View Amenities",
            "viewVisitor" => "View Visitor",
            "viewBanner" => "View Banner",
            "viewResource" => "View Resource",
            "viewResidentDirectory" => "View Resident Directory",
            "viewHistory" => "View History",
            "viewServiceDirectory" => "View Service Directory",
            "viewSocietyCommitte" => "View Society Committee",
            "viewEmergencyDirectory" => "View Emergency Directory",
            "addResource" => "Add Resource",
            "addComplainTicket" => "Add Complain Ticket",
    );
    return $managerAppPermission;
    }
}

if(!function_exists('addressFor')){
    function addressFor()
    {
        $addressFor = array(
          "supplier" => "Supplier",
          "customer"=>"Customer",
    );
    return $addressFor;
    }
}

if(!function_exists('source')){
    function source()
    {
        $source = array(
          "tanker" => "Tanker",
          "self"=>"Self",
    );
    return $source;
    }
}

if(!function_exists('contactPersonFor')){
    function contactPersonFor()
    {
        $contactPersonFor = array(
          "supplier" => "Supplier",
          "customer"=>"Customer",
    );
    return $contactPersonFor;
    }
}

if(!function_exists('actionType')){
    function actionType()
    {
        $actionType = array(
          "send" => "Send",
          "accept"=>"Accept",
          "reject"=>"Reject",
    );
    return $actionType;
    }
}

if(!function_exists('notificationType')){
    function notificationType()
    {
        $notificationType = array(
          "banner" => "Banner",
          "poll"=>"Poll",
          "forum"=>"Forum",
          "notice"=>"Notice",
          "amenities"=>"Amenities",
          "sos_emergency"=>"Sos Emergency",
          "complain"=>"Complain",
          "visitor"=>"Visitor",
          "delivery_boy"=>"Delivery Boy",
          "taxi"=>"Taxi",
          "test_notification"=>"Test Notification",
    );
    return $notificationType;
    }
}

if (!function_exists('getToFixedValue')) {
    function getToFixedValue($decimalNumber = ''){
        if($decimalNumber == ""){
            $roundNumber = $CI->session->userdata('company_id');
        } else {
            $roundNumber = $decimalNumber;
        }
        return $roundNumber;
    }
}

if (!function_exists('decimalValueForNumber')) {
    function decimalValueForNumber($number)
    {
        return strlen(substr(strrchr($number, "."), 1));
    }
}

if (!function_exists('admin_url')) {
    function admin_url($uri = '', $protocol = null)
    {
        return base_url('Admin/' . $uri, $protocol);
    }
}

// Add admin_redirect
if (!function_exists('admin_redirect')) {
    function admin_redirect($uri = '', $method = 'auto', $code = null)
    {
        if (!preg_match('#^(\w+:)?//#i', $uri)) {
            $uri = base_url('Admin/' . $uri);
        }
        return redirect($uri, $method, $code);
    }
}

if (!function_exists('checkAndCreatePath')) {
    function checkAndCreatePath($path)
    {
        $dirs = null;
        if (strpos($path, '/')) {
            $dirs = explode("/", $path);
        }

        if (strpos($path, '\\')) {
            $dirs = explode("\\", $path);
        }

        $new_path = '';
        if (isset($dirs) && $dirs != null) {
            for ($i = 0; $i < count($dirs); $i++) {
                $new_path .= ($dirs[$i] . "/");

                if (!file_exists($new_path)) {
                    if (!mkdir($new_path, 0777, true)) {
                        die('Failed to create folders...');
                    }else {
                        $filename = $path.'index.html';
                        $index = fopen($filename, 'w');
                        fwrite($index, "Not allowed");
                    }
                }
            }
        }
    }
}
if(!function_exists('imageAcceptExtension')){
    function imageAcceptExtension($imageExtension = array()){
        $imageAcceptExtension = array(
            'jpeg' => 'image/jpeg',
            'jpg' => 'image/jpg',
            'png' => 'image/png',
            'pdf' => 'application/pdf',
            'mp4' => 'video/mp4',
            'mp3' => 'audio/mpeg',
            'ogg' => 'audio/ogg'
        );
        if(!empty($imageExtension)){
            return array_intersect_key($imageAcceptExtension,$imageExtension);
        }
        else{
            return $imageAcceptExtension;
        }

    }
}

if (!function_exists('getResourceTypeId')) {
    function getResourceTypeId($resourceTypeName,$societyId = "")
    {
        $resourceTypeModel = new ResourceTypeModel();
        $session       = \Config\Services::session();
        if (empty($societyId)) {
            $societyId = $session->get('society_id');
        }
        $filterData = array(
            'resource_type_name' => $resourceTypeName,
            'society_id' => $societyId,
        );
        $resourceTypeData = $resourceTypeModel->getResourceTypeData($filterData);
        $resourceTypeId = $resourceTypeData['resource_type_id'];
        return $resourceTypeId;
    }
}

if (!function_exists('imageExtension')) {
    function imageExtension($imageFormat = array())
    {
        $imageExtension = array(
            'jpeg',
            'png',
            'jpg',
            'JPG',
            'pdf',
            'mp4',
            'mp3'
        );
        if (!empty($imageFormat)) {
            return array_intersect($imageFormat, $imageExtension);
        } else {
            return $imageExtension;
        }

    }
}

if (!function_exists('arrayKeyFirst')) {
    function arrayKeyFirst(array $array)
    {
        foreach ($array as $key => $value) {
            return $key;
        }
    }
}

if (!function_exists('mediaValidation')) {
    function mediaValidation($imageData,$mediaValidationArray = array(),$isApiCall = 0)
    {
        $mediaIdArray = isset($mediaValidationArray['media_id']) ? $mediaValidationArray['media_id'] : 0;
        $commonMediaArray = isset($mediaValidationArray['common_media']) ? $mediaValidationArray['common_media'] : '';
        $mediaFileArray = isset($mediaValidationArray['media_file']) ? $mediaValidationArray['media_file'] : '';
        $mediaTypeArray = isset($mediaValidationArray['media_type']) ? $mediaValidationArray['media_type'] : '';
        $mediaFileArray = array();
        if (isset($_FILES["media_file"])) {
            $filesCount = count($_FILES['media_file']['name']);
            $start = arrayKeyFirst($_FILES['media_file']['name']);
            $filesCount = ($start == 0) ? $filesCount : $start + $filesCount;
            for ($i = $start; $i < $filesCount; $i++) {
                $mediaFileArray[$i] =  $_FILES['media_file']['name'][$i];
            }
        }
        // printArray($start);
            // printArray($mediaFileArray,1);
        $excessFileArray = array();
        $documentSrNo = 0;
        if (!empty($mediaIdArray)) {
            foreach ($mediaIdArray as $dcKey => $mediaId) {
                $documentSrNo += 1;
                $commonMedia = array_key_exists($dcKey, $commonMediaArray) ? $commonMediaArray[$dcKey] : "";
                $mediaFile = array_key_exists($dcKey, $mediaFileArray) ? $mediaFileArray[$dcKey] : "";
                $mediaType = array_key_exists($dcKey, $mediaTypeArray) ? $mediaTypeArray[$dcKey] : "";
                
                if($mediaFile != '' || $commonMedia != ''){
                    if(empty($mediaType)){
                        $excessFileArray[] = 'Media File Line No ' . $documentSrNo . ' Media Type Is Required';
                    }
                }
                if(isset($mediaType) && !empty($mediaType)){
                    if($commonMedia == '' && $mediaFile == ''){
                        $excessFileArray[] = 'Media File Line No ' . $documentSrNo . ' Is Required';
                    }
                    else{
                        if($mediaFile != '' && isset($mediaFile)){
                            if($mediaType == 'image'){
                                $Image = explode('.',$mediaFile);
                                $ext = pathinfo($mediaFile, PATHINFO_EXTENSION);
                                if(($ext == 'pdf'|| $ext == 'mp4' || $ext == 'mp3')){
                                    $excessFileArray[] = 'Please Upload only Image';
                                }
                            }
                            else if($mediaType == 'audio' || $mediaType == 'video'){
                                $ext = pathinfo($mediaFile, PATHINFO_EXTENSION);
                                if(($ext == 'pdf'|| $ext == 'jpeg' || $ext == 'png' || $ext == 'jpg' || $ext == 'JPG') ){
                                    $excessFileArray[] = 'Please Upload only Video';
                                }
                            }
                            else{
                                $ext = pathinfo($mediaFile, PATHINFO_EXTENSION);
                                if( $ext != 'pdf'){
                                    $excessFileArray[] = 'Please Upload only Pdf';
                                }
                            }
                        }
                    }
                }
            }
        }
        if($isApiCall == 0){
            if(!empty($excessFileArray)){
                $response['success'] = false;
                $response['msg'] = implode("\n", $excessFileArray);
                echo json_encode($response);
                exit();
            }
        } else {
            if(!empty($excessFileArray)){
                $response['success'] = false;
                $response['msg'] = implode("\n", $excessFileArray);
                return $response;
            }
        }

    }
}

if (!function_exists('intercomType')) {
	function intercomType()
	{
		$intercomType = array(
			"flat" => "Flat",
			"common_area" => "Common Area",
		);
		return $intercomType;
	}
}

if (!function_exists('feeType')) {
    function feeType()
    {
        $feeType = array(
            "penalties" => "Penalties",
            "fee_and_charges" => "Fee & Charges",
        );
        return $feeType;
    }
}

if (!function_exists('warrantyFor')) {
    function warrantyFor()
    {
        $warrantyFor = array(
            "society" => "Society",
            "residents" => "Residents",
        );
        return $warrantyFor;
    }
}

if(!function_exists('currentFinancialYear')){
	function currentFinancialYear(){
		$month = date("m");
		if($month >= 04){
			$firstDateCurrentFinancial = FIRST_DATE_CURRENT_FINANCIAL;
			$lastDateCurrentFinancial = LAST_DATE_CURRENT_FINANCIAL;
		}
		else{
			$firstDateCurrentFinancial = CURRENT_FINANCIAL;
			$lastDateCurrentFinancial = LAST_CURRENT_FINANCIAL;
		}

		$createdOn = $firstDateCurrentFinancial." - ".$lastDateCurrentFinancial;
		return $createdOn;
	}
}

if(!function_exists('productCategoryType')){
    function productCategoryType()
    {
        $productCategoryType = array(
            "lead_category" => "Lead Category",
            "product_category" => "Product Category",
    );
    return $productCategoryType;
    }
}

if(!function_exists('visitorCompanyType')){
    function visitorCompanyType()
    {
        $visitorCompanyType = array(
            "delivery_boy" => "Delivery Boy",
            "taxi" => "Taxi",
    );
    return $visitorCompanyType;
    }
}

if(!function_exists('readingType')){
    function readingType()
    {
        $readingType = array(
            "usage" => "Usage",
            "refilled" => "Refilled",
    );
    return $readingType;
    }
}

if(!function_exists('notesFor')){
    function notesFor()
    {
        $notesFor = array(
            "customer" => "Customer",
            "quotation" => "Quotation",
            "supplier" => "Supplier",
            "lead" => "Lead",
            "sales_order" => "Sales Order",
            "invoice" => "Invoice",
            "good_receipt_note" => "Good Receipt Note",
            "delivery_note" => "Delivery Note",
    );
    return $notesFor;
    }
}

if(!function_exists('linkedTo')){
    function linkedTo()
    {
        $linkedTo = array(
            "customer" => "Customer",
            "supplier" => "Supplier",
            "lead" => "Lead",
    );
    return $linkedTo;
    }
}

if(!function_exists('voucherType')){
    function voucherType()
    {
        $voucherType = array(
            "bank_payment" => "Bank Payment",
            "bank_receipt" => "Bank Receipt",
            "cash_payment" => "Cash Payment",
            "cash_receipt" => "Cash Receipt",
    );
    return $voucherType;
    }
}

if(!function_exists('transactionMode')){
    function transactionMode()
    {
        $transactionMode = array(
            "cheque" => "Cheque",
            "neft_rtgs" => "NEFT/RTGS",
            "imps_upi" => "IMPS/UPI",
            "credit_debit_card" => "Credit/Debit Card",
            "cash" => "Cash",
    );
    return $transactionMode;
    }
}

if(!function_exists('relatedTo')){
    function relatedTo()
    {
        $relatedTo = array(
            "quotation" => "Quotation",
            "sales_order" => "Sales Order",
            "invoice" => "Invoice",
            "good_receipt_note" => "Good Receipt Note",
            "delivery_note" => "Delivery Note",
            "lead" => "Lead",
    );
    return $relatedTo;
    }
}

if(!function_exists('eventType')){
    function eventType()
    {
        $eventType = array(
            "event_wise" => "Event Wise",
            "date_wise" => "Date Wise",
    );
    return $eventType;
    }
}

if(!function_exists('linkedToAPI')){
    function linkedToAPI()
    {
        $linkedToAPI = [
            [
                "key" => "customer",
                "value" => "Customer"
            ],
            [
                "key" => "supplier",
                "value" =>"Supplier"
            ],
            [
                "key" => "lead",
                "value" => "Lead"
            ],
        ];
        return $linkedToAPI;
    }
}

if(!function_exists('generateDateRange')){
    function generateDateRange($startDate, $endDate)
    {
        $start = \DateTime::createFromFormat('d-m-Y H:i', $startDate);
        $end = \DateTime::createFromFormat('d-m-Y H:i', $endDate);
        
        if (!$start || !$end) {
            return [];
        }
        $start = $start->format('d-m-Y');
        $end = $end->format('d-m-Y');
        $start = \DateTime::createFromFormat('d-m-Y', $start);
        $end = \DateTime::createFromFormat('d-m-Y', $end);

        $dateRange = [];
        $end->modify('+1 day'); // Include the end date
    
        $interval = new \DateInterval('P1D');
        $datePeriod = new \DatePeriod($start, $interval, $end);
    
        foreach ($datePeriod as $date) {
            $dateRange[] = $date->format('Y-m-d');
        }
    
        return $dateRange;
    }
}

if(!function_exists('complainTypeApi')){
    function complainTypeApi()
    {
        $complainTypeApi = [
            [
                "key" => "personal",
                "value" => "Personal (Only Me)"
            ],
            [
                "key" => "community",
                "value" =>"Community (All)"
            ],
        ];
        return $complainTypeApi;
    }
}

if(!function_exists('readingTypeApi')){
    function readingTypeApi()
    {
        $readingTypeApi = [
            [
                "key" => "usage",
                "value" => "Usage"
            ],
            [
                "key" => "refilled",
                "value" =>"Refilled"
            ],
        ];
        return $readingTypeApi;
    }
}

if(!function_exists('foodLikeApi')){
    function foodLikeApi()
    {
        $foodLikeApi = [
            [
                "key" => "jain",
                "value" => "Jain"
            ],
            [
                "key" => "non_jain",
                "value" =>"Non Jain"
            ],
            [
                "key" => "veg",
                "value" =>"Veg"
            ],
            [
                "key" => "non_veg",
                "value" =>"Non Veg"
            ],
        ];
        return $foodLikeApi;
    }
}

if (!function_exists('vehicleTypeApi')) {
    function vehicleTypeApi()
    {
        $vehicleTypeApi = [
            [
                "key" => "2_wheelers",
                "value" => "2 Wheelers"
            ],
            [
                "key" => "4_wheelers",
                "value" =>"4 Wheelers"
            ],
        ];

        return $vehicleTypeApi;
    }
}

if (!function_exists('sourceAPI')) {
    function sourceAPI()
    {
        $sourceAPI = [
            [
                "key" => "tanker",
                "value" => "Tanker"
            ],
            [
                "key" => "self",
                "value" =>"Self"
            ],
        ];

        return $sourceAPI;
    }
}

if(!function_exists('relatedToAPI')){
    function relatedToAPI()
    {
        $relatedToAPI = [
            [
                "key" => "quotation",
                "value" => "Quotation"
            ],
            [
                "key" => "sales_order",
                "value" =>"Sales Order"
            ],
            [
                "key" => "invoice",
                "value" => "Invoice"
            ],
            [
                "key" => "good_receipt_note",
                "value" => "Good Receipt Note"
            ],
            [
                "key" => "delivery_note",
                "value" => "Delivery Note"
            ],
            [
                "key" => "lead",
                "value" => "Lead"
            ],
        ];
        return $relatedToAPI;
    }
}

if(!function_exists('notesForAPI')){
    function notesForAPI()
    {
        $notesForAPI = [
            [
                "key" => "customer",
                "value" => "Customer"
            ],
            [
                "key" => "quotation",
                "value" => "Quotation"
            ],
            [
                "key" => "supplier",
                "value" =>"Supplier"
            ],
            [
                "key" => "sales_order",
                "value" =>"Sales Order"
            ],
            [
                "key" => "invoice",
                "value" => "Invoice"
            ],
            [
                "key" => "good_receipt_note",
                "value" => "Good Receipt Note"
            ],
            [
                "key" => "delivery_note",
                "value" => "Delivery Note"
            ],
            [
                "key" => "lead",
                "value" => "Lead"
            ],
        ];
        return $notesForAPI;
    }
}

if(!function_exists('assignedTo')){
    function assignedTo()
    {
        $assignedTo = array(
            "staff" => "Staff",
            "user" => "User",
        );
        return $assignedTo;
    }
}

if (!function_exists('editButtonStatus')) {
    function editButtonStatus()
    {
        $editButton = array(
            "saved",
        );
        return $editButton;
    }
}
if (!function_exists('deleteButtonStatus')) {
    function deleteButtonStatus()
    {
        $deleteButton = array(
            "saved",
        );
        return $deleteButton;
    }
}

if(!function_exists('dispatchedType')){
    function dispatchedType()
    {
        $dispatchedType = array(
            "cc_attached" => "CC Attached",
            "no_attached" => "No Attached",
        );
        return $dispatchedType;
    }
}

if(!function_exists('transportCharge')){
    function transportCharge()
    {
        $transportCharge = array(
            "to_pay" => "To Pay",
            "paid" => "Paid",
        );
        return $transportCharge;
    }
}
if(!function_exists('salesOrderType')){
    function salesOrderType()
    {
        $salesOrderType = array(
            "direct" => 'Direct',
            "quotation" => "Quotation",
        );
        return $salesOrderType;
    }
}
if(!function_exists('deliveryNoteType')){
    function deliveryNoteType()
    {
        $deliveryNoteType = array(
            "sales_order" => "Sales Order",
        );
        return $deliveryNoteType;
    }
}
if(!function_exists('invoiceType')){
    function invoiceType()
    {
        $invoiceType = array(
            "delivery_note" => "Delivery Note",
        );
        return $invoiceType;
    }
}

if (!function_exists('isValidDate')) {
    function isValidDate($date){
        $invalidDate = array(
            '01-01-1970',
            '1970-01-01',
            '00-00-0000',
            '0000-00-00',
            '0000-00-00 00:00:00',
            ''
        );
        //$d = DateTime::createFromFormat($format, $date);
        return !in_array($date,$invalidDate);
    }
}


if (!function_exists('roundNumber')) {
    function roundNumber($number,$decimal = 2){
        if($number < 0){
            $number = abs($number);
            $result = "-".(round($number,$decimal));
        }else {
            $result = round($number,$decimal);
        }
        return $result;
    }
}
if(!function_exists('salesReturnType')){
    function salesReturnType()
    {
        $salesReturnType = array(
            "invoice" => "Invoice",
        );
        return $salesReturnType;
    }
}

//if (!function_exists('getModuleObjectData')) {
//    function getModuleObjectData($filter = array(), $ojectData)
//    {
//        $moduleObject = array();
//        if (!empty($filter)) {
//            foreach($filter as $filterElement){
//                $moduleObject[$filterElement] = array_key_exists($filterElement,$ojectData) ? $ojectData[$filterElement] : '';
//            }
//            return $moduleObject;
//        }
//    }
//}

if (!function_exists('getModuleObjectData')) {
    function getModuleObjectData($filter = array(), $objectData = array())
    {
        $moduleArray = array();
        if (!empty($objectData)) {
            $moduleArray = $objectData;
        }
        if (!empty($filter)) {
            foreach ($filter as $key => $filterElement) {
                $moduleObject = array();
                if (!empty($filterElement)) {
                    foreach ($filterElement as $filterData) {
                        $moduleObject[$filterData] = array_key_exists($filterData, $objectData) ? $objectData[$filterData] : '';
                    }
                }
                $moduleArray[$key] = $moduleObject;
            }
            //            if(!empty($moduleArray)){
            //                return array_merge($ojectData,$moduleArray);
            //            }
            //            else {
            return $moduleArray;
            //            }
        }
    }
}

if(!function_exists('purchaseReturnType')){
    function purchaseReturnType()
    {
        $purchaseReturnType = array(
            "good_receipt_note" => "Good Receipt Note",
        );
        return $purchaseReturnType;
    }
}

if(!function_exists('mediaType')){
    function mediaType()
    {
        $mediaTypes = array(
            "image" => "Image",
            "video" => "Video",
            "audio" => "Audio",
            "pdf" => "PDF",
        );
        return $mediaTypes;
    }
}

if(!function_exists('recipient')){
    function recipient()
    {
        $recipients = array(
            "all_owners(resident_and_non_resident)" => "All Owners (Resident And Non-Resident)",
            "all_owners_and_tenants(resident_and_non_resident)" => "All Owners And Tenants (Resident And Non-Resident)",
            "all_residents(owners_and_tenants)" => "All Residents (Owners And Tenants)",
            "all_management_committee_members(only_mc_members)" => "All Management Committee Members (Only MC Members)",
        );
        return $recipients;
    }
}

if(!function_exists('tagType')){
    function tagType()
    {
        $tagTypes = array(
           "parking" => "Parking",
        );
        return $tagTypes;
    }
}

if(!function_exists('callTypeAPI')){
    function callTypeAPI()
    {
        $callTypeAPI = [
            [
                "key" => "schedule",
                "value" => "Schedule"
            ],
            [
                "key" => "normal",
                "value" =>"Normal"
            ],
        ];
        return $callTypeAPI;
    }
}

if(!function_exists('callType')){
    function callType()
    {
        $callType = array(
            "schedule" => "Schedule",
            "normal" => "Normal",
        );
        return $callType;
    }
}

if (!function_exists('indianMoneyFormat')) {
    function indianMoneyFormat($number,$decimalPoint = 0,$withSymbol = 1){

        // $CI =& get_instance();
        // $companyId = $CI->session->userdata('company_id');

        // if($decimalPoint == ''){
        //     $decimalPoint = getToFixedValue($companyId);
        // }

//      if($decimalPoint == ''){
//          $decimalPoint = getToFixedValue($companyId);
//          $decimalPoint = floatval($decimalPoint) + 1;
//      } else {
//          $decimalPoint = floatval($decimalPoint) + 1;
//      }
//
//
//
//      $decimal = (string)($number - floor($number));
//      $money = floor($number);
//      $length = strlen($money);
//      $delimiter = '';
//      $money = strrev($money);
//
//      for($i=0;$i<$length;$i++){
//          if(( $i==3 || ($i>3 && ($i-1)%2==0) )&& $i!=$length){
//              $delimiter .=',';
//          }
//          $delimiter .=$money[$i];
//      }
//
//      $result = strrev($delimiter);
//      $decimal = preg_replace("/0\./i", ".", $decimal);
//      $decimal = substr($decimal, 0, $decimalPoint);
//
//      if( $decimal != '0'){
//          $result = $result.$decimal;
//      }
//      if($withSymbol == 1){
//          $symbol = '&#8377;';
//          return $symbol. ' '.$result;
//      } else {
//          return $result;
//      }

        $amount = round($number, $decimalPoint);

        $amountArray = explode('.', $amount);
        if (count($amountArray) == 1) {
            $int = $amountArray[0];
            $des = 00;
        } else {
            $int = $amountArray[0];
            $des = $amountArray[1];
        }
        if (strlen($des) == 1) {
            $des = $des . "0";
        }
        if ($int >= 0) {
            $int = numFormatIndia($int);
            $theMoney = $int . "." . $des;
        } else {
            $int = abs($int);
            $int = numFormatIndia($int);
            $theMoney = "-" . $int . "." . $des;
        }
        if ($withSymbol == 1) {
            $symbol = '₹';
            return $symbol.''.$theMoney;
        } else {
            return $theMoney;
        }

    }
}

if (!function_exists('numFormatIndia')) {
    function numFormatIndia($num)
    {

        $explrestUnits = "";
        if (strlen($num) > 3) {
            $lastThree = substr($num, strlen($num) - 3, strlen($num));
            $restUnits = substr($num, 0, strlen($num) - 3); // extracts the last three digits
            $restUnits = (strlen($restUnits) % 2 == 1) ? "0" . $restUnits : $restUnits; // explodes the remaining digits in 2's formats, adds a zero in the beginning to maintain the 2's grouping.
            $expUnit = str_split($restUnits, 2);
            for ($i = 0; $i < sizeof($expUnit); $i++) {
                // creates each of the 2's group and adds a comma to the end
                if ($i == 0) {
                    $explrestUnits .= (int)$expUnit[$i] . ","; // if is first value , convert into integer
                } else {
                    $explrestUnits .= $expUnit[$i] . ",";
                }
            }
            $theCash = $explrestUnits . $lastThree;
        } else {
            $theCash = $num;
        }
        return $theCash; // writes the final format where $currency is the currency symbol.
    }
}


if (!function_exists('isReferenceInTable')) {
    function isReferenceInTable($field, $table, $id,$extraField = '',$extraValue = '')
    {
        // $db = \Config\Database::connect();
        helper('tenant');
        $db = getTenantDB();
        $builder = $db->table($table);
        if(is_array($id)){
            $builder->whereIn($field, $id);
        } else {
            $builder->where($field, $id);
        }

        if($extraField != '' && $extraValue != ''){
            if(is_array($extraValue)){
                $builder->whereIn($extraField, $extraValue);
            }
            else {
                $builder->where($extraField, $extraValue);
            }

        }
        $row = $builder->get()->getRow();
        if ($row) {
            return true;
        }

        return false;
    }
}

if (!function_exists('excelExport')) {
    //function excelExport($name, $sheetName,$excelName, $dataRows, $subTotalCellValueArray = array(),$toColumn = '',$skipHeader = false,$ignoreCurrencySymbolsSubTotalCellValueArray= array(),$rowCellCurrencyFormat = array(),$date= 0, $roundNumberCellValueArray = array()){
    function excelExport($filterData = array()){
        $name = isset($filterData['file_name']) ? $filterData['file_name']:  '';
        $sheetName = isset($filterData['sheet_name']) ? $filterData['sheet_name']:  '';
        $excelName = isset($filterData['excel_header_name']) ? $filterData['excel_header_name']:  '';
        $dataRows = isset($filterData['data_row']) ? $filterData['data_row']:  '';
        $subTotalCellValueArray = isset($filterData['sub_total_cell_value_array']) ? $filterData['sub_total_cell_value_array']:  '';
        $toColumn = isset($filterData['to_column']) ? $filterData['to_column']:  '';
        $skipHeader = isset($filterData['skip_header']) ? $filterData['skip_header']:  false;
        $ignoreCurrencySymbolsSubTotalCellValueArray = isset($filterData['ignore_currency_symbols_sub_total_cell_value_array']) ? $filterData['ignore_currency_symbols_sub_total_cell_value_array']:  array();
        $rowCellCurrencyFormat = isset($filterData['row_cell_currency_format']) ? $filterData['row_cell_currency_format']:  array();
        $date = isset($filterData['date']) ? $filterData['date']:  0;
        $roundNumberCellValueArray = isset($filterData['round_number_cell_value_array']) ? $filterData['round_number_cell_value_array']:  array();


        $spreadsheet = new Spreadsheet();
        $worksheet = $spreadsheet->getActiveSheet();
        if(!$skipHeader){
            $rowStart = 6;
        } else {
            $rowStart = 1;
        }
        if(!$skipHeader){
            $ionAuth    = new \App\Libraries\IonAuth();
            $userDetails = $ionAuth->user()->row();
            $session = \Config\Services::session();
            $societyModel =  new \App\Models\SocietyModel();
            $societyData = $societyModel->getSocietyData(array(
                "society_id" => $session->get('society_id'),
            ));
            $userName = $userDetails->first_name." ".$userDetails->last_name;
            $societyName = isset($societyData['society_name']) ? $societyData['society_name'] : "";

            $styleArray = [
                'font' => [
                    'bold' => true,
                ],
                'alignment' => [
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                ],
                'borders' => [
                    'top' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    ],
                ],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
//                  'rotation' => 90,
//                  'startColor' => [
//                      'argb' => 'FF4F81BD',
//                  ],
                    'endColor' => [
                        'argb' => 'FF4F81BD',
                    ],
                ],
            ];

            if(!empty($date)){
                $rowStart = 7;
                list($fromDate,$toDate) = explode(" - ",$date);
                $header = [
                    [ $excelName,'', '', '', '', '' ],
                    [ '','', '', '', '', '' ],
                    [ 'User Name', $userName,    '', '', 'Run Date', TODAY_DATE_TIME ],
                    [ 'Society', $societyName,    '', '', '', ''   ],
                    [ 'From Date', $fromDate, '', '', 'To Date', $toDate],
                ];
            }
            else{
                $header = [
                    [ $excelName,'', '', '', '', '' ],
                    [ '','', '', '', '', '' ],
                    [ 'User Name', $userName,    '', '', 'Run Date', TODAY_DATE_TIME ],
                    [ 'Society', $societyName,    '', '', '', ''   ],
                    [ '','', '', '', '', '' ],
                ];
            }


            $worksheet->fromArray( $header, NULL, 'A1' );

            $worksheet->getStyle('A1')->applyFromArray($styleArray);
            $worksheet->getStyle("A1")->getFont()->setSize(10);
            $worksheet->getStyle("A3:B3")->getFont()->setBold( true );
            $worksheet->getStyle("A4:B4")->getFont()->setBold( true );
            $worksheet->getStyle("E3:F3")->getFont()->setBold( true );
            $worksheet->getStyle("A5:B5")->getFont()->setBold( true );
            $worksheet->getStyle("E5:F5")->getFont()->setBold( true );
        }

        $worksheet->fromArray( $dataRows, NULL, 'A'.$rowStart,true );
        $highestRow = $worksheet->getHighestRow();
        $excelLastRow = $highestRow + 1;
        $worksheet->setAutoFilter('A'.$rowStart.':'.$toColumn.$rowStart);
//      $worksheet->getStyle('A'.$rowStart.':'.$toColumn.$rowStart)
//          ->getFont()->getColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_RED);

        $worksheet->getStyle('A'.$rowStart.':'.$toColumn.$rowStart)->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()->setARGB('979797');

        if(!empty($rowCellCurrencyFormat)){
            foreach ($rowCellCurrencyFormat as $rowCellCurrencyElement){
                $worksheet->getStyle("$rowCellCurrencyElement".($rowStart+1).":".$rowCellCurrencyElement.$highestRow)
                    ->getNumberFormat()
                    ->setFormatCode('#,##0.00;-#,##0.00');
            }
        }

        if(!empty($subTotalCellValueArray)){
            foreach ($subTotalCellValueArray as $subTotalCellValueElement){

                if(in_array($subTotalCellValueElement,$ignoreCurrencySymbolsSubTotalCellValueArray)){
                    $worksheet->getStyle($subTotalCellValueElement)
                        ->getNumberFormat()
                        ->setFormatCode('#,##0.00;-#,##0.00');
                    //$worksheet->getStyle("$subTotalCellValueElement"."7:".$subTotalCellValueElement.$highestRow)
                    $worksheet->getStyle("$subTotalCellValueElement".($rowStart+1).":".$subTotalCellValueElement.$highestRow)
                        ->getNumberFormat()
                        ->setFormatCode('#,##0.00;-#,##0.00');
                } else {
                    $worksheet->getStyle($subTotalCellValueElement)
                        ->getNumberFormat()
                        ->setFormatCode('₹ #,##0.00;₹ -#,##0.00');
                    //$worksheet->getStyle("$subTotalCellValueElement"."7:".$subTotalCellValueElement.$highestRow)
                    $worksheet->getStyle("$subTotalCellValueElement".($rowStart+1).":".$subTotalCellValueElement.$highestRow)
                        ->getNumberFormat()
                        ->setFormatCode('₹ #,##0.00;₹ -#,##0.00');
                }


                $worksheet->setCellValue($subTotalCellValueElement.$excelLastRow, '=SUBTOTAL(9,'.$subTotalCellValueElement.($rowStart+1).':'.$subTotalCellValueElement.$highestRow.')');
            }
        }

        if(!empty($roundNumberCellValueArray)){
            foreach ($roundNumberCellValueArray as $roundNumberCellValueElement){
                $worksheet->getStyle($roundNumberCellValueElement)
                    ->getNumberFormat()
                    ->setFormatCode('#,##0;-#,##0');
                //$worksheet->getStyle("$subTotalCellValueElement"."7:".$subTotalCellValueElement.$highestRow)
                $worksheet->getStyle("$roundNumberCellValueElement".($rowStart+1).":".$roundNumberCellValueElement.$highestRow)
                    ->getNumberFormat()
                    ->setFormatCode('#,##0;-#,##0');
                $worksheet->setCellValue($roundNumberCellValueElement.$excelLastRow, '=SUBTOTAL(9,'.$roundNumberCellValueElement.($rowStart+1).':'.$roundNumberCellValueElement.$highestRow.')');
            }
        }

        $from = "A".$rowStart; // or any value
        $to = $toColumn.$rowStart; // or any value
        $worksheet->getStyle("$from:$to")->getFont()->setBold( true );

        foreach ($worksheet->getColumnIterator() as $column) {
            $worksheet->getColumnDimension($column->getColumnIndex())->setAutoSize(true);
        }

        $worksheet->setTitle($sheetName);
        $writer = new Xlsx($spreadsheet);
        ob_end_clean();
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . basename($name) . '.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output'); // download file
    }
}

if (!function_exists('productDocumentToHtml')) {
    function productDocumentToHtml($productCodeName,$productId,$returnType = 'html'){
        $html = '';
        $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $productId . "' data-dt_view_url='".admin_url('Product/view') ."'>" . $productCodeName . "</a><br>";
        return $html;
    }
}

if (!function_exists('transactionDocumentToHtml')) {
    function transactionDocumentToHtml($transactionCodeName,$transactionType,$transactionId,$returnType = 'html'){
        $html = '';

        if($transactionType == 'invoice') {
                    $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $transactionId . "' data-dt_view_url='".admin_url('Invoice/view') ."'>" . $transactionCodeName . "</a><br>";
        }
        else if($transactionType == 'good_receipt_note' || $transactionType == 'good_receipt_note_unapproved') {
                    $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $transactionId . "' data-dt_view_url='".admin_url('GoodReceiptNote/view') ."'>" . $transactionCodeName . "</a><br>";
        }
        else if($transactionType == 'sales_return' || $transactionType == 'sales_return_unapproved') {
            $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $transactionId . "' data-dt_view_url='".admin_url('SalesReturn/view') ."'>" . $transactionCodeName . "</a><br>";
        }
        else if($transactionType == 'purchase_return' || $transactionType == 'purchase_return_unapproved') {
            $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $transactionId . "' data-dt_view_url='".admin_url('PurchaseReturn/view') ."'>" . $transactionCodeName . "</a><br>";
        }
        else if($transactionType == 'quotation') {
            $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $transactionId . "' data-dt_view_url='".admin_url('Quotation/view') ."'>" . $transactionCodeName . "</a><br>";
        }
        else if($transactionType == 'sales_order') {
            $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $transactionId . "' data-dt_view_url='".admin_url('SalesOrder/view') ."'>" . $transactionCodeName . "</a><br>";
        }
        else if($transactionType == 'delivery_note' || $transactionType == 'delivery_note_unapproved') {
            $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $transactionId . "' data-dt_view_url='".admin_url('DeliveryNote/view') ."'>" . $transactionCodeName . "</a><br>";
        }
        else if($transactionType == 'adjustment_product_debit' || $transactionType == 'adjustment_product_credit') {
            $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $transactionId . "' data-dt_view_url='".admin_url('Adjustment/view') ."'>" . $transactionCodeName . "</a><br>";
        }
        return $html;
    }
}

if(!function_exists('commonFormSubmit')){
    function commonFormSubmit()
    {
        $formSubmits = array(
            "saved" => "Saved",
            "approved" => "Approved",
        );
        return $formSubmits;
    }
}

if (!function_exists('roundNumberWithComma')) {
    function roundNumberWithComma($number,$withSymbol = 1){



        // if($decimalPoint == ''){
        // 	$decimalPoint = getToFixedValue($companyId);
        // }

        // $amount = round($number, $decimalPoint);
        $amount = round($number);

        $amountArray = explode('.', $amount);
        // if (count($amountArray) == 1) {
        // 	$int = $amountArray[0];
        // 	$des = 00;
        // } else {
        // 	$int = $amountArray[0];
        // 	$des = $amountArray[1];
        // }
        // if (strlen($des) == 1) {
        // 	$des = $des . "0";
        // }
        // if ($int >= 0) {
        // 	$int = numFormatIndia($int);
        // 	$theMoney = $int . "." . $des;
        // } else {
        // 	$int = abs($int);
        // 	$int = numFormatIndia($int);
        // 	$theMoney = "-" . $int . "." . $des;
        // }

        if (count($amountArray) == 1) {
            $int = $amountArray[0];
            //$des = 00;
        } else {
            $int = $amountArray[0];
            //$des = $amountArray[1];
        }
        if ($int >= 0) {
            $int = numFormatIndia($int);
            $theMoney = $int;
        } else {
            $int = abs($int);
            $int = numFormatIndia($int);
            $theMoney = "-" . $int;
        }

        if ($withSymbol == 1) {
            $symbol = '₹';
            return $symbol . '' . $theMoney;
        } else {
            return $theMoney;
        }
    }
}
if (!function_exists('referenceDocumentToHtml')) {
    function referenceDocumentToHtml($referenceDocument,$referenceDocumentType,$returnType = 'html'){
        $html = '';
        $referenceDocument = explode(",",$referenceDocument);
        if(is_array($referenceDocument) and count($referenceDocument) > 0){
            foreach($referenceDocument as $documentData){
                list($documentId,$documentNumber) = explode("_",$documentData);
                 if($referenceDocumentType == 'quotation') {
                    $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $documentId . "' data-dt_view_url='".admin_url('Quotation/view') ."'>" . $documentNumber . "</a><br>";
                }
                else if($referenceDocumentType == 'sales_order') {
                    $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $documentId . "' data-dt_view_url='".admin_url('SalesOrder/view') ."'>" . $documentNumber . "</a><br>";
                }
                else if($referenceDocumentType == 'delivery_note') {
                    $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $documentId . "' data-dt_view_url='".admin_url('DeliveryNote/view') ."'>" . $documentNumber . "</a><br>";
                }
                else if($referenceDocumentType == 'invoice') {
                    $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $documentId . "' data-dt_view_url='".admin_url('Invoice/view') ."'>" . $documentNumber . "</a><br>";
                }
                else if($referenceDocumentType == 'good_receipt_note') {
                    $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $documentId . "' data-dt_view_url='".admin_url('GoodReceiptNote/view') ."'>" . $documentNumber . "</a><br>";
                }
            }
        }
        return $html;
    }
}


if (!function_exists('getDatatableLanguageArray')) {
    function getDatatableLanguageArray()
    {
        $lang = array(
            'lengthMenu' => '<span>'.lang("common_show").':</span> _MENU_',
            'search' => '<span>'.lang("common_filter").':</span> _INPUT_',
            'searchPlaceholder' => ''.lang("common_filter_message").'',
            'paginate' => array(
                'first' => "First",
                'last' => "Last",
                'next' => "&rarr;",
                'previous' => "&larr;"
            )
        );

        return $lang;
    }
}

if(!function_exists('accessFilter')){
    function accessFilter($dbObjRef, $moduleFieldArray,$api = 0,$apiArray = array()){
        $session = session();

        if (1 == 1) {
            if($api == 0){
                $societyId      = $session->get('society_id');
            } else {
                $societyId      = $apiArray['society_id'];
            }
            if(is_array($moduleFieldArray) && count($moduleFieldArray) > 0){
                foreach($moduleFieldArray as $module => $fieldId){
                    if ($module == 'society') {
                        $dbObjRef->whereIn($fieldId, explode(",", $societyId));
                    }
                }
            }
        }
    }
}

if (!function_exists('compareArray')) {
    function compareArray($oldData, $newData)
    {
        $newArray = [];
        foreach ($oldData as $key => $oldValue) {
            if (array_key_exists($key, $newData)) {
                $newArray[$key] = $newData[$key];
            }
        }
        return $newArray;
    }
}

if (!function_exists('compareAndCreateNewArray')) {
    function compareAndCreateNewArray($oldData, $newData) {
        $newArray = [];
        // Step 1: Iterate through each element of the old data array
        foreach ($oldData as $key => $oldValue) {
            // Step 2: Check if the key exists in the new data array
            if (array_key_exists($key, $newData)) {
                // Step 3: Compare values associated with the key
                if ($oldValue != $newData[$key]) {
                    // Step 4: Add the key and corresponding values to the new array
                    $newArray[$key] = ['oldValue' => $oldValue, 'newValue' => $newData[$key]];
                }
            } else {
                // Step 5: Add key from old data array to new array
                $newArray[$key] = ['oldValue' => $oldValue, 'newValue' => null];
            }
        }
        // Step 6: Add keys that exist only in the new data array to the new array
        foreach ($newData as $key => $newValue) {
            if (!array_key_exists($key, $oldData)) {
                $newArray[$key] = ['oldValue' => null, 'newValue' => $newValue];
            }
        }
        return $newArray;
    }
}


if (!function_exists('logActivity')) {
    /**
     * Log Activity for everything
     * @param  string $description Activity Description
     * @param  integer $staffid Who done this activity
     */
    function logActivity($description, $userId = null, $logModule = null,$logModuleId = null,$oldNewData = null,$compareData = null,$type = '',$typeId = 0,$societyId = 0)
    {

        $request    = \Config\Services::request();
        $os_br = new \App\Libraries\Dt_ci_browser_os();
        $session       = \Config\Services::session();
        // $db = \Config\Database::connect();
        helper('tenant');
        $db = getTenantDB();
        $user_ip = $request->getIPAddress();
        $platform = $os_br->showInfo('os');
        $browser = $os_br->showInfo('browser');

        $log = array(
            'description' => isset($description) ? $description : -1,
            'date' => date('Y-m-d H:i:s'),
            'user_browser'=> isset($browser) ? $browser : -1,
            'user_platform'=> isset($platform) ? $platform : -1,
            'user_ip'=> isset($user_ip) ? $user_ip : -1,
            'Module'=> isset($logModule) ? $logModule : -1,
            'module_id'=> isset($logModuleId) ? $logModuleId : -1,
            'old_new_data'=> isset($oldNewData) ? $oldNewData : -1,
            'difference_data'=> isset($compareData) ? $compareData : -1,
            'type' => isset($type) ? $type : '',
            'type_id' => isset($typeId) ? $typeId : 0,
        );

        if (!DEFINED('CRON')) {
            if ($userId != null && is_numeric($userId)) {
                $log['user_id']  = $userId ;
            } else {
                /// $log['staff_id'] = '[CRON]';
                $log['user_id'] = '00';

            }
        } else {
            // manually invoked cron
            if (isset($userId)) {
                $log['user_id'] = $userId;
            } else {
                // $log['staff_id'] = '[CRON]';
                $log['user_id'] = '00';
            }
        }
        if($session->get('user_id')){
            $log['society_id'] = $session->get('society_id');
        } else {
            $log['society_id'] = $societyId;
        }

        $builder = $db->table('tbl_activity_log');
        $builder->insert($log);
    }
}

if (!function_exists('flatDocumentToHtml')) {
    function flatDocumentToHtml($flatTowerName,$flatId,$returnType = 'html'){
        $html = '';
        $html .= "<a class='text-primary text-bold  dt-detail-model-view' data-dt_view_id='" . $flatId . "' data-dt_view_url='".admin_url('Flat/view') ."'>" . $flatTowerName . "</a><br>";
        return $html;
    }
}

if (!function_exists('towerDocumentToHtml')) {
    function towerDocumentToHtml($towerName,$towerId,$returnType = 'html'){
        $html = '';
        $html .= "<a class='text-primary text-bold  dt-detail-model-view' data-dt_view_id='" . $towerId . "' data-dt_view_url='".admin_url('Tower/view') ."'>" . $towerName . "</a><br>";
        return $html;
    }
}

if(!function_exists('statusFor')){
    function statusFor()
    {
        $statusFor = array(
            "rentals" => "Rentals",
            "complain" => "Complain",
            "sos_emergency" => "Sos Emergency",
    );
    return $statusFor;
    }
}

if (!function_exists('formsArray')) {
    function formsArray()
    {
        $formsArray = array(
            "Booklet (Permanent Record)" => array(
                "Inventories Handover",
                "4-Wheelers & Token Issue",
                "2-Wheelers & Sticker Issue",
                "Identity Cards Issued (Staff)",
                "Amenities Use Cards",
                "Intercom Given",
                "Biometric Access Cards",
                "Barcode Issued",
                "Advance Maintenance & Security Deposits"
            ),
            "General" => array(
                "Check-list (Facilities-Amenities-Housekeeping)",
                "Amenities Entry Registers",
                "Electric Goods & Service Chalan",
                "Attendance Sheets",
                "Cash Voucher",
                "Voting Sheet",
                "Meeting Attendance"
            ),
            "Information" => array(
                "Members",
                "Tenants",
                "Staff"
            ),
            "Correspondence" => array(
                "General",
                "Personal",
                "Statutory"
            ),
            "Application" => array(
                "Facilities Booking (with Rules & Item Checklist for Organizer)",
                "Permission for Furniture/Renovation",
                "Alteration in Flats",
                "Direct Maintenance Deposits",
                "Car Tokens"
            ),
            "Agreements" => array(
                "Security",
                "Housekeeping",
                "Electrician",
                "Plumber",
                "Gardener"
            ),
            "NOC & Certificates" => array(
                "Bank Loan",
                "Name Transfer",
                "Leave & License",
                "Sale of Flat"
            ),
            "Statutory Forms" => array(
                "Application for Membership",
                "Cancellation of Membership",
                "Associate Membership",
                "Share Transfer Form",
                "Request for Duplicate Share Certificate",
                "Indemnity Bond for Duplicate Share Certificate",
                "Lodging FIR for Share Certificate Lost",
                "Consent for attending GM by Joint Owner",
                "Consent for Proxy Voting",
                "Society Charge Handover",
                "Change of Signature in Bank"
            ),
            "Rules & Regulations" => array(
                "Statutory Compliance",
                "Work Division",
                "Security SOP",
                "Furniture & Renovation Rules",
                "Function Organizing Rules",
                "Rules & Timings Boards",
                "Standard Operating Procedure"
                // "Standard Operating Procedure" => array(
                //     "General",
                //     "Management & Timings",
                //     "Fee & Charges",
                //     "Amenities & Facilities Usage",
                //     "Expenses & Payments",
                //     "Penalties",
                //     "Parking",
                //     "Security System",
                //     "Cleaning System",
                //     "Attendance Rules",
                //     "Do’s & Don’ts"
                // )
            )
        );

        return $formsArray;
    }
}

if(!function_exists('formatesArray')){
    function formatesArray()
    {
        $formatesArray = array(
            "",
            "General",
            "Information",
            "Correspondence",
            "Application",
            "Agreements",
            "NOC & Certificates",
            "Statutory Forms",
            "Rules & Regulations",
        );
        return $formatesArray;
    }
}

if (!function_exists('getIndianCurrency')) {

    function getIndianCurrency($number)
    {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(
            0 => '',
            1 => 'one',
            2 => 'two',
            3 => 'three',
            4 => 'four',
            5 => 'five',
            6 => 'six',
            7 => 'seven',
            8 => 'eight',
            9 => 'nine',
            10 => 'ten',
            11 => 'eleven',
            12 => 'twelve',
            13 => 'thirteen',
            14 => 'fourteen',
            15 => 'fifteen',
            16 => 'sixteen',
            17 => 'seventeen',
            18 => 'eighteen',
            19 => 'nineteen',
            20 => 'twenty',
            30 => 'thirty',
            40 => 'forty',
            50 => 'fifty',
            60 => 'sixty',
            70 => 'seventy',
            80 => 'eighty',
            90 => 'ninety'
        );
        $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str[] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal) ? "." . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ? $Rupees . 'Rupees ' : '') . $paise;
    }
}

if (!function_exists('vendorDocumentToHtml')) {
    function vendorDocumentToHtml($vendorName,$vendorId,$returnType = 'html'){
        $html = '';
        $html .= "<a class='text-primary text-bold dt-detail-model-view' data-dt_view_id='" . $vendorId . "' data-dt_view_url='".admin_url('Vendor/view') ."'>" . $vendorName . "</a><br>";
        return $html;
    }
}

if (!function_exists('staffDocumentToHtml')) {
    function staffDocumentToHtml($staffName,$staffId,$returnType = 'html'){
        $html = '';
        $html .= "<a class='text-primary text-bold  dt-detail-model-view' data-dt_view_id='" . $staffId . "' data-dt_view_url='".admin_url('Staff/view') ."'>" . $staffName . "</a><br>";
        return $html;
    }
}


if (!function_exists('resourceDocumentToHtml')) {
    function resourceDocumentToHtml($resourceName,$resourceId,$returnType = 'html'){
        $html = '';
        $html .= "<a class='text-primary text-bold  dt-detail-model-view' data-dt_view_id='" . $resourceId . "' data-dt_view_url='".admin_url('Resource/view') ."'>" . $resourceName . "</a><br>";
        return $html;
    }
}

if (!function_exists('generatorDocumentToHtml')) {
    function generatorDocumentToHtml($generatorName,$generatorId,$returnType = 'html'){
        $html = '';
        $html .= "<a class='text-primary text-bold  dt-detail-model-view' data-dt_view_id='" . $generatorId . "' data-dt_view_url='".admin_url('Generator/view') ."'>" . $generatorName . "</a><br>";
        return $html;
    }
}


if(!function_exists('staffType')){
    function staffType()
    {
        $staffTypes = array(
            "servants"=>"Servants",
            "house_maids"=>"House Maids",
            "drivers" => "Drivers",
            "guard" => "Guard"
        );
        return $staffTypes;
    }
}

if(!function_exists('gateType')){
    function gateType()
    {
        $gateTypes = array(
            "inside"=>"Inside",
            "outside"=>"Outside",
        );
        return $gateTypes;
    }
}

// if(!function_exists('documentFor')){
//     function documentFor()
//     {
//         $documentFors = array(
//             // "staff" => "Staff",
//             "ownership_flat" => "Ownership Flat",
//             "rentals" => "Rentals",
//         );
//         return $documentFors;
//     }
// }

if (!function_exists('documentFormat')) {
    function documentFormat()
    {
        $documentFormats = array(
            "pdf" => "PDF",
            "image" => "Image",
        );
        return $documentFormats;
    }
}
if (!function_exists('intercomType')) {
    function intercomType()
    {
        $intercomType = array(
            "flat" => "Flat",
            "common_area" => "Common Area",
        );
        return $intercomType;
    }
}
if (!function_exists('areaType')) {
    function areaType()
    {
        $areaType = array(
            "carpet" => "Carpet",
            "super_build_up" => "Super Build-up",
            "rera_carpet" => "Rera Carpet",
        );
        return $areaType;
    }
}

if (!function_exists('amcType')) {
    function amcType()
    {
        $amcType = array(
            "essential_facailities_services" => "Essential Facailities Services",
            "other_facailities_services" => "Other Facailities Services",
            "outsourced_services" => "Outsourced Services",
        );
        return $amcType;
    }
}

if (!function_exists('serviceType')) {
    function serviceType()
    {
        $serviceType = array(
            "break_down" => "Break Down",
            "preventive" => "Preventive",
        );
        return $serviceType;
    }
}

if (!function_exists('visitType')) {
    function visitType()
    {
        $visitType = array(
            "covered_under_amc" => "Covered Under AMC",
            "paid" => "Paid",
        );
        return $visitType;
    }
}

if (!function_exists('bankAccountType')) {
    function bankAccountType()
    {
        $bankAccountType = array(
            "savings" => "Savings",
            "current" => "Current",
        );
        return $bankAccountType;
    }
}

if (!function_exists('numberType')) {
    function numberType()
    {
        $numberTypes = array(
            "range" => "Range",
            "manual" => "Manual",
        );
        return $numberTypes;
    }
}


if (!function_exists('bloodGroupType')) {
    function bloodGroupType()
    {
        $bloodGroupTypes = array(
            "A+" => "A+",
            "A-" => "A-",
            "B+" => "B+",
            "B-" => "B-",
            "O+" => "O+",
            "O-" => "O-",
            "AB+" => "AB+",
            "AB-" => "AB-",
        );
        return $bloodGroupTypes;
    }
}



if (!function_exists('relation')) {
    function relation()
    {
        $relations = array(
            "my_self"=> "My Self",
            "mother" => "Mother",
            "father" => "Father",
            "wife" => "Wife",
            "daughter" => "Daughter",
            "son" => "Son",
            "sister" => "Sister",
            "brother" => "Brother",
            "aunt" => "Aunt",
            "uncle" => "Uncle",
            "niece" => "Niece",
            "nephew" => "Nephew",
            "cousin(female)" => "Cousin(Female)",
            "cousin(male)" => "Cousin(Male)",
            "grandmother" => "Grand Mother",
            "grandfather" => "Grand Father",
            "granddaughter" => "Grand Daughter",
            "grandson" => "Grand Son",
            "stepsister" => "Step Sister",
            "stepmother" => "Step Mother",
            "stepfather" => "Step Father",
            "stepbrother" => "Step Brother",
            "stepdaughter" => "Step Daughter",
            "stepson" => "Step Son",
            "sister_in_law" => "Sister In Law",
            "brother_in_law" => "Brother In Law",
            "mother_in_law" => "Mother In Law",
            "father_in_law" => "Father In Law",
            "daughter_in_law" => "Daughter In Law",
            "son_in_law" => "Son In Law",
            "sibling_(gender_neutral)" => "Sibling (Gender Neutral)",
            "parent_(gender_neutral)" => "Parent (Gender Neutral)",
            "child_(gender_neutral)" => "Child (Gender Neutral)",
            "sibling_of_parent_(gender_neutral)" => "Sibling Of Parent (Gender Neutral)",
            "child_of_sibling_(gender_neutral)" => "child of sibling (Gender Neutral)",
            "cousin_(gender_neutral)" => "Cousin (Gender Neutral)",
            "grandparent_(gender_neutral)" => "Grand Parent (Gender Neutral)",
            "grandchild_(gender_neutral)" => "Grand Child (Gender Neutral)",
            "step_sibling_(gender_neutral)" => "Step Sibling (Gender Neutral)",
            "step_parent_(gender_neutral)" => "Step Parent (Gender Neutral)",
            "step_child_(gender_neutral)" => "Step Child (Gender Neutral)",
            "sibling_in_law_(gender_neutral)" => "Sibling-In-Law (Gender Neutral)",
            "parent_in_law_(gender_neutral)" => "Parent-In-Law (Gender Neutral)",
            "child_in_law_(gender_neutral)" => "Child-In-Law (Gender Neutral)",
            "family_member(gender_neutral)" => "Family Member(Gender Neutral)",
            "pet_(gender_neutral)" => "Pet (Gender Neutral)",
            "other"=>"Other",
        );
        return $relations;
    }
}



if(!function_exists('foodLike')){
    function foodLike()
    {
        $foodLikes = array(
            "jain" => "Jain",
            "non_jain"=>"Non Jain",
            "veg" => "Veg",
            "non_veg" => "Non Veg",
        );
        return $foodLikes;
    }
}
if(!function_exists('paymentMethod')){
    function paymentMethod()
    {
        $paymentMethods = array(
            "cash" => "Cash",
        );
        return $paymentMethods;
    }
}

if (!function_exists('vehicleType')) {
    function vehicleType()
    {
        $vehicleTypes = array(
            "2_wheelers" => "2 Wheelers",
            "4_wheelers" => "4 Wheelers",
        );
        return $vehicleTypes;
    }
}

if (!function_exists('flatType')) {
    function flatType()
    {
        $flatTypes = array(
            "ownership_flat" => "Ownership Flat",
            "rentals" => "Rentals",
        );
        return $flatTypes;
    }
}


if (!function_exists('generate_pdf')) {
    /**
     * Log Activity for everything
     * @param  string $description Activity Description
     * @param  integer $staffid Who done this activity
     */
    function generate_pdf($content, $name = 'download.pdf', $output_type = null, $footer = null, $margin_bottom = null, $header = null, $margin_top = null, $orientation = 'P')
    {
        $pdf    = new \App\Libraries\Dt_mpdf();
        return $pdf->generate($content, $name, $output_type, $footer, $margin_bottom, $header, $margin_top, $orientation);
    }
}

//if (!function_exists('staffDocumentToHtml')) {
//    function staffDocumentToHtml($staffName,$staffId,$returnType = 'html'){
//        $html = '';
//        $html .= "<a class='text-primary text-bold font-weight-bold dt-detail-model-view' data-dt_view_id='" . $staffId . "' data-dt_view_url='".admin_url('Staff/view') ."'>" . $staffName . "</a><br>";
//        return $html;
//    }
//}


if (!function_exists('genderType')) {
    function genderType()
    {
        $genderTypes = array(
            "male" => "Male",
            "female" => "Female",
        );
        return $genderTypes;
    }
}
if (!function_exists('monthsDropDown')) {
    function monthsDropDown($selected = null){

        $months = array();
        for ($i = 0; $i < 12; $i++) {
            $timestamp = mktime(0, 0, 0, date('n') - $i, 1);
            //$months[date('n', $timestamp)] = date('F', $timestamp);
            $months[date('m', $timestamp)] = date('F', $timestamp);
        }

        return arrayToHTMLOptions($months, $selected);
    }
}

if (!function_exists('yearDropDown')) {
    function yearDropDown($from, $to, $selected)
    {
        $years = array();
        for ($i = $to; $i >= $from; $i--) {
            $years[$i] = $i;
        }
        return arrayToHTMLOptions($years, $selected);
    }
}

if (!function_exists('arrayToHTMLOptions')) {
    function arrayToHTMLOptions($option_array, $selected = null){
        $options = "";
        foreach ($option_array as $key => $val){
            if(is_array($selected) && !empty($selected)){
                $options .= (in_array($key, $selected)) ? "<option value='$key' selected='selected'>$val</option>" : "<option value='$key'>$val</option>";
            }else{
                $options .= (!is_null($selected) && $key == $selected) ? "<option value='$key' selected='selected'>$val</option>" : "<option value='$key'>$val</option>";
            }

        }
        return $options;

    }
}
if (!function_exists('time_elapsed_string')) {
//times now
    function time_elapsed_string($datetime, $full = false)
    {
        $now = new DateTime;
        $ago = new DateTime($datetime);
        $diff = $now->diff($ago);

        $diff->w = floor($diff->d / 7);
        $diff->d -= $diff->w * 7;

        $string = array(
            'y' => 'year',
            'm' => 'month',
            'w' => 'week',
            'd' => 'day',
            'h' => 'hour',
            'i' => 'minute',
            's' => 'second',
        );
        foreach ($string as $k => &$v) {
            if ($diff->$k) {
                $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
            } else {
                unset($string[$k]);
            }
        }

        if (!$full) $string = array_slice($string, 0, 1);
        return $string ? implode(', ', $string) . ' ago' : 'just now';
    }
}


if (!function_exists('categoryFor')) {
    function categoryFor()
    {
        $categoryFor = array(
            "vendor" => "Vendor",
            "complain" => "Complain",
            // "resource" => "Resource",
            "notice" => "Notice",
            "event" => "Event",
            "sos" => "Sos",
            "faq" => "Faq",
        );
        return $categoryFor;
    }
}
if (!function_exists('notifiedToType')) {
    function notifiedToType()
    {
        $notifiedToType = array(
            "complete_society" => "Complete Society",
            "selected_towers" => "Selected Towers",
            "selected_flats" => "Selected Flats",
        );
        return $notifiedToType;
    }
}

if (!function_exists('amenitiesType')) {
    function amenitiesType()
    {
        $amenitiesType = array(
            "amenities" => "Amenities",
            "facilities" => "Facilities",
        );
        return $amenitiesType;
    }
}
if (!function_exists('materialType')) {
    function materialType()
    {
        $materialType = array(
            "inwards" => "Inwards",
            "outwards" => "Outwards",
        );
        return $materialType;
    }
}

if (!function_exists('materialFor')) {
    function materialFor()
    {
        $materialFor = array(
            "purchase" => "Purchase",
            "return" => "Return",
        );
        return $materialFor;
    }
}

if (!function_exists('genRandomNumber')) {
    function genRandomNumber($length)
    {
        $characters = "123456789";
        $string = '';
        for ($p = 0; $p < $length; $p++) {
            $string .= $characters[mt_rand(0, strlen($characters) - 1)];
        }
        return $string;
    }
}

if(!function_exists('resourceTypeAPI')){
    function resourceTypeAPI()
    {
        $resourceTypeAPI = [
            [
                "key" => "milkman",
                "value" => "Milkman"
            ],
            [
                "key" => "maid",
                "value" =>"Maid"
            ],
            [
                "key" => "gardener",
                "value" => "Gardener"
            ],
        ];
        return $resourceTypeAPI;
    }
}

if (!function_exists('relationAPI')) {
    function relationAPI()
    {
        $relationAPI = [
            ["key" => "my_self", "value" => "My Self"],
            ["key" => "mother", "value" => "Mother"],
            ["key" => "father", "value" => "Father"],
            ["key" => "wife", "value" => "Wife"],
            ["key" => "daughter", "value" => "Daughter"],
            ["key" => "son", "value" => "Son"],
            ["key" => "sister", "value" => "Sister"],
            ["key" => "brother", "value" => "Brother"],
            ["key" => "aunt", "value" => "Aunt"],
            ["key" => "uncle", "value" => "Uncle"],
            ["key" => "niece", "value" => "Niece"],
            ["key" => "nephew", "value" => "Nephew"],
            ["key" => "cousin(female)", "value" => "Cousin(Female)"],
            ["key" => "cousin(male)", "value" => "Cousin(Male)"],
            ["key" => "grandmother", "value" => "Grand Mother"],
            ["key" => "grandfather", "value" => "Grand Father"],
            ["key" => "granddaughter", "value" => "Grand Daughter"],
            ["key" => "grandson", "value" => "Grand Son"],
            ["key" => "stepsister", "value" => "Step Sister"],
            ["key" => "stepmother", "value" => "Step Mother"],
            ["key" => "stepfather", "value" => "Step Father"],
            ["key" => "stepbrother", "value" => "Step Brother"],
            ["key" => "stepdaughter", "value" => "Step Daughter"],
            ["key" => "stepson", "value" => "Step Son"],
            ["key" => "sister_in_law", "value" => "Sister In Law"],
            ["key" => "brother_in_law", "value" => "Brother In Law"],
            ["key" => "mother_in_law", "value" => "Mother In Law"],
            ["key" => "father_in_law", "value" => "Father In Law"],
            ["key" => "daughter_in_law", "value" => "Daughter In Law"],
            ["key" => "son_in_law", "value" => "Son In Law"],
            ["key" => "sibling_(gender_neutral)", "value" => "Sibling (Gender Neutral)"],
            ["key" => "parent_(gender_neutral)", "value" => "Parent (Gender Neutral)"],
            ["key" => "child_(gender_neutral)", "value" => "Child (Gender Neutral)"],
            ["key" => "sibling_of_parent_(gender_neutral)", "value" => "Sibling Of Parent (Gender Neutral)"],
            ["key" => "child_of_sibling_(gender_neutral)", "value" => "Child of Sibling (Gender Neutral)"],
            ["key" => "cousin_(gender_neutral)", "value" => "Cousin (Gender Neutral)"],
            ["key" => "grandparent_(gender_neutral)", "value" => "Grand Parent (Gender Neutral)"],
            ["key" => "grandchild_(gender_neutral)", "value" => "Grand Child (Gender Neutral)"],
            ["key" => "step_sibling_(gender_neutral)", "value" => "Step Sibling (Gender Neutral)"],
            ["key" => "step_parent_(gender_neutral)", "value" => "Step Parent (Gender Neutral)"],
            ["key" => "step_child_(gender_neutral)", "value" => "Step Child (Gender Neutral)"],
            ["key" => "sibling_in_law_(gender_neutral)", "value" => "Sibling-In-Law (Gender Neutral)"],
            ["key" => "parent_in_law_(gender_neutral)", "value" => "Parent-In-Law (Gender Neutral)"],
            ["key" => "child_in_law_(gender_neutral)", "value" => "Child-In-Law (Gender Neutral)"],
            ["key" => "family_member(gender_neutral)", "value" => "Family Member(Gender Neutral)"],
            ["key" => "pet_(gender_neutral)", "value" => "Pet (Gender Neutral)"],
            ["key" => "other", "value" => "Other"],
        ];
        
        return $relationAPI;
    }
}

if (!function_exists('bloodGroupTypeAPI')) {
    function bloodGroupTypeAPI()
    {
        $bloodGroupTypeAPI = [
            [
                "key" => "A+",
                "value" => "A+"
            ],
            [
                "key" => "A-",
                "value" =>"A-"
            ],
            [
                "key" => "B+",
                "value" => "B+"
            ],
            [
                "key" => "B-",
                "value" => "B-"
            ],
            [
                "key" => "O+",
                "value" => "O+"
            ],
            [
                "key" => "O-",
                "value" => "O-"
            ],
            [
                "key" => "AB+",
                "value" => "AB+"
            ],
            [
                "key" => "AB-",
                "value" => "AB-"
            ],
        ];
        return $bloodGroupTypeAPI;
    }
}

if(!function_exists('sosTypeAPI')){
    function sosTypeAPI()
    {
        $sosTypeAPI = [
            [
                "key" => "family",
                "value" => "Family"
            ],
            [
                "key" => "gatekeeper",
                "value" =>"Gatekeeper"
            ],
            [
                "key" => "resident",
                "value" => "Resident"
            ],
            [
                "key" => "committee",
                "value" => "Committee"
            ],
        ];
        return $sosTypeAPI;
    }
}

// if (!function_exists('qrcode')) {
//     function qrcode($type = 'text', $text = '', $size = 2, $level = 'H', $sq = null,$userId)
//     {
//         $fileName = FCPATH . 'uploads/qrcode/qrcode' . $userId . ($sq ? $sq : '') . '.png';

//         if ($type == 'link') {
//             $text = urldecode($text);
//         }

//         // Load QR Code library
//         $this->config = config('IonAuth');
//         $this->ionAuth    = new \App\Libraries\IonAuth();
//         $qr = $this->ionAuth->Dt_qrcode();
//         $config = [
//             'data' => $text,
//             'size' => $size,
//             'level' => $level,
//             'savename' => $fileName
//         ];

//         // Generate QR Code
//         $qr->generate($config);

//         // Get image data
//         if (file_exists($fileName)) {
//             $imageData = file_get_contents($fileName);
//             return "<img src='data:image/png;base64," . base64_encode($imageData) . "' alt='{$text}' class='' />";
//         }

//         return '';
//     }
// }

// if (!function_exists('qrcode')) {
//     function qrcode($type = 'text', $text = '', $size = 2, $level = 'H', $sq = null, $userId)
//     {

//         $fileName = FCPATH . 'uploads/qrCode/' . $userId . ($sq ? $sq : '') . '.png';

//         if ($type == 'link') {
//             $text = urldecode($text);
//         }

//         // Load QR Code library
//         $qr    = new \App\Libraries\DT_qrcode();
//         // $qr = $ionAuth->Dt_qrcode();
//         $config = [
//             'data' => $text,
//             'size' => $size,
//             'level' => $level,
//             'savename' => $fileName
//         ];
//         // Generate QR Code
//         $qr->generate($config);

//         // Get image data
//         if (file_exists($fileName)) {
//             $imageData = file_get_contents($fileName);
//             return "<img src='data:image/png;base64," . base64_encode($imageData) . "' alt='{$text}' class='' />";
//         }

//         return '';
//     }
// }

if (!function_exists('qrcode')) {
   //function qrcode($type = 'text', $text = '', $size = 2, $level = 'H', $sq = null)
   function qrcode($type = 'text', $text = '', $size = 2, $level = 'QR_ECLEVEL_L', $sq = null)
   {
       $file_name =  UPLOAD_REL_PATH   .'qrcode/' . ($sq ? $sq : '') . '.png';
       if ($type == 'link') {
           $text = urldecode($text);
       }
       $qr    = new \App\Libraries\Dt_qrcode();
       $config = ['data' => $text, 'size' => $size, 'level' => $level, 'savename' => $file_name];
        $qr->generate($config);
       $imagedata = file_get_contents($file_name);
       return "<img src='data:image/png;base64," . base64_encode($imagedata) . "' alt='{$text}' class='' />";
   }
}

if (!function_exists('qrcodeEvent')) {
   //function qrcode($type = 'text', $text = '', $size = 2, $level = 'H', $sq = null)
   function qrcodeEvent($type = 'text', $text = '', $size = 2, $level = 'QR_ECLEVEL_L', $sq = null)
   {
       $file_name =  UPLOAD_REL_PATH   .'qrcode/event/' . ($sq ? $sq : '') . '.png';
       if ($type == 'link') {
           $text = urldecode($text);
       }
       $qr    = new \App\Libraries\Dt_qrcode();
       $config = ['data' => $text, 'size' => $size, 'level' => $level, 'savename' => $file_name];
        $qr->generate($config);
       $imagedata = file_get_contents($file_name);
       return "<img src='data:image/png;base64," . base64_encode($imagedata) . "' alt='{$text}' class='' />";
   }
}
if (!function_exists('convertDurationToMinute')) {
    function convertDurationToMinute($durationString) {
        // Basic implementation to handle common duration strings
        $parts = explode(' ', $durationString);
        $number = (int)$parts[0];
        $unit = $parts[1];

        switch ($unit) {
            case 'year':
            case 'years':
                return $number * 525600; // minutes in a year
            case 'month':
            case 'months':
                return $number * 43800; // minutes in a month
            case 'week':
            case 'weeks':
                return $number * 10080; // minutes in a week
            case 'day':
            case 'days':
                return $number * 1440; // minutes in a day
            case 'hour':
            case 'hours':
                return $number * 60; // minutes in an hour
            case 'minute':
            case 'minutes':
                return $number; // already in minutes
            case 'second':
            case 'seconds':
                return $number / 60; // convert seconds to minutes
            default:
                return 0; // Unknown duration
        }
    }
}

if (!function_exists('weekDays')) {
    function weekDays()
    {
        $weekDaysArray = array(
            array(
                "working_day_id" => "1",
                "working_day_name" => "Monday",
                "is_active" => false
            ),
            array(
                "working_day_id" => "2",
                "working_day_name" => "Tuesday",
                "is_active" => false
            ),
            array(
                "working_day_id" => "3",
                "working_day_name" => "Wednesday",
                "is_active" => false
            ),
            array(
                "working_day_id" => "4",
                "working_day_name" => "Thursday",
                "is_active" => false
            ),
            array(
                "working_day_id" => "5",
                "working_day_name" => "Friday",
                "is_active" => false
            ),
            array(
                "working_day_id" => "6",
                "working_day_name" => "Saturday",
                "is_active" => false
            ),
            array(
                "working_day_id" => "7",
                "working_day_name" => "Sunday",
                "is_active" => false
            )
        );
        return $weekDaysArray;
    }
}

if (!function_exists('genRandomAlphaNumeric')) {
    function genRandomAlphaNumeric($length)
    {
        $characters = "123456789abcdefghijklmnopqrstuvwxyz";
        $string = '';
        for ($p = 0; $p < $length; $p++) {
            $string .= $characters[mt_rand(0, strlen($characters) - 1)];
        }
        return $string;
    }
}

// if (!function_exists('sendNotification')) {
//     function sendNotification($data = array(),$notificationFor)
//     {
        
//     //     $content = array(
//     //         "en" => $data['title_name']
//     //     );
//     //     // $appUrl= $data['app_url'];
//     //     $notificationType= $data['notification_type'];
//     //     $playerId= $data['player_id'];
//     //     $hashes_array = array();

//     //     if(($notificationType == 'product') || ($notificationType == 'general')){
//     //             $fields = array(
//     //                 'app_id' => APP_ID,
//     //                 'included_segments' => array(
//     //                 'Subscribed Users'
//     //             ),
//     //           // 'app_url'=>$appUrl,
//     //                 'contents' => $content,
//     //                 'large_icon' => isset($data['image']) ? $data['image'] : "",
//     //             );
//     //     }
//     //     else{
//     //         $fields = array(
//     //             'app_id' => APP_ID,
//     //             'include_player_ids' => $playerId,
//     //             // 'app_url'=>$appUrl,
//     //             'contents' => $content,
//     //             'large_icon' => isset($data['image']) ? $data['image'] : "",
//     //         );
//     //     }
//     // if($notificationFor == 'android'){
//     //     $fields['isAndroid'] = true;
//     //     // $fields['big_picture'] = isset($data['image']) ? $data['image'] : "";
//     // }
//     // elseif($notificationFor == 'ios'){
//     //     $fields['isIos'] = true;
//     //     // $fields['ios_attachments'] = isset($data['image']) ? $data['image'] : "";
//     // }
//     //     if(isset($data['is_button'])){
//     //         array_push($hashes_array, array(
//     //             "id" => "like-button",
//     //             "text" => "Like",
//     //             "icon" => "http://i.imgur.com/N8SN8ZS.png",
//     //             "url" => "https://yoursite.com"
//     //         ));
//     //         $fields['web_buttons'] = $hashes_array;
//     //     }
//     //     $fields = json_encode($fields);
//     //     $ch = curl_init();
//     //     curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
//     //     curl_setopt($ch, CURLOPT_HTTPHEADER, array(
//     //         'Content-Type: application/json; charset=utf-8',
//     //         'Authorization: Basic NWNkZTdjZWMtMTQyMy00ZWViLThhODctMWY4OGNlY2JjYzU3'
//     //     ));
//     //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
//     //     curl_setopt($ch, CURLOPT_HEADER, FALSE);
//     //     curl_setopt($ch, CURLOPT_POST, TRUE);
//     //     curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
//     //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
//     //     $response = curl_exec($ch);
//     //     curl_close($ch);
//     //     return $response;


//         $content = [
//             "en" => $data['title_name']
//         ];

//         // Determine notification fields based on type
//         $notificationType = $data['notification_type'];
//         $playerId = $data['player_id'];
//         $hashes_array = [];

//         if ($notificationType == 'product' || $notificationType == 'general') {
//             $fields = [
//                 'app_id' => APP_ID,
//                 'included_segments' => ['Subscribed Users'],
//                 'contents' => $content,
//                 'large_icon' => $data['image'] ?? "",
//             ];
//         } else {
//             $fields = [
//                 'app_id' => APP_ID,
//                 'include_player_ids' => [$playerId],
//                 'contents' => $content,
//                 'large_icon' => $data['image'] ?? "",
//             ];
//         }

//         // Add platform-specific fields
//         if ($notificationFor == 'android') {
//             $fields['isAndroid'] = true;
//         } elseif ($notificationFor == 'ios') {
//             $fields['isIos'] = true;
//         }

//         // Add web button if specified
//         if (isset($data['is_button'])) {
//             $hashes_array[] = [
//                 "id" => "like-button",
//                 "text" => "Like",
//                 "icon" => "http://i.imgur.com/N8SN8ZS.png",
//                 "url" => "https://yoursite.com"
//             ];
//             $fields['web_buttons'] = $hashes_array;
//         }

//         // Convert fields to JSON
//         $fields = json_encode($fields);

//         $client = \Config\Services::curlrequest();

//         try {
//             $response = $client->request('POST', 'https://onesignal.com/api/v1/notifications', [
//                 'headers' => [
//                     'Content-Type' => 'application/json; charset=utf-8',
//                     'Authorization' => 'Basic ' . getenv('ONESIGNAL_REST_API_KEY'),
//                 ],
//                 'body' => $fields,
//                 'verify' => false,
//             ]);

//             // Capture response and status code
//             $responseBody = $response->getBody();
//             $statusCode = $response->getStatusCode();

//             log_message('error', 'OneSignal HTTP Status Code: ' . $statusCode);
//             log_message('error', 'OneSignal Response Body: ' . $responseBody);

//             if ($statusCode !== 200) {
//                 throw new \Exception('OneSignal API returned status code ' . $statusCode . ': ' . $responseBody);
//             }

//             return $responseBody;
//         } catch (\Exception $e) {
//             // Log detailed error message
//             log_message('error', 'Notification error: ' . $e->getMessage());
//             return 'Failed to send notification. Please check the logs for details.';
//         }
//     }
// }


if (!function_exists('sendNotificationAndroid')) {
    function sendNotificationAndroid($notificationData = array())
    {
        $content = [
            "en" => $notificationData['description']
        ];
        $headings = [
            "en" => $notificationData['title_name']
        ];
        $appUrl= isset($notificationData['app_url']) ? $notificationData['app_url'] : "" ;
        $playerId = $notificationData['player_id'];
        $fields = [
            'app_id' => APP_ID, // Replace with your actual App ID OneSignal App ID
            // 'included_segments' => array('All'),
            'include_player_ids' => $playerId,
            'headings' => $headings,
            'contents' => $content,
            'app_url'=>$appUrl,
            'data' => json_decode($notificationData['extra_data'])
        ];
        // printArray($fields,1);
        $fields['isAndroid'] = true;
        $fields = json_encode($fields);
        // printArray($fields,1);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic MTE2NzAwYjUtNThhMC00MTczLWIzMTgtNDMyMzFhMzhlOWYz' // rest-api key
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $response = curl_exec($ch);
        // printArray($response,1);
        curl_close($ch);
        return $response;
    }
}


if (!function_exists('sendNotificationIOS')) {
    function sendNotificationIOS($notificationData = array())
    {
        $content = [
            "en" => $notificationData['description']
        ];
        $headings = [
            "en" => $notificationData['title_name']
        ];
        $appUrl=isset($notificationData['app_url']) ? $notificationData['app_url'] : '';
        $playerId = $notificationData['player_id'];
        $fields = [
            'app_id' => APP_ID, // Replace with your actual App ID OneSignal App ID
            'include_player_ids' => $playerId,
            'headings' => $headings,
            'contents' => $content,
            'app_url'=>$appUrl,
            'data' => json_decode($notificationData['extra_data'])
        ];


        $fields['isIos'] = true;


        $fields = json_encode($fields);

        // printArray($fields,1);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic MTE2NzAwYjUtNThhMC00MTczLWIzMTgtNDMyMzFhMzhlOWYz' // rest-api key
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $response = curl_exec($ch);

        // printArray($response,1);
        curl_close($ch);
        return $response;
    }
}
if (!function_exists('testNo')) {

    function testNo($heading, $message, $userIds)
    {
        $content = [
            "en" => $message
        ];

        $fields = [
            'app_id' => APP_ID,
            'include_player_ids' => $userIds,
            'headings' => [
                "en" => $heading
            ],
            'contents' => $content,
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic MTE2NzAwYjUtNThhMC00MTczLWIzMTgtNDMyMzFhMzhlOWYz'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        $result = curl_exec($ch);
        curl_close($ch);

        return json_decode($result);
    }
}

if (!function_exists('sendNotificationBackUP')) {
    function sendNotificationBackUP(array $data, string $notificationFor)
    {
        $content = [
            "en" => $data['description']
        ];
        $headings = [
            "en" => $data['title_name']
        ];
        $playerId=$data['player_id'];
        $fields = [
            'app_id' => APP_ID, // Replace with your actual App ID
            //'included_segments' => array('All'),
            'include_player_ids' => $playerId,
            'headings' => $headings,
            'contents' => $content,
            'data' => json_decode($data['extra_data'])
        ];

        if ($notificationFor == 'android') {
            $fields['isAndroid'] = true;
        } elseif ($notificationFor == 'ios') {
            $fields['isIos'] = true;
        }

        $fields = json_encode($fields);

        // printArray($fields,1);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic MTE2NzAwYjUtNThhMC00MTczLWIzMTgtNDMyMzFhMzhlOWYz'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $response = curl_exec($ch);

        // printArray($response,1);
        curl_close($ch);
        return $response;

//        $client = \Config\Services::curlrequest();
//
//
//        try {
//            $response = $client->request('POST', 'https://onesignal.com/api/v1/notifications', [
//                'headers' => [
//                    'Content-Type' => 'application/json; charset=utf-8',
//                    'Authorization' => 'Basic NWNkZTdjZWMtMTQyMy00ZWViLThhODctMWY4OGNlY2JjYzU3', // Replace with your actual API Key
//                ],
//                'body' => $fields,
//                'verify' => false,
//            ]);
//
//            $responseBody = $response->getBody();
//            $statusCode = $response->getStatusCode();
//
//            log_message('error', 'OneSignal HTTP Status Code: ' . $statusCode);
//            log_message('error', 'OneSignal Response Body: ' . $responseBody);
//
//            if ($statusCode !== 200) {
//                throw new \Exception('OneSignal API returned status code ' . $statusCode . ': ' . $responseBody);
//            }
//
//            return $responseBody;
//        } catch (\Exception $e) {
//            log_message('error', 'Notification error: ' . $e->getMessage());
//            return 'Failed to send notification. Please check the logs for details.';
//        }
    }
}

if (!function_exists('visitorListData')) {
    function visitorListData($visitorArray = array(),$userId = 0)
    {
        $visitorModel    = new \App\Models\VisitorModel();
        $visitorData = $visitorModel->getVisitorData($visitorArray);
        $objectFilterData = array(
            'flat_id' => array('flat_id','tower_flat_name'),
            'ownership_flat_member_id' => array('ownership_flat_member_id','name','flat_number','flat_name','member_image','member_number'),
            'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
            'visitor_company_id' => array('visitor_company_id','visitor_company_name','visitor_company_image'),
            'resource_type_id' => array('resource_type_id','resource_type_name'),
            'parking_slot_id' => array('parking_slot_id','number','parking_block_display'),
        );
        $visitorDocumentDataWise = array();
        $visitorWorkingDayDataWise = array();
        $visitorIdArray = array();
        $visitorMediaData = array();
        if(!empty($visitorData)) {
            foreach($visitorData as $vdKey => $visitorElement){
                $path = site_url('uploads/no_image.png');
                $thumbnailPath = site_url('uploads/no_image.png');
                $visitorCompanyPath = site_url('uploads/no_image.png');
                $visitorCompanyThumbnailPath = site_url('uploads/no_image.png');
                $memberName = isset($visitorElement['name']) ? $visitorElement['name'] : "";
                $flatNumber = isset($visitorElement['tower_flat_name']) ? $visitorElement['tower_flat_name'] : "";
                $visitorData[$vdKey]['flat_number'] = $flatNumber;
                $visitorData[$vdKey]['flat_name'] = $flatNumber." ".$memberName;
                if ($visitorElement['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $visitorElement['member_image'])) {
                    $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $visitorElement['member_image'];
                }
                $visitorData[$vdKey]['member_image'] = $path;
                if ($visitorElement['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $visitorElement['member_image'])) {
                    $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $visitorElement['member_image'];
                }
                $visitorData[$vdKey]['thumbnail_member_image'] = $thumbnailPath;

                if ($visitorElement['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorElement['visitor_company_image'])) {
                    $visitorCompanyPath = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorElement['visitor_company_image'];
                }
                $visitorData[$vdKey]['visitor_company_image'] = $visitorCompanyPath;

                if ($visitorElement['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorElement['visitor_company_image'])) {
                    $visitorCompanyThumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorElement['visitor_company_image'];
                }
                $visitorData[$vdKey]['thumbnail_visitor_company_image'] = $visitorCompanyThumbnailPath;

                if($visitorElement['created_by'] == $userId){
                    $visitorData[$vdKey]['is_visitor_created_by_me'] = 1;
                } else {
                    $visitorData[$vdKey]['is_visitor_created_by_me'] = 0;
                }
                $visitorIdArray[] = $visitorElement['visitor_id'];
                if($visitorElement['type'] != 'resource'){
                    $visitorImageData = $visitorModel->getDocumentImageData(array(
                        "document_type_id" => $visitorElement['visitor_id'],
                        "document_type" => 'visitor',
                        "is_multiple" => 1
                    ));
                }
                else{
                    $visitorImageData = $visitorModel->getDocumentImageData(array(
                        "document_type_id" => $visitorElement['resource_id'],
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                }
                $visitorMediaData = array();
                if(!empty($visitorImageData)) {
                    foreach ($visitorImageData as $visitorImageElement) {
                        if ($visitorImageElement["document_image"] == '') {
                            $visitorImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                            $visitorImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                        } else {
                            $visitorImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
                            $visitorImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
                        }
                        $visitorMediaData[] = $visitorImageElement;
                    }
                }
                $visitorData[$vdKey]['visitor_image_data'] = $visitorMediaData;
            }
            if(!empty($visitorIdArray)){
                $visitorWorkingDayData = $visitorModel->getVisitorWorkingDayData(array(
                    "visitor_id" => $visitorIdArray,
                    "is_multiple" => 1
                ));
                if(!empty($visitorWorkingDayData)) {
                    foreach ($visitorWorkingDayData as $visitorWorkingElement) {
                        $visitorWorkingDayDataWise[$visitorWorkingElement['visitor_id']][] = $visitorWorkingElement;
                    }
                }
                
            }
        }
        if (!empty($visitorData)) {
            foreach ($visitorData as $vKey => $visitor) {
                $visitorData[$vKey] = getModuleObjectData($objectFilterData,$visitor);
                if($visitor['status'] == 'entered' || $visitor['status'] == 'exited'){
                    $endDate = isValidDate($visitor['end_date']) ? $visitor['end_date'] : date("Y-m-d H:i:s");
                    $visitorData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($visitor['start_date'],$endDate);
                }
                $visitorData[$vKey]['display_created_at'] = isValidDate($visitor['created_at']) ? YMDToDMY($visitor["created_at"],true) : "";
                $visitorData[$vKey]['display_updated_at'] = isValidDate($visitor['updated_at']) ? YMDToDMY($visitor["updated_at"],true) : "";
                // $formattedResourceType = getResourceKeyValue($visitorElement['resource_type']);
                // $visitorData[$vKey]['resource_type_display'] = $formattedResourceType;
                $visitorData[$vKey]['visitor_type_display'] = underscoreToUcWord($visitor["type"]);
                $visitorData[$vKey]['visitor_duration_display'] = underscoreToUcWord($visitor["visitor_duration"]);
                $visitorData[$vKey]['status_display'] = underscoreToUcWord($visitor["status"]);
                $visitorData[$vKey]['created_at_display'] = time_elapsed_string($visitor['created_at']);
                $visitorData[$vKey]['updated_at_display'] = time_elapsed_string($visitor['updated_at']);
                $visitorData[$vKey]["expected_start_date_time_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y h:i A', strtotime($visitor["expected_start_date_time"])) : "";
                $visitorData[$vKey]["expected_end_date_time_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitor["expected_end_date_time"])) : "";
                $visitorData[$vKey]["start_date_time_display"] = isValidDate($visitor['start_date']) ? date('d M, Y h:i A', strtotime($visitor["start_date"])) : "";
                $visitorData[$vKey]["delivery_date_time_display"] = isValidDate($visitor['delivery_date']) ? date('d M, Y h:i A', strtotime($visitor["delivery_date"])) : "";
                $visitorData[$vKey]["end_date_time_display"] = isValidDate($visitor['end_date']) ? date('d M, Y h:i A', strtotime($visitor["end_date"])) : "";
                $visitorData[$vKey]["expected_start_date_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y', strtotime($visitor["expected_start_date_time"])) : "";
                $visitorData[$vKey]["expected_end_date_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M, Y', strtotime($visitor["expected_end_date_time"])) : "";
                $visitorData[$vKey]["start_date_display"] = isValidDate($visitor['start_date']) ? date('d M, Y', strtotime($visitor["start_date"])) : "";
                $visitorData[$vKey]["end_date_display"] = isValidDate($visitor['end_date']) ? date('d M, Y', strtotime($visitor["end_date"])) : "";
                $path = site_url('uploads/no_image.png');
                $thumbnailPath = site_url('uploads/no_image.png');
                if ($visitor['id_proof'] != '' && file_exists(ID_PROOF_PATH . $visitor['id_proof'])) {
                    $path = site_url() . ID_PROOF_PATH . $visitor['id_proof'];
                }
                $visitorData[$vKey]['id_proof'] = $path;
                if ($visitor['id_proof'] != '' && file_exists(THUMBNAIL_ID_PROOF_PATH . $visitor['id_proof'])) {
                    $thumbnailPath = site_url() . THUMBNAIL_ID_PROOF_PATH . $visitor['id_proof'];
                }
                $visitorData[$vKey]['thumbnail_id_proof'] = $thumbnailPath;
                $qrCodePath = '';
                if ($visitor['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $visitor['qr_code_image'])) {
                    $qrCodePath = site_url() . QR_CODE_IMAGE_PATH . $visitor['qr_code_image'];
                }
                $visitorData[$vKey]['qr_code_image'] = $qrCodePath;

                $visitorData[$vKey]['visitor_working_day_data'] = array_key_exists($visitor['visitor_id'],$visitorWorkingDayDataWise) ? $visitorWorkingDayDataWise[$visitor['visitor_id']]: array();
                
                $shareData = array(
                    'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                    'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                    'share_image' => base_url('uploads/no_image.png'),
                    "share_link" => "https://digitattva.in/",
                    "share_qr_code_image" => $qrCodePath,
                );
                $visitorData[$vKey]['share_data'] = $shareData;
            }
        }
        return $visitorData;
    }
}

if (!function_exists('sendNotificationDataList')) {
    function sendNotificationDataList($filterData = array(),$extraDataJson = '')
    {
        $ownershipFlatModel    = new \App\Models\OwnershipFlatModel();
        $commonWebserviceModel    = new \App\Models\CommonWebserviceModel();
        $resourceTypeModel    = new \App\Models\ResourceTypeModel();
        $ownershipFlatMemberId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : 0;
        $appType = isset($filterData['app_type']) ? $filterData['app_type'] : 0;
        $collectOnGate = isset($filterData['collect_on_gate']) ? $filterData['collect_on_gate'] : 0;
        $ownershipFlatId = isset($filterData['ownership_flat_id']) ? $filterData['ownership_flat_id'] : 0;
        $societyId = isset($filterData['society_id']) ? $filterData['society_id'] : 0;
        $userId = isset($filterData['user_id']) ? $filterData['user_id'] : 0;
        $visitorName = isset($filterData['visitor_name']) ? $filterData['visitor_name'] : '';
        $typeId = isset($filterData['type_id']) ? $filterData['type_id'] : 0;
        $type = isset($filterData['type']) ? $filterData['type'] : '';
        $status = isset($filterData['status']) ? $filterData['status'] : '';
        $visitorCompanyName = isset($filterData['visitor_company_name']) ? $filterData['visitor_company_name'] : '';
        $noOfParcel = isset($filterData['no_of_parcel']) ? $filterData['no_of_parcel'] : '';
        $guard = isset($filterData['guard']) ? $filterData['guard'] : '';
        $vehicleNo = isset($filterData['vehicle_no']) ? $filterData['vehicle_no'] : '';
        $categoryName = isset($filterData['category_name']) ? $filterData['category_name'] : '';
        // $sosName = isset($filterData['sos_name']) ? $filterData['sos_name'] : '';
        $memberName = isset($filterData['member_name']) ? $filterData['member_name'] : '';
        $complainTitle = isset($filterData['complain_title']) ? $filterData['complain_title'] : '';
        $pollTitle = isset($filterData['poll_title']) ? $filterData['poll_title'] : '';
        $complainNumber = isset($filterData['complain_number']) ? $filterData['complain_number'] : '';
        $memberName = isset($filterData['member_name']) ? $filterData['member_name'] : '';
        $sendForNotification = isset($filterData['send_for_notification']) ? $filterData['send_for_notification'] : '';
        $sendForNotificationId = isset($filterData['send_for_notification_id']) ? $filterData['send_for_notification_id'] : 0;

        $receiveForNotification = isset($filterData['receive_for_notification']) ? $filterData['receive_for_notification'] : '';
        $receiveForNotificationId = isset($filterData['receive_for_notification_id']) ? $filterData['receive_for_notification_id'] : 0;
        $resourceTypeId = isset($filterData['resource_type_id']) ? $filterData['resource_type_id'] : 0;

        $customerDataArray = array();
        $batchNotificationDataArray = array();
        $userSocietyIdArray = array();
        if($appType == GATE_KEEPER){

            $notificationType = $commonWebserviceModel->getNotificationTypeData(array(
                'notification_type' => ucwords(str_replace('_', ' ', $type)),
            ));
            $ownershipFlatMemberMobile = $ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'society_id' => $societyId,
                'is_show_all_member' => 1,
                'is_active' => 1,             
            ));
            if(!empty($ownershipFlatMemberMobile)){
                $userData = $commonWebserviceModel->getUserSocietyData(array(
                    "type_id" => $ownershipFlatMemberMobile['member_id'],
                    'society_id' => $societyId,
                ));
                if(!empty($userData)){
                    $userDevice = $commonWebserviceModel->deviceData(array(
                        "user_society_id" => $userData['user_society_id'],
                        "user_type" => MEMBER_APP,
                        "is_latest" => 1,
                        'is_notification_allowed' => 1,
                        'society_id' => $societyId,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'notification_type_id' => isset($notificationType['notification_type_id']) ? $notificationType['notification_type_id'] : 0,
                    ));
                }
                if(!empty($userDevice)){
                    if ($userDevice['is_enabled'] == 1) {
                        if(!empty($type) && $type == 'delivery_boy'){
                            if($collectOnGate == 1){
                                if(!empty($status) && $status == 'collected'){
                                    $notificationArray = array(
                                        'notification_title' => 'Parcel Collected: '.$noOfParcel. ' from '.$visitorName.' - '.$visitorCompanyName,
                                        'description' => 'The '.$visitorName.' from '.$visitorCompanyName.' has handed over your parcel with number '.$noOfParcel.' to the '.$guard.' at the gate. Please collect it from the front desk at your convenience.',
                                        // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                    );
                                    $appUrlArray = array(
                                        'app_url' => MEMBER_URL .'visitor/' . $type,
                                    );
                                }
                                else if(!empty($status) && $status == 'delivered'){
                                    $notificationArray = array(
                                        'notification_title' => 'Parcel Handed Over: '.$noOfParcel,
                                        'description' => 'Your parcel with number '.$noOfParcel.' has been delivered and handed over to you by the '.$guard.'. If you have any questions or concerns, please contact the front desk.',
                                        // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                    );
                                    $appUrlArray = array(
                                        'app_url' => MEMBER_URL .'visitor/' . $type,
                                    );
                                }
                            }
                            else{
                                if(!empty($status) && $status == 'entered'){
                                    $notificationArray = array(
                                        'notification_title' => $visitorName.' Entered: '.$visitorCompanyName,
                                        'description' => 'The '.$visitorName.' from '.$visitorCompanyName.' has been granted entry by the '.$guard.' and will be arriving at your location shortly.',
                                        // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                    );
                                    $appUrlArray = array(
                                        'app_url' => MEMBER_URL .'visitor/' . $type,
                                    );
                                }
                                else if(!empty($status) && $status == 'exited'){
                                    $notificationArray = array(
                                        'notification_title' => $visitorName.' Exited: '.$visitorCompanyName,
                                        'description' => 'The '.$visitorName.' from '.$visitorCompanyName.' has exited the premises. Their delivery has been completed, and they have left the location.',
                                        // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                    );
                                    $appUrlArray = array(
                                        'app_url' => MEMBER_URL .'visitor/' . $type,
                                    );
                                }
                            }

                            if(!empty($status) && $status == 'approval_pending' || $status == 'entry_pre_approve' || $status == 'waiting_for_approval'){
                                $notificationArray = array(
                                    'notification_title' => $visitorName.' Waiting for Approval: '.$visitorCompanyName,
                                    'description' => 'The '.$visitorName.' from '.$visitorCompanyName.' is at the gate and awaiting your approval for entry. Please review and respond through the app to allow or deny access.',
                                    // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                                    'is_action_perform' => 1,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                            else if(!empty($status) && $status == 'approval_rejected'){
                                $notificationArray = array(
                                    'notification_title' => $visitorName.' Access Rejected: '.$visitorCompanyName,
                                    'description' => 'The entry request for the '.$visitorName.' from '.$visitorCompanyName.' has been rejected by the member. Please do not allow entry.',
                                    // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                                    'is_action_perform' => 1,

                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                        }
                        else if(!empty($type) && $type == 'visitor'){
                            if(!empty($status) && $status == 'entered'){
                                $notificationArray = array(
                                    'notification_title' =>'Visitor Entered by '.$guard,
                                    'description' => 'Your visitor, '.$visitorName.', has successfully entered the premises. They will be arriving at your location shortly.',
                                    // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                            else if(!empty($status) && $status == 'exited'){
                                $notificationArray = array(
                                    'notification_title' =>'Visitor Has Left the Premises',
                                    'description' => 'Our visitor, '.$visitorName.', has exited the premises. We hope their visit was pleasant.',
                                    // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                            else if(!empty($status) && ($status == 'approval_pending' || $status == 'waiting_for_approval' || $status == 'entry_pre_approve')){
                                $notificationArray = array(
                                    'notification_title' =>'Visitor Waiting for Approval',
                                    'description' => $visitorName. ' is at the gate and awaiting your approval for entry. Please review and respond through the app to allow or deny access.',
                                    // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                        }
                        else if(!empty($type) && $type == 'taxi'){
                            if(!empty($status) && $status == 'entered'){
                                $notificationArray = array(
                                    'notification_title' =>'Cab Entry Allowed: '.$vehicleNo,
                                    'description' => 'Your cab with the last 4 digits '.$vehicleNo.', has been allowed entry by the '.$guard.'. It will arrive at your location shortly.',
                                    // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                            else if(!empty($status) && $status == 'exited'){
                                $notificationArray = array(
                                    'notification_title' =>'Cab Exited: '.$vehicleNo,
                                    'description' => 'Your cab with the last 4 digits '.$vehicleNo.', has been allowed exited by the '.$guard.', and they have left the location.',
                                    // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }

                            if(!empty($status) && $status == 'approval_pending' || $status == 'entry_pre_approve' || $status == 'waiting_for_approval'){
                                $notificationArray = array(
                                    'notification_title' =>'Cab Awaiting Approval: '.$vehicleNo,
                                    'description' => 'Your cab with the last 4 digits '.$vehicleNo.' is at the gate and waiting for your approval. Please confirm or deny access through the app.',
                                    // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                                    'is_action_perform' => 1,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                        }
                        else if(!empty($type) && $type == 'resource'){
                            if(!empty($status) && $status == 'entered'){
                                $notificationArray = array(
                                    'notification_title' => $categoryName.' Entered: '.$visitorName,
                                    'description' => $visitorName.', your '.$categoryName.', has been allowed entry by the '.$guard.' and is now at the location. Please be aware of their presence during their visit.',
                                    // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                            else if(!empty($status) && $status == 'exited'){
                                $notificationArray = array(
                                    'notification_title' => $categoryName.' Exited: '.$visitorName,
                                    'description' => $visitorName.', your '.$categoryName .', has exited the premises. Their visit has concluded, and they have left the location.',
                                    // 'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                                $appUrlArray = array(
                                    'app_url' => MEMBER_URL .'visitor/' . $type,
                                );
                            }
                        }
                    }
                    if(!empty($type) && $type == 'complain'){
                       if(!empty($status) && $status == 'complain_resolved'){
                           $notificationArray = array(
                               'notification_title' => 'Complain Status Updated '.$complainNumber,
                               'description' => 'Your complain regarding '.$complainTitle.' has been updated. Please check the app for the latest details and status.',
                               // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $typeId,
                           );
                            $appUrlArray = array(
                                'app_url' => MEMBER_URL .'ticket_detail_page/' . $typeId,
                            );
                       }
                       else{
                          $notificationArray = array(
                               'notification_title' => 'New Complain Registered',
                               'description' => 'A new complain has been registered by '.$memberName.' regarding '.$complainTitle.'. Please review the details and take appropriate action.',
                               // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $typeId,
                           );
                            $appUrlArray = array(
                                'app_url' => MEMBER_URL .'ticket_detail_page/' . $typeId,
                            );
                       }

                   }
                   else if(!empty($type) && $type == 'poll'){
                        if(!empty($status) && $status == 'poll_ended'){
                            $notificationArray = array(
                                'notification_title' => 'Poll Results Are In!',
                                'description' => 'The poll on '.$pollTitle.' has ended. Check the app to see the final results and how the community voted.',
                                // 'app_url' => MEMBER_URL .'poll/completed',
                            );
                            $appUrlArray = array(
                                'app_url' => MEMBER_URL .'poll/completed',
                            );
                        }

                    }

//                    else if(!empty($type) && $type == 'sos_emergency'){
//                        if(!empty($status) && $status == 'sos_emergency'){
//                            $notificationArray = array(
//                                'notification_title' => $sosName.' Alert: SOS Triggered',
//                                'description' => 'An SOS alert has been triggered with the following message: '.$sosName.': '.$filterData['description'],
//                                'flat_id' => $filterData['flat_id'],
//                                'staff_id' => $filterData['staff_id'],
//                                'management_committee_id' => $filterData['management_committee_id'],
//                            );
//                        }
//                        else {
//                            $notificationArray = array(
//                                'notification_title' => $sosName.' Resolved',
//                                'description' => 'The SOS alert with the topic '.$sosName.'has been resolved. Thank you for your prompt attention.',
//                                'flat_id' => $filterData['flat_id'],
//                                'staff_id' => $filterData['staff_id'],
//                                'management_committee_id' => $filterData['management_committee_id'],
//                            );
//                        }
//                    }       
//
//                    }
//                    else if(!empty($type) && $type == 'poll'){
//                        if(!empty($status) && $status == 'poll_ended'){
//                            $notificationArray = array(
//                                'notification_title' => 'Poll Results Are In!',
//                                'description' => 'The poll on '.$pollTitle.' has ended. Check the app to see the final results and how the community voted.',
//                            );
//                        }
//
//                    }

                    $playerIdArray = array();
                    $iosPlayerIdArray = array();
                    $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                    $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                    $customerData['app_url'] = isset($appUrlArray['app_url']) ? $appUrlArray['app_url'] : "";
                    // printArray($customerData,1);
                    $customerData['extra_data'] = $extraDataJson;
                    $customerData['type'] = $status;

                    $notificationOtherArray =array(
                        'notification_id' => '',
                        'send_for_notification' => $sendForNotification,
                        'send_for_notification_id' => $sendForNotificationId,
                        'receive_for_notification' => $userDevice['user_type'],
                        'receive_for_notification_id' => $userDevice['user_type_id'],
                        'society_id' => $societyId,
                        'notification_date' => TODAY_DATE_YMD,
                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'ownership_flat_id' => $ownershipFlatId,
                        'type' => $status,
                        'type_id' => $typeId,
                        'extra_data' => $extraDataJson,
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    if(!empty($notificationArray)) {
                        $playerIdArray = array();
                        $iosPlayerIdArray = array();
                        $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                        $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                        $customerData['extra_data'] = $extraDataJson;
                        $customerData['type'] = $status;

                        // $notificationOtherArray =array(
                        //     'notification_id' => '',
                        //     'society_id' => $societyId,
                        //     'notification_date' => TODAY_DATE_YMD,
                        //     'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                        //     'ownership_flat_member_id' => $ownershipFlatMemberId,
                        //     'ownership_flat_id' => $ownershipFlatId,
                        //     'send_for_notification' => $sendForNotification,
                        //     'send_for_notification_id' => $sendForNotificationId,
                        //     'receive_for_notification' => $receiveForNotification,
                        //     'receive_for_notification_id' => $receiveForNotificationId,
                        //     'type' => $status,
                        //     'type_id' => $typeId,
                        //     'extra_data' => $extraDataJson,
                        //     'created_by' => $userId,
                        //     'updated_by' => $userId,
                        //     'created_at' => date("Y-m-d H:i:s"),
                        //     'updated_at' => date("Y-m-d H:i:s"),
                        // );
                        $notificationArray = array_merge($notificationArray, $notificationOtherArray);
                        $batchNotificationDataArray[] = $notificationArray;
                        $deviceToken = $userDevice['one_signal_id'];
                        $playerId = $userDevice['player_id'];
                        // printArray($playerId,1);
                        if ($userDevice['is_enabled'] == 1) {
                            if (strtolower($userDevice['device_type']) == 'android') {
                                if (!empty($playerId)) {
                                    array_push($playerIdArray, $playerId);
                                }
                            } else {
                                if (!empty($playerId)) {
                                    array_push($iosPlayerIdArray, $playerId);
                                }
                            }
                        }
                    }
                }
            }

            // printArray($batchNotificationDataArray,1);
            if(!empty($batchNotificationDataArray)){
                $ownershipFlatModel->batchInsert($batchNotificationDataArray,'tbl_notification');
            }
            $sendNotificationData = array();
            if(!empty($playerIdArray)){
                $customerData['player_id'] = $playerIdArray;
                $sendNotificationData = $customerData;
                sendNotificationAndroid($sendNotificationData);
            }
            $sendNotificationIOSData = array();
            if(!empty($iosPlayerIdArray)){
                $customerData['player_id'] = $iosPlayerIdArray;
                $sendNotificationIOSData = $customerData;
                sendNotificationIOS($sendNotificationIOSData);
            }
        }
        else {
            if(!empty($type) && $type == 'delivery_boy'){
                // echo "dsfsd";
                if(!empty($status) && $status == 'entry_pre_approve' || $status == 'entry_pre_approved'){
                    $notificationArray = array(
                        'notification_title' => $visitorName.' Waiting for Approval: '.$visitorCompanyName,
                        'description' => 'The '.$visitorName.' from '.$visitorCompanyName.' is at the gate and awaiting your approval for entry. Please review and respond through the app to allow or deny access.',
                        // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                        'is_action_perform' => 1,
                    );
                    $appUrlArray = array(
                        'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                    );
                }
                else if(!empty($status) && $status == 'approval_rejected'){
                    $notificationArray = array(
                        'notification_title' => $visitorName.' Access Rejected: '.$visitorCompanyName,
                        'description' => 'The entry request for the '.$visitorName.' from '.$visitorCompanyName.' has been rejected by the member. Please do not allow entry.',
                        // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                        'is_action_perform' => 1,

                    );
                    $appUrlArray = array(
                        'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                    );
                }
            }
            else if(!empty($type) && $type == 'visitor'){
                if(!empty($status) && $status == 'approval_rejected'){
                    $notificationArray = array(
                        'notification_title' =>'Visitor Access Denied',
                        'description' => 'The entry request for '.$visitorName.' has been rejected by the '.$memberName.'. Please do not allow the visitor to enter the premises.',
                        // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                        'is_action_perform' => 1,
                    );
                    $appUrlArray = array(
                        'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                    );
                }
                else if(!empty($status) && $status == 'entry_pre_approve'){
                    $notificationArray = array(
                        'notification_title' =>'Visitor Approved: '.$visitorName,
                        'description' => $visitorName.' has been approved for entry by the '.$memberName.'. Please grant them access to the premises',
                        // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                        'is_action_perform' => 1,
                    );
                    $appUrlArray = array(
                        'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                    );
                }
                else if(!empty($status) && ($status == 'approval_pending' || $status == 'waiting_for_approval')){
                    $notificationArray = array(
                        'notification_title' =>'Visitor Waiting for Approval',
                        'description' => $visitorName. ' is at the gate and awaiting your approval for entry. Please review and respond through the app to allow or deny access.',
                        // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                    );
                    $appUrlArray = array(
                        'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                    );
                }
            }
            else if(!empty($type) && $type == 'taxi'){
                if(!empty($status) && $status == 'approval_rejected'){
                    $notificationArray = array(
                        'notification_title' =>'Cab Rejected: '.$vehicleNo,
                        'description' => 'Your cab with the last 4 digits '.$vehicleNo.' has been rejected by the '.$memberName.'. Please do not allow the cab to enter the premises.',
                        // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                        'is_action_perform' => 1,
                    );
                    $appUrlArray = array(
                        'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                    );
                }

                if(!empty($status) && $status == 'entry_pre_approve'){
                    $notificationArray = array(
                        'notification_title' =>'Cab Awaiting Approval: '.$vehicleNo,
                        'description' => 'Your cab with the last 4 digits '.$vehicleNo.' is at the gate and waiting for your approval. Please confirm or deny access through the app.',
                        // 'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                        'is_action_perform' => 1,
                    );
                    $appUrlArray = array(
                        'app_url' => GATE_KEEPER_URL .'visitor/' . $type,
                    );
                }
            }
//            else if(!empty($type) && $type == 'sos_emergency'){
//                if(!empty($status) && $status == 'sos_emergency'){
//                    $notificationArray = array(
//                        'notification_title' => $sosName.' Alert: SOS Triggered',
//                        'description' => 'An SOS alert has been triggered with the following message: '.$sosName.': '.$filterData['description'],
//                        'flat_id' => isset($filterData['flat_id']) ? $filterData['flat_id'] : 0,
//                        'staff_id' => isset($filterData['staff_id']) ? $filterData['staff_id'] : 0,
//                        'management_committee_id' => isset($filterData['management_committee_id']) ? $filterData['management_committee_id'] : 0,
//                    );
//                }
//                else {
//                    $notificationArray = array(
//                        'notification_title' => $sosName.' Resolved',
//                        'description' => 'The SOS alert with the topic '.$sosName.'has been resolved. Thank you for your prompt attention.',
//                        'flat_id' => isset($filterData['flat_id']) ? $filterData['flat_id'] : 0,
//                        'staff_id' => isset($filterData['staff_id']) ? $filterData['staff_id'] : 0,
//                        'management_committee_id' => isset($filterData['management_committee_id']) ? $filterData['management_committee_id'] : 0,
//                    );
//
//                }
//            }

            $playerIdArray = array();
            $iosPlayerIdArray = array();
            $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
            $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
            $customerData['app_url'] = isset($appUrlArray['app_url']) ? $appUrlArray['app_url'] : "";

            $customerData['extra_data'] = $extraDataJson;
            $customerData['type'] = $status;

            $resourceTypeGuardData = $resourceTypeModel->getResourceTypeData(array(
                'is_guard' => 1,
                'is_multiple' => 1,
                'is_login' => 1,
                'is_active' => 1,
                'society_id' => $societyId,
            ));
            $resourceTypeIdArray = [];
            if (!empty($resourceTypeGuardData)) {
                foreach ($resourceTypeGuardData as $resourceTypeElement) {
                    $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                }
            }

            $userSocietyData = $commonWebserviceModel->getUserSocietyData(array(
                'society_id' => $societyId,
                'resource_type_id' => $resourceTypeIdArray,
                'is_multiple' => 1
            ));

            // printArray($resourceTypeIdArray,1);
            
            if(!empty($userSocietyData)){
                foreach($userSocietyData as $userSocietyElement){
                    $userSocietyIdArray[] = $userSocietyElement['user_society_id'];
                }
            }
            if(!empty($userSocietyIdArray)){
                $userDeviceArray = $commonWebserviceModel->deviceData(array(
                    "user_society_id" => $userSocietyIdArray,
                    "user_type" => GATE_KEEPER,
                    "is_latest" => 1,
                    "is_multiple" => 1,
                ));
            }

            // printArray($notificationArray,1);
            if(!empty($userDeviceArray)){
                foreach($userDeviceArray as $userDevice){
                    $notificationOtherArray = array(
                        'notification_id' => '',
                        'send_for_notification' => $sendForNotification,
                        'send_for_notification_id' => $sendForNotificationId,
                        'receive_for_notification' => $userDevice['user_type'],
                        'receive_for_notification_id' => $userDevice['user_type_id'],
                        'society_id' => $societyId,
                        'notification_date' => TODAY_DATE_YMD,
                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'ownership_flat_id' => $ownershipFlatId,
                        'type' => $status,
                        'type_id' => $typeId,
                        'extra_data' => $extraDataJson,
                        'is_action_perform' => isset($notificationArray['is_action_perform']) ? $notificationArray['is_action_perform'] : 0,
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );

                    if(!empty($notificationArray)){
                        $notificationArray = array_merge($notificationArray,$notificationOtherArray);
                        //send notification data
                        $deviceToken = $userDevice['one_signal_id'];
                        $playerId = $userDevice['player_id'];
                        $batchNotificationDataArray[] = $notificationArray;

                        if(strtolower($userDevice['device_type']) == 'android'){
                            if (!empty($playerId)) {
                                array_push($playerIdArray,$playerId);
                            }
                        } else {
                            if (!empty($playerId)) {
                                array_push($iosPlayerIdArray,$playerId);
                            }
                        }
                    }
                }
            }
            // printArray($batchNotificationDataArray,1);
            if(!empty($batchNotificationDataArray)){
                $ownershipFlatModel->batchInsert($batchNotificationDataArray,'tbl_notification');
            }

            $sendNotificationData = array();
            if(!empty($playerIdArray)){
                $customerData['player_id'] = $playerIdArray;
                $sendNotificationData = $customerData;
                sendNotificationAndroid($sendNotificationData);
            }
            $sendNotificationIOSData = array();
            if(!empty($iosPlayerIdArray)){
                $customerData['player_id'] = $iosPlayerIdArray;
                $sendNotificationIOSData = $customerData;
                sendNotificationIOS($sendNotificationIOSData);
            }
        }   
    }
}

if (!function_exists('sendNotificationSosDataList')) {
    function sendNotificationSosDataList($filterData = array(), $extraDataJson = '')
    {
        $ownershipFlatModel = new \App\Models\OwnershipFlatModel();
        $commonWebserviceModel = new \App\Models\CommonWebserviceModel();
        $ownershipFlatMemberId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : 0;
        $appType = isset($filterData['app_type']) ? $filterData['app_type'] : 0;
        $ownershipFlatId = isset($filterData['ownership_flat_id']) ? $filterData['ownership_flat_id'] : 0;
        $societyId = isset($filterData['society_id']) ? $filterData['society_id'] : 0;
        $userId = isset($filterData['user_id']) ? $filterData['user_id'] : 0;
        $typeId = isset($filterData['type_id']) ? $filterData['type_id'] : 0;
        $type = isset($filterData['type']) ? $filterData['type'] : '';
        $status = isset($filterData['status']) ? $filterData['status'] : '';
        $categoryName = isset($filterData['category_name']) ? $filterData['category_name'] : '';
        $memberName = isset($filterData['member_name']) ? $filterData['member_name'] : '';
        $customerDataArray = array();
        $batchNotificationDataArray = array();
        $userIdArray = array();
        if ($appType == GATE_KEEPER) {
            $ownershipFlatMemberMobile = $ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'society_id' => $societyId,
                // 'is_notification_allowed' => 1,
                'is_show_all_member' => 1,
                'is_active' => 1
            ));
            // printArray($ownershipFlatMemberMobile,1);
            if (!empty($ownershipFlatMemberMobile)) {
                $userData = $commonWebserviceModel->getUserData(array(
                    "phone" => $ownershipFlatMemberMobile['mobile_no'],
                    'society_id' => $societyId,
                ));
                if (!empty($userData)) {
                    $userDevice = $commonWebserviceModel->deviceData(array(
                        "user_id" => $userData['id'],
                        "user_type" => MEMBER_APP,
                        "is_latest" => 1,
                    ));
                }
                if (!empty($userDevice)) {
                    if (!empty($type) && $type == 'sos_emergency') {
                        if (!empty($status) && $status == 'sos_emergency') {
                            $notificationArray = array(
                                'notification_title' => $categoryName . ' Alert: SOS Triggered',
                                'description' => 'An SOS alert has been triggered with the following message: ' . $categoryName . ': ' . $filterData['description'],
                                'flat_id' => $filterData['flat_id'],
                                'staff_id' => $filterData['staff_id'],
                                'management_committee_id' => $filterData['management_committee_id'],
                            );
                        } else {
                            $notificationArray = array(
                                'notification_title' => $categoryName . ' Resolved',
                                'description' => 'The SOS alert with the topic ' . $categoryName . 'has been resolved. Thank you for your prompt attention.',
                                'flat_id' => $filterData['flat_id'],
                                'staff_id' => $filterData['staff_id'],
                                'management_committee_id' => $filterData['management_committee_id'],
                            );
                        }
                    }
                    $notificationOtherArray = array(
                        'notification_id' => '',
                        'society_id' => $societyId,
                        'notification_date' => TODAY_DATE_YMD,
                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'ownership_flat_id' => $ownershipFlatId,
                        'type' => $status,
                        'type_id' => $typeId,
                        'extra_data' => $extraDataJson,
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    if (!empty($notificationArray)) {
                        $notificationArray = array_merge($notificationArray, $notificationOtherArray);
                        $extraData = array();
                        $extraObj['api_user_id'] = $userId;
                        $extraObj['society_id'] = $societyId;
                        $extraData['is_api_data'] = $extraObj;
                        $batchNotificationDataArray[] = $notificationArray;
                        $deviceToken = array($userDevice['one_signal_id']);
                        $playerId = array($userDevice['player_id']);
                        $notificationSendArray["body"] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                        $notificationSendArray["title"] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                        $notificationSendArray["sound"] = "default";
                        $notificationSendArray["badge"] = "1";
                        $notificationSendArray["click_action"] = "FCM_PLUGIN_ACTIVITY";
                        $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                        $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                        if (!empty($deviceToken)) {
                            $customerData['device_token'] = array_filter($deviceToken);
                            $customerData['player_id'] = array_filter($playerId);
                            $customerData['extra_data'] = $extraDataJson;
                            $customerData['type'] = $status;
                            $customerData['notification_for'] = $notificationArray['notification_for'];
                            array_push($customerDataArray, $customerData);
                        }
                    }
                }
            }

            if (!empty($batchNotificationDataArray)) {
                $ownershipFlatModel->batchInsert($batchNotificationDataArray, 'tbl_notification');
            }
            sendSosNotification($customerDataArray);
        } else {


        }
    }
}
if (!function_exists('sendSosNotification')) {
    function sendSosNotification( $notificationData = array())
    {
        if(!empty($notificationData)){
            foreach ($notificationData as $notificationElement){
                $content = [
                    "en" => $notificationElement['description']
                ];
                $headings = [
                    "en" => $notificationElement['title_name']
                ];
                $playerId = $notificationElement['player_id'];
                $fields = [
                    'app_id' => APP_ID, // Replace with your actual App ID
                           // 'included_segments' => array('All'),
                    'include_player_ids' => $playerId,
                    'headings' => $headings,
                    'contents' => $content,
                    'data' => json_decode($notificationElement['extra_data'])
                ];
                if ($notificationElement['notification_for'] == 'android') {
                    $fields['isAndroid'] = true;
                } elseif ($notificationElement['notification_for'] == 'ios') {
                    $fields['isIos'] = true;
                }

                $fields = json_encode($fields);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json; charset=utf-8',
                    'Authorization: Basic MTE2NzAwYjUtNThhMC00MTczLWIzMTgtNDMyMzFhMzhlOWYz'
                ));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_HEADER, FALSE);
                curl_setopt($ch, CURLOPT_POST, TRUE);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                $response = curl_exec($ch);

                // printArray($response,1);
                curl_close($ch);
                return $response;
            }
        }
    }
}
if (!function_exists('calculateDateTimeDifference')) {
    function calculateDateTimeDifference( $date1,  $date2)
    {
        $dateTime1 = new \DateTime($date1); // Fully qualify DateTime
        $dateTime2 = new \DateTime($date2); // Fully qualify DateTime
        // Calculate the difference
        $interval = $dateTime2->diff($dateTime1);

        $hours = $interval->h;
        $minutes = $interval->i;

        // Format hours and minutes with leading zeros
        $formattedHours = str_pad($hours, 2, '0', STR_PAD_LEFT);
        $formattedMinutes = str_pad($minutes, 2, '0', STR_PAD_LEFT);

        // Return the formatted difference
        return "$formattedHours HH : $formattedMinutes MM";

        // Format the difference
        // return $interval->format('%h HH : %i MM');
    }
}

if (!function_exists('getFunctionKeyValue')) {
    function getFunctionKeyValue($key, $mapping) {
        // Return the key-value format
        return [
            "key" => $key,
            "value" => isset($mapping[$key]) ? $mapping[$key] : "Unknown"
        ];
    }
}

if (!function_exists('sendNotificationSosGateKeeperAndroid')) {
    function sendNotificationSosGateKeeperAndroid($notificationData = array(),$emergencyId = '')
    {
        $ownershipFlatModel = new \App\Models\OwnershipFlatModel();
        $notificationModel = new \App\Models\NotificationModel();
        $batchNotificationDataArray = array();
        $batchUpdateNotificationDataArray = array();
        if(!empty($notificationData)) {
            foreach ($notificationData as $notificationElement) {
                $notificationArray = array(
                    'send_for_notification' => isset($notificationElement['send_for_notification']) ? $notificationElement['send_for_notification'] : '',
                    'send_for_notification_id' => isset($notificationElement['send_for_notification_id']) ? $notificationElement['send_for_notification_id'] : '',
                    'receive_for_notification' => isset($notificationElement['receive_for_notification']) ? $notificationElement['receive_for_notification'] : '',
                    'receive_for_notification_id' => isset($notificationElement['receive_for_notification_id']) ? $notificationElement['receive_for_notification_id'] : '',
                    'notification_title' => isset($notificationElement['notification_title']) ? $notificationElement['notification_title'] : '',
                    'notification_for' => isset($notificationElement['notification_for']) ? $notificationElement['notification_for'] : '',
                    'notification_date' => isset($notificationElement['notification_date']) ? $notificationElement['notification_date'] : TODAY_DATE_YMD,
                    'description' => isset($notificationElement['description']) ? $notificationElement['description'] : '',
                    'society_id' => isset($notificationElement['society_id']) ? $notificationElement['society_id'] : '',
                    'type' => isset($notificationElement['type']) ? $notificationElement['type'] : '',
                    'type_id' => isset($notificationElement['type_id']) ? $notificationElement['type_id'] : '',
                    'extra_data' => isset($notificationElement['extra_data_json']) ? $notificationElement['extra_data_json'] : '',
                    'flat_id' => isset($notificationElement['flat_id']) ? $notificationElement['flat_id'] : '',
                    'ownership_flat_id' => isset($notificationElement['ownership_flat_id']) ? $notificationElement['ownership_flat_id'] : '',
                    'ownership_flat_member_id' => isset($notificationElement['ownership_flat_member_id']) ? $notificationElement['ownership_flat_member_id'] : '',
                    'management_committee_id' => isset($notificationElement['management_committee_id']) ? $notificationElement['management_committee_id'] : '',
                    'staff_id' => isset($notificationElement['staff_id']) ? $notificationElement['staff_id'] : '',
                    'created_by' => isset($notificationElement['user_id']) ? $notificationElement['user_id'] : '',
                    'updated_by' => isset($notificationElement['user_id']) ? $notificationElement['user_id'] : '',
                    // 'app_url' => isset($notificationElement['app_url']) ? $notificationElement['app_url'] : '',
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                );
                // $appUrlArray = array(
                //     'app_url' => isset($notificationElement['app_url']) ? $notificationElement['app_url'] : '',
                // );
                $batchNotificationDataArray[] = $notificationArray;
                // $extraData = array();
                // $extraObj['api_user_id'] = isset($notificationElement['user_id']) ? $notificationElement['user_id'] : '';
                // $extraObj['society_id'] = isset($notificationElement['society_id']) ? $notificationElement['society_id'] : '';
                // $extraData['is_api_data'] = $extraObj;
                // $notificationInsertData = $ownershipFlatModel->insertUpdateRecord($notificationArray, 'notification_id', 'tbl_notification', 1,'',array(),$extraData);
                // $lastNotificationInsertId = $notificationInsertData['lastInsertedId'];
                // $notificationStoreData = $notificationModel->getNotificationData(array(
                //     'notification_id' => $lastNotificationInsertId,
                // ));
                // $notificationStoreData = json_decode($notificationStoreData['extra_data'], true);
                // $notificationStoreData['notification_id'] = $lastNotificationInsertId;
                // $ownershipFlatModel->updateNotificationExtraData($lastNotificationInsertId,$notificationStoreData);
            }
        }
        if (!empty($batchNotificationDataArray)) {
           $ownershipFlatModel->batchInsert($batchNotificationDataArray, 'tbl_notification');
        }
        $notificationEmergencyData = $notificationModel->getNotificationData(array(
            'type_id' => $emergencyId,
            'type' => 'sos_emergency',
            'is_multiple' => 1
        ));
        if(!empty($notificationEmergencyData)){
            foreach($notificationEmergencyData as $emergency){
                $notificationStoreData = json_decode($emergency['extra_data'], true);
                $notificationStoreData['notification_id'] = $emergency['notification_id'];
                $notificationUpdateArray = array(
                    'notification_id' => $emergency['notification_id'],
                    'extra_data' => json_encode($notificationStoreData),
                );
                $batchUpdateNotificationDataArray[] = $notificationUpdateArray;
            }
        }
        if (!empty($batchUpdateNotificationDataArray)) {
           $ownershipFlatModel->batchUpdate($batchUpdateNotificationDataArray, 'notification_id','tbl_notification');
        }
        if(!empty($notificationData)){
            foreach ($notificationData as $notificationElement){
                $notificationEmergencyLastId = $notificationModel->getNotificationData(array(
                    'type_id' => $notificationElement['type_id'],
                    'type' => $notificationElement['type'],
                    'send_for_notification' => $notificationElement['send_for_notification'],
                    'send_for_notification_id' => $notificationElement['send_for_notification_id'],
                    'receive_for_notification' => $notificationElement['receive_for_notification'],
                    'receive_for_notification_id' => $notificationElement['receive_for_notification_id'], 
                ));
                $notificationId = $notificationEmergencyLastId['notification_id'];
                $notificationExtraData = json_decode($notificationElement['extra_data_json'], true);
                $notificationExtraData['notification_id'] = $notificationId;
                // $notificationExtraData['id'] = 'OS_b68e8f18-3021-4740-be5d-c8b6429fb44e';
                $content = [
                    "en" => $notificationElement['description']
                ];
                $headings = [
                    "en" => $notificationElement['notification_title']
                ];
                $playerId = $notificationElement['player_id'];
                // $appUrl = isset($notificationElement['app_url']) ? $notificationElement['app_url'] : "" ;
                $fields = [
                    'app_id' => APP_ID, // Replace with your actual App ID
                    'include_player_ids' => array($playerId),
                    // 'included_segments' => array('All'),
                    'headings' => $headings,
                    'contents' => $content,
                    // 'app_url' => $appUrl,
                    'data' => $notificationExtraData,
                    // 'android_channel_id' => "b68e8f18-3021-4740-be5d-c8b6429fb44e",
                    // 'sound' => 'buzzer',
                    // 'vibration' => [0, 2000, 500, 2000],
                    // 'android_sound' => 'buzzer',
                    // 'priority' => 10,
                ];

                if($notificationElement['status'] != 'sos_emergency_resolved'){
                    $buttons = [
                        [
                            "id" => "attend",
                            "text" => "Attend"
                        ],
                        [
                            "id" => "reject",
                            "text" => "Reject"
                        ]
                    ];
                    $fields['sound'] = 'buzzer';
                    // $fields['android_sound'] = 'buzzer';
                    $fields['vibration'] = [0, 2000, 500, 2000];
                    $fields['priority'] = 10;
                    $fields['android_channel_id'] = "b68e8f18-3021-4740-be5d-c8b6429fb44e";
                    $fields['buttons'] = $buttons;
                }
                else{
                    if($notificationElement['receive_for_notification'] == 'admin'){
                        $fields['app_url'] = MANAGER_URL .'sos_alert/' . $notificationElement['type_id'];
                    }
                    elseif($notificationElement['receive_for_notification'] == 'member'){
                        $fields['app_url'] = MEMBER_URL .'sos_alert/' . $notificationElement['type_id']; 
                    }
                    else{
                        $fields['app_url'] = GATE_KEEPER_URL .'sos_send_message/' . $notificationElement['type_id']; 
                    }
                }
                // $customSound = 'buzzer'; 

                if ($notificationElement['notification_for'] == 'android') {
                    $fields['isAndroid'] = true;
                    if($notificationElement['status'] != 'sos_emergency_resolved'){
                        $fields['android_sound'] = 'buzzer';
                    }
                } elseif ($notificationElement['notification_for'] == 'ios') {
                    $fields['isIos'] = true;
                    if($notificationElement['status'] != 'sos_emergency_resolved'){
                        $fields['ios_sound'] = 'buzzer.wav';
                    }
                }

                // $fields['isAndroid'] = true;
                // $fields['android_sound'] = $customSound;
                
                $fields = json_encode($fields);
                // printArray($fields,1);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json; charset=utf-8',
                    'Authorization: Basic MTE2NzAwYjUtNThhMC00MTczLWIzMTgtNDMyMzFhMzhlOWYz'
                ));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_HEADER, FALSE);
                curl_setopt($ch, CURLOPT_POST, TRUE);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                $response = curl_exec($ch);
                // printArray($response,1);
                curl_close($ch);
              //  return $response;
            }
        }
    }
}

if (!function_exists('sendNotificationComplainAndroid')) {
    function sendNotificationComplainAndroid($notificationData = array())
    {
        $ownershipFlatModel = new \App\Models\OwnershipFlatModel();
        $notificationModel = new \App\Models\NotificationModel();
        $batchNotificationDataArray = array();
        $batchUpdateNotificationDataArray = array();
        if(!empty($notificationData)) {
            foreach ($notificationData as $notificationElement) {
                $notificationArray = array(
                    'send_for_notification' => isset($notificationElement['send_for_notification']) ? $notificationElement['send_for_notification'] : '',
                    'send_for_notification_id' => isset($notificationElement['send_for_notification_id']) ? $notificationElement['send_for_notification_id'] : '',
                    'receive_for_notification' => isset($notificationElement['receive_for_notification']) ? $notificationElement['receive_for_notification'] : '',
                    'receive_for_notification_id' => isset($notificationElement['receive_for_notification_id']) ? $notificationElement['receive_for_notification_id'] : '',
                    'notification_title' => isset($notificationElement['notification_title']) ? $notificationElement['notification_title'] : '',
                    'notification_for' => isset($notificationElement['notification_for']) ? $notificationElement['notification_for'] : '',
                    'notification_date' => isset($notificationElement['notification_date']) ? $notificationElement['notification_date'] : TODAY_DATE_YMD,
                    'description' => isset($notificationElement['description']) ? $notificationElement['description'] : '',
                    'society_id' => isset($notificationElement['society_id']) ? $notificationElement['society_id'] : '',
                    'type' => isset($notificationElement['type']) ? $notificationElement['type'] : '',
                    'type_id' => isset($notificationElement['type_id']) ? $notificationElement['type_id'] : '',
                    'extra_data' => isset($notificationElement['extra_data_json']) ? $notificationElement['extra_data_json'] : '',
                    'flat_id' => isset($notificationElement['flat_id']) ? $notificationElement['flat_id'] : '',
                    'ownership_flat_id' => isset($notificationElement['ownership_flat_id']) ? $notificationElement['ownership_flat_id'] : '',
                    'ownership_flat_member_id' => isset($notificationElement['ownership_flat_member_id']) ? $notificationElement['ownership_flat_member_id'] : '',
                    'management_committee_id' => isset($notificationElement['management_committee_id']) ? $notificationElement['management_committee_id'] : '',
                    'staff_id' => isset($notificationElement['staff_id']) ? $notificationElement['staff_id'] : '',
                    'created_by' => isset($notificationElement['user_id']) ? $notificationElement['user_id'] : '',
                    'updated_by' => isset($notificationElement['user_id']) ? $notificationElement['user_id'] : '',
                    // 'app_url' => isset($notificationElement['app_url']) ? $notificationElement['app_url'] : '',
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                );
                
                $batchNotificationDataArray[] = $notificationArray;
            }
        }
        if (!empty($batchNotificationDataArray)) {
           $ownershipFlatModel->batchInsert($batchNotificationDataArray, 'tbl_notification');
        }
        if (!empty($batchUpdateNotificationDataArray)) {
           $ownershipFlatModel->batchUpdate($batchUpdateNotificationDataArray, 'notification_id','tbl_notification');
        }
        if(!empty($notificationData)){
            foreach ($notificationData as $notificationElement){
                $notificationExtraData = json_decode($notificationElement['extra_data_json'], true);
                $content = [
                    "en" => $notificationElement['description']
                ];
                $headings = [
                    "en" => $notificationElement['notification_title']
                ];
                $playerId = $notificationElement['player_id'];

                if($notificationElement['type'] == 'complain'){
                    if($notificationElement['receive_for_notification'] == 'admin'){
                        $appUrl = MANAGER_URL .'ticket_detail_page/' . $notificationElement['type_id'];
                    }
                    else{
                        $appUrl = MEMBER_URL .'ticket_detail_page/' . $notificationElement['type_id']; 
                    }
                }
                else if($notificationElement['type'] == 'amenities'){
                    $appUrl = MANAGER_URL . 'my_booking/' . $notificationElement['type_id'];
                }

                // $appUrl = isset($notificationElement['app_url']) ? $notificationElement['app_url'] : "" ;
                $fields = [
                    'app_id' => APP_ID, // Replace with your actual App ID
                    'include_player_ids' => array($playerId),
                    'headings' => $headings,
                    'contents' => $content,
                    'app_url' => $appUrl,
                    'data' => $notificationExtraData,
                ];
                if ($notificationElement['notification_for'] == 'android') {
                    $fields['isAndroid'] = true;
                } elseif ($notificationElement['notification_for'] == 'ios') {
                    $fields['isIos'] = true;
                }
                $fields = json_encode($fields);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json; charset=utf-8',
                    'Authorization: Basic MTE2NzAwYjUtNThhMC00MTczLWIzMTgtNDMyMzFhMzhlOWYz'
                ));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_HEADER, FALSE);
                curl_setopt($ch, CURLOPT_POST, TRUE);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                $response = curl_exec($ch);
                // printArray($response,1);
                curl_close($ch);
            }
        }
    }
}

if (!function_exists('sendNotificationResourceAndroid')) {
    function sendNotificationResourceAndroid($notificationData = array())
    {
        $ownershipFlatModel = new \App\Models\OwnershipFlatModel();
        $notificationModel = new \App\Models\NotificationModel();
        $batchNotificationDataArray = array();
        $batchUpdateNotificationDataArray = array();
        if(!empty($notificationData)) {
            foreach ($notificationData as $notificationElement) {
                $notificationArray = array(
                    'send_for_notification' => isset($notificationElement['send_for_notification']) ? $notificationElement['send_for_notification'] : '',
                    'send_for_notification_id' => isset($notificationElement['send_for_notification_id']) ? $notificationElement['send_for_notification_id'] : '',
                    'receive_for_notification' => isset($notificationElement['receive_for_notification']) ? $notificationElement['receive_for_notification'] : '',
                    'receive_for_notification_id' => isset($notificationElement['receive_for_notification_id']) ? $notificationElement['receive_for_notification_id'] : '',
                    'notification_title' => isset($notificationElement['notification_title']) ? $notificationElement['notification_title'] : '',
                    'notification_for' => isset($notificationElement['notification_for']) ? $notificationElement['notification_for'] : '',
                    'notification_date' => isset($notificationElement['notification_date']) ? $notificationElement['notification_date'] : TODAY_DATE_YMD,
                    'description' => isset($notificationElement['description']) ? $notificationElement['description'] : '',
                    'society_id' => isset($notificationElement['society_id']) ? $notificationElement['society_id'] : '',
                    'type' => isset($notificationElement['type']) ? $notificationElement['type'] : '',
                    'type_id' => isset($notificationElement['type_id']) ? $notificationElement['type_id'] : '',
                    'extra_data' => isset($notificationElement['extra_data_json']) ? $notificationElement['extra_data_json'] : '',
                    'flat_id' => isset($notificationElement['flat_id']) ? $notificationElement['flat_id'] : '',
                    'ownership_flat_id' => isset($notificationElement['ownership_flat_id']) ? $notificationElement['ownership_flat_id'] : '',
                    'ownership_flat_member_id' => isset($notificationElement['ownership_flat_member_id']) ? $notificationElement['ownership_flat_member_id'] : '',
                    'management_committee_id' => isset($notificationElement['management_committee_id']) ? $notificationElement['management_committee_id'] : '',
                    'staff_id' => isset($notificationElement['staff_id']) ? $notificationElement['staff_id'] : '',
                    'created_by' => isset($notificationElement['user_id']) ? $notificationElement['user_id'] : '',
                    'updated_by' => isset($notificationElement['user_id']) ? $notificationElement['user_id'] : '',
                    // 'app_url' => isset($notificationElement['app_url']) ? $notificationElement['app_url'] : '',
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                );
                $batchNotificationDataArray[] = $notificationArray;
            }
        }
        if (!empty($batchNotificationDataArray)) {
           $ownershipFlatModel->batchInsert($batchNotificationDataArray, 'tbl_notification');
        }
        
        if(!empty($notificationData)){
            foreach ($notificationData as $notificationElement){
                $notificationExtraData = json_decode($notificationElement['extra_data_json'], true);
                $content = [
                    "en" => $notificationElement['description']
                ];
                $headings = [
                    "en" => $notificationElement['notification_title']
                ];
                $playerId = $notificationElement['player_id'];
                $appUrl = isset($notificationElement['app_url']) ? $notificationElement['app_url'] : "" ;
                $fields = [
                    'app_id' => APP_ID, // Replace with your actual App ID
                    'include_player_ids' => array($playerId),
                    'headings' => $headings,
                    'contents' => $content,
                    'app_url' => $appUrl,
                    'data' => $notificationExtraData,
                ];
                if ($notificationElement['notification_for'] == 'android') {
                    $fields['isAndroid'] = true;
                } elseif ($notificationElement['notification_for'] == 'ios') {
                    $fields['isIos'] = true;
                }
                $fields = json_encode($fields);
                // printArray($fields,1);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json; charset=utf-8',
                    'Authorization: Basic MTE2NzAwYjUtNThhMC00MTczLWIzMTgtNDMyMzFhMzhlOWYz'
                ));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_HEADER, FALSE);
                curl_setopt($ch, CURLOPT_POST, TRUE);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                $response = curl_exec($ch);
                // printArray($response,1);
                curl_close($ch);
              //  return $response;
            }
        }
    }
}

if (!function_exists('resourceType')) {
    function resourceType()
    {
        return array(
            array('name' => 'servants', 'is_login' => 0),
            array('name' => 'house_maids', 'is_login' => 0),
            array('name' => 'drivers', 'is_login' => 0),
            array('name' => 'gardener', 'is_login' => 0),
            array('name' => 'guard', 'is_login' => 1)
        );
    }
}
if (!function_exists('getResourceKeyValue')) {
    function getResourceKeyValue($key) 
    {   
        return is_array($key) 
            ? array_map(fn($k) => ['key' => $k, 'value' => underscoreToUcWord($k)], $key) 
            : ['key' => $key, 'value' => underscoreToUcWord($key)];
    }
}

if (!function_exists('electricTypeViewing')) {
    function electricTypeViewing()
    {
        $electricTypeViewings = array(
            "yes" => 'Yes',
            "no" => 'No',
        );
        return $electricTypeViewings;
    }
}

if (!function_exists('ApiDB')) {
    function ApiDB($filterData = array(), $extraDataJson = '')
    {
        $societyModel = new \App\Models\SocietyModel();
        
        $societyId = $filterData['society_id'];

        $societyData = $this->societyModel->getSocietyData(array(
            'society_id' => $societyId,
        ));
        
        if (!$societyId) {
            return  \Config\Database::connect();
        }

        $dbConfig = [
            'DSN'      => '',
            'hostname' => $societyData['db_host'] ?? 'localhost',
            'username' => $societyData['db_user'] ?? 'root',
            'password' => $societyData['db_pass'] ?? '',
            'database' => $societyData['db_name'],
            'DBDriver' => 'MySQLi',
            'DBPrefix' => '',
            'pConnect' => false,
            'DBDebug'  => true,
            'charset'  => 'utf8',
            'DBCollat' => 'utf8_general_ci',
            'swapPre'  => '',
            'encrypt'  => false,
            'compress' => false,
            'strictOn' => false,
            'failover' => [],
            'port'     => 3306,
        ];

        return \Config\Database::connect($dbConfig, false); // false = don't override default
    }
}

if (!function_exists('beginDualTransaction')) {
    function beginDualTransaction($masterDb, $tenantDb)
    {
        $masterDb->transStart();
        $tenantDb->transStart();
    }
}

if (!function_exists('commitDualTransaction')) {
    function commitDualTransaction($masterDb, $tenantDb)
    {
        if($masterDb->transStatus() !== FALSE || $tenantDb->transStatus() !== FALSE){
            $masterDb->transComplete();
            $tenantDb->transComplete();
        }
    }
}

if (!function_exists('rollbackDualTransaction')) {
    function rollbackDualTransaction($masterDb, $tenantDb)
    {
        if($masterDb->transStatus() === FALSE || $tenantDb->transStatus() === FALSE){
            $masterDb->transRollback();
            $tenantDb->transRollback();
        }
    }
}

