<?php
use App\Models\ItemBalanceModel;

function itemInOut($itemData)
{
    $ionAuth    = new \App\Libraries\IonAuth();
    $item_balance_model = new ItemBalanceModel();

	$itemLedgerData = [];
	$itemLedgerData['item_ledger_id']               = '';
	$itemLedgerData['item_id']                      = $itemData['item_id'];
	$itemLedgerData['common_area_id']                 = $itemData['common_area_id'];
	$itemLedgerData['society_id']                  = $itemData['society_id'];
	$itemLedgerData['financial_year_id']                  = $itemData['financial_year_id'];
	$itemLedgerData['document_number']                  = $itemData['document_number'];

	$itemLedgerData['transaction_for']               = $itemData['transaction_for'];
	$itemLedgerData['transaction_for_id']            = isset($itemData['transaction_for_id']) ? $itemData['transaction_for_id'] : "";
	$itemLedgerData['transaction_type']              = isset($itemData['transaction_type']) ? $itemData['transaction_type'] : "";
	$itemLedgerData['transaction_for_item_id']      = isset($itemData['transaction_for_item_id']) ? $itemData['transaction_for_item_id'] : "";


	$itemLedgerData['actual_qty']                    = $itemData['actual_qty'];
	$itemLedgerData['posting_date_time']             = date('Y-m-d H:i:s');
	$itemLedgerData['cumulative_quantity_before']    = isset($itemData['cumulative_quantity_before']) ? $itemData['cumulative_quantity_before'] : "";
    $itemLedgerData['cumulative_quantity_after']     = isset($itemData['cumulative_quantity_after']) ? $itemData['cumulative_quantity_after'] : "";



	$newItemStock = [];
	$newItemStock['item_balance_id'] = '';


	$transactionType = 'debit';

	$transactions = [
		'material_inwards' => 'credit',
		'material_outwards' => 'debit',
	];

	if (array_key_exists($itemData['transaction_type'], $transactions)) {
		$transactionType = $transactions[$itemData['transaction_type']];
	}

	// get current stock
	$currentStock = $item_balance_model->getItemBalanceData(array(
		'item_id' => $itemData['item_id'],
		'common_area_id' => $itemData['common_area_id']
	));


	if (!empty($currentStock)) {
		$newItemStock['item_balance_id'] = $currentStock['item_balance_id'];
		$newItemStock['actual_quantity'] = $currentStock['actual_quantity'];
	} else {
		$newItemStock['item_balance_id'] = '';
		$newItemStock['actual_quantity'] = 0;
	}

	if ($transactionType == 'debit') {
		$newQty = floatval($newItemStock['actual_quantity']) - floatval($itemData['actual_qty']);
		$itemLedgerData['qty_after_transaction'] = $newQty;
	} else {
		$newQty = floatval($newItemStock['actual_quantity']) +  floatval($itemData['actual_qty']);
		$itemLedgerData['qty_after_transaction'] = $newQty;
	}


	$itemLedgerData['transaction_type']    = $transactionType;

	$isApiCall = isset($itemData['is_api_call']) ? $itemData['is_api_call'] : 0;
	$apUserId = isset($itemData['api_user_id']) ? $itemData['api_user_id'] : 0;


	if($isApiCall == 0){
        $item_balance_model->insertUpdateRecord($itemLedgerData, 'item_ledger_id', 'tbl_item_ledger');
	} else {
		$CI->Mdl_common_web_service->insertUpdateRecordApi($itemLedgerData, 'item_ledger_id', 'tbl_item_ledger', 1,'',$apUserId);
	}


	$newItemStockData = array(
		'item_balance_id' =>  $newItemStock['item_balance_id'],
		'item_id' => $itemData['item_id'],
		'common_area_id' => $itemData['common_area_id'],
		'society_id' => $itemData['society_id'],
		'actual_quantity' => $newQty,
	);

	if ($newItemStock['item_balance_id'] != '') {
		$newItemStockData['updated_at'] = date('Y-m-d H:i:s');
		if($isApiCall == 0){
			$newItemStockData['updated_by'] = $ionAuth->getUserId();
		} else {
			$newItemStockData['updated_by'] = $apUserId;
		}

	} else {
		$newItemStockData['created_at'] = date('Y-m-d H:i:s');
		$newItemStockData['updated_at'] = date('Y-m-d H:i:s');
		if($isApiCall == 0){
			$newItemStockData['created_by'] = $ionAuth->getUserId();
			$newItemStockData['updated_by'] = $ionAuth->getUserId();
		} else {
			$newItemStockData['created_by'] = $apUserId;
			$newItemStockData['updated_by'] = $apUserId;
		}
	}

	if($isApiCall == 0) {
        $item_balance_model->insertUpdate($newItemStockData, 'item_balance_id', 'tbl_item_balance',1,$currentStock);
	} else {
		$CI->Mdl_common_web_service->insertUpdateApi($newItemStockData, 'item_balance_id', 'tbl_item_balance');
	}
}
