<?php
if (!function_exists('approvedButton')) {
    function approvedButton($filterData = array())
    {

        $buttonId = isset($filterData['button_id']) ? $filterData['button_id'] : "";
        $formSubmit = isset($filterData['form_submit']) ? $filterData['form_submit'] : "";
        $permissionLabel = isset($filterData['permission_label']) ? $filterData['permission_label'] : "";
        $permissionName = isset($filterData['permission_name']) ? $filterData['permission_name'] : "";
        $approvedModule = isset($filterData['approved_module']) ? $filterData['approved_module'] : "";

        $html = '';

        if (1 == 1) {
            if ($formSubmit == 'short_closed') {
                $statusLabel = 'SHORT CLOSED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }
            if ($formSubmit == 'approved') {
                $statusLabel = 'APPROVED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }
            if ($formSubmit == 'rejected') {
                $statusLabel = 'REJECTED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }
            if ($formSubmit == 'pending') {
                $statusLabel = 'APPROVE';
                $html .= "<a class=''>Pending</a><br>";
                if ($permissionName) {
                    $html .= '<a  data-value = "confirmed" id=form_status_' . $buttonId . ' data-id = ' . $buttonId . ' href="javascript:void(0);" class="btn btn-success badge badge-success bg-glow form-status">' . $statusLabel . '</a>';
                }
            }
            if ($formSubmit == 'confirmed') {
                $statusLabel = 'CONFIRMED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }
            if ($formSubmit == 'cancelled') {
                $statusLabel = 'CANCELLED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }

            if ($formSubmit == 'partially_short_closed') {
                $statusLabel = 'PARTIALLY SHORT CLOSED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }

            if ($formSubmit == 'cancel') {
                $statusLabel = 'Cancelled';
                $html .= '<a id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }

            if ($formSubmit == 'pending_state_c&a_approval') {
                $statusLabel = 'Waiting For State C&A Approval';
                $html .= '<a id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }

            if ($formSubmit == 'pending_aic_approval') {
                $statusLabel = 'Waiting For AIC Approval';
                $html .= '<a id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }

            if ($formSubmit == 'saved') {
                $statusLabel = 'APPROVE';
                $html .= "<a class=''>Saved</a><br>";
                if ($permissionName) {
                    $html .= '<a  data-value = "approved" id=form_status_' . $buttonId . ' data-id = ' . $buttonId . ' href="javascript:void(0);" class="btn btn-success badge badge-success bg-glow form-status">' . $statusLabel . '</a>';
                }
            }
        } else {
            if ($formSubmit == 'short_closed') {
                $statusLabel = 'SHORT CLOSED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }
            if ($formSubmit == 'approved') {
                $statusLabel = 'APPROVED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }
            if ($formSubmit == 'saved') {
                $statusLabel = 'SAVED';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }
            if ($formSubmit == 'pending') {
                $statusLabel = 'PENDING';
                $html .= '<a  id=form_status_' . $buttonId . ' class="">' . $statusLabel . '</a>';
            }
        }

        return $html;
    }
}


if (!function_exists('societyActionButton')) {
    function societyActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $societyId = isset($filterData['society_id']) ? $filterData['society_id'] : "";
        $isSuperAdmin = isset($filterData['is_super_admin']) ? $filterData['is_super_admin'] : 0;
        $html = '';
        // if($dtCIAcl->checkAccess('Society|pdf')){
        //     $html .= '<a target="_blank" href="' . site_url(($isSuperAdmin ? 'SuperAdmin/Society' : 'Admin/Society') . "/pdf/$societyId") . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('Society.society_pdf') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
        //  }


        if($dtCIAcl->checkAccess('Society|manage')){
            $html .='<a href="'. site_url(($isSuperAdmin ? 'SuperAdmin/Society' : 'Admin/Society') . "/manage/$societyId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Society.edit_society').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        if(empty($isSuperAdmin)){
            if($dtCIAcl->checkAccess('Society|delete')) {
                $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Society.delete_society').'" data-id="' . $societyId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
            }
        }
        return $html;
    }
}

if (!function_exists('warrantyActionButton')) {
    function warrantyActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $warrantyId = isset($filterData['warranty_id']) ? $filterData['warranty_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Warranty|manage')){
            $html .='<a href="'. admin_url("Warranty/manage/$warrantyId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Warranty.edit_warranty').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        if($dtCIAcl->checkAccess('Warranty|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Warranty.delete_warranty').'" data-id="' . $warrantyId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }
        return $html;
    }
}

if (!function_exists('categoryActionButton')) {
    function categoryActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $categoryId = isset($filterData['category_id']) ? $filterData['category_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Category|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Category.delete_category').'" data-id="' . $categoryId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('Category|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Category.edit_category').'"  data-id = "'.$categoryId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('generatorActionButton')) {
    function generatorActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $generatorId = isset($filterData['generator_id']) ? $filterData['generator_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Generator|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Generator.delete_generator').'" data-id="' . $generatorId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('Generator|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Generator.edit_generator').'"  data-id = "'.$generatorId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}


if (!function_exists('GeneratorReadingActionButton')) {
    function GeneratorReadingActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $generatorReadingId = isset($filterData['generator_reading_id']) ? $filterData['generator_reading_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('GeneratorReading|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('GeneratorReading.delete_generator_reading').'" data-id="' . $generatorReadingId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('GeneratorReading|manage')){
            $html .='<a href="'. admin_url("GeneratorReading/manage/$generatorReadingId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('GeneratorReading.edit_generator_reading').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('taxActionButton')) {
    function taxActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $taxId = isset($filterData['tax_id']) ? $filterData['tax_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Tax|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Tax.delete_tax').'" data-id="' . $taxId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('Tax|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Tax.edit_tax').'"  data-id = "'.$taxId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('groupActionButton')) {
    function groupActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $groupId = isset($filterData['group_id']) ? $filterData['group_id'] : "";
        $isSuperAdmin = isset($filterData['is_super_admin']) ? $filterData['is_super_admin'] : 0;
        $html = '';

        if($dtCIAcl->checkAccess('Auth|deleteGroup')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Auth.delete_groups').'" data-id = "'.$groupId.'" class="btn btn-sm btn-icon delete-record dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Auth|edit_group')){
            $html .='<a href="'. site_url(($isSuperAdmin ? 'SuperAdmin' : 'Admin/Auth') . "/edit_group/$groupId") .'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Auth.edit_groups').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('userActionButton')) {
    function userActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $userId = isset($filterData['user_id']) ? $filterData['user_id'] : "";
        $isSuperAdmin = isset($filterData['is_super_admin']) ? $filterData['is_super_admin'] : 0;
        $html = '';

        if($dtCIAcl->checkAccess('Auth|deleteUser')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Auth.delete_users').'" data-id = "'.$userId.'" class="btn btn-sm btn-icon delete-record dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Auth|edit_user')){
            $html .='<a href="'. site_url(($isSuperAdmin ? 'SuperAdmin' : 'Admin/Auth') . "/edit_user/$userId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Auth.edit_users').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('towerActionButton')) {
    function towerActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $towerId = isset($filterData['tower_id']) ? $filterData['tower_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Tower|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Tower.delete_tower').'" data-id="' . $towerId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Tower|manage')){
            $html .='<a href="'. admin_url("Tower/manage/$towerId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Tower.edit_tower').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('eventActionButton')) {
    function eventActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $eventId = isset($filterData['event_id']) ? $filterData['event_id'] : "";
        $formSubmit = isset($filterData['form_submit']) ? $filterData['form_submit'] : "";
        $viewUrl = admin_url('Event/manage/').$eventId."/1";
        $html = '';
        if($dtCIAcl->checkAccess('Event|delete') && in_array($formSubmit, deleteButtonStatus())){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Event.delete_event').'" data-id="' . $eventId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Event|manage') && in_array($formSubmit, editButtonStatus())){
            $html .='<a href="'. admin_url("Event/manage/$eventId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Event.edit_event').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Event.view_event').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        return $html;
    }
}

if (!function_exists('eventBookingActionButton')) {
    function eventBookingActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $eventBookingId = isset($filterData['event_booking_id']) ? $filterData['event_booking_id'] : "";
        $viewUrl = admin_url('EventBooking/manage/').$eventBookingId."/1";
        $html = '';
        $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('EventBooking.view_event_booking').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        return $html;
    }
}

if (!function_exists('visitorCompanyActionButton')) {
    function visitorCompanyActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $visitorCompanyId = isset($filterData['visitor_company_id']) ? $filterData['visitor_company_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('VisitorCompany|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('VisitorCompany.delete_visitor_company').'" data-id="' . $visitorCompanyId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('VisitorCompany|addEdit')){
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('VisitorCompany.edit_visitor_company').'"  data-id = "'.$visitorCompanyId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('flatActionButton')) {
    function flatActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $flatId = isset($filterData['flat_id']) ? $filterData['flat_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Flat|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Flat.delete_flat').'" data-id="' . $flatId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Flat|manage')){
            $html .='<a href="'. admin_url("Flat/manage/$flatId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Flat.edit_flat').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('gateActionButton')) {
    function gateActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $gateId = isset($filterData['gate_id']) ? $filterData['gate_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Gate|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Gate.delete_gate').'" data-id="' . $gateId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Gate|manage')){
            $html .='<a href="'. admin_url("Gate/manage/$gateId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Gate.edit_gate').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('sosActionButton')) {
    function sosActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $sosId = isset($filterData['sos_id']) ? $filterData['sos_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Sos|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Sos.delete_sos').'" data-id="' . $sosId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Sos|manage')){
            $html .='<a href="'. admin_url("Sos/manage/$sosId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Sos.edit_sos').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('tagAssignActionButton')) {
    function tagAssignActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $tagAssignId = isset($filterData['tag_assign_id']) ? $filterData['tag_assign_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('TagAssign|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('TagAssign.delete_tag_assign').'" data-id="' . $tagAssignId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('TagAssign|manage')){
            $html .='<a href="'. admin_url("TagAssign/manage/$tagAssignId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('TagAssign.edit_tag_assign').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('sinkingFundActionButton')) {
    function sinkingFundActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $sinkingFundId = isset($filterData['sinking_fund_id']) ? $filterData['sinking_fund_id'] : "";
        $remainingAmount = isset($filterData['remaining_amount']) ? $filterData['remaining_amount'] : 0;
        $html = '';


        if(($dtCIAcl->checkAccess('SinkingFund|addInvestment')) && ($remainingAmount > 0)){
            $html .= '<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-id="' . $sinkingFundId . '" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('SinkingFund.add_investment').'" class="btn btn-sm btn-icon add-investment"><i class="ti ti-currency-dollar"></i></a>';
        }

        if($dtCIAcl->checkAccess('SinkingFund|addWithdrawn')){
            $html .= '<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-id="' . $sinkingFundId . '" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('SinkingFund.add_withdrawn').'" class="btn btn-sm btn-icon add-withdrawn"><i class="ti ti-wallet"></i></a>';
        }

        if($dtCIAcl->checkAccess('SinkingFund|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('SinkingFund.delete_sinking_fund').'" data-id="' . $sinkingFundId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('SinkingFund|manage')){
            $html .='<a href="'. admin_url("SinkingFund/manage/$sinkingFundId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('SinkingFund.edit_sinking_fund').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('emergencyContactActionButton')) {
    function emergencyContactActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $emergencyNumberId = isset($filterData['emergency_number_id']) ? $filterData['emergency_number_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('EmergencyContact|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('EmergencyContact.delete_emergency_contact').'" data-id="' . $emergencyNumberId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('EmergencyContact|manage')){
            $html .='<a href="'. admin_url("EmergencyContact/manage/$emergencyNumberId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('EmergencyContact.edit_emergency_contact').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('noticeActionButton')) {
    function noticeActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $noticeId = isset($filterData['notice_id']) ? $filterData['notice_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Notice|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Notice.delete_notice').'" data-id="' . $noticeId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Notice|manage')){
            $html .='<a href="'. admin_url("Notice/manage/$noticeId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Notice.edit_notice').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('letterHeadActionButton')) {
    function letterHeadActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $letterHeadId = isset($filterData['letter_head_id']) ? $filterData['letter_head_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('LetterHead|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('LetterHead.delete_letter_head').'" data-id="' . $letterHeadId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('LetterHead|manage')){
            $html .='<a href="'. admin_url("LetterHead/manage/$letterHeadId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('LetterHead.edit_letter_head').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('forumActionButton')) {
    function forumActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $forumId = isset($filterData['forum_id']) ? $filterData['forum_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Forum|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Forum.delete_forum').'" data-id="' . $forumId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Forum|manage')){
            $html .='<a href="'. admin_url("Forum/manage/$forumId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Forum.edit_forum').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        $html .= '<a href="'. admin_url('Forum/manage/').$forumId."/1".'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Forum.view_forum').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        return $html;
    }
}

if (!function_exists('settingActionButton')) {
    function settingActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $settingId = isset($filterData['setting_id']) ? $filterData['setting_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Setting|manage')){
            $html .='<a href="'. admin_url("Setting/manage/$settingId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Setting.edit_setting').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('tagActionButton')) {
    function tagActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $tagId = isset($filterData['tag_id']) ? $filterData['tag_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Tag|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Tag.delete_tag').'" data-id="' . $tagId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Tag|manage')){
            $html .='<a href="'. admin_url("Tag/manage/$tagId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Tag.edit_tag').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('itemActionButton')) {
    function itemActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $itemId = isset($filterData['item_id']) ? $filterData['item_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Item|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Item.delete_item').'" data-id="' . $itemId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Item|manage')){
            $html .='<a href="'. admin_url("Item/manage/$itemId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Item.edit_item').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('ownershipFlatActionButton')) {
    function ownershipFlatActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $ownershipFlatId = isset($filterData['ownership_flat_id']) ? $filterData['ownership_flat_id'] : "";
        $type = isset($filterData['type']) ? $filterData['type'] : "";
        $html = '';
        if($type == TRANSFERRED){
            $editUrl = admin_url('OwnershipFlat/manage/').$ownershipFlatId."?type=transferred";
            $viewUrl = admin_url('TransferredFlat/manage/').$ownershipFlatId."/1?type=transferred";
            $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('TransferredFlat.view_transferred_flat').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';

            if($dtCIAcl->checkAccess('TransferredFlat|pdf')){
                $html .= '<a target="_blank" href="' . admin_url('OwnershipFlat/transferredFlatPdf/') . $ownershipFlatId . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('TransferredFlat.ownership_flat_pdf') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
            }
        }
        else{
            $editUrl = admin_url('OwnershipFlat/manage/').$ownershipFlatId."?type=first_owner";

            if($dtCIAcl->checkAccess('OwnershipFlat|pdf')){
                $html .= '<a target="_blank" href="' . admin_url('OwnershipFlat/pdf/') . $ownershipFlatId . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('OwnershipFlat.ownership_flat_pdf') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
            }
            if($dtCIAcl->checkAccess('OwnershipFlat|delete')){
                $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('OwnershipFlat.delete_ownership_flat').'" data-id="' . $ownershipFlatId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

            }
            if($dtCIAcl->checkAccess('OwnershipFlat|manage')){
                $html .='<a href="'. $editUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('OwnershipFlat.edit_ownership_flat').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
            }
        }
        return $html;
    }
}

if (!function_exists('rentalsActionButton')) {
    function rentalsActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $rentalsId = isset($filterData['rentals_id']) ? $filterData['rentals_id'] : "";
        $rentAgreementPeriodFrom = isset($filterData['rent_agreement_period_from']) ? $filterData['rent_agreement_period_from'] : "";
        $rentAgreementPeriodTo = isset($filterData['rent_agreement_period_to']) ? $filterData['rent_agreement_period_to'] : "";
        $isClose = isset($filterData['is_close']) ? $filterData['is_close'] : 0;
        $html = '';

        $viewUrl = admin_url('Rentals/manage/').$rentalsId."/1";
        if((strtotime($rentAgreementPeriodTo) < strtotime(TODAY_DATE_YMD) ) || $isClose == 1){
            $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Rentals.view_rentals').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
            if($dtCIAcl->checkAccess('Rentals|pdf')){
                $html .= '<a target="_blank" href="' . admin_url('Rentals/pdf/') . $rentalsId . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('Rentals.rentals_pdf') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
            }
        } else {
            if($dtCIAcl->checkAccess('Rentals|delete')){
                $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Rentals.delete_rentals').'"  data-id="' . $rentalsId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

            }
            if($dtCIAcl->checkAccess('Rentals|manage')){
                $html .='<a href="'. admin_url("Rentals/manage/$rentalsId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Rentals.edit_rentals').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
            }
            if($dtCIAcl->checkAccess('Rentals|pdf')){
                $html .= '<a target="_blank" href="' . admin_url('Rentals/pdf/') . $rentalsId . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('Rentals.rentals_pdf') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
            }
            $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Rentals.view_rentals').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        }

        return $html;
    }
}

if (!function_exists('materialActionButton')) {
    function materialActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $materialId = isset($filterData['material_id']) ? $filterData['material_id'] : "";
        $formSubmit = isset($filterData['form_submit']) ? $filterData['form_submit'] : "";
        $html = '';

        if($dtCIAcl->checkAccess('Material|pdf')){
           $html .= '<a target="_blank" href="' . admin_url('Material/pdf/') . $materialId . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('Material.material_pdf') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
        }
        if($dtCIAcl->checkAccess('Material|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Material.delete_material').'"  data-id="' . $materialId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Material|manage')  &&  in_array($formSubmit, editButtonStatus()) ){
            $html .='<a href="'. admin_url("Material/manage/$materialId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Material.edit_material').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        $html .= '<a href="'. admin_url('Material/manage/').$materialId."/1".'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Material.view_material').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        return $html;
    }
}


if (!function_exists('resourceActionButton')) {
    function resourceActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $resourceId = isset($filterData['resource_id']) ? $filterData['resource_id'] : "";
        $html = '';

        if($dtCIAcl->checkAccess('Resource|delete')){
            //$html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Resource.delete_resource').'"  data-id="' . $resourceId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>';
        }
        if($dtCIAcl->checkAccess('Resource|manage') ){
            $html .='<a href="'. admin_url("Resource/manage/$resourceId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Resource.edit_resource').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        $html .= '<a href="'. admin_url('Resource/manage/').$resourceId."/1".'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Resource.view_resource').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        return $html;
    }
}

if (!function_exists('pollActionButton')) {
    function pollActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $pollId = isset($filterData['poll_id']) ? $filterData['poll_id'] : "";
        $html = '';

        if($dtCIAcl->checkAccess('Poll|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Poll.delete_poll').'"  data-id="' . $pollId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>';
        }
        if($dtCIAcl->checkAccess('Poll|manage') ){
            $html .='<a href="'. admin_url("Poll/manage/$pollId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Poll.edit_poll').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        $html .= '<a href="'. admin_url('Poll/manage/').$pollId."/1".'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Poll.view_poll').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        return $html;
    }
}


if (!function_exists('commonAreaActionButton')) {
    function commonAreaActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $commonAreaId = isset($filterData['common_area_id']) ? $filterData['common_area_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('CommonArea|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('CommonArea.delete_common_area').'" data-id="' . $commonAreaId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('CommonArea|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('CommonArea.edit_common_area').'"  data-id = "'.$commonAreaId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('ParkingAreaActionButton')) {
    function ParkingAreaActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $parkingAreaId = isset($filterData['parking_area_id']) ? $filterData['parking_area_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('ParkingArea|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('ParkingArea.delete_parking_area').'" data-id="' . $parkingAreaId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('ParkingArea|manage')) {
            $html .='<a href="'. admin_url("ParkingArea/manage/$parkingAreaId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('ParkingArea.edit_parking_area').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('manufacturerActionButton')) {
    function manufacturerActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $manufacturerId = isset($filterData['manufacturer_id']) ? $filterData['manufacturer_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Manufacturer|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Manufacturer.delete_manufacturer').'" data-id="' . $manufacturerId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('Manufacturer|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Manufacturer.edit_manufacturer').'"  data-id = "'.$manufacturerId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('managementCommitteeResponsibilitiesActionButton')) {
    function managementCommitteeResponsibilitiesActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $managementCommitteeResponsibilitiesId = isset($filterData['management_committee_responsibilities_id']) ? $filterData['management_committee_responsibilities_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('ManagementCommitteeResponsibilities|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('ManagementCommitteeResponsibilities.delete_mcr').'" data-id="' . $managementCommitteeResponsibilitiesId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('ManagementCommitteeResponsibilities|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('ManagementCommitteeResponsibilities.edit_mcr').'"  data-id = "'.$managementCommitteeResponsibilitiesId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('serviceActionButton')) {
    function serviceActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $serviceId = isset($filterData['service_id']) ? $filterData['service_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Service|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Service.delete_service').'" data-id="' . $serviceId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Service|manage')){
            $html .='<a href="'. admin_url("Service/manage/$serviceId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Service.edit_service').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('commonKeysActionButton')) {
    function commonKeysActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $commonKeysId = isset($filterData['common_keys_id']) ? $filterData['common_keys_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('CommonKeys|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('CommonKeys.delete_common_keys').'" data-id="' . $commonKeysId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('CommonKeys|manage')){
            $html .='<a href="'. admin_url("CommonKeys/manage/$commonKeysId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('CommonKeys.edit_common_keys').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }

        if ($dtCIAcl->checkAccess('KeyIssue|index')) {

            $html .= '<a target="_blank" href="'. admin_url('KeyIssue?ck_id=') . $commonKeysId.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('KeyIssue.view_key_issue').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('bankAccountActionButton')) {
    function bankAccountActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $bankAccountId = isset($filterData['bank_account_id']) ? $filterData['bank_account_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('BankAccount|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('BankAccount.delete_bank_account').'" data-id="' . $bankAccountId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('BankAccount|manage')) {
            $html .='<a href="'. admin_url("BankAccount/manage/$bankAccountId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('BankAccount.edit_bank_account').'"  data-id = "'.$bankAccountId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('brokerActionButton')) {
    function brokerActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $brokerId = isset($filterData['broker_id']) ? $filterData['broker_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Broker|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Broker.delete_broker').'" data-id="' . $brokerId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('Broker|manage')) {
            $html .='<a href="'. admin_url("Broker/manage/$brokerId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Broker.edit_broker').'"  data-id = "'.$brokerId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('parkingSlotActionButton')) {
    function parkingSlotActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $parkingSlotId = isset($filterData['parking_slot_id']) ? $filterData['parking_slot_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('ParkingSlot|delete')) {
            // $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('ParkingSlot.delete_parking_slot').'" data-id="' . $parkingSlotId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('ParkingSlot|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('ParkingSlot.edit_parking_slot').'"  data-id = "'.$parkingSlotId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('statusActionButton')) {
    function statusActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $statusId = isset($filterData['status_id']) ? $filterData['status_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Status|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Status.delete_status').'" data-id="' . $statusId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Status|manage')){
            $html .='<a href="'. admin_url("Status/manage/$statusId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Status.edit_status').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('waterTankActionButton')) {
    function waterTankActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $waterTankId = isset($filterData['water_tank_id']) ? $filterData['water_tank_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('WaterTank|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('WaterTank.delete_water_tank').'" data-id="' . $waterTankId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('WaterTank|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('WaterTank.edit_water_tank').'"  data-id = "'.$waterTankId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('resourceTypeActionButton')) {
    function resourceTypeActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $resourceTypeId = isset($filterData['resource_type_id']) ? $filterData['resource_type_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('ResourceType|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('ResourceType.delete_resource_type').'" data-id="' . $resourceTypeId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('ResourceType|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('ResourceType.edit_resource_type').'"  data-id = "'.$resourceTypeId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('documentActionButton')) {
    function documentActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $documentId = isset($filterData['document_id']) ? $filterData['document_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Document|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Document.delete_document').'" data-id="' . $documentId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Document|manage')){
            $html .='<a href="'. admin_url("Document/manage/$documentId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Document.edit_document').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('documentFolderActionButton')) {
    function documentFolderActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $documentFolderId = isset($filterData['document_folder_id']) ? $filterData['document_folder_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('DocumentFolder|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('DocumentFolder.delete_document_folder').'" data-id="' . $documentFolderId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('DocumentFolder|manage')){
            $html .='<a href="'. admin_url("DocumentFolder/manage/$documentFolderId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('DocumentFolder.edit_document_folder').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('amenitiesActionButton')) {
    function amenitiesActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $amenitiesId = isset($filterData['amenities_id']) ? $filterData['amenities_id'] : "";
        $status = isset($filterData['status']) ? $filterData['status'] : "";
        $html = '';
        $viewUrl = admin_url('Amenities/manage/').$amenitiesId."/1";
        if($dtCIAcl->checkAccess('Amenities|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Amenities.delete_amenities').'" data-id="' . $amenitiesId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('Amenities|manage') && $status != 'approved' && $status != 'rejected') {
            $html .='<a href="'. admin_url("Amenities/manage/$amenitiesId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Amenities.edit_amenities').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Amenities.view_amenities').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';

        return $html;
    }
}

if (!function_exists('invoiceActionButton')) {
    function invoiceActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $invoiceId = isset($filterData['invoice_id']) ? $filterData['invoice_id'] : "";
        $html = '';
        $viewUrl = admin_url('Invoice/manage/').$invoiceId."/1";
        if($dtCIAcl->checkAccess('Invoice|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Invoice.delete_invoice').'" data-id="' . $invoiceId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('Invoice|manage')) {
            $html .='<a href="'. admin_url("Invoice/manage/$invoiceId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Invoice.edit_invoice').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }

        if($dtCIAcl->checkAccess('Invoice|pdf')){
            $html .= '<a target="_blank" href="' . admin_url('Invoice/pdf/') . $invoiceId . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('Invoice.invoice_pdf') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
        }

        // $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Invoice.view_invoice').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';

        return $html;
    }
}

        
        if (!function_exists('voucherActionButton')) {
            function voucherActionButton($filterData = array())
            {
                $dtCIAcl = new \App\Libraries\Dt_ci_acl();
                $voucherId = isset($filterData['voucher_id']) ? $filterData['voucher_id'] : "";
                $moduleType = isset($filterData['module_type']) ? $filterData['module_type'] : "";
                $status = isset($filterData['status']) ? $filterData['status'] : "";
                if($moduleType == "receipt"){
                    $lang = "Receipt";
                } else {
                    $lang = "Voucher";
                }
                $html = '';
                $viewUrl = admin_url('Voucher/manage/').$voucherId."/1/?type=".$moduleType;
                
                if($dtCIAcl->checkAccess('Voucher|pdf')){
                    $html .= '<a target="_blank" href="' . admin_url('Voucher/pdf/') . $voucherId . '/?type='.$moduleType. 'data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang($lang.'.voucher_pdf') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
                }
        
                if($dtCIAcl->checkAccess('Voucher|delete')) {
                    $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang($lang.'.delete_voucher').'" data-id="' . $voucherId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
                }
        
                if($dtCIAcl->checkAccess('Voucher|manage') && $status != 'approved' && $status != 'rejected') {
                    $html .='<a href="'. admin_url("Voucher/manage/$voucherId/?type=".$moduleType).'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang($lang.'.edit_voucher').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
                }
                // $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang($lang.'.view_voucher').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        
        
                return $html;
            }
        }
if (!function_exists('waterMeterReadingActionButton')) {
    function waterMeterReadingActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $waterMeterReadingId = isset($filterData['water_meter_reading_id']) ? $filterData['water_meter_reading_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('WaterMeterReading|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('WaterMeterReading.delete_water_meter_reading').'" data-id="' . $waterMeterReadingId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('WaterMeterReading|manage')){
            $html .='<a href="'. admin_url("WaterMeterReading/manage/$waterMeterReadingId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('WaterMeterReading.edit_water_meter_reading').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('MenPowerAttendanceActionButton')) {
    function MenPowerAttendanceActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $menPowerAttendanceId = isset($filterData['men_power_attendance_id']) ? $filterData['men_power_attendance_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('MenPowerAttendance|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('MenPowerAttendance.delete_men_power_attendance').'" data-id="' . $menPowerAttendanceId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('MenPowerAttendance|manage')){
            $html .='<a href="'. admin_url("MenPowerAttendance/manage/$menPowerAttendanceId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('MenPowerAttendance.edit_men_power_attendance').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('timeSlotActionButton')) {
    function timeSlotActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $timeSlotId = isset($filterData['time_slot_id']) ? $filterData['time_slot_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('TimeSlot|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('TimeSlot.delete_time_slot').'" data-id="' . $timeSlotId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('TimeSlot|manage')){
            $html .='<a href="'. admin_url("TimeSlot/manage/$timeSlotId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('TimeSlot.edit_time_slot').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('accountActionButton')) {
    function accountActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $accountId = isset($filterData['account_id']) ? $filterData['account_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Account|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Account.delete_account').'" data-id="' . $accountId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Account|manage')){
            $html .='<a href="'. admin_url("Account/manage/$accountId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Account.edit_account').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('subAccountActionButton')) {
    function subAccountActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $subAccountId = isset($filterData['sub_account_id']) ? $filterData['sub_account_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('SubAccount|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('SubAccount.delete_sub_account').'" data-id="' . $subAccountId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }
        if($dtCIAcl->checkAccess('SubAccount|manage')){
            $html .='<a href="'. admin_url("SubAccount/manage/$subAccountId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('SubAccount.edit_sub_account').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('organicWasteRecordActionButton')) {
    function organicWasteRecordActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $organicWasteRecordId = isset($filterData['organic_waste_record_id']) ? $filterData['organic_waste_record_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('OrganicWasteRecord|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('OrganicWasteRecord.delete_organic_waste_record').'" data-id="' . $organicWasteRecordId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }
        if($dtCIAcl->checkAccess('OrganicWasteRecord|manage')){
            $html .='<a href="'. admin_url("OrganicWasteRecord/manage/$organicWasteRecordId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('OrganicWasteRecord.edit_organic_waste_record').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('budgetActionButton')) {
    function budgetActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $budgetId = isset($filterData['budget_id']) ? $filterData['budget_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Budget|pdf')){
            $html .= '<a target="_blank" href="' . admin_url('Budget/pdf/') . $budgetId . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('Budget.pdf_budget') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
        }
        if($dtCIAcl->checkAccess('Budget|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Budget.delete_budget').'" data-id="' . $budgetId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }
        if($dtCIAcl->checkAccess('Budget|manage')){
            $html .='<a href="'. admin_url("Budget/manage/$budgetId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Budget.edit_budget').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('bookingActionButton')) {
    function bookingActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $bookingId = isset($filterData['booking_id']) ? $filterData['booking_id'] : "";
        $bookingDate = isset($filterData['booking_date']) ? $filterData['booking_date'] : "";
        $status = isset($filterData['status']) ? $filterData['status'] : "";
        $html = '';

        if($status == 'pending'){
            // if ($dtCIAcl->checkAccess('Booking|delete')) {
            //     if(strtotime($bookingDate) >= strtotime(TODAY_DATE_YMD) || $dtCIAcl->checkAccess('Booking|previousDelete')) {
            //         $html .= '<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="' . lang('Booking.delete_booking') . '" data-id="' . $bookingId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>';
            //     }
            // }
            if ($dtCIAcl->checkAccess('Booking|manage')) {
                if(strtotime($bookingDate) >= strtotime(TODAY_DATE_YMD) || $dtCIAcl->checkAccess('Booking|previousEdit')) {
                    $html .= '<a href="' . admin_url("Booking/manage/$bookingId") . '" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="' . lang('Booking.edit_booking') . '" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
                }
            }
            
        }
        return $html;
    }
}

if (!function_exists('intercomActionButton')) {
    function intercomActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $intercomId = isset($filterData['intercom_id']) ? $filterData['intercom_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Intercom|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Intercom.delete_intercom').'" data-id="' . $intercomId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Intercom|manage')){
            $html .='<a href="'. admin_url("Intercom/manage/$intercomId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Intercom.edit_intercom').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('investmentsActionButton')) {
    function investmentsActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $investmentsId = isset($filterData['investments_id']) ? $filterData['investments_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Investments|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Investments.delete_investments').'" data-id="' . $investmentsId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Investments|manage')){
            $html .='<a href="'. admin_url("Investments/manage/$investmentsId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Investments.edit_investments').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('managementCommitteeActionButton')) {
    function managementCommitteeActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $managementCommitteeId = isset($filterData['management_committee_id']) ? $filterData['management_committee_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('ManagementCommittee|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('ManagementCommittee.delete_management_committee').'" data-id="' . $managementCommitteeId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('ManagementCommittee|manage')){
            $html .='<a href="'. admin_url("ManagementCommittee/manage/$managementCommitteeId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('ManagementCommittee.edit_management_committee').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('meetingActionButton')) {
    function meetingActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $meetingId = isset($filterData['meeting_id']) ? $filterData['meeting_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Meeting|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Meeting.delete_meeting').'" data-id="' . $meetingId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Meeting|manage')){
            $html .='<a href="'. admin_url("Meeting/manage/$meetingId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Meeting.edit_meeting').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('complainActionButton')) {
    function complainActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $complainId = isset($filterData['complain_id']) ? $filterData['complain_id'] : "";
        $isClose = isset($filterData['is_close']) ? $filterData['is_close'] : 0;
        $html = '';
        $viewUrl = admin_url('Complain/manage/').$complainId."/1";
        if($isClose == 1){
            $html .= '<a href="'. $viewUrl.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('Complain.view_complain').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        }
        else{
            if($dtCIAcl->checkAccess('Complain|delete')){
                $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Complain.delete_complain').'" data-id="' . $complainId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

            }
            if($dtCIAcl->checkAccess('Complain|manage')){
                $html .='<a href="'. admin_url("Complain/manage/$complainId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Complain.edit_complain').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
            }
        }
        return $html;
    }
}

if (!function_exists('staffActionButton')) {
    function staffActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $staffId = isset($filterData['staff_id']) ? $filterData['staff_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Staff|pdf')){
            $html .= '<a target="_blank" href="' . admin_url('Staff/pdf/') . $staffId . '" data-bs-toggle = "tooltip"  data-bs-placement = "top" title="' . lang('Staff.pdf_staff') . '" class="btn btn-sm btn-icon "><i class="ti ti-file-text"></i></a>';
        }
        if($dtCIAcl->checkAccess('Staff|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Staff.delete_staff').'" data-id="' . $staffId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Staff|manage')){
            $html .='<a href="'. admin_url("Staff/manage/$staffId").'" data-bs-toggle = "tooltip" data-     dbs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Staff.edit_staff').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('amcActionButton')) {
    function amcActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $amcId = isset($filterData['amc_id']) ? $filterData['amc_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('AMC|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('AMC.delete_amc').'" data-id="' . $amcId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('AMC|manage')){
            $html .='<a href="'. admin_url("AMC/manage/$amcId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('AMC.edit_amc').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('bannerActionButton')) {
    function bannerActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $bannerId = isset($filterData['banner_id']) ? $filterData['banner_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Banner|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Banner.delete_banner').'" data-id="' . $bannerId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Banner|manage')){
            $html .='<a href="'. admin_url("Banner/manage/$bannerId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Banner.edit_banner').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('faqActionButton')) {
    function faqActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $faqId = isset($filterData['faq_id']) ? $filterData['faq_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Faq|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Faq.delete_faq').'" data-id="' . $faqId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Faq|manage')){
            $html .='<a href="'. admin_url("Faq/manage/$faqId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Faq.edit_faq').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}


if (!function_exists('visitActionButton')) {
    function visitActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $visitId = isset($filterData['visit_id']) ? $filterData['visit_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Visit|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Visit.delete_visit').'" data-id="' . $visitId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Visit|manage')){
            $html .='<a href="'. admin_url("Visit/manage/$visitId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Visit.edit_visit').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('vendorActionButton')) {
    function vendorActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $vendorId = isset($filterData['vendor_id']) ? $filterData['vendor_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Vendor|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Vendor.delete_vendor').'" data-id="' . $vendorId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Vendor|manage')){
            $html .='<a href="'. admin_url("Vendor/manage/$vendorId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Vendor.edit_vendor').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('bankActionButton')) {
    function bankActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $bankId = isset($filterData['bank_id']) ? $filterData['bank_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Bank|delete')) {
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Bank.delete_bank').'" data-id="' . $bankId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;
        }

        if($dtCIAcl->checkAccess('Bank|addEdit')) {
            $html .='<a href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Bank.edit_bank').'"  data-id = "'.$bankId.'" class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('chargesActionButton')) {
    function chargesActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $chargesId = isset($filterData['charges_id']) ? $filterData['charges_id'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('Charges|delete')){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('Charges.delete_charges').'" data-id="' . $chargesId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('Charges|manage')){
            $html .='<a href="'. admin_url("Charges/manage/$chargesId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('Charges.edit_charges').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        return $html;
    }
}

if (!function_exists('keyIssueActionButton')) {
    function keyIssueActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $keyIssueId = isset($filterData['key_issue_id']) ? $filterData['key_issue_id'] : "";
        $formSubmit = isset($filterData['form_submit']) ? $filterData['form_submit'] : "";
        $html = '';
        if($dtCIAcl->checkAccess('KeyIssue|delete') ){
            $html .='<a  href="javascript:void(0);" data-bs-toggle = "tooltip" data-bs-placement = "top" title="'. lang('KeyIssue.delete_key_issue').'" data-id="' . $keyIssueId . '" class="btn btn-sm btn-icon dt-delete-record"><i class="ti ti-trash"></i></a>' ;

        }
        if($dtCIAcl->checkAccess('KeyIssue|manage') &&  in_array($formSubmit, editButtonStatus())){
            $html .='<a href="'. admin_url("KeyIssue/manage/$keyIssueId").'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="'. lang('KeyIssue.edit_key_issue').'" class="btn btn-sm btn-icon"><i class="ti ti-edit"></i></a>';
        }
        $html .= '<a href="'. admin_url('KeyIssue/manage/').$keyIssueId."/1".'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('KeyIssue.view_key_issue').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        return $html;
    }
}

if (!function_exists('PollVotesActionButton')) {
    function PollVotesActionButton($filterData = array())
    {
        $dtCIAcl = new \App\Libraries\Dt_ci_acl();
        $pollId = isset($filterData['poll_id']) ? $filterData['poll_id'] : "";
        $html = '';
        if ($dtCIAcl->checkAccess('PollVotesDetail|index')) {

            $html .= '<a target="_blank" href="'. admin_url('PollVotesDetail?poll_id=') . $pollId.'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title= "'. lang('PollVotes.view_poll_votes_detail').'" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a>';
        }
        return $html;
    }
}