<?php
namespace App\Controllers\Api;

use App\Controllers\Admin\Gate;
use App\Models\NotesModel;
use CodeIgniter\RESTful\ResourceController;
use App\Models;
use App\Models\ComplainModel;
use App\Models\CommonWebServiceModel;
use App\Models\SocietyModel;
use App\Models\FlatModel;
use App\Models\TowerModel;
use App\Models\VisitorCompanyModel;
use App\Models\CategoryModel;
use App\Models\MeetingModel;
use App\Models\OwnershipFlatModel;
use App\Models\ParkingSlotModel;
use App\Models\VisitorModel;
use App\Models\ResourceModel;
use App\Models\NoticeModel;
use App\Models\StatusModel;
use App\Models\PollModel;
use App\Models\AmenitiesModel;
use App\Models\BannerModel;
use App\Models\DocumentFolderModel;
use App\Models\ManagementCommitteeModel;
use App\Models\NotificationModel;
use App\Models\SettingModel;
use App\Models\FaqModel;
use App\Models\mediaModel;
use App\Models\EventModel;
use App\Models\GeneratorModel;
use App\Models\WaterTankModel;
use App\Models\ResourceTypeModel;
use Firebase\JWT\JWT;
use CodeIgniter\HTTP\IncomingRequest;
use DateTime;

class GuardApi extends ResourceController
{
    protected $complainModel;
    protected $amenitiesModel;
    protected $commonWebserviceModel;
    protected $ownershipFlatModel;
    protected $parkingSlotModel;
    protected $flatModel;
    protected $towerModel;
    protected $visitorCompanyModel;
    protected $categoryModel;
    protected $societyModel;
    protected $meetingModel;
    protected $statusModel;
    protected $visitorModel;
    protected $resourceModel;
    protected $noticeModel;
    protected $pollModel;
    protected $eventModel;
    protected $bannerModel;
    protected $managementCommitteeModel;
    protected $settingModel;
    protected $notificationModel;
    protected $documentFolderModel;
    protected $faqModel;
    protected $forumModel;
    protected $generatorModel;
    protected $waterTankModel;
    protected $resourceTypeModel;
    protected $managementCommitteeResponsibilitiesModel;

    public function __construct()
    {
        $this->managementCommitteeModel = new ManagementCommitteeModel();
        $this->complainModel = new ComplainModel();
        $this->amenitiesModel = new AmenitiesModel();
        $this->flatModel = new FlatModel();
        $this->meetingModel = new MeetingModel();
        $this->resourceTypeModel = new ResourceTypeModel();
        $this->towerModel = new TowerModel();
        $this->visitorCompanyModel = new VisitorCompanyModel();
        $this->categoryModel = new CategoryModel();
        $this->eventModel = new EventModel();
        $this->visitorModel = new VisitorModel();
        $this->resourceModel = new ResourceModel();
        $this->noticeModel = new NoticeModel();
        $this->pollModel = new PollModel();
        $this->commonWebserviceModel = new CommonWebServiceModel();
        $this->statusModel = new StatusModel();
        $this->societyModel = new SocietyModel();
        $this->ownershipFlatModel = new OwnershipFlatModel();
        $this->rentalModel = new Models\RentalsModel();
        $this->parkingSlotModel = new ParkingSlotModel();
        $this->notificationModel = new NotificationModel();
        $this->amenitiesModel = new Models\AmenitiesModel();
        $this->bookingModel = new Models\BookingModel();
        $this->vendorModel = new Models\VendorModel();
        $this->managementCommitteeModel = new Models\ManagementCommitteeModel();
        $this->managementCommitteeResponsibilitiesModel = new Models\ManagementCommitteeResponsibilitiesModel();
        $this->sosModel = new Models\SosModel();
        $this->staffModel = new Models\StaffModel();
        $this->bannerModel = new Models\BannerModel();
        $this->documentFolderModel = new Models\DocumentFolderModel();
        $this->settingModel = new Models\SettingModel();
        $this->faqModel = new Models\FaqModel();
        $this->forumModel = new Models\ForumModel();
        $this->mediaModel = new Models\MediaModel();
        $this->parkingAreaModel = new Models\ParkingAreaModel();
        $this->ionAuthModel = new Models\IonAuthModel();
        $this->generatorModel = new Models\GeneratorModel();
        $this->waterTankModel = new Models\WaterTankModel();
        helper('Dt_ci_site_helper');
        $this->validation = \Config\Services::validation();
        $this->startRtime = microtime(TRUE);
        $this->db = \Config\Database::connect();
        checkAndCreatePath(CATEGORY_IMAGE_PATH);
        checkAndCreatePath(DOCUMENT_IMAGE_PATH);
        checkAndCreatePath(QR_CODE_IMAGE_PATH);
        checkAndCreatePath(VEHICLE_IMAGE_PATH);
        checkAndCreatePath(EVENT_QR_CODE_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_MEDIA_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_EVENT_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_STAFF_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_ID_PROOF_PATH);
        checkAndCreatePath(THUMBNAIL_CATEGORY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_COMPLAIN_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_CATEGORY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VEHICLE_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VISITOR_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_RENTALS_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_ITEM_IMAGE_PATH);
    }

    public function __destruct()
    {
        // Get the current timestamp
        $this->endRtime = microtime(TRUE);
        // Log the loading time to the log table
        if (REST_ENABLE_LOGGING == TRUE) {
            $this->logAccessTime();
        }
    }

    function checkPin()
    {
        $userId = $this->request->getVar('user_id');
        $pin = $this->request->getVar('pin');
        $appType = $this->request->getVar('app_type');
        // $societyId = $this->request->getVar('society_id');
        $permissionsArray = [];
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('pin', lang('CommonWebService.pin'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'id' => $userId,
            );
            $userData = $this->commonWebserviceModel->getUserData($filterArray);

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();

                $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_id' => $userId,
                    // 'society_id' => $societyId,
                ));
                if(!empty($userDataPermissionFilter)){
                    $permissions = $userDataPermissionFilter['permissions'];
                    $unserializedData = unserialize($permissions);
                    
                    foreach ($permissionsToCheck as $key => $value) {
                        if(!empty($unserializedData)){
                            if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                                $permissionsArray[] = $key;
                            }
                        }
                    }                                    
                }
            }

            $dbPin = isset($userData['pin']) ? $userData['pin'] : 0;
            if (password_verify($pin, $dbPin)) {
                $responseData = true;
            } else {
                $responseData = false;
            }
            if ($responseData) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.pin_verified_successfully'),
                    'data' => null,
                    'user_permission_array' => $permissionsArray,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_pin'),
                    'data' => null,
                    'user_permission_array' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    function changePin()
    {
        $userId = $this->request->getVar('user_id');
        $oldPin = $this->request->getVar('old_pin');
        $newPin = $this->request->getVar('new_pin');
        $confirmPin = $this->request->getVar('confirm_pin');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('old_pin', lang('CommonWebService.old_pin'), 'required|numeric|exact_length[4]');
        $this->validation->setRule('new_pin', lang('CommonWebService.new_pin'), 'required|numeric|exact_length[4]');
        $this->validation->setRule('confirm_pin', lang('CommonWebService.confirm_pin'), 'required|numeric|exact_length[4]');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'id' => $userId,
            );
            $userData = $this->commonWebserviceModel->getUserData($filterArray);
            $dbPin = isset($userData['pin']) ? $userData['pin'] : 0;
            if (password_verify($oldPin, $dbPin)) {
                if ($oldPin == $newPin) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.new_pin_should_be_different_from_old_pin'),
                        'data' => null,
                        'response_code' => 404,
                    );
                    return $this->response($data, 404);
                } else {
                    if ($newPin == $confirmPin) {
                        $filterPin = $this->ionAuthModel->hashPassword($confirmPin);
                        $userPinArray['pin'] = $filterPin;
                        $userPinArray['updated_at'] = date('Y-m-d H:i:s');
                        $userPinArray['updated_by'] = $userData['id'];
                        $responseData = $this->commonWebserviceModel->updateData($userPinArray, 'tbl_users', 'id', $userData['id']);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.confirm_pin_mismatch_new_pin'),
                            'data' => null,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                }
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_old_pin'),
                    'data' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
            if ($responseData) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.pin_change_successfully'),
                    'data' => null,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.error_while_changing_pin'),
                    'data' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    function deviceInfo()
    {
        $deviceId = $this->request->getVar('device_id');
        $deviceToken = $this->request->getVar('device_token');
        $oneSignalId = $this->request->getVar('one_signal_id');
        $deviceType = $this->request->getVar('device_type');
        $deviceModel = $this->request->getVar('device_model');
        $deviceVersion = $this->request->getVar('device_version');
        $playerId = $this->request->getVar('player_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        $this->validation->setRule('device_token', lang('CommonWebService.device_token'), 'required');
        $this->validation->setRule('device_type', lang('CommonWebService.device_type'), 'required');
        $this->validation->setRule('device_model', lang('CommonWebService.device_model'), 'required');
        $this->validation->setRule('device_version', lang('CommonWebService.device_version'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $userDeviceData = $this->commonWebserviceModel->userDevice('', $deviceId, $appType);
            $userDeviceResponse = '';
            if (!empty($userDeviceData) && count($userDeviceData) > 0) {
                $this->commonWebserviceModel->updateData(array('is_latest' => 0), 'tbl_user_device_info', 'device_id', $deviceId);
                if ($playerId != '' && $playerId != 'undefined') {
                    $userDevice = array(
                        'device_id' => $deviceId,
                        'device_type' => $deviceType,
                        'device_token' => $deviceToken,
                        'one_signal_id' => $oneSignalId,
                        'device_model' => $deviceModel,
                        'device_version' => $deviceVersion,
                        'player_id' => $playerId,
                        'user_type' => $appType,
                        'is_latest' => 1,
                        'updated_at' => date('Y-m-d H:i:s'),
                    );
                    $userDeviceResponse = $this->commonWebserviceModel->updateData($userDevice, 'tbl_user_device_info', 'user_device_info_id', $userDeviceData[0]['user_device_info_id']);
                }

            } else {
                if ($playerId != '' && $playerId != 'undefined') {
                    $userDevice = array(
                        'device_id' => $deviceId,
                        'device_type' => $deviceType,
                        'device_token' => $deviceToken,
                        'one_signal_id' => $oneSignalId,
                        'device_model' => $deviceModel,
                        'device_version' => $deviceVersion,
                        'player_id' => $playerId,
                        'user_type' => $appType,
                        'is_latest' => 1,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    );
                    $userDeviceResponse = $this->commonWebserviceModel->insertData($userDevice, 'tbl_user_device_info');
                }
            }
            if (isset($userDeviceResponse) && !empty($userDeviceResponse)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.device_info_store_successfully'),
                    'data' => $userDevice,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);

            } else {
                // Display an error response
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.device_info_not_store'),
                    'data' => $userDevice,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function updateUserDeviceInfo()
    {
        $userId = $this->request->getVar('user_id');
        $deviceId = $this->request->getVar('device_id');
        $appType = $this->request->getVar('app_type');
        $deviceType = $this->request->getVar('device_type');
        $deviceModel = $this->request->getVar('device_model');
        $deviceVersion = $this->request->getVar('device_version');
        $oneSignalId = $this->request->getVar('one_signal_id');
        $playerId = $this->request->getVar('player_id');
        $userTypeId = $this->request->getVar('user_type_id');

        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        $this->validation->setRule('user_type_id', lang('CommonWebService.user_type_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $deviceUserType = '';
            if ($appType == GATE_KEEPER) {
                $deviceUserType = GATE_KEEPER;
            } 
            else if ($appType == MEMBER_APP) {
                $deviceUserType = MEMBER_APP;
            }
            else{
                $deviceUserType = MANAGER_APP;
            }
            $userDeviceData = $this->commonWebserviceModel->userDevice('', $deviceId, $appType);
            // printArray($userDeviceData,1);
            if (!empty($userDeviceData) && count($userDeviceData) > 0) {
                $userDeviceArray = array(
                    'tbl_name' => 'tbl_user_device_info',
                    'user_id' => $userId,
                    'user_type_id' => $userTypeId,
                );
                $this->commonWebserviceModel->updateUserDeviceData($userDeviceArray);
                

                //  $this->commonWebserviceModel->updateData(array('is_latest' => 0), 'tbl_user_device_info', 'user_id', $userId);
                $editUserDevice = array(
                    'device_id' => $deviceId,
                    'user_id' => $userId,
                    'user_type' => $deviceUserType,
                    'user_type_id' => $userTypeId,
                    'is_latest' => 1,
                    'updated_by' => $userId,
                    'updated_at' => date('Y-m-d H:i:s'),
                );
                $userDeviceResponse = $this->commonWebserviceModel->updateData($editUserDevice, 'tbl_user_device_info', 'user_device_info_id', $userDeviceData[0]['user_device_info_id']);
            } else {

                $userDeviceArray = array(
                    'tbl_name' => 'tbl_user_device_info',
                    'user_id' => $userId,
                    'user_type_id' => $userTypeId,
                );
                $this->commonWebserviceModel->updateUserDeviceData($userDeviceArray);

                $userDevice = array(
                    'device_id' => $deviceId,
                    'user_id' => $userId,
                    'user_type' => $deviceUserType,
                    'user_type_id' => $userTypeId,
                    'is_latest' => 1,
                    'created_by' => $userId,
                    'updated_by' => $userId,
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                );
                $userDeviceResponse = $this->commonWebserviceModel->insertData($userDevice, 'tbl_user_device_info');
            }
            if (isset($userDeviceResponse) && !empty($userDeviceResponse)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.device_info_store_successfully'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);

            } else {
                // Display an error response
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.device_info_not_store'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    function getSocietyList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'is_active' => 1,
            );
            $societyData = $this->societyModel->getSocietyData($filterArray);
            if (isset($societyId) && count($societyId) == 1) {
                $societyData = isset($societyData[0]) ? $societyData[0] : array();
            }
            if (!empty($societyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.society_listing_successfully'),
                    'data' => $societyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $societyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    public function userLogin()
    {
        $mobileNo = $this->request->getVar('mobile_no');
        $societyId = $this->request->getVar('society_id');
        $deviceId = $this->request->getVar('device_id');
        $appType = $this->request->getVar('app_type');
        
        $this->validation->setRule('mobile_no', lang('CommonWebService.mobile_no'), 'required|max_length[10]|min_length[10]');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $permissionsArray = array();
            if($appType == MEMBER_APP){
                $permissionsToCheck = customerAppPermission();
                $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Member',
                ));
            }

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();
                $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                    'is_guard' => 1,
                    'is_login' => 1,
                    'is_active' => 1,
                    'is_multiple' => 1,
                ));
            }

            if($appType == MANAGER_APP){
                $permissionsToCheck = managerAppPermission();
                $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Manager',
                ));
            }
            $userData = array();
            $userData = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $mobileNo,
                'society_id' => $societyId,
                'resource_type_id' => $resourceTypeData['resource_type_id'],
            ));

            

            $password = PASSWORD;


            if (empty($userData)) {
                return $this->response(array(
                    'status' => FALSE,
                    'message' => lang('CommonWebService.kindly_contact_society_admin'),
                    'data' => null,
                    'response_code' => 200
                ), 200);
            }

            if ($appType == MEMBER_APP) {
                $ownershipFlatIdArray = array();
                $societyIdArray = array();
                $userSocietyIdArray = array();
                $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'mobile_no' => $mobileNo,
                ));
                $ownershipFlatMemberFoundData = array();
                $rentalMemberFoundData = array();
                $moduleType = '';
                if (!empty($flatMemberFoundData)) {
                    $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                    $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                    if ($moduleType == 'ownership_flat') {
                        $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'mobile_no' => $mobileNo,
                            'is_latest' => 1,
                            'is_active' => 1
                        ));

//                      printArray($ownershipFlatMemberFoundData,1);
                        $flatOwnershipIdArray = array();
                        $userOwnershipIdArray = array();
                        if (!empty($ownershipFlatMemberFoundData)) {
                            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'mobile_no' => $mobileNo,
                                'is_latest' => 1,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                            //printArray($ownershipFlatMemberData,1);
                            if (!empty($ownershipFlatMemberData)) {
                                foreach ($ownershipFlatMemberData as $ownershipFlatMemberElement) {
                                    $societyIdArray[] = $ownershipFlatMemberElement['society_id'];
                                    $flatOwnershipIdArray[] = $ownershipFlatMemberElement['ownership_flat_member_id'];
                                }
                                $societyIdArray = array_unique($societyIdArray);
                                if (!empty($userData)) {
                                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                        'user_id' => $userData['id'],
                                        'type' => MEMBER_APP,
                                        'is_multiple' => 1
                                    ));

//                                  printArray($userSocietyData,1);
                                    if (!empty($userSocietyData)) {
                                        foreach ($userSocietyData as $userSocietyElement) {
                                            $userSocietyIdArray[] = $userSocietyElement['society_id'];
                                            $userOwnershipIdArray[] = $userSocietyElement['type_id'];
                                        }
                                    }
                                    $userSocietyIdArray = array_unique($userSocietyIdArray);
                                }

//                                printArray($userOwnershipIdArray);


                                $userSocietyOwnerMemberDifferenceArray = array_diff($flatOwnershipIdArray, $userOwnershipIdArray);

                                $societyDifferenceArray = array_diff($societyIdArray, $userSocietyIdArray);
                                $lastUserId = $userData['id'];

//                              printArray($societyDifferenceArray)
                                
                            }
                        }
                    } else if ($moduleType == 'rentals') {
                        $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'check_rental_start' => 1,
                            'is_active' => 1
                        ));
//                      printArray($rentalMemberFoundData,1);

                        if (!empty($rentalMemberFoundData)) {
                            $rentalMemberData = $this->rentalModel->getRentalsMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberId,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                        }
                        $rentalsIdArray = array();
                        $societyIdArray = array();
                        //printArray($rentalMemberData,1);
                        if (!empty($rentalMemberData)) {
                            foreach ($rentalMemberData as $rentalMemberElement) {
                                $rentalsIdArray[] = $rentalMemberElement['type_id'];
                            }

                            if (!empty($rentalsIdArray)) {
                                $rentalsData = $this->rentalModel->getRentalsData(array(
                                    'is_api_call' => 1,
                                    'rentals_id' => $rentalsIdArray,
                                    'is_multiple' => 1
                                ));

                                if (!empty($rentalsData)) {
                                    foreach ($rentalsData as $rentalsElement) {
                                        $societyIdArray[] = $rentalsElement['society_id'];
                                    }
                                }
                                $societyIdArray = array_unique($societyIdArray);

                                if (!empty($userData)) {
                                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                        'user_id' => $userData['id'],
                                        'type' => MEMBER_APP,
                                        'is_multiple' => 1
                                    ));
                                    if (!empty($userSocietyData)) {
                                        foreach ($userSocietyData as $userSocietyElement) {
                                            $userSocietyIdArray[] = $userSocietyElement['society_id'];
                                        }
                                    }
                                    $userSocietyIdArray = array_unique($userSocietyIdArray);
                                }

                                $societyDifferenceArray = array_diff($societyIdArray, $userSocietyIdArray);
                                $lastUserId = $userData['id'];
                            }
                        }
                    }
                }
                if ((empty($ownershipFlatMemberData)) && empty($rentalMemberFoundData)) {
                    return $this->response(array(
                        'status' => FALSE,
                        'message' => lang('CommonWebService.kindly_contact_society_admin'),
                        'data' => null,
                        'response_code' => 200
                    ), 200);
                }
            }
            $deviceUserType = '';
            if ($appType == GATE_KEEPER) {
                $deviceUserType = GATE_KEEPER;
            }
            else if ($appType == MANAGER_APP) {
                $deviceUserType = MANAGER_APP;
            }
            else {
                $deviceUserType = MEMBER_APP;
            }
            $userDataFilter = array();
            if (!empty($userData)) {
                if (isset($userData['active']) && $userData['active'] != 1) {
                    //return $this->respond(array(
                    return $this->response(array(
                        'status' => FALSE,
                        'message' => lang('CommonWebService.user_account_is_inactive'),
                        'data' => null,
                        'response_code' => 200
                    ), 200);
                }
                $userId = $userData['id'];
            }
            if ($appType == MEMBER_APP) {
                $userData = $this->commonWebserviceModel->getUserData(array(
                    'phone' => $mobileNo
                ));
                $otp = OTP_CODE;
                if (DEV_ENVIRONMENT == 'production') {
                    if (isset($userData['phone']) && $userData['phone'] == '8976677224') {
                        $otp = OTP_CODE;
                    } else {
                        $otp = GenRandomNumber(6);
                    }
                }
                $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                $userArray['otp'] = $otp;
                $userArray['otp_validity'] = $otpValidity;
                $this->commonWebserviceModel->updateData($userArray, 'tbl_users', 'id', $userData['id']);
                $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                    'phone' => $mobileNo
                ));
                if (!empty($userDataFilter)) {
                    if (empty($userDataFilter['password'])) {
                        $userDataFilter['is_password_empty'] = 1;
                    } else {
                        $userDataFilter['is_password_empty'] = 0;
                    }
                }
            }

            if ($appType == GATE_KEEPER) {
                $otp = OTP_CODE;
                if (DEV_ENVIRONMENT == 'production') {
                    if (isset($userData['phone']) && $userData['phone'] == '8976677224') {
                        $otp = OTP_CODE;
                    } else {
                        $otp = GenRandomNumber(4);
                    }
                }
                $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                $userArray['otp'] = $otp;
                $userArray['otp_validity'] = $otpValidity;
                $userArray['latitude'] = $latitude;
                $userArray['longitude'] = $longitude;
                $this->commonWebserviceModel->updateData($userArray, 'tbl_users', 'id', $userData['id']);
                $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                    'phone' => $mobileNo,
                ));
                if (!empty($userDataFilter)) {
                    if (empty($userDataFilter['pin'])) {
                        $userDataFilter['is_pin_empty'] = 1;
                    } else {
                        $userDataFilter['is_pin_empty'] = 0;
                    }
                }
                $resourceTypeGuardData = $this->resource_type_model->getResourceTypeData(array(
                    'is_guard' => 1,
                    'is_multiple' => 1,
                    'is_login' => 1,
                    'is_active' => 1,
                    'society_id' => $this->session->get('society_id'),
                ));
                $resourceTypeIdArray = [];
                if (!empty($resourceTypeGuardData)) {
                    foreach ($resourceTypeGuardData as $resourceTypeElement) {
                        $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                    }
                }
                $userSocietyIdArray = array();
                $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_id' => $userDataFilter['id'],
                    'resource_type_id' => $resourceTypeIdArray,
                    'is_multiple' => 1
                ));
                if (!empty($userSocietyData)) {
                    foreach ($userSocietyData as $userSocietyElement) {
                        $userSocietyIdArray[] = $userSocietyElement['society_id'];
                    }
                }
                $userSocietyIdArray = array_unique($userSocietyIdArray);

                $groupData = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_id' => $userDataFilter['id'],
                    'society_id' => $userSocietyIdArray,
                ));
                $groupId = isset($groupData['id']) ? $groupData['id'] : '';
                $permissions = isset($groupData['permissions']) ? $groupData['permissions'] : '';
                $unserializedData = unserialize($permissions);
                $permissionsArray = [];
                if(!empty($unserializedData)){
                    foreach ($permissionsToCheck as $key => $value) {
                        if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }

            }

            if ($appType == MANAGER_APP) {
                $otp = OTP_CODE;
                if (DEV_ENVIRONMENT == 'production') {
                    if (isset($userData['phone']) && $userData['phone'] == '8976677224') {
                        $otp = OTP_CODE;
                    } else {
                        $otp = GenRandomNumber(4);
                    }
                }
                $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                $userArray['otp'] = $otp;
                $userArray['otp_validity'] = $otpValidity;
                $this->commonWebserviceModel->updateData($userArray, 'tbl_users', 'id', $userData['id']);
                $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                    'phone' => $mobileNo,
                ));
                if (!empty($userDataFilter)) {
                    if (empty($userDataFilter['pin'])) {
                        $userDataFilter['is_pin_empty'] = 1;
                    } else {
                        $userDataFilter['is_pin_empty'] = 0;
                    }
                }
                $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Manager',
                    'society_id' => $this->session->get('society_id'),
                ));
                $userSocietyIdArray = array();
                $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_id' => $userDataFilter['id'],
                    'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                    'is_multiple' => 1
                ));
                if (!empty($userSocietyData)) {
                    foreach ($userSocietyData as $userSocietyElement) {
                        $userSocietyIdArray[] = $userSocietyElement['society_id'];
                    }
                }
                $userSocietyIdArray = array_unique($userSocietyIdArray);

                $groupData = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_id' => $userDataFilter['id'],
                    'society_id' => $userSocietyIdArray,
                ));
                $groupId = isset($groupData['id']) ? $groupData['id'] : '';
                $permissions = isset($groupData['permissions']) ? $groupData['permissions'] : '';
                $unserializedData = unserialize($permissions);
                
                $permissionsArray = [];
                if(!empty($unserializedData)){
                    foreach ($permissionsToCheck as $key => $value) {
                        if (in_array("MobileManagerApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }
            }

            return $this->response(array(
                'status' => TRUE,
                'message' => lang('CommonWebService.login_successfully'),
                'data' => $userDataFilter,
                // "token" => $token,
                'response_code' => 200,
                'user_permission_array' => $permissionsArray,
            ), 200);

        }
    }


    public function submitOtp()
    {
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if ($appType == "member") {
            $this->validation->setRule('login_type', lang('CommonWebService.login_type'), 'required');
        }
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $userId = $this->request->getVar('user_id');
            $otp = $this->request->getVar('otp');
            $pin = $this->request->getVar('pin');
            $password = $this->request->getVar('password');
            $permissionsArray = array();
            if($appType == MEMBER_APP){
                $permissionsToCheck = customerAppPermission();
                $resourceTypeMemberData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Member',
                    'society_id' => $this->session->get('society_id'),
                ));
            }

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();
                $resourceTypeGuardData = $this->resource_type_model->getResourceTypeData(array(
                    'is_guard' => 1,
                    'is_multiple' => 1,
                    'is_login' => 1,
                    'is_active' => 1,
                    'society_id' => $this->session->get('society_id'),
                ));
                $resourceTypeIdArray = [];
                if (!empty($resourceTypeGuardData)) {
                    foreach ($resourceTypeGuardData as $resourceTypeElement) {
                        $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                    }
                }
            }

            if($appType == MANAGER_APP){
                $permissionsToCheck = managerAppPermission();
                $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Manager',
                    'society_id' => $this->session->get('society_id'),
                ));
            }
            $loginType = $this->request->getVar('login_type');

             
            $filterArray = array(
                'id' => $userId,
            );
             
            $userData = $this->commonWebserviceModel->getUserData($filterArray);

            if ($appType == MEMBER_APP) {
                if (!empty($userData)) {
                    if (strtolower($loginType) == 'otp') {
                        $otpValidityTime = strtotime($userData['otp_validity']);
                        $currentTime = strtotime(date("Y-m-d H:i:s"));
                        if ($otp != $userData['otp']) {
                            return $this->response(array(
                                'status' => false,
                                'response_code' => 404,
                                'message' => lang('CommonWebService.invalid_otp_code'),
                                'data' => null
                            ), 400);
                        } else if ($currentTime > $otpValidityTime) {
                            return $this->response(array(
                                'status' => false,
                                'response_code' => 404,
                                'message' => lang('CommonWebService.otp_code_expired'),
                                'data' => null
                            ), 400);
                        } else {
                            $isUserMultipleFlat = 0;
                            $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
                            $ownershipFlatMemberData = array();
                            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'mobile_no' => $phoneNumber,
                            ));

                            if (!empty($flatMemberFoundData)) {
                                $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                                $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                                if ($moduleType == 'ownership_flat') {
                                    $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                                        'is_latest' => 1,
                                        'is_active' => 1
                                    ));
                                    if (!empty($ownershipFlatMemberFoundData)) {
                                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                            'mobile_no' => $phoneNumber,
                                            'is_latest' => 1,
                                            'is_multiple' => 1,
                                            'is_active' => 1
                                        ));
                                    }
                                } else if ($moduleType == 'rentals') {
                                    $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                                        'check_rental_start' => 1,
                                        'is_active' => 1
                                    ));
                                    if (!empty($rentalMemberFoundData)) {
                                        $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                                            'mobile_no' => $phoneNumber,
                                            'is_multiple' => 1,
                                            'is_active' => 1
                                        ));
                                    }
                                }
                            }

                            $isUserMultipleFlat = count($ownershipFlatMemberData);
                            $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                                'user_id' => $userData['id'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'is_society_id_group' => 1,
                                'is_multiple' => 1
                            ));

                            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                                'user_id' => $userData['id'],
                                'is_multiple' => 1
                            ));
                            $isUserMultipleSociety = count($userDataSocietyFilter);
                            //                          echo 'flat ='.$isUserMultipleFlat;
                            //                          echo "<br/>";
                            //                          echo 'society = '.$isUserMultipleSociety;
                            //                          echo "<br/>";
                            $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                                'id' => $userId
                            ));

                            $isUserSocietyApi = 0;
                            $isFlatSelectRequired = 0;
                            $isSocietySelectRequired = 0;
                            $token = '';
                            //                          if(count($userDataSocietyFilter) > 1){
                            //                              $isUserSocietyApi = 1;
                            //                              $token = '';
                            //                          }
                            if ($isUserMultipleSociety > 1 && $isUserMultipleFlat > 1) {
                                $isSocietySelectRequired = 1;
                                $isFlatSelectRequired = 1;
                            } else if ($isUserMultipleSociety == 1 && $isUserMultipleFlat > 1) {
                                $isSocietySelectRequired = 0;
                                $isFlatSelectRequired = 1;
                            } else if ($isUserMultipleSociety == 1 && $isUserMultipleFlat == 1) {
                                //$isUserSocietyApi = 0;
                                $jwtSecretKey = getenv('JWT_SECRET');
                                $iat = time(); // current timestamp value
                                //$exp = $iat + 36000;
                                $exp = $iat + (30 * 86400); // Expires in 7 days
                                $payload = array(
                                    "iss" => "Issuer of the JWT",
                                    "aud" => "Audience that the JWT",
                                    "sub" => "Subject of the JWT",
                                    "iat" => $iat, //Time the JWT issued at
                                    "exp" => $exp, // Expiration time of token
                                    "email" => $userData['email'],
                                    "user_id" => $userData['id']
                                );
                                $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                            }

                            if (!empty($userDataFilter)) {
                                $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                                $userDataFilter['is_society_api'] = $isUserSocietyApi;
                                $userDataFilter['is_society_selection_required'] = $isSocietySelectRequired;
                                $userDataFilter['is_society_flat_selection_required'] = $isFlatSelectRequired;
                                $userDataFilter['user_society_data'] = $userDataSocietyFilter;
                                $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;

                                // printArray($userDataPermissionFilter);
                                // printArray($permissionsToCheck,1);

                                if($isSocietySelectRequired == 0 && $isFlatSelectRequired == 0){
                                    if(!empty($userDataPermissionFilter)){
                                        $permissions = $userDataPermissionFilter[0]['permissions'];
                                        $unserializedData = unserialize($permissions);
                                        $permissionsArray = [];
                                        if(!empty($unserializedData)){
                                            foreach ($permissionsToCheck as $key => $value) {
                                                if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                                                    $permissionsArray[] = $key;
                                                }
                                            }
                                        }                                    
                                    }
                                }
                            }
                            return $this->response(array(
                                'status' => true,
                                'response_code' => 200,
                                'message' => lang('CommonWebService.otp_verified_successfully'),
                                'data' => $userDataFilter,
                                'user_permission_array' => $permissionsArray,
                                "token" => $token,
                            ), 200);
                        }

                    }
                    if (strtolower($loginType) == 'password') {
                        $dbPassword = $userData['password'];
                        $checkPasswordData = $this->commonWebserviceModel->passwordCheck(array(
                            'db_password' => $dbPassword,
                            'password' => $password
                        ));
                        if (!$checkPasswordData) {
                            return $this->response(array(
                                'status' => FALSE,
                                'message' => lang('CommonWebService.invalid_password'),
                                'data' => null,
                                'response_code' => 200,
                            ), 200);
                        } else {
                            $isUserMultipleFlat = 0;
                            $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
                            $ownershipFlatMemberData = array();
                            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'mobile_no' => $phoneNumber,
                            ));

                            if (!empty($flatMemberFoundData)) {
                                $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                                $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                                if ($moduleType == 'ownership_flat') {
                                    $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                                        'is_latest' => 1,
                                        'is_active' => 1
                                    ));
                                    if (!empty($ownershipFlatMemberFoundData)) {
                                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                            'mobile_no' => $phoneNumber,
                                            'is_latest' => 1,
                                            'is_multiple' => 1,
                                            'is_active' => 1
                                        ));
                                    }
                                } else if ($moduleType == 'rentals') {
                                    $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                                        'check_rental_start' => 1,
                                        'is_active' => 1
                                    ));
                                    if (!empty($rentalMemberFoundData)) {
                                        $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                                            'mobile_no' => $phoneNumber,
                                            'is_multiple' => 1,
                                            'is_active' => 1
                                        ));
                                    }
                                }
                            }

                            $isUserMultipleFlat = count($ownershipFlatMemberData);

                            $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                                'user_id' => $userData['id'],
                                'is_society_id_group' => 1,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'is_multiple' => 1
                            ));

                            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                                'user_id' => $userData['id'],
                                'is_multiple' => 1
                            ));
                            $isUserMultipleSociety = count($userDataSocietyFilter);

                            $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                                'id' => $userId
                            ));

                            $isUserSocietyApi = 0;
                            $isFlatSelectRequired = 0;
                            $isSocietySelectRequired = 0;
                            $token = '';

                            if ($isUserMultipleSociety > 1 && $isUserMultipleFlat > 1) {
                                $isSocietySelectRequired = 1;
                                $isFlatSelectRequired = 1;
                            } else if ($isUserMultipleSociety == 1 && $isUserMultipleFlat > 1) {
                                $isSocietySelectRequired = 0;
                                $isFlatSelectRequired = 1;
                            } else if ($isUserMultipleSociety == 1 && $isUserMultipleFlat == 1) {
                                $jwtSecretKey = getenv('JWT_SECRET');
                                $iat = time(); // current timestamp value
                                //$exp = $iat + 36000;
                                $exp = $iat + (30 * 86400); // Expires in 7 days
                                $payload = array(
                                    "iss" => "Issuer of the JWT",
                                    "aud" => "Audience that the JWT",
                                    "sub" => "Subject of the JWT",
                                    "iat" => $iat, //Time the JWT issued at
                                    "exp" => $exp, // Expiration time of token
                                    "email" => $userData['email'],
                                    "user_id" => $userData['id']
                                );
                                $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                            }

                            if (!empty($userDataFilter)) {
                                $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                                $userDataFilter['is_society_api'] = $isUserSocietyApi;
                                $userDataFilter['is_society_selection_required'] = $isSocietySelectRequired;
                                $userDataFilter['is_society_flat_selection_required'] = $isFlatSelectRequired;
                                $userDataFilter['user_society_data'] = $userDataSocietyFilter;
                                $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;




                                if($isSocietySelectRequired == 0 && $isFlatSelectRequired == 0){
                                    if(!empty($userDataPermissionFilter)){
                                        $permissions = $userDataPermissionFilter[0]['permissions'];
                                        $unserializedData = unserialize($permissions);
                                        $permissionsArray = [];
                                        foreach ($permissionsToCheck as $key => $value) {
                                            if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                                                $permissionsArray[] = $key;
                                            }
                                        }                                    
                                    }
                                }
                            }
                            return $this->response(array(
                                'status' => true,
                                'response_code' => 200,
                                'message' => lang('CommonWebService.password_verified_successfully'),
                                'data' => $userDataFilter,
                                 'user_permission_array' => $permissionsArray,
                                "token" => $token,
                            ), 200);
                        }
                    }

                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strtoupper($loginType) . ' ' . lang('CommonWebService.verified_unsuccessfully'),
                        'data' => null
                    ), 400);
                }
            }


            if ($appType == GATE_KEEPER) {
                $isUpdatePinRequired = 0;
                if (!empty($userData)) {
                    if (empty($userData['pin'])) {
                        $isUpdatePinRequired = 1;
                        if (empty($pin)) {
                            return $this->response(array(
                                'status' => FALSE,
                                'message' => "Please Enter Pin",
                                'data' => null,
                                'response_code' => 400,
                            ), 400);
                        }
                    }

                    $otpValidityTime = strtotime($userData['otp_validity']);
                    $currentTime = strtotime(date("Y-m-d H:i:s"));
                    if ($otp != $userData['otp']) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.invalid_otp_code'),
                            'data' => null
                        ), 400);
                    } else if ($currentTime > $otpValidityTime) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.otp_code_expired'),
                            'data' => null
                        ), 400);
                    } else {
                        if ($isUpdatePinRequired == 1 || $pin != '') {
                            $filterPin = $this->ionAuthModel->hashPassword($pin);
                            $userPinArray['pin'] = $filterPin;
                            $userPinArray['updated_at'] = date('Y-m-d H:i:s');
                            $userPinArray['updated_by'] = $userData['id'];
                            $this->commonWebserviceModel->updateData($userPinArray, 'tbl_users', 'id', $userData['id']);
                        }


                        $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                            'user_id' => $userData['id'],
                            'resource_type_id' => $resourceTypeIdArray,
                            'is_society_id_group' => 1,
                            'is_multiple' => 1
                        ));
                        if (count($userDataSocietyFilter) > 1) {
                            $isUserSocietyApi = 1;
                            $token = '';
                        } else {
                            $isUserSocietyApi = 0;
                            $jwtSecretKey = getenv('JWT_SECRET');
                            $iat = time(); // current timestamp value
                            //$exp = $iat + 36000;
                            $exp = $iat + (30 * 86400); // Expires in 7 days
                            $payload = array(
                                "iss" => "Issuer of the JWT",
                                "aud" => "Audience that the JWT",
                                "sub" => "Subject of the JWT",
                                "iat" => $iat, //Time the JWT issued at
                                "exp" => $exp, // Expiration time of token
                                "email" => $userData['email'],
                                "user_id" => $userData['id']
                            );
                            $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                        }
                        $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                            'id' => $userId
                        ));

                        $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                            'user_id' => $userId,
                            'is_multiple' => 1
                        ));

                        if(!empty($userDataPermissionFilter)){
                            $permissions = $userDataPermissionFilter[0]['permissions'];
                            $unserializedData = unserialize($permissions);
                            $permissionsArray = [];
                            if(!empty($unserializedData)){
                                foreach ($permissionsToCheck as $key => $value) {
                                    if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                                        $permissionsArray[] = $key;
                                    }
                                }
                            }                                    
                        }

                        if (!empty($userDataFilter)) {
                            $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                            $userDataFilter['is_society_api'] = $isUserSocietyApi;
                            $userDataFilter['is_society_selection_required'] = $isUserSocietyApi;
                            $userDataFilter['user_society_data'] = $userDataSocietyFilter;
                        }

                        return $this->response(array(
                            'status' => true,
                            'response_code' => 200,
                            'message' => lang('CommonWebService.otp_verified_successfully'),
                            'data' => $userDataFilter,
                             'user_permission_array' => $permissionsArray,
                            "token" => $token,
                        ), 200);
                    }
                }
            }

            if ($appType == MANAGER_APP) {
                if (!empty($userData)) {
                    $otpValidityTime = strtotime($userData['otp_validity']);
                    $currentTime = strtotime(date("Y-m-d H:i:s"));
                    if ($otp != $userData['otp']) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.invalid_otp_code'),
                            'data' => null
                        ), 400);
                    } else if ($currentTime > $otpValidityTime) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.otp_code_expired'),
                            'data' => null
                        ), 400);
                    } else {
                        $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                            'user_id' => $userData['id'],
                            'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                            'is_society_id_group' => 1,
                            'is_multiple' => 1
                        ));
                        if (count($userDataSocietyFilter) > 1) {
                            $isUserSocietyApi = 1;
                            $token = '';
                        } else {
                            $isUserSocietyApi = 0;
                            $jwtSecretKey = getenv('JWT_SECRET');
                            $iat = time(); // current timestamp value
                            //$exp = $iat + 36000;
                            $exp = $iat + (30 * 86400); // Expires in 7 days
                            $payload = array(
                                "iss" => "Issuer of the JWT",
                                "aud" => "Audience that the JWT",
                                "sub" => "Subject of the JWT",
                                "iat" => $iat, //Time the JWT issued at
                                "exp" => $exp, // Expiration time of token
                                "email" => $userData['email'],
                                "user_id" => $userData['id']
                            );
                            $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                        }
                        $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                            'id' => $userId
                        ));

                        $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                            'user_id' => $userId,
                            'is_multiple' => 1
                        ));

                        if(!empty($userDataPermissionFilter)){
                            $permissions = $userDataPermissionFilter[0]['permissions'];
                            $unserializedData = unserialize($permissions);
                            $permissionsArray = [];
                            if(!empty($unserializedData)){
                                foreach ($permissionsToCheck as $key => $value) {
                                    if (in_array("MobileManagerApp|$key", $unserializedData)) {
                                        $permissionsArray[] = $key;
                                    }
                                }
                            }                                    
                        }
                        if (!empty($userDataFilter)) {
                            $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                            $userDataFilter['is_society_api'] = $isUserSocietyApi;
                            $userDataFilter['is_society_selection_required'] = $isUserSocietyApi;
                            $userDataFilter['user_society_data'] = $userDataSocietyFilter;
                        }
                        return $this->response(array(
                            'status' => true,
                            'response_code' => 200,
                            'message' => lang('CommonWebService.otp_verified_successfully'),
                            'data' => $userDataFilter,
                             'user_permission_array' => $permissionsArray,
                            "token" => $token,
                        ), 200);
                    }
                }
            }
        }
    }

    public function resendOtp()
    {
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $userId = $this->request->getVar('user_id');
            $appType = $this->request->getVar('app_type');

              
            $filterArray = array(
                'id' => $userId,
            );
              
            $userData = $this->commonWebserviceModel->getUserData($filterArray);

            if (!empty($userData)) {
                $otpValidityTime = strtotime($userData['updated_at'], strtotime("-60 seconds"));
                $currentTime = strtotime(date("Y-m-d H:i:s", strtotime("-60 seconds")));
                if ($currentTime < $otpValidityTime) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.otp_send_every_second'),
                        'data' => null
                    ), 400);
                } else {
                    $otp = OTP_CODE;
                    $mobileNo = isset($userData['phone']) ? $userData['phone'] : "";
                    if (DEV_ENVIRONMENT == 'production') {
                        if ($mobileNo == '8976677224') {
                            $otp = OTP_CODE;
                        } else {
                            $otp = GenRandomNumber(6);
                        }
                    }
                    $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                    $otpArray = array(
                        'id' => $userId,
                        'otp' => $otp,
                        'otp_validity' => $otpValidity,
                        'updated_at' => DATE_TIME_DATABASE
                    );

                    $this->commonWebserviceModel->updateData($otpArray, 'tbl_users', 'id', $userId);

                    // if (DEV_ENVIRONMENT == 'production') {
                    //      sendSmsOtp($mobileNo,$otp . " is the OTP for your Tripwell account. Keep this OTP to yourself and do not share with anyone for account safety. - TRIPWELL TAXI SERVICES PRIVATE LIMITED",1207167430511390056);
                    // }

                    $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                        'phone' => $mobileNo
                    ));

                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => lang('CommonWebService.otp_send_successfully'),
                        'data' => $userDataFilter,
                    ), 200);
                }
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null
                ), 400);
            }
        }
    }

    function getUserSocietyList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_id' => $userId,
                "is_multiple" => 1,
                'search' => $search,
                "is_society_id_group" => 1,
                'start' => $start,
            ));
            if (!empty($userSocietyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.user_society_listing_successfully'),
                    'data' => $userSocietyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $userSocietyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    function userSocietyLogin()
    {
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $permissionsArray = array();
            if($appType == MEMBER_APP){
                $permissionsToCheck = customerAppPermission();
            }

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();
            }

            if($appType == MANAGER_APP){
                $permissionsToCheck = managerAppPermission();
            }
            if ($appType == MEMBER_APP) {
                $filterArray = array(
                    'id' => $userId,
                );
                $userData = $this->commonWebserviceModel->getUserData($filterArray);

                $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_id' => $userId,
                    'is_society_id_group' => 1,
                    'society_id' => $societyId,
                    'is_multiple' => 1,
                ));

                $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_id' => $userId,
                    'society_id' => $societyId,
                    'is_multiple' => 1
                ));

                if (empty($userSocietyData)) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.invalid_society'),
                        'data' => $userSocietyData,
                        'response_code' => 404,
                    );
                    //return $this->respond($data,404);
                    return $this->response($data, 404);
                }

                $isUserMultipleFlat = 0;
                $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
                $ownershipFlatMemberData = array();

                $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'mobile_no' => $phoneNumber,
                    'society_id' => $societyId
                ));

                if (!empty($flatMemberFoundData)) {
                    $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                    $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                    if ($moduleType == 'ownership_flat') {
                        $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'society_id' => $societyId,
                            'is_latest' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($ownershipFlatMemberFoundData)) {
                            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'mobile_no' => $phoneNumber,
                                'society_id' => $societyId,
                                'is_latest' => 1,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                        }
                    } else if ($moduleType == 'rentals') {
                        $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'society_id' => $societyId,
                            'check_rental_start' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($rentalMemberFoundData)) {
                            $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                                'mobile_no' => $phoneNumber,
                                'society_id' => $societyId,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                        }
                    }
                }

                $isUserMultipleFlat = count($ownershipFlatMemberData);
                $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                    'id' => $userId
                ));

                if ($isUserMultipleFlat > 1) {
                    if (!empty($userDataFilter)) {
                        $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                        $userDataFilter['is_society_flat_selection_required'] = 1;
                        $userDataFilter['user_society_data'] = $userSocietyData;
                        $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;
                    }
                    if (!empty($userDataFilter)) {
                        $data = array(
                            'status' => true,
                            'message' => lang('CommonWebService.user_society_login_successfully'),
                            'data' => $userDataFilter,
                            'user_permission_array' => $permissionsArray,
                            'response_code' => 200,
                        );
                        return $this->response($data, 200);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.no_data_found'),
                            'data' => $userDataFilter,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                } else {
                    $jwtSecretKey = getenv('JWT_SECRET');
                    $iat = time(); // current timestamp value
                    //$exp = $iat + 36000; // Expires in 10 hours
                    $exp = $iat + (30 * 86400); // Expires in 7 days
                    $payload = array(
                        "iss" => "Issuer of the JWT",
                        "aud" => "Audience that the JWT",
                        "sub" => "Subject of the JWT",
                        "iat" => $iat, //Time the JWT issued at
                        "exp" => $exp, // Expiration time of token
                        "email" => $userDataFilter['email'],
                        "user_id" => $userDataFilter['id'],
                    );
                    $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                    if (!empty($userDataFilter)) {
                        $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                        $userDataFilter['is_society_flat_selection_required'] = 0;
                        $userDataFilter['user_society_data'] = $userSocietyData;
                        $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;
                    }

                    if(!empty($userDataPermissionFilter)){
                        $permissions = $userDataPermissionFilter[0]['permissions'];
                        $unserializedData = unserialize($permissions);
                        $permissionsArray = [];
                        if(!empty($unserializedData)){
                            foreach ($permissionsToCheck as $key => $value) {
                                if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                                    $permissionsArray[] = $key;
                                }
                            } 
                        }                                   
                    }

                    if (!empty($userDataFilter)) {
                        $data = array(
                            'status' => true,
                            'message' => lang('CommonWebService.user_society_login_successfully'),
                            'data' => $userDataFilter,
                            'user_permission_array' => $permissionsArray,
                            'token' => $token,
                            'response_code' => 200,
                        );
                        return $this->response($data, 200);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.no_data_found'),
                            'data' => $userDataFilter,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                }
            }

            if ($appType == GATE_KEEPER || $appType == MANAGER_APP) {
                if ($appType == GATE_KEEPER) {

                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'user_id' => $userId,
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeIdArray,
                        'is_multiple' => 1,
                    ));

                    $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                        'user_id' => $userId,
                        'society_id' => $societyId,
                        'is_multiple' => 1
                    ));

                    if(!empty($userDataPermissionFilter)){
                        $permissions = $userDataPermissionFilter[0]['permissions'];
                        $unserializedData = unserialize($permissions);
                        $permissionsArray = [];
                        if(!empty($unserializedData)){
                            foreach ($permissionsToCheck as $key => $value) {
                                if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                                    $permissionsArray[] = $key;
                                }
                            } 
                        }                                   
                    }

                }
                else if ($appType == MANAGER_APP) {
                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'user_id' => $userId,
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                        'is_multiple' => 1,
                    ));

                    $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                        'user_id' => $userId,
                        'society_id' => $societyId,
                        'is_multiple' => 1
                    ));

                    if(!empty($userDataPermissionFilter)){
                        $permissions = $userDataPermissionFilter[0]['permissions'];
                        $unserializedData = unserialize($permissions);
                        $permissionsArray = [];
                        if(!empty($unserializedData)){
                            foreach ($permissionsToCheck as $key => $value) {
                                if (in_array("MobileManagerApp|$key", $unserializedData)) {
                                    $permissionsArray[] = $key;
                                }
                            }
                        }                                        
                    }
                }

                if (empty($userSocietyData)) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.invalid_society'),
                        'data' => $userSocietyData,
                        'response_code' => 404,
                    );
                    //return $this->respond($data,404);
                    return $this->response($data, 404);
                }
                $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                    'id' => $userId
                ));
                $jwtSecretKey = getenv('JWT_SECRET');
                $iat = time(); // current timestamp value
                //$exp = $iat + 36000;
                $exp = $iat + (30 * 86400); // Expires in 7 days
                $payload = array(
                    "iss" => "Issuer of the JWT",
                    "aud" => "Audience that the JWT",
                    "sub" => "Subject of the JWT",
                    "iat" => $iat, //Time the JWT issued at
                    "exp" => $exp, // Expiration time of token
                    "email" => $userDataFilter['email'],
                    "user_id" => $userDataFilter['id'],
                );
                $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                if (!empty($userDataFilter)) {
                    $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                    $userDataFilter['user_society_data'] = $userSocietyData;
                }
                if (!empty($userDataFilter)) {
                    $data = array(
                        'status' => true,
                        'message' => lang('CommonWebService.user_society_login_successfully'),
                        'data' => $userDataFilter,
                        'user_permission_array' => $permissionsArray,
                        'token' => $token,
                        'response_code' => 200,
                    );
                    return $this->response($data, 200);
                } else {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.no_data_found'),
                        'data' => $userDataFilter,
                        'response_code' => 404,
                    );
                    return $this->response($data, 404);
                }
            }

        }
    }


    function getUserSocietyFlatList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'id' => $userId,
            );
            $userData = $this->commonWebserviceModel->getUserData($filterArray);

            $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
            $ownershipFlatMemberData = array();

            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'mobile_no' => $phoneNumber,
            ));

            if (!empty($flatMemberFoundData)) {
                $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                if ($moduleType == 'ownership_flat') {
                    $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_latest' => 1,
                        'is_active' => 1
                    ));
                    if (!empty($ownershipFlatMemberFoundData)) {
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'mobile_no' => $phoneNumber,
                            'society_id' => $societyId,
                            'is_latest' => 1,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                    }
                } else if ($moduleType == 'rentals') {
                    $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'check_rental_start' => 1,
                        'is_active' => 1
                    ));
                    if (!empty($rentalMemberFoundData)) {
                        $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                            'mobile_no' => $phoneNumber,
                            'society_id' => $societyId,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                    }
                }
            }

            if (!empty($ownershipFlatMemberData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.user_society_flat_listing_successfully'),
                    'data' => $ownershipFlatMemberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $ownershipFlatMemberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    function userSocietyFlatLogin()
    {
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $permissionsArray = array();
            $permissionsToCheck = customerAppPermission();
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_id' => $userId,
                'society_id' => $societyId,
                'is_multiple' => 1,
            ));
            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                'user_id' => $userId,
                'society_id' => $societyId,
                'is_multiple' => 1
            ));
            $filterArray = array(
                'id' => $userId,
            );
            $userData = $this->commonWebserviceModel->getUserData($filterArray);

            $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;

            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'mobile_no' => $phoneNumber,
            ));


            if (!empty($flatMemberFoundData)) {
                $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                //$ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                if ($moduleType == 'ownership_flat') {
                    $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_latest' => 1,
                        'is_active' => 1
                    ));
                    if (!empty($ownershipFlatMemberFoundData)) {
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'society_id' => $societyId,
                            'is_latest' => 1,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                    }
                } else if ($moduleType == 'rentals') {
                    $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'check_rental_start' => 1,
                        'is_active' => 1
                    ));
                    if (!empty($rentalMemberFoundData)) {
                        $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'society_id' => $societyId,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                    }
                }
            }

            if (empty($ownershipFlatMemberData)) {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_society_flat'),
                    'data' => $ownershipFlatMemberData,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
            $userDataFilter = $this->commonWebserviceModel->getUserData(array(
                'id' => $userId
            ));
            $jwtSecretKey = getenv('JWT_SECRET');
            $iat = time(); // current timestamp value
            //$exp = $iat + 36000;
            $exp = $iat + (30 * 86400); // Expires in 7 days
            $payload = array(
                "iss" => "Issuer of the JWT",
                "aud" => "Audience that the JWT",
                "sub" => "Subject of the JWT",
                "iat" => $iat, //Time the JWT issued at
                "exp" => $exp, // Expiration time of token
                "email" => $userDataFilter['email'],
                "user_id" => $userDataFilter['id'],
            );
            $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
            if (!empty($userDataFilter)) {
                $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                $userDataFilter['user_society_data'] = $userSocietyData;
                $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;

                if(!empty($userDataPermissionFilter)){
                    $permissions = $userDataPermissionFilter[0]['permissions'];
                    $unserializedData = unserialize($permissions);
                    $permissionsArray = [];
                    if(!empty($unserializedData)){
                        foreach ($permissionsToCheck as $key => $value) {
                            if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                                $permissionsArray[] = $key;
                            }
                        } 
                    }                                   
                }
            }
            if (!empty($userDataFilter)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.user_society_flat_login_successfully'),
                    'data' => $userDataFilter,
                    'user_permission_array' => $permissionsArray,
                    'token' => $token,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $userDataFilter,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditVisitor()
    {
//      $myfilePost = fopen("addEditVisitorPost.json", "a") or die("Unable to open file!");
//      fwrite($myfilePost, json_encode($_POST));
//      fclose($myfilePost);
//
//      $myfilePost = fopen("addEditVisitorFile.json", "a") or die("Unable to open file!");
//      fwrite($myfilePost, json_encode($_FILES));
//      fclose($myfilePost);
//      $visitorNameMobileNo = $this->request->getVar('visitor_name_mobile_no');
//      $visitorNameMobileNoArray = json_decode($visitorNameMobileNo, true);
//      $myfilePost1 = fopen("addEditVisitorFileMOOOO11.json", "a") or die("Unable to open file!");
//      fwrite($myfilePost1, json_encode($visitorNameMobileNoArray));
//      fclose($myfilePost1);
//      die();
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $visitorId = $this->request->getVar('visitor_id');
        $visitorNameMobileNo = $this->request->getVar('visitor_name_mobile_no');
        $visitorPurpose = $this->request->getVar('visitor_purpose');
        $visitorDuration = $this->request->getVar('visitor_duration');
        $vehicleType = $this->request->getVar('vehicle_type');
        $vehicleNo = $this->request->getVar('vehicle_no');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $type = $this->request->getVar('type');
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $visitorCompanyName = $this->request->getVar('visitor_company_name');
        $noOfParcel = $this->request->getVar('no_of_parcel');
        $collectOnGate = $this->request->getVar('collect_on_gate');
        $status = $this->request->getVar('status');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $resourceInTime = $this->request->getVar('resource_in_time');
        $resourceOutTime = $this->request->getVar('resource_out_time');
        $address = $this->request->getVar('address');
        $workingDayName = $this->request->getVar('working_day_name');
        $userId = $this->request->getVar('user_id');
        $documentImage = $this->request->getVar('document_image[]');
        $idProof = $this->request->getVar('id_proof');
        $noOfVisitor = $this->request->getVar('no_of_visitor');
        $isStatusUpdate = $this->request->getVar('is_status_update');
        $expectedStartDateTime = $this->request->getVar('expected_start_date_time');
        $expectedEndDateTime = $this->request->getVar('expected_end_date_time');
        $anyTimeDuringTheDay = $this->request->getVar('anytime_during_the_day');
        $isDeliveredToMember = $this->request->getVar('is_delivered_to_member');
        $otp = $this->request->getVar('otp');
        $appType = $this->request->getVar('app_type');
        $deliveryReferenceName = $this->request->getVar('reference_name');
        $deliveryReferenceMobile = $this->request->getVar('reference_mobile');
        $visitorNameMobileNoArray = json_decode($visitorNameMobileNo, true);
        $workingDayNameArray = json_decode($workingDayName, true);
        $visitorValidationData = array();
        $lastVisitorIdArray = array();

        $userData = $this->commonWebserviceModel->getUserData(array(
            'id' => $userId,
        ));
        $resourceTypeId = $userData['resource_type_id'];


        if(!empty($parkingPlaceId)){
            $visitorParkingStoreData = $this->visitorModel->getVisitorData(array(
                'parking_slot_id' => $parkingSlotId, // 2
                'status' => array("approval_pending","waiting_for_approval","entry_pre_approve","entered"),
            ));

            if(!empty($visitorParkingStoreData)){
                return $this->response(array(
                    'status' => FALSE,
                    'message' => "This Parking Slot Is Already Assigned",
                    'data' => null,
                    'response_code' => 400,
                ), 400);
            }

            // $parkingPlaceData = $this->parkingPlaceModel->getParkingPlaceData(array(
            //     "parking_place_id" => $parkingPlaceId
            // ));

            // if(!empty($parkingPlaceData)){
            //     if($parkingPlaceData['vehicle_type']){
            //         return $this->response(array(
            //             'status' => FALSE,
            //             'message' => "This Parking Slot Is Already Assigned",
            //             'data' => null,
            //             'response_code' => 400,
            //         ), 400);
            //     }
            // }
        }

        if ($type != 'delivery_boy' && empty($visitorId)) {
            if (is_array($visitorNameMobileNoArray)) {
                foreach ($visitorNameMobileNoArray as $visitor) {
                    $visitorValidationData['visitor_name'][] = isset($visitor['visitor_name']) ? $visitor['visitor_name'] : '';
                    $visitorValidationData['visitor_mobile_no'][] = isset($visitor['visitor_mobile_no']) ? $visitor['visitor_mobile_no'] : '';
                }
            }

            $visitorValidationData['type'] = $type;
            $visitorValidationData['society_id'] = $societyId;

            $rules = [
                'visitor_name.*' => 'required',
                'visitor_mobile_no.*' => 'required',
                'type' => 'required',
                'society_id' => 'required|numeric',
            ];

            $messages = [
                'visitor_name.*' => [
                    'required' => 'The visitor name is required.',
                ],
                'visitor_mobile_no.*' => [
                    'required' => 'The mobile number is required.',
                    // 'numeric' => 'The mobile number must be numeric.',
                    //'exact_length[10]' => 'Mobile number should be bew',
                ],
                'type' => [
                    'required' => 'The Type is required.',
                ],
                'society_id' => [
                    'required' => 'The Society id is required.',
                ],
            ];
            $this->validation->setRules($rules, $messages);

            if (!$this->validation->run($visitorValidationData)) {
                // validation failed
                $errors = $this->validation->getErrors();
                return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                ), 400);
            }
        }

        // $currentTimeStamp = strtotime(date("Y-m-d H:i:s"));
        // $expectedStartDateTimeStamp = strtotime($expectedStartDateTime);
        // if($expectedStartDateTimeStamp < $currentTimeStamp){
        //     return $this->response(array(
        //         'status' => FALSE,
        //         'message' => "Expected Start Date-Time Can't Be Earlier Than Current Time.",
        //         'data' => null,
        //         'response_code' => 400,
        //     ), 400);
        // } 

        $expectedStartDateTimeStamp = strtotime($expectedStartDateTime);
        $expectedEndDateTimeStamp = strtotime($expectedEndDateTime);
        if ($expectedEndDateTimeStamp <= $expectedStartDateTimeStamp) {
            return $this->response(array(
                'status' => FALSE,
                'message' => "End Time Must Be Greater Than Start Time.",
                'data' => null,
                'response_code' => 400,
            ), 400);
        }
        $visitorRecordData = $this->visitorModel->getVisitorData(array(
            'visitor_id' => $visitorId,
        ));

        $visitorUpdateArray = array();
        $visitorStatusUpdateArray = array();
        if (!empty($isDeliveredToMember) && !empty($visitorId)) {
            $filterArray = array(
                'visitor_id' => $visitorId,
            );
            $visitorOtpData = $this->visitorModel->getVisitorData($filterArray);
            if (!empty($visitorOtpData)) {
                $otpValidityTime = strtotime($visitorOtpData['otp_validity']);
                $currentTime = strtotime(date("Y-m-d H:i:s"));
                if ($otp != $visitorOtpData['otp']) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.invalid_otp_code'),
                        'data' => null
                    ), 400);
                }
                // else if ($currentTime > $otpValidityTime) {
                //  return $this->response(array(
                //         'status' => false,
                //         'response_code' => 404,
                //         'message' => lang('CommonWebService.otp_code_expired'),
                //         'data' => null
                //     ), 400);
                // }
                else {
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'status' => $status,
                        // 'otp' => $otp,
                        'delivery_reference_name' => $deliveryReferenceName,
                        'delivery_reference_mobile' => $deliveryReferenceMobile,
                    );
                    // if($status == 'collected'){
                    //  $visitorArray['delivery_date'] = date("Y-m-d H:i:s");
                    // }
                    $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                        'visitor_id' => $visitorId,
                    ));
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $visitorId,
                        "document_type" => 'visitorId',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }
                    $notificationArray = array(
                        'ownership_flat_member_id' => $visitorUpdateData['ownership_flat_member_id'],
                        'ownership_flat_id' => $visitorUpdateData['ownership_flat_id'],
                        'status' => $status,
                        'type' => $visitorUpdateData['type'],
                        'society_id' => $societyId,
                        'user_id' => $userId,
                        'type_id' => $visitorId,
                        'visitor_name' => $visitorUpdateData['visitor_name'],
                        'mobile_no' => $visitorUpdateData['visitor_mobile_no'],
                        'display_status' => underscoreToUcWord($status),
                        'image' => $visitorImagePath,
                        'collect_on_gate' => $visitorUpdateData['collect_on_gate'],
                        'vehicle_no' => $visitorUpdateData['vehicle_no'],
                        'visitor_company_name' => $visitorUpdateData['visitor_company_name'],
                        'no_of_parcel' => $visitorUpdateData['no_of_parcel'],
                        'guard' => $visitorUpdateData['updated_by_name'],
                        'module' => 'visitor',
                        'app_type' => $appType,
                        'member_name' => $visitorUpdateData['name'],
                    );
                    $extraDatajson = json_encode($notificationArray);
                    if ($appType == GATE_KEEPER) {
                        $notificationArray['send_for_notification'] = $appType;
                        $notificationArray['send_for_notification_id'] = $userId;
                        $notificationArray['receive_for_notification'] = $resourceTypeId;
                        $notificationArray['receive_for_notification_id'] = $visitorUpdateData['ownership_flat_member_id'];
                    }

                    if ($appType == MEMBER_APP) {
                        $notificationArray['send_for_notification'] = $appType;
                        $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                        $notificationArray['receive_for_notification'] = $resourceTypeId;
                        $notificationArray['receive_for_notification_id'] = 0;
                    }

                    sendNotificationDataList($notificationArray, $extraDatajson);
                    $visitorUpdateArray = compareArray($visitorArray, $visitorUpdateData);
                    $extraData = array();
                    $extraObj['api_user_id'] = $userId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);
                    $lastVisitorId = $visitorData['lastInsertedId'];
                    array_push($lastVisitorIdArray,$lastVisitorId);
                    $visitorStatusArray = array(
                        'visitor_status_history_id' => '',
                        'visitor_id' => $visitorUpdateData['visitor_id'],
                        'status' => $visitorUpdateData['status'],
                    );
                    $visitorStatusData = $this->commonWebserviceModel->insertUpdateRecord($visitorStatusArray, 'visitor_status_history_id', 'tbl_visitor_status_history', 1, '', array(), $extraData, $visitorStatusUpdateArray);
                    //     return $this->response(array(
                    //     'status' => true,
                    //     'response_code' => 200,
                    //     'message' => lang('CommonWebService.otp_verified_successfully'),
                    //     'data' => null
                    // ), 200);
                }
            }
        } else {

            $documentImageData = array();
            if (isset($_FILES["document_image"])) {
                $documentImagePath = DOCUMENT_IMAGE_PATH;
                $documentImageData = $dt_ci_file_upload->UploadMultipleFile('document_image', MAX_IMAGE_SIZE_LIMIT, $documentImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($documentImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($documentImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($documentImageData['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($documentImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }
            if (isset($_FILES["id_proof"])) {
                $idProofPath = ID_PROOF_PATH;
                $ownershipFlatId = $this->request->getVar('ownership_flat_id');
                $idProofResult = $dt_ci_file_upload->uploadFile('id_proof', MAX_IMAGE_SIZE_LIMIT, $idProofPath, true, true, array('jpeg', 'png', 'jpg'));
                if ($idProofResult['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($idProofResult['message']),
                        'data' => null
                    ), 404);
                } else {
                    $idProofRecord = $idProofResult['file_name'];
                    unset($idProofResult['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($idProofResult, ID_PROOF_PATH, THUMBNAIL_ID_PROOF_PATH);
                }
            }

            if (isset($visitorId) && $visitorId != '') {
                if (isset($documentImageData) && count($documentImageData) > 0) {
                    $visitorData = $this->visitorModel->deleteRecordDocumentImage($visitorId,array('visitor'),$userId,$societyId);
                }
                $this->visitorModel->deleteRecordWorkingDay($visitorId, $userId, $societyId);
            }

            // Json Decode for Visitor Name and Mobile No
            $ownershipFlatMemberUpdateArray = array();
            if (is_array($visitorNameMobileNoArray)) {
                foreach ($visitorNameMobileNoArray as $visitor) {
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'visitor_name' => $visitor['visitor_name'],
                        'visitor_mobile_no' => $visitor['visitor_mobile_no'],
                        'visitor_purpose' => $visitorPurpose,
                        'vehicle_type' => $vehicleType,
                        'vehicle_no' => $vehicleNo,
                        'society_id' => $societyId,
                        'type' => $type,
                        'ownership_flat_id' => $ownershipFlatId,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'ownership_flat_parking_id' => $ownershipFlatParkingId,
                        'visitor_company_id' => $visitorCompanyId,
                        // 'company_name'=> $companyName,
                        'no_of_parcel' => $noOfParcel,
                        'collect_on_gate' => $collectOnGate,
                        'resource_in_time' => $resourceInTime,
                        'resource_out_time' => $resourceOutTime,
                        'address' => $address,
                        'no_of_visitor' => $noOfVisitor,
                        'anytime_during_the_day' => $anyTimeDuringTheDay,
                        'parking_slot_id' => $parkingSlotId,
                        'visitor_duration' => $visitorDuration
                    );
                    if ($visitorId == '' && $appType == MEMBER_APP && $type == 'visitor') {
                        $visitorArray['no_of_visitor'] = $noOfVisitor;
                    }

                    if ($visitorId == '') {
                        $visitorArray['status'] = (isset($status) && (!empty($status))) ? $status : 'approval_pending';
                        $visitorArray['qr_code_number'] = GenRandomNumber(6);
                        $combineQRCodeType = $visitorArray['qr_code_number'];

                        $codeContents = $combineQRCodeType;
                        qrcode('text', $codeContents, 4, '', $combineQRCodeType);
                        $visitorArray['qr_code_image'] = $combineQRCodeType . '.png';
                    }
                    if (isset($expectedStartDateTime)) {
                        $visitorArray['expected_start_date_time'] = DMYToYMD($expectedStartDateTime, true, true);
                    }
                    if (isset($expectedEndDateTime)) {
                        $visitorArray['expected_end_date_time'] = DMYToYMD($expectedEndDateTime, true, true);
                    }
                    if ($visitorId != '' && $type == 'delivery_boy') {
                        $visitorArray['status'] = $status;
                    }
                    if ($status == 'collected') {
                        $visitorArray['delivery_date'] = date("Y-m-d H:i:s");

                        if (!empty($visitorId)) {
                            $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                                'visitor_id' => $visitorId,
                                'is_deleted' => 0,
                            ));
                            $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $visitorId,
                                "document_type" => 'visitorId',
                            ));
                            $visitorImagePath = SITE_URL('uploads/no_image.png');
                            if (!empty($visitorImageData)) {
                                if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                                    $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                                }
                            }

                            $notificationArray = array(
                                'ownership_flat_member_id' => $ownershipFlatMemberId,
                                'ownership_flat_id' => $ownershipFlatId,
                                'status' => $status,
                                'type' => $type,
                                'society_id' => $societyId,
                                'user_id' => $userId,
                                'type_id' => $visitorUpdateData['visitor_id'],
                                'visitor_name' => $visitorUpdateData['visitor_name'],
                                'mobile_no' => $visitorUpdateData['visitor_mobile_no'],
                                'display_status' => underscoreToUcWord($status),
                                'image' => $visitorImagePath,
                                'collect_on_gate' => $collectOnGate,
                                'visitor_company_name' => $visitorUpdateData['visitor_company_name'],
                                'vehicle_no' => $visitorUpdateData['vehicle_no'],
                                'no_of_parcel' => $noOfParcel,
                                'guard' => $visitorUpdateData['updated_by_name'],
                                'module' => 'visitor',
                                'app_type' => $appType,
                                'member_name' => $visitorUpdateData['name'],
                            );

                            $extraDatajson = json_encode($notificationArray);
                            if ($appType == GATE_KEEPER) {
                                $notificationArray['send_for_notification'] = $appType;
                                $notificationArray['send_for_notification_id'] = $userId;
                                $notificationArray['receive_for_notification'] = $resourceTypeId;
                                $notificationArray['receive_for_notification_id'] = $ownershipFlatMemberId;
                            }

                            if ($appType == MEMBER_APP) {
                                $notificationArray['send_for_notification'] = $appType;
                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                $notificationArray['receive_for_notification'] = $resourceTypeId;
                                $notificationArray['receive_for_notification_id'] = 0;
                            }
                            sendNotificationDataList($notificationArray, $extraDatajson);
                        }
                    }
                    // Delivery Boy If Collect On Gate generate OTP and store in Ownership Flat Member Table
                    if (!empty($collectOnGate) && !empty($ownershipFlatMemberId)) {
                        $ownershipFlatMemberUpdateData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'is_active' => 1
                        ));
                        $otp = DELIVERY_OTP_CODE;
                        if (DEV_ENVIRONMENT == 'production') {
                            if (isset($ownershipFlatMemberUpdateData['mobile_no']) && $ownershipFlatMemberUpdateData['mobile_no'] == '8976677224') {
                                $otp = DELIVERY_OTP_CODE;
                            } else {
                                $otp = GenRandomNumber(6);
                            }
                        }
                        $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                        $visitorArray['otp'] = $otp;
                        $visitorArray['otp_validity'] = $otpValidity;
                    }

                    if (!empty($visitorId)) {
                        $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                            'visitor_id' => $visitorId,
                            'is_deleted' => 0,
                        ));
                        if (isset($idProofRecord)) {
                            if ($visitorUpdateData['id_proof'] != '' && file_exists(ID_PROOF_PATH . $visitorUpdateData['id_proof'])) {
                                unlink(ID_PROOF_PATH . $visitorUpdateData['id_proof']);
                            }
                            $visitorArray['id_proof'] = $idProofRecord;
                        }
                        $visitorUpdateArray = compareArray($visitorArray, $visitorUpdateData);
                    } else {
                        if (isset($idProofRecord)) {
                            $visitorArray['id_proof'] = $idProofRecord;
                        }
                    }
                    $extraData = array();
                    $extraObj['api_user_id'] = $userId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);
                    $lastVisitorId = $visitorData['lastInsertedId'];
                    array_push($lastVisitorIdArray,$lastVisitorId);
                    //Notification

                    if ($visitorId == '') {
                        $visitorMemberNameData = $this->visitorModel->getVisitorData(array(
                            'visitor_id' => $visitorId,
                        ));
                        if (isset($documentImageData) && count($documentImageData) > 0) {
                            $batchArray = array();
                            unset($documentImageData['success']);
                            foreach ($documentImageData as $key => $imageData) {
                                $documentImage = isset($imageData['file_name']) ? $imageData['file_name'] : "";
                            }
                        } else {
                            $documentImage = '';
                        }

                        if ($documentImage == '') {
                            $visitorImageData = SITE_URL('uploads/no_image.png');
                        } else {
                            $visitorImageData = SITE_URL() . DOCUMENT_IMAGE_PATH . $documentImage;
                        }
                        $visitorStatus = (isset($status) && (!empty($status))) ? $status : 'approval_pending';
                        $notificationArray = array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'ownership_flat_id' => $ownershipFlatId,
                            'status' => (isset($status) && (!empty($status))) ? $status : 'approval_pending',
                            'type' => $type,
                            'society_id' => $societyId,
                            'user_id' => $userId,
                            'type_id' => $lastVisitorId,
                            'visitor_name' => $visitor['visitor_name'],
                            'collect_on_gate' => $collectOnGate,
                            'vehicle_no' => $vehicleNo,
                            'module' => 'visitor',
                            'app_type' => $appType,
                            'mobile_no' => $visitor['visitor_mobile_no'],
                            'display_status' => underscoreToUcWord($visitorStatus),
                            'image' => $visitorImageData,
                            'member_name' => $visitorMemberNameData['name'],
                            'visitor_company_name' => $visitorCompanyName,
                            'resource_type_id' => $resourceTypeId,
                        );
                        if ($appType == GATE_KEEPER) {
                            $notificationArray['send_for_notification'] = $appType;
                            $notificationArray['send_for_notification_id'] = $userId;
                            $notificationArray['receive_for_notification'] = $resourceTypeId;
                            $notificationArray['receive_for_notification_id'] = $ownershipFlatMemberId;
                        }

                        if ($appType == MEMBER_APP) {
                            $notificationArray['send_for_notification'] = $appType;
                            $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                            $notificationArray['receive_for_notification'] = $resourceTypeId;
                            $notificationArray['receive_for_notification_id'] = 0;
                        }

                        $extraDatajson = json_encode($notificationArray);
//                          printArray($notificationArray,1);
                        sendNotificationDataList($notificationArray, $extraDatajson);
                    }

                    // Working Day Store
                    if (is_array($workingDayNameArray)) {
                        foreach ($workingDayNameArray as $workingDay) {
                            $workingDayArray = array(
                                'visitor_working_day_id' => '',
                                'working_day_id' => $workingDay['working_day_id'],
                                'working_day_name' => $workingDay['working_day_name'],
                                'visitor_id' => $lastVisitorId,
                            );
                            $workingDayData = array();
                            $workingDayUpdateArray = array();
                            $workingDayObj['api_user_id'] = $userId;
                            $workingDayObj['society_id'] = $societyId;
                            $workingDayData['is_api_data'] = $workingDayObj;
                            $visitorWorkingDayData = $this->commonWebserviceModel->insertUpdateRecord($workingDayArray, 'visitor_working_day_id', 'tbl_visitor_working_day', 1, '', array(), $workingDayData, $workingDayUpdateArray);
                            $lastvisitorWorkingDayDataId = $visitorWorkingDayData['lastInsertedId'];
                        }
                    }
                    // Visitor Multiple Image Store
                    if ($lastVisitorId != '') {
                        if (isset($documentImageData) && count($documentImageData) > 0) {
                            $batchArray = array();
                            unset($documentImageData['success']);
                            foreach ($documentImageData as $key => $imageData) {
                                $dataArray = array(
                                    'document_image_id' => '',
                                    'document_type' => 'visitor',
                                    'document_type_id' => $lastVisitorId,
                                    'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                                    'created_by' => $userId,
                                    'updated_by' => $userId,
                                    'created_at' => date("Y-m-d H:i:s"),
                                    'updated_at' => date("Y-m-d H:i:s"),
                                );
                                array_push($batchArray, $dataArray);
                            }
                            $visitorExtraDataArray = array();
                            $visitorExtraDataArray['module_id'] = $lastVisitorId;
                            $visitorExtraDataArray['module'] = 'Visitor Image';
                            $visitorExtraDataArray['type'] = 'Visitor';
                            $visitorExtraDataArray['old_data'] = '';
                            $visitorExtraDataArray['user_id'] = $userId;
                            $visitorExtraDataArray['society_id'] = $societyId;
                            $this->visitorModel->batchInsert($batchArray, 'tbl_document_image', $visitorExtraDataArray);
                        }
                    }
                }
            }
        }

        $filterArray = array(
            'visitor_id' => $lastVisitorIdArray,
            'is_multiple' => 1,
            'is_deleted' => 0,
        );
        $visitorListData = visitorListData($filterArray, $userId);

        if (isset($visitorId) && !empty($visitorId)) {
            if (isset($visitorData['success']) && $visitorData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.visitor')),
                    'data' => $visitorListData
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.visitor')),
                    'data' => $visitorListData
                ), 404);
            }
        } else {
            if (isset($visitorData['success']) && $visitorData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.visitor')),
                    'data' => $visitorListData
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.visitor')),
                    'data' => $visitorListData
                ), 400);
            }
        }
//        }
    }

    public function sendNotification()
    {
        $this->db->transBegin();
        
        $userId = $this->request->getVar('user_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $appType = $this->request->getVar('app_type');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            if($appType == MEMBER_APP){
                $userDevice = $this->commonWebserviceModel->deviceData(array(
                    "user_type_id" => $ownershipFlatMemberId,
                    "user_type" => $appType,
                    "is_latest" => 1,
                ));
            }
            else{
                $userDevice = $this->commonWebserviceModel->deviceData(array(
                    "user_id" => $userId,
                    "user_type" => $appType,
                    "is_latest" => 1,
                ));
            }
            $notificationResponse = array();
            if (!empty($userDevice)) {
                if ($userDevice['one_signal_id'] != '' && $userDevice['player_id'] != '') {
                    $notificationArray = array(
                        'ownership_flat_id' => 0,
                        'ownership_flat_member_id' => isset($userDevice['user_type_id']) ? $userDevice['user_type_id'] : 0,
                        'type' => 'test_notification',
                        'status' => 'test_notification',
                        'society_id' => $societyId,
                        'user_id' => $userId,
                        'notification_title' =>  ' Test Notification',
                        'description' => 'Test Notification',
                        'module' => 'test_notification',
                        'device_type' => isset($userDevice['device_type']) ? strtolower($userDevice['device_type']) : '',
                        'notification_for' => isset($userDevice['device_type']) ? strtolower($userDevice['device_type']) : '',
                        'one_signal_id' => isset($userDevice['one_signal_id']) ? $userDevice['one_signal_id'] : '',
                        'player_id' => isset($userDevice['player_id']) ? $userDevice['player_id'] : '',
                        'receive_for_notification' => isset($userDevice['resource_type_id']) ? $userDevice['resource_type_id'] : '',
                        'app_type' => $appType,
                    );
                    $notificationOtherArray = array(
                        'notification_id' => '',
                        'ownership_flat_member_id' => $notificationArray['ownership_flat_member_id'],
                        'society_id' => $societyId,
                        'notification_title' =>  $notificationArray['notification_title'],
                        'description' => $notificationArray['description'],
                        'type' => 'test_notification',
                        'notification_for' => isset($userDevice['device_type']) ? strtolower($userDevice['device_type']) : '',
                        'notification_date' => TODAY_DATE_YMD,
                    );
                    if ($appType == GATE_KEEPER) {
                        $notificationOtherArray['send_for_notification'] = $appType;
                        $notificationOtherArray['send_for_notification_id'] = $userId;
                        // $notificationOtherArray['receive_for_notification'] = GATE_KEEPER;
                        $notificationOtherArray['receive_for_notification_id'] = $userId;
                    }
                    if ($appType == MEMBER_APP) {
                        $notificationOtherArray['send_for_notification'] = $appType;
                        $notificationOtherArray['send_for_notification_id'] = $ownershipFlatMemberId;
                        // $notificationOtherArray['receive_for_notification'] = MEMBER_APP;
                        $notificationOtherArray['receive_for_notification_id'] = $ownershipFlatMemberId;
                    }
                    $notificationOtherArray['extra_data'] = json_encode($notificationArray);
                    $customerData['extra_data'] = json_encode($notificationArray);
                    $customerData['description'] = 'Test Notification';
                    $customerData['title_name'] = 'Test Notification';
                    $customerData['player_id'] = array($userDevice['player_id']);
                    $customerData['one_signal_id'] = $userDevice['one_signal_id'];
                    $customerData['device_token'] = $userDevice['device_token'];
                    $extraData = array();
                    $extraObj['api_user_id'] = $userId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $notificationResponse = $this->notificationModel->insertUpdateRecord($notificationOtherArray, 'notification_id', 'tbl_notification', 1, '', array(), $extraData);
                     //send notification data
                    if(strtolower($userDevice['device_type']) == 'android'){
                        $sendNotificationData = $customerData;
                        sendNotificationAndroid($sendNotificationData);
                    }
                    else{
                        $sendNotificationData = $customerData;
                        sendNotificationIOS($sendNotificationData);
                    }
                }   
            }

            if (isset($notificationResponse['success']) && $notificationResponse['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.notification_send_successfully'),
                    'data' => null
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.notification_send_unsuccessfully'),
                    'data' => null
                ), 404);
            }
        }


//        $data = [
//            'title_name' => 'Your Notification Title',
//            'notification_type' => 'product', // or 'general'
//            'player_id' => '8ccc8512-f0cb-4693-ab2b-f8274c25cc1d',
//            'image' => 'https://digitattva.in/society/uploads/document/1725020688_dca4775adf301ae64c7f.jpg',
//            'is_button' => true
//        ];
//
//        $notificationFor = 'android'; // or 'ios'
//
//        $response = sendNotification($data, $notificationFor);
//
//        echo $response;

    }


    public function visitorStatusChange()
    {

        $this->db->transBegin();
        $visitorId = $this->request->getVar('visitor_id');
        $societyId = $this->request->getVar('society_id');
        $status = $this->request->getVar('status');
        $userId = $this->request->getVar('user_id');
        $isSelfApproved = $this->request->getVar('is_self_approved');
        $appType = $this->request->getVar('app_type');
        $isNotificationStatus = $this->request->getVar('is_notification_status');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('status', lang('CommonWebService.status'), 'required');
        $this->validation->setRule('visitor_id', lang('CommonWebService.visitor_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if ($appType == MEMBER_APP) {
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $visitorUpdateArray = array();
            $visitorStatusUpdateArray = array();
            $isInsertUpdate = 1;

            if (!empty($isSelfApproved)) {
                $visitorSelfApprovedData = $this->visitorModel->getVisitorData(array(
                    'order_by' => array(array("tv.self_approved_at" => "desc")),
                ));

                if (isValidDate($visitorSelfApprovedData['self_approved_at'])) {
                    $scanValidityTime = strtotime($visitorSelfApprovedData['self_approved_at'], strtotime("-30 seconds"));
                    $currentTime = strtotime(date("Y-m-d H:i:s", strtotime("-30 seconds")));

                    if ($currentTime < $scanValidityTime) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.wait_second_for_approval'),
                            'data' => null
                        ), 400);
                    }
                }
            }
            $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                'visitor_id' => $visitorId,
            ));

            $userData = $this->commonWebserviceModel->getUserData(array(
                'id' => $userId,
            ));
            $resourceTypeId = $userData['resource_type_id'];

            if (!empty($visitorUpdateData)) {

                if ($visitorUpdateData['status'] == $status) {
                    $isInsertUpdate = 0;
                }
                if ($isInsertUpdate == 1) {

                    if ($status == 'entered' && $visitorUpdateData['type'] != 'resource' && $visitorUpdateData['visitor_duration'] != 'frequent') {
                        if ($visitorUpdateData['anytime_during_the_day'] == 0) {
                            $currentDateTime = date('Y-m-d H:i:s');
                            $startTime = $visitorUpdateData['expected_start_date_time'];
                            $endTime = $visitorUpdateData['expected_end_date_time'];
                            $currentDateTimeStamp = strtotime($currentDateTime);
                            $startTimeStamp = strtotime($startTime);
                            $endTimeStamp = strtotime($endTime);
                            if ($currentDateTimeStamp < $startTimeStamp || $currentDateTimeStamp > $endTimeStamp) {
                                return $this->response(array(
                                    'status' => false,
                                    'response_code' => 404,
                                    'message' => lang('CommonWebService.you_can_enter_between') . date('d M, Y h:i A', $startTimeStamp) . ' - ' . date('d M, Y h:i A', $endTimeStamp),
                                    'data' => null
                                ), 404);
                            }
                        }
                    }
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'status' => $status,
                    );
                    if (!empty($isSelfApproved)) {
                        $visitorArray['self_approved_at'] = date("Y-m-d H:i:s");
                        $visitorArray['self_approved_by'] = $userId;
                    }
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $visitorId,
                        "document_type" => 'visitorId',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }
                    $notificationArray = array(
                        'ownership_flat_member_id' => $visitorUpdateData['ownership_flat_member_id'],
                        'ownership_flat_id' => $visitorUpdateData['ownership_flat_id'],
                        'status' => $status,
                        'type' => $visitorUpdateData['type'],
                        'society_id' => $societyId,
                        'user_id' => $userId,
                        'type_id' => $visitorId,
                        'visitor_name' => $visitorUpdateData['visitor_name'],
                        'visitor_company_name' => $visitorUpdateData['visitor_company_name'],
                        'collect_on_gate' => $visitorUpdateData['collect_on_gate'],
                        'guard' => $visitorUpdateData['updated_by_name'],
                        'vehicle_no' => $visitorUpdateData['vehicle_no'],
                        'module' => 'visitor',
                        'app_type' => $appType,
                        'mobile_no' => $visitorUpdateData['visitor_mobile_no'],
                        'display_status' => underscoreToUcWord($status),
                        'image' => $visitorImagePath,
                        'member_name' => $visitorUpdateData['name'],
                    );
                    if ($appType == GATE_KEEPER) {
                        $notificationArray['send_for_notification'] = $appType;
                        $notificationArray['send_for_notification_id'] = $userId;
                        $notificationArray['receive_for_notification'] = $resourceTypeId;
                        $notificationArray['receive_for_notification_id'] = $visitorUpdateData['ownership_flat_member_id'];
                    }

                    if ($appType == MEMBER_APP) {
                        $notificationArray['send_for_notification'] = $appType;
                        $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                        $notificationArray['receive_for_notification'] = $resourceTypeId;
                        $notificationArray['receive_for_notification_id'] = 0;
                    }
                    $extraDatajson = json_encode($notificationArray);
                    sendNotificationDataList($notificationArray, $extraDatajson);


                    if ($status == 'entered') {
                        $visitorArray['start_date'] = date("Y-m-d H:i:s");
                    }
                    if (!empty($isNotificationStatus)) {
                        $visitorArray['expected_start_date_time'] = date("Y-m-d H:i:s");
                        $visitorArray['expected_end_date_time'] = date("Y-m-d H:i:s", strtotime('+2 hours'));
                        $visitorArray['is_visitor_approved'] = 1;
                        $visitorArray['is_visitor_approved_at'] = date("Y-m-d H:i:s");
                        $visitorArray['is_visitor_approved_by'] = $userId;
                    }
                    if ($status == 'exited') {
                        $visitorArray['end_date'] = date("Y-m-d H:i:s");

                    }
                    if ($status == 'collected') {
                        $visitorArray['delivery_date'] = date("Y-m-d H:i:s");
                    }
                    $visitorUpdateArray = compareArray($visitorArray, $visitorUpdateData);
                    $extraData = array();
                    $extraObj['api_user_id'] = $userId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);
                    $lastVisitorId = $visitorData['lastInsertedId'];
                    $visitorStatusArray = array(
                        'visitor_status_history_id' => '',
                        'visitor_id' => $visitorUpdateData['visitor_id'],
                        'status' => $visitorUpdateData['status'],
                    );
                    $visitorStatusData = $this->commonWebserviceModel->insertUpdateRecord($visitorStatusArray, 'visitor_status_history_id', 'tbl_visitor_status_history', 1, '', array(), $extraData, $visitorStatusUpdateArray);
                }

                $filterArray = array(
                    'visitor_id' => $visitorId,
                    'is_multiple' => 1,
                    'is_deleted' => 0,
                );
                $visitorListData = visitorListData($filterArray, $userId);


            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.status_change_unsuccessfully'),
                    'data' => null
                ), 404);
            }

            if ($isInsertUpdate == 0) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.this_visitor_is_already') . underscoreToUcWord($status),
                    'data' => $visitorListData
                ), 200);
            }

            if (isset($visitorData['success']) && $visitorData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.status_change_successfully'),
                    'data' => $visitorListData
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.status_change_unsuccessfully'),
                    'data' => $visitorListData
                ), 404);
            }
        }
    }


    public function getEditResourceList()
    {
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $resourceTypeId = $this->request->getVar('resource_type_id');
        $userId = $this->request->getVar('user_id');

        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {

            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'is_helper' => 1,
                'resource_type_id' => $resourceTypeId,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'user_id' => $userId,
                'is_deleted' => 0,
            );
            $resourceData = $this->resourceModel->getResourceFlatData($filterArray);
            $objectFilterData = array(
                'flat_id' => array('flat_id', 'tower_flat_name'),
                'ownership_flat_member_id' => array('ownership_flat_member_id', 'name'),
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
            );
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceFlatIdArray = array();
            $resourceIdArray = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceFlatIdArray[] = $resourceElement['resource_flat_id'];
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }

                if (!empty($resourceFlatIdArray)) {
                    $resourceWorkingDayData = $this->resourceModel->getResourceWorkingDayData(array(
                        "resource_flat_id" => $resourceFlatIdArray,
                        "resource_id" => $resourceIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceWorkingDayData)) {
                        foreach ($resourceWorkingDayData as $resourceWorkingElement) {
                            $resourceWorkingDayDataWise[$resourceWorkingElement['resource_id']][] = $resourceWorkingElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }

                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);

                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $resourceData[$vKey]['resource_working_day_data'] = array_key_exists($resource['resource_id'], $resourceWorkingDayDataWise) ? $resourceWorkingDayDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditResource()
    {
        // printArray($_POST,1);
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $resourceId = $this->request->getVar('resource_id');
        $resourceFlatId = $this->request->getVar('resource_flat_id');
        $resourceName = $this->request->getVar('resource_name');
        $resourceMobileNo = $this->request->getVar('resource_mobile_no');
        $status = $this->request->getVar('status');
        $resourceInTime = $this->request->getVar('resource_in_time');
        $resourceOutTime = $this->request->getVar('resource_out_time');
        // $address = $this->request->getVar('address');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        // $categoryId = $this->request->getVar('category_id');
        $resourceWeekDay = $this->request->getVar('resource_week_day');
        $towerId = $this->request->getVar('tower_id');
        $flatId = $this->request->getVar('flat_id');
        $type = $this->request->getVar('type');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $userId = $this->request->getVar('user_id');
        $documentImage = $this->request->getVar('document_image[]');
        $idProof = $this->request->getVar('id_proof');
        $isStatusUpdate = $this->request->getVar('is_status_update');
        $isNotificationSend = $this->request->getVar('is_notification_send');
        $appType = $this->request->getVar('app_type');
        $fatherName = $this->request->getVar('father_name');
        $dateOfBirth = $this->request->getVar('date_of_birth');
        $gender = $this->request->getVar('gender');
        $work = $this->request->getVar('work');
        $presentAddress = $this->request->getVar('present_address');
        $permanentAddress = $this->request->getVar('permanent_address');
        $reference = $this->request->getVar('reference');
        $isOutsourced = $this->request->getVar('is_outsourced');
        $vendorId = $this->request->getVar('vendor_id');
        $resourceTypeId = $this->request->getVar('resource_type_id');

        // $resourceInTime = $this->request->getVar('resource_in_time');
        // $resourceOutTime = $this->request->getVar('resource_out_time');
        $this->validation->setRule('resource_type_id', lang('CommonWebService.resource_type'), 'required');
        $this->validation->setRule('resource_name', lang('CommonWebService.resource_name'), 'required');
        $this->validation->setRule('resource_in_time', lang('CommonWebService.resource_in_time'), 'required');
        $this->validation->setRule('resource_out_time', lang('CommonWebService.resource_out_time'), 'required');
        $this->validation->setRule('resource_week_day', lang('CommonWebService.resource_week_day'), 'required');
        $this->validation->setRule('resource_mobile_no', lang('CommonWebService.resource_mobile_no'), 'required|max_length[10]|min_length[10]');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {

            // Json Decode for resource Name and Mobile No
            $resourceWeekDayArray = json_decode($resourceWeekDay, true);
            if (empty($resourceWeekDayArray)) {
                return $this->response(array(
                    'status' => FALSE,
                    'message' => "Weekdays Are Required",
                    'data' => null,
                    'response_code' => 400,
                ), 400);
            }


            if($appType != MANAGER_APP){
                $towerId = 0;
                $flatId = 0;
                $ownershipFlatId = 0;
                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_active' => 1,
                    'is_show_all_member' => 1
                ));

                if (!empty($ownershipFlatData)) {
                    $flatId = isset($ownershipFlatData['flat_id']) ? $ownershipFlatData['flat_id'] : 0;
                    $ownershipFlatId = isset($ownershipFlatData['ownership_flat_id']) ? $ownershipFlatData['ownership_flat_id'] : 0;
                    $type = isset($ownershipFlatData['type']) ? $ownershipFlatData['type'] : 0;
                    $towerId = isset($ownershipFlatData['tower_id']) ? $ownershipFlatData['tower_id'] : 0;
                }
            }
            else{
                $ownershipFlatArray = array(
                    'tower_id' => $towerId,
                    'flat_id' => $flatId,
                    'ownership_flat_id' => $ownershipFlatId,
                    'type' => $type,
                    'is_active' => 1,
                    'is_show_all_member' => 1
                );
                if($type == 'ownership_flat'){
                    $ownershipFlatArray['is_owner'] = 1;
                }
                else{
                    $ownershipFlatArray['agreement_with'] = 1;
                }
                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData($ownershipFlatArray);
                if (!empty($ownershipFlatData)) {
                    $ownershipFlatMemberId = isset($ownershipFlatData['ownership_flat_member_id']) ? $ownershipFlatData['ownership_flat_member_id'] : 0;
                }

                // $resourceFlatDataArray  = $this->resourceModel->getResourceFlatData(array(
                //     'category_id' => $categoryId,
                //     'resource_name' => $resourceName,
                //     'resource_mobile_no' => $resourceMobileNo,
                //     'resource_id' => $resourceId,
                //     'ownership_flat_member_id' =>  $ownershipFlatMemberId,
                // ));

                // if(!empty($resourceFlatDataArray)){
                //     return $this->response(array(
                //         'status' => false,
                //         'response_code' => 404,
                //         'message' => $resourceFlatDataArray['category_name'] .' '. lang('CommonWebService.already_added_to_your_flat'),
                //         'data' => null
                //     ), 404);
                // }
            }

            $resourceFlatDataArray  = $this->resourceModel->getResourceFlatData(array(
                'resource_type_id' => $resourceTypeId,
                'resource_name' => $resourceName,
                'resource_mobile_no' => $resourceMobileNo,
                'resource_id' => $resourceId,
                // 'ownership_flat_member_id' =>  $ownershipFlatMemberId,
                'ownership_flat_id' =>  $ownershipFlatId,
                'is_helper' => 1,
                'is_deleted' => 0
            ));

            if(!empty($resourceFlatDataArray)){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => ($resourceFlatDataArray['resource_type_name']) .' '. lang('CommonWebService.already_added_to_this_flat'),
                    'data' => null
                ), 404);
            }

            // printArray($ownershipFlatMemberId,1);
            
            if (isset($resourceId) && $resourceId != '') {
                if (isset($resourceFlatId) && $resourceFlatId != '') {
                    $this->resourceModel->deleteRecordResourceFlat($resourceFlatId, $resourceId, $userId, $societyId);
                    $this->resourceModel->deleteRecordWorkingDay($resourceFlatId, $resourceId, $userId, $societyId);
                }
            }
            $documentImageData = array();
            if (isset($_FILES["document_image"])) {
                $documentImagePath = DOCUMENT_IMAGE_PATH;
                $documentImageData = $dt_ci_file_upload->UploadMultipleFile('document_image', MAX_IMAGE_SIZE_LIMIT, $documentImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($documentImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($documentImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($documentImageData['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($documentImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }
            // Json Decode for resource Name and Mobile No
            // $resourceWeekDayArray = json_decode($resourceWeekDay, true);
            $resourceUpdateArray = array();
            $resourceArray = array(
                'resource_id' => $resourceId,
                'resource_name' => $resourceName,
                'resource_mobile_no' => $resourceMobileNo,
                'society_id' => $societyId,
                // 'category_id' => $categoryId,
                // 'address' => $address,
                // 'category_id' => $categoryId,
                'father_name' => $fatherName,
                'date_of_birth' => DMYToYMD($dateOfBirth),
                'gender' => $gender,
                'work' => $work,
                'present_address' => $presentAddress,
                'permanent_address' => $permanentAddress,
                'reference' => $reference,
                'resource_type_id' => $resourceTypeId,
                'is_outsourced' => isset($isOutsourced) ? 1 : 0,
            );
            if(isset($isOutsourced)){
                $resourceArray['vendor_id'] = $vendorId;
            } else {
                $resourceArray['vendor_id'] = 0;
            }
            if ($resourceId == '') {
                $resourceArray['status'] = 'approved';
                $resourceArray['qr_code_number'] = GenRandomNumber(6);
                //$combineQRCodeType  =$resourceArray['qr_code_number'] . '_' .'resource';
                $combineQRCodeType = $resourceArray['qr_code_number'];
//              $codeContents  = "BEGIN:VCARD\n";
//              $codeContents .= "VERSION:2.1\n";
//              // $codeContents .= 'N:' . $visitorId . "\n";
//              $codeContents .= "FN:$combineQRCodeType \n";
//              $codeContents .= "END:VCARD";
                $codeContents = $combineQRCodeType;
                qrcode('text', $codeContents, 4, '', $combineQRCodeType);
                $resourceArray['qr_code_image'] = $combineQRCodeType . '.png';
                // $visitorUpdateArray = compareArray($visitorArray,$visitorUpdateData);
            }
            if (!empty($resourceId)) {
                $resourceUpdateData = $this->resourceModel->getResourceData(array(
                    'resource_id' => $resourceId,
                ));
                $resourceUpdateArray = compareArray($resourceArray, $resourceUpdateData);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $resourceData = $this->commonWebserviceModel->insertUpdateRecord($resourceArray, 'resource_id', 'tbl_resource', 1, '', array(), $extraData, $resourceUpdateArray);
            $lastResourceId = $resourceData['lastInsertedId'];
            $resourceFlatArray = array(
                'resource_flat_id' => '',
                'resource_id' => $lastResourceId,
                'tower_id' => $towerId,
                'flat_id' => $flatId,
                'ownership_flat_id' => $ownershipFlatId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'resource_in_time' => $resourceInTime,
                'resource_out_time' => $resourceOutTime,
            );
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $resourceFlatData = $this->commonWebserviceModel->insertUpdateRecord($resourceFlatArray, 'resource_flat_id', 'tbl_resource_flat', 1, '', array(), $extraData);
            $lastResourceFlatId = $resourceFlatData['lastInsertedId'];
            // Working Day Store
            if (is_array($resourceWeekDayArray)) {
                foreach ($resourceWeekDayArray as $workingDay) {
                    $workingDayArray = array(
                        'resource_working_day_id' => '',
                        'resource_id' => $lastResourceId,
                        'resource_flat_id' => $lastResourceFlatId,
                        'working_day_id' => $workingDay['working_day_id'],
                        'working_day_name' => $workingDay['working_day_name'],
                        'resource_in_time' => $resourceInTime,
                        'resource_out_time' => $resourceOutTime,
                    );
                    $workingDayData = array();
                    $workingDayUpdateArray = array();
                    $workingDayObj['api_user_id'] = $userId;
                    $workingDayObj['society_id'] = $societyId;
                    $workingDayData['is_api_data'] = $workingDayObj;
                    $resourceWorkingDayData = $this->commonWebserviceModel->insertUpdateRecord($workingDayArray, 'resource_working_day_id', 'tbl_resource_working_day', 1, '', array(), $workingDayData, $workingDayUpdateArray);
                    $lastResourceWorkingDayDataId = $resourceWorkingDayData['lastInsertedId'];
                }
            }

            // resource Multiple Image Store
            if ($lastResourceId != '') {
                if (isset($documentImageData) && count($documentImageData) > 0) {
                    $batchArray = array();
                    unset($documentImageData['success']);
                    foreach ($documentImageData as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' => '',
                            'document_type' => 'resource',
                            'document_type_id' => $lastResourceId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $resourceExtraDataArray = array();
                    $resourceExtraDataArray['module_id'] = $lastResourceId;
                    $resourceExtraDataArray['module'] = 'Resource Image';
                    $resourceExtraDataArray['type'] = 'Resource';
                    $resourceExtraDataArray['old_data'] = '';
                    $resourceExtraDataArray['user_id'] = $userId;
                    $resourceExtraDataArray['society_id'] = $societyId;
                    $this->resourceModel->batchInsert($batchArray, 'tbl_document_image', $resourceExtraDataArray);
                }
            }


            if($isNotificationSend == 1){
                if (!empty($ownershipFlatData)) {
                    $ownershipFlatMemberIdArray = array();
                    $notificationDataArray = array();
                    $userDeviceUserIdArray = array();
                    $userDeviceUserTypeIdArray = array();
                    $userDeviceUserTypeArray = array();
                    
                    if($appType != MANAGER_APP){
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_id' => $ownershipFlatId,
                            'type' => $type,
                            'is_multiple' => 1,
                            'member_id_not' => $ownershipFlatMemberId
                        ));
                    } else {
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_id' => $ownershipFlatId,
                            'type' => $type,
                            'is_multiple' => 1,
                        ));
                    }
                    $resourceSendData = $this->resourceModel->getResourceData(array(
                        'resource_id' => $resourceId,
                        'is_helper' => 1,
                    ));
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceId,
                        "document_type" => 'resource',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }
                    if(!empty($ownershipFlatMemberData)){
                        foreach($ownershipFlatMemberData as $ownershipFlatMember){
                            $ownershipFlatMemberIdArray[] = $ownershipFlatMember['ownership_flat_member_id'];
                        }
                    }
                    $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Member',
                        'society_id' => $this->session->get('society_id'),
                    ));
                    if (!empty($ownershipFlatMemberIdArray)) {
                        $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeData['resource_type_id'],
                            'type_id' => $ownershipFlatMemberIdArray,
                            'is_multiple' => 1
                        ));

                        if (!empty($userSocietyFamilyData)) {
                            foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                $userDeviceUserIdArray[] = isset($userSocietyFamilyElement['user_id']) ? $userSocietyFamilyElement['user_id'] : 0;
                                $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                $userDeviceUserTypeArray[] = $resourceTypeData['resource_type_id'];
                            }
                            $userDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_id" => $userDeviceUserIdArray,
                                "user_type_id" => $userDeviceUserTypeIdArray,
                                "resource_type_id" => $userDeviceUserTypeArray,
                                "is_latest" => 1,
                                "is_multiple" => 1,
                            ));

                            $userDeviceIdArray = array();

                            if(!empty($userDevice)){
                                foreach($userDevice as $userDeviceElement){
                                    $userDeviceIdArray[] = $userDeviceElement['device_id'];
                                }
                            }

                            $notificationType = $this->commonWebserviceModel->getNotificationTypeData(array(
                                'notification_type' => ucwords('resources'),
                            ));

                            $notificationTypeDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
                                'notification_type_id' => $notificationType['notification_type_id'],
                                'device_id' => $userDeviceIdArray,
                                'ownership_flat_member_id' => $userDeviceUserTypeIdArray,
                                'is_multiple' => 1,
                            ));

                            if(!empty($userDevice)){
                                foreach ($userDevice as &$device) {
                                    foreach ($notificationTypeDevice as $notification) {
                                        if ($device['device_id'] == $notification['device_id'] && $device['user_type_id'] == $notification['ownership_flat_member_id']) {
                                            $device['is_enabled'] = $notification['is_enabled'];
                                        }
                                    }
                                }
                            }

                            if (!empty($userDevice)) {
                                foreach ($userDevice as $userDeviceElement) {
                                    if ($userDeviceElement['is_enabled'] == 1) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                            $resourceType = $resourceSendData['resource_type_name'];
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'resource',
                                                'status' => 'new_resource',
                                                'notification_date' => TODAY_DATE_YMD,
                                                'type_id' => $resourceId,
                                                'society_id' => $societyId,
                                                'visitor_name' => $resourceSendData['resource_name'],
                                                'user_id' => $userId,
                                                'notification_title' => $resourceType . ' Added To Your Flat : ' . $resourceSendData['resource_name'],
                                                'description' => $resourceSendData['resource_name'] . ', your ' . $resourceType . ', has been added to your flat by the ' . $resourceSendData['updated_by_name'] . '.',
                                                'module' => 'resource',
                                                'category_name' => $resourceType,
                                                'guard' => $resourceSendData['updated_by_name'],
                                                'mobile_no' => $resourceSendData['resource_mobile_no'],
                                                'display_status' => underscoreToUcWord('entered'),
                                                'image' => $visitorImagePath,
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                                'receive_for_notification' => isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '',
                                                'app_type' => $appType,
                                            );

                                            // if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                // $notificationArray['receive_for_notification'] = MEMBER_APP;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            // }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!empty($notificationDataArray)) {
                        sendNotificationResourceAndroid($notificationDataArray);
                    }
                }
            }

            // $categoryData = $this->categoryModel->getCategoryData(array(
            //     'category_for' => 'resource',
            //     'is_multiple' => 1,
            //     'is_active' => 1,
            // ));
            
            $start = 0;
            if(!empty($ownershipFlatMemberId)){
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $ownershipFlatId = $ownershipMemberFlatData['ownership_flat_id'];
            }
            else{
                $ownershipFlatId = 0;
            }
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                // 'search' => $search,
                // 'category_id' => $categoryId,
                // 'category_name' => $categoryName,
                'resource_type_id' => $resourceTypeId,
                'society_id' => $societyId,
                'resource_id' => $lastResourceId,
                'user_id' => $userId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'ownership_flat_id' => $ownershipFlatId,
                'is_deleted' => 0,
                'is_helper' => 1,
            );
            if (!empty($isMyResource)) {
                $resourceIdArray = array();
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1
                ));
                if (!empty($ownershipMemberFlatData)) {
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'ownership_flat_id' => $ownershipMemberFlatData['ownership_flat_id'],
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        'is_multiple' => 1
                    ));
                }
                if (!empty($resourceFlatData)) {
                    foreach ($resourceFlatData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                }
                if (!empty($resourceIdArray)) {
                    $rData = $this->resourceModel->getResourceData(array(
                        'resource_id' => $resourceIdArray,
                        'ownership_flat_id' => $ownershipFlatId,
                        'start' => $start,
                        // 'search' => $search,
                        // 'category_id' => $categoryId,
                        // 'category_name' => $categoryName,
                        'resource_type_id' => $resourceTypeId,
                        'is_multiple' => 1
                    ));
                }
            } else {
                $rData = $this->resourceModel->getResourceData($filterArray);
            }
            $objectFilterData = array(
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceIdArray = array();
            if (!empty($rData)) {
                foreach ($rData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($rData)) {
                foreach ($rData as $vKey => $resource) {
                    $rData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    $rData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    $rData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $rData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $rData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    // $rData[$vKey]['resource_type'] = $formattedResourceType;
                    $rData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $rData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $rData[$vKey]['qr_code_image'] = $path;
                    $resourceImagePath = site_url('uploads/no_image.png');
                    if ($resource['resource_image'] != '' && file_exists(DOCUMENT_IMAGE_PATH . $resource['resource_image'])) {
                        $resourceImagePath = site_url() . DOCUMENT_IMAGE_PATH . $resource['resource_image'];
                    }
                    $rData[$vKey]['resource_image'] = $resourceImagePath;
                    $rData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $rData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $rData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $rData[$vKey]['share_data'] = $shareData;
                }
            }

                    
            if (isset($resourceId) && !empty($resourceId)) {
                if (isset($resourceData['success']) && $resourceData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.resource')),
                        'data' => $rData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.resource')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($resourceData['success']) && $resourceData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.resource')),
                        'data' => $rData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.resource')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function resourceExited()
    {
        $this->db->transBegin();
        $visitorId = $this->request->getVar('visitor_id');
        $status = $this->request->getVar('status');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('visitor_id', lang('CommonWebService.visitor_id'), 'required');
        $this->validation->setRule('status', lang('CommonWebService.status'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $visitorUpdateArray = array();
            $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                'visitor_id' => $visitorId,
            ));
            $isInsertUpdate = 1;
            if (!empty($visitorUpdateData)) {
                if ($visitorUpdateData['status'] == 'exited') {
                    $isInsertUpdate = 0;
                }

                if ($isInsertUpdate == 1) {
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'status' => $status,
                    );
                    if ($status == 'exited') {
                        $visitorArray['end_date'] = date("Y-m-d H:i:s");
                    }
                    $extraData = array();
                    $extraObj['api_user_id'] = $userId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorUpdateArray = compareArray($visitorArray, $visitorUpdateData);

                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);

                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'resource_id' => $visitorUpdateData['resource_id'],
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        'is_multiple' => 1
                    ));
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $visitorUpdateData['resource_id'],
                        "document_type" => 'resource',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }

                    $ownershipFlatMemberIdArray = array();
                    $ownershipFlatIdWiseArray = array();
                    $ownershipTypeWiseArray = array();
                    $notificationDataArray = array();
                    $notificationArray = array();

                    $userDeviceUserIdArray = array();
                    $userDeviceUserTypeIdArray = array();
                    $userDeviceUserTypeArray = array();


                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlat) {
                            $ownershipFlatIdWiseArray[] = $resourceFlat['ownership_flat_id'];
                            $ownershipTypeWiseArray[] = $resourceFlat['type'];
                        }
                    }
                    
                    $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_id' => $ownershipFlatIdWiseArray,
                        'type' => $ownershipTypeWiseArray,
                        'is_multiple' => 1
                    ));
                        

                    if (!empty($ownershipFlatMemberData)) {
                        foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                            $ownershipFlatMemberIdArray[] = $ownershipFlatMember['ownership_flat_member_id'];
                        }
                    }
                    $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Member',
                        'society_id' => $this->session->get('society_id'),
                    ));
                    if (!empty($ownershipFlatMemberIdArray)) {
                        $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeData['resource_type_id'],
                            'type_id' => $ownershipFlatMemberIdArray,
                            // 'is_user_device_token_get' => 1,
                            'is_multiple' => 1
                        ));

                        if (!empty($userSocietyFamilyData)) {
                            foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                $userDeviceUserIdArray[] = isset($userSocietyFamilyElement['user_id']) ? $userSocietyFamilyElement['user_id'] : 0;
                                $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                $userDeviceUserTypeArray[] = $resourceTypeData['resource_type_id'];
                            }
                            $userDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_id" => $userDeviceUserIdArray,
                                "user_type_id" => $userDeviceUserTypeIdArray,
                                "resource_type_id" => $userDeviceUserTypeArray,
                                "is_latest" => 1,
                                "is_multiple" => 1,
                            ));

                            $userDeviceIdArray = array();

                            if(!empty($userDevice)){
                                foreach($userDevice as $userDeviceElement){
                                    $userDeviceIdArray[] = $userDeviceElement['device_id'];
                                }
                            }

                            $notificationType = $this->commonWebserviceModel->getNotificationTypeData(array(
                                'notification_type' => ucwords('resources'),
                            ));

                            $notificationTypeDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
                                'notification_type_id' => $notificationType['notification_type_id'],
                                'device_id' => $userDeviceIdArray,
                                'ownership_flat_member_id' => $userDeviceUserTypeIdArray,
                                'is_multiple' => 1,
                            ));

                            if(!empty($userDevice)){
                                foreach ($userDevice as &$device) {
                                    foreach ($notificationTypeDevice as $notification) {
                                        if ($device['device_id'] == $notification['device_id'] && $device['user_type_id'] == $notification['ownership_flat_member_id']) {
                                            $device['is_enabled'] = $notification['is_enabled'];
                                        }
                                    }
                                }
                            }

                            if (!empty($userDevice)) {
                                foreach ($userDevice as $userDeviceElement) {
                                    if ($userDeviceElement['is_enabled'] == 1) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                            $resourceType = $visitorUpdateData['resource_type_name'];
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'resource',
                                                'status' => 'exited',
                                                'notification_date' => TODAY_DATE_YMD,
                                                'type_id' => $visitorUpdateData['resource_id'],
                                                'society_id' => $societyId,
                                                'visitor_name' => $visitorUpdateData['visitor_name'],
                                                'user_id' => $userId,
                                                'notification_title' => $resourceType . ' Exited: ' . $visitorUpdateData['visitor_name'],
                                                'description' => $visitorUpdateData['visitor_name'] . ', your ' . $resourceType . ', has exited the premises. Their visit has concluded, and they have left the location.',
                                                'module' => 'resource',
                                                'category_name' => $resourceType,
                                                'guard' => $visitorUpdateData['updated_by_name'],
                                                'mobile_no' => $visitorUpdateData['visitor_mobile_no'],
                                                'display_status' => underscoreToUcWord('exited'),
                                                'image' => $visitorImagePath,
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                                'app_type' => $appType,
                                            );

                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                $notificationArray['receive_for_notification'] = $resourceTypeData['resource_type_id'];
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!empty($notificationDataArray)) {
                        sendNotificationResourceAndroid($notificationDataArray);
                    }
                }
                $filterArray = array(
                    'is_multiple' => 1,
                    'resource_id' => $visitorUpdateData['resource_id'],
                    'is_helper' => 1,
                    'is_deleted' => 0,
                );
                $resourceData = $this->resourceModel->getResourceData($filterArray);
                $objectFilterData = array(
                    'resource_type_id' => array('resource_type_id', 'resource_type_name'),
                );
                $resourceFlatDataWise = array();
                $resourceFlatAlreadyDataWise = array();
                $resourceDocumentDataWise = array();
                $resourceWorkingDayDataWise = array();
                $resourceIdArray = array();
                if (!empty($resourceData)) {
                    foreach ($resourceData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                    if (!empty($resourceIdArray)) {
                        $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                            "resource_id" => $resourceIdArray,
                            'ownership_flat_member_id' => $userId,
                            'is_deleted' => 0,
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceFlatAlreadyAddedData)) {
                            foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                                $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                            }
                        }
                        $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                            "resource_id" => $resourceIdArray,
                            'is_deleted' => 0,
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceFlatData)) {
                            foreach ($resourceFlatData as $resourceFlatElement) {
                                $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                            }
                        }
                        $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                            "document_type_id" => $resourceIdArray,
                            "document_type" => 'resource',
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceImageData)) {
                            foreach ($resourceImageData as $resourceImageElement) {
                                if ($resourceImageElement["document_image"] == '') {
                                    $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                    $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                } else {
                                    $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                    $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                }
                                $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                            }
                        }
                    }
                }
                if (!empty($resourceData)) {
                    foreach ($resourceData as $vKey => $resource) {
                        // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                        $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                        // $visitorResourceData = $this->visitorModel->getVisitorData(array(
                        //  'resource_id' => $resource['resource_id'],
                        // ));
                        // if(!empty($visitorResourceData)){
                        //  $status = $visitorResourceData['status'];
                        //  $startDate = isValidDate($visitorResourceData['start_date']) ? $visitorResourceData['start_date'] : date("Y-m-d H:i:s");
                        //  $endDate = isValidDate($visitorResourceData['end_date']) ? $visitorResourceData['end_date'] : date("Y-m-d H:i:s");
                        //  $resourceData[$vKey]['difference_start_end_date'] = $this->calculateDateTimeDifference($startDate,$endDate);
                        //  $resourceData[$vKey]["start_date_time_display"] = date('d M, Y H:i A', strtotime($startDate));
                        //  $resourceData[$vKey]["end_date_time_display"] = date('d M, Y H:i A', strtotime($endDate));
                        //  $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                        //  $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                        //  $resourceData[$vKey]["status"] = $status;
                        //  $resourceData[$vKey]["visitor_status_display"] = underscoreToUcWord($status);
                        //  $resourceData[$vKey]["visitor_id"] = $visitorResourceData['visitor_id'];
                        // }
                        // else{
                        //  $resourceData[$vKey]["start_date_time_display"] = '';
                        //  $resourceData[$vKey]["end_date_time_display"] = '';
                        //  $resourceData[$vKey]["start_date_display"] = '';
                        //  $resourceData[$vKey]["end_date_display"] = '';
                        //  $resourceData[$vKey]["visitor_status_display"] = 'Not Arrived Yet';
                        //  $resourceData[$vKey]["visitor_id"] = 0;
                        // }

                        $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                        if ($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD) {
                            $status = 'approved';
                            $visitorStatus = 'approved';
                        } else {
                            $status = $resource['visitor_status'];
                            $visitorStatus = $resource['visitor_status'];
                        }


                        $startDate = isValidDate($resource['start_date']) ? $resource['start_date'] : date("Y-m-d H:i:s");
                        $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                        $resourceData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($startDate, $endDate);
                        $resourceData[$vKey]["start_date_time_display"] = date('d M, Y h:i A', strtotime($startDate));
                        $resourceData[$vKey]["end_date_time_display"] = date('d M, Y h:i A', strtotime($endDate));
                        $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                        $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                        $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                        // $resourceData[$vKey]["status"] = (isset($resource['status']) && $resource['status'] === 'approved') ? 'Not Arrived Yet' : $status;
                        $resourceData[$vKey]["visitor_status_display"] = (isset($resource['visitor_status']) && !empty($resource['visitor_status'])) ? underscoreToUcWord($status) : 'approved';
                        $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                        $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                        $path = '';
                        if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                            $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                        }
                        $resourceData[$vKey]['visitor_status'] = $visitorStatus;
                        $resourceData[$vKey]['qr_code_image'] = $path;
                        // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                        $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                        $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                        $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                        $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                        $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                        $resourceData[$vKey]['visitor_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                        $shareData = array(
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            "share_link" => "https://digitattva.in/",
                            "share_qr_code_image" => $path,
                        );
                        $resourceData[$vKey]['share_data'] = $shareData;
                    }
                }
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.resource_exited_unsuccessfully'),
                    'data' => null
                ), 400);
            }
            if ($isInsertUpdate == 0) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.this_visitor_is_already') . underscoreToUcWord($status),
                    'data' => $resourceData
                ), 200);
            }
            if (isset($visitorData['success']) && $visitorData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.resource_exited_successfully'),
                    'data' => $resourceData
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.resource_exited_unsuccessfully'),
                    'data' => $resourceData
                ), 400);
            }
        }
    }

    public function resourceEntered()
    {
        $this->db->transBegin();
        $resourceId = $this->request->getVar('resource_id');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $resourceData = $this->resourceModel->getResourceData(array(
                'resource_id' => $resourceId,
                'is_helper' => 1,
                'is_deleted' => 0,
            ));
            // $resourceFlatDataArray = $this->resourceModel->getResourceFlatData(array(
            //  'resource_id' => $resourceId,
            //  'is_multiple' => 1,
            // ));
            $isInsertUpdate = 1;
            $visitorUpdateArray = array();
            if (!empty($resourceData)) {
                if ($resourceData['visitor_status'] == 'entered') {
                    $isInsertUpdate = 0;
                }
                if ($isInsertUpdate == 1) {
                    $visitorArray = array(
                        'visitor_id' => '',
                        'visitor_name' => $resourceData['resource_name'],
                        'visitor_mobile_no' => $resourceData['resource_mobile_no'],
                        'society_id' => $resourceData['society_id'],
                        'resource_id' => $resourceData['resource_id'],
                        'resource_type_id' => $resourceData['resource_type_id'],
                        // 'category_id'=> $resourceData['category_id'],
                        'type' => 'resource',
                        'ownership_flat_member_id' => $userId,
                        'address' => $resourceData['address'],
                        'expected_start_date_time' => date("Y-m-d H:i:s"),
                        'status' => 'entered',
                        'start_date' => date("Y-m-d H:i:s"),
                    );
                    $extraData = array();
                    $extraObj['api_user_id'] = $userId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);

                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'resource_id' => $resourceId,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        'is_multiple' => 1
                    ));
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceId,
                        "document_type" => 'resource',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }
                    $ownershipFlatMemberIdArray = array();
                    $ownershipFlatIdWiseArray = array();
                    $ownershipTypeWiseArray = array();
                    $notificationDataArray = array();

                    $userDeviceUserIdArray = array();
                    $userDeviceUserTypeIdArray = array();
                    $userDeviceUserTypeArray = array();



                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlat) {
                            $ownershipFlatIdWiseArray[] = $resourceFlat['ownership_flat_id'];
                            $ownershipTypeWiseArray[] = $resourceFlat['type'];


                        }
                    }

                    $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_id' => $ownershipFlatIdWiseArray,
                        'type' => $ownershipTypeWiseArray,
                        'is_multiple' => 1
                    ));
                        
                    if (!empty($ownershipFlatMemberData)) {
                        foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                            $ownershipFlatMemberIdArray[] = $ownershipFlatMember['ownership_flat_member_id'];


                        }
                    }

                    $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Member',
                        'society_id' => $this->session->get('society_id'),
                    ));

                    if (!empty($ownershipFlatMemberIdArray)) {
                        $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeData['resource_type_id'],
                            'type_id' => $ownershipFlatMemberIdArray,
                            'is_multiple' => 1
                        ));

                        if (!empty($userSocietyFamilyData)) {
                            foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                $userDeviceUserIdArray[] = isset($userSocietyFamilyElement['user_id']) ? $userSocietyFamilyElement['user_id'] : 0;
                                $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                $userDeviceUserTypeArray[] = $resourceTypeData['resource_type_id'];
                            }

                            // printArray($userDeviceUserTypeIdArray);
                            // printArray($ownershipFlatMemberIdArray);
                            $userDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_id" => $userDeviceUserIdArray,
                                "user_type_id" => $userDeviceUserTypeIdArray,
                                "resource_type_id" => $userDeviceUserTypeArray,
                                "is_latest" => 1,
                                "is_multiple" => 1,
                            ));

                            $userDeviceIdArray = array();

                            if(!empty($userDevice)){
                                foreach($userDevice as $userDeviceElement){
                                    $userDeviceIdArray[] = $userDeviceElement['device_id'];
                                }
                            }

                            $notificationType = $this->commonWebserviceModel->getNotificationTypeData(array(
                                'notification_type' => ucwords('resources'),
                            ));

                            $notificationTypeDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
                                'notification_type_id' => $notificationType['notification_type_id'],
                                'device_id' => $userDeviceIdArray,
                                'ownership_flat_member_id' => $userDeviceUserTypeIdArray,
                                'is_multiple' => 1,
                            ));
                            if(!empty($userDevice)){
                                foreach ($userDevice as &$device) {
                                    foreach ($notificationTypeDevice as $notification) {
                                        if ($device['device_id'] == $notification['device_id'] && $device['user_type_id'] == $notification['ownership_flat_member_id']) {
                                            $device['is_enabled'] = $notification['is_enabled'];
                                        }
                                    }
                                }
                            }
                            if (!empty($userDevice)) {
                                foreach ($userDevice as $userDeviceElement) {
                                    if ($userDeviceElement['is_enabled'] == 1) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                            $resourceType = $resourceData['resource_type_name'];
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'resource',
                                                'status' => 'entered',
                                                'notification_date' => TODAY_DATE_YMD,
                                                'type_id' => $resourceId,
                                                'society_id' => $societyId,
                                                'visitor_name' => $resourceData['resource_name'],
                                                'user_id' => $userId,
                                                'notification_title' => $resourceType . ' Entered: ' . $resourceData['resource_name'],
                                                'description' => $resourceData['resource_name'] . ', your ' . $resourceType . ', has been allowed entry by the ' . $resourceData['updated_by_name'] . ' and is now at the location. Please be aware of their presence during their visit.',
                                                'module' => 'resource',
                                                'category_name' => $resourceType,
                                                'guard' => $resourceData['updated_by_name'],
                                                'mobile_no' => $resourceData['resource_mobile_no'],
                                                'display_status' => underscoreToUcWord('entered'),
                                                'image' => $visitorImagePath,
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                                'app_type' => $appType,
                                            );

                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                $notificationArray['receive_for_notification'] = $resourceTypeData['resource_type_id'];
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if (!empty($notificationDataArray)) {
                        sendNotificationResourceAndroid($notificationDataArray);
                    }

                }
            }

            $filterArray = array(
                'is_multiple' => 1,
                'resource_id' => $resourceId,
                'is_helper' => 1,
                'is_deleted' => 0,
            );
            $resourceData = $this->resourceModel->getResourceData($filterArray);
            $objectFilterData = array(
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceIdArray = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $userId,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                    if ($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD) {
                        $status = 'approved';
                        $visitorStatus = 'approved';
                    } else {
                        $status = $resource['visitor_status'];
                        $visitorStatus = $resource['visitor_status'];
                    }
                    $startDate = isValidDate($resource['start_date']) ? $resource['start_date'] : date("Y-m-d H:i:s");
                    $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                    $resourceData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($startDate, $endDate);
                    $resourceData[$vKey]["start_date_time_display"] = date('d M, Y h:i A', strtotime($startDate));
                    $resourceData[$vKey]["end_date_time_display"] = date('d M, Y h:i A', strtotime($endDate));
                    $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                    $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    // $resourceData[$vKey]["status"] = (isset($resource['status']) && $resource['status'] === 'approved') ? 'Not Arrived Yet' : $status;
                    $resourceData[$vKey]["visitor_status_display"] = (isset($resource['visitor_status']) && !empty($resource['visitor_status'])) ? underscoreToUcWord($status) : 'approved';
                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $resourceData[$vKey]['qr_code_image'] = $path;
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['visitor_status'] = $visitorStatus;
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['visitor_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }

            if ($isInsertUpdate == 0) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.this_visitor_is_already') . "Entered",
                    'data' => $resourceData
                ), 200);
            }
            if (isset($visitorData['success']) && $visitorData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.resource_entered_successfully'),
                    'data' => $resourceData
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.resource_entered_unsuccessfully'),
                    'data' => $resourceData
                ), 400);
            }
        }
    }

    public function getResourceList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        // $categoryId = $this->request->getVar('category_id');
        $userId = $this->request->getVar('user_id');
        // $categoryName = $this->request->getVar('category_name');
        $isMyResource = $this->request->getVar('is_my_resource');
        $appType = $this->request->getVar('app_type');
        $resourceTypeId = $this->request->getVar('resource_type_id');

        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        // $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                'society_id' => $societyId,
                'is_multiple' => 1,
                'is_helper' => 1,
                'is_active' => 1,
            ));
            // $resourceTypes = resourceType();
            // $resourceTypeArray = [];
            // foreach ($resourceTypes as $resource) {
            //     if (isset($resource['is_login']) && $resource['is_login'] == 0) {
            //         $resourceTypeArray[] = $resource['name'];
            //     }
            // }
            // $formattedResourceTypes = getResourceKeyValue($resourceType);
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            if(!empty($ownershipFlatMemberId)){
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $ownershipFlatId = $ownershipMemberFlatData['ownership_flat_id'];
            }
            else{
                $ownershipFlatId = 0;
            }
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                // 'category_id' => $categoryId,
                // 'category_name' => $categoryName,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'user_id' => $userId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'ownership_flat_id' => $ownershipFlatId,
                'resource_type_id' => $resourceTypeId,
                // 'resource_type_array' => $resourceTypeArray,
                'is_deleted' => 0,
                'is_helper' => 1,
            );
            if (!empty($isMyResource)) {
                $resourceIdArray = array();
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1
                ));
                if (!empty($ownershipMemberFlatData)) {
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'ownership_flat_id' => $ownershipMemberFlatData['ownership_flat_id'],
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        'is_multiple' => 1
                    ));
                }
                if (!empty($resourceFlatData)) {
                    foreach ($resourceFlatData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                }
                if (!empty($resourceIdArray)) {
                    $resourceData = $this->resourceModel->getResourceData(array(
                        'resource_id' => $resourceIdArray,
                        'ownership_flat_id' => $ownershipFlatId,
                        'start' => $start,
                        'search' => $search,
                        // 'category_id' => $categoryId,
                        // 'category_name' => $categoryName,
                        'resource_type_id' => $resourceTypeId,
                        'is_helper' => 1,
                        // 'resource_type_array' => $resourceTypeArray,
                        'is_multiple' => 1
                    ));
                }
            } else {
                $resourceData = $this->resourceModel->getResourceData($filterArray);
            }
            $objectFilterData = array(
                //'flat_id' => array('flat_id','tower_flat_name'),
                //'ownership_flat_member_id' => array('ownership_flat_member_id','name'),
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
                //'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceImageDataWise = array();
            $resourceIdArray = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
//                  $resourceWorkingDayData = $this->resourceModel->getResourceWorkingDayData(array(
//                      "resource_id" => $resourceIdArray,
//                      "is_multiple" => 1
//                  ));
//                  if(!empty($resourceWorkingDayData)) {
//                      foreach ($resourceWorkingDayData as $resourceWorkingElement) {
//                          $resourceWorkingDayDataWise[$resourceWorkingElement['resource_id']][] = $resourceWorkingElement;
//                      }
//                  }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    //                  if($resource['status'] == 'entered' || $resource['status'] == 'exited'){
                    //                      $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                    //                      $resourceData[$vKey]['difference_start_end_date'] = $this->calculateDateTimeDifference($resource['start_date'],$endDate);
                    //                  }

                    $resourceImagePath = site_url('uploads/no_image.png');
                    if ($resource['resource_image'] != '' && file_exists(DOCUMENT_IMAGE_PATH . $resource['resource_image'])) {
                        $resourceImagePath = site_url() . DOCUMENT_IMAGE_PATH . $resource['resource_image'];
                    }
                    $resourceData[$vKey]['resource_image'] = $resourceImagePath;
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";

                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $resourceData[$vKey]['qr_code_image'] = $path;
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    //                  $path = site_url('uploads/no_image.png');
                    // if ($resource['id_proof'] != '' && file_exists(ID_PROOF_PATH . $resource['id_proof'])) {
                    //  $path = site_url() . ID_PROOF_PATH . $resource['id_proof'];
                    // }
                    // $resourceData[$vKey]['id_proof'] = $path;
//                                      $resourceData[$vKey]['resource_working_day_data'] = array_key_exists($resource['resource_id'],$resourceWorkingDayDataWise) ? $resourceWorkingDayDataWise[$resource['resource_id']]: array();
                    $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();

                    //                  if ($resource['ownership_flat_member_id'] == $userId) {
                    //                      $resourceData[$vKey]['is_added'] = 1;
                    //                  } else {
                    //                      $resourceData[$vKey]['is_added'] = 0;
                    //                  }
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getSosEmergencyList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $sosEmergencyId = $this->request->getVar('sos_emergency_id');
        $categoryId = $this->request->getVar('category_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'category_id' => $categoryId,
                'sos_emergency_id' => $sosEmergencyId,
                'society_id' => $societyId,
            );
            $sosEmergencyData = $this->sosModel->getSosEmergencyData($filterArray);
            $objectFilterData = array(
                'category_id' => array('category_id', 'category_name'),
                'status_id' => array('status_id', 'status_name', 'is_resolved'),
            );
            $sosEmergencyNotificationDataWise = array();
            $sosEmergencyRecordDataWise = array();
            $sosEmergencyIdArray = array();
            if (!empty($sosEmergencyData)) {
                foreach ($sosEmergencyData as $sosEmergencyElement) {
                    $sosEmergencyIdArray[] = $sosEmergencyElement['sos_emergency_id'];
                }
                if (!empty($sosEmergencyIdArray)) {
                    $sosEmergencyNotificationData = $this->sosModel->getSosEmergencyNotificationData(array(
                        "sos_emergency_id" => $sosEmergencyIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($sosEmergencyNotificationData)) {
                        foreach ($sosEmergencyNotificationData as $sosEmergencyNotificationElement) {
                            $sosEmergencyNotificationDataWise[$sosEmergencyNotificationElement['sos_emergency_id']][] = $sosEmergencyNotificationElement;
                        }
                    }
                    $sosEmergencyRecordData = $this->sosModel->getSosEmergencyRecordData(array(
                        "sos_emergency_id" => $sosEmergencyIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($sosEmergencyRecordData)) {
                        foreach ($sosEmergencyRecordData as $sosEmergencyRecordElement) {
                            if ($sosEmergencyRecordElement["sos_record"] == '') {
                                $sosEmergencyRecordElement["sos_record"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $sosEmergencyRecordElement["sos_record"] = SITE_URL() . CATEGORY_IMAGE_PATH . $sosEmergencyRecordElement["sos_record"];
                            }
                            $sosEmergencyRecordDataWise[$sosEmergencyRecordElement['sos_emergency_id']][] = $sosEmergencyRecordElement;
                        }
                    }
                }
            }
            if (!empty($sosEmergencyData)) {
                foreach ($sosEmergencyData as $vKey => $sosEmergency) {
                    $sosEmergencyData[$vKey] = getModuleObjectData($objectFilterData, $sosEmergency);
                    $sosEmergencyData[$vKey]['created_at'] = isValidDate($sosEmergency['created_at']) ? YMDToDMY($sosEmergency["created_at"], true) : "";
                    $sosEmergencyData[$vKey]['updated_at'] = isValidDate($sosEmergency['updated_at']) ? YMDToDMY($sosEmergency["updated_at"], true) : "";
                    $sosEmergencyData[$vKey]['status_display'] = underscoreToUcWord($sosEmergency["status"]);
                    $sosEmergencyData[$vKey]['created_at_display'] = time_elapsed_string($sosEmergency['created_at']);
                    $sosEmergencyData[$vKey]['updated_at_display'] = time_elapsed_string($sosEmergency['updated_at']);
                    $sosEmergencyData[$vKey]['sos_emergency_notification_data'] = array_key_exists($sosEmergency['sos_emergency_id'], $sosEmergencyNotificationDataWise) ? $sosEmergencyNotificationDataWise[$sosEmergency['sos_emergency_id']] : array();
                    $sosEmergencyData[$vKey]['sos_emergency_record_data'] = array_key_exists($sosEmergency['sos_emergency_id'], $sosEmergencyRecordDataWise) ? $sosEmergencyRecordDataWise[$sosEmergency['sos_emergency_id']] : array();
                    if ($sosEmergency["category_image"] == '') {
                        $sosEmergencyData[$vKey]["category_image"] = SITE_URL('uploads/no_image.png');
                        $sosEmergencyData[$vKey]["thumbnail_category_image"] = SITE_URL('uploads/no_image.png');
                    } else {
                        $sosEmergencyData[$vKey]["thumbnail_category_image"] = SITE_URL() . THUMBNAIL_CATEGORY_IMAGE_PATH . $sosEmergency["category_image"];
                        $sosEmergencyData[$vKey]["category_image"] = SITE_URL() . CATEGORY_IMAGE_PATH . $sosEmergency["category_image"];
                    }
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $sosEmergencyData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($sosEmergencyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.sos_emergency_listing_successfully'),
                    'sos_type_list' => sosTypeAPI(),
                    'data' => $sosEmergencyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'sos_type_list' => sosTypeAPI(),
                    'data' => $sosEmergencyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function getSosEmergencyNotificationList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $typeId = $this->request->getVar('type_id');

        $userId = $this->request->getVar('user_id');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if($appType == MEMBER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'search' => $search,
                'type' => $type,
                'type_id' => $typeId,
                'society_id' => $societyId,
            );
            $getNotificationData = $this->notificationModel->getNotificationData($filterArray);


            if (!empty($getNotificationData)) {
                foreach ($getNotificationData as $nKey => $getNotificationElement) {

                    $getNotificationData[$nKey]['created_at'] = isValidDate($getNotificationElement['created_at']) ? YMDToDMY($getNotificationElement["created_at"], true) : "";
                    $getNotificationData[$nKey]['updated_at'] = isValidDate($getNotificationElement['updated_at']) ? YMDToDMY($getNotificationElement["updated_at"], true) : "";

                    $getNotificationData[$nKey]['created_at_display'] = time_elapsed_string($getNotificationElement['created_at']);
                    $getNotificationData[$nKey]['updated_at_display'] = time_elapsed_string($getNotificationElement['updated_at']);

                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $getNotificationData[$nKey]['share_data'] = $shareData;
                }
            }
            if (!empty($getNotificationData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.sos_emergency_notification_listing_successfully'),
                    'data' => $getNotificationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $getNotificationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }
    
    public function acceptRejectNotification()
    {
        $notificationId = $this->request->getVar('notification_id');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $actionType = $this->request->getVar('action_type');
        $appType = $this->request->getVar('app_type');

        $this->validation->setRule('notification_id', lang('CommonWebService.notification_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        $this->validation->setRule('action_type', lang('CommonWebService.action_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $notificationData = $this->notificationModel->getNotificationData(array(
                'notification_id' => $notificationId,
            ));
            if(strtolower($notificationData['action_type']) != 'send'){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.sos_status_already_updated') . underscoreToUcWord($notificationData['action_type']),
                    'data' => null
                ), 404);
            }
            $notificationUpdateArray = array(
                'notification_id' => $notificationId,
                'action_type' => $actionType,
                'is_action_perform' => 1,
            );
            $notificationUpdateData = $this->commonWebserviceModel->insertUpdateRecord($notificationUpdateArray, 'notification_id', 'tbl_notification', 1, '', array());

            if (isset($notificationUpdateData['success']) && $notificationUpdateData['success']) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => "Notification ".$actionType . " Successfully",
                    'data' => null
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.notification')),
                    'data' => null
                ), 404);
            }

        }
    }


    public function getResourceGateKeeperList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        // $categoryId = $this->request->getVar('category_id');
        $userId = $this->request->getVar('user_id');
        // $categoryName = $this->request->getVar('category_name');
        $status = $this->request->getVar('filtered_status');
        $isTodayExitVisitor = $this->request->getVar('is_today_exit_visitor');
        $isTodayEnterVisitor = $this->request->getVar('is_today_enter_visitor');
        $resourceTypeId = $this->request->getVar('resource_type_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        // $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                'society_id' => $societyId,
                'is_multiple' => 1,
                'is_helper' => 1,
                'is_active' => 1,
            ));

            // $resourceTypes = resourceType();
            // $resourceType = [];
            // foreach ($resourceTypes as $resource) {
            //     if (isset($resource['is_login']) && $resource['is_login'] == 0) {
            //         $resourceType[] = $resource['name'];
            //     }
            // }
            // $formattedResourceTypes = getResourceKeyValue($resourceType);

            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            $resourceTypes = resourceType();
            $resourceTypeArray = [];
            foreach ($resourceTypes as $resource) {
                if (isset($resource['is_login']) && $resource['is_login'] == 0) {
                    $resourceTypeArray[] = $resource['name'];
                }
            }
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                // 'resource_type_array' => $resourceTypeArray,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'user_id' => $userId,
                'status' => $status,
                'resource_type_id' => $resourceTypeId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_deleted' => 0,
                'is_today_exit_visitor' => $isTodayExitVisitor,
                'is_today_enter_visitor' => $isTodayEnterVisitor,
                'is_helper' => 1,
            );
            $resourceData = $this->resourceModel->getResourceData($filterArray);
            // printArray($resourceData,1);
            $objectFilterData = array(
                //'flat_id' => array('flat_id','tower_flat_name'),
                //'ownership_flat_member_id' => array('ownership_flat_member_id','name'),
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
                //'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceIdArray = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    // $visitorData = $this->visitorModel->getVisitorData(array(
                    //  'resource_id' => $resource['resource_id'],
                    //  'status' => $status,
                    // ));
                    // if(!empty($visitorData)){
                    //  $endDateStatus = isValidDate($visitorData['end_date']) ? date('Y-m-d', strtotime($visitorData['end_date'])) : '';
                    //  if($visitorData['status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD){
                    //      $status = 'approved';
                    //  }
                    //  else{
                    //      $status = $visitorData['status'];
                    //  }
                    //  $startDate = isValidDate($visitorData['start_date']) ? $visitorData['start_date'] : date("Y-m-d H:i:s");
                    //  $endDate = isValidDate($visitorData['end_date']) ? $visitorData['end_date'] : date("Y-m-d H:i:s");
                    //  $resourceData[$vKey]['difference_start_end_date'] = $this->calculateDateTimeDifference($startDate,$endDate);
                    //  $resourceData[$vKey]["start_date_time_display"] = date('d M, Y H:i A', strtotime($startDate));
                    //  $resourceData[$vKey]["end_date_time_display"] = date('d M, Y H:i A', strtotime($endDate));
                    //  $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                    //  $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                    //  $resourceData[$vKey]["status"] = (isset($status) && $status === 'approved') ? 'Not Arrived Yet' : $status;
                    //  $resourceData[$vKey]["visitor_status_display"] = underscoreToUcWord($status);
                    //  $resourceData[$vKey]["visitor_id"] = $visitorData['visitor_id'];
                    // }
                    // else{
                    //  $resourceData[$vKey]["start_date_time_display"] = '';
                    //  $resourceData[$vKey]["end_date_time_display"] = '';
                    //  $resourceData[$vKey]["start_date_display"] = '';
                    //  $resourceData[$vKey]["end_date_display"] = '';
                    //  $resourceData[$vKey]["visitor_status_display"] = 'Not Arrived Yet';
                    //  $resourceData[$vKey]["visitor_id"] = 0;
                    // }
                    // $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                    // if($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD){
                    //  $status = 'approved';
                    // }
                    $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                    if ($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD) {
                        $status = 'approved';
                        $visitorStatus = 'approved';
                    } else {
                        $status = $resource['visitor_status'];
                        $visitorStatus = $resource['visitor_status'];
                    }
                    $startDate = isValidDate($resource['start_date']) ? $resource['start_date'] : date("Y-m-d H:i:s");
                    $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                    $resourceData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($startDate, $endDate);
                    $resourceData[$vKey]["start_date_time_display"] = date('d M, Y h:i A', strtotime($startDate));
                    $resourceData[$vKey]["end_date_time_display"] = date('d M, Y h:i A', strtotime($endDate));
                    $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                    $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    // $resourceData[$vKey]["status"] = (isset($resource['status']) && $resource['status'] === 'approved') ? 'Not Arrived Yet' : $status;
                    $resourceData[$vKey]["visitor_status_display"] = (isset($resource['visitor_status']) && !empty($resource['visitor_status'])) ? underscoreToUcWord($status) : 'approved';
                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $resourceData[$vKey]['visitor_status'] = $visitorStatus;
                    $resourceData[$vKey]['qr_code_image'] = $path;
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['visitor_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getResourceDetailList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $resourceTypeId = $this->request->getVar('resource_type_id');
        // $categoryId = $this->request->getVar('category_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        // $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'resource_type_id' => $resourceTypeId,
                // 'category_id' => $categoryId,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'is_helper' => 1,
                'is_deleted' => 0,
            );
            $resourceData = $this->resourceModel->getResourceData($filterArray);
            $objectFilterData = array(
                //'flat_id' => array('flat_id','tower_flat_name'),
                //'ownership_flat_member_id' => array('ownership_flat_member_id','name'),
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
                //'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
            );
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceAttendanceDataWise = array();
            $resourceFlatDataWise = array();
            $resourceFlatDataWise = array();
            $resourceIdArray = array();
            // $categoryIdArray = array();
            $resourceNameArray = array();
            $resourceTypeArray = array();
            $totalFlatCount = 0;
            $durationInMinutes = 0;
            $lastAttendanceChecked = 0;
            $maxDuration = -1;
            $maxAttendanceDuration = -1;
            $longestDurationResource = '';
            $longestAttendanceDuration = '';
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                    $resourceNameArray[] = $resourceElement['resource_name'];
                    $resourceTypeArray[] = $resourceElement['resource_type_id'];
                }
                if (!empty($resourceIdArray)) {
//                  $resourceWorkingDayData = $this->resourceModel->getResourceWorkingDayData(array(
//                      "resource_id" => $resourceIdArray,
//                      "is_multiple" => 1
//                  ));
//                  if(!empty($resourceWorkingDayData)) {
//                      foreach ($resourceWorkingDayData as $resourceWorkingElement) {
//                          $resourceWorkingDayDataWise[$resourceWorkingElement['resource_id']][] = $resourceWorkingElement;
//                      }
//                  }
                    $resourceAttendanceData = $this->visitorModel->getVisitorResourceAttendanceData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));

                    if (!empty($resourceAttendanceData)) {
                        foreach ($resourceAttendanceData as $resourceAttendanceElement) {
                            $resourceAttendanceElement['current_month_days'] = date("t", mktime(0, 0, 0, date("n"), 1, date("Y")));
                            $resourceAttendanceElement['last_attendance_year'] = time_elapsed_string($resourceAttendanceElement['created_at']);
                            $lastAttendanceChecked = convertDurationToMinute($resourceAttendanceElement['last_attendance_year']);

                            if ($lastAttendanceChecked > $maxAttendanceDuration) {
                                $maxAttendanceDuration = $lastAttendanceChecked;
                                $longestAttendanceDuration = $resourceAttendanceElement['last_attendance_year'];
                            }
                            $resourceAttendanceDataWise[$resourceAttendanceElement['resource_id']][] = $resourceAttendanceElement;
                        }
                    }

                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        //"category_id" => $categoryIdArray,
                        "resource_type_id" => $resourceTypeArray,
                        "is_multiple" => 1,
                        'is_helper' => 1,
                        'is_deleted' => 0,
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $totalFlatCount++;
                            $resourceFlatElement['flat_work_duration_year'] = time_elapsed_string($resourceFlatElement['created_at']);
                            $durationInMinutes = convertDurationToMinute($resourceFlatElement['flat_work_duration_year']);
                            // Track the maximum duration and corresponding resource
                            if ($durationInMinutes > $maxDuration) {
                                $maxDuration = $durationInMinutes;
                                $longestDurationResource = $resourceFlatElement['flat_work_duration_year'];
                            }
                            $resourceFlatDataWise[$resourceFlatElement['resource_type_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $resourceData[$vKey]['qr_code_image'] = $path;
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    $resourceData[$vKey]['work_in_total_house'] = $totalFlatCount;
                    $resourceData[$vKey]['work_in_house_year'] = $longestDurationResource;
                    $resourceData[$vKey]['last_attendance_checked'] = $longestAttendanceDuration;
                    $resourceData[$vKey]['resource_attendance_data'] = array_key_exists($resource['resource_id'], $resourceAttendanceDataWise) ? $resourceAttendanceDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_type_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_type_id']] : array();
                    //$resourceData[$vKey]['resource_working_day_data'] = array_key_exists($resource['resource_id'],$resourceWorkingDayDataWise) ? $resourceWorkingDayDataWise[$resource['resource_id']]: array();
                    $resourceData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }
    public function getTowerList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $towerId = $this->request->getVar('tower_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'tower_id' => $towerId,
                'society_id' => $societyId,
                'is_active' => 1,
            );
            $towerData = $this->towerModel->getTowerData($filterArray);
            if (isset($towerId) && count($towerId) == 1) {
                $towerData = isset($towerData[0]) ? $towerData[0] : array();
            }
            if (!empty($towerData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.tower_listing_successfully'),
                    'data' => $towerData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $towerData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getOwnershipFlatList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $towerId = $this->request->getVar('tower_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        //  $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            //$start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            $legendsData = array(
                array(
                    'type' => 'ownership_flat',
                    'name' => 'Ownership Flat',
                    'color_code' => FLAT_OWNER_COLOR_CODE,
                ),
                array(
                    'type' => 'rentals',
                    'name' => 'Rentals',
                    'color_code' => VISITOR_COLOR_CODE,
                ),
            );

            $legendsDataIdWise = array();
            if (!empty($legendsData)) {
                foreach ($legendsData as $legendsElement) {
                    $legendsDataIdWise[$legendsElement['type']] = $legendsElement;
                }
            }
            // printArray($legendsDataIdWise,1);
            $ownershipFlatMemberIdArray = array();
            $flatFilterArray = array(
                'is_multiple' => 1,
                'society_id' => $societyId,
                'is_active' => 1,
                'is_latest' => 1,
                //'check_flat_rent' => 1
            );

            $getOwnerFlatData = $this->ownershipFlatModel->getOwnershipFlatNotRentalsData($flatFilterArray);

            if (!empty($getOwnerFlatData)) {
                foreach ($getOwnerFlatData as $getOwnerFlatElement) {
                    array_push($ownershipFlatMemberIdArray, $getOwnerFlatElement['ownership_flat_member_id']);
                }
            }

            $rentFlatFilterArray = array(
                'is_multiple' => 1,
                'society_id' => $societyId,
                'is_active' => 1,
                'check_flat_rent' => 1
            );
            $getRentalsFlatData = $this->ownershipFlatModel->getRentalsFlatData($rentFlatFilterArray);
            if (!empty($getRentalsFlatData)) {
                foreach ($getRentalsFlatData as $geRentalsFlatElement) {
                    array_push($ownershipFlatMemberIdArray, $geRentalsFlatElement['ownership_flat_member_id']);
                }
            }

            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                'is_show_all_member' => 1,
                'is_multiple' => 1,
            ));

            $filteredData = [];
            $rentalIds = [];
            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                if ($ownershipFlatMember['type'] === 'rentals') {
                    $rentalIds[] = $ownershipFlatMember['ownership_flat_id'];
                }
            }
            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                if ( ($ownershipFlatMember['type'] === 'ownership_flat' && in_array($ownershipFlatMember['ownership_flat_id'], $rentalIds)) || 
                    $ownershipFlatMember['is_owner'] === 0 ) 
                {
                    continue; // Skip this entry
                }
                $filteredData[] = $ownershipFlatMember; // Keep other entries
            }
            $ownershipFlatMemberIdNewArray = array();
            $ownershipFlatMemberData = $filteredData;
            if(!empty($ownershipFlatMemberData)){
                foreach($ownershipFlatMemberData as $ownershipFlatMemberList){
                    $ownershipFlatMemberIdNewArray[] = $ownershipFlatMemberList['ownership_flat_member_id'];
                }
            }
            // printArray($ownershipFlatMemberIdNewArray,1);
            $filterArray = array(
                'is_multiple' => 1,
                //  'start' => $start,
                'search' => $search,
                'tower_id' => $towerId,
                'ownership_flat_id' => $ownershipFlatId,
                'ownership_flat_member_id' => $ownershipFlatMemberIdNewArray,
                'society_id' => $societyId,
                'is_active' => 1,
                'is_latest' => 1,
                // 'is_owner' => 1,
            );
            $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatApiData($filterArray);
            // printArray($ownershipFlatData,1);
            if (!empty($ownershipFlatData)) {
                foreach ($ownershipFlatData as $vKey => $ownershipFlat) {
                    $ownershipFlatData[$vKey]['color_code'] = array_key_exists($ownershipFlat['type'], $legendsDataIdWise) ? $legendsDataIdWise[$ownershipFlat['type']]['color_code'] : '';
                    $ownershipFlatData[$vKey]['created_at'] = isValidDate($ownershipFlat['created_at']) ? YMDToDMY($ownershipFlat["created_at"], true) : "";
                    $ownershipFlatData[$vKey]['updated_at'] = isValidDate($ownershipFlat['updated_at']) ? YMDToDMY($ownershipFlat["updated_at"], true) : "";
                    $ownershipFlatData[$vKey]['created_at_display'] = time_elapsed_string($ownershipFlat['created_at']);
                    $ownershipFlatData[$vKey]['updated_at_display'] = time_elapsed_string($ownershipFlat['updated_at']);

                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($ownershipFlat['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $ownershipFlat['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $ownershipFlat['member_image'];
                    }
                    if ($ownershipFlat['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlat['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlat['member_image'];
                    }
                    $ownershipFlatData[$vKey]['thumbnail_member_image'] = $thumbnailPath;
                    $ownershipFlatData[$vKey]['member_image'] = $path;

                }
            }
            $unitGroupResult = [];
            if (!empty($ownershipFlatData)) {
                foreach ($ownershipFlatData as $ownershipFlatElement) {
                    $unitGroup = $ownershipFlatElement['unit_group'];
                    if (!isset($unitGroupResult[$unitGroup])) {
                        $unitGroupResult[$unitGroup] = [
                            'floor' => $unitGroup,
                            'ownership_flat_data' => []
                        ];
                    }
                    $unitGroupResult[$unitGroup]['ownership_flat_data'][] = $ownershipFlatElement;
                }
            }
            // Convert the associative array to a numerical array
            $unitGroupResult = array_values($unitGroupResult);
            $ownershipFlatData = $unitGroupResult;
            if (!empty($ownershipFlatData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.ownership_flat_listing_successfully'),
                    "legends" => $legendsData,
                    'data' => $ownershipFlatData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    "legends" => $legendsData,
                    'data' => $ownershipFlatData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getOwnershipFlatMemberList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $flatId = $this->request->getVar('flat_id');
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                //'ownership_flat_member_id' => $ownershipFlatMemberId,
                'ownership_flat_id' => $ownershipFlatId,
                'flat_id' => $flatId,
                'is_show_all_member' => 1,
                'society_id' => $societyId,
                'type' => $type,
                'is_active' => 1,
            );
            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData($filterArray);
            if (!empty($ownershipFlatMemberData)) {
                $filteredOwnershipFlatMemberData = []; // New array to hold filtered data

                foreach ($ownershipFlatMemberData as $vKey => $ownershipFlatMemberElement) {
                    if ($ownershipFlatMemberElement['type'] == 'rentals') {
                        $rentalsData = $this->rentalModel->getRentalsMemberData(array(
                            'rentals_id' => $ownershipFlatMemberElement['type_id'],
                            'check_rental_start' => 1,
                        ));

                        // printArray($rentalsData,1);

                        // If rentalsData is not empty, add the element to the filtered array
                        if (!empty($rentalsData)) {
                            $filteredOwnershipFlatMemberData[] = $ownershipFlatMemberElement;
                        }
                    } else {
                        // If the type is not rentals, keep the element as is
                        $filteredOwnershipFlatMemberData[] = $ownershipFlatMemberElement;
                    }
                }

                // Update ownershipFlatMemberData with filtered results
                $ownershipFlatMemberData = $filteredOwnershipFlatMemberData;
            }
//          lastQuery();
            if (!empty($ownershipFlatMemberData)) {
                foreach ($ownershipFlatMemberData as $vKey => $ownershipFlatMemberElement) {
                    if (IS_SHOW_MOBILE_NO == 1) {
                        $lastFourDigits = substr($ownershipFlatMemberElement['mobile_no'], -4);
                        $phoneLength = strlen($ownershipFlatMemberElement['mobile_no']);
                        // $ownershipFlatMemberData[$vKey]['mobile_no'] = str_repeat('✕', $phoneLength - 4) . $lastFourDigits;
                        $repeatCount = $phoneLength - 4;
                        if ($repeatCount < 0) {
                            $repeatCount = 0;
                        }
                        $ownershipFlatMemberData[$vKey]['mobile_no'] = str_repeat('✕', $repeatCount) . $lastFourDigits;
                    }
                    $ownershipFlatMemberData[$vKey]['relation'] = underscoreToUcWord($ownershipFlatMemberElement['relation']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($ownershipFlatMemberElement['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberElement['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberElement['member_image'];
                    }
                    if ($ownershipFlatMemberElement['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberElement['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberElement['member_image'];
                    }
                    $ownershipFlatMemberData[$vKey]['thumbnail_member_image'] = $thumbnailPath;
                    $ownershipFlatMemberData[$vKey]['member_image'] = $path;
                }
            }

//          if(isset($ownershipFlatMemberId) && !empty($ownershipFlatMemberId)){
//              $ownershipFlatMemberData = isset($ownershipFlatMemberData[0]) ? $ownershipFlatMemberData[0] : array();
//          }
            if (!empty($ownershipFlatMemberData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.ownership_flat_member_listing_successfully'),
                    'data' => $ownershipFlatMemberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $ownershipFlatMemberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function checkVersion()
    {
        $versionCode = $this->request->getVar('version_code');
        $platform = $this->request->getVar('platform');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('version_code', lang('CommonWebService.version_code'), 'required');
        $this->validation->setRule('platform', lang('CommonWebService.platform'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        }
        $appVersion = $this->commonWebserviceModel->getAppVersionData(array(
            'platform' => $platform,
            'app_type' => $appType,
        ));
        if (!empty($appVersion)) {
            if ($versionCode == $appVersion['version_code']) {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_updated_version'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            } elseif ($versionCode < $appVersion['version_code']) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.version_list_successfully'),
                    'data' => $appVersion,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_updated_version'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        } else {
            $data = array(
                'status' => false,
                'message' => lang('CommonWebService.no_updated_version'),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 404,
            );
            return $this->response($data, 404);
        }
    }

    public function getOwnershipFlatParkingList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $parkingAreaId = $this->request->getVar('parking_area_id');
        $societyId = $this->request->getVar('society_id');
        $vehicleType = $this->request->getVar('vehicle_type');
        $isVisitorParking = $this->request->getVar('is_visitor_parking');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $legendsData = array(
                array(
                    'id' => 'flat_owner',
                    'name' => 'Flat',
                    'color_code' => FLAT_OWNER_COLOR_CODE,
                ),
                array(
                    'id' => 'visitor',
                    'name' => 'Visitor',
                    'color_code' => VISITOR_COLOR_CODE,
                ),
                array(
                    'id' => 'free_slot',
                    'name' => 'Free Slot',
                    'color_code' => FREE_SLOT_COLOR_CODE,
                )
            );

            $legendsDataIdWise = array();
            if (!empty($legendsData)) {
                foreach ($legendsData as $legendsElement) {
                    $legendsDataIdWise[$legendsElement['id']] = $legendsElement;
                }
            }

            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'ownership_flat_id' => $ownershipFlatId,
                'parking_slot_id' => $parkingSlotId,
                'vehicle_type' => $vehicleType,
                'society_id' => $societyId,
                'is_active' => 1,
            );
//          $parkingPlaceData = $this->parkingPlaceModel->getParkingPlaceData(array(
//              'is_active' => 1,
//              'society_id' => $societyId,
//              'is_multiple' => 1,
//          ));
            $parkingVehicleDataWise = array();
            $parkingAreaData = $this->parkingAreaModel->getParkingAreaData(array(
                'is_active' => 1,
                'society_id' => $societyId,
                'vehicle_type' => $vehicleType,
                'is_multiple' => 1,
                'start' => -1
            ));
            if (!empty($parkingAreaData)) {
                foreach ($parkingAreaData as $parkingAreaElement) {
                    $parkingAreaIdArray[] = $parkingAreaElement['parking_area_id'];
                }

                if(!empty($parkingAreaIdArray)){
                    $parkingVehicleData = $this->parkingAreaModel->getParkingVehicleData(array(
                        "parking_area_id" => $parkingAreaIdArray,
                        'vehicle_type' => $vehicleType,
                        "is_multiple" => 1
                    ));
                    if(!empty($parkingVehicleData)) {
                        foreach ($parkingVehicleData as $parkingVehicleElement) {
                            $parkingVehicleDataWise[$parkingVehicleElement['parking_area_id']][] = $parkingVehicleElement;
                        }
                    }
                    
                }
            }
            if (!empty($parkingAreaData)) {
                foreach ($parkingAreaData as $pKey => $parkingArea) {
                    $parkingAreaData[$pKey]['parking_vehicle_data'] = array_key_exists($parkingArea['parking_area_id'],$parkingVehicleDataWise) ? $parkingVehicleDataWise[$parkingArea['parking_area_id']]: array();
                }
            }
            // lastQuery();
            $availableParkingData = $this->parkingSlotModel->getParkingSlotData(array(
                'is_available_flat' => 1,
                'society_id' => $societyId,
                //'is_visitor_parking' => $isVisitorParking,
                'is_visitor_parking' => 1,
                'is_flat_owner' => 1,
                'is_available_visitor_approval_pending' => 1,
                'vehicle_type' => $vehicleType,
                'parking_area_id' => $parkingAreaId,
                'is_multiple' => 1,
                'search' => $search,
                'start' => -1
            ));

            if (!empty($availableParkingData)) {
                foreach ($availableParkingData as $key => $availableParkingElement) {
                    $availableParkingData[$key]['color_code'] = array_key_exists('free_slot', $legendsDataIdWise) ? $legendsDataIdWise['free_slot']['color_code'] : '';
                }
            }
            if (!empty($availableParkingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.ownership_flat_parking_listing_successfully'),
                    'parking_slot_data' => $parkingAreaData,
                    'data' => $availableParkingData,
                    'limit' => DATA_LIMIT,
                    "legends" => $legendsData,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'parking_slot_data' => $parkingAreaData,
                    'data' => $availableParkingData,
                    'limit' => DATA_LIMIT,
                    "legends" => $legendsData,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function getParkingList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $parkingAreaId = $this->request->getVar('parking_area_id');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $flatId = $this->request->getVar('flat_id');
        //$this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $legendsData = array(
                array(
                    'id' => 'flat_owner',
                    'name' => 'Flat',
                    'color_code' => FLAT_OWNER_COLOR_CODE,
                ),
                array(
                    'id' => 'visitor',
                    'name' => 'Visitor',
                    'color_code' => VISITOR_COLOR_CODE,
                ),
                array(
                    'id' => 'free_slot',
                    'name' => 'Free Slot',
                    'color_code' => FREE_SLOT_COLOR_CODE,
                )
            );

            $legendsDataIdWise = array();
            if (!empty($legendsData)) {
                foreach ($legendsData as $legendsElement) {
                    $legendsDataIdWise[$legendsElement['id']] = $legendsElement;
                }
            }
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                //'start' => $start,
                'search' => $search,
                'parking_slot_id' => $parkingSlotId,
                'society_id' => $societyId,
                'is_active' => 1,
            );

            $parkingAreaData = $this->parkingAreaModel->getParkingAreaData(array(
                'is_active' => 1,
                'society_id' => $societyId,
                'is_multiple' => 1,
            ));
            if (!empty($parkingAreaData)) {
                foreach ($parkingAreaData as $parkingAreaElement) {
                    $parkingAreaIdArray[] = $parkingAreaElement['parking_area_id'];
                }

                if(!empty($parkingAreaIdArray)){
                    $parkingVehicleData = $this->parkingAreaModel->getParkingVehicleData(array(
                        "parking_area_id" => $parkingAreaIdArray,
                        "is_multiple" => 1
                    ));
                    if(!empty($parkingVehicleData)) {
                        foreach ($parkingVehicleData as $parkingVehicleElement) {
                            $parkingVehicleDataWise[$parkingVehicleElement['parking_area_id']][] = $parkingVehicleElement;
                        }
                    }
                    
                }
            }
            if (!empty($parkingAreaData)) {
                foreach ($parkingAreaData as $pKey => $parkingArea) {
                    $parkingAreaData[$pKey]['parking_vehicle_data'] = array_key_exists($parkingArea['parking_area_id'],$parkingVehicleDataWise) ? $parkingVehicleDataWise[$parkingArea['parking_area_id']]: array();
                }
            }

            $allOwnerParkingData = $this->parkingSlotModel->getAllOwnerParkingData(array(
                'society_id' => $societyId,
                'parking_area_id' => $parkingAreaId,
                'flat_id' => $flatId,
                //'start' => $start,
                'search' => $search,
                'is_multiple' => 1,
            ));
            // 

            // if (!empty($allOwnerParkingData)) {
            //     $filteredOwnershipFlatMemberData = [];
            //     foreach ($allOwnerParkingData as $vKey => $allOwnerParkingData) {
            //         if ($allOwnerParkingData['type'] == 'rentals') {
            //             $rentalsData = $this->rentalModel->getRentalsMemberData(array(
            //                 'rentals_id' => $allOwnerParkingData['type_id'],
            //                 'check_rental_start' => 1,
            //             ));
            //             if (!empty($rentalsData)) {
            //                 $filteredOwnershipFlatMemberData[] = $allOwnerParkingData;
            //             }
            //         } else {
            //             $filteredOwnershipFlatMemberData[] = $allOwnerParkingData;
            //         }
            //     }
            //     $allOwnerParkingData = $filteredOwnershipFlatMemberData;
            // }
            $objectFilterData = array(
                'parking_slot_id' => array('parking_slot_id', 'number', 'display_block', 'parking_block_display'),
                'flat_id' => array('flat_id', 'flat_no'),
            );

            if (!empty($allOwnerParkingData)) {
                foreach ($allOwnerParkingData as $aoKey => $allOwnerParkingElement) {
                    $allOwnerParkingData[$aoKey] = getModuleObjectData($objectFilterData, $allOwnerParkingElement);
                    $allOwnerParkingData[$aoKey]['color_code'] = array_key_exists($allOwnerParkingElement['allocated_parking'], $legendsDataIdWise) ? $legendsDataIdWise[$allOwnerParkingElement['allocated_parking']]['color_code'] : '';
                }
            }

            if (!empty($allVisitorParkingData)) {
                foreach ($allVisitorParkingData as $avKey => $allVisitorParkingElement) {
                    $allVisitorParkingData[$avKey] = getModuleObjectData($objectFilterData, $allVisitorParkingElement);
                }
            }

            if (!empty($allOwnerParkingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.parking_listing_successfully'),
                    'data' => $allOwnerParkingData,
                    //'visitor_data' => $allVisitorParkingData,
                    'parking_slot_data' => $parkingAreaData,
                    'limit' => DATA_LIMIT,
                    "legends" => $legendsData,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $allOwnerParkingData,
                    //'visitor_data' => $allVisitorParkingData,
                    'parking_slot_data' => $parkingAreaData,
                    'limit' => DATA_LIMIT,
                    "legends" => $legendsData,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getStaticDropdownList()
    {
        $userId = $this->request->getVar('user_id');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $sosTypeArray = sosTypeAPI();

            if ($appType === GATE_KEEPER) {
                foreach ($sosTypeArray as $index => $item) {
                    if ($item['key'] === 'family') {
                        unset($sosTypeArray[$index]);
                    }
                }
            }
            $sosTypeArray = array_values($sosTypeArray);

            $staticTypeAsArray = array(
                'sos' => $sosTypeArray,
                'week_days' => weekDays(),
                'complain_type' => complainTypeApi(),
                'food_like' => foodLikeApi(),
                'vehicle_type' => vehicleTypeApi(),
                'blood_group_type' => bloodGroupTypeAPI(),
                'relation' => relationAPI(),
                'source' => sourceAPI(),
                'reading_type' => readingTypeAPI(),
            );
            // if (!empty($staticDropdownType) && $search != '' ) {
            //     foreach ($staticDropdownType as $staticDropdownTypeElement){
            //         if(strpos(strtolower($staticDropdownTypeElement['value']),strtolower($search)) !== false){
            //             $tempObjArray = array();
            //             $tempObjArray[$type] = $staticDropdownTypeElement['key'];
            //             $tempObjArray['display_'.$type] = $staticDropdownTypeElement['value'];
            //             array_push($staticTypeAsArray,$tempObjArray);
            //         }
            //     }
            // }else {
            //     foreach ($staticDropdownType as $staticDropdownTypeElement){
            //         $tempObjArray = array();
            //         $tempObjArray[$type] = $staticDropdownTypeElement['key'];
            //         $tempObjArray['display_'.$type] = $staticDropdownTypeElement['value'];
            //         array_push($staticTypeAsArray,$tempObjArray);
            //     }
            // }
            if (!empty($staticTypeAsArray)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.dropdown_listing_successfully'),
                    'data' => $staticTypeAsArray,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $staticTypeAsArray,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }

    }

    public function getVisitorCompanyList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $visitorCompanyType = $this->request->getVar('visitor_company_type');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'visitor_company_id' => $visitorCompanyId,
                'visitor_company_type' => $visitorCompanyType,
                'is_active' => 1,
            );
            $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData($filterArray);
            if (!empty($visitorCompanyData)) {
                foreach ($visitorCompanyData as $bkey => $visitorCompany) {
                    $visitorCompanyData[$bkey]['created_at'] = YMDToDMY($visitorCompany["created_at"], true);
                    $visitorCompanyData[$bkey]['updated_at'] = YMDToDMY($visitorCompany["updated_at"], true);
                    $visitorCompanyData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompany["visitor_company_type"]);
                    $visitorCompanyData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                    $visitorCompanyData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($visitorCompany['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                        $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                    }
                    if ($visitorCompany['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                    }
                    $visitorCompanyData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
                    $visitorCompanyData[$bkey]['visitor_company_image'] = $path;
                }
            }
            if (!empty($visitorCompanyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.visitor_company_listing_successfully'),
                    'data' => $visitorCompanyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $visitorCompanyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getCategoryList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $categoryId = $this->request->getVar('category_id');
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $categoryFor = $this->request->getVar('category_for');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            if(!empty($start)){
                $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            }
            else{
                $start = -1;
            }
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'category_id' => $categoryId,
                'category_for' => $categoryFor,
                'society_id' => $societyId,
                'is_active' => 1,
            );
            $categoryData = $this->categoryModel->getCategoryData($filterArray);
            if (!empty($categoryData)) {
                foreach ($categoryData as $bkey => $category) {
                    $categoryData[$bkey]['created_at'] = YMDToDMY($category["created_at"], true);
                    $categoryData[$bkey]['updated_at'] = YMDToDMY($category["updated_at"], true);
                    $categoryData[$bkey]['created_at_display'] = time_elapsed_string($category['created_at']);
                    $categoryData[$bkey]['updated_at_display'] = time_elapsed_string($category['created_at']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($category['category_image'] != '' && file_exists(CATEGORY_IMAGE_PATH . $category['category_image'])) {
                        $path = site_url() . CATEGORY_IMAGE_PATH . $category['category_image'];
                    }
                    if ($category['category_image'] != '' && file_exists(THUMBNAIL_CATEGORY_IMAGE_PATH . $category['category_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_CATEGORY_IMAGE_PATH . $category['category_image'];
                    }
                    $categoryData[$bkey]['thumbnail_category_image'] = $thumbnailPath;
                    $categoryData[$bkey]['category_image'] = $path;
                }
            }
            if (!empty($categoryData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.category_listing_successfully'),
                    'data' => $categoryData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $categoryData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getStatusList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $statusId = $this->request->getVar('status_id');
        $userId = $this->request->getVar('user_id');
        $statusFor = $this->request->getVar('status_for');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'status_id' => $statusId,
                'status_for' => $statusFor,
                'is_active' => 1,
            );
            $statusData = $this->statusModel->getStatusData($filterArray);
            if (!empty($statusData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.status_listing_successfully'),
                    'data' => $statusData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $statusData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function sendVisitorApprovalNotification()
    {
        $visitorId = $this->request->getVar('visitor_id');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $isStatusChange = $this->request->getVar('is_status_change');
        $appType = $this->request->getVar('app_type');

        $this->validation->setRule('visitor_id', lang('CommonWebService.visitor_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'visitor_id' => $visitorId,
                'is_deleted' => 0,
            );
            $visitorData = $this->visitorModel->getVisitorData($filterArray);
            if (!empty($visitorData)) {
                if (!empty($isStatusChange)) {
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'status' => 'waiting_for_approval',
                    );
                    $extraData = array();
                    $extraObj['api_user_id'] = $userId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorInsertData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData);
                }
                $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                    "document_type_id" => $visitorId,
                    "document_type" => 'visitor',
                ));
                $visitorImagePath = SITE_URL('uploads/no_image.png');
                if (!empty($visitorImageData)) {
                    if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                        $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                    }
                }
                $notificationArray = array(
                    'ownership_flat_member_id' => $visitorData['ownership_flat_member_id'],
                    'ownership_flat_id' => $visitorData['ownership_flat_id'],
                    'status' => 'waiting_for_approval',
                    'type' => $visitorData['type'],
                    'society_id' => $societyId,
                    'user_id' => $userId,
                    'type_id' => $visitorData['visitor_id'],
                    'visitor_name' => $visitorData['visitor_name'],
                    'module' => 'visitor',
                    'app_type' => GATE_KEEPER,
                    'mobile_no' => $visitorData['visitor_mobile_no'],
                    'display_status' => underscoreToUcWord('waiting_for_approval'),
                    'image' => $visitorImagePath,
                );
                $extraDatajson = json_encode($notificationArray);
                $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Member',
                    'society_id' => $this->session->get('society_id'),
                ));

                if ($appType == GATE_KEEPER) {
                    $notificationArray['send_for_notification'] = $appType;
                    $notificationArray['send_for_notification_id'] = $userId;
                    $notificationArray['receive_for_notification'] = $resourceTypeData['resource_type_id'];
                    $notificationArray['receive_for_notification_id'] = $visitorData['ownership_flat_member_id'];
                }

                if ($appType == MEMBER_APP) {
                    $notificationArray['send_for_notification'] = $appType;
                    $notificationArray['send_for_notification_id'] = $visitorData['ownership_flat_member_id'];
                    $notificationArray['receive_for_notification'] = $resourceTypeData['resource_type_id'];
                    $notificationArray['receive_for_notification_id'] = 0;
                }

                sendNotificationDataList($notificationArray, $extraDatajson);
            }
            $filterArray = array(
                'visitor_id' => $visitorId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            );
            $visitorListData = visitorListData($filterArray, $userId);
            if (!empty($visitorData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.notification_send_successfully'),
                    'data' => $visitorListData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteVisitor()
    {
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $visitorId = $this->request->getVar('visitor_id');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('visitor_id', lang('CommonWebService.visitor_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $visitorId = ($visitorId != '') ? explode(",", $visitorId) : '';
            $visitorRecordData = $this->visitorModel->getVisitorData(array(
                'visitor_id' => $visitorId,
            ));

            if (!empty($visitorRecordData)) {
                if ($visitorRecordData['status'] == 'entered' || $visitorRecordData['status'] == 'exited') {
                    $data = array(
                        'status' => False,
                        'message' => lang('CommonWebService.you_cant_delete_these_visitor') . underscoreToUcWord($visitorRecordData['status']),
                        'response_code' => 404,
                        'data' => null,
                    );
                    return $this->response($data, 404);
                }
            }
            $visitorData = $this->visitorModel->deleteVisitorRecord(array('visitor_id' => $visitorId, 'user_id' => $userId));
            if ($visitorData['success']) {
                if (!empty($visitorId)) {
                    foreach ($visitorId as $visitor) {
                        $deleteDataArray['module'] = 'Visitor';
                        $deleteDataArray['activity'] = "Visitor Deleted";
                        $deleteDataArray['module_id'] = $visitor;
                        logActivity('Visitor Deleted [VisitorID: ' . $visitor . ']', $userId, 'Visitor', $visitor, json_encode($deleteDataArray), '', 'Visitor', $visitor);
                    }
                }
                $this->db->transCommit();
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.visitor')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $this->db->transRollback();
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.visitor')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteMember()
    {
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $memberId = $this->request->getVar('member_id');
        $remarks = $this->request->getVar('remarks');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('member_id', lang('CommonWebService.member_id'), 'required');
        $this->validation->setRule('remarks', lang('CommonWebService.remarks'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $memberId = ($memberId != '') ? explode(",", $memberId) : '';


            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                'type' => 'member',
                'type_id' => $memberId,
                'society_id' => $societyId,
            ));

            // printArray($userSocietyData['user_society_id'],1);
            if(!empty($userSocietyData)){  
                // if(count($userSocietyData) == 1){
                    $this->commonWebserviceModel->deleteUserSocietyFlatRecord($userSocietyData['user_society_id'],$userId);
                // }
            }

            $ownershipFlatMemberDeleteData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $memberId,
                'is_multiple' => 1
            ));

            if(is_array($ownershipFlatMemberDeleteData) && !empty($ownershipFlatMemberDeleteData)){
                foreach ($ownershipFlatMemberDeleteData as $image){
                    $FileUrl = '';
                    if(isset($image['member_image']) && $image['member_image'] != '') {
                        $FileUrl = FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                    }
                    if (file_exists($FileUrl)) {
                        unlink($FileUrl);
                    }

                    $thumbnailFileUrl = '';
                    if(isset($image['member_image']) && $image['member_image'] != '') {
                        $thumbnailFileUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                    }
                    if (file_exists($thumbnailFileUrl)) {
                        unlink($thumbnailFileUrl);
                    }
                }
            }
            
            $memberRecordData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $memberId,
            ));
            $memberData = $this->ownershipFlatModel->deleteMemberRecord(array('member_id' => $memberId, 'user_id' => $userId, 'remarks' => $remarks));
            if ($memberData['success']) {
                if (!empty($memberId)) {
                    foreach ($memberId as $member) {
                        $deleteDataArray['module'] = 'Ownership Flat Member';
                        $deleteDataArray['activity'] = "Ownership Flat Member Deleted";
                        $deleteDataArray['module_id'] = $member;
                        logActivity('Ownership Flat Member Deleted [OwnershipFlatMemberID: ' . $member . ']', $userId, 'Ownership Flat Member', $member, json_encode($deleteDataArray), '', 'Ownership Flat Member', $member);
                    }
                }
                $this->db->transCommit();
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.member')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $this->db->transRollback();
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.member')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteVehicle()
    {
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $remarks = $this->request->getVar('remarks');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('ownership_flat_parking_id', lang('CommonWebService.ownership_flat_parking_id'), 'required');
        $this->validation->setRule('remarks', lang('CommonWebService.remarks'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $ownershipFlatParkingId = ($ownershipFlatParkingId != '') ? explode(",", $ownershipFlatParkingId) : '';
            $ownershipFlatParkingDeleteData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'is_multiple' => 1
            ));

            if(is_array($ownershipFlatParkingDeleteData) && !empty($ownershipFlatParkingDeleteData)){
                foreach ($ownershipFlatParkingDeleteData as $image){
                    $FileUrl = '';
                    if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                        $FileUrl = VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                    }
                    if (file_exists($FileUrl)) {
                        unlink($FileUrl);
                    }

                    $thumbnailFileUrl = '';
                    if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                        $thumbnailFileUrl = THUMBNAIL_VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                    }
                    if (file_exists($thumbnailFileUrl)) {
                        unlink($thumbnailFileUrl);
                    }
                }
            }
            $vehicleData = $this->ownershipFlatModel->deleteVehicleRecord(array('ownership_flat_parking_id' => $ownershipFlatParkingId, 'user_id' => $userId, 'remarks' => $remarks));
            if ($vehicleData['success']) {
                if (!empty($vehicleId)) {
                    foreach ($vehicleId as $vehicle) {
                        $deleteDataArray['module'] = 'Ownership Flat Vehicle';
                        $deleteDataArray['activity'] = "Ownership Flat Vehicle Deleted";
                        $deleteDataArray['module_id'] = $vehicle;
                        logActivity('Ownership Flat Vehicle Deleted [OwnershipFlatVehicleID: ' . $vehicle . ']', $userId, 'Ownership Flat Vehicle', $vehicle, json_encode($deleteDataArray), '', 'Ownership Flat Vehicle', $vehicle);
                    }
                }
                $this->db->transCommit();
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.vehicle')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $this->db->transRollback();
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.vehicle')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getNoticeList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $noticeId = $this->request->getVar('notice_id');
        $isRead = $this->request->getVar('is_read');
        $isBookmark = $this->request->getVar('is_bookmark');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $userId = $this->request->getVar('user_id');
        $type = $this->request->getVar('type');
        $categoryId = $this->request->getVar('category_id[]');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        // $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {

            $categoryData = $this->categoryModel->getCategoryData(array(
                'category_for' => 'notice',
                'is_multiple' => 1,
                'is_active' => 1,
            ));

            if (!empty($isRead) && !empty($noticeId)) {
                $noticeReadData = $this->commonWebserviceModel->getDocumentReadData(array(
                    "type" => 'notice',
                    "type_id" => $noticeId,
                    "ownership_flat_member_id" => $ownershipFlatMemberId,
                ));

                if (empty($noticeReadData)) {
                    $documentReadArray = array(
                        'document_read_id' => '',
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        "type" => 'notice',
                        'type_id' => $noticeId,
                    );
                    $extraData = array();
                    $extraObj['api_user_id'] = $ownershipFlatMemberId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $documentReadData = $this->commonWebserviceModel->insertUpdateRecord($documentReadArray, 'document_read_id', 'tbl_document_read', 1, '', array(), $extraData);
                }
            }
            $totalBookmarkData = $this->commonWebserviceModel->getTotalBookmarkData(array(
                'type' => 'notice',
                'ownership_flat_member_id' => $ownershipFlatMemberId
            ));
            $totalBookmark = isset($totalBookmarkData['total_bookmark']) ? $totalBookmarkData['total_bookmark'] : 0;
            $totalUnreadData = $this->commonWebserviceModel->getTotalUnreadData(array(
                'type' => 'notice',
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            ));
            $totalUnread = isset($totalUnreadData['total_unread']) ? $totalUnreadData['total_unread'] : 0;
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'type' => $type,
                'society_id' => $societyId,
                'notice_id' => $noticeId,
                'category_id' => $categoryId,
                'is_bookmark' => $isBookmark,
                'is_check_expiry_date' => date("Y-m-d"),
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $noticeData = $this->noticeModel->getNoticeData($filterArray);
            $noticeDocumentDataWise = array();
            $noticeCategoryDataWise = array();
            $noticeBookmarkDataWise = array();
            $noticeIdArray = array();
            if (!empty($noticeData)) {
                foreach ($noticeData as $noticeElement) {
                    $noticeIdArray[] = $noticeElement['notice_id'];
                }
                if (!empty($noticeIdArray)) {
                    $noticeCategoryData = $this->noticeModel->getNoticeCategoryData(array(
                        "notice_id" => $noticeIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($noticeCategoryData)) {
                        foreach ($noticeCategoryData as $noticeCategoryElement) {
                            $noticeCategoryDataWise[$noticeCategoryElement['notice_id']][] = $noticeCategoryElement;
                        }
                    }
                    $noticeBookmarkData = $this->noticeModel->getBookmarkData(array(
                        "type" => 'notice',
                        "type_id" => $noticeIdArray,
                        "ownership_flat_member_id" => $ownershipFlatMemberId,
                        "is_multiple" => 1,
                        "is_bookmark" => 1,
                    ));
                    if (!empty($noticeBookmarkData)) {
                        foreach ($noticeBookmarkData as $noticeBookmarkElement) {
                            $noticeBookmarkDataWise[$noticeBookmarkElement['type_id']][] = $noticeBookmarkElement;
                        }
                    }
                    $noticeImageData = $this->mediaModel->getMediaData(array(
                        "media_for_id" => $noticeIdArray,
                        "media_for" => 'notice',
                        "is_multiple" => 1
                    ));
                    if (!empty($noticeImageData)) {
                        foreach ($noticeImageData as $noticeImageElement) {
                            if ($noticeImageElement["media_file"] == '') {
                                $noticeImageElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                                $noticeImageElement["media_file"] = SITE_URL('uploads/no_image.png');
                            } else {
                                if($noticeImageElement['media_type'] == 'image'){
                                    $noticeImageElement["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $noticeImageElement["media_file"];
                                }
                                else{
                                    $noticeImageElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                                }
                                $noticeImageElement["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $noticeImageElement["media_file"];
                            }
                            $noticeDocumentDataWise[$noticeImageElement['media_for_id']][] = $noticeImageElement;
                        }
                    }
                }
            }
            if (!empty($noticeData)) {
                foreach ($noticeData as $nKey => $notice) {
                    //$noticeData[$nKey]["notice_date_display"] = isValidDate($notice['notice_date']) ? date('d M Y, H:i A', strtotime($notice["notice_date"])) : "";
                    $noticeData[$nKey]["notice_date_display"] = isValidDate($notice['notice_date']) ? date('d M Y', strtotime($notice["notice_date"])) : "";
                    $noticeData[$nKey]['created_at'] = isValidDate($notice['created_at']) ? YMDToDMY($notice["created_at"], true) : "";
                    $noticeData[$nKey]['updated_at'] = isValidDate($notice['updated_at']) ? YMDToDMY($notice["updated_at"], true) : "";
                    $noticeData[$nKey]['created_at_display'] = time_elapsed_string($notice['created_at']);
                    $noticeData[$nKey]['updated_at_display'] = time_elapsed_string($notice['updated_at']);
                    $noticeData[$nKey]['notice_bookmark_data'] = array_key_exists($notice['notice_id'], $noticeBookmarkDataWise) ? $noticeBookmarkDataWise[$notice['notice_id']] : array();
                    $noticeData[$nKey]['notice_category_data'] = array_key_exists($notice['notice_id'], $noticeCategoryDataWise) ? $noticeCategoryDataWise[$notice['notice_id']] : array();
                    $noticeData[$nKey]['notice_image_data'] = array_key_exists($notice['notice_id'], $noticeDocumentDataWise) ? $noticeDocumentDataWise[$notice['notice_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $noticeData[$nKey]['share_data'] = $shareData;
                }
            }
            if (!empty($noticeData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.notice_listing_successfully'),
                    'total_bookmark_count' => $totalBookmark,
                    'total_unread_count' => $totalUnread,
                    'category_data' => $categoryData,
                    'data' => $noticeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'total_bookmark_count' => $totalBookmark,
                    'total_unread_count' => $totalUnread,
                    'category_data' => $categoryData,
                    'data' => $noticeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getNotificationList()
    {
        $appType = $this->request->getVar('app_type');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $notificationId = $this->request->getVar('notification_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        // $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if ($appType == MEMBER_APP) {
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'notification_id' => $notificationId,
                //'type' => 'notification',
            );
            if ($appType == GATE_KEEPER) {
                $filterArray['receive_for_notification'] = GATE_KEEPER;
                $filterArray['receive_for_notification_id'] = $userId;
            }
            if ($appType == MEMBER_APP) {
                $filterArray['receive_for_notification'] = MEMBER_APP;
                $filterArray['receive_for_notification_id'] = $ownershipFlatMemberId;
            }

            if ($appType == MANAGER_APP) {
                $filterArray['receive_for_notification'] = MANAGER_APP;
                $filterArray['receive_for_notification_id'] = $userId;
            }

            $notificationData = $this->notificationModel->getNotificationData($filterArray);
            $notificationDocumentDataWise = array();
            $notificationIdArray = array();
            if (!empty($notificationData)) {
                foreach ($notificationData as $notificationElement) {
                    $notificationIdArray[] = $notificationElement['notification_id'];
                }
                if (!empty($notificationIdArray)) {
                    $notificationImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $notificationIdArray,
                        "document_type" => 'notification',
                        "is_multiple" => 1
                    ));
                    if (!empty($notificationImageData)) {
                        foreach ($notificationImageData as $notificationImageElement) {
                            if ($notificationImageElement["document_image"] == '') {
                                $notificationImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $notificationImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $notificationImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $notificationImageElement["document_image"];
                                $notificationImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $notificationImageElement["document_image"];
                            }
                            $notificationDocumentDataWise[$notificationImageElement['document_type_id']][] = $notificationImageElement;
                        }
                    }
                }
            }
            if (!empty($notificationData)) {
                foreach ($notificationData as $vKey => $notification) {
                    $notificationData[$vKey]['created_at'] = isValidDate($notification['created_at']) ? YMDToDMY($notification["created_at"], true) : "";
                    $notificationData[$vKey]['updated_at'] = isValidDate($notification['updated_at']) ? YMDToDMY($notification["updated_at"], true) : "";
                    $notificationData[$vKey]['notifiation_time_display'] = isValidDate($notification['created_at']) ? date("h:i A", strtotime($notification['created_at'])) : "";

                    $notificationData[$vKey]["notification_date_display"] = isValidDate($notification['notification_date']) ? date('d M Y', strtotime($notification["notification_date"])) : "";
                    $notificationData[$vKey]['created_at_display'] = time_elapsed_string($notification['created_at']);
                    $notificationData[$vKey]['updated_at_display'] = time_elapsed_string($notification['updated_at']);
                    $notificationData[$vKey]['notification_image_data'] = array_key_exists($notification['notification_id'], $notificationDocumentDataWise) ? $notificationDocumentDataWise[$notification['notification_id']] : array();
                }
            }
            if (!empty($notificationData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.notification_listing_successfully'),
                    'data' => $notificationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $notificationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditBookmark()
    {
        $this->db->transBegin();
        $userId = $this->request->getVar('user_id');
        $isBookmark = $this->request->getVar('is_bookmark');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $typeId = $this->request->getVar('type_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('type', lang('CommonWebService.type'), 'required|alpha');
        $this->validation->setRule('type_id', lang('CommonWebService.type_id'), 'required|numeric');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $filterArray = array(
                'is_multiple' => 1,
                'type' => $type,
                'type_id' => $typeId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $bookmarkData = $this->noticeModel->getBookmarkData($filterArray);
            $bookmarkIdArray = array();
            if (!empty($bookmarkData)) {
                foreach ($bookmarkData as $bookmarkElement) {
                    array_push($bookmarkIdArray, $bookmarkElement['bookmark_id']);
                }
            }
            if (!empty($bookmarkIdArray)) {
                $this->noticeModel->deleteBookmarkRecord($bookmarkIdArray);
            }
            if ($isBookmark == 0) {
                $totalBookmarkData = $this->commonWebserviceModel->getTotalBookmarkData(array(
                    'type' => $type,
                    'type_id' => $typeId,
                ));
                $totalBookmark = isset($totalBookmarkData['total_bookmark']) ? $totalBookmarkData['total_bookmark'] : 0;
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.un_bookmark')),
                    'data' => null,
                    'total_bookmark' => (int)$totalBookmark
                ), 200);
            } else {
                $bookmarkArray = array(
                    'bookmark_id' => '',
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'type' => $type,
                    'type_id' => $typeId,
                    'society_id' => $societyId
                );
                $extraData = array();
                $extraObj['api_user_id'] = $userId;
                $extraObj['society_id'] = $societyId;
                $extraData['is_api_data'] = $extraObj;
                $bookmarkData = $this->commonWebserviceModel->insertUpdateRecord($bookmarkArray, 'bookmark_id', 'tbl_bookmark', 1, '', array(), $extraData);
                $lastBookmarkId = $bookmarkData['lastInsertedId'];
                $totalBookmarkData = $this->commonWebserviceModel->getTotalBookmarkData(array(
                    'type' => $type,
                    'type_id' => $typeId,
                ));
                $totalBookmark = isset($totalBookmarkData['total_bookmark']) ? $totalBookmarkData['total_bookmark'] : 0;
                if (isset($bookmarkData['success']) && $bookmarkData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.bookmark')),
                        'data' => null,
                        'total_bookmark' => (int)$totalBookmark
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed'), lang('CommonWebService.bookmark')),
                        'data' => null,
                        'total_bookmark' => (int)$totalBookmark
                    ), 400);
                }
            }

        }
    }

    public function addEditPollVotes()
    {
        $this->db->transBegin();
        $userId = $this->request->getVar('user_id');
        $pollOptionIdArray = $this->request->getVar('poll_option_id');
        $pollId = $this->request->getVar('poll_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('poll_id', lang('CommonWebService.poll_id'), 'required|numeric');
        $this->validation->setRule('poll_option_id.*', lang('CommonWebService.poll_option_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $pollData = $this->pollModel->getPollData(array(
                'poll_id' => $pollId,
            ));
            $todayDate = date('Y-m-d');
            if (!empty($pollData)) {
                $pollEndDate = $pollData['end_date'];
                if ($pollEndDate < $todayDate) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 400,
                        'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.poll_ended')),
                        'data' => null,
                    ), 400);
                }
            }

            $filterArray = array(
                'is_multiple' => 1,
                // 'poll_option_id' => $pollOptionIdArray,
                'poll_id' => $pollId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $pollVotesData = $this->pollModel->getPollVotesData($filterArray);
            $pollVotesIdArray = array();
            if (!empty($pollVotesData)) {
                foreach ($pollVotesData as $pollVotesElement) {
                    array_push($pollVotesIdArray, $pollVotesElement['poll_votes_id']);
                }
            }
            if (!empty($pollVotesIdArray)) {
                $this->pollModel->deletePollVotesRecord($pollVotesIdArray);
            }
            // if(!empty($pollVotesData)){
            //  $totalPollVotesData = $this->pollModel->getTotalPollVotesData(array(
            //      'poll_id' => $pollId,
            //      // 'type_id' => $typeId,
            //  ));
            //  $totalPollVotes = isset($totalPollVotesData['total_poll_votes']) ? $totalPollVotesData['total_poll_votes']: 0;
            //  $this->db->transCommit();
            //  return $this->response(array(
            //      'status' => true,
            //      'response_code' => 200,
            //      'message' => sprintf(lang('CommonWebService.successfully'),lang('CommonWebService.un_poll')),
            //      'data' => null,
            //      'total_poll_votes' => (int) $totalPollVotes
            //  ), 200);
            // }
            $pollOptionIdDataArray = implode(',', $pollOptionIdArray);
            $pollOptionIdDataArray = explode(',', $pollOptionIdDataArray);
            if (!empty($pollOptionIdDataArray)) {
                foreach ($pollOptionIdDataArray as $pollOptionId) {
                    $pollVotesArray = array(
                        'poll_votes_id' => '',
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'poll_option_id' => $pollOptionId,
                        'poll_id' => $pollId,
                    );
                    $extraData = array();
                    $extraObj['api_user_id'] = $userId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $pollVotesData = $this->commonWebserviceModel->insertUpdateRecord($pollVotesArray, 'poll_votes_id', 'tbl_poll_votes', 1, '', array(), $extraData);
                    $lastPollVotesId = $pollVotesData['lastInsertedId'];
                }
            }
            $totalPollVotesData = $this->pollModel->getTotalPollVotesData(array(
                'poll_id' => $pollId,
                // 'type_id' => $typeId,
            ));
            $totalPollVotes = isset($totalPollVotesData['total_poll_votes']) ? $totalPollVotesData['total_poll_votes'] : 0;
            if (isset($pollVotesData['success']) && $pollVotesData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.poll_votes')),
                    'data' => null,
                    'total_poll_votes' => (int)$totalPollVotes
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed'), lang('CommonWebService.poll_votes')),
                    'data' => null,
                    'total_poll_votes' => (int)$totalPollVotes
                ), 400);
            }
        }
    }

    public function addEditVisitorCompany()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $validation = \Config\Services::validation();
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $visitorCompanyType = $this->request->getVar('visitor_company_type');
        $societyId = $this->request->getVar('society_id');
        $visitorCompanyName = $this->request->getVar('visitor_company_name');
        $visitorCompanyImage = $this->request->getVar('visitor_company_image');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('visitor_company_name', lang('CommonWebService.visitor_company_name'), 'required');
        $this->validation->setRule('visitor_company_type', lang('CommonWebService.visitor_company_type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {

            $visitorCompanyForNameCheck = $this->visitorCompanyModel->checkVisitorCompanyNameExist(array('visitor_company_id' => $visitorCompanyId, 'visitor_company_name' => $visitorCompanyName, 'visitor_company_type' => $visitorCompanyType));

            if (!empty($visitorCompanyForNameCheck)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => "This Visitor Company Type " . underscoreToUcWord($visitorCompanyForNameCheck['visitor_company_type']) . " Visitor Company Name " . $visitorCompanyName . " Already Exists",
                    'data' => null
                ), 404);
            }

            
            if (isset($_FILES["visitor_company_image"])) {
                $visitorCompanyImagePath = VISITOR_COMPANY_IMAGE_PATH;
                $visitorCompanyImageResult = $dt_ci_file_upload->uploadFile('visitor_company_image', MAX_IMAGE_SIZE_LIMIT, $visitorCompanyImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($visitorCompanyImageResult['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($visitorCompanyImageResult['message']),
                        'data' => null
                    ), 404);
                } else {
                    $visitorCompanyImageRecord = $visitorCompanyImageResult['file_name'];
                    unset($visitorCompanyImageResult['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($visitorCompanyImageResult, VISITOR_COMPANY_IMAGE_PATH, THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH);
                }
            }    
            $visitorCompanyUpdateArray = array();
            $visitorCompanyArray = array(
                'visitor_company_id' => $visitorCompanyId,
                'visitor_company_type' => $visitorCompanyType,
                'visitor_company_name' => $visitorCompanyName,
                'is_active' => 1,
            );
            if (isset($_FILES["visitor_company_image"])) {
                if ($visitorCompanyId != '') {
                    $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData(array('visitor_company_id' => $visitorCompanyId));
                    if ($visitorCompanyData['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyData['visitor_company_image'])) {
                        unlink(VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyData['visitor_company_image']);
                    }
                    if ($visitorCompanyData['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyData['visitor_company_image'])) {
                        unlink(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyData['visitor_company_image']);
                    }
                }
                $visitorCompanyArray['visitor_company_image'] = $visitorCompanyImageResult['file_name'];
            }
            if (!empty($visitorCompanyId)) {
                $visitorCompanyUpdateData = $this->visitorCompanyModel->getVisitorCompanyData(array(
                    'visitor_company_id' => $visitorCompanyId,
                ));
                $visitorCompanyUpdateArray = compareArray($visitorCompanyArray, $visitorCompanyUpdateData);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $visitorCompanyData = $this->commonWebserviceModel->insertUpdateRecord($visitorCompanyArray, 'visitor_company_id', 'tbl_visitor_company', 1, '', array(), $extraData, $visitorCompanyUpdateArray);
            $lastVisitorCompanyId = $visitorCompanyData['lastInsertedId'];
            $visitorCompanyListData = $this->visitorCompanyModel->getVisitorCompanyData(array(
                'visitor_company_id' => $lastVisitorCompanyId,
                'is_multiple' => 1,
            ));
            if (!empty($visitorCompanyListData)) {
                foreach ($visitorCompanyListData as $bkey => $visitorCompanyList) {
                    $visitorCompanyListData[$bkey]['created_at'] = YMDToDMY($visitorCompanyList["created_at"], true);
                    $visitorCompanyListData[$bkey]['updated_at'] = YMDToDMY($visitorCompanyList["updated_at"], true);
                    $visitorCompanyListData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompanyList["visitor_company_type"]);
                    $visitorCompanyListData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompanyList['created_at']);
                    $visitorCompanyListData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompanyList['created_at']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($visitorCompanyList['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyList['visitor_company_image'])) {
                        $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyList['visitor_company_image'];
                    }
                    if ($visitorCompanyList['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyList['visitor_company_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyList['visitor_company_image'];
                    }
                    $visitorCompanyListData[$bkey]['visitor_company_image'] = $path;
                    $visitorCompanyListData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
                }
            }
            if (isset($visitorCompanyId) && !empty($visitorCompanyId)) {
                if (isset($visitorCompanyData['success']) && $visitorCompanyData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.visitor_company')),
                        'data' => $visitorCompanyListData,
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.visitor_company')),
                        'data' => $visitorCompanyListData,
                    ), 404);
                }
            } else {
                if (isset($visitorCompanyData['success']) && $visitorCompanyData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.visitor_company')),
                        'data' => $visitorCompanyListData,
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.visitor_company')),
                        'data' => $visitorCompanyListData,
                    ), 400);
                }
            }
        }
    }

    public function getPollList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $pollId = $this->request->getVar('poll_id');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $pollType = $this->request->getVar('poll_type');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'poll_id' => $pollId,
                'society_id' => $societyId,
            );
            $pollData = $this->pollModel->getPollData($filterArray);
            $pollOptionDataWise = array();
            $pollVotesDataWise = array();
            $pollIdArray = array();
            if (!empty($pollData)) {
                foreach ($pollData as $pollElement) {
                    $pollIdArray[] = $pollElement['poll_id'];
                }
                if (!empty($pollIdArray)) {
                    $pollOptionData = $this->pollModel->getPollOptionData(array(
                        "poll_id" => $pollIdArray,
                        "ownership_flat_member_id" => $ownershipFlatMemberId,
                        "is_multiple" => 1
                    ));
                    if (!empty($pollOptionData)) {
                        foreach ($pollOptionData as $pollOptionElement) {
                            $pollOptionDataWise[$pollOptionElement['poll_id']][] = $pollOptionElement;
                        }
                    }
                    $pollVotesData = $this->pollModel->getPollVotesData(array(
                        "poll_id" => $pollIdArray,
                        "ownership_flat_member_id" => $ownershipFlatMemberId,
                        "is_multiple" => 1,
                    ));
                    if (!empty($pollVotesData)) {
                        foreach ($pollVotesData as $pollVotesElement) {
                            $pollVotesDataWise[$pollVotesElement['poll_id']][] = $pollVotesElement;
                        }
                    }
                }
            }
            if (!empty($pollData)) {
                foreach ($pollData as $pKey => $poll) {
                    $pollData[$pKey]["start_date_display"] = isValidDate($poll['start_date']) ? date('d M Y', strtotime($poll["start_date"])) : "";
                    $pollData[$pKey]["end_date_display"] = isValidDate($poll['end_date']) ? date('d M Y', strtotime($poll["end_date"])) : "";
                    $pollData[$pKey]['created_at'] = YMDToDMY($poll["created_at"], true);
                    $pollData[$pKey]['updated_at'] = YMDToDMY($poll["updated_at"], true);
                    $pollData[$pKey]['created_at_display'] = time_elapsed_string($poll['created_at']);
                    $pollData[$pKey]['updated_at_display'] = time_elapsed_string($poll['updated_at']);
                    $pollData[$pKey]['poll_option_data'] = array_key_exists($poll['poll_id'], $pollOptionDataWise) ? $pollOptionDataWise[$poll['poll_id']] : array();
                    $pollData[$pKey]['poll_votes_data'] = array_key_exists($poll['poll_id'], $pollVotesDataWise) ? $pollVotesDataWise[$poll['poll_id']] : array();
                }
            }
            $currentCompletedPollWiseData = array();
            $completedPoll = array();
            $currentPoll = array();
            if (!empty($pollData)) {
                foreach ($pollData as $key => $pollElement) {
                    // if($pollType == 'completed_poll'){
                        if (strtotime(TODAY_DATE) > strtotime($pollElement['end_date'])) {
                            $pollElement['poll_status'] = 'Ended';
                            array_push($completedPoll, $pollElement);
                        } else {
                    // }
                    // if($pollType == 'current_poll') {
                        $pollElement['poll_status'] = 'Ongoing';
                        array_push($currentPoll, $pollElement);
                        }
                    // }
                }
            }
            if($pollType == 'current_poll'){
                $currentCompletedPollWiseData = $currentPoll;
            }
            if($pollType == 'completed_poll'){
                $currentCompletedPollWiseData = $completedPoll;
            }
            if (!empty($currentCompletedPollWiseData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.poll_listing_successfully'),
                    'data' => $currentCompletedPollWiseData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $currentCompletedPollWiseData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getDocumentFolderList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $documentFolderId = $this->request->getVar('document_folder_id');
        $isFolderDetail = $this->request->getVar('is_folder_detail');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $appType = $this->request->getVar('app_type');

        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'document_folder_id' => $documentFolderId,
            );
            $documentFolderData = $this->documentFolderModel->getDocumentFolderData($filterArray);
            $documentFolderDocumentDataWise = array();
            $documentFolderItemDataWise = array();
            $documentFolderIdArray = array();
            $documentFolderItemIdArray = array();
            if (!empty($isFolderDetail)) {
                if (!empty($documentFolderData)) {
                    foreach ($documentFolderData as $documentFolderElement) {
                        $documentFolderIdArray[] = $documentFolderElement['document_folder_id'];
                    }
                    if (!empty($documentFolderIdArray)) {
                        $documentFolderItemData = $this->documentFolderModel->getDocumentFolderItemData(array(
                            "document_folder_id" => $documentFolderIdArray,
                            "is_multiple" => 1,
                        ));
                        if (!empty($documentFolderItemData)) {
                            foreach ($documentFolderItemData as $documentFolderItemElement) {
                                $documentFolderItemIdArray[] = $documentFolderItemElement['document_folder_item_id'];
                            }
                        }
                        if (!empty($documentFolderItemIdArray)) {
                            $documentFolderImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $documentFolderItemIdArray,
                                "document_type" => 'document_folder',
                                "is_multiple" => 1
                            ));
                            if (!empty($documentFolderImageData)) {
                                foreach ($documentFolderImageData as $documentFolderImageElement) {

                                    $extension = explode('.', $documentFolderImageElement["document_image"]);
                                    if (!empty($extension)) {
                                        foreach ($extension as $extensionElement) {
                                            if ($extensionElement == 'pdf') {
                                                $documentFolderImageElement["icon_image"] = site_url('uploads/pdf_image.jpg');
                                            } else {
                                                $documentFolderImageElement["icon_image"] = site_url('uploads/no_image.png');
                                            }
                                        }
                                    }
                                    if ($documentFolderImageElement["document_image"] == '') {
                                        $documentFolderImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                        $documentFolderImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                    } else {
                                        if (!empty($extension)) {
                                            foreach ($extension as $extensionElement) {
                                                if ($extensionElement == 'pdf') {

                                                    $documentFolderImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                                }
                                                else{
                                                    $documentFolderImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $documentFolderImageElement["document_image"];
                                                }
                                            }
                                        }
                                        $documentFolderImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $documentFolderImageElement["document_image"];
                                    }
                                    $documentFolderDocumentDataWise[$documentFolderImageElement['document_type_id']][] = $documentFolderImageElement;
                                }
                            }
                        }
                    }
                }
                if (!empty($documentFolderItemData)) {
                    foreach ($documentFolderItemData as $vKey => $documentFolderItem) {
                        $documentFolderItemData[$vKey]['document_folder_item_image_data'] = array_key_exists($documentFolderItem['document_folder_item_id'], $documentFolderDocumentDataWise) ? $documentFolderDocumentDataWise[$documentFolderItem['document_folder_item_id']] : array();
                    }
                }
                if (isset($documentFolderItemData) && !empty($documentFolderItemData)) {
                    foreach ($documentFolderItemData as $documentFolderItemElement) {
                        $documentFolderItemElement['effective_date_display'] = isValidDate($documentFolderItemElement['effective_date']) ? date("d F, Y", strtotime($documentFolderItemElement['effective_date'])) : "";
                        $documentFolderItemElement['effective_time_display'] = isValidDate($documentFolderItemElement['created_at']) ? date("h:i A", strtotime($documentFolderItemElement['created_at'])) : "";
                        $documentFolderItemDataWise[$documentFolderItemElement['document_folder_id']][] = $documentFolderItemElement;
                    }
                }
            }
            if (!empty($documentFolderData)) {
                foreach ($documentFolderData as $vKey => $documentFolder) {
                    $documentFolderData[$vKey]['created_at'] = isValidDate($documentFolder['created_at']) ? YMDToDMY($documentFolder["created_at"], true) : "";
                    $documentFolderData[$vKey]['updated_at'] = isValidDate($documentFolder['updated_at']) ? YMDToDMY($documentFolder["updated_at"], true) : "";
                    $documentFolderData[$vKey]['created_at_display'] = time_elapsed_string($documentFolder['created_at']);
                    $documentFolderData[$vKey]['updated_at_display'] = time_elapsed_string($documentFolder['updated_at']);
                    $documentFolderData[$vKey]['document_folder_item_data'] = array_key_exists($documentFolder['document_folder_id'], $documentFolderItemDataWise) ? $documentFolderItemDataWise[$documentFolder['document_folder_id']] : array();
                }
            }
            if (!empty($documentFolderData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.document_folder_listing_successfully'),
                    'data' => $documentFolderData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $documentFolderData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getBannerList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $bannerId = $this->request->getVar('banner_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'banner_id' => $bannerId,
                'date_greater_than_equal_to' => TODAY_DATE_YMD,
            );
            $bannerData = $this->bannerModel->getBannerData($filterArray);
            $bannerImageDataWise = array();
            $bannerIdArray = array();
            if (!empty($bannerData)) {
                foreach ($bannerData as $bannerElement) {
                    $bannerIdArray[] = $bannerElement['banner_id'];
                }
                if (!empty($bannerIdArray)) {
                    $bannerImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $bannerIdArray,
                        "document_type" => 'banner',
                        "is_multiple" => 1
                    ));
                    if (!empty($bannerImageData)) {
                        foreach ($bannerImageData as $bannerImageElement) {
                            if ($bannerImageElement["document_image"] == '') {
                                $bannerImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $bannerImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $bannerImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
                                $bannerImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
                            }
                            $bannerImageDataWise[$bannerImageElement['document_type_id']][] = $bannerImageElement;
                        }
                    }
                }
            }
            if (!empty($bannerData)) {
                foreach ($bannerData as $vKey => $banner) {
                    $bannerData[$vKey]['created_at'] = isValidDate($banner['created_at']) ? YMDToDMY($banner["created_at"], true) : "";
                    $bannerData[$vKey]['updated_at'] = isValidDate($banner['updated_at']) ? YMDToDMY($banner["updated_at"], true) : "";
                    $bannerData[$vKey]['created_at_display'] = time_elapsed_string($banner['created_at']);
                    $bannerData[$vKey]['updated_at_display'] = time_elapsed_string($banner['updated_at']);
                    $bannerData[$vKey]["start_date_display"] = isValidDate($banner['start_date']) ? date('d F, Y', strtotime($banner["start_date"])) : "";
                    $bannerData[$vKey]["end_date_display"] = isValidDate($banner['end_date']) ? date('d F, Y', strtotime($banner["end_date"])) : "";
                    $bannerData[$vKey]['banner_image_data'] = array_key_exists($banner['banner_id'], $bannerImageDataWise) ? $bannerImageDataWise[$banner['banner_id']] : array();
                }
            }
            if (!empty($bannerData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.banner_listing_successfully'),
                    'data' => $bannerData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $bannerData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

//     public function getDashboardList()
//     {
//         $societyId = $this->request->getVar('society_id');
//         $userId = $this->request->getVar('user_id');
//         $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
//         $ownershipFlatId = $this->request->getVar('ownership_flat_id');
//         $isCustomerApp = $this->request->getVar('is_customer_app');
//         $appType = $this->request->getVar('app_type');
//         $deviceId = $this->request->getVar('device_id');
//         $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
//         $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
//         $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
//         if (!$this->validation->withRequest($this->request)->run()) {
//             $errors = $this->validation->getErrors();
//             return $this->response(array(
//                 'status' => FALSE,
//                 'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
//                 'data' => null,
//                 'limit' => DATA_LIMIT,
//                 'response_code' => 400,
//             ), 400);
//         } else {

//             if($appType == MEMBER_APP){
//                 $notificationDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
//                     'ownership_flat_member_id' => $ownershipFlatMemberId,
//                     'society_id' => $societyId,
//                     'device_id' => $deviceId,
//                 ));

//                 if(empty($notificationDevice)){
//                     $notificationTypeData = $this->commonWebserviceModel->getNotificationTypeData(array(
//                         'is_multiple' => 1,
//                     ));

//                     if(!empty($notificationTypeData)){
//                         $notificationArray = array();
//                         foreach($notificationTypeData as $notificationElement){
//                             $notificationTypeArray = array(
//                                 'user_device_notification_config_id' => '',
//                                 'device_id' => $deviceId,
//                                 'society_id' => $societyId,
//                                 'ownership_flat_member_id' => $ownershipFlatMemberId,
//                                 'notification_type_id' => $notificationElement['notification_type_id'],
//                                 'is_enabled' => 1,
//                                 'created_by' => $userId,
//                                 'updated_by' => $userId,
//                                 'created_at' => date("Y-m-d H:i:s"),
//                                 'updated_at' => date("Y-m-d H:i:s"),
//                             );
//                             array_push($notificationArray, $notificationTypeArray);
//                         }
//                         $this->commonWebserviceModel->batchInsert($notificationArray, 'tbl_user_device_notification_config');
//                     }
//                 }
//             }

//             $legendsData = array(
//                 array(
//                     'id' => 'entered',
//                     'name' => 'Entered',
//                     'color_code' => ENTERED_COLOR_CODE,
//                 ),
//                 array(
//                     'id' => 'entry_pre_approve',
//                     'name' => 'Entry Pre Approve',
//                     'color_code' => ENTERED_COLOR_CODE,
//                 ),
//                 array(
//                     'id' => 'collected',
//                     'name' => 'Collected',
//                     'color_code' => ENTERED_COLOR_CODE,
//                 ),
//                 array(
//                     'id' => 'delivered',
//                     'name' => 'Delivered',
//                     'color_code' => EXITED_COLOR_CODE,
//                 ),
//                 array(
//                     'id' => 'exited',
//                     'name' => 'Exited',
//                     'color_code' => EXITED_COLOR_CODE,
//                 ),
//                 array(
//                     'id' => 'approval_rejected',
//                     'name' => 'Approval Rejected',
//                     'color_code' => EXITED_COLOR_CODE,
//                 ),
//                 array(
//                     'id' => 'approval_pending',
//                     'name' => 'APPROVAL Pending',
//                     'color_code' => PENDING_COLOR_CODE,
//                 )
//             );

//             $legendsDataIdWise = array();
//             if (!empty($legendsData)) {
//                 foreach ($legendsData as $legendsElement) {
//                     $legendsDataIdWise[$legendsElement['id']] = $legendsElement;
//                 }
//             }

//             $filterArray = array(
//                 'is_multiple' => 1,
//                 'is_active' => 1,
//                 'society_id' => $societyId,
//                 'date_greater_than_equal_to' => TODAY_DATE_YMD,
//             );
//             $bannerData = $this->bannerModel->getBannerData($filterArray);
//             $bannerImageDataWise = array();
//             $bannerIdArray = array();
//             $ownershipMemberFlatData = array();
//             if (!empty($bannerData)) {
//                 foreach ($bannerData as $bannerElement) {
//                     $bannerIdArray[] = $bannerElement['banner_id'];
//                 }
//                 if (!empty($bannerIdArray)) {
//                     $bannerImageData = $this->visitorModel->getDocumentImageData(array(
//                         "document_type_id" => $bannerIdArray,
//                         "document_type" => 'banner',
//                         "is_multiple" => 1
//                     ));
//                     if (!empty($bannerImageData)) {
//                         foreach ($bannerImageData as $bannerImageElement) {
//                             if ($bannerImageElement["document_image"] == '') {
//                                 $bannerImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
//                                 $bannerImageElement["document_image"] = SITE_URL('uploads/no_image.png');
//                             } else {
//                                 $bannerImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
//                                 $bannerImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
//                             }
//                             $bannerImageDataWise[$bannerImageElement['document_type_id']][] = $bannerImageElement;
//                         }
//                     }

//                 }
//             }
//             if (!empty($bannerData)) {
//                 foreach ($bannerData as $vKey => $banner) {
//                     $bannerData[$vKey]['created_at'] = isValidDate($banner['created_at']) ? YMDToDMY($banner["created_at"], true) : "";
//                     $bannerData[$vKey]['updated_at'] = isValidDate($banner['updated_at']) ? YMDToDMY($banner["updated_at"], true) : "";
//                     $bannerData[$vKey]['created_at_display'] = time_elapsed_string($banner['created_at']);
//                     $bannerData[$vKey]['updated_at_display'] = time_elapsed_string($banner['updated_at']);
//                     $bannerData[$vKey]["start_date_display"] = isValidDate($banner['start_date']) ? date('d F, Y', strtotime($banner["start_date"])) : "";
//                     $bannerData[$vKey]["end_date_display"] = isValidDate($banner['end_date']) ? date('d F, Y', strtotime($banner["end_date"])) : "";

//                     $bannerData[$vKey]['banner_image_data'] = array_key_exists($banner['banner_id'], $bannerImageDataWise) ? $bannerImageDataWise[$banner['banner_id']] : array();
//                 }
//             }
//             $visitorCountData = $this->visitorModel->getVisitorCountData(array('date_greater_than_equal_to' => TODAY_DATE_YMD, 'society_id' => $societyId));

//             $visitorFilterArray = array(
//                 'is_multiple' => 1,
//                 'is_deleted' => 0,
//                 'date_greater_than_equal_to' => TODAY_DATE_YMD,
//             );

//             if (!empty($isCustomerApp)) {
//                 $visitorFilterArray['ownership_flat_member_id'] = $ownershipFlatMemberId;
//                 $visitorFilterArray['ownership_flat_id'] = $ownershipFlatId;
//                 $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
//                     'ownership_flat_member_id' => $ownershipFlatMemberId,
//                     'is_active' => 1
//                 ));
//             }
//             $visitorData = $this->visitorModel->getVisitorData($visitorFilterArray);
//             $objectFilterData = array(
//                 'flat_id' => array('flat_id', 'tower_flat_name'),
//                 'ownership_flat_member_id' => array('ownership_flat_member_id', 'name'),
//                 'ownership_flat_parking_id' => array('ownership_flat_parking_id', 'parking_slot_no', 'number'),
//                 'visitor_company_id' => array('visitor_company_id', 'visitor_company_name'),
//             );
//             $visitorDocumentDataWise = array();
//             $visitorWorkingDayDataWise = array();
//             $visitorIdArray = array();
//             if (!empty($visitorData)) {
//                 foreach ($visitorData as $visitorElement) {
//                     $visitorIdArray[] = $visitorElement['visitor_id'];
//                 }
//                 if (!empty($visitorIdArray)) {
//                     $visitorWorkingDayData = $this->visitorModel->getVisitorWorkingDayData(array(
//                         "visitor_id" => $visitorIdArray,
//                         "is_multiple" => 1
//                     ));
//                     if (!empty($visitorWorkingDayData)) {
//                         foreach ($visitorWorkingDayData as $visitorWorkingElement) {
//                             $visitorWorkingDayDataWise[$visitorWorkingElement['visitor_id']][] = $visitorWorkingElement;
//                         }
//                     }
//                     $visitorImageData = $this->visitorModel->getDocumentImageData(array(
//                         "document_type_id" => $visitorIdArray,
//                         "document_type" => 'visitor',
//                         "is_multiple" => 1
//                     ));
//                     if (!empty($visitorImageData)) {
//                         foreach ($visitorImageData as $visitorImageElement) {
//                             if ($visitorImageElement["document_image"] == '') {
//                                 $visitorImageElement["thumbnail_document_image"] = '';
//                                 $visitorImageElement["document_image"] = '';
//                             } else {
//                                 $visitorImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
//                                 $visitorImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
//                             }
//                             $visitorDocumentDataWise[$visitorImageElement['document_type_id']][] = $visitorImageElement;
//                         }
//                     }
//                 }
//             }
//             if (!empty($visitorData)) {
//                 foreach ($visitorData as $vKey => $visitor) {
//                     $visitorData[$vKey] = getModuleObjectData($objectFilterData, $visitor);
//                     $visitorData[$vKey]['color_code'] = array_key_exists($visitor['status'], $legendsDataIdWise) ? $legendsDataIdWise[$visitor['status']]['color_code'] : '';
//                     if ($visitor['status'] == 'entered' || $visitor['status'] == 'exited') {
//                         $endDate = isValidDate($visitor['end_date']) ? $visitor['end_date'] : date("Y-m-d H:i:s");
//                         $visitorData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($visitor['start_date'], $endDate);
//                     }
//                     $visitorData[$vKey]['created_at'] = isValidDate($visitor['created_at']) ? YMDToDMY($visitor["created_at"], true) : "";
//                     $visitorData[$vKey]['updated_at'] = isValidDate($visitor['updated_at']) ? YMDToDMY($visitor["updated_at"], true) : "";
//                     $visitorData[$vKey]['visitor_type_display'] = underscoreToUcWord($visitor["type"]);
//                     $visitorData[$vKey]['status_display'] = underscoreToUcWord($visitor["status"]);
//                     $visitorData[$vKey]['created_at_display'] = time_elapsed_string($visitor['created_at']);
//                     $visitorData[$vKey]['updated_at_display'] = time_elapsed_string($visitor['updated_at']);
//                     $visitorData[$vKey]["expected_start_date_time_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y h:i A', strtotime($visitor["expected_start_date_time"])) : "";
//                     $visitorData[$vKey]["expected_end_date_time_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitor["expected_end_date_time"])) : "";
//                     $visitorData[$vKey]["start_date_time_display"] = isValidDate($visitor['start_date']) ? date('d M, Y h:i A', strtotime($visitor["start_date"])) : "";
//                     $visitorData[$vKey]["end_date_time_display"] = isValidDate($visitor['end_date']) ? date('d M, Y h:i A', strtotime($visitor["end_date"])) : "";
//                     $visitorData[$vKey]["expected_start_date_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y', strtotime($visitor["expected_start_date_time"])) : "";
//                     $visitorData[$vKey]["expected_end_date_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M, Y', strtotime($visitor["expected_end_date_time"])) : "";
//                     $visitorData[$vKey]["start_date_display"] = isValidDate($visitor['start_date']) ? date('d M, Y', strtotime($visitor["start_date"])) : "";
//                     $visitorData[$vKey]["end_date_display"] = isValidDate($visitor['end_date']) ? date('d M, Y', strtotime($visitor["end_date"])) : "";
//                     $path = site_url('uploads/no_image.png');
//                     if ($visitor['id_proof'] != '' && file_exists(ID_PROOF_PATH . $visitor['id_proof'])) {
//                         $path = site_url() . ID_PROOF_PATH . $visitor['id_proof'];
//                     }
//                     $visitorData[$vKey]['id_proof'] = $path;
//                     $qrCodePath = '';
//                     if ($visitor['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $visitor['qr_code_image'])) {
//                         $qrCodePath = site_url() . QR_CODE_IMAGE_PATH . $visitor['qr_code_image'];
//                     }
//                     $visitorData[$vKey]['qr_code_image'] = $qrCodePath;
//                     $visitorData[$vKey]['visitor_working_day_data'] = array_key_exists($visitor['visitor_id'], $visitorWorkingDayDataWise) ? $visitorWorkingDayDataWise[$visitor['visitor_id']] : array();
//                     $visitorData[$vKey]['visitor_image_data'] = array_key_exists($visitor['visitor_id'], $visitorDocumentDataWise) ? $visitorDocumentDataWise[$visitor['visitor_id']] : array();
//                     $shareData = array(
//                         'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
//                         'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
//                         'share_image' => base_url('uploads/no_image.png'),
//                         "share_link" => "https://digitattva.in/",
//                         "share_qr_code_image" => $qrCodePath,
//                     );
//                     $visitorData[$vKey]['share_data'] = $shareData;
//                 }
//             }

//             $ownershipFlatMemberArray = array(
//                 'ownership_flat_member_id' => $ownershipFlatMemberId,
//                 'is_active' => 1,
//                 'is_show_all_member' => 1
//             );
//             $memberData = array();
//             $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData($ownershipFlatMemberArray);
//             if (!empty($ownershipFlatMemberData)) {
//                 $memberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
//                     'type' => $ownershipFlatMemberData['type'],
//                     'type_id' => $ownershipFlatMemberData['type_id'],
//                     'ownership_flat_member_id_not' => $ownershipFlatMemberId,
//                     'is_show_all_member' => 1,
//                     'is_multiple' => 1,
//                     'is_active' => 1
//                 ));
//             }
//             if (!empty($memberData)) {
//                 foreach ($memberData as $vKey => $member) {
//                     $formattedRelation = getFunctionKeyValue($member['relation'], relation());
//                     $formattedFoodLike = getFunctionKeyValue($member['food_like'], foodLike());
//                     $formattedBloodGroup = getFunctionKeyValue($member['blood_group'], bloodGroupType());
//                     $memberPath = site_url('uploads/no_image.png');
//                     $memberThumbnailPath = site_url('uploads/no_image.png');
//                     if ($member['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
//                         $memberPath = site_url() . FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
//                     }
//                     if ($member['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
//                         $memberThumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
//                     }
//                     $memberData[$vKey]['thumbnail_member_image'] = $memberThumbnailPath;
//                     $memberData[$vKey]['member_image'] = $memberPath;
//                     $memberData[$vKey]['gender_display'] = underscoreToUcWord($member["gender"]);
//                     $memberData[$vKey]['relation'] = $formattedRelation;
//                     $memberData[$vKey]['food_like'] = $formattedFoodLike;
//                     $memberData[$vKey]['blood_group'] = $formattedBloodGroup;
//                     $memberData[$vKey]['relation_display'] = underscoreToUcWord($member["relation"]);
//                     $memberData[$vKey]['food_like_display'] = underscoreToUcWord($member["food_like"]);
//                     $memberData[$vKey]['birth_date_display'] = isValidDate($member['birth_date']) ? YMDToDMY($member["birth_date"]) : "";
//                 }
//             }
//             // User Society Flat Data
//               if ($appType == MEMBER_APP || $appType == GATE_KEEPER) {
//                   $filterArray = array(
//                       'id' => $userId,
//                       //'user_type' => $appType,
//                   );
//               }
//               else {
//                   $filterArray = array(
//                       'id' => $userId,
//                       'user_type' => $appType,
//                   );
//               }
//             $userData = $this->commonWebserviceModel->getUserData($filterArray);
//             if ($appType == MEMBER_APP) {
//                 if (!empty($userData)) {   
//                     $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
//                     $ownershipFlatMemberData = array();
//                     $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
//                         'mobile_no' => $phoneNumber,
//                     ));
//                     if (!empty($flatMemberFoundData)) {
//                         $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
//                         $ownershipFlatMemberIdFound = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;
//                         if ($moduleType == 'ownership_flat') {
//                             $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
//                                 'ownership_flat_member_id' => $ownershipFlatMemberIdFound,
//                                 'is_latest' => 1,
//                                 'is_active' => 1
//                             ));
//                             if (!empty($ownershipFlatMemberFoundData)) {
//                                 $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
//                                     'mobile_no' => $phoneNumber,
//                                     'society_id' => $societyId,
//                                     'is_latest' => 1,
//                                     'is_multiple' => 1,
//                                     'is_active' => 1
//                                 ));
//                             }
//                         } else if ($moduleType == 'rentals') {
//                             $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
//                                 'ownership_flat_member_id' => $ownershipFlatMemberIdFound,
//                                 'check_rental_start' => 1,
//                                 'is_active' => 1
//                             ));
//                             if (!empty($rentalMemberFoundData)) {
//                                 $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
//                                     'mobile_no' => $phoneNumber,
//                                     'society_id' => $societyId,
//                                     'is_multiple' => 1,
//                                     'is_active' => 1
//                                 ));
//                             }
//                         }
//                     }
//                 }

//             }
//             $profileData = new \stdClass();
//             $type = '';
//             $typeId = '';
//             // Get Customer Profile
//             if ($appType == MEMBER_APP) {
//                 $profileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
//                     'ownership_flat_member_id' => $ownershipFlatMemberId,
//                     'is_active' => 1,
//                     'is_show_all_member' => 1
//                 ));
//                 if (!empty($profileData)) {
//                     $path = site_url('uploads/no_image.png');
//                     $thumbnailPath = site_url('uploads/no_image.png');
//                     if ($profileData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'])) {
//                         $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'];
//                     }
//                     if ($profileData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'])) {
//                         $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'];
//                     }
//                     $profileData['thumbnail_member_image'] = $thumbnailPath;
//                     $profileData['member_image'] = $path;
//                 }
//             }
//             else{
//                 $filterArray = array(
//                     'society_id' => $societyId,
//                     'user_id' => $userId,
//                     'type' => GATE_KEEPER
//                 );

//                 $userSocietyData = $this->ionAuthModel->getUserSocietyWiseData($filterArray);
// //                printArray($userSocietyData,1);
//                 $type = isset($userSocietyData['type']) ? $userSocietyData['type'] : '';
//                 $typeId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : '';
//                 if ($type == GATE_KEEPER) {
//                     $profileData = $this->resourceModel->getResourceData(array("resource_id" => $typeId, 'society_id' => $societyId,'is_helper' => 1));
//                     if (!empty($profileData)) {
//                         $profileData['date_of_birth'] = isset($profileData['date_of_birth']) ? YMDToDMY($profileData["date_of_birth"]) : "";
//                         $profileData['working_hours'] = "10:00 AM To 07:00 PM";
//                         $profileData['support_number'] = "-";

//                         $resourceImageData = $this->visitorModel->getDocumentImageData(array(
//                             "document_type_id" => $typeId,
//                             "document_type" => 'resource',
//                             "is_multiple" => 1
//                         ));
//                         if (!empty($resourceImageData)) {
//                             foreach ($resourceImageData as $siKey => $resourceImageElement) {
//                                 $paths = '';
//                                 $thumbnailPaths = '';
//                                 if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
//                                     $paths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
//                                 }
//                                 if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
//                                     $thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
//                                 }
//                                 $resourceImageData[$siKey]['thumbnail_document_image'] = $thumbnailPaths;
//                                 $resourceImageData[$siKey]['document_image'] = $paths;
//                             }
//                         }
//                         $profileData['resource_image_data'] = $resourceImageData;
//                     }
//                 }

//                 if($appType == MANAGER_APP){
//                     $profileData = $this->commonWebserviceModel->getUserData(array(
//                         'id' => $userId,
//                     ));
//                 }
//             }
//             // Company Data
//             $visitorCompanyFilterArray = array(
//                 'is_multiple' => 1,
//                 'start' => 0,
//                 'is_active' => 1,
//             );
//             $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData($visitorCompanyFilterArray);
//             if (!empty($visitorCompanyData)) {
//                 foreach ($visitorCompanyData as $bkey => $visitorCompany) {
//                     $visitorCompanyData[$bkey]['created_at'] = YMDToDMY($visitorCompany["created_at"], true);
//                     $visitorCompanyData[$bkey]['updated_at'] = YMDToDMY($visitorCompany["updated_at"], true);
//                     $visitorCompanyData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompany["visitor_company_type"]);
//                     $visitorCompanyData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompany['created_at']);
//                     $visitorCompanyData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompany['created_at']);
//                     $path = site_url('uploads/no_image.png');
//                     $thumbnailPath = site_url('uploads/no_image.png');
//                     if ($visitorCompany['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
//                         $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
//                     }
//                     if ($visitorCompany['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
//                         $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
//                     }
//                     $visitorCompanyData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
//                     $visitorCompanyData[$bkey]['visitor_company_image'] = $path;
//                 }
//             }
//             // Tower Data
//             $towerFilterArray = array(
//                 'is_multiple' => 1,
//                 'start' => 0,
//                 'society_id' => $societyId,
//                 'is_active' => 1,
//             );


//             $towerData = $this->towerModel->getTowerData($towerFilterArray);


//             $statusArray = array(
//                 'is_multiple' => 1,
//                 'start' => -1,
//                 'is_active' => 1,
//             );
//             $statusData = $this->statusModel->getStatusData($statusArray);

//             $complainStatusData = [];
//             $sosEmergencyStatusData = [];
//             $rentalsStatusData = [];

//             if(!empty($statusData)){
//                 foreach ($statusData as $statusElement) {
//                     if ($statusElement['status_for'] === 'complain') {
//                         $complainStatusData[] = $statusElement;
//                     } elseif ($statusElement['status_for'] === 'sos_emergency') {
//                         $sosEmergencyStatusData[] = $statusElement;
//                     } elseif ($statusElement['status_for'] === 'rentals') {
//                         $rentalsStatusData[] = $statusElement;
//                     }
//                 }
//             }

//             if (!empty($bannerData) || !empty($visitorData) || !empty($visitorCountData) || !empty($memberData) || !empty($ownershipMemberFlatData)|| !empty($ownershipFlatMemberData)|| !empty($profileData) || !empty($visitorCompanyData) || !empty($towerData) || !empty($complainStatusData) || !empty($sosEmergencyStatusData) || !empty($rentalsStatusData)) {
//                 $data = array(
//                     'status' => true,
//                     'message' => lang('CommonWebService.dashboard_listing_successfully'),
//                     'data' => array(
//                         'banner_data' => $bannerData,
//                         'my_visitor' => $visitorData,
//                         'total_visitor' => $visitorCountData,
//                         'ownership_flat_member_data' => $ownershipMemberFlatData,
//                         'member_data' => $memberData,
//                         'user_society_flat_data' => $ownershipFlatMemberData,
//                         'user_profile_data' => $profileData,
//                         'visitor_company_data' => $visitorCompanyData,
//                         'tower_data' => $towerData,
//                         'complain_status_data' => $complainStatusData,
//                         'sos_emergency_status_data' => $sosEmergencyStatusData,
//                         'rentals_status_data' => $rentalsStatusData,
//                         'record_data' => array(
//                             'no_of_recording' => NO_OF_RECORDING,
//                             'recording_limit' => RECORDING_LIMIT,
//                         ),
//                     ),
//                     'limit' => DATA_LIMIT,
//                     'response_code' => 200,
//                 );
//                 return $this->response($data, 200);
//             } else {
//                 $data = array(
//                     'status' => false,
//                     'message' => lang('CommonWebService.no_data_found'),
//                     'data' => array(),
//                     'limit' => DATA_LIMIT,
//                     'response_code' => 404,
//                 );
//                 return $this->response($data, 404);
//             }
//         }
//     }


    public function getDashboardData()
    {
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $isCustomerApp = $this->request->getVar('is_customer_app');
        $appType = $this->request->getVar('app_type');
        $deviceId = $this->request->getVar('device_id');
        $filterType = $this->request->getVar('filter_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {

            if(empty($filterType)){
                $filterType = 'all';
            }

            // banner Data
            if(($filterType == 'all') || ($filterType == 'banner_data') ){
                if(($appType == MEMBER_APP) || ($appType == MANAGER_APP) ){
                    $filterArray = array(
                        'is_multiple' => 1,
                        'is_active' => 1,
                        'society_id' => $societyId,
                        'date_greater_than_equal_to' => TODAY_DATE_YMD,
                    );
                    $bannerData = $this->bannerModel->getBannerData($filterArray);
                    $bannerImageDataWise = array();
                    $bannerIdArray = array();
                    $ownershipMemberFlatData = array();
                    if (!empty($bannerData)) {
                        foreach ($bannerData as $bannerElement) {
                            $bannerIdArray[] = $bannerElement['banner_id'];
                        }
                        if (!empty($bannerIdArray)) {
                            $bannerImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $bannerIdArray,
                                "document_type" => 'banner',
                                "is_multiple" => 1
                            ));
                            if (!empty($bannerImageData)) {
                                foreach ($bannerImageData as $bannerImageElement) {
                                    if ($bannerImageElement["document_image"] == '') {
                                        $bannerImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                        $bannerImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                    } else {
                                        $bannerImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
                                        $bannerImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
                                    }
                                    $bannerImageDataWise[$bannerImageElement['document_type_id']][] = $bannerImageElement;
                                }
                            }
                        }
                    }
                    if (!empty($bannerData)) {
                        foreach ($bannerData as $vKey => $banner) {
                            $bannerData[$vKey]['created_at'] = isValidDate($banner['created_at']) ? YMDToDMY($banner["created_at"], true) : "";
                            $bannerData[$vKey]['updated_at'] = isValidDate($banner['updated_at']) ? YMDToDMY($banner["updated_at"], true) : "";
                            $bannerData[$vKey]['created_at_display'] = time_elapsed_string($banner['created_at']);
                            $bannerData[$vKey]['updated_at_display'] = time_elapsed_string($banner['updated_at']);
                            $bannerData[$vKey]["start_date_display"] = isValidDate($banner['start_date']) ? date('d F, Y', strtotime($banner["start_date"])) : "";
                            $bannerData[$vKey]["end_date_display"] = isValidDate($banner['end_date']) ? date('d F, Y', strtotime($banner["end_date"])) : "";
                            $bannerData[$vKey]['banner_image_data'] = array_key_exists($banner['banner_id'], $bannerImageDataWise) ? $bannerImageDataWise[$banner['banner_id']] : array();
                        }
                    }
                    $data['banner_data'] = $bannerData;
                }
            }

            // legend Data
            if(($filterType == 'all') || ($filterType == 'legend_data') || ($filterType == 'my_visitor')){
                if($appType == MEMBER_APP){

                    $legendsData = array(
                        array(
                            'id' => 'entered',
                            'name' => 'Entered',
                            'color_code' => ENTERED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'entry_pre_approve',
                            'name' => 'Entry Pre Approve',
                            'color_code' => ENTERED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'collected',
                            'name' => 'Collected',
                            'color_code' => ENTERED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'delivered',
                            'name' => 'Delivered',
                            'color_code' => EXITED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'exited',
                            'name' => 'Exited',
                            'color_code' => EXITED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'approval_rejected',
                            'name' => 'Approval Rejected',
                            'color_code' => EXITED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'approval_pending',
                            'name' => 'APPROVAL Pending',
                            'color_code' => PENDING_COLOR_CODE,
                        )
                    );

                    $legendsDataIdWise = array();
                    if (!empty($legendsData)) {
                        foreach ($legendsData as $legendsElement) {
                            $legendsDataIdWise[$legendsElement['id']] = $legendsElement;
                        }
                    }
                    $visitorFilterArray = array(
                        'is_multiple' => 1,
                        'is_deleted' => 0,
                        'date_greater_than_equal_to' => TODAY_DATE_YMD,
                    );

                    if (!empty($isCustomerApp)) {
                        $visitorFilterArray['ownership_flat_member_id'] = $ownershipFlatMemberId;
                        $visitorFilterArray['ownership_flat_id'] = $ownershipFlatId;
                        $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'is_active' => 1
                        ));
                    }
                    $visitorData = $this->visitorModel->getVisitorData($visitorFilterArray);
                    $objectFilterData = array(
                        'flat_id' => array('flat_id', 'tower_flat_name'),
                        'ownership_flat_member_id' => array('ownership_flat_member_id', 'name'),
                        'ownership_flat_parking_id' => array('ownership_flat_parking_id', 'parking_slot_no', 'number'),
                        'visitor_company_id' => array('visitor_company_id', 'visitor_company_name'),
                    );
                    $visitorDocumentDataWise = array();
                    $visitorWorkingDayDataWise = array();
                    $visitorIdArray = array();
                    if (!empty($visitorData)) {
                        foreach ($visitorData as $visitorElement) {
                            $visitorIdArray[] = $visitorElement['visitor_id'];
                        }
                        if (!empty($visitorIdArray)) {
                            $visitorWorkingDayData = $this->visitorModel->getVisitorWorkingDayData(array(
                                "visitor_id" => $visitorIdArray,
                                "is_multiple" => 1
                            ));
                            if (!empty($visitorWorkingDayData)) {
                                foreach ($visitorWorkingDayData as $visitorWorkingElement) {
                                    $visitorWorkingDayDataWise[$visitorWorkingElement['visitor_id']][] = $visitorWorkingElement;
                                }
                            }
                            $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $visitorIdArray,
                                "document_type" => 'visitor',
                                "is_multiple" => 1
                            ));
                            if (!empty($visitorImageData)) {
                                foreach ($visitorImageData as $visitorImageElement) {
                                    if ($visitorImageElement["document_image"] == '') {
                                        $visitorImageElement["thumbnail_document_image"] = '';
                                        $visitorImageElement["document_image"] = '';
                                    } else {
                                        $visitorImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
                                        $visitorImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
                                    }
                                    $visitorDocumentDataWise[$visitorImageElement['document_type_id']][] = $visitorImageElement;
                                }
                            }
                        }
                    }
                    if (!empty($visitorData)) {
                        foreach ($visitorData as $vKey => $visitor) {
                            $visitorData[$vKey] = getModuleObjectData($objectFilterData, $visitor);
                            $visitorData[$vKey]['color_code'] = array_key_exists($visitor['status'], $legendsDataIdWise) ? $legendsDataIdWise[$visitor['status']]['color_code'] : '';
                            if ($visitor['status'] == 'entered' || $visitor['status'] == 'exited') {
                                $endDate = isValidDate($visitor['end_date']) ? $visitor['end_date'] : date("Y-m-d H:i:s");
                                $visitorData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($visitor['start_date'], $endDate);
                            }
                            $visitorData[$vKey]['created_at'] = isValidDate($visitor['created_at']) ? YMDToDMY($visitor["created_at"], true) : "";
                            $visitorData[$vKey]['updated_at'] = isValidDate($visitor['updated_at']) ? YMDToDMY($visitor["updated_at"], true) : "";
                            $visitorData[$vKey]['visitor_type_display'] = underscoreToUcWord($visitor["type"]);
                            $visitorData[$vKey]['status_display'] = underscoreToUcWord($visitor["status"]);
                            $visitorData[$vKey]['created_at_display'] = time_elapsed_string($visitor['created_at']);
                            $visitorData[$vKey]['updated_at_display'] = time_elapsed_string($visitor['updated_at']);
                            $visitorData[$vKey]["expected_start_date_time_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y h:i A', strtotime($visitor["expected_start_date_time"])) : "";
                            $visitorData[$vKey]["expected_end_date_time_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitor["expected_end_date_time"])) : "";
                            $visitorData[$vKey]["start_date_time_display"] = isValidDate($visitor['start_date']) ? date('d M, Y h:i A', strtotime($visitor["start_date"])) : "";
                            $visitorData[$vKey]["end_date_time_display"] = isValidDate($visitor['end_date']) ? date('d M, Y h:i A', strtotime($visitor["end_date"])) : "";
                            $visitorData[$vKey]["expected_start_date_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y', strtotime($visitor["expected_start_date_time"])) : "";
                            $visitorData[$vKey]["expected_end_date_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M, Y', strtotime($visitor["expected_end_date_time"])) : "";
                            $visitorData[$vKey]["start_date_display"] = isValidDate($visitor['start_date']) ? date('d M, Y', strtotime($visitor["start_date"])) : "";
                            $visitorData[$vKey]["end_date_display"] = isValidDate($visitor['end_date']) ? date('d M, Y', strtotime($visitor["end_date"])) : "";
                            $path = site_url('uploads/no_image.png');
                            if ($visitor['id_proof'] != '' && file_exists(ID_PROOF_PATH . $visitor['id_proof'])) {
                                $path = site_url() . ID_PROOF_PATH . $visitor['id_proof'];
                            }
                            $visitorData[$vKey]['id_proof'] = $path;
                            $qrCodePath = '';
                            if ($visitor['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $visitor['qr_code_image'])) {
                                $qrCodePath = site_url() . QR_CODE_IMAGE_PATH . $visitor['qr_code_image'];
                            }
                            $visitorData[$vKey]['qr_code_image'] = $qrCodePath;
                            $visitorData[$vKey]['visitor_working_day_data'] = array_key_exists($visitor['visitor_id'], $visitorWorkingDayDataWise) ? $visitorWorkingDayDataWise[$visitor['visitor_id']] : array();
                            $visitorData[$vKey]['visitor_image_data'] = array_key_exists($visitor['visitor_id'], $visitorDocumentDataWise) ? $visitorDocumentDataWise[$visitor['visitor_id']] : array();
                            $shareData = array(
                                'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                                'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                                'share_image' => base_url('uploads/no_image.png'),
                                "share_link" => "https://digitattva.in/",
                                "share_qr_code_image" => $qrCodePath,
                            );
                            $visitorData[$vKey]['share_data'] = $shareData;
                        }
                    }
                    $data['my_visitor'] = $visitorData;

                    $notificationDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'society_id' => $societyId,
                        'device_id' => $deviceId,
                    ));

                    if(empty($notificationDevice)){
                        $notificationTypeData = $this->commonWebserviceModel->getNotificationTypeData(array(
                            'is_multiple' => 1,
                        ));

                        if(!empty($notificationTypeData)){
                            $notificationArray = array();
                            foreach($notificationTypeData as $notificationElement){
                                $notificationTypeArray = array(
                                    'user_device_notification_config_id' => '',
                                    'device_id' => $deviceId,
                                    'society_id' => $societyId,
                                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                                    'notification_type_id' => $notificationElement['notification_type_id'],
                                    'is_enabled' => 1,
                                    'created_by' => $userId,
                                    'updated_by' => $userId,
                                    'created_at' => date("Y-m-d H:i:s"),
                                    'updated_at' => date("Y-m-d H:i:s"),
                                );
                                array_push($notificationArray, $notificationTypeArray);
                            }
                            $this->commonWebserviceModel->batchInsert($notificationArray, 'tbl_user_device_notification_config');
                        }
                    }
                }
            }

            // Visitor Data
            if (($filterType == 'all') || ($filterType == 'total_visitor')) {
                if($appType == GATE_KEEPER){
                    $visitorCountData = $this->visitorModel->getVisitorCountData(array('date_greater_than_equal_to' => TODAY_DATE_YMD, 'society_id' => $societyId));
                    $data['total_visitor'] = $visitorCountData;
                }
            }

            if (($filterType == 'all') || ($filterType == 'company_data')) {
                if ($appType == MEMBER_APP || $appType == GATE_KEEPER) {

                    // Company Data
                $visitorCompanyFilterArray = array(
                    'is_multiple' => 1,
                    'start' => 0,
                    'visitor_company_type' => 'taxi',
                    'is_active' => 1,
                );
                $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData($visitorCompanyFilterArray);
                $deliveryboyVisitorCompanyData = array();
                $taxiVisitorCompanyData = array();
                if (!empty($visitorCompanyData)) {
                    foreach ($visitorCompanyData as $bkey => $visitorCompany) {
                        $visitorCompanyData[$bkey]['created_at'] = YMDToDMY($visitorCompany["created_at"], true);
                        $visitorCompanyData[$bkey]['updated_at'] = YMDToDMY($visitorCompany["updated_at"], true);
                        $visitorCompanyData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompany["visitor_company_type"]);
                        $visitorCompanyData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                        $visitorCompanyData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                        $path = site_url('uploads/no_image.png');
                        $thumbnailPath = site_url('uploads/no_image.png');
                        if ($visitorCompany['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                            $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                        }
                        if ($visitorCompany['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                            $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                        }
                        $visitorCompanyData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
                        $visitorCompanyData[$bkey]['visitor_company_image'] = $path;

                            // if($companyData[$bkey]['company_type'] == 'delivery_boy'){
                            //     $deliveryboyCompanyData[] = $companyData[$bkey];
                            // } else {
                            //     $taxiCompanyData[] = $companyData[$bkey];
                            // }
                        }
                        $data['taxi_visitor_company_data'] = $visitorCompanyData;
                    }

                    $visitorCompanyFilterArray = array(
                        'is_multiple' => 1,
                        'start' => 0,
                        'visitor_company_type' => 'delivery_boy',
                        'is_active' => 1,
                    );
                    $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData($visitorCompanyFilterArray);
                    $deliveryboyVisitorCompanyData = array();
                    $taxiVisitorCompanyData = array();
                    if (!empty($visitorCompanyData)) {
                        foreach ($visitorCompanyData as $bkey => $visitorCompany) {
                            $visitorCompanyData[$bkey]['created_at'] = YMDToDMY($visitorCompany["created_at"], true);
                            $visitorCompanyData[$bkey]['updated_at'] = YMDToDMY($visitorCompany["updated_at"], true);
                            $visitorCompanyData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompany["visitor_company_type"]);
                            $visitorCompanyData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                            $visitorCompanyData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                            $path = site_url('uploads/no_image.png');
                            $thumbnailPath = site_url('uploads/no_image.png');
                            if ($visitorCompany['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                                $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                            }
                            if ($visitorCompany['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                                $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                            }
                            $visitorCompanyData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
                            $visitorCompanyData[$bkey]['visitor_company_image'] = $path;
                        }
                        $data['delivery_boy_visitor_company_data'] = $visitorCompanyData;
                    }
                }
            }

            // User Society Flat Data
            if ($appType == MEMBER_APP) {
                $filterArray = array(
                    'id' => $userId,
                );
                $userData = $this->commonWebserviceModel->getUserData($filterArray);
                if (!empty($userData)) {   
                    $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
                    $ownershipFlatMemberData = array();
                    $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'mobile_no' => $phoneNumber,
                    ));
                    if (!empty($flatMemberFoundData)) {
                        $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                        $ownershipFlatMemberIdFound = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;
                        if ($moduleType == 'ownership_flat') {
                            $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberIdFound,
                                'is_latest' => 1,
                                'is_active' => 1
                            ));
                            if (!empty($ownershipFlatMemberFoundData)) {
                                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'mobile_no' => $phoneNumber,
                                    'society_id' => $societyId,
                                    'is_latest' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ));
                            }
                        } else if ($moduleType == 'rentals') {
                            $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberIdFound,
                                'check_rental_start' => 1,
                                'is_active' => 1
                            ));
                            if (!empty($rentalMemberFoundData)) {
                                $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                                    'mobile_no' => $phoneNumber,
                                    'society_id' => $societyId,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ));
                            }
                        }
                    }
                }
                $data['user_society_flat_data'] = $ownershipFlatMemberData;
            }

            if (($appType == MEMBER_APP) || ($appType == MANAGER_APP)) {
                $recordData = array(
                    'no_of_recording' => NO_OF_RECORDING,
                    'recording_limit' => RECORDING_LIMIT,
                );
                $data['record_data'] = $recordData;
            }

            if (($appType == GATE_KEEPER) || ($appType == MANAGER_APP)) {
                $societyData = $this->societyModel->getSocietyData(array(
                    'society_id' => $societyId,
                ));
                $data['user_logged_society'] = $societyData;
            }

            if ($appType == MEMBER_APP) {
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'society_id' => $societyId,
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $data['user_logged_society'] = $ownershipFlatMemberData;
            }

            // Tower Data
            // if(($filterType == 'all') || ($filterType == 'tower_data') ) {
            //     if($appType == MEMBER_APP){
            //         $start = 0;
            //         $filterArray = array(
            //             'is_multiple' => 1,
            //             'start' => $start,
            //             'society_id' => $societyId,
            //             'is_active' => 1,
            //         );
            //         $towerData = $this->towerModel->getTowerData($filterArray);
            //         $data['tower_data'] = $towerData;
            //     }
            // }

            // food Data
            if(($filterType == 'all') || ($filterType == 'food_data')) {
                if($appType == MEMBER_APP){
                    $data['food_data'] = foodLikeApi();
                }
            }

            // vehicle Data
            if(($filterType == 'all') || ($filterType == 'vehicle_type_data')) {
                if($appType == MEMBER_APP){
                    $data['vehicle_type_data'] = vehicleTypeApi();
                }
            }

            // Blood Group Type Data
            if(($filterType == 'all') || ($filterType == 'blood_group_type_data')) {
                if($appType == MEMBER_APP){
                    $data['blood_group_type_data'] = bloodGroupTypeAPI();
                }
            }

            // Relation Type Data
            if(($filterType == 'all') || ($filterType == 'relation_type_data')) {
                if($appType == MEMBER_APP){
                    $data['relation_type_data'] = relationAPI();
                }
            }

            // Source Type Data
            if(($filterType == 'all') || ($filterType == 'source_type_data')) {
                if($appType == MANAGER_APP){
                    $data['source_type_data'] = sourceAPI();
                }
            }

            // Complain category Data
            if(($filterType == 'all') || ($filterType == 'complain_category_data')) {
                // $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
                $filterArray = array(
                    'is_multiple' => 1,
                    'start' => -1,
                    // 'search' => $search,
                    'category_for' => "complaint",
                    'society_id' => $societyId,
                    'is_active' => 1,
                );
                $categoryData = $this->categoryModel->getCategoryData($filterArray);
                if (!empty($categoryData)) {
                    foreach ($categoryData as $bkey => $category) {
                        $categoryData[$bkey]['created_at'] = YMDToDMY($category["created_at"], true);
                        $categoryData[$bkey]['updated_at'] = YMDToDMY($category["updated_at"], true);
                        $categoryData[$bkey]['created_at_display'] = time_elapsed_string($category['created_at']);
                        $categoryData[$bkey]['updated_at_display'] = time_elapsed_string($category['created_at']);
                        $path = site_url('uploads/no_image.png');
                        $thumbnailPath = site_url('uploads/no_image.png');
                        if ($category['category_image'] != '' && file_exists(CATEGORY_IMAGE_PATH . $category['category_image'])) {
                            $path = site_url() . CATEGORY_IMAGE_PATH . $category['category_image'];
                        }
                        if ($category['category_image'] != '' && file_exists(THUMBNAIL_CATEGORY_IMAGE_PATH . $category['category_image'])) {
                            $thumbnailPath = site_url() . THUMBNAIL_CATEGORY_IMAGE_PATH . $category['category_image'];
                        }
                        $categoryData[$bkey]['thumbnail_category_image'] = $thumbnailPath;
                        $categoryData[$bkey]['category_image'] = $path;
                    }
    
                    $data['complain_category_data'] = $categoryData;
                }
            }

            // Status Data
            $statusArray = array(
                'is_multiple' => 1,
                'start' => -1,
                'is_active' => 1,
            );
            $statusData = $this->statusModel->getStatusData($statusArray);

            $complainStatusData = [];
            $sosEmergencyStatusData = [];
            $rentalsStatusData = [];

            if(!empty($statusData)){
                foreach ($statusData as $statusElement) {
                    if ($statusElement['status_for'] === 'complain') {
                        $complainStatusData[] = $statusElement;
                    } elseif ($statusElement['status_for'] === 'sos_emergency') {
                        $sosEmergencyStatusData[] = $statusElement;
                    } elseif ($statusElement['status_for'] === 'rentals') {
                        $rentalsStatusData[] = $statusElement;
                    }
                }
            }

            $data['complain_status_data'] = $complainStatusData;
            $data['sos_emergency_status_data'] = $sosEmergencyStatusData;
            $data['rentals_status_data'] = $rentalsStatusData;

            if(($filterType == 'all') || ($filterType == 'generator_data')) {
                if($appType == MANAGER_APP){
                    $filterArray = array(
                        'is_multiple' => 1,
                        'is_active' => 1,
                        'start' => 0,
                        // 'search' => $search,
                        // 'generator_id' => $generatorId,
                        'society_id' => $societyId,
                        'user_id' => $userId,
                    );
                    $generatorData = $this->generatorModel->getGeneratorData($filterArray);
                    if (!empty($generatorData)) {
                        foreach ($generatorData as $gKey => $generatorElement) {
                            $generatorData[$gKey]['created_at'] = isValidDate($generatorElement['created_at']) ? YMDToDMY($generatorElement["created_at"], true) : "";
                            $generatorData[$gKey]['updated_at'] = isValidDate($generatorElement['updated_at']) ? YMDToDMY($generatorElement["updated_at"], true) : "";
                            $generatorData[$gKey]['created_at_display'] = time_elapsed_string($generatorElement['created_at']);
                            $generatorData[$gKey]['updated_at_display'] = time_elapsed_string($generatorElement['updated_at']);
                        }
                    }
                    $data['generator_data'] = $generatorData;
                }
            }

            if(($filterType == 'all') || ($filterType == 'water_tank_data')) {
                if($appType == MANAGER_APP){
                    $filterArray = array(
                        'is_multiple' => 1,
                        'start' => 0,
                        // 'search' => $search,
                        // 'water_tank_id' => $waterTankId,
                        // 'water_meter_reading_id' => $waterMeterReadingId,
                        'society_id' => $societyId,
                        'is_active' => 1,
                        // 'is_api' => 1,
                    );
                    $waterTankData = $this->waterTankModel->getWaterTankData($filterArray);
                    $data['water_tank_data'] = $waterTankData;
                }
            }

            if(($filterType == 'all') || ($filterType == 'resource_type')) {
                $resourceTypeData = $this->resourceModel->getResourceCountData(array(
                    'society_id' => $societyId,
                    'is_multiple' => 1,
                    'is_helper' => 1,
                    'is_active' => 1,
                ));
                
                $data['resource_type'] = $resourceTypeData;
            }
            
            if ((!empty($data['banner_data'])) || (!empty($data['my_visitor'])) || (!empty($data['total_visitor'])) || (!empty($data['user_society_flat_data'])) || (!empty($data['delivery_boy_visitor_company_data'])) || (!empty($data['taxi_visitor_company_data'])) || (!empty($data['record_data'])) || (!empty($data['user_logged_society'])) || (!empty($data['food_data'])) || (!empty($data['vehicle_type_data'])) || (!empty($data['blood_group_type_data'])) || (!empty($data['relation_type_data'])) || (!empty($data['source_type_data'])) || (!empty($data['complain_category_data']))  || (!empty($data['generator_data'])) || (!empty($data['resource_type'])) || (!empty($data['water_tank_data'])) || (!empty($data['complain_status_data'])) || (!empty($data['sos_emergency_status_data'])) || (!empty($data['rentals_status_data']))) {
                $dashboardData = array(
                    'status' => true,
                    'message' => lang('CommonWebService.dashboard_listing_successfully'),
                    'data' => $data,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($dashboardData, 200);
            } else {
                $dashboardData = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => array(),
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($dashboardData, 404);
            }
        }
    }

    public function getProfileList()
    {
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $profileData = array();
            $resourceTypeGuardData = $this->resource_type_model->getResourceTypeData(array(
                'is_guard' => 1,
                'is_multiple' => 1,
                'is_login' => 1,
                'is_active' => 1,
                'society_id' => $this->session->get('society_id'),
            ));
            $resourceTypeIdArray = [];
            if (!empty($resourceTypeGuardData)) {
                foreach ($resourceTypeGuardData as $resourceTypeElement) {
                    $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                }
            }
            $type = '';
            $typeId = '';
            $filterArray = array(
                'society_id' => $societyId,
                'user_id' => $userId,
                'resource_type_id' => $resourceTypeIdArray,
            );
            $userSocietyData = $this->ionAuthModel->getUserSocietyWiseData($filterArray);

            $type = isset($userSocietyData['type']) ? $userSocietyData['type'] : '';
            $typeId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : '';
            if ($type == GATE_KEEPER) {
                $profileData = $this->resourceModel->getResourceData(array("resource_id" => $typeId, 'society_id' => $societyId,'is_helper' => 1));
                if (!empty($profileData)) {
                    $profileData['date_of_birth'] = isset($profileData['date_of_birth']) ? YMDToDMY($profileData["date_of_birth"]) : "";
                    $profileData['working_hours'] = "10:00 AM To 07:00 PM";
                    $profileData['support_number'] = "-";
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $typeId,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $siKey => $resourceImageElement) {
                            $paths = '';
                            $thumbnailPaths = '';
                            if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                $paths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                            }
                            if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                $thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                            }
                            $resourceImageData[$siKey]['thumbnail_document_image'] = $thumbnailPaths;
                            $resourceImageData[$siKey]['document_image'] = $paths;
                        }
                    }
                    $profileData['resource_image_data'] = $resourceImageData;
                }
            }
            if (!empty($profileData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.profile_listing_successfully'),
                    'data' => $profileData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $profileData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function editProfile()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $resourceName = $this->request->getVar('resource_name');
        $resourceImage = $this->request->getVar('resource_image[]');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $resourceImageData = array();
            if (isset($_FILES["resource_image"])) {
                $resourceImagePath = DOCUMENT_IMAGE_PATH;
                $resourceImageData = $dt_ci_file_upload->UploadMultipleFile('resource_image', MAX_IMAGE_SIZE_LIMIT, $resourceImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($resourceImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($resourceImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($resourceImageData['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($resourceImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }

            $resourceUpdateArray = array();
            $resourceArray = array(
                'resource_id' => $resourceId,
                'resource_name' => $resourceName,
                'is_guard' => 1,
                'is_active' => 1,
            );
            if (!empty($resourceId)) {
                $resourceUpdateArray = $this->resourceModel->getResourceData(array(
                    'resource_id' => $resourceId,
                ));
                $resourceUpdateArray = compareArray($resourceArray, $resourceUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $resourceData = $this->commonWebserviceModel->insertUpdateRecord($resourceArray, 'resource_id', 'tbl_resource', 1, '', array(), $extraData, $resourceUpdateArray);
            $lastResourceId = $resourceData['lastInsertedId'];


            $userUpdateArray = array();
            $userArray = array(
                'id' => $userId,
                'first_name' => $resourceName,
            );
            if (!empty($userId)) {
                $userUpdateArray = $this->commonWebserviceModel->getUserData(array(
                    'id' => $userId,
                ));
                $userUpdateArray = compareArray($userArray, $userUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $userData = $this->commonWebserviceModel->insertUpdateRecord($userArray, 'id', 'tbl_users', 1, '', array(), $extraData, $userUpdateArray);
            $lastUserId = $userData['lastInsertedId'];


            // resource Multiple Image Store
            if ($lastResourceId != '') {
                if (isset($resourceImageData) && count($resourceImageData) > 0) {
                    $batchArray = array();
                    unset($resourceImageData['success']);
                    foreach ($resourceImageData as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' => '',
                            'document_type' => 'resource',
                            'document_type_id' => $lastResourceId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $resourceExtraDataArray = array();
                    $resourceExtraDataArray['module_id'] = $lastResourceId;
                    $resourceExtraDataArray['module'] = 'Resource Image';
                    $resourceExtraDataArray['type'] = 'Resource';
                    $resourceExtraDataArray['old_data'] = '';
                    $resourceExtraDataArray['user_id'] = $userId;
                    $resourceExtraDataArray['society_id'] = $societyId;
                    $this->commonWebserviceModel->batchInsert($batchArray, 'tbl_document_image', $resourceExtraDataArray);
                }
            }
            if (isset($resourceData['success']) && $resourceData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.edit_profile')),
                    'data' => null
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.edit_profile')),
                    'data' => null
                ), 404);
            }
        }
    }

    public function addEditVehicle()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $vehicleType = $this->request->getVar('vehicle_type');
        $vehicleNo = $this->request->getVar('vehicle_no');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $tokenNo = $this->request->getVar('token_no');
        $isElectric = $this->request->getVar('is_electric');
        $vehicleImage = $this->request->getVar('vehicle_image');

        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('vehicle_type', lang('CommonWebService.vehicle_type'), 'required');
        $this->validation->setRule('vehicle_no', lang('CommonWebService.vehicle_no'), 'required');
        $this->validation->setRule('is_electric', lang('CommonWebService.is_electric'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            if (isset($_FILES["vehicle_image"])) {
                $vehicleImagePath = VEHICLE_IMAGE_PATH;
                $vehicleImageResult = $dt_ci_file_upload->uploadFile('vehicle_image', MAX_IMAGE_SIZE_LIMIT, $vehicleImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($vehicleImageResult['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($vehicleImageResult['message']),
                        'data' => null
                    ), 404);
                } else {
                    $vehicleImageRecord = $vehicleImageResult['file_name'];
                    // else{
                        unset($vehicleImageResult['success']);
                        $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($vehicleImageResult, VEHICLE_IMAGE_PATH, THUMBNAIL_VEHICLE_IMAGE_PATH);
                    // }
                }
            }

            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_show_all_member' => 1,
                'is_active' => 1
            ));

            $type = isset($ownershipFlatMemberData['type']) ? $ownershipFlatMemberData['type'] : '';
            $typeId = isset($ownershipFlatMemberData['type_id']) ? $ownershipFlatMemberData['type_id'] : 0;
            $ownershipFlatId = isset($ownershipFlatMemberData['ownership_flat_id']) ? $ownershipFlatMemberData['ownership_flat_id'] : 0;

            $ownershipFlatParkingUpdateArray = array();
            $ownershipFlatParkingArray = array(
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'type' => $type,
                'type_id' => $typeId,
                'vehicle_type' => $vehicleType,
                'vehicle_no' => $vehicleNo,
                'parking_slot_id' => $parkingSlotId,
                'token_no' => $tokenNo,
                'is_electric' => $isElectric,
                'ownership_flat_id' => $ownershipFlatId,
            );
            if (isset($vehicleImageRecord)) {
                if ($ownershipFlatParkingId != '') {
                    $ownershipFlatParkingData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array('ownership_flat_parking_id' => $ownershipFlatParkingId,'is_show_all_parking' => 1));
                    if ($ownershipFlatParkingData['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $ownershipFlatParkingData['vehicle_image'])) {
                        unlink(VEHICLE_IMAGE_PATH . $ownershipFlatParkingData['vehicle_image']);
                    }
                    if ($ownershipFlatParkingData['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $ownershipFlatParkingData['vehicle_image'])) {
                        unlink(THUMBNAIL_VEHICLE_IMAGE_PATH . $ownershipFlatParkingData['vehicle_image']);
                    }
                }
                $ownershipFlatParkingArray['vehicle_image'] = $vehicleImageRecord;
            }
            if (!empty($ownershipFlatParkingId)) {
                $ownershipFlatParkingUpdateArray = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                    'ownership_flat_parking_id' => $ownershipFlatParkingId,
                    'is_show_all_parking' => 1
                ));
                $ownershipFlatParkingUpdateArray = compareArray($ownershipFlatParkingArray, $ownershipFlatParkingUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;

            // printArray($ownershipFlatParkingArra,1);
            $ownershipFlatParkingData = $this->commonWebserviceModel->insertUpdateRecord($ownershipFlatParkingArray, 'ownership_flat_parking_id', 'tbl_ownership_flat_parking', 1, '', array(), $extraData, $ownershipFlatParkingUpdateArray);
            $lastOwnershipFlatParkingId = $ownershipFlatParkingData['lastInsertedId'];


            $vehicleInsertData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                'ownership_flat_parking_id' => $lastOwnershipFlatParkingId,
            ));

            if (!empty($vehicleInsertData)) {
                $formattedVehicleType = getFunctionKeyValue($vehicleInsertData['vehicle_type'], vehicleType());
                $vehiclePath = site_url('uploads/no_image.png');
                $vehicleThumbnailPath = site_url('uploads/no_image.png');
                if ($vehicleInsertData['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $vehicleInsertData['vehicle_image'])) {
                    $vehiclePath = site_url() . VEHICLE_IMAGE_PATH . $vehicleInsertData['vehicle_image'];
                }
                if ($vehicleInsertData['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicleInsertData['vehicle_image'])) {
                    $vehicleThumbnailPath = site_url() . THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicleInsertData['vehicle_image'];
                }
                $vehicleInsertData['vehicle_image'] = $vehiclePath;
                $vehicleInsertData['thumbnail_vehicle_image'] = $vehicleThumbnailPath;
                $vehicleInsertData['vehicle_type_display'] = underscoreToUcWord($vehicleInsertData["vehicle_type"]);
                $vehicleInsertData['vehicle_type'] = $formattedVehicleType;
                
            }



            if (isset($ownershipFlatParkingId) && !empty($ownershipFlatParkingId)) {
                if (isset($ownershipFlatParkingData['success']) && $ownershipFlatParkingData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.vehicle')),
                        'data' => $vehicleInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.vehicle')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($ownershipFlatParkingData['success']) && $ownershipFlatParkingData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.vehicle')),
                        'data' => $vehicleInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.vehicle')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function getVehicleList()
    {
        $appType = $this->request->getVar('app_type');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $start = $this->request->getVar('start');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $type = $this->request->getVar('type');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');

        if($appType == MEMBER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        else {
            $this->validation->setRule('ownership_flat_id', lang('CommonWebService.ownership_flat_id'), 'required');
            $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        }
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            if($appType == MEMBER_APP){
                $filterArray = array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1,
                );
                $vehicleData = array();
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData($filterArray);
                if (!empty($ownershipFlatMemberData)) {
                    $type = isset($ownershipFlatMemberData['type']) ? $ownershipFlatMemberData['type'] : '';
                    $typeId = isset($ownershipFlatMemberData['type_id']) ? $ownershipFlatMemberData['type_id'] : 0;
                    $vehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                        'search' => $search,
                        'type' => $type,
                        'type_id' => $typeId,
                        'start' => $start,
                        'ownership_flat_parking_id' => $ownershipFlatParkingId,
                        'is_multiple' => 1,
                        'is_show_all_parking' => 1
                    ));
                }
            }
            else{
                $vehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                    'search' => $search,
                    'type' => $type,
                    'type_id' => $ownershipFlatId,
                    'start' => $start,
                    'ownership_flat_parking_id' => $ownershipFlatParkingId,
                    'is_multiple' => 1,
                    'is_show_all_parking' => 1
                ));
            }

            if (!empty($vehicleData)) {
                foreach ($vehicleData as $vKey => $vehicle) {
                    $formattedVehicleType = getFunctionKeyValue($vehicle['vehicle_type'], vehicleType());
                    $vehiclePath = site_url('uploads/no_image.png');
                    $vehicleThumbnailPath = site_url('uploads/no_image.png');
                    if ($vehicle['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehiclePath = site_url() . VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    if ($vehicle['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehicleThumbnailPath = site_url() . THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    $vehicleData[$vKey]['vehicle_image'] = $vehiclePath;
                    $vehicleData[$vKey]['thumbnail_vehicle_image'] = $vehicleThumbnailPath;
                    $vehicleData[$vKey]['vehicle_type_display'] = underscoreToUcWord($vehicle["vehicle_type"]);
                    $vehicleData[$vKey]['vehicle_type'] = $formattedVehicleType;
                }
            }

            if (!empty($vehicleData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.vehicle_listing_successfully'),
                    'data' => $vehicleData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $vehicleData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getMyVehicleList()
    {
        $appType = $this->request->getVar('app_type');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $start = $this->request->getVar('start');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $type = $this->request->getVar('type');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');

        // if($appType == MEMBER_APP){
        //     $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        // }
        // else {
            $this->validation->setRule('ownership_flat_id', lang('CommonWebService.ownership_flat_id'), 'required');
            $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
            $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        // }
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $vehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                'search' => $search,
                'type' => $type,
                'ownership_flat_id' => $ownershipFlatId,
                'start' => $start,
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'is_multiple' => 1,
                'is_show_all_parking' => 1,
            ));
            $parkingSlotIdArray = [];
            $filteredParkingSlotData = [];
            if (!empty($vehicleData)) {
                foreach ($vehicleData as $vKey => $vehicle) {
                    $parkingSlotIdArray[] = $vehicle['parking_slot_id'];
                    $formattedVehicleType = getFunctionKeyValue($vehicle['vehicle_type'], vehicleType());
                    $vehiclePath = site_url('uploads/no_image.png');
                    $vehicleThumbnailPath = site_url('uploads/no_image.png');
                    if ($vehicle['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehiclePath = site_url() . VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    if ($vehicle['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehicleThumbnailPath = site_url() . THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    $vehicleData[$vKey]['vehicle_image'] = $vehiclePath;
                    $vehicleData[$vKey]['thumbail_vehicle_image'] = $vehicleThumbnailPath;
                    $vehicleData[$vKey]['vehicle_type_display'] = underscoreToUcWord($vehicle["vehicle_type"]);
                    $vehicleData[$vKey]['vehicle_type'] = $formattedVehicleType;
                }
            }

            if($type == 'ownership_flat'){
                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatData(array(
                    'ownership_flat_id' => $ownershipFlatId,
                ));
            }
            else{
                $ownershipFlatData = $this->rentalModel->getRentalsData(array(
                    'ownership_flat_id' => $ownershipFlatId,
                ));
            }

            // if(!empty($ownershipFlatData)){
            //     $parkingPlaceData = $this->parkingPlaceModel->getParkingPlaceData(array(
            //         'flat_id' => $ownershipFlatData['flat_id'],
            //         'is_multiple' => 1
            //     ));

            //     if(!empty($parkingPlaceData)){
            //         foreach ($parkingPlaceData as $parkingPlaceElement) {
            //             if (!in_array($parkingPlaceElement['parking_place_id'], $parkingPlaceIdArray)) {
            //                 $filteredParkingPlaceData[] = $parkingPlaceElement;
            //             }
            //         }
            //     }
            // }
            $vehicleDataMerge = array_merge($vehicleData,$filteredParkingSlotData);
            if (!empty($vehicleDataMerge)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.vehicle_listing_successfully'),
                    'data' => $vehicleDataMerge,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $vehicleDataMerge,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditMember()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $name = $this->request->getVar('name');
        $email = $this->request->getVar('email');
        $mobileNo = $this->request->getVar('mobile_no');
        $gender = $this->request->getVar('gender');
        $relation = $this->request->getVar('relation');
        $birthDate = $this->request->getVar('birth_date');
        $bloodGroup = $this->request->getVar('blood_group');
        $relation = $this->request->getVar('relation');
        $foodLike = $this->request->getVar('food_like');
        $isOwner = $this->request->getVar('is_owner');
        $isEdit = $this->request->getVar('is_edit');
        $isStatusChange = $this->request->getVar('is_status_change');
        $memberImage = $this->request->getVar('member_image');
        $memberId = $this->request->getVar('member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $remarks = $this->request->getVar('remarks');

        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('name', lang('CommonWebService.name'), 'required');
        $this->validation->setRule('mobile_no', lang('CommonWebService.mobile_no'), 'required');
        $this->validation->setRule('gender', lang('CommonWebService.gender'), 'required');
        $this->validation->setRule('birth_date', lang('CommonWebService.birth_date'), 'required');
        if (!empty($isStatusChange)) {
            $this->validation->setRule('remarks', lang('CommonWebService.remarks'), 'required');
        }

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {


            if (!empty($isStatusChange)) {
                $ownershipFlatMemberArray = array(
                    'ownership_flat_member_id' => $memberId,
                    'is_active' => 0,
                    'remarks' => $remarks,
                );
            } else {

                if (isset($_FILES["member_image"])) {
                    $memberImagePath = FLAT_MEMBER_IMAGE_PATH;
                    $memberImageResult = $dt_ci_file_upload->uploadFile('member_image', MAX_IMAGE_SIZE_LIMIT, $memberImagePath, true, true, array('jpeg', 'png', 'jpg'));
                    if ($memberImageResult['success'] == false) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => strip_tags($memberImageResult['message']),
                            'data' => null
                        ), 404);
                    } else {
                        $memberImageRecord = $memberImageResult['file_name'];
                        unset($memberImageResult['success']);
                        $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($memberImageResult, FLAT_MEMBER_IMAGE_PATH, THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
                    }
                }

                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1
                ));

                // if (!empty($ownershipFlatMemberData)) {
                //     foreach ($ownershipFlatMembersData as $mkey => $flatMember) {
                //         if ($mobileNo == $flatMember['mobile_no']) {
                //             return $this->response(array(
                //                 'status' => false,
                //                 'response_code' => 404,
                //                 'message' => "Members Mobiles Numbers Can't Be Same",
                //                 'data' => null
                //             ), 404);
                //         }
                //     }
                // }

                $ownershipFlatMemberUpdateArray = array();

                // printArray($ownershipFlatMemberData,1);

                $ownershipFlatMembersData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'type' => $ownershipFlatMemberData['type'],
                    'type_id' => $ownershipFlatMemberData['type_id'],
                    'flat_id' => $ownershipFlatMemberData['flat_id'],
                    'mobile_no' => $mobileNo,
                    'member_id_not' => $memberId,
                    // 'is_multiple' => 1,
                ));

                // printArray($ownershipFlatMembersData,1);

                if (!empty($ownershipFlatMembersData)) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => "Members Mobiles Numbers Can't Be Same",
                        'data' => null
                    ), 404);
                }

                $ownershipFlatMemberArray = array(
                    'type' => $ownershipFlatMemberData['type'],
                    'type_id' => $ownershipFlatMemberData['type_id'],
                    'name' => $name,
                    'email_id' => $email,
                    'mobile_no' => $mobileNo,
                    'gender' => $gender,
                    'relation' => $relation,
                    'birth_date' => DMYToYMD($birthDate),
                    'ownership_flat_id' => $ownershipFlatId,
                    'blood_group' => $bloodGroup,
                    'relation' => $relation,
                    'food_like' => $foodLike,
                    'is_owner' => $isOwner,
                    'is_active' => 1,
                );
                if ($isEdit == 1) {
                    $ownershipFlatMemberArray['ownership_flat_member_id'] = $memberId;
                } else {
                    $ownershipFlatMemberArray['ownership_flat_member_id'] = '';
                }
                if (isset($memberImageRecord)) {
                    if ($isEdit == 1) {
                        $memberImageData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('ownership_flat_member_id' => $ownershipFlatMemberId, 'is_show_all_member' => 1));
                        $ownershipFlatMemberUpdateArray = $memberImageData;
                        if ($memberImageData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                        if ($memberImageData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                    }
                    $ownershipFlatMemberArray['member_image'] = $memberImageRecord;
                }
            }
            if ($isEdit == 1 || $isStatusChange == 1) {
                $ownershipFlatMemberUpdateArray = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('ownership_flat_member_id' => $ownershipFlatMemberId, 'is_show_all_member' => 1,'is_active' => 1));
                $ownershipFlatMemberUpdateArray = compareArray($ownershipFlatMemberArray, $ownershipFlatMemberUpdateArray);
            }

            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $memberData = $this->commonWebserviceModel->insertUpdateRecord($ownershipFlatMemberArray, 'ownership_flat_member_id', 'tbl_ownership_flat_member', 1, '', array(), $extraData, $ownershipFlatMemberUpdateArray);
            $lastOwnershipFlatMemberId = $memberData['lastInsertedId'];

            $ownershipFlatMemberFilterArray = array(
                'ownership_flat_member_id' => $lastOwnershipFlatMemberId,
                'is_show_all_member' => 1,
            );
            $memberInsertData = array();
            $ownershipFlatMemberInsertData = $this->ownershipFlatModel->getOwnershipFlatMemberData($ownershipFlatMemberFilterArray);
            if (!empty($ownershipFlatMemberInsertData)) {
                $memberInsertData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'type' => $ownershipFlatMemberInsertData['type'],
                    'type_id' => $ownershipFlatMemberInsertData['type_id'],
                    'is_show_all_member' => 1,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
            }
            if (!empty($memberInsertData)) {
                foreach ($memberInsertData as $vKey => $member) {
                    $formattedRelation = getFunctionKeyValue($member['relation'], relation());
                    $formattedFoodLike = getFunctionKeyValue($member['food_like'], foodLike());
                    $formattedBloodGroup = getFunctionKeyValue($member['blood_group'], bloodGroupType());
                    $memberPath = site_url('uploads/no_image.png');
                    $memberThumbnailPath = site_url('uploads/no_image.png');
                    if ($member['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberPath = site_url() . FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    if ($member['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberThumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    $memberInsertData[$vKey]['member_image'] = $memberPath;
                    $memberInsertData[$vKey]['thumbnail_member_image'] = $memberThumbnailPath;
                    $memberInsertData[$vKey]['gender_display'] = underscoreToUcWord($member["gender"]);
                    $memberInsertData[$vKey]['relation'] = $formattedRelation;
                    $memberInsertData[$vKey]['food_like'] = $formattedFoodLike;
                    $memberInsertData[$vKey]['blood_group'] = $formattedBloodGroup;
                    $memberInsertData[$vKey]['relation_display'] = underscoreToUcWord($member["relation"]);
                    $memberInsertData[$vKey]['food_like_display'] = underscoreToUcWord($member["food_like"]);
                    $memberInsertData[$vKey]['birth_date_display'] = isValidDate($member['birth_date']) ? YMDToDMY($member["birth_date"]) : "";
                }
            }
            
            if (isset($isEdit) && !empty($isEdit)) {
                if (isset($memberData['success']) && $memberData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.member')),
                        'data' => $memberInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.member')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($memberData['success']) && $memberData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.member')),
                        'data' => $memberInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.member')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function getMemberList()
    {
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $search = $this->request->getVar('search');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $memberId = $this->request->getVar('member_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                
                'is_show_all_member' => 1,
                'is_active' => 1
            );
            $memberData = array();
            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData($filterArray);
            if (!empty($ownershipFlatMemberData)) {
                $memberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'type' => $ownershipFlatMemberData['type'],
                    'type_id' => $ownershipFlatMemberData['type_id'],
                    'member_id' => $memberId,
                    'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                    'search' => $search,
                    'is_show_all_member' => 1,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
            }
            if (!empty($memberData)) {
                foreach ($memberData as $vKey => $member) {
                    $formattedRelation = getFunctionKeyValue($member['relation'], relation());
                    $formattedFoodLike = getFunctionKeyValue($member['food_like'], foodLike());
                    $formattedBloodGroup = getFunctionKeyValue($member['blood_group'], bloodGroupType());
                    $memberPath = site_url('uploads/no_image.png');
                    $memberThumbnailPath = site_url('uploads/no_image.png');
                    if ($member['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberPath = site_url() . FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    if ($member['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberThumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    $memberData[$vKey]['member_image'] = $memberPath;
                    $memberData[$vKey]['thumbnail_member_image'] = $memberThumbnailPath;
                    $memberData[$vKey]['gender_display'] = underscoreToUcWord($member["gender"]);
                    $memberData[$vKey]['relation'] = $formattedRelation;
                    $memberData[$vKey]['food_like'] = $formattedFoodLike;
                    $memberData[$vKey]['blood_group'] = $formattedBloodGroup;
                    $memberData[$vKey]['relation_display'] = underscoreToUcWord($member["relation"]);
                    $memberData[$vKey]['food_like_display'] = underscoreToUcWord($member["food_like"]);
                    $memberData[$vKey]['birth_date_display'] = isValidDate($member['birth_date']) ? YMDToDMY($member["birth_date"]) : "";
                }
            }
            if (!empty($memberData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.member_listing_successfully'),
                    'data' => $memberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $memberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function editCustomerProfile()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $memberImage = $this->request->getVar('member_image');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            if (isset($_FILES["member_image"])) {
                $memberImagePath = FLAT_MEMBER_IMAGE_PATH;
                $memberImageResult = $dt_ci_file_upload->uploadFile('member_image', MAX_IMAGE_SIZE_LIMIT, $memberImagePath, true, true, array('jpeg', 'png', 'jpg'),true,true);
                if ($memberImageResult['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($memberImageResult['message']),
                        'data' => null
                    ), 404);
                } else {
                    $memberImageRecord = $memberImageResult['file_name'];
                    unset($memberImageResult['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($memberImageResult, FLAT_MEMBER_IMAGE_PATH, THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
                }
            }
            if (isset($memberImageRecord)) {
                $memberUpdateArray = array();
                $memberArray = array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                );
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1
                ));
                $memberUpdateArray = $ownershipFlatMemberData;
                if ($ownershipFlatMemberData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberData['member_image'])) {
                    unlink(FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberData['member_image']);
                }
                if ($ownershipFlatMemberData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberData['member_image'])) {
                    unlink(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberData['member_image']);
                }
                $memberArray['member_image'] = $memberImageRecord;
                $memberUpdateArray = compareArray($memberArray, $memberUpdateArray);
                $extraData = array();
                $extraObj['api_user_id'] = $userId;
                $extraObj['society_id'] = $societyId;
                $extraData['is_api_data'] = $extraObj;
                $memberData = $this->commonWebserviceModel->insertUpdateRecord($memberArray, 'ownership_flat_member_id', 'tbl_ownership_flat_member', 1, '', array(), $extraData, $memberUpdateArray);

            }
            $memberProfileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_active' => 1,
                'is_show_all_member' => 1
            ));
            if (!empty($memberProfileData)) {
                $path = site_url('uploads/no_image.png');
                $thumbnailPath = site_url('uploads/no_image.png');
                if ($memberProfileData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $memberProfileData['member_image'])) {
                    $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $memberProfileData['member_image'];
                }
                if ($memberProfileData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberProfileData['member_image'])) {
                    $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberProfileData['member_image'];
                }
                $memberProfileData['thumbnail_member_image'] = $thumbnailPath;
                $memberProfileData['member_image'] = $path;
            }
            if (!empty($memberProfileData)) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.profile_updated_successfully'),
                    'data' => $memberProfileData
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.no_data_found')),
                    'data' => $memberProfileData
                ), 400);
            }
        }
    }
    public function scanQRCode()
    {
        $qrCodeNumber = $this->request->getVar('qr_code_number');
        //$type = $this->request->getVar('type');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('qr_code_number', lang('CommonWebService.qr_code_number'), 'required');
        //$this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {

            $type = '';
            $resourceData = array();
            $visitorData = $this->visitorModel->getVisitorData(array(
                'type' => $type,
                'qr_code_number' => $qrCodeNumber,
                'society_id' => $societyId,
            ));

            if (!empty($visitorData)) {
                $type = $visitorData['type'];
            }
            if (empty($visitorData)) {
                $resourceData = $this->resourceModel->getResourceData(array(
                    'qr_code_number' => $qrCodeNumber,
                    'society_id' => $societyId,
                    'is_helper' => 1,
                    'is_multiple' => 1
                ));
                if (!empty($resourceData)) {
                    $type = 'resource';
                }
            }

            $scanQRCodeData = array();

            if ($type == 'resource') {
                $resourceData = $this->resourceModel->getResourceData(array(
                    'qr_code_number' => $qrCodeNumber,
                    'society_id' => $societyId,
                    'is_helper' => 1,
                    'is_multiple' => 1
                ));
                // $objectFilterData = array(
                //     'category_id' => array('category_id', 'category_name'),
                // );
                $resourceFlatDataWise = array();
                // $resourceFlatAlreadyDataWise = array();
                $resourceDocumentDataWise = array();
                $resourceWorkingDayDataWise = array();
                $resourceIdArray = array();
                if (!empty($resourceData)) {
                    foreach ($resourceData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                    if (!empty($resourceIdArray)) {
                        // $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        //     "resource_id" => $resourceIdArray,
                        //  'ownership_flat_member_id' => $ownershipFlatMemberId,
                        //  'is_deleted' => 0,
                        //     "is_multiple" => 1
                        // ));
                        // if(!empty($resourceFlatAlreadyAddedData)) {
                        //     foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                        //         $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        //     }
                        // }
                        $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                            "resource_id" => $resourceIdArray,
                            'is_deleted' => 0,
                            'is_helper' => 1,
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceFlatData)) {
                            foreach ($resourceFlatData as $resourceFlatElement) {
                                $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                            }
                        }
                        $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                            "document_type_id" => $resourceIdArray,
                            "document_type" => 'resource',
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceImageData)) {
                            foreach ($resourceImageData as $resourceImageElement) {
                                if ($resourceImageElement["document_image"] == '') {
                                    $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                    $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                } else {
                                    $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                    $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                }
                                $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                            }
                        }
                    }
                }
                if (!empty($resourceData)) {
                    foreach ($resourceData as $vKey => $resource) {
                        // $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                        $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                        if ($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD) {
                            $status = 'approved';
                            $visitorStatus = 'approved';
                        } else {
                            $status = $resource['visitor_status'];
                            $visitorStatus = $resource['visitor_status'];
                        }
                        $startDate = isValidDate($resource['start_date']) ? $resource['start_date'] : date("Y-m-d H:i:s");
                        $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                        $resourceData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($startDate, $endDate);
                        $resourceData[$vKey]["start_date_time_display"] = date('d M, Y h:i A', strtotime($startDate));
                        $resourceData[$vKey]["end_date_time_display"] = date('d M, Y h:i A', strtotime($endDate));
                        $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                        $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                        $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                        // $resourceData[$vKey]["status"] = (isset($resource['status']) && $resource['status'] === 'approved') ? 'Not Arrived Yet' : $status;
                        $resourceData[$vKey]["visitor_status_display"] = (isset($resource['visitor_status']) && !empty($resource['visitor_status'])) ? underscoreToUcWord($status) : 'approved';
                        $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                        $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                        $path = '';
                        if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                            $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                        }
                        $resourceData[$vKey]['visitor_status'] = $visitorStatus;
                        $resourceData[$vKey]['qr_code_image'] = $path;
                        $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                        $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                        $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                        $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                        // $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'],$resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']]: array();
                        $resourceData[$vKey]['visitor_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                        $shareData = array(
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            "share_link" => "https://digitattva.in/",
                            "share_qr_code_image" => $path,
                        );
                        $resourceData[$vKey]['share_data'] = $shareData;
                    }
                }
                $scanQRCodeData = $resourceData;
            } else {
                $filterArray = array(
                    'type' => $type,
                    'qr_code_number' => $qrCodeNumber,
                    'society_id' => $societyId,
                    'is_multiple' => 1
                );
                $visitorData = visitorListData($filterArray, $userId);
                // $visitorData = $this->visitorModel->getVisitorData(array(
                //  'type' => $type,
                //  'qr_code_number' => $qrCodeNumber,
                //  'society_id' => $societyId,
                //  'is_multiple' => 1
                // ));
                // $objectFilterData = array(
                //     'flat_id' => array('flat_id','tower_flat_name'),
                //     'ownership_flat_member_id' => array('ownership_flat_member_id','name','flat_number','flat_name','member_image','member_number'),
                //     'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
                //     'company_id' => array('company_id','company_name'),
                //     'category_id' => array('category_id','category_name'),
                //  'parking_place_id' => array('parking_place_id','number','parking_block_display'),
                // );
                // $visitorDocumentDataWise = array();
                // $visitorWorkingDayDataWise = array();
                // $visitorIdArray = array();
                // if(!empty($visitorData)) {
                //     foreach($visitorData as $vdKey => $visitorElement){
                //      $path = site_url('uploads/no_image.png');
                //      $memberName = isset($visitorElement['name']) ? $visitorElement['name'] : "";
                //      $flatNumber = isset($visitorElement['tower_flat_name']) ? $visitorElement['tower_flat_name'] : "";
                //      $visitorData[$vdKey]['flat_number'] = $flatNumber;
                //      $visitorData[$vdKey]['flat_name'] = $flatNumber." ".$memberName;
                //      $visitorData[$vdKey]['member_image'] = $path;
                //      if($visitorElement['created_by'] == $userId){
                //          $visitorData[$vdKey]['is_visitor_created_by_me'] = 1;
                //      } else {
                //          $visitorData[$vdKey]['is_visitor_created_by_me'] = 0;
                //      }

                //         $visitorIdArray[] = $visitorElement['visitor_id'];
                //     }
                //     if(!empty($visitorIdArray)){
                //      $visitorWorkingDayData = $this->visitorModel->getVisitorWorkingDayData(array(
                //             "visitor_id" => $visitorIdArray,
                //             "is_multiple" => 1
                //         ));
                //         if(!empty($visitorWorkingDayData)) {
                //             foreach ($visitorWorkingDayData as $visitorWorkingElement) {
                //                 $visitorWorkingDayDataWise[$visitorWorkingElement['visitor_id']][] = $visitorWorkingElement;
                //             }
                //         }
                //         $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                //             "document_type_id" => $visitorIdArray,
                //             "document_type" => 'visitor',
                //             "is_multiple" => 1
                //         ));
                //         if(!empty($visitorImageData)) {
                //             foreach ($visitorImageData as $visitorImageElement) {
                //                 if ($visitorImageElement["document_image"] == '') {
                //                     $visitorImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                //                 } else {
                //                     $visitorImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
                //                 }
                //                 $visitorDocumentDataWise[$visitorImageElement['document_type_id']][] = $visitorImageElement;
                //             }
                //         }
                //     }
                // }
                // if (!empty($visitorData)) {
                //  foreach ($visitorData as $vKey => $visitor) {
                //      $visitorData[$vKey] = getModuleObjectData($objectFilterData,$visitor);
                //      if($visitor['status'] == 'entered' || $visitor['status'] == 'exited'){
                //          $endDate = isValidDate($visitor['end_date']) ? $visitor['end_date'] : date("Y-m-d H:i:s");
                //          $visitorData[$vKey]['difference_start_end_date'] = $this->calculateDateTimeDifference($visitor['start_date'],$endDate);
                //      }
                //      $visitorData[$vKey]['created_at'] = isValidDate($visitor['created_at']) ? YMDToDMY($visitor["created_at"],true) : "";
                //      $visitorData[$vKey]['updated_at'] = isValidDate($visitor['updated_at']) ? YMDToDMY($visitor["updated_at"],true) : "";
                //      $visitorData[$vKey]['visitor_type_display'] = underscoreToUcWord($visitor["type"]);
                //      $visitorData[$vKey]['status_display'] = underscoreToUcWord($visitor["status"]);
                //      $visitorData[$vKey]['created_at_display'] = time_elapsed_string($visitor['created_at']);
                //      $visitorData[$vKey]['updated_at_display'] = time_elapsed_string($visitor['updated_at']);
                //      $visitorData[$vKey]["expected_start_date_time_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y H:i A', strtotime($visitor["expected_start_date_time"])) : "";
                //      $visitorData[$vKey]["expected_end_date_time_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M,Y H:i A', strtotime($visitor["expected_end_date_time"])) : "";
                //      $visitorData[$vKey]["start_date_time_display"] = isValidDate($visitor['start_date']) ? date('d M, Y H:i A', strtotime($visitor["start_date"])) : "";
                //      $visitorData[$vKey]["end_date_time_display"] = isValidDate($visitor['end_date']) ? date('d M, Y H:i A', strtotime($visitor["end_date"])) : "";
                //      $visitorData[$vKey]["expected_start_date_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y', strtotime($visitor["expected_start_date_time"])) : "";
                //      $visitorData[$vKey]["expected_end_date_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M, Y', strtotime($visitor["expected_end_date_time"])) : "";
                //      $visitorData[$vKey]["start_date_display"] = isValidDate($visitor['start_date']) ? date('d M, Y', strtotime($visitor["start_date"])) : "";
                //      $visitorData[$vKey]["end_date_display"] = isValidDate($visitor['end_date']) ? date('d M, Y', strtotime($visitor["end_date"])) : "";
                //      $path = site_url('uploads/no_image.png');
                //      if ($visitor['id_proof'] != '' && file_exists(ID_PROOF_PATH . $visitor['id_proof'])) {
                //          $path = site_url() . ID_PROOF_PATH . $visitor['id_proof'];
                //      }
                //      $visitorData[$vKey]['id_proof'] = $path;
                //      $qrCodePath = '';
                //      if ($visitor['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $visitor['qr_code_image'])) {
                //          $qrCodePath = site_url() . QR_CODE_IMAGE_PATH . $visitor['qr_code_image'];
                //      }
                //      $visitorData[$vKey]['qr_code_image'] = $qrCodePath;

                //      $visitorData[$vKey]['visitor_working_day_data'] = array_key_exists($visitor['visitor_id'],$visitorWorkingDayDataWise) ? $visitorWorkingDayDataWise[$visitor['visitor_id']]: array();
                //      $visitorData[$vKey]['visitor_image_data'] = array_key_exists($visitor['visitor_id'],$visitorDocumentDataWise) ? $visitorDocumentDataWise[$visitor['visitor_id']]: array();
                //      $shareData = array(
                //          'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                //          'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                //          'share_image' => base_url('uploads/no_image.png'),
                //          "share_link" => "https://digitattva.in/",
                //          "share_qr_code_image" => $qrCodePath,
                //      );
                //      $visitorData[$vKey]['share_data'] = $shareData;
                //  }
                // }
                $scanQRCodeData = $visitorData;
            }

            if (!empty($type) && $type != 'resource') {
                $type = 'visitor';
            }
            if (!empty($scanQRCodeData)) {

                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.qr_code_scan_succesfully'),
                    'data' => $scanQRCodeData,
                    'limit' => DATA_LIMIT,
                    'type' => $type,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'type' => $type,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getNotificationTypeList()
    {
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $filterArray = array(
                'is_multiple' => 1
            );
            $notificationTypeData = $this->commonWebserviceModel->getNotificationTypeData($filterArray);

            $notificationStoreArray = array(
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_multiple' => 1
            );
            $notificationStoreData = $this->commonWebserviceModel->getNotificationStoreList($notificationStoreArray);

            $enabledMapping = array();
            if (!empty($notificationStoreData)) {
                foreach ($notificationStoreData as $store) {
                    $enabledMapping[$store['notification_type_id']] = $store['is_enabled'];
                }
            }

            // Update notification type data
            if (!empty($notificationTypeData)) {
                foreach ($notificationTypeData as &$notification) {
                    $notificationId = $notification['notification_type_id'];
                    if (isset($enabledMapping[$notificationId])) {
                        $notification['is_enabled'] = $enabledMapping[$notificationId];
                    } else {
                        $notification['is_enabled'] = 1;
                    }
                }
            }


            // printArray($notificationStoreData,1);
            if (!empty($notificationTypeData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.notification_type_listing_successfully'),
                    'data' => $notificationTypeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $notificationTypeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function notificationStore()
    {
        $this->db->transBegin();
        $userId = $this->request->getVar('user_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $deviceId = $this->request->getVar('device_id');
        $notificationTypeId = $this->request->getVar('notification_type_id');
        $isEnabled = $this->request->getVar('is_enabled');
        $notificationSettings = $this->request->getVar('notification_settings');

        $this->validation->setRule('notification_type_id', lang('CommonWebService.notification_type_id'), 'required');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $notificationTypeIdArray =  array();
            $isEnabledArray =  array();
            if(isset($notificationSettings) && !empty($notificationSettings)){
                $notificationSettingsArr = json_decode($notificationSettings,true);
                // printArray($notificationSettingsArr,1);
                if(!empty($notificationSettingsArr)){
                    foreach ($notificationSettingsArr as $key => $notificationSettings){
                        $notificationTypeIdArray[] = $key;
                        $isEnabledArray[$key] = $notificationSettings;
                    }
                }
            }

            // printArray($isEnabledArray,1);

            $nsArray = array(
                'device_id' => $deviceId,
                // 'notification_type_id' => $notificationTypeId,
                'notification_type_id' => $notificationTypeIdArray,
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_multiple' => 1
            );

            $notificationStoreData = $this->commonWebserviceModel->getNotificationStoreList($nsArray);

            // printArray($notificationStoreData,1);
            $userDeviceNotificationStoreIdArray = array();
            if (!empty($notificationStoreData)) {
                foreach ($notificationStoreData as $nsElement) {
                    $userDeviceNotificationStoreIdArray[] = $nsElement['user_device_notification_config_id'];
                }

                if (!empty($userDeviceNotificationStoreIdArray)) {
                    $this->commonWebserviceModel->deleteNotificationStoreRecord($userDeviceNotificationStoreIdArray, $userId, $societyId);
                }
            }

            $notificationConfigUpdateArray = array();
            $notificationConfigInsertArray = array();
            foreach($notificationTypeIdArray as $notiTypeId) {
                $notificationConfigInsertArray[] = array(
                    'user_device_notification_config_id' => '',
                    'device_id' => $deviceId,
                    'notification_type_id' => $notiTypeId,
                    'society_id' => $societyId,
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_enabled' => isset($isEnabledArray[$notiTypeId]) ? $isEnabledArray[$notiTypeId] : 1,
                );
            }

            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $notificationConfigData = $this->commonWebserviceModel->batchInsert($notificationConfigInsertArray, 'tbl_user_device_notification_config', array());

            $filterArray = array(
                'is_multiple' => 1
            );
            $notificationTypeData = $this->commonWebserviceModel->getNotificationTypeData($filterArray);

            $notificationStoreArray = array(
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_multiple' => 1
            );
            $notificationStoreData = $this->commonWebserviceModel->getNotificationStoreList($notificationStoreArray);

            $enabledMapping = array();
            if (!empty($notificationStoreData)) {
                foreach ($notificationStoreData as $store) {
                    $enabledMapping[$store['notification_type_id']] = $store['is_enabled'];
                }
            }

            if (!empty($notificationTypeData)) {
                foreach ($notificationTypeData as &$notification) {
                    $notificationId = $notification['notification_type_id'];
                    if (isset($enabledMapping[$notificationId])) {
                        $notification['is_enabled'] = $enabledMapping[$notificationId];
                    } else {
                        $notification['is_enabled'] = 1;
                    }
                }
            }
            
            // $notificationConfigArray = array(
            //     'user_device_notification_config_id' => '',
            //     'device_id' => $deviceId,
            //     'notification_type_id' => $notificationTypeId,
            //     'society_id' => $societyId,
            //     'ownership_flat_member_id' => $ownershipFlatMemberId,
            //     'is_enabled' => $isEnabled,
            // );
            // $extraData = array();
            // $extraObj['api_user_id'] = $userId;
            // $extraObj['society_id'] = $societyId;
            // $extraData['is_api_data'] = $extraObj;
            // $notificationConfigData = $this->commonWebserviceModel->insertUpdateRecord($notificationConfigArray, 'user_device_notification_config_id', 'tbl_user_device_notification_config', 1, '', array(), $extraData, $notificationConfigUpdateArray);

            if (isset($notificationConfigData['success']) && $notificationConfigData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.notification_store_successfully'),
                    'data' => $notificationTypeData,
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.notification_store_unsuccessfully'),
                    'data' => $notificationTypeData,
                ), 404);
            }
        }
    }

    public function getAppLoadData(){
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $userId = $this->request->getVar('user_id');
        $filterType = $this->request->getVar('filter_type');
        $appType = $this->request->getVar('app_type');
        $permissionsArray = array();
        if($appType == MEMBER_APP){
            $permissionsToCheck = customerAppPermission();
        }

        if($appType == GATE_KEEPER){
            $permissionsToCheck = gatekeeperAppPermission();

            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                'user_id' => $userId,
                'society_id' => $societyId,
            ));
            if(!empty($userDataPermissionFilter)){
                $permissions = $userDataPermissionFilter['permissions'];
                $unserializedData = unserialize($permissions);
                $permissionsArray = [];
                foreach ($permissionsToCheck as $key => $value) {
                    if(!empty($unserializedData)){
                        if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }                                    
            }
        }

        if($appType == MANAGER_APP){
            $permissionsToCheck = managerAppPermission();

            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                'user_id' => $userId,
                'society_id' => $societyId,
            ));
            if(!empty($userDataPermissionFilter)){
                $permissions = $userDataPermissionFilter['permissions'];
                $unserializedData = unserialize($permissions);
                $permissionsArray = [];
                foreach ($permissionsToCheck as $key => $value) {
                    if(!empty($unserializedData)){
                        if (in_array("MobileManagerApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }                                    
            }
        }

        if($appType == MEMBER_APP){
            $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                'resource_type_name' => 'Member',
                'society_id' => $this->session->get('society_id'),
            ));
            $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_id' => $userId,
                'society_id' => $societyId,
                'resource_type_id' => $resourceTypeData['resource_type_id'],
                // 'type_id' => $ownershipFlatMemberId,
            ));

            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                'user_id' => $userId,
                'society_id' => $societyId,
            ));
            if(!empty($userDataPermissionFilter)){
                $permissions = $userDataPermissionFilter['permissions'];
                $unserializedData = unserialize($permissions);
                $permissionsArray = [];
                foreach ($permissionsToCheck as $key => $value) {
                    if(!empty($unserializedData)){
                        if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }                                    
            }
        }


        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        // $this->validation->setRule('filter_type', lang('CommonWebService.filter_type'), 'required');

        if(empty($filterType) && $filterType == ''){
            $filterType = 'all';
        }

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {


            if(($filterType == 'resident') || ($filterType == 'all') || ($filterType == 'society_directory')){

                $legendsData = array(
                    array(
                        'type' => 'ownership_flat',
                        'name' => 'Ownership Flat',
                        'color_code' => FLAT_OWNER_COLOR_CODE,
                    ),
                    array(
                        'type' => 'rentals',
                        'name' => 'Rentals',
                        'color_code' => VISITOR_COLOR_CODE,
                    ),
                );

                $legendsDataIdWise = array();
                if (!empty($legendsData)) {
                    foreach ($legendsData as $legendsElement) {
                        $legendsDataIdWise[$legendsElement['type']] = $legendsElement;
                    }
                }

                $towerData = $this->towerModel->getTowerData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_active" => 1
                ));

                $towerFloorData = $this->towerModel->getTowerUnitData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_active" => 1
                ));

                $flatData = $this->flatModel->getFlatData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_active" => 1
                ));

                $flatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_show_all_member" => 1,
                ));

                $rentalsWiseData = array();

                if(!empty($flatMemberData)){
                    foreach($flatMemberData as $flatMemberElement){
                        if($flatMemberElement['type'] == 'rentals'){
                            $rentalsWiseData[] = $flatMemberElement['type_id'];
                        }
                    }
                }
                // printArray($rentalsWiseData);
                $rentalsAgreementPeriodCheck = $this->rentalModel->getRentalsData(array(
                    'rentals_id' => $rentalsWiseData,
                    'is_api_call' => 1,
                    'check_flat_rent' => 1,
                    "society_id" => $societyId,
                    'is_multiple' => 1
                ));

                $flatMemberVehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_show_all_parking" => 1,
                ));

                $rentalsVehicleWiseData = array();
                if(!empty($flatMemberVehicleData)){
                    foreach($flatMemberVehicleData as $flatMemberVehicleElement){
                        if($flatMemberVehicleElement['type'] == 'rentals'){
                            $rentalsVehicleWiseData[] = $flatMemberVehicleElement['type_id'];
                        }
                    }
                }

                if (!empty($flatMemberData)) {
                    if (!empty($rentalsAgreementPeriodCheck)) {
                        $validRentalsAgreementPeriod = array_column($rentalsAgreementPeriodCheck, 'rentals_id');
                        foreach ($flatMemberData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals' && !in_array($flatMemberElement['type_id'], $validRentalsAgreementPeriod)) {
                                unset($flatMemberData[$key]); // Agar agreement me nahi hai toh remove karo
                            }
                        }
                        $flatMemberData = array_values($flatMemberData);
                    } else {
                        // Agr rentalsAgreementPeriodCheck empty hai, toh koi bhi rentals nahi ana chahiye
                        foreach ($flatMemberData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals') {
                                unset($flatMemberData[$key]);
                            }
                        }
                        $flatMemberData = array_values($flatMemberData);
                    }
                }

                if (!empty($flatMemberVehicleData)) {
                    if (!empty($rentalsAgreementPeriodCheck)) {
                        $validRentalsParkingPeriod = array_column($rentalsAgreementPeriodCheck, 'rentals_id');
                        foreach ($flatMemberVehicleData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals' && !in_array($flatMemberElement['type_id'], $validRentalsParkingPeriod)) {
                                unset($flatMemberVehicleData[$key]); // Agar Parking me nahi hai toh remove karo
                            }
                        }
                        $flatMemberVehicleData = array_values($flatMemberVehicleData);
                    } else {
                        // Agr rentalsAgreementPeriodCheck empty hai, toh koi bhi rentals nahi ana chahiye
                        foreach ($flatMemberVehicleData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals') {
                                unset($flatMemberVehicleData[$key]);
                            }
                        }
                        $flatMemberVehicleData = array_values($flatMemberVehicleData);
                    }
                }

                $memberGrouped = [];
                foreach ($flatMemberData as $member) {
                    $flatId = $member['flat_id'];
                    $type = $member['type']; // 'ownership_flat' or 'rentals'
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($member['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    if ($member['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    $member['thumbnail_member_image'] = $thumbnailPath;
                    $member['member_image'] = $path;

                    if (!isset($memberGrouped[$flatId])) {
                        $memberGrouped[$flatId] = ['ownership_flat' => [], 'rentals' => []];
                    }
                    // if ($member['type'] === 'ownership_flat' && $member['is_owner'] != 1) {
                    //     continue; // Skip non-owners in ownership_flat
                    // }
                    $memberGrouped[$flatId][$type][] = $member;
                }

                $vehicleGrouped = [];
                foreach ($flatMemberVehicleData as $vehicle) {
                    $flatId = $vehicle['flat_id'];
                    $type = $vehicle['type']; // 'ownership_flat' or 'rentals'
                    if (!isset($vehicleGrouped[$flatId])) {
                        $vehicleGrouped[$flatId] = ['ownership_flat' => [], 'rentals' => []];
                    }
                    $vehicleGrouped[$flatId][$type][] = $vehicle;
                }

                $floorGrouped = [];
                foreach ($flatData as $flat) {
                    $flatId = $flat['flat_id'];
                    $floorId = $flat['floor_id'];
                    $flat['member_data'] = $memberGrouped[$flatId] ?? ['ownership_flat' => [], 'rentals' => []];
                    $flat['vehicle_data'] = $vehicleGrouped[$flatId] ?? ['ownership_flat' => [], 'rentals' => []];
                    $flat['ownership_flat_name'] = '';
                    if (!empty($flat['member_data']['rentals'])) {
                        $flat['color_code'] = $legendsDataIdWise['rentals']['color_code'];
                        $flat['type'] = 'rentals';
                        foreach ($flat['member_data']['rentals'] as $rentalsElement) {
                            if (!empty($rentalsElement['agreement_with'])) {
                                $flat['ownership_flat_name'] = $rentalsElement['name'];
                                $flat['member_image'] = $rentalsElement['member_image'];
                                break; // Stop checking once rentals is found
                            }
                        }
                    } else {
                        $flat['color_code'] = $legendsDataIdWise['ownership_flat']['color_code'];
                        $flat['type'] = 'ownership_flat';
                    }

                    if (empty($flat['ownership_flat_name']) && !empty($flat['member_data']['ownership_flat'])) {
                        foreach ($flat['member_data']['ownership_flat'] as $owner) {
                            if ($owner['is_owner'] == 1) {
                                $flat['ownership_flat_name'] = $owner['name'];
                                $flat['member_image'] = $owner['member_image'];
                                break; // Stop checking once owner is found
                            }
                        }
                    }
                    // Add flat to floor grouping
                    if (!isset($floorGrouped[$floorId])) {
                        $floorGrouped[$floorId] = [];
                    }
                    if(!empty($flat['ownership_flat_name'])){
                        $floorGrouped[$floorId][] = $flat;
                    }
                }

                $towerGrouped = [];
                foreach ($towerFloorData as $floor) {
                    $towerId = $floor['tower_id'];
                    $floorId = $floor['tower_unit_id'];
                    $floor['flat_data'] = $floorGrouped[$floorId] ?? [];
                    if (!isset($towerGrouped[$towerId])) {
                        $towerGrouped[$towerId] = [];
                    }
                    if(!empty($floor['flat_data'])){
                        $towerGrouped[$towerId][] = $floor;
                    }
                }
                // printARray($towerGrouped,1);
                $finalTowerArray = [];
                foreach ($towerData as $tower) {
                    $towerId = $tower['tower_id'];
                    $tower['floor_data'] = $towerGrouped[$towerId] ?? [];
                    $finalTowerArray[] = $tower;
                }
                $data['legends_data'] = $legendsData;
                $data['residence_data'] = $finalTowerArray;

            }

            if(($filterType == 'profile') || ($filterType == 'all')){
                $profileData = new \stdClass();
                $type = '';
                $typeId = '';
                // Get Member Profile
                if ($appType == MEMBER_APP) {
                    $profileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_active' => 1,
                        'is_show_all_member' => 1
                    ));
                    if (!empty($profileData)) {
                        $path = site_url('uploads/no_image.png');
                        $thumbnailPath = site_url('uploads/no_image.png');
                        if ($profileData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'])) {
                            $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'];
                        }
                        if ($profileData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'])) {
                            $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'];
                        }
                        $profileData['thumbnail_member_image'] = $thumbnailPath;
                        $profileData['member_image'] = $path;
                    }
                }
                // Get Gate Keeper Profile
                if ($appType == GATE_KEEPER) {
                    $resourceTypeGuardData = $this->resource_type_model->getResourceTypeData(array(
                        'is_guard' => 1,
                        'is_multiple' => 1,
                        'is_login' => 1,
                        'is_active' => 1,
                        'society_id' => $this->session->get('society_id'),
                    ));
                    $resourceTypeIdArray = [];
                    if (!empty($resourceTypeGuardData)) {
                        foreach ($resourceTypeGuardData as $resourceTypeElement) {
                            $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                        }
                    }
                    $profileFilterArray = array(
                        'society_id' => $societyId,
                        'user_id' => $userId,
                        'resource_type_id' => $resourceTypeIdArray
                    );
                    $userSocietyData = $this->ionAuthModel->getUserSocietyWiseData($profileFilterArray);
                    $type = isset($userSocietyData['type']) ? $userSocietyData['type'] : '';
                    $typeId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : '';
                    if ($type == GATE_KEEPER) {
                        $profileData = $this->resourceModel->getResourceData(array("resource_id" => $typeId, 'society_id' => $societyId,'is_login' => 1,'is_active' => 1,'is_guard' => 1));
                        if (!empty($profileData)) {
                            $profileData['date_of_birth'] = isset($profileData['date_of_birth']) ? YMDToDMY($profileData["date_of_birth"]) : "";
                            $profileData['working_hours'] = "10:00 AM To 07:00 PM";
                            $profileData['support_number'] = "-";
                            $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $typeId,
                                "document_type" => 'resource',
                                "is_multiple" => 1
                            ));
                            if (!empty($resourceImageData)) {
                                foreach ($resourceImageData as $siKey => $resourceImageElement) {
                                    $paths = '';
                                    $thumbnailPaths = '';
                                    if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                        $paths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                                    }
                                    if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                        $thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                                    }
                                    $resourceImageData[$siKey]['thumbnail_document_image'] = $thumbnailPaths;
                                    $resourceImageData[$siKey]['document_image'] = $paths;
                                }
                            }
                            $profileData['resource_image_data'] = $resourceImageData;
                        }
                    } 
                }
                // Get Manager Profile
                if($appType == MANAGER_APP){
                    $profileData = $this->commonWebserviceModel->getUserData(array(
                        'id' => $userId,
                    ));
                }
                // printArray($profileData,1);
                $data['profile_data'] = $profileData;
            }

            if(($filterType == 'settings_data') || ($filterType == 'all')){
                $settingFilterArray = array(
                    'society_id' => $societyId,
                );
                $settingData = $this->settingModel->getSettingData($settingFilterArray);

                $data['setting_data'] = $settingData;
            }

            if(($filterType == 'society_directory') || ($filterType == 'all')){
                
                // service_directory
                $filterArray = array(
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'start' => -1,
                    'society_id' => $societyId,
                    'user_id' => $userId,
                    'is_api' => 1,
                );
                $categoryData = $this->categoryModel->getCategoryData(array(
                    'category_for' => 'vendor',
                    'is_multiple' => 1,
                    'is_active' => 1,
                ));
                $vendorData = $this->vendorModel->getVendorData($filterArray);
                if (!empty($vendorData)) {
                    foreach ($vendorData as $vkey => $vendor) {
                        $vendorData[$vkey]['created_at'] = YMDToDMY($vendor["created_at"], true);
                        $vendorData[$vkey]['updated_at'] = YMDToDMY($vendor["updated_at"], true);
                        $vendorData[$vkey]['created_at_display'] = time_elapsed_string($vendor['created_at']);
                        $vendorData[$vkey]['updated_at_display'] = time_elapsed_string($vendor['created_at']);
                        $mobileNumbers = explode(', ', $vendor['vendor_mobile_no']);
                        $personNames = explode(', ', $vendor['vendor_person_name']);
                        $designations = explode(', ', $vendor['vendor_designation']);
                        $contactInfo = [];
                        foreach ($mobileNumbers as $index => $mobile) {
                            $contactInfo[] = [
                                'mobile_no' => $mobile,
                                'person_name' => $personNames[$index] ?? null,
                                'designation' => $designations[$index] ?? null
                            ];
                        }
                        $vendorData[$vkey]['contact_info'] = $contactInfo;
                        $vendorData[$vkey]['vendor_category_name'] = explode(', ', $vendor['vendor_category_name']);
                        $vendorData[$vkey]['vendor_category_id'] = explode(', ', $vendor['vendor_category_id']);
                        $shareData = [
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            'share_link' => 'https://digitattva.in/',
                        ];
                        $vendorData[$vkey]['share_data'] = $shareData;
                    }
                }
                $data['category_data'] = $categoryData;

                // society_committee
                $filterArray = array(
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'start' => -1,
                    'society_id' => $societyId,
                    'user_id' => $userId,
                    'is_api' => 1,
                );
                $committeeData = $this->managementCommitteeModel->getManagementCommitteeData($filterArray);
    
                $responsibilityData = $this->managementCommitteeResponsibilitiesModel->getManagementCommitteeResponsibilitiesData(array(
                    'is_multiple' => 1,
                    'is_active' => 1,
                ));
    
                $responsibilitiesDataCmmitteeIdWise = array();
                if (!empty($committeeData)) {
                    foreach ($committeeData as $ckey => $committee) {
                        $committeeData[$ckey]['created_at'] = YMDToDMY($committee["created_at"], true);
                        $committeeData[$ckey]['updated_at'] = YMDToDMY($committee["updated_at"], true);
                        $committeeData[$ckey]['created_at_display'] = time_elapsed_string($committee['created_at']);
                        $committeeData[$ckey]['updated_at_display'] = time_elapsed_string($committee['created_at']);
                        $shareData = array(
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            "share_link" => "https://digitattva.in/",
                        );
                        $committeeData[$ckey]['share_data'] = $shareData;
                        $responsibilitiesData = $this->managementCommitteeModel->getManagementCommitteeResponsibilitiesData(array(
                            "management_committee_id" => $committee['management_committee_id'],
                            'is_multiple' => 1
                        ));
                        if (!empty($responsibilitiesData)) {
                            foreach ($responsibilitiesData as $responsibilitiesElement) {
                                $responsibilitiesDataCmmitteeIdWise[$responsibilitiesElement['management_committee_id']][] = $responsibilitiesElement;
                            }
                        }
                        $committeeData[$ckey]['responsibilites_data'] = array_key_exists($committee['management_committee_id'], $responsibilitiesDataCmmitteeIdWise) ? $responsibilitiesDataCmmitteeIdWise[$committee['management_committee_id']] : array();
                    }
                }
                $data['responsibility_data'] = $responsibilityData;
                // emergency_directory
                $filterArray = array(
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'is_deleted' => 0,
                    'start' => -1,
                    'user_id' => $userId
                );
                $emergencyData = $this->commonWebserviceModel->getEmergencyData($filterArray);
                $emergencyIdArray = array();
                $emergencyDocumentDataWise = array();
                if (!empty($emergencyData)) {
                    foreach ($emergencyData as $emergencyElement) {
                        $emergencyIdArray[] = $emergencyElement['emergency_number_id'];
                    }
    
                    if (!empty($emergencyIdArray)) {
                        $emergencyImageData = $this->visitorModel->getDocumentImageData(array(
                            "document_type_id" => $emergencyIdArray,
                            "document_type" => 'emergency_contact',
                            "is_multiple" => 1
                        ));
    
                        if (!empty($emergencyImageData)) {
                            foreach ($emergencyImageData as $emergencyImageElement) {
                                if ($emergencyImageElement["document_image"] == '') {
                                    $emergencyImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                    $emergencyImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                } else {
                                    $emergencyImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $emergencyImageElement["document_image"];
                                    $emergencyImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $emergencyImageElement["document_image"];
                                }
                                $emergencyDocumentDataWise[$emergencyImageElement['document_type_id']][] = $emergencyImageElement;
                            }
                        }
                    }
                }
    
                if (!empty($emergencyData)) {
                    foreach ($emergencyData as $ekey => $emergency) {
                        $emergencyData[$ekey]['created_at'] = YMDToDMY($emergency["created_at"], true);
                        $emergencyData[$ekey]['updated_at'] = YMDToDMY($emergency["updated_at"], true);
                        $emergencyData[$ekey]['created_at_display'] = time_elapsed_string($emergency['created_at']);
                        $emergencyData[$ekey]['updated_at_display'] = time_elapsed_string($emergency['created_at']);
                        $shareData = array(
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            "share_link" => "https://digitattva.in/",
                        );
                        $emergencyData[$ekey]['share_data'] = $shareData;
                        $emergencyData[$ekey]['emergency_image_data'] = array_key_exists($emergency['emergency_number_id'], $emergencyDocumentDataWise) ? $emergencyDocumentDataWise[$emergency['emergency_number_id']] : array();
                    }
                }


                $data['society_directory'] = array(
                    'residence_data' => (isset($data['residence_data']) && !empty($data['residence_data'])) ? $data['residence_data'] : array(),
                    'service_directory' => (isset($vendorData) && !empty($vendorData)) ? $vendorData : array(),
                    'society_committee' => (isset($committeeData) && !empty($committeeData)) ? $committeeData : array(),
                    'emergency_directory' => (isset($emergencyData) && !empty($emergencyData)) ? $emergencyData : array(),
                );
            }


            $sosTypeArray = sosTypeAPI();

            if ($appType === GATE_KEEPER) {
                foreach ($sosTypeArray as $index => $item) {
                    if ($item['key'] === 'family') {
                        unset($sosTypeArray[$index]);
                    }
                }
            }
            $sosTypeArray = array_values($sosTypeArray);
            $data['sos'] = $sosTypeArray; 
            $data['week_days'] = weekDays(); 
            $data['complain_type'] = complainTypeApi(); 
            $data['reading_type'] = readingTypeAPI();

            


            if ((!empty($data['setting_data'])) || (!empty($data['profile_data'])) || (!empty($data['legends_data'])) || (!empty($data['residence_data'])) || (!empty($data['society_directory']))
                || (!empty($data['sos'])) || (!empty($data['week_days'])) || (!empty($data['reading_type'])) || (!empty($data['complain_type'])) || (!empty($permissionsArray))
            ) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.app_loaded_data_successfully'),
                    'data' => $data,
                    'user_permission_array' => $permissionsArray,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null,
                    'user_permission_array' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function sendBulk()
    {
//      $userIds = ['6c522c3a-5a4b-4c0e-ace4-ca77637f3d11', '6d50d161-320e-4002-a895-40e1e7e07acb']; // Add the player IDs here
//      $heading = 'Notification Title';
//      $message = 'This is a bulk notification message.';
//
//      $response = testNo($heading, $message, $userIds);

        return json_encode($response);
    }

    function _remap($method)
    {
        // Sure it exists, but can they do anything with it?
        if (!method_exists($this, $method)) {
            $data = array(
                'status' => false,
                'message' => "Unknown method",
                'response_code' => 405,
                'data' => null,
            );
            return $this->response($data, 405);
        }

        if (method_exists($this, $method)) {
            $this->logRequest($authorized = TRUE);
            return $this->$method();
        }
    }

    protected function logRequest($authorized = FALSE, $response = "")
    {
        $request = request();
        $header = $request->Header('Authorization');
        if ($header != '') {
            if (!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $requestArray = array();
            $requestArray = $request->getVar();
            $requestArray['Authorization'] = $token;
            $params = $requestArray;
        } else {
            $params = $request->getVar();
        }

        $builder = $this->db->table('tbl_logs');
        $data['uri'] = uri_string();
        $data['method'] = $this->request->getMethod();
        $data['params'] = json_encode($params);
        $data['api_key'] = '';
        $data['ip_address'] = $request->getIPAddress();
        $data['time'] = time();
        $data['authorized'] = $authorized;
        $data['response'] = $response;
        $data['request_time'] = date("Y-m-d h:i:s");
        // Insert the request into the log table
        $builder->insert($data);
        $this->insertId = $this->db->insertID();

    }

    protected function logAccessTime()
    {
        if ($this->insertId == '') {
            return false;
        }

        $payload['rtime'] = $this->endRtime - $this->startRtime;
        $builder = $this->db->table('tbl_logs');

        $builder->where('id', $this->insertId);
        $builder->update($payload);
    }

    protected function logResponseCode($http_code, $output)
    {
        if ($this->insertId == '') {
            return false;
        }

        $payload['response_code'] = $http_code;
        $payload['response'] = $output;
        $payload['responsetime'] = time();
        $payload['response_time'] = date("Y-m-d h:i:s");

        $builder = $this->db->table('tbl_logs');

        $builder->where('id', $this->insertId);
        $builder->update($payload);
    }

    function response($data = array(), $http_code = NULL, $continue = FALSE)
    {

        if ($http_code !== NULL) {
            // So as to be safe later on in the process
            $http_code = (int)$http_code;
        }
        // Set the output as NULL by default
        $output = NULL;

        // If data is NULL and no HTTP status code provided, then display, error and exit
        if ($data === NULL && $http_code === NULL) {
            $http_code = 404;
        } // If data is not NULL and a HTTP status code provided, then continue
        elseif ($data !== NULL) {
            $output = json_encode($data);
        }

        // If not greater than zero, then set the HTTP status code as 200 by default
        // Though perhaps 500 should be set instead, for the developer not passing a
        // correct HTTP status code
        $http_code > 0 || $http_code = 200;
        // JC: Log response code only if rest logging enabled
        if (REST_ENABLE_LOGGING === TRUE) {
            $this->logResponseCode($http_code, $output);
        }
        return $this->respond($data, $http_code);
    }
}

?>
