<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\WaterMeterReadingModel;
use App\Models\SocietyModel;
use App\Models\WaterTankModel;

class WaterMeterReading extends BaseController
{
	protected $water_meter_reading_model;
    public function __construct() {
        $this->water_meter_reading_model = new WaterMeterReadingModel();
        $this->water_tank_model = new WaterTankModel();
        $this->society_model = new SocietyModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Water Meter Reading';
        return $this->dt_ci_template->load("Admin","WaterMeterReading/WaterMeterReadingView",$data);
	}

	public function manage($waterMeterReadingId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($waterMeterReadingId != '') {
			$filterData = array(
				"water_meter_reading_id" => $waterMeterReadingId
			);
			$data['water_meter_reading_data'] = $this->water_meter_reading_model->getWaterMeterReadingData($filterData);

            if(empty($data['water_meter_reading_data'])){
                return redirect()->to('Admin/WaterMeterReading/manage');
            }
		}
		if ($waterMeterReadingId != '') {
			$data['title'] = 'Edit Water Meter Reading';
		} else {
			$data['title'] = 'Add Water Meter Reading';
		}

		if ((isset($data['water_meter_reading_data']['society_id']) && $data['water_meter_reading_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/WaterMeterReading');
        }
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
		return $this->dt_ci_template->load("Admin","WaterMeterReading/WaterMeterReadingManageView",$data);
	}

    public function getWaterMeterReadingListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_water_meter_reading as twmr");
		$this->datatables->select("twmr.water_meter_reading_id,ts.society_name,ts.society_name,twmr.is_active,twmr.availability_volume,twmr.supply_volume,twmr.reading_date_time,twmr.remarks,twt.water_tank_name,twmr.source");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,twmr.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = twmr.society_id","left");
		$this->datatables->join("tbl_water_tank as twt","twt.water_tank_id = twmr.water_tank_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = twmr.updated_by AND tupdate.society_id = twmr.society_id","left");
		$this->datatables->groupBy("twmr.water_meter_reading_id");
		accessFilter($this->datatables, array("society" => "twmr.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"water_meter_reading_id" => isset($data[$key]['water_meter_reading_id']) ? $data[$key]['water_meter_reading_id'] : ""
				);
				$data[$key]['action_button'] = waterMeterReadingActionButton($actionButtonFilter);
				$data[$key]['reading_date_time'] = isValidDate($data[$key]['reading_date_time']) ? siteDateFormat($data[$key]['reading_date_time'],true) : "";
				$data[$key]['source'] = isset($data[$key]['source']) ? underscoreToUcWord($data[$key]['source']) : "";
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $waterMeterReadingId = $this->request->getVar('water_meter_reading_id');
        $status = $this->request->getVar('status');
        $return = $this->water_meter_reading_model->statusChange($waterMeterReadingId,$status,'water_meter_reading_id','tbl_water_meter_reading');
		if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('WaterMeterReading.water_meter_reading'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('WaterMeterReading.water_meter_reading'));
        }
		echo json_encode($response);
		exit;
    }

    public function save()
	{
        $this->db->transStart();
		$validation = \Config\Services::validation();
		$waterMeterReadingId = $this->request->getVar('water_meter_reading_id');
		$waterTankId = $this->request->getVar("water_tank_id");
		$availabilityVolume = $this->request->getVar("availability_volume");
		$source = $this->request->getVar("source");
		$supplyVolume = $this->request->getVar("supply_volume");
		$readingDateTime = $this->request->getVar("reading_date_time");
		$remarks = $this->request->getVar("remarks");
		$isActive = $this->request->getVar("is_active");

		$validation->setRule('availability_volume', lang('WaterMeterReading.availability_volume'), 'required');
		$validation->setRule('water_tank_id', lang('WaterMeterReading.water_tank'), 'required');
		$validation->setRule('source', lang('WaterMeterReading.source'), 'required');
		$validation->setRule('reading_date_time', lang('WaterMeterReading.reading_date_time'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $waterMeterReadingData = $this->water_meter_reading_model->getWaterMeterReadingData(array(
                'water_tank_id' => $waterTankId,
            )); 

            if(!empty($waterMeterReadingData) && strtotime($waterMeterReadingData['reading_date_time']) >= strtotime($readingDateTime)){
                $response['success'] = false;
                $response['msg'] = lang('WaterMeterReading.can/t_edit_past_record');
                echo json_encode($response);
                exit;
            }

			$waterMeterReadingUpdateArray = array();
			$waterMeterReadingArray = array(
				'water_meter_reading_id' => $waterMeterReadingId,
				'water_tank_id' => $waterTankId,
				'availability_volume' => $availabilityVolume,
				'source' => $source,
				'supply_volume' => $supplyVolume,
				'society_id' => $this->session->get('society_id'),
				'remarks' => $remarks,
				'reading_date_time' => DMYToYMD($readingDateTime,true,true),
				'is_active' => isset($isActive) ? 1 : 0,
			);
			if(!empty($waterMeterReadingId)){
                $waterMeterReadingUpdateData = $this->water_meter_reading_model->getWaterMeterReadingData(array(
                    'water_meter_reading_id' => $waterMeterReadingId,
                ));
                $waterMeterReadingUpdateArray = compareArray($waterMeterReadingArray,$waterMeterReadingUpdateData);
            }
			$waterMeterReadingData = $this->water_meter_reading_model->insertUpdateRecord($waterMeterReadingArray, 'water_meter_reading_id', 'tbl_water_meter_reading', 1,'',array(),array(),$waterMeterReadingUpdateArray);
			$lastWaterMeterReadingId = $waterMeterReadingData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
			if (isset($waterMeterReadingId) && $waterMeterReadingId != '') {
                if (($waterMeterReadingData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('WaterMeterReading.water_meter_reading'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('WaterMeterReading.water_meter_reading'));
                }
            } else {
                if (($waterMeterReadingData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('WaterMeterReading.water_meter_reading'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('WaterMeterReading.water_meter_reading'));
                }
            }
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $waterMeterReadingId = $this->request->getVar('water_meter_reading_id');
        $waterMeterReadingData = $this->water_meter_reading_model->deleteRecord($waterMeterReadingId);
        $transactionStatus = $this->db->transComplete();
        if (($waterMeterReadingData)  && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("WaterMeterReading.water_meter_reading"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("WaterMeterReading.water_meter_reading"));
        }
        echo json_encode($response);
        exit;
    }
    public function excelExportWaterMeterReading()
    {
        $fileName ='WMR-' . DATETIMEFORMAT;
        $sheetName = 'WMR-' . DATEFORMAT;
        $excelHeaderName = 'Water Meter Reading';
        $tableData = $this->getWaterMeterReadingListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('WaterMeterReading.society'),
            lang('WaterMeterReading.water_tank'),
            lang('WaterMeterReading.reading_date_time'),
            lang('WaterMeterReading.source'),
            lang('WaterMeterReading.availability_volume'),
            lang('WaterMeterReading.supply_volume'),
            lang('WaterMeterReading.remarks'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["water_tank_name"],
                $row["reading_date_time"],
                $row["source"],
                $row["availability_volume"],
                $row["supply_volume"],
                $row["remarks"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'H';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function waterMeterReadingPdf()
    {
        if(!$this->dt_ci_acl->checkAccess('WaterMeterReading|pdf')){
            return NO_ACCESS_SECTION;
        } else {
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            $data['society_data'] = $societyData;
            $filterData = array(
                'is_multiple' => 1,
            );
            $data['water_meter_reading_data'] = $this->water_meter_reading_model->getWaterMeterReadingData($filterData);
            $data['name'] = lang("WaterMeterReading.water_meter_reading_pdf") . ".pdf";
            $printHeader = '';
            $printFooter = '';
            $printFooter = pdfFooter( 0, array());
            $html = view('Admin/WaterMeterReading/pdf/WaterMeterReadingPdfView', $data);
            generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
        }
    }

    public function getAvailabilityVolume() {
		// printArray($_POST,1);
		$validation = \Config\Services::validation();
		$waterTankId = $this->request->getVar('water_tank_id');
		$waterMeterReadingId = $this->request->getVar('water_meter_reading_id');
		$readingDateTime = $this->request->getVar('reading_date_time');
		// $availibilityVolume = $this->request->getVar('availability_volume');
		$supplyVolume = $this->request->getVar('supply_volume');
        // $readingDateTimeMinusOneDay = date('Y-m-d', strtotime($readingDateTime . ' -1 day'));
		
		$validation->setRule('water_tank_id', lang('Event.water_tank_id'), 'required',array("required" => lang('Event.water_tank_id')." Is Required"));
		$validation->setRule('reading_date_time', lang('Event.reading_date_time'), 'required',array("required" => lang('Event.reading_date_time')." Is Required"));

		if (!$validation->withRequest($this->request)->run()) {
			$errors = $validation->getErrors();
			$response['success'] = false;
			$response['msg'] = implode("\n", $errors);
			echo json_encode($response);
			exit;
		} else {
			
                // printArray($readingDateTimeMinusOneDay,1);
                $waterMeterReadingData = $this->water_meter_reading_model->getWaterMeterReadingData(array(
                    'water_tank_id' => $waterTankId,
                    'get_last_record' => 1,
                    'water_meter_reading_id_not' => $waterMeterReadingId,
                    // 'reading_date_time' => $readingDateTimeMinusOneDay,
                ));

                if(!empty($waterMeterReadingData)){
                    $newAvailabilityVolume = $supplyVolume + $waterMeterReadingData['availability_volume'];
                    $response['success'] = true;
                    $response['availability_volume'] = $newAvailabilityVolume;
                    echo json_encode($response);
                    exit;
                } else {
                    // $newAvailabilityVolume = $;
                    $response['success'] = true;
                    $response['availability_volume'] = $supplyVolume;
                    echo json_encode($response);
                    exit;
                }
			}
		}
	}

