<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\VisitorCompanyModel;
class VisitorCompany extends BaseController
{
    protected $visitor_company_model;
    public function __construct() {
        $this->visitor_company_model = new VisitorCompanyModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Visitor Company';
        $data['visitor_company_model_view'] = view('Admin/VisitorCompany/VisitorCompanyModalView', $data);
        return $this->dt_ci_template->load("Admin","VisitorCompany/VisitorCompanyView",$data);
    }

    public function getVisitorCompanyListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_visitor_company as tvc");
        $this->datatables->select("tvc.visitor_company_id, tvc.visitor_company_name, tvc.is_active,tvc.visitor_company_type,tvc.visitor_company_image");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tvc.created_at,tvc.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tvc.updated_by AND tupdate.society_id = tvc.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tvc.created_by AND tcreate.society_id = tvc.society_id","left");
        $this->datatables->groupBy("tvc.visitor_company_id");
        accessFilter($this->datatables, array("society" => "tvc.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "visitor_company_id" => isset($displayData['visitor_company_id']) ? $displayData['visitor_company_id'] : ""
                );
                $data[$key]['action_button'] = visitorCompanyActionButton($actionButtonFilter);
                $data[$key]['display_visitor_company_type'] = underscoreToUcWord($displayData['visitor_company_type']);
                $imageUrl = '';
                $imageThumbnailUrl = '';
                if(isset($displayData['visitor_company_image']) && $displayData['visitor_company_image'] != '') {
                    $imageUrl = site_url() . VISITOR_COMPANY_IMAGE_PATH . $displayData['visitor_company_image'];
                }
                if(isset($displayData['visitor_company_image']) && $displayData['visitor_company_image'] != '') {
                    $imageThumbnailUrl = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $displayData['visitor_company_image'];
                }
                $data[$key]['thumbnail_visitor_company_image'] = $imageThumbnailUrl;
                $data[$key]['visitor_company_image'] = $imageUrl;
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $visitorCompanyName = $this->request->getVar('visitor_company_name');
        $visitorCompanyType = $this->request->getVar('visitor_company_type');
        $isActive = $this->request->getVar('is_active');
        if (isset($visitorCompanyId) && $visitorCompanyId == '') {
            $validation->setRule('visitor_company_name', lang('VisitorCompany.visitor_company_name'), 'required|checkTenantUnique[tbl_visitor_company.visitor_company_name]',array('checkTenantUnique' => 'This {field} Already Exists'));
        } else {
            $validation->setRule('visitor_company_name', lang('VisitorCompany.visitor_company_name'), 'required|checkTenantUnique[tbl_visitor_company.visitor_company_name,visitor_company_id,'.$visitorCompanyId.']',array('checkTenantUnique' => 'This {field} Already Exists'));
        }
        $validation->setRule('visitor_company_type', lang('VisitorCompany.visitor_company_type'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $visitorCompanyUpdateArray = array();
            $visitorCompanyArray = array(
                'visitor_company_id' => $visitorCompanyId,
                'visitor_company_name' => $visitorCompanyName,
                'visitor_company_type' => $visitorCompanyType,
                'is_active' => isset($isActive) ? 1 : 0,
                'society_id' => $this->session->get('society_id'),
            );
            if(!empty($visitorCompanyId)){
                $visitorCompanyUpdateData = $this->visitor_company_model->getVisitorCompanyData(array(
                    'visitor_company_id' => $visitorCompanyId,
                ));
                $visitorCompanyUpdateArray = compareArray($visitorCompanyArray,$visitorCompanyUpdateData);
            }
            $visitorCompanyData = $this->visitor_company_model->insertUpdateRecord($visitorCompanyArray,'visitor_company_id','tbl_visitor_company', 1,'',array(),array(),$visitorCompanyUpdateArray);
            $lastVisitorCompanyId = $visitorCompanyData['lastInsertedId'];
            if (isset($visitorCompanyData['success']) && $visitorCompanyData['success']) {
                if (isset($_FILES['visitor_company_image'])) {
                    $visitorCompanyImagePath    = VISITOR_COMPANY_IMAGE_PATH;
                    $imageResult        = $this->dt_ci_file_upload->UploadFile('visitor_company_image', MAX_IMAGE_SIZE_LIMIT, $visitorCompanyImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
                    if ($imageResult['success'] == false) {
                        $response['success']    = false;
                        $response['msg']        = strip_tags($imageResult['message']);
                        echo json_encode($response);
                        die();
                    } else {
                        unset($imageResult['success']);
                        $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailUploadFile($imageResult, VISITOR_COMPANY_IMAGE_PATH, THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH);

                        if ($lastVisitorCompanyId != '') {
                            $imageData = $this->visitor_company_model->getVisitorCompanyData(array("visitor_company_id" => $lastVisitorCompanyId));
                            $imageUrl = '';
                            if(isset($imageData['visitor_company_image']) && $imageData['visitor_company_image'] != '') {
                                $imageUrl = VISITOR_COMPANY_IMAGE_PATH. $imageData['visitor_company_image'];
                            }
                            if (file_exists($imageUrl)) {
                                unlink($imageUrl);
                            }

                            $thumbnailImageUrl = '';
                            if(isset($imageData['visitor_company_image']) && $imageData['visitor_company_image'] != '') {
                                $thumbnailImageUrl = THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH. $imageData['visitor_company_image'];
                            }
                            if (file_exists($thumbnailImageUrl)) {
                                unlink($thumbnailImageUrl);
                            }
                        }
                        unset($imageResult['success']);
                        $imageUpdateArray = array(
                            'visitor_company_id' => $lastVisitorCompanyId,
                            'visitor_company_image' => $imageResult['file_name'],
                        );
                        $this->visitor_company_model->insertUpdateRecord($imageUpdateArray, 'visitor_company_id','tbl_visitor_company');
                    }
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($visitorCompanyId) && $visitorCompanyId != '') {
                if (($visitorCompanyData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('VisitorCompany.visitor_company'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('VisitorCompany.visitor_company'));
                }
            } else {
                if (($visitorCompanyData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('VisitorCompany.visitor_company'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('VisitorCompany.visitor_company'));
                }
            }
            echo json_encode($response);
            exit();
        }
    }

    public function changeStatus()
    {
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $status = $this->request->getVar('status');
        $return = $this->visitor_company_model->statusChange($visitorCompanyId,$status,'visitor_company_id','tbl_visitor_company');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('VisitorCompany.visitor_company'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('VisitorCompany.visitor_company'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        if (isReferenceInTable('visitor_company_id', 'tbl_visitor', $visitorCompanyId)) {
            if (!empty($visitorCompanyId)) {
                foreach ($visitorCompanyId as $visitorCompany) {
                    $deleteDataArray['module'] = 'Visitor Company';
                    $deleteDataArray['activity'] = "Tried to delete Visitor Company ";
                    $deleteDataArray['module_id'] = $visitorCompany;
                    logActivity('Tried to delete Visitor Company [VisitorCompanyID: ' . $visitorCompany . ']', $this->data['userId'], 'Visitor Company', $visitorCompany, json_encode($deleteDataArray), '', 'Visitor Company', $visitorCompany);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $imageData = $this->visitor_company_model->getVisitorCompanyData(array("visitor_company_id" => $visitorCompanyId));
        $imageUrl = '';
        if(isset($imageData['visitor_company_image']) && $imageData['visitor_company_image'] != '') {
            $imageUrl = VISITOR_COMPANY_IMAGE_PATH. $imageData['visitor_company_image'];
        }
        if (file_exists($imageUrl)) {
            unlink($imageUrl);
        }
        $thumbnailImageUrl = '';
        if(isset($imageData['visitor_company_image']) && $imageData['visitor_company_image'] != '') {
            $thumbnailImageUrl = THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH. $imageData['visitor_company_image'];
        }
        if (file_exists($thumbnailImageUrl)) {
            unlink($thumbnailImageUrl);
        }
        $visitorCompanyData = $this->visitor_company_model->deleteRecord($visitorCompanyId);
        $transactionStatus = $this->db->transComplete();
        if (($visitorCompanyData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang('VisitorCompany.visitor_company'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang('VisitorCompany.visitor_company'));
        }
        echo json_encode($response);
        exit;
    }

    public function getVisitorCompanyDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'visitor_company_id' => $visitorCompanyId,
        );
        echo $this->visitor_company_model->getVisitorCompany($filterData);
    }

    public function excelExportVisitorCompany()
    {
        $fileName ='visitor-company-' . DATETIMEFORMAT;
        $sheetName = 'Visitor-Company-' . DATEFORMAT;
        $excelHeaderName = 'Visitor Company';
        $tableData = $this->getVisitorCompanyListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('VisitorCompany.visitor_company'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["visitor_company_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}