<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\CommonWebServiceModel;
class Vehicle extends BaseController
{
    protected $common_web_service_model;
    public function __construct() {
        $this->common_web_service_model = new CommonWebServiceModel();
    }

    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Vehicle';
        $dataFilters['filters'] = array(
            array(
                "type" => "flat_type",
                "id" => "flat_type",
                "name" => "flat_type",
                "title" => "OwnershipFlat.type",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "flatTypeDd",
                "id" => "filter_type_id",
                "name" => "filter_type_id",
                "title" => "OwnershipFlat.type_name",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "flatDd",
                "id" => "filter_flat_id",
                "name" => "filter_flat_id",
                "title" => "OwnershipFlat.flat_no",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "parkingSlotDd",
                "id" => "filter_parking_slot_id",
                "name" => "filter_parking_slot_id",
                "title" => "OwnershipFlat.parking_slot",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
            array(
                "type" => "electric_type",
                "id" => "is_electric",
                "name" => "is_electric",
                "class" => "is_electric",
                "title" => "OwnershipFlat.is_electric",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Vehicle/VehicleView",$data);
    }

    public function getVehicleListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $flatId = $this->request->getVar("filter_flat_id");
        $type = $this->request->getVar("flat_type");
        $typeId = $this->request->getVar("filter_type_id");
        $parkingSlotId = $this->request->getVar("filter_parking_slot_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $isElectric = $this->request->getVar("is_electric");
        // $ownerMemberId = $this->request->getVar("filter_flat_member_id");

        $this->datatables->table("tbl_ownership_flat_parking as tc");
        $this->datatables->select("tc.ownership_flat_parking_id,tc.type,tc.created_at,tc.updated_at,tc.vehicle_type,tc.parking_slot_id,tc.vehicle_no,tc.token_no, tc.is_electric");
        $this->datatables->select("concat(COALESCE(ta.parking_area_name,''),'-',(tps.number)) as parking_slot,COALESCE(tf.flat_no,'') as flat_no");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");

        $this->datatables->select("(CASE WHEN tc.type = 'ownership_flat' THEN COALESCE(tm.name, '') 
                                    WHEN tc.type = 'rentals' THEN  COALESCE(tr.name, '')
                                    END) as type_name");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tc.updated_by AND tupdate.society_id = tc.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tc.created_by AND tcreate.society_id = tc.society_id","left");
        $this->datatables->join("tbl_parking_slot as tps","tps.parking_slot_id = tc.parking_slot_id","left");
        $this->datatables->join("tbl_parking_area as ta","ta.parking_area_id = tps.parking_area_id","left");
        $this->datatables->join("tbl_parking_vehicle as tpv","tps.parking_vehicle_id = tpv.parking_vehicle_id","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm","tofm.type_id = tc.type_id AND tc.type=tofm.type AND tofm.is_delete = 0 AND tofm.ownership_flat_id = tc.ownership_flat_id","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $this->datatables->join("tbl_ownership_flat_member as tr","tr.type_id = tc.type_id AND tr.is_delete = 0 AND tc.type=tr.type AND tr.ownership_flat_id = tc.ownership_flat_id","left");
        $this->datatables->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tc.ownership_flat_id","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
        $this->datatables->where("tc.is_delete = 0");
        $this->datatables->groupBy("tc.ownership_flat_parking_id");
        accessFilter($this->datatables, array("society" => "tof.society_id"));

        if (isset($type) && !empty($type)) {
            $this->datatables->where("tc.type", $type);
        }

        if (isset($isElectric) && !empty($isElectric)) {
            if($isElectric == 'yes'){
                $this->datatables->where("tc.is_electric", 1);
            }
            else{
                $this->datatables->where("tc.is_electric", 0); 
            }
        }
        if($type == 'ownership_flat'){
            if(isset($typeId)) {
                if(is_array($typeId)){
                    $this->datatables->whereIn("tc.type = 'ownership_flat' AND tc.type_id",$typeId);
                } else {
                    $this->datatables->where("tc.type = 'ownership_flat' AND tc.type_id",$typeId);
                }
            } 
        }
        else if($type == 'rentals'){
            if(isset($typeId)) {
                if(is_array($typeId)){
                    $this->datatables->whereIn("tc.type = 'rentals' AND tc.type_id",$typeId);
                } else {
                    $this->datatables->where("tc.type = 'rentals' AND tc.type_id",$typeId);
                }
            }   
        }
        

        if(isset($flatId)) {
            if(is_array($flatId)){
                $this->datatables->whereIn("tof.flat_id",$flatId);
            } else {
                $this->datatables->where("tof.flat_id",$flatId);
            }
        }

        if(isset($parkingSlotId)) {
            if(is_array($parkingSlotId)){
                $this->datatables->whereIn("tps.parking_slot_id",$parkingSlotId);
            } else {
                $this->datatables->where("tps.parking_slot_id",$parkingSlotId);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tc.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tc.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tc.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }


        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";

                $data[$key]['type'] = underscoreToUcWord($displayData['type']);
            }
        }

        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
}
