<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\TaxModel;
class Tax extends BaseController
{
    protected $tax_model;
    public function __construct() {
        $this->tax_model = new TaxModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Tax';
        $data['tax_model_view'] = view('Admin/Tax/TaxModalView', $data);
        return $this->dt_ci_template->load("Admin","Tax/TaxView",$data);
    }

    public function getTaxListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_tax as tt");
        $this->datatables->select("tt.tax_id, tt.tax_name, tt.is_active,tt.tax_rate");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tt.created_at,tt.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tt.updated_by AND tupdate.society_id = tt.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tt.created_by AND tcreate.society_id = tt.society_id","left");
        $this->datatables->groupBy("tt.tax_id");
        accessFilter($this->datatables, array("society" => "tt.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "tax_id" => isset($displayData['tax_id']) ? $displayData['tax_id'] : ""
                );
                $data[$key]['action_button'] = taxActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $taxId = $this->request->getVar('tax_id');
        $taxName = $this->request->getVar('tax_name');
        $taxRate = $this->request->getVar('tax_rate');
        $isActive = $this->request->getVar('is_active');

        if (isset($taxId) && $taxId == '') {
            $validation->setRule('tax_name', lang('Tax.tax_name'), 'required|combination_unique[tbl_tax.tax_name]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
            $validation->setRule('tax_name', lang('Tax.tax_name'), 'required|edit_unique[tbl_tax.tax_name.'.$taxId. ']',array('edit_unique' => 'This {field} Already Exists'));
        }
        $validation->setRule('tax_rate', lang('Tax.tax_rate'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $taxUpdateArray = array();
            $taxArray = array(
                'tax_id' => $taxId,
                'tax_name' => $taxName,
                'tax_rate' => $taxRate,
                'is_active' => isset($isActive) ? 1 : 0,
                'society_id' => $this->session->get('society_id'),
            );
            if(!empty($taxId)){
                $taxUpdateData = $this->tax_model->getTaxData(array(
                    'tax_id' => $taxId,
                ));
                $taxUpdateArray = compareArray($taxArray,$taxUpdateData);
            }

            $taxData = $this->tax_model->insertUpdateRecord($taxArray,'tax_id','tbl_tax', 1,'',array(),array(),$taxUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($taxId) && $taxId != '') {
                if (($taxData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Tax.tax'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Tax.tax'));
                }
            } else {
                if (($taxData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Tax.tax'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Tax.tax'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $taxId = $this->request->getVar('tax_id');
        $status = $this->request->getVar('status');

        $return = $this->tax_model->statusChange($taxId,$status,'tax_id','tbl_tax');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Tax.tax'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Tax.tax'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $taxId = $this->request->getVar('tax_id');
        if (isReferenceInTable('tax_id', 'tbl_amenities', $taxId) ||
            isReferenceInTable('tax_id', 'tbl_booking', $taxId) ||
            isReferenceInTable('tax_id', 'tbl_charges', $taxId)
        ) {
            if (!empty($taxId)) {
                foreach ($taxId as $tax) {
                    $deleteDataArray['module'] = 'Tax';
                    $deleteDataArray['activity'] = "Tried to delete Tax ";
                    $deleteDataArray['module_id'] = $tax;
                    logActivity('Tried to delete Tax [TaxID: ' . $tax . ']', $this->data['userId'], 'Tax', $tax, json_encode($deleteDataArray), '', 'Tax', $tax);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $taxData = $this->tax_model->deleteRecord($taxId);
        $transactionStatus = $this->db->transComplete();
        if (($taxData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang('Tax.tax'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang('Tax.tax'));
        }
        echo json_encode($response);
        exit;
    }

    public function getTaxDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $taxId = $this->request->getVar('tax_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'tax_id' => $taxId,

        );
        echo $this->tax_model->getTax($filterData);
    }

    public function excelExportTax()
    {
        $fileName ='tax-' . DATETIMEFORMAT;
        $sheetName = 'Tax-' . DATEFORMAT;
        $excelHeaderName = 'Tax';
        $tableData = $this->getTaxListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Tax.tax_name'),
            lang('Tax.tax_rate'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["tax_name"],
                $row["tax_rate"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'D';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
