<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ResourceTypeModel;
use App\Models\CommonWebServiceModel;
use App\Models\ResourceModel;
helper('text');
class ResourceType extends BaseController
{
    protected $resource_type_model;
    protected $common_web_service_model;
    protected $resource_model;
    public function __construct() {
        $this->resource_type_model = new ResourceTypeModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->resource_model = new ResourceModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Resource Type';
        $data['v_resource_type_modal'] = view('Admin/ResourceType/ResourceTypeModalView', $data);
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", array());
        return $this->dt_ci_template->load("Admin","ResourceType/ResourceTypeView",$data);
    }

    public function getResourceTypeListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_resource_type as twt");
        $this->datatables->select("twt.resource_type_id, twt.resource_type_name,twt.is_active, twt.society_id,ts.society_name,twt.is_login,twt.group_id,tg.name,twt.is_guard,twt.is_show");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,twt.created_at,twt.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = twt.updated_by AND tupdate.society_id = twt.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = twt.created_by AND tcreate.society_id = twt.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = twt.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_groups as tg","tg.id = twt.group_id","left");
        $this->datatables->where("twt.is_show",0);
        $this->datatables->groupBy("twt.resource_type_id");
        accessFilter($this->datatables, array("society" => "twt.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "resource_type_id" => isset($displayData['resource_type_id']) ? $displayData['resource_type_id'] : "",
                );
                $data[$key]['action_button'] = resourceTypeActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $this->centralDB->transStart();
        $validation = \Config\Services::validation();
        $resourceTypeId = $this->request->getVar('resource_type_id');
        $resourceTypeName = $this->request->getVar('resource_type_name');
        $isActive = $this->request->getVar('is_active');
        $groupId = $this->request->getVar('group_id');
        $isLogin = $this->request->getVar('is_login');
        $isHelper = $this->request->getVar('is_helper');
        $isGuard = $this->request->getVar('is_guard');

        if (isset($resourceTypeId) && $resourceTypeId == '') {
            $validation->setRule('resource_type_name', lang('ResourceType.resource_type_name'), 'required|combination_unique[tbl_resource_type.resource_type_name.'.$this->session->get('society_id').'.]');
        } else {
            $validation->setRule('resource_type_name', lang('ResourceType.resource_type_name'), 'required|edit_unique[tbl_resource_type.resource_type_name.' . $resourceTypeId . '.'. $this->session->get('society_id').']');
        }
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $resourceTypeUpdateArray = array();
            $resourceTypeArray = array(
                'resource_type_id' => $resourceTypeId,
                'resource_type_name' => $resourceTypeName,
                'group_id' => $groupId,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
                'is_login' => isset($isLogin) ? 1 : 0,
                'is_helper' => isset($isHelper) ? 1 : 0,
                'is_guard' => isset($isGuard) ? 1 : 0,
            );
            if(!empty($resourceTypeId)){
                $resourceTypeUpdateData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_id' => $resourceTypeId,
                    'is_api' => 0,
                ));
                $resourceTypeUpdateArray = compareArray($resourceTypeArray,$resourceTypeUpdateData);
            }
            $resourceTypeData = $this->resource_type_model->insertUpdateRecord($resourceTypeArray,'resource_type_id','tbl_resource_type', 1,'',array(),array(),$resourceTypeUpdateArray);
            if (!empty($resourceTypeId)) {
                $resourceIsActive   = $resourceTypeUpdateData['is_active'];
                $resourceIsLogin    = $resourceTypeUpdateData['is_login'];
                $resourceGroupId    = $resourceTypeUpdateData['group_id'];
                $resourceIsGuard    = $resourceTypeUpdateData['is_guard'];
                $userResourceTypeId = $resourceTypeId;

                $isMismatch =
                    (isset($isLogin) && ((bool)$isLogin !== (bool)$resourceIsLogin)) ||
                    (isset($isActive) && ((bool)$isActive !== (bool)$resourceIsActive)) ||
                    (isset($isGuard) && ((bool)$isGuard !== (bool)$resourceIsGuard)) ||
                    ($resourceGroupId != $groupId);

                $isPartial = !isset($isLogin) || !isset($isActive) || !isset($isGuard);

                if ($isMismatch) {
                    $resourceData = $this->resource_model->getResourceData(array(
                        'resource_type_id' => $resourceTypeId,
                        'society_id' => $this->session->get("society_id"),
                        'is_multiple' => 1
                    ));


                    if (!empty($groupId)) {
                        $groupData = $this->common_web_service_model->getGroupsData(array(
                            'id' => $groupId,
                            'society_id' => $this->session->get('society_id'),
                        ));
                        $groupId = isset($groupData['id']) ? $groupData['id'] : '';
                        $permissions = isset($groupData['permissions']) ? $groupData['permissions'] : '';
                        $permissionArray = unserialize($permissions);
                        $permissionLabel = array();
                        $controllers_methods = $this->dt_ci_acl->getPermissableMethods();

                        foreach ($controllers_methods as $controller_name => $methods_arr) {
                            foreach ($methods_arr as $method) {
                                $methodDisplay = "";
                                $methodActual = "";
                                if (is_array($method)) {
                                    reset($method);
                                    $methodActual = key($method);
                                    $methodDisplay = $method[$methodActual];
                                } else {
                                    $methodDisplay = $method;
                                    $methodActual = $method;
                                }
                                $inputName = $controller_name . "|" . $methodActual;
                                $permissionLabel[] = $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay;
                            }
                        }
                    }

                    if (!empty($resourceData)) {
                        $userSocietyIds = [];
                        $mobileNumbers = [];
                        $resourceMobileNoData = [];
                        $userIds = [];
                        $usedMobileNumbers = [];

                        foreach ($resourceData as $resource) {
                            if (!empty($resource['user_society_id'])) {
                                $userSocietyIds[] = $resource['user_society_id'];
                            } else {
                                $mobileNumbers[] = $resource['resource_mobile_no'];
                                $resourceMobileNoData[] = $resource;
                            }
                        }

                        $userData = $this->common_web_service_model->getUserSocietyData(array(
                            'phone' => $mobileNumbers,
                            'is_multiple' => 1
                        ));

                        if (!empty($userData)) {
                            foreach ($userData as $user) {
                                if (!empty($user['phone'])) {
                                    $usedMobileNumbers[] = $user['phone'];
                                    $userIds[$user['phone']] = $user['user_id'];
                                }
                            }
                        }

                        if (!empty($resourceMobileNoData)) {
                            $userInsert = [];
                            $userSocietyInsert = [];
                            $userGroupInsert = [];
                            $labelArray = [];

                            foreach ($resourceMobileNoData as $resourceMobileElement) {
                                $mobile = $resourceMobileElement['resource_mobile_no'];
                                $slug = random_string();
                                $slugSociety = random_string();
                                $id = isset($userIds[$mobile]) ? $userIds[$mobile] : 0;
                                // printArray($id,1);
                                if ($id == 0) {
                                    $userInsert[] = array(
                                        'first_name' => $resourceMobileElement['resource_name'],
                                        'active' => 1,
                                        'slug' => $slug,
                                    );
                                }

                                $userSocietyInsert[] = array(
                                    'user_society_id' => '',
                                    'user_id' => $id,
                                    'society_id' => $this->session->get('society_id'),
                                    'phone' => $mobile,
                                    'resource_type_id' => $resourceTypeId,
                                    'type_id' => $resourceMobileElement['resource_id'],
                                    'is_active' => 1,
                                    'slug' => $slug,
                                    'society_slug' => $slugSociety,
                                );

                                $userGroupInsert[] = array(
                                    'id' => '',
                                    'group_id' => $groupId,
                                    'slug' => $slug,
                                    'society_slug' => $slugSociety,
                                );

                                if (is_array($permissionLabel) && count($permissionLabel) > 0) {
                                    foreach ($permissionLabel as $labelData) {
                                        list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                        if (in_array($permissionValue, $permissionArray)) {
                                            $labelArray[] = array(
                                                'controller_name' => $controller,
                                                'permission_name' => $permissionValue,
                                                'permission_label' => $label,
                                                'group_id' => $groupId,
                                                'slug' => $slug,
                                                'society_slug' => $slugSociety,
                                                'created_at' => date('Y-m-d H:i:s'),
                                                'created_by' => $this->session->get('user_id'),
                                                'updated_at' => date('Y-m-d H:i:s'),
                                                'updated_by' => $this->session->get('user_id'),
                                            );
                                        }
                                    }
                                }
                            }

                            $this->resource_model->batchInsert($userInsert, MASTER_DB.".tbl_users");
                            $this->resource_model->batchInsert($labelArray, MASTER_DB.".tbl_user_permission");
                            $this->resource_model->batchInsert($userSocietyInsert, MASTER_DB.".tbl_user_society");
                            $this->resource_model->batchInsert($userGroupInsert, MASTER_DB.".tbl_users_groups");

                            $this->resource_type_model->updateUserGroupId();
                            $this->resource_type_model->updateUserSocietyId();
                            $this->resource_type_model->updateUserPermissionId();
                            $this->resource_type_model->updateUserPermissionSocietyId();
                            $this->resource_type_model->updateUserSocietyGroupId();
                        }

                        if(!empty($userSocietyIds)){

                            $unusedMobileNumbers = array_diff($mobileNumbers, $usedMobileNumbers);

                            $userSocietyDataArray = $this->common_web_service_model->getUserSocietyData(array(
                                'user_society_id' => $userSocietyIds,
                                'society_id' => $this->session->get('society_id'),
                                'is_multiple' => 1
                            ));

                            if (!empty($userSocietyDataArray)) {
                                $this->common_web_service_model->deleteUserSocietyPermissionRecord($userSocietyIds);
                                $labelArray = [];
                                $userGroupArray = [];
                                $userSocietyArray = [];

                                foreach ($userSocietyDataArray as $userSocietyElement) {
                                    $userSocietyArray[] = array(
                                        'user_society_id' => $userSocietyElement['user_society_id'],
                                        'is_active' => isset($isActive) ? 1 : 0,
                                    );

                                    $userGroupArray[] = array(
                                        'id' => $userSocietyElement['user_group_id'],
                                        'group_id' => $groupId,
                                    );

                                    if (is_array($permissionLabel) && count($permissionLabel) > 0) {
                                        foreach ($permissionLabel as $labelData) {
                                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                            if (in_array($permissionValue, $permissionArray)) {
                                                $labelArray[] = array(
                                                    'controller_name' => $controller,
                                                    'permission_name' => $permissionValue,
                                                    'permission_label' => $label,
                                                    'user_id' => $userSocietyElement['user_id'],
                                                    'group_id' => $groupId,
                                                    'user_society_id' => $userSocietyElement['user_society_id'],
                                                    'created_at' => date('Y-m-d H:i:s'),
                                                    'created_by' => $this->session->get('user_id'),
                                                    'updated_at' => date('Y-m-d H:i:s'),
                                                    'updated_by' => $this->session->get('user_id'),
                                                );
                                            }
                                        }
                                    }
                                }

                                $this->resource_model->batchInsert($labelArray, MASTER_DB.".tbl_user_permission");
                                $this->resource_model->batchUpdate($userSocietyArray,'user_society_id', MASTER_DB.".tbl_user_society");
                                $this->resource_model->batchUpdate($userGroupArray,'id', MASTER_DB.".tbl_users_groups");
                            }
                        }
                    }
                } 
                else if ($isPartial) {
                    $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                        'resource_type_id' => $resourceTypeId,
                        'society_id' => $this->session->get("society_id"),
                        'is_multiple' => 1
                    ));

                    $userSocietyIds = array_column($userSocietyData, 'user_society_id');
                    if (!empty($userSocietyIds)) {
                        $this->common_web_service_model->userSocietyStatusChange($userSocietyIds, $this->data['userId']);
                    }
                }
            }
            $transactionStatus = $this->db->transComplete();
            $transactionCentralStatus = $this->centralDB->transComplete();



            if (isset($resourceTypeId) && $resourceTypeId != '') {
                if (($resourceTypeData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('ResourceType.resource_type'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('ResourceType.resource_type'));
                }
            } else {
                if (($resourceTypeData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('ResourceType.resource_type'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('ResourceType.resource_type'));
                }
            }
            echo json_encode($response);
            exit();
        }
    }

    public function changeStatus()
    {
        $resourceTypeId = $this->request->getVar('resource_type_id');
        $status = $this->request->getVar('status');
        $return = $this->resource_type_model->statusChange($resourceTypeId,$status,'resource_type_id','tbl_resource_type');
        if ($return == 1) {
            $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                'resource_type_id' => $resourceTypeId,
                'society_id' => $this->session->get("society_id"),
                'is_multiple' => 1
            ));

            $userSocietyIds = array_column($userSocietyData, 'user_society_id');
            if (!empty($userSocietyIds)) {
                $this->common_web_service_model->userSocietyStatusChange($userSocietyIds, $this->data['userId'],$status);
            }
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('ResourceType.resource_type'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('ResourceType.resource_type'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $resourceTypeId = $this->request->getVar('resource_type_id');
         if( isReferenceInTable( 'resource_type_id','tbl_resource', $resourceTypeId)){
             if(!empty($resourceTypeId)){
                 foreach($resourceTypeId as $resourceType){
                     $deleteDataArray['module'] = 'Resource Type';
                     $deleteDataArray['activity'] = "Tried to delete Resource Type ";
                     $deleteDataArray['module_id'] = $resourceType;
                     logActivity('Tried to delete Resource Type [ResourceTypeID: ' . $resourceType . ']',$this->data['userId'],'Resource Type',$resourceType,json_encode($deleteDataArray),'','Resource Type',$resourceType);
                 }
             }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
        $resourceTypeData = $this->resource_type_model->deleteRecord($resourceTypeId);
        $transactionStatus = $this->db->transComplete();
        if (($resourceTypeData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('ResourceType.resource_type'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('ResourceType.resource_type'));
        }
        echo json_encode($response);
        exit;
    }

    public function getResourceTypeDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $resourceTypeId = $this->request->getVar('resource_type_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'resource_type_id' => $resourceTypeId,

        );
        echo $this->resource_type_model->getResourceType($filterData);
    }

    public function excelExportResourceType()
    {
        $fileName ='resource-type-' . DATETIMEFORMAT;
        $sheetName = 'ResourceType-' . DATEFORMAT;
        $excelHeaderName = 'Resource Type';
        $tableData = $this->getResourceTypeListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Society.society'),
            lang('ResourceType.resource_type_name'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["resource_type_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
