<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\RentalsModel;
use App\Models\SocietyModel;
use App\Models\StatusModel;
use App\Models\DocumentModel;
use App\Models\StaffModel;
use App\Models\OwnershipFlatModel;
use App\Models\ResourceModel;
use App\Models\ResourceTypeModel;
use App\Models\CommonWebServiceModel;
use App\Models\IonAuthModel;
helper('text');
class Rentals extends BaseController
{
    protected $rentals_model;
    public function __construct() {
        $this->rentals_model = new RentalsModel();
        $this->society_model = new SocietyModel();
        $this->status_model = new StatusModel();
        $this->document_model = new DocumentModel();
        $this->staff_model = new StaffModel();
        $this->resource_model = new ResourceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->resource_model = new ResourceModel();
        $this->resource_type_model = new ResourceTypeModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ionAuthModel = new IonAuthModel();
        // checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);
        // checkAndCreatePath(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
        // checkAndCreatePath(THUMBNAIL_VEHICLE_IMAGE_PATH);
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Rentals';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "flatDd",
                "id" => "filter_flat_id",
                "name" => "filter_flat_id",
                "title" => "Rentals.flat_no",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "ownershipFlatMemberDd",
                "id" => "filter_owner_member_id",
                "name" => "filter_owner_member_id",
                "title" => "Rentals.owner_member",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "brokerDd",
                "id" => "filter_broker_id",
                "name" => "filter_broker_id",
                "title" => "Rentals.broker",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "statusDd",
                "id" => "filter_status_id",
                "name" => "filter_status_id",
                "title" => "Rentals.status_name",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_agreement_period_from",
                "name" => "filter_agreement_period_from",
                "title" => "Rentals.agreement_period",
            ),
            // array(
            //  "type" => "daterange",
            //  "id" => "filter_agreement_period_upto",
            //  "name" => "filter_agreement_period_upto",
            //  "title" => "agreement_period_to",
            // ),

            array(
                "type" => "daterange",
                "id" => "filter_closing_date",
                "name" => "filter_closing_date",
                "title" => "Rentals.closing_date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['rental_change_status_modal'] = view('Admin/Rentals/RentalChangeStatusModalView', array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Rentals/RentalsView",$data);
    }

    public function getRentalsListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $flatId = $this->request->getVar("filter_flat_id");
        $statusId = $this->request->getVar("filter_status_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $brokerId = $this->request->getVar("filter_broker_id");
        $ownerMemberId = $this->request->getVar("filter_owner_member_id");
        $rentAgreementPeriod = $this->request->getVar("filter_agreement_period_from");
        $rentAgreementPeriodTo = $this->request->getVar("filter_agreement_period_upto");
        $closingDate = $this->request->getVar("filter_closing_date");

        $this->datatables->table("tbl_rentals as tr");
        $this->datatables->select("concat(tr.prefix,tr.series) as document_number");
        $this->datatables->select("tr.rentals_id, tr.is_active,tr.society_id,ts.society_name");
        $this->datatables->select("tf.flat_no as flat_nos,concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no,GROUP_CONCAT(distinct(COALESCE(trfm.owner_name,'')) SEPARATOR ', ') as owner_member_name,COALESCE(tb.broker_name,'') as broker_name,tr.tenant_name,tr.flat_id,tr.broker_contact_no, tr.tenant_contact_no,tr.tenant_email,tr.permanent_address,tr.work_address");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tr.updated_at");
        $this->datatables->select("tt.tower_name,tr.rent_agreement_period_from,tr.rent_agreement_period_to");
        $this->datatables->select("COALESCE(tstatus.status_name,'') as status_name,tstatus.is_open,tstatus.is_close,tr.rental_closing_date");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tr.society_id","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tr.flat_id","left");
        $this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $this->datatables->join("tbl_rentals_flat_owner as trfm","trfm.rentals_id = tr.rentals_id","left");
        $this->datatables->join(MASTER_DB.".tbl_broker as tb","tb.broker_id = tr.broker_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tr.updated_by AND tupdate.society_id = tr.society_id","left");
        $this->datatables->join("tbl_status as tstatus","tstatus.status_id = tr.status_id","left");
        $this->datatables->where("tr.is_delete = 0");

        if(isset($flatId)) {
            if(is_array($flatId)){
                $this->datatables->whereIn("tr.flat_id",$flatId);
            } else {
                $this->datatables->where("tr.flat_id",$flatId);
            }
        }

        if(isset($statusId)) {
            if(is_array($statusId)){
                $this->datatables->whereIn("tr.status_id",$statusId);
            } else {
                $this->datatables->where("tr.status_id",$statusId);
            }
        }

        if(isset($brokerId)) {
            if(is_array($brokerId)){
                $this->datatables->whereIn("tr.broker_id",$brokerId);
            } else {
                $this->datatables->where("tr.broker_id",$brokerId);
            }
        }

        if(isset($statusId)) {
            if(is_array($statusId)){
                $this->datatables->whereIn("tr.status_id",$statusId);
            } else {
                $this->datatables->where("tr.status_id",$statusId);
            }
        }

        if(isset($ownerMemberId)) {
            if(is_array($ownerMemberId)){
                $this->datatables->whereIn("tr.owner_member_id",$ownerMemberId);
            } else {
                $this->datatables->where("tr.owner_member_id",$ownerMemberId);
            }
        }
        if($rentAgreementPeriod != ''){
            list($fromDate,$toDate) = explode(" - ",$rentAgreementPeriod);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tr.rent_agreement_period_from,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tr.rent_agreement_period_to,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tr.rent_agreement_period_from,'".DATE_FORMATE_MYSQL_YMD."') = ",$fromDate);
                $this->datatables->where("date_format(tr.rent_agreement_period_to,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        // if($rentAgreementPeriodTo != ''){
        //  list($fromDate,$toDate) = explode(" - ",$rentAgreementPeriodTo);
        //  $fromDate = DMYToYMD($fromDate);
        //  $toDate = DMYToYMD($toDate);
        //  if(strtotime($fromDate) != strtotime($toDate)){
        //      $this->datatables->where("date_format(tr.rent_agreement_period_to,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
        //      $this->datatables->where("date_format(tr.rent_agreement_period_to,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
        //  } else {
        //      $this->datatables->where("date_format(tr.rent_agreement_period_to,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
        //  }
        // }
        if($closingDate != ''){
            list($fromDate,$toDate) = explode(" - ",$closingDate);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tr.rental_closing_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tr.rental_closing_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tr.rental_closing_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tr.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tr.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tr.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        accessFilter($this->datatables, array("society" => "tr.society_id"));
        $this->datatables->groupBy("tr.rentals_id");
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "rentals_id" => isset($displayData['rentals_id']) ? $displayData['rentals_id'] : "",
                    "rent_agreement_period_from" => isset($displayData['rent_agreement_period_from']) ? $displayData['rent_agreement_period_from'] : "",
                    "rent_agreement_period_to" => isset($displayData['rent_agreement_period_to']) ? $displayData['rent_agreement_period_to'] : "",
                    "is_close" => isset($displayData['is_close']) ? $displayData['is_close'] : "",
                );
                $data[$key]['is_change_status'] = 1;
                if(strtotime($displayData['rent_agreement_period_to']) < strtotime(TODAY_DATE_YMD)){
                    $data[$key]['is_change_status'] = 0;
                }
                $data[$key]['action_button'] = rentalsActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['rent_agreement_period_from'] = siteDateFormat($displayData['rent_agreement_period_from']);
                $data[$key]['rent_agreement_period_to'] = siteDateFormat($displayData['rent_agreement_period_to']);
                $data[$key]['rental_closing_date'] = isValidDate($displayData['rental_closing_date']) ? siteDateFormat($displayData['rental_closing_date']) : '';
                $data[$key]['excel_flat_no'] = isset($displayData['flat_no']) ?  $displayData['flat_no'] : "";
                $data[$key]['flat_no'] = isset($displayData['flat_no']) ?  flatDocumentToHtml($displayData['flat_no'],$displayData['flat_id']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($rentalsId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        if ($rentalsId != '') {
            $filterData = array(
                "rentals_id" => $rentalsId
            );
            $data['rentals_data'] = $this->rentals_model->getRentalsData($filterData);
            if (empty($data['rentals_data'])) {
                return redirect()->to('Admin/Rentals');
            }

            $rentalsFlatOwnerData = $this->rentals_model->getRentalsFlatOwnerData(array(
                'rentals_id' => $rentalsId,
                'is_multiple' => 1
            ));
            $data['rentals_flat_owner_data'] = $rentalsFlatOwnerData;

            $rentalsMemberData = $this->rentals_model->getRentalsMemberData(array(
                'type' => 'rentals',
                'type_id' => $rentalsId,
                'is_multiple' => 1
            ));
            $data['rentals_member_data'] = $rentalsMemberData;

            $rentalsEmergencyContactData = $this->rentals_model->getRentalsEmergencyData(array(
                'type' => 'rentals',
                'type_id' => $rentalsId,
                'is_multiple' => 1
            ));
            $data['rentals_emergency_contact_data'] = $rentalsEmergencyContactData;

            $rentalsParkingData = $this->rentals_model->getRentalsParkingData(array(
                'type' => 'rentals',
                'type_id' => $rentalsId,
                'is_multiple' => 1
            ));
            $data['rentals_parking_data'] = $rentalsParkingData;

            $documentData = $this->document_model->getDocumentData(array(
                'document_for' => 'rentals',
                'is_active' => 1,
                'is_multiple' => 1,
            ));
            if(!empty($documentData)){
                foreach ($documentData as $key => $displayData) {
                    $document = $this->staff_model->getDocument(array(
                        'document_id' => $displayData['document_id'],
                    ));
                    if(!empty($document)){
                        $documentData[$key]['module_document_id'] = $document['module_document_id'];
                        $documentData[$key]['input_box'] = $document['input_box'];
                        $documentData[$key]['document_expiry_date'] = $document['document_expiry_date'];
                    }
                    $documentImageData = $this->staff_model->getDocumentImage(array(
                        "document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
                        'module_id' => $rentalsId,
                        'module' => 'rentals',
                        "is_multiple" => 1,
                    ));
                    $documentData[$key]['module_image_data'] = $documentImageData;
                }
            }
            $data['document_data'] = $documentData;
        }
        else{
            $documentType = $this->document_model->getDocumentData(array(
                'document_for' => 'rentals',
                'is_active' => 1,
                'is_multiple' => 1,

            ));
            $iKey = 0;
            if(!empty($documentType)){
                foreach($documentType as $imageType){
                    $documentTypeData[$iKey] = $imageType;
                    $iKey = $iKey + 1;
                }
            }
            if(!empty($documentTypeData)){
                $data['document_data'] = $documentTypeData;
            }
        }
        if ($rentalsId != '') {
            $data['title'] = 'Edit Rentals';
        } else {
            $data['title'] = 'Add Rentals';
        }

        $data['rentals_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

        $select2Condition = array(
            'isRentalFlat' => true,
        );
        $data['document_table'] = view('Admin/Staff/DocumentView', isset($data) ? $data : array());
        $data['rentals_flat_owner_table'] = view('Admin/Rentals/RentalsFlatOwnerView', isset($data) ? $data : array());
        $data['rentals_member_table'] = view('Admin/Rentals/RentalsMemberView', isset($data) ? $data : array());
        $data['rentals_emergency_contact_table'] = view('Admin/Rentals/RentalsEmergencyContactView', isset($data) ? $data : array());
        $data['rentals_parking_table'] = view('Admin/Rentals/RentalsParkingView', isset($data) ? $data : array());
        $data['rentals_access_card_table'] = view('Admin/Rentals/RentalsAccessCardView', isset($data) ? $data : array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
        if ((isset($data['rentals_data']['society_id']) && $data['rentals_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Rentals');
        }

        if ((isset($data['rentals_data']['is_close'])) && ($data['rentals_data']['is_close'] == 1 || strtotime($data['rentals_data']['rent_agreement_period_to']) < strtotime(TODAY_DATE_YMD) )  && $data['rentals_data']['view'] != 1 ) {
            return redirect()->to('Admin/Rentals');
        }
        $this->dt_ci_template->load("Admin","Rentals/RentalsManageView",$data);
    }
    public function save()
    {
        // printArray($_POST,1);
        $validation = \Config\Services::validation();
        $this->db->transStart();
        $this->centralDB->transStart();
        $rentalsId = $this->request->getVar('rentals_id');
        $prefix = $this->request->getVar('prefix');
        $series = $this->request->getVar('series');
        $flatId = $this->request->getVar('flat_id');
       // $ownerMemberId = $this->request->getVar('owner_member_id');
       // $ownerContactNo = $this->request->getVar('owner_contact_no');
        $brokerId = $this->request->getVar('broker_id');
        $brokerContactNo = $this->request->getVar('broker_contact_no');
        $tenantName = $this->request->getVar('tenant_name');
        $tenantContactNo = $this->request->getVar('tenant_contact_no');
        $tenantEmail = $this->request->getVar('tenant_email');
        $permanentAddress = $this->request->getVar('permanent_address');
        $workAddress = $this->request->getVar('work_address');
        //$resident = $this->request->getVar('resident');
        //$isActive = $this->request->getVar('is_active');
        $rentAgreementPeriodTo = $this->request->getVar('rent_agreement_period_to');
        $rentAgreementPeriodFrom = $this->request->getVar('rent_agreement_period_from');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');


       $validation->setRule('flat_id', lang('Rentals.flat'), 'required');
      // $validation->setRule('owner_member_id', lang('Rentals.owner_member'), 'required');
       //$validation->setRule('owner_contact_no', lang('Rentals.owner_contact_no'), 'required');
       $validation->setRule('broker_id', lang('Rentals.broker'), 'required');
       $validation->setRule('broker_contact_no', lang('Rentals.broker_contact_no'), 'required');
       $validation->setRule('tenant_name', lang('Rentals.tenant_name'), 'required');
       $validation->setRule('tenant_contact_no', lang('Rentals.tenant_contact_no'), 'required');
       $validation->setRule('permanent_address', lang('Rentals.permanent_address'), 'required');
       $validation->setRule('work_address', lang('Rentals.work_address'), 'required');
       $validation->setRule('rent_agreement_period_to', lang('Rentals.rent_agreement_period_to'), 'required');
       $validation->setRule('rent_agreement_period_from', lang('Rentals.rent_agreement_period_from'), 'required');
       $validation->setRule('ownership_flat_id', lang('Rentals.ownership_flat_id'), 'required');

       $validation->setRule('name.*', lang('Rentals.name'), 'required');
       //$validation->setRule('mobile_no.*', lang('Rentals.mobile_no'), 'required');
       // $validation->setRule('gender.*', lang('Rentals.gender'), 'required');
       $validation->setRule('relation.*', lang('Rentals.relation'), 'required');
       // $validation->setRule('birth_date.*', lang('Rentals.birth_date'), 'required');

       $validation->setRule('ec_name.*', lang('Rentals.e_name'), 'required');
       $validation->setRule('ec_place.*', lang('Rentals.e_place'), 'required');
       $validation->setRule('ec_relation.*', lang('Rentals.e_relation'), 'required');
       $validation->setRule('ec_mobile_no.*', lang('Rentals.e_mobile'), 'required');

       $validation->setRule('owner_name.*', lang('Rentals.owner_member'), 'required');
       $validation->setRule('owner_mobile_no.*', lang('Rentals.owner_contact_no'), 'required');

        $moduleDocumentResult = array();
        if (isset($_FILES["document_image"])) {
            $moduleDocumentResult  = $this->dt_ci_file_upload->MultipleFileUpload('document_image', MAX_IMAGE_SIZE_LIMIT, DOCUMENT_IMAGE_PATH, true, true, array('jpeg', 'png', 'jpg', 'JPG'));

            // printArray($moduleDocumentResult,1);
            if ($moduleDocumentResult['success'] == false) {
                $response['success'] = false;
                $response['msg'] = strip_tags($moduleDocumentResult['message']);
                echo json_encode($response);
                die();
            }
            else{
                unset($moduleDocumentResult['success']);
                $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($moduleDocumentResult, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
            }
        }

        $imageFormat = array('jpg','jpeg','png','JPG');
        $imageExtension = imageExtension($imageFormat);
        $rentalsResult = array();
        if (isset($_FILES["member_image"])) {
            $rentalsPath = FLAT_MEMBER_IMAGE_PATH;
            $rentalsResult = $this->dt_ci_file_upload->UploadMultipleFile('member_image', MAX_IMAGE_SIZE_LIMIT, $rentalsPath, true, true, $imageExtension, true);
            if ($rentalsResult['success'] == false) {
                $response['success'] = false;
                $response['msg'] = strip_tags($rentalsResult['message']);
                echo json_encode($response);
                die();
            }
            else{
                    unset($rentalsResult['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($rentalsResult, FLAT_MEMBER_IMAGE_PATH, THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
                }
        }

        $rentalsParkingResult = array();
        if (isset($_FILES["vehicle_image"])) {
            $rentalsParkingPath = VEHICLE_IMAGE_PATH;
            $rentalsParkingResult = $this->dt_ci_file_upload->UploadMultipleFile('vehicle_image', MAX_IMAGE_SIZE_LIMIT, $rentalsParkingPath, true, true, $imageExtension, true);
            if ($rentalsParkingResult['success'] == false) {
                $response['success'] = false;
                $response['msg'] = strip_tags($rentalsParkingResult['message']);
                echo json_encode($response);
                die();
            }
            else{
                    unset($rentalsParkingResult['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($rentalsParkingResult, VEHICLE_IMAGE_PATH, THUMBNAIL_VEHICLE_IMAGE_PATH);
                }
        }

        // $moduleDocumentResult = array();
        // if (isset($_FILES["document_image"])) {
        //     $moduleDocumentResult  = $this->dt_ci_file_upload->MultipleFileUpload('document_image', MAX_IMAGE_SIZE_LIMIT, DOCUMENT_IMAGE_PATH, true, true, array('jpeg', 'png', 'jpg', 'JPG'));

        //     // printArray($moduleDocumentResult,1);
        //     if ($moduleDocumentResult['success'] == false) {
        //         $response['success'] = false;
        //         $response['msg'] = strip_tags($moduleDocumentResult['message']);
        //         echo json_encode($response);
        //         die();
        //     }
        //     else{
        //         unset($moduleDocumentResult['success']);
        //         $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($moduleDocumentResult, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
        //     }
        // }
        // die();


        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            //get member data
            $rentalsMemberIdArray = $this->request->getVar('ownership_flat_member_id');
            $memberIdArray = $this->request->getVar('member_id');
            $nameArray = $this->request->getVar('name');
            $emailIdArray = $this->request->getVar('email_id');
            $mobileNoArray = $this->request->getVar('mobile_no');
            $genderArray = $this->request->getVar('gender');
            $birthDateArray = $this->request->getVar('birth_date');
            $bloodGroupArray = $this->request->getVar('blood_group');
            $relationArray = $this->request->getVar('relation',);
            // $foodLikeArray = $this->request->getVar('food_like');
            $agreementWithArray = $this->request->getVar('agreement_with');

            if (strtotime($rentAgreementPeriodFrom) > strtotime($rentAgreementPeriodTo)){
                $response['success'] = false;
                $response['msg'] = lang('Rentals.rent_agreement_period_to_date_from_date_message');
                echo json_encode($response);
                exit;
            }
            if (strtotime($rentAgreementPeriodTo) < strtotime(date('Y-m-d'))) {
                $response['success'] = false;
                $response['msg'] = lang('Rentals.date_today_or_future_validation');
                echo json_encode($response);
                exit;
            }
            if(isset($rentalsId) && $rentalsId != "") {
                $oldRentalsMemberData = $this->rentals_model->getRentalsMemberData(array(
                    'type' => 'rentals',
                    'type_id' => $rentalsId,
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'society_id' => $this->session->get('society_id'),
                ));
            }
            $filterMobileNoArray = $this->request->getVar('mobile_no');
            if(isset($oldRentalsMemberData) && !empty($oldRentalsMemberData)){
                foreach($oldRentalsMemberData as $oldMemberData){
                    if(isset($oldMemberData['mobile_no'])) {
                        $filterMobileNoArray[] = $oldMemberData['mobile_no'];
                    }
                }
            }
            $filterMobileNoArray = array_filter($filterMobileNoArray, function($value, $key) {
                return !empty($value);
            }, ARRAY_FILTER_USE_BOTH);
            $mobileNoErrorArray = array();
            // Resource Validation
            $resourceData = $this->resource_model->getResourceData(array(
                'resource_mobile_no' => $filterMobileNoArray,
                'is_multiple' => 1,
                'society_id' => $this->session->get('society_id'),
            ));
            if(!empty($resourceData)){
                foreach($resourceData as $resource){
                    if(in_array($resource['resource_mobile_no'], $filterMobileNoArray)){ 
                        $mobileNoErrorArray[] = $resource['resource_mobile_no']." Already Exists in this Society as Resource.";
                    }
                }
            }
            if(!empty($mobileNoErrorArray)){
                $response['success'] = false;
                $response['msg'] = implode("\n", $mobileNoErrorArray);
                echo json_encode($response);
                exit;
            }
            // Manager Validation
            $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER);
            $managerData = $this->common_web_service_model->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                'resource_type_id' => $resourceTypeManagerId,
                'society_id' => $this->session->get('society_id'),
                'is_multiple' => 1
            ));
            if(!empty($managerData)){
                foreach($managerData as $member){
                    if(in_array($member['phone'], $filterMobileNoArray)){ 
                        $mobileNoErrorArray[] = $member['phone']." Already Exists in this Society as Manager.";
                    }
                }
            }
            if(!empty($mobileNoErrorArray)) {
                $response['success'] = false;
                $response['msg'] = implode("\n", $mobileNoErrorArray);
                echo json_encode($response);
                exit;
            }

            // Exists Member-Data
            $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);
            $existsUserData = $this->common_web_service_model->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                'is_multiple' => 1
            ));

            $existsUserMemberData = $this->common_web_service_model->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                'is_multiple' => 1,
                'is_member' => 1,
            ));
            $resourceTypeMemberData = $this->resource_type_model->getResourceTypeData(array(
                "resource_type_name" => RESOURCE_TYPE_MEMBER,
                "society_id" => $this->session->get('society_id'),
            ));

            $ownerFlatMobileNumberArray = array();
            $rentalsMobileNumberArray = array();
            $getOwnerFlatMemberData = $this->ownership_flat_model->getFlatMemberData(array('ownership_flat_id' => $ownershipFlatId,'ownership_flat_member_id_not' => $rentalsMemberIdArray,'is_multiple'=> 1,'is_active' => 1));
            // printArray($getOwnerFlatMemberData,1);

            if(!empty($getOwnerFlatMemberData)){
                foreach($getOwnerFlatMemberData as $getOwnerFlatMemberElement){
                    if($getOwnerFlatMemberElement['mobile_no'] != ''){
                        array_push($ownerFlatMobileNumberArray,$getOwnerFlatMemberElement['mobile_no']);
                    }
                }
            }

            if(!empty($rentalsMemberIdArray)) {
                foreach ($rentalsMemberIdArray as $mkey => $rentalsMemberId) {
                    $mobileNo = array_key_exists($mkey, $mobileNoArray) ? $mobileNoArray[$mkey] : '';
                    if($mobileNo != ''){
                        array_push($rentalsMobileNumberArray,$mobileNo);
                    }
                }
            }
            if(!empty($ownerFlatMobileNumberArray) && !empty($rentalsMobileNumberArray)){
                $mobileNoDuplicateArray = array_intersect($ownerFlatMobileNumberArray,$rentalsMobileNumberArray);
            }
            // printArray($getOwnerFlatMemberData,1);
            if(!empty($mobileNoDuplicateArray)){
                $response['success'] = false;
                $response['msg'] = "You Cann't Add This ".implode(",", $mobileNoDuplicateArray)." Mobile No This Flat";
                echo json_encode($response);
                exit;
            }

            // $rentalsDataData = $this->rentals_model->getFlatRentalDate(array(
            //     'flat_id'=>$flatId,'rent_agreement_period_from'=> $rentAgreementPeriodFrom,'rent_agreement_period_to' => $rentAgreementPeriodTo,'rentals_id' => $rentalsId,'is_multiple'=> 1));

            // if(!empty($rentalsDataData)){
            //     $dateOverlappedRental = array();
            //     foreach ($rentalsDataData as $rentalsDataElement) {
            //         $dateOverlappedRental[] = $rentalsDataElement['document_number'];
            //     }

            //     $rentalsNo = implode(",", $dateOverlappedRental);
            //     $response['success'] = false;
            //     $response['msg'] = 'Selected Flat '. $rentalsDataData[0]['flat_no'].' Rent Agreement Period Used To Other Rental No '.$rentalsNo;
            //     echo json_encode($response);
            //     exit;
            // }




            $oldRentalsMemberData = array();
            $oldRentalsEmergencyContactData = array();
            $oldRentalsParkingData = array();


            if(!empty($rentalsId)) {
                $oldRentalsMemberData = $this->rentals_model->getRentalsMemberData(array(
                    'type' => 'rentals',
                    'type_id' => $rentalsId,
                    'is_multiple' => 1
                ));

                $oldRentalsEmergencyContactData = $this->rentals_model->getRentalsEmergencyData(array(
                    'type' => 'rentals',
                    'type_id' => $rentalsId,
                    'is_multiple' => 1
                ));

                $oldRentalsParkingData = $this->rentals_model->getRentalsParkingData(array(
                    'type' => 'rentals',
                    'type_id' => $rentalsId,
                    'is_multiple' => 1
                ));
            }

           $imageResultArray = array();
            if(!empty($moduleDocumentResult)){
                foreach ($moduleDocumentResult as $keyImage => $imageResultData){
                    list($fromKey) = explode("_",$keyImage);
                    $imageResultArray[$fromKey][] = $imageResultData;
                }
            }



            //get emergency contact data
            $rentalsEmergencyContactIdArray = $this->request->getVar('ownership_flat_emergency_contact_id');
            $ecNameArray = $this->request->getVar('ec_name');
            $ecPlaceArray = $this->request->getVar('ec_place');
            $ecRelationArray = $this->request->getVar('ec_relation');
            $ecMobileNoArray = $this->request->getVar('ec_mobile_no');

            //get parking data
            $rentalsParkingIdArray  = $this->request->getVar('ownership_flat_parking_id');
            $vehicleTypeArray = $this->request->getVar('vehicle_type');
            $parkingSlotIdArray = $this->request->getVar('parking_slot_id');
            $vehicleNoArray = $this->request->getVar('vehicle_no');
            // $parkingSlotNoArray = $this->request->getVar('parking_slot_no');
            $tokenNoArray = $this->request->getVar('token_no');
            $isElectricArray = $this->request->getVar('is_electric');

            //get flat owner data
            $rentalsFlatOwnerIdArray  = $this->request->getVar('rentals_flat_owner_id');
            $ownerIdArray  = $this->request->getVar('owner_id');
            $ownerNameArray  = $this->request->getVar('owner_name');
            $ownerMobileNoArray  = $this->request->getVar('owner_mobile_no');
            $commonMemberImageArray  = $this->request->getVar('common_member_image');


            //get access card data
            // $moduleAccessCardTokenIdArray = $this->request->getVar('module_access_card_token_id');
            // $remarksArray = $this->request->getVar('remarks');
            // $liftsAccessArray = $this->request->getVar('lifts_access');
            // $amenitiesIdArray = $this->request->getVar('amenities_id');
            // $accessCardVehicleTypeArray = $this->request->getVar('access_card_vehicle_type');

            if (!isset($agreementWithArray)) {
                $commonValidationArray[] =  'Atleast One Rentals Member Should Be Selected As Aggrement With';
            }


            if (!empty($commonValidationArray)) {
                $response['success'] = false;
                $response['msg'] = implode("\n", $commonValidationArray);
                echo json_encode($response);
                exit();
            }

            $parkingSlotDuplicateArray = array();
            $parkingSlotUniqueArray = array();
            $memberKey = 0;
            if(!empty($parkingSlotIdArray)) {
                foreach ($parkingSlotIdArray as $mkey => $parkingSlotId) {
                    $memberKey = $memberKey + 1;
                    $parkingSlot = array_key_exists($mkey, $parkingSlotIdArray) ? $parkingSlotIdArray[$mkey] : '';

                    if($parkingSlot != ''){
                        if (!in_array($parkingSlot, $parkingSlotUniqueArray)) {
                            $parkingSlotUniqueArray[$memberKey] = $parkingSlot;
                        } else {
                            $parkingSlotDuplicateObject = array();
                            $parkingSlotDuplicateObject['row_no'] = $memberKey;
                            $parkingSlotDuplicateArray[$memberKey] = $parkingSlotDuplicateObject;
                        }
                    }
                }
            }
            $findDuplicatieParkingSlotArray = array();
            if(!empty($parkingSlotDuplicateArray)){
                foreach($parkingSlotDuplicateArray as $parkingSlotDuplicateElement){
                    $findDuplicatieParkingSlotArray[] =  "Vehicle & Parking Detail Line Item ".$parkingSlotDuplicateElement['row_no'] . "  Parking Slot Duplicate ";
                }
            }

            if(!empty($findDuplicatieParkingSlotArray)){
                $response['success'] = false;
                $response['msg'] = implode("\n", $findDuplicatieParkingSlotArray);
                echo json_encode($response);
                exit;
            }

            $parkingSlotValidationArray = array();
            $selectedParkingSlotArray = array();
            $selectedOwnershipSlotParkingArray = array();
            $aggreementPeriodClosedArray = array();
            $filteredAlreadyAssignedData = array();
            // printArray($parkingSlotIdArray,1);
            // foreach ($parkingSlotIdArray as $pkey => $pValue) {
            //     if(isReferenceInTable('parking_Slot_id', 'tbl_ownership_flat_parking', $pValue) && !empty($pValue)) {
            //         $parkingSlotValidationArray[] = 'Pakeing Slot Is Already Occupied For Row No '. $pkey;
            //     }
            // }

            foreach ($parkingSlotIdArray as $sppKey => $sppValue) {
                $parkingSlotId = array_key_exists($sppKey, $parkingSlotIdArray) ? $parkingSlotIdArray[$sppKey] : '';
                $ownerShipFlatParkingId = array_key_exists($sppKey, $rentalsParkingIdArray) ? $rentalsParkingIdArray[$sppKey] : '';

                if (!empty($parkingSlotId)) {
                    $selectedParkingSlotArray[] = $parkingSlotId;
                }
                if (!empty($ownerShipFlatParkingId)) {
                    $selectedOwnershipSlotParkingArray[] = $ownerShipFlatParkingId;
                }

            }
            $filterData = array(
                "ownership_flat_parking_not_id" => $selectedOwnershipSlotParkingArray,
                "parking_slot_id" => $selectedParkingSlotArray,
                "check_rental_start" => 1,
                "is_multiple" => 1
            );
            if(!empty($selectedParkingSlotArray)){
                $alreadyAssignedData = $this->ownership_flat_model->checkAssignedParking($filterData);
                $aggreementPeriodClosedArray = $this->ownership_flat_model->checkAggrementClosed(array("is_multiple" =>1));
                // lastQuery();
                // printArray($aggreementPeriodClosedArray,1);
                if (!empty($alreadyAssignedData) && !empty($aggreementPeriodClosedArray)) {
                    foreach ($alreadyAssignedData as $key => $assignedData) {
                        $isDuplicate = false;
                        // Only proceed if type is 'rentals'
                        if ($assignedData['type'] == 'rentals') {
                            foreach ($aggreementPeriodClosedArray as $closedData) {
                                // Check if type_id matches rentals_id
                                if ($assignedData['type_id'] == $closedData['rentals_id']) {
                                    // echo "f";
                                    $isDuplicate = true;
                                    break; // No need to check further if we found a match
                                }
                            }
                        }
                        // If no duplicate is found, or the type is not 'rentals', add the item to the filtered list
                        if (!$isDuplicate) {
                            $filteredAlreadyAssignedData[] = $assignedData;
                        }
                    }
                } else {
                    // If either array is empty, no need to filter
                    $filteredAlreadyAssignedData = $alreadyAssignedData;
                }

                // printArray($filteredAlreadyAssignedData,1);
                if(!empty($filteredAlreadyAssignedData)){
                    foreach ($filteredAlreadyAssignedData as $aKey => $value) {
                        $parkingSlotValidationArray[] = 'Parking Slot '. $value['parking_area'] .' Is Already Occupied';
                    }

                }
                if(!empty($parkingSlotValidationArray)){
                    $response['success'] = false;
                    $response['msg'] = implode("\n", $parkingSlotValidationArray);
                    echo json_encode($response);
                    exit;

                }
            }

            $statusId = 0;
            $statusData = $this->status_model->getStatusData(array(
                'status_for' => 'rentals',
                'is_active' => 1,
                'is_open' => 1,
            ));
            if(empty($statusData)){
                $response['success'] = false;
                $response['msg'] = 'Status Master Rentals Is Open Status Not Defined';
                echo json_encode($response);
                exit();
            }
            if(!empty($statusData)){
                $statusId = isset($statusData['status_id']) ? $statusData['status_id'] : 0;
            }
            $rentalsUpdateArray = array();

            $documentPrefix = RENTAL_PREFIX;
            $prefix = $documentPrefix;
            $nextSeries = 'getNextSeries("rentals", "' . $prefix . '","'.$this->session->get('society_id').'")';
            $rentalsArray = array(
                'rentals_id' => $rentalsId,
                'society_id' => $this->session->get('society_id'),
                //'tower_id'=> $towerId,
                'flat_id' => $flatId,
                'ownership_flat_id' => $ownershipFlatId,
                //'owner_member_id' => $ownerMemberId,
                //'owner_contact_no' => $ownerContactNo,
                'broker_id' => $brokerId,
                'broker_contact_no' => $brokerContactNo,
                'tenant_name' => $tenantName,
                'tenant_email' => $tenantEmail,
                'tenant_contact_no' => $tenantContactNo,
                'work_address' => $workAddress,
                'permanent_address' => $permanentAddress,
                'rent_agreement_period_from' => DMYToYMD($rentAgreementPeriodFrom),
                'rent_agreement_period_to' =>  DMYToYMD($rentAgreementPeriodTo),
                //'resident' => $resident,
                'is_active' =>  1,
                'status_id' => $statusId
            );

            if (isset($rentalsId) && $rentalsId == '') {
                $rentalsArray['prefix'] = $prefix;
                $rentalsArray['series'] = $nextSeries;
            }
            if(!empty($rentalsId)){
                $rentalUpdateData = $this->rentals_model->getRentalsData(array(
                    "rentals_id" => $rentalsId
                ));
                $rentalsUpdateArray = compareArray($rentalsArray,$rentalUpdateData);
            }
            $rentalsData = $this->rentals_model->insertUpdateRecord($rentalsArray, 'rentals_id', 'tbl_rentals', 1,'',array("series"),array(),$rentalsUpdateArray);
            $lastRentalsId = $rentalsData['lastInsertedId'];

            // member-Data 
            $filterMemberIdArr = array_filter($filterMobileNoArray, function($value, $key) {
                return !empty($value);
            }, ARRAY_FILTER_USE_BOTH);

            $memberDetailsData = array();
            if($filterMemberIdArr) {
                $memberDetailsData = array_reduce($this->ownership_flat_model->getMemberData(array(
                    'phone' => $filterMemberIdArr,
                    'is_multiple' => 1
                )), function($carry, $item) {
                    $carry[$item['member_id']] = $item;
                    return $carry;
                }, []);
            }

            $memberDetailUpdateArray = array();
            $memberDetailInsertArray = array();
            $ownershipFlatMemberDetailInsertArray = array();
            $ownershipFlatMemberDetailUpdateArray = array();
            if (!empty($memberIdArray)) {
                foreach ($memberIdArray as $mkey => $memberId) {
                    $rentalsMemberId = array_key_exists($mkey, $rentalsMemberIdArray) ? $rentalsMemberIdArray[$mkey] : '';
                    $name = array_key_exists($mkey, $nameArray) ? $nameArray[$mkey] : '';
                    $emailId = array_key_exists($mkey, $emailIdArray) ? $emailIdArray[$mkey] : '';
                    $mobileNo = array_key_exists($mkey, $mobileNoArray) ? $mobileNoArray[$mkey] : '';
                    $gender = array_key_exists($mkey, $genderArray) ? $genderArray[$mkey] : '';
                    $birthDate = array_key_exists($mkey, $birthDateArray) ? $birthDateArray[$mkey] : '';
                    $bloodGroup = array_key_exists($mkey, $bloodGroupArray) ? $bloodGroupArray[$mkey] : '';
                    $relation = array_key_exists($mkey, $relationArray) ? $relationArray[$mkey] : '';
                    $commonMemberImage = array_key_exists($mkey, $commonMemberImageArray) ? $commonMemberImageArray[$mkey] : '';
                    // $foodLike = array_key_exists($mkey, $foodLikeArray) ? $foodLikeArray[$mkey] : '';
                    $agreementWith = isset($agreementWithArray) && array_key_exists($mkey, $agreementWithArray) ? $agreementWithArray[$mkey] : '';

                    if ($memberId == '' && array_key_exists($mkey, $nameArray)) {
                        $memberSlug = random_string();
                        $memberDetailInsertArray[$mkey] = array(
                            'member_id' => '',
                            'name' => $name,
                            'email_id' => $emailId,
                            // 'mobile_no' => $mobileNo,
                            'gender' => $gender,
                            'birth_date' => DMYToYMD($birthDate),
                            'blood_group' => $bloodGroup,
                            // 'relation' => $relation,
                            // 'food_like' => $foodLike,
                            'member_image' => array_key_exists($mkey, $rentalsResult) ? $rentalsResult[$mkey]['file_name'] : 0,
                            'member_slug' => $memberSlug,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        
                    } else {
                        if(isset($memberDetailsData[$memberId])){
                            $memberSlug = $memberDetailsData[$memberId]['member_slug'];
                        }
                        $memberDetailUpdateArray[$mkey] = array(
                            'member_id' => $memberId,
                            'member_slug' => $memberSlug,
                            'name' => $name,
                            'email_id' => $emailId,
                            // 'mobile_no' => $mobileNo,
                            'gender' => $gender,
                            'birth_date' => DMYToYMD($birthDate),
                            'blood_group' => $bloodGroup,
                            // 'relation' => $relation,
                            // 'status' => 'approved',
                            // 'food_like' => $foodLike,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    }

                    if($rentalsMemberId == '' ){
                        $ownershipFlatMemberDetailInsertArray[$mkey] = array(
                            'ownership_flat_member_id' => '',
                            'ownership_flat_id' => $ownershipFlatId,
                            'member_id' => $memberId,
                            'member_slug' => $memberSlug,
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type' => 'rentals',
                            'type_id' => $lastRentalsId,
                            'agreement_with' => isset($agreementWith) ? $agreementWith : 0,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $ownershipFlatMemberDetailUpdateArray[$mkey] = array(
                            'ownership_flat_member_id' => $rentalsMemberId,
                            'ownership_flat_id' => $ownershipFlatId,
                            'member_id' => $memberId,
                            'member_slug' => $memberSlug,
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type' => 'rentals',
                            'type_id' => $lastRentalsId,
                            'agreement_with' => isset($agreementWith) ? $agreementWith : 0,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    }

                    $insertUpdateOwnershipFlatMemberDetailArr[$memberSlug] = array(
                        'member_slug' => $memberSlug,
                        'mobile_no' => $mobileNo,
                    );

                    if (array_key_exists($mkey, $rentalsResult)) {
                        $rentalsFlatResponse = $this->rentals_model->getRentalsMemberData(array("member_id" => $memberId));
                        $imageUrl = '';
                        if (isset($rentalsFlatResponse['member_image']) && $rentalsFlatResponse['member_image'] != '') {
                            $imageUrl = FLAT_MEMBER_IMAGE_PATH . $rentalsFlatResponse['member_image'];
                        }
                        if (file_exists($imageUrl)) {
                            unlink($imageUrl);
                        }

                        $thumbnailImageUrl = '';
                        if (isset($rentalsFlatResponse['member_image']) && $rentalsFlatResponse['member_image'] != '') {
                            $thumbnailImageUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $rentalsFlatResponse['member_image'];
                        }
                        if (file_exists($thumbnailImageUrl)) {
                            unlink($thumbnailImageUrl);
                        }
                        $memberDetailUpdateArray[$mkey]['member_image'] = $rentalsResult[$mkey]['file_name'];
                    }
                    else{
                        $memberDetailUpdateArray[$mkey]['member_image'] = $commonMemberImage; 
                    }
                }
            }
            
            $memberExtraDataArray = array();
            $memberExtraDataArray['module_id'] = $lastRentalsId;
            $memberExtraDataArray['module'] = 'Rental Member';
            $memberExtraDataArray['type'] = 'Rental';
            $memberExtraDataArray['old_data'] = $oldRentalsMemberData;
            $memberExtraDataArray['user_id'] = $this->data['userId'];
            $memberExtraDataArray['society_id'] = $this->session->get('society_id');

            if (!empty($memberDetailInsertArray)) {
                $this->ownership_flat_model->batchInsert($memberDetailInsertArray, MASTER_DB.'.tbl_member',$memberExtraDataArray);
            }
            if (!empty($memberDetailUpdateArray)) {
                $this->ownership_flat_model->batchUpdate($memberDetailUpdateArray, "member_id", MASTER_DB.'.tbl_member',$memberExtraDataArray);
            }
            if (!empty($ownershipFlatMemberDetailInsertArray)) {
                $this->ownership_flat_model->batchInsert($ownershipFlatMemberDetailInsertArray, 'tbl_ownership_flat_member',$memberExtraDataArray);
            }
            if (!empty($ownershipFlatMemberDetailUpdateArray)) {
                $this->ownership_flat_model->batchUpdate($ownershipFlatMemberDetailUpdateArray, "ownership_flat_member_id", 'tbl_ownership_flat_member',$memberExtraDataArray);
            }
            $this->ownership_flat_model->updateMemberId();

            $oldOwnershipFlatMobileNoArray = array();
            $memberMobileMap = [];
            $oldOwnershipFlatMemberIdArray = array();

            $groupData = $this->common_web_service_model->getGroupsData([
                'group_id' => $resourceTypeMemberData['group_id'],
                'society_id' => $this->session->get('society_id'),
            ]);
            
            $groupId = $groupData['id'] ?? '';
            $permissions = $groupData['permissions'] ?? '';
            $permissionArray = unserialize($permissions);
            $permissionLabel = [];
            $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
            
            foreach ($controllers_methods as $controller_name => $methods_arr) {
                foreach ($methods_arr as $method) {
                    $methodDisplay = is_array($method) ? reset($method) : $method;
                    $methodActual = is_array($method) ? key($method) : $method;
                    $inputName = "$controller_name|$methodActual";
                    $permissionLabel[] = "$inputName|dt|$controller_name|dt|$methodDisplay";
                }
            }

            $ownershipFlatMemberInsertData = $this->rentals_model->getRentalsMemberData([
                'ownership_flat_id' => $ownershipFlatId,
                'type_id' => $lastRentalsId,
                'type' => 'rentals',
                'is_multiple' => 1,
                'society_id' => $this->session->get('society_id'),
            ]);
            // adding mobile No's
            foreach ($ownershipFlatMemberInsertData as $key => $value) {
                $ownershipFlatMemberInsertData[$key]['mobile_no'] = $insertUpdateOwnershipFlatMemberDetailArr[$value['member_slug']]['mobile_no'];
            }

            $oldMemberArr = array();
            foreach ($oldRentalsMemberData as $oKey => $oldMember) {
                $oldmemberComboKey = $oldMember['society_id'].'|'.$oldMember['ownership_flat_member_id'];
                $oldMemberArr[$oldmemberComboKey] = $oldMember;
            }

            $tblUsrInsertArr = [];
            $tblUsrUpdateArr = [];
            $tblUsrSocietyInsertArr = [];
            $tblUsrSocietyUpadteArr = [];
            $tblUsrGroupArr = [];
            $tblUsrPermissionArr = [];
            $deleteUserArr = [];
            $deleteMemberIdArr = [];
            $deleteUserIdArr = [];
            $deleteUserSocietyIdArr = [];

            $existsUserDataArr = array();
            $existsUserMobileNoWiseArr = array();
            if(!empty($existsUserData)){
                foreach($existsUserData as $existsUser) {
                    $comboKey = $existsUser['society_id']."|".$existsUser['resource_type_id']."|".$existsUser['type_id'];
                    $existsUserDataArr[$comboKey] = $existsUser;
                    $existsUserMobileNoWiseArr[$existsUser['phone']][] = $existsUser;
                }
            }

            $existsUserMemberDataArr = array();
            if(!empty($existsUserMemberData)){
                foreach($existsUserMemberData as $existsUserMember){
                    $comboKey=$existsUserMember['society_id']."|".$existsUserMember['resource_type_id']."|".$existsUserMember['type_id'];
                    $existsUserMemberDataArr[$comboKey] = $existsUserMember;
                }
            }

            foreach($ownershipFlatMemberInsertData as $newMember){
                $newMemberComboKey = $newMember['society_id']."|".$newMember['resource_type_id']."|".$newMember['member_id'];
                $newComboKey = $newMember['society_id']."|".$newMember['ownership_flat_member_id'];
                if(empty($existsUserData)){
                    // New User
                    $password = PASSWORD;
                    $slug = random_string();
                    $slugSociety = random_string();
                    if(!empty($newMember['mobile_no'])){
                        $tblUsrInsertArr[] = [
                            'username' => $newMember['email_id'],
                            'email' => $newMember['email_id'],
                            'first_name' => $newMember['name'],
                            // 'phone' => $newMember['mobile_no'],
                            'user_type_id' => $newMember['member_id'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'password' => $this->ionAuthModel->hashPassword($password),
                            'active' => 1,
                            'slug' => $slug,
                            'created_at' => date('Y-m-d H:i:s'),
                            'created_by' => $this->session->get('user_id'),
                            'updated_at' => date('Y-m-d H:i:s'),
                            'updated_by' => $this->session->get('user_id'),
                        ];
                
                        $tblUsrGroupArr[] = [
                            'id' => '',
                            'group_id' => $groupId,
                            'slug' => $slug,
                            'society_slug' => $slugSociety,
                        ];
                
                        $tblUsrSocietyInsertArr[] = [
                            'user_society_id' => '',
                            'society_id' => $this->session->get('society_id'),
                            'phone' => $newMember['mobile_no'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type_id' => $newMember['member_id'],
                            'slug' => $slug,
                            'is_active' => 1,
                            'society_slug' => $slugSociety,
                            'created_at' => date('Y-m-d H:i:s'),
                            'created_by' => $this->session->get('user_id'),
                            'updated_at' => date('Y-m-d H:i:s'),
                            'updated_by' => $this->session->get('user_id'),
                        ];
                
                        foreach ($permissionLabel as $labelData) {
                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                            if (in_array($permissionValue, $permissionArray)) {
                                $tblUsrPermissionArr[] = [
                                    'controller_name' => $controller,
                                    'permission_name' => $permissionValue,
                                    'permission_label' => $label,
                                    'group_id' => $resourceTypeMemberData['group_id'],
                                    'slug' => $slug,
                                    'society_slug' => $slugSociety,
                                    'created_at' => date('Y-m-d H:i:s'),
                                    'created_by' => $this->session->get('user_id'),
                                    'updated_at' => date('Y-m-d H:i:s'),
                                    'updated_by' => $this->session->get('user_id'),
                                ];
                            }
                        }
                    }
                }
                else {
                    // phone no update
                    if(isset($existsUserDataArr[$newMemberComboKey])){
                        $userSocietyId = $existsUserDataArr[$newMemberComboKey]['user_society_id'];
                        $userSocietyMemberId = $existsUserDataArr[$newMemberComboKey]['type_id'];
                        if($newMember['mobile_no'] != $existsUserDataArr[$newMemberComboKey]['phone']){
                            if(empty($newMember['mobile_no'])){
                                $deleteUserSocietyIdArr[] = $userSocietyMemberId;
                            } else {
                                $tblUsrSocietyUpadteArr[] = array(
                                    'user_society_id' => $userSocietyId,
                                    'phone' => $newMember['mobile_no'],
                                    'updated_at' => date('Y-m-d H:i:s'),
                                    'updated_by' => $this->session->get('user_id'),
                                );
                            }
                        }
                        continue;
                    }

                    // member id changed
                    if(isset($oldMemberArr[$newComboKey])){
                        $oldMemberId = $oldMemberArr[$newComboKey]['member_id'];
                        $newMemberId = $newMember['member_id'];
                        // $oldMemberComboKey = $oldMemberArr[$newComboKey]['society_id'].'|'.$oldMemberArr[$newComboKey]['resource_type_id'].'|'.$oldMemberArr[$newComboKey]['member_id'];
                        // $oldUserSocietyId = $existsUserDataArr[$oldMemberComboKey]['user_society_id'];
                        if($oldMemberId != $newMemberId){
                            $deleteUserSocietyIdArr[] = $oldMemberId;
                        }
                    }

                    if(isset($existsUserMobileNoWiseArr[$newMember['mobile_no']])){
                        // new entry if not in user society
                        if(!isset($existsUserMemberDataArr[$newMemberComboKey])) {
                            $password = PASSWORD;
                            $slugSociety = random_string();
                            // $slug = $existsUserMemberDataArr[$newMemberComboKey]['slug'];
                            $slug = $existsUserMobileNoWiseArr[$newMember['mobile_no']][0]['slug'];
                            $tblUsrGroupArr[] = [
                                'id' => '',
                                'group_id' => $groupId,
                                'slug' => $slug,
                                'society_slug' => $slugSociety,
                            ];
                    
                            $tblUsrSocietyInsertArr[] = [
                                'user_society_id' => '',
                                'is_active' => 1,
                                'society_id' => $this->session->get('society_id'),
                                'phone' => $newMember['mobile_no'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $newMember['member_id'],
                                'slug' => $slug,
                                'society_slug' => $slugSociety,
                                'created_at' => date('Y-m-d H:i:s'),
                                'created_by' => $this->session->get('user_id'),
                                'updated_at' => date('Y-m-d H:i:s'),
                                'updated_by' => $this->session->get('user_id'),
                            ];
                    
                            foreach ($permissionLabel as $labelData) {
                                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                if (in_array($permissionValue, $permissionArray)) {
                                    $tblUsrPermissionArr[] = [
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'group_id' => $resourceTypeMemberData['group_id'],
                                        'slug' => $slug,
                                        'society_slug' => $slugSociety,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'created_by' => $this->session->get('user_id'),
                                        'updated_at' => date('Y-m-d H:i:s'),
                                        'updated_by' => $this->session->get('user_id'),
                                    ];
                                }
                            }
                        }
                    } else {
                        // New User
                        $password = PASSWORD;
                        $slug = random_string();
                        $slugSociety = random_string();
                        if(!empty($newMember['mobile_no'])){
                            $tblUsrInsertArr[] = [
                                'username' => $newMember['email_id'],
                                'email' => $newMember['email_id'],
                                'first_name' => $newMember['name'],
                                // 'phone' => $newMember['mobile_no'],
                                'user_type_id' => $newMember['member_id'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'password' => $this->ionAuthModel->hashPassword($password),
                                'active' => 1,
                                'slug' => $slug,
                            ];
                    
                            $tblUsrGroupArr[] = [
                                'id' => '',
                                'group_id' => $groupId,
                                'slug' => $slug,
                                'society_slug' => $slugSociety,
                            ];
                    
                            $tblUsrSocietyInsertArr[] = [
                                'user_society_id' => '',
                                'society_id' => $this->session->get('society_id'),
                                'phone' => $newMember['mobile_no'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $newMember['member_id'],
                                'slug' => $slug,
                                'is_active' => 1,
                                'society_slug' => $slugSociety,
                                'created_at' => date('Y-m-d H:i:s'),
                                'created_by' => $this->session->get('user_id'),
                                'updated_at' => date('Y-m-d H:i:s'),
                                'updated_by' => $this->session->get('user_id'),
                            ];
                    
                            foreach ($permissionLabel as $labelData) {
                                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                if (in_array($permissionValue, $permissionArray)) {
                                    $tblUsrPermissionArr[] = [
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'group_id' => $resourceTypeMemberData['group_id'],
                                        'slug' => $slug,
                                        'society_slug' => $slugSociety,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'created_by' => $this->session->get('user_id'),
                                        'updated_at' => date('Y-m-d H:i:s'),
                                        'updated_by' => $this->session->get('user_id'),
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            // Execute all batch operations
            if (!empty($tblUsrUpdateArr)) {
                $this->resource_model->batchUpdate($tblUsrUpdateArr, 'id', MASTER_DB.'.tbl_users');
            }
            if (!empty($tblUsrInsertArr)) {
                $this->resource_model->batchInsert($tblUsrInsertArr, MASTER_DB.'.tbl_users');
            }
            if (!empty($tblUsrGroupArr)) {
                $this->resource_model->batchInsert($tblUsrGroupArr, MASTER_DB.'.tbl_users_groups');
            }
            if (!empty($tblUsrSocietyInsertArr)) {
                $this->resource_model->batchInsert($tblUsrSocietyInsertArr, MASTER_DB.'.tbl_user_society');
            }
            if (!empty($tblUsrSocietyUpadteArr)) {
                $this->resource_model->batchUpdate($tblUsrSocietyUpadteArr,'user_society_id', MASTER_DB.'.tbl_user_society');
            }
            if (!empty($tblUsrPermissionArr)) {
                $this->resource_model->batchInsert($tblUsrPermissionArr, MASTER_DB.'.tbl_user_permission');
            }
            if (!empty($deleteUserSocietyIdArr)){
                $this->ownership_flat_model->deleteUserIdRecords(array(
                    'member_id' => $deleteUserSocietyIdArr,
                ));
            }
            
            // Refresh mapping IDs
            $this->resource_type_model->updateUserGroupId();
            $this->resource_type_model->updateUserSocietyId();
            $this->resource_type_model->updateUserPermissionId();
            $this->resource_type_model->updateUserPermissionSocietyId();

            if (!empty($rentalsEmergencyContactIdArray)) {
                foreach ($rentalsEmergencyContactIdArray as $ecKey =>  $rentalsEmergencyContactId) {
                    $ecName = array_key_exists($ecKey, $ecNameArray) ? $ecNameArray[$ecKey] : '';
                    $ecPlace = array_key_exists($ecKey, $ecPlaceArray) ? $ecPlaceArray[$ecKey] : '';
                    $ecRelation = array_key_exists($ecKey, $ecRelationArray) ? $ecRelationArray[$ecKey] : '';
                    $ecMobileNo = array_key_exists($ecKey, $ecMobileNoArray) ? $ecMobileNoArray[$ecKey] : '';

                    if ($rentalsEmergencyContactId == '' && array_key_exists($ecKey, $ecNameArray)) {
                        $contactDetailInsertArray[$ecKey] = array(
                            'ownership_flat_emergency_contact_id' => '',
                            'type' => 'rentals',
                            'type_id' => $lastRentalsId,
                            'name' => $ecName,
                            'place' => $ecPlace,
                            'relation' => $ecRelation,
                            'mobile_no' => $ecMobileNo,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $contactDetailUpdateArray[$ecKey] = array(
                            'ownership_flat_emergency_contact_id' => $rentalsEmergencyContactId,
                            'type' => 'rentals',
                            'type_id' => $lastRentalsId,
                            'name' => $ecName,
                            'place' => $ecPlace,
                            'relation' => $ecRelation,
                            'mobile_no' => $ecMobileNo,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    }
                }

                $emergencyContactExtraDataArray = array();
                $emergencyContactExtraDataArray['module_id'] = $lastRentalsId;
                $emergencyContactExtraDataArray['module'] = 'Rental Emergency Contact';
                $emergencyContactExtraDataArray['type'] = 'Rental';
                $emergencyContactExtraDataArray['old_data'] = $oldRentalsEmergencyContactData;
                $emergencyContactExtraDataArray['user_id'] = $this->data['userId'];
                $emergencyContactExtraDataArray['society_id'] = $this->session->get('society_id');
                if (!empty($contactDetailInsertArray)) {
                    $this->rentals_model->batchInsert($contactDetailInsertArray, 'tbl_ownership_flat_emergency_contact',$emergencyContactExtraDataArray);
                }
                if (!empty($contactDetailUpdateArray)) {
                    $this->rentals_model->batchUpdate($contactDetailUpdateArray, "ownership_flat_emergency_contact_id", 'tbl_ownership_flat_emergency_contact',$emergencyContactExtraDataArray);
                }
            }

            if (!empty($rentalsParkingIdArray)) {
                foreach ($rentalsParkingIdArray as $pKey => $rentalsParkingId) {
                    $vehicleType = isset($vehicleTypeArray) && array_key_exists($pKey, $vehicleTypeArray) ? $vehicleTypeArray[$pKey] : '';
                    $parkingSlotId = array_key_exists($pKey, $parkingSlotIdArray) ? $parkingSlotIdArray[$pKey] : '';
                    $vehicleNo = array_key_exists($pKey, $vehicleNoArray) ? $vehicleNoArray[$pKey] : '';
                    // $parkingSlotNo = array_key_exists($pKey, $parkingSlotNoArray) ? $parkingSlotNoArray[$pKey] : '';
                    $tokenNo = array_key_exists($pKey, $tokenNoArray) ? $tokenNoArray[$pKey] : '';
                    $isElectric = array_key_exists($pKey, $isElectricArray) ? $isElectricArray[$pKey] : '';

                    if ($rentalsParkingId == '' && (isset($vehicleTypeArray) && array_key_exists($pKey, $vehicleTypeArray))) {
                        $parkingDetailInsertArray[$pKey] = array(
                            'ownership_flat_parking_id' => '',
                            'ownership_flat_id' => $ownershipFlatId,
                            'type' => 'rentals',
                            'type_id' => $lastRentalsId,
                            'vehicle_type' => $vehicleType,
                            'parking_slot_id' => $parkingSlotId,
                            'vehicle_no' => $vehicleNo,
                            // 'parking_slot_no' => $parkingSlotNo,
                            'token_no' => $tokenNo,
                            'is_electric' => $isElectric,
                            'vehicle_image' => array_key_exists($pKey, $rentalsParkingResult) ? $rentalsParkingResult[$pKey]['file_name'] : 0,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $parkingDetailUpdateArray[$pKey] = array(
                            'ownership_flat_parking_id' => $rentalsParkingId,
                            'ownership_flat_id' => $ownershipFlatId,
                            'type' => 'rentals',
                            'type_id' => $lastRentalsId,
                            'vehicle_type' => $vehicleType,
                            'parking_slot_id' => $parkingSlotId,
                            'vehicle_no' => $vehicleNo,
                            // 'parking_slot_no' => $parkingSlotNo,
                            'token_no' => $tokenNo,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        if (array_key_exists($pKey, $rentalsParkingResult)) {
                            $rentalsParkingResponse = $this->rentals_model->getRentalsParkingData(array("ownership_flat_member_id" => $rentalsMemberId));
                            $imageUrl = '';
                            if (isset($rentalsParkingResponse['vehicle_image']) && $rentalsParkingResponse['vehicle_image'] != '') {
                                $imageUrl = FLAT_MEMBER_IMAGE_PATH . $rentalsParkingResponse['vehicle_image'];
                            }
                            if (file_exists($imageUrl)) {
                                unlink($imageUrl);
                            }

                            $thumbnailImageUrl = '';
                            if (isset($rentalsParkingResponse['vehicle_image']) && $rentalsParkingResponse['vehicle_image'] != '') {
                                $thumbnailImageUrl = THUMBNAIL_VEHICLE_IMAGE_PATH . $rentalsParkingResponse['vehicle_image'];
                            }
                            if (file_exists($thumbnailImageUrl)) {
                                unlink($thumbnailImageUrl);
                            }
                            $parkingDetailUpdateArray[$pKey]['vehicle_image'] = $rentalsParkingResult[$pKey]['file_name'];
                        }

                        $parkingSlotUpdateArray = array(
                            'parking_slot_id' => $parkingSlotId,
                            'ownership_flat_parking_id' => $rentalsParkingId,
                        );

                        $this->rentals_model->insertUpdateRecord($parkingSlotUpdateArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
                    }
                }
                $parkingExtraDataArray = array();
                $parkingExtraDataArray['module_id'] = $lastRentalsId;
                $parkingExtraDataArray['module'] = 'Rental Parking Detail';
                $parkingExtraDataArray['type'] = 'Rental';
                $parkingExtraDataArray['old_data'] = $oldRentalsParkingData;
                $parkingExtraDataArray['user_id'] = $this->data['userId'];
                $parkingExtraDataArray['society_id'] = $this->session->get('society_id');

                if (!empty($parkingDetailInsertArray)) {
                    $this->rentals_model->batchInsert($parkingDetailInsertArray, 'tbl_ownership_flat_parking',$parkingExtraDataArray);
                }
                if (!empty($parkingDetailUpdateArray)) {
                    $this->rentals_model->batchUpdate($parkingDetailUpdateArray, "ownership_flat_parking_id", 'tbl_ownership_flat_parking',$parkingExtraDataArray);
                }
            }



            if (!empty($rentalsFlatOwnerIdArray)) {
                if($rentalsId != ''){
                    $this->rentals_model->deleteRentalsFlatOwnerRecord($lastRentalsId);
                }

                foreach ($rentalsFlatOwnerIdArray as $foKey =>  $rentalsFlatOwnerId) {
                    $ownerId = array_key_exists($foKey, $ownerIdArray) ? $ownerIdArray[$foKey] : '';
                    $ownerName = array_key_exists($foKey, $ownerNameArray) ? $ownerNameArray[$foKey] : '';
                    $ownerMobileNo = array_key_exists($foKey, $ownerMobileNoArray) ? $ownerMobileNoArray[$foKey] : '';

                    $flatOwnerInsertArray[$foKey] = array(
                        'rentals_flat_owner_id' => '',
                        'rentals_id' => $lastRentalsId,
                        'owner_id' => $ownerId,
                        'owner_name' => $ownerName,
                        'mobile_no' => $ownerMobileNo,
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }

                $flatOwnerExtraDataArray = array();
                $flatOwnerExtraDataArray['module_id'] = $lastRentalsId;
                $flatOwnerExtraDataArray['module'] = 'Rental Flat Owner';
                $flatOwnerExtraDataArray['type'] = 'Rental';
                $flatOwnerExtraDataArray['old_data'] = array();
                $flatOwnerExtraDataArray['user_id'] = $this->data['userId'];
                $flatOwnerExtraDataArray['society_id'] = $this->session->get('society_id');
                if (!empty($flatOwnerInsertArray)) {
                    $this->rentals_model->batchInsert($flatOwnerInsertArray, 'tbl_rentals_flat_owner',$flatOwnerExtraDataArray);
                }
            }

            $moduleDocumentUpdateArray = array();
            $documentIdArray = $this->request->getVar('document_id');
            $moduleDocumentIdArray = $this->request->getVar('module_document_id');
            $inputBoxArray = $this->request->getVar('input_box');
            $documentExpiryDateArray = $this->request->getVar('document_expiry_date');
            if (!empty($moduleDocumentIdArray)) {
                foreach ($moduleDocumentIdArray as $fkey => $moduleDocumentId) {
                    $moduleDocumentsId = array_key_exists($fkey, $moduleDocumentIdArray) ? $moduleDocumentIdArray[$fkey] : 0;
                    $documentId = array_key_exists($fkey, $documentIdArray) ? $documentIdArray[$fkey] : 0;
                    $inputBox = (isset($inputBoxArray) && array_key_exists($fkey, $inputBoxArray)) ? $inputBoxArray[$fkey] : 0;
                    $documentExpiryDate = (isset($documentExpiryDateArray) && array_key_exists($fkey, $documentExpiryDateArray)) ? $documentExpiryDateArray[$fkey] : 0;
                    $moduleDocumentImage = array_key_exists($fkey, $imageResultArray) ? $imageResultArray[$fkey] : [];
                    $moduleDocumentInsertArray = array(
                        'module_document_id' => $moduleDocumentsId,
                        'module_id' => $lastRentalsId,
                        'module' => 'rentals',
                        'document_id' => $documentId,
                        'input_box' => $inputBox,
                        'document_expiry_date' => $documentExpiryDate,
                    );
                    if(!empty($moduleDocumentId)){
                        $documentUpdateData = $this->staff_model->getDocument(array(
                            'module_document_id' => $moduleDocumentId,
                        ));
                        $moduleDocumentUpdateArray = compareArray($moduleDocumentInsertArray,$documentUpdateData);
                        $moduleDocumentUpdateArray['type'] = 'Rental';
                        $moduleDocumentUpdateArray['type_id']  = $lastRentalsId;
                    }
                    $moduleDocumentData = $this->rentals_model->insertUpdate($moduleDocumentInsertArray, 'module_document_id', 'tbl_module_document', 1,$moduleDocumentUpdateArray);
                    $lastModuleDocumentId = $moduleDocumentData['lastInsertedId'];
                    // printArray($moduleDocumentImage);
                    $imageDataArray = array();
                    if(!empty($moduleDocumentImage)){
                        unset($imageResultArray['success']);
                        foreach ($moduleDocumentImage as  $mdImageElement){
                            $imageDataArray[] = array(
                                'module_document_image_id' =>   '',
                                'module_id' => $lastRentalsId,
                                'module' => 'rentals',
                                'module_document_id' => $lastModuleDocumentId,
                                'document_id' => $documentId,
                                'document_image' => isset($mdImageElement['file_name']) ? $mdImageElement['file_name'] : "",
                                'created_at' => date('Y-m-d H:i:s'),
                                'updated_at' => date('Y-m-d H:i:s'),
                                'created_by' => $this->data['userId'],
                                'updated_by' => $this->data['userId']
                            );
                        }
                        $mediaExtraDataArray = array();
                        $mediaExtraDataArray['module_id'] = $lastRentalsId;
                        $mediaExtraDataArray['module'] = 'Rentals Document Image';
                        $mediaExtraDataArray['type'] = 'Rentals';
                        $mediaExtraDataArray['old_data'] = array();
                        $mediaExtraDataArray['user_id'] = $this->data['userId'];
                        $mediaExtraDataArray['society_id'] = $this->session->get('society_id');
                        $this->rentals_model->batchInsert($imageDataArray, 'tbl_module_document_image',$mediaExtraDataArray);
                    }
                }
            }

            $transactionStatus = $this->db->transComplete();
            $transactionCentralStatus = $this->centralDB->transComplete();

            if (isset($rentalsId) && $rentalsId != '') {
                if (($rentalsData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Rentals.rentals'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Rentals.rentals'));
                }
            } else {
                if (($rentalsData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Rentals.rentals'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Rentals.rentals'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $rentalsId   = $this->request->getVar('rentals_id');
        $status = $this->request->getVar('status');
        $return = $this->rentals_model->statusChange($rentalsId,$status,'rentals_id','tbl_rentals');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Rentals.rentals'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Rentals.rentals'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $this->centralDB->transStart();

        $rentalsId  = $this->request->getVar('rentals_id');
        $rentalsData = $this->rentals_model->getRentalsData(array(
            'rentals_id' =>$rentalsId,
            'is_multiple' => 1
        ));

        $isCloseRentalArray = array();
        $rentAgreementPeriodToArray = array();
        $commonMessage = '';
        if (!empty($rentalsData)) {
            foreach ($rentalsData as $rentalsElement) {
                $documentNumber =  $rentalsElement['document_number'];
                $rentAgreementPeriodFrom =  $rentalsElement['rent_agreement_period_from'];
                $rentAgreementPeriodTo =  $rentalsElement['rent_agreement_period_to'];
                if ($rentalsElement['is_close'] == 1) {
                    $isCloseRentalArray[]= $documentNumber;
                } else {
                    if ((strtotime(TODAY_DATE_YMD) >= strtotime($rentAgreementPeriodFrom)) && (strtotime(TODAY_DATE_YMD) <= strtotime($rentAgreementPeriodTo))){
                    } else {
                        if(strtotime($rentAgreementPeriodFrom) < strtotime(TODAY_DATE_YMD)){
                            $rentAgreementPeriodToArray[] = $documentNumber;
                        }
                    }

                }
            }
        }



        if (!empty($isCloseRentalArray) || !empty($rentAgreementPeriodToArray)) {

            if (!empty($isCloseRentalArray)) {

                $rentalsNo = implode(",", $isCloseRentalArray);

                $commonMessage .= 'For Rental '. $rentalsNo . " Already Closed So Can't Deleted." ;

            }

            if (!empty($rentAgreementPeriodToArray)) {
                $rentalsNo = implode(",", $rentAgreementPeriodToArray);
                $newLine = '';
                if ($commonMessage != '') {
                    $newLine .= "\n";
                }
                $commonMessage .= $newLine . 'For Rental '. $rentalsNo . " The Aggreement Period Have Been Passed So Can't Deleted." ;
            }

            $response['success'] = false;
            $response['msg'] = $commonMessage ;
            echo json_encode($response);
            exit;
        }

        $moduleDocumentImageData = $this->staff_model->getDocumentImage(array(
            "module_id" => $rentalsId,
            "module" => 'rentals',
            "is_multiple" =>1,
        ));
        if(is_array($moduleDocumentImageData) && !empty($moduleDocumentImageData)){
            foreach ($moduleDocumentImageData as $image){
                $FileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }

        $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
            'type' => 'rentals',
            'type_id' => $rentalsId,
            'is_multiple' => 1,
        ));



        $deleteMemberIdArr = array(); 

        if(is_array($ownershipFlatMemberData) && !empty($ownershipFlatMemberData)){
            foreach ($ownershipFlatMemberData as $image){
                $FileUrl = '';
                if(isset($image['member_image']) && $image['member_image'] != '') {
                    $FileUrl = FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['member_image']) && $image['member_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }

                $deleteMemberIdArr[] = $image['member_id'];
            }
        }

        // printArray($deleteMemberIdArr,1);

        $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
            //'ownership_flat_id' => $ownershipFlatId,
            'type' => 'rentals',
            'type_id' => $rentalsId,
            'is_multiple' => 1
        ));

        if(is_array($ownershipFlatParkingData) && !empty($ownershipFlatParkingData)){
            foreach ($ownershipFlatParkingData as $image){
                $FileUrl = '';
                if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                    $FileUrl = VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }


        $rentalsData = $this->rentals_model->deleteRecord($rentalsId);
        $deleteUserData = $this->ownership_flat_model->deleteUserIdRecords(array(
            'member_id' => $deleteMemberIdArr,
        ));
        $transactionStatus = $this->db->transComplete();
        $transactionCentralStatus = $this->centralDB->transComplete();
        if (($rentalsData && $deleteUserData) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Rentals.rentals"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Rentals.rentals"));
        }
        echo json_encode($response);
        exit;
    }

    public function addRentalsMemberRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $memberRow = view('Admin/Rentals/RentalsMemberRowView', $data);
        echo $memberRow;
    }

    public function deleteRentalsMemberRow()
    {
        $this->db->transStart();
        $ownershipFlatMemberId  = $this->request->getVar('ownership_flat_member_id');
        $rentalsId = $this->request->getVar('rentals_id');

        $rentalsMemberDeleteData = $this->rentals_model->getRentalsMemberData(array(
            'ownership_flat_member_id' => $ownershipFlatMemberId,
            'is_multiple' => 1
        ));
        if(is_array($rentalsMemberDeleteData) && !empty($rentalsMemberDeleteData)){
            foreach ($rentalsMemberDeleteData as $image){
                $FileUrl = '';
                if(isset($image['member_image']) && $image['member_image'] != '') {
                    $FileUrl = FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['member_image']) && $image['member_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }

        $rentalsMemberData = $this->rentals_model->deleteRentalsMemberRecord($ownershipFlatMemberId);

        if ($rentalsMemberData) {
            if(!empty($rentalsMemberId)){
                foreach($rentalsMemberId as $documentElement){
                    $deleteDataArray['module'] = 'Rentals Member';
                    $deleteDataArray['activity'] = "Rentals Member Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Rentals Member Deleted [RentalsMemberID: ' . $documentElement . ']',$this->data['userId'],'Rentals Member',$documentElement,json_encode($deleteDataArray),'','Rentals',$rentalsId);
                }
            }

            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Rentals.rentals_member'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Rentals.rentals_member'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Rentals.rentals_member'));
        }
        echo json_encode($response);
        exit();
    }

    public function addRentalsEmergencyContactRow()
    {
        $data['contact_row_number'] = $this->request->getVar("contact_row_number");
        $contactRow = view('Admin/Rentals/RentalsEmergencyContactRowView', $data);
        echo $contactRow;
    }

    public function deleteRentalsEmergencyContactRow()
    {
        $this->db->transStart();
        $ownershipFlatEmergencyContactId = $this->request->getVar('ownership_flat_emergency_contact_id');
        $rentalsId =$this->request->getVar('rentals_id');

        $rentalsEmergencyData = $this->rentals_model->deleteRentalsContactRecord($ownershipFlatEmergencyContactId);

        if ($rentalsEmergencyData) {
            if(!empty($rentalsEmergencyContactId)){
                foreach($rentalsEmergencyContactId as $documentElement){
                    $deleteDataArray['module'] = 'Rentals Emergency Contact';
                    $deleteDataArray['activity'] = "Rentals Emergency Contact Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Rentals Emergency Contact Deleted [RentalsEmergencyContactID: ' . $documentElement . ']',$this->data['userId'],'Rentals Emergency Contact',$documentElement,json_encode($deleteDataArray),'','Rentals',$rentalsId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Rentals.rentals_contact'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Rentals.rentals_contact'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Rentals.rentals_contact'));
        }
        echo json_encode($response);
        exit();
    }

    public function addRentalsParkingRow()
    {
        $data['parking_row_number'] = $this->request->getVar("parking_row_number");
        $parkingRow = view('Admin/Rentals/RentalsParkingRowView', $data);
        echo $parkingRow;
    }

    public function deleteRentalsParkingRow()
    {
        $this->db->transStart();
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $rentalsId = $this->request->getVar('rentals_id');

        $rentalsParkingDeleteData = $this->rentals_model->getRentalsParkingData(array(
            'ownership_flat_parking_id' => $ownershipFlatParkingId,
            'is_multiple' => 1
        ));

        if(is_array($rentalsParkingDeleteData) && !empty($rentalsParkingDeleteData)){
            foreach ($rentalsParkingDeleteData as $image){
                $FileUrl = '';
                if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                    $FileUrl = VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }

        $rentalsParkingData = $this->rentals_model->deleteRentalsParkingRecord($ownershipFlatParkingId);

        if ($rentalsParkingData) {

            if(!empty($rentalsParkingId)){
                foreach($rentalsParkingId as $documentElement){
                    $deleteDataArray['module'] = 'Rentals Parking';
                    $deleteDataArray['activity'] = "Rentals Parking Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Rentals Parking Deleted [RentalsParkingID: ' . $documentElement . ']',$this->data['userId'],'Rentals Parking',$documentElement,json_encode($deleteDataArray),'','Rentals',$rentalsId);
                }
            }

            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Rentals.rentals_parking'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Rentals.rentals_parking'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Rentals.rentals_parking'));
        }
        echo json_encode($response);
        exit();
    }
    public function changeRentalStatus()
    {
        $validation = \Config\Services::validation();
        $this->db->transStart();
        $rentalId    = $this->request->getVar('modal_rental_id');
        $closingDate = $this->request->getVar('closing_date');
        $closingReason = $this->request->getVar('closing_reason');

        $validation->setRule('modal_rental_id', lang('Rentals.rental_id'), 'required');
        $validation->setRule('closing_date', lang('Rentals.closing_date'), 'required');
        $validation->setRule('closing_reason', lang('Rentals.closing_reason'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $statusId = 0;
            $statusData = $this->status_model->getStatusData(array(
                'status_for' => 'rentals',
                'is_active' => 1,
                'is_close' => 1,
            ));
            if(empty($statusData)){
                $response['success'] = false;
                $response['msg'] = 'Status Master Rentals Is Close Status Not Defined';
                echo json_encode($response);
                exit();
            }
            if(!empty($statusData)){
                $statusId = isset($statusData['status_id']) ? $statusData['status_id'] : 0;
            }

            $rentalIdArray = explode(',', $rentalId);

            if (!empty($rentalIdArray)) {
                $rentalsData = $this->rentals_model->getRentalsData(array('rentals_id'=>$rentalIdArray));
                $rentAgreementPeriodFrom = '';
                $rentAgreementPeriodTo = '';
                $rentalStatusId ='';

                if(!empty($rentalsData)){
                    $rentAgreementPeriodFrom = isset($rentalsData['rent_agreement_period_from']) ? $rentalsData['rent_agreement_period_from'] :'';
                    $rentAgreementPeriodTo = isset($rentalsData['rent_agreement_period_to']) ? $rentalsData['rent_agreement_period_to'] :'';
                    $rentalStatusId = isset($rentalsData['status_id']) ? $rentalsData['status_id'] :'';
                }

                // printArray(DMYToYMD($closingDate));
                // printArray($rentAgreementPeriodFrom);
                // printArray($rentAgreementPeriodTo);

                if($rentalStatusId == $statusId){
                    $response['success'] = false;
                    $response['msg'] = "Rental Already Closed";
                    echo json_encode($response);
                    exit();
                }

                if ((strtotime(DMYToYMD($closingDate)) >= strtotime($rentAgreementPeriodFrom)) && (strtotime(DMYToYMD($closingDate)) <= strtotime($rentAgreementPeriodTo))){
                } else {
                    $response['success'] = false;
                    $response['msg'] = "Please Select Rental Closing Date Between ".YMDToDMY($rentAgreementPeriodFrom) ." To ".YMDToDMY($rentAgreementPeriodTo) ;
                    echo json_encode($response);
                    exit();
                }

                //printArray($rentalsData ,1);

                foreach ($rentalIdArray as $rKey => $rentalElement) {
                    $rentalClosingUpdateArray[$rKey] = array(
                        'rentals_id' => $rentalElement,
                        'rental_closing_date' => DMYToYMD($closingDate),
                        'rental_closing_reason' => $closingReason,
                        'status_id' => $statusId
                    );
                }

                if (!empty($rentalClosingUpdateArray)) {
                    $rentalsDataArray[] = $rentalsData;
                    $rentalClosingExtraDataArray = array();
                    $rentalClosingExtraDataArray['module_id'] = $rentalStatusId;
                    $rentalClosingExtraDataArray['module'] = 'Rental Closed';
                    $rentalClosingExtraDataArray['type'] = 'Rental';
                    $rentalClosingExtraDataArray['old_data'] = $rentalsDataArray;
                    $rentalClosingExtraDataArray['user_id'] = $this->data['userId'];
                    $rentalClosingExtraDataArray['society_id'] = $this->session->get('society_id');
                    $closingUpdateData = $this->rentals_model->batchUpdate($rentalClosingUpdateArray, "rentals_id",  'tbl_rentals',$rentalClosingExtraDataArray);
                }

                $rentalsParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                    'type' => 'rentals',
                    'type_id' => $rentalIdArray,
                    'is_multiple' => 1,
                ));
                if(!empty($rentalsParkingData)){
                    foreach($rentalsParkingData as $rPkey =>  $rentalsParkingElement){
                        $rentalsParkingUpdateArray[$rPkey] = array(
                            'ownership_flat_parking_id' => $rentalsParkingElement['ownership_flat_parking_id'],
                            'is_delete' => 1
                        );
                    }
                    if (!empty($rentalsParkingUpdateArray)) {
                        $this->rentals_model->batchUpdate($rentalsParkingUpdateArray, "ownership_flat_parking_id",  'tbl_ownership_flat_parking');
                    }
                }
            }

            $transactionStatus = $this->db->transComplete();
            if (($closingUpdateData['success']) && ($transactionStatus == 1)) {
                $response['success']  = true;
                $response['msg']      = "Rental Close Agreement Successfully";
            } else {
                $response['success']  = false;
                $response['msg']      = "Rental Close Agreement Error!";
            }
            echo json_encode($response);
            exit();
        }
    }

    public function getAllRentalsMemberDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $flatId = $this->request->getVar('flat_id');
        $filterData = array(
            'ownership_flat_member_id' => $ownershipFlatMemberId,
            'flat_id' => $flatId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'is_active'=> 1,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->rentals_model->getAllRentalsMember($filterData);
    }

    public function view($id = null)
    {
        $rentalsId = $this->request->getVar("view_id");
        if($rentalsId == "" && $rentalsId == null){
            return redirect()->to('Admin/Rentals');
        }
        else {
            $id = $rentalsId;
            $filterData = array(
                "rentals_id" => $rentalsId
            );
            $rentalsData = $this->rentals_model->getRentalsData($filterData);

            $rentalsMemberData = $this->rentals_model->getRentalsMemberData(array(
                'type' => 'rentals',
                'type_id' => $rentalsId,
                'is_multiple' => 1
            ));
            $data['rentals_member_data'] = $rentalsMemberData;

            $rentalsEmergencyContactData = $this->rentals_model->getRentalsEmergencyData(array(
                'type' => 'rentals',
                'type_id' => $rentalsId,
                'is_multiple' => 1
            ));
            $rentalsParkingData = $this->rentals_model->getRentalsParkingData(array(
                'type' => 'rentals',
                'type_id' => $rentalsId,
                'is_multiple' => 1
            ));
            $documentData = $this->document_model->getDocumentData(array(
                'document_for' => 'rentals',
                'is_active' => 1,
                'is_multiple' => 1,
            ));
            if(!empty($documentData)){
                foreach ($documentData as $key => $displayData) {
                    $documentImageData = $this->staff_model->getDocumentImage(array(
                        "document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
                        'module_id' => $rentalsId,
                        'module' => 'rentals',
                        "is_multiple" => 1,
                    ));
                    $documentData[$key]['module_image_data'] = $documentImageData;
                }
            }
            $data['document_data'] = $documentData;
            $data['rentals_data'] = $rentalsData;
            $data['rentals_emergency_contact_data'] = $rentalsEmergencyContactData;
            $data['rentals_parking_data'] = $rentalsParkingData;
            $rentalsView = view("Admin/Rentals/RentalsModelView", $data);
            $response['view_title'] = "Rentals Details";
            $response['view_detail'] = $rentalsView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function getNextSeries()
    {
        $type = $this->request->getVar('type');
        $prefix = $this->request->getVar('prefix');
        $societyId = $this->request->getVar('society_id');

        $centralDB = \Config\Database::connect();

        $society = $centralDB->table('tbl_society')
            ->where('society_id', $societyId)
            ->get()
            ->getRowArray();

        // $getNextSeries = $this->rentals_model->getNextSeries($type, $prefix, $societyId);
        $getNextSeries = $this->rentals_model->getNextSeries($type, $prefix, $society['db_name']);
        $response['success'] = true;
        $response['data'] = $getNextSeries;
        echo json_encode($response);
        exit;
    }

    public function excelExportRentals()
    {
        $fileName ='rentals-' . DATETIMEFORMAT;
        $sheetName = 'Rentals-' . DATEFORMAT;
        $excelHeaderName = 'Rentals';
        $tableData = $this->getRentalsListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Rentals.rental_number'),
            lang('Rentals.flat_no'),
            lang('Rentals.owner_member'),
            //lang('Rentals.owner_contact_no'),
            lang('Rentals.broker'),
            lang('Rentals.broker_contact_no'),
            lang('Rentals.tenant_name'),
            lang('Rentals.tenant_contact_no'),
            lang('Rentals.tenant_email'),
            lang('Rentals.rent_agreement_period_from'),
            lang('Rentals.rent_agreement_period_to'),
            lang('Rentals.permanent_address'),
            lang('Rentals.work_address'),
            lang('Rentals.status_name'),
            lang('Rentals.closing_date'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["document_number"],
                $row["excel_flat_no"],
                $row["owner_member_name"],
               // $row["owner_contact_no"],
                $row["broker_name"],
                $row["broker_contact_no"],
                $row["tenant_name"],
                $row["tenant_contact_no"],
                $row["tenant_email"],
                $row["rent_agreement_period_from"],
                $row["rent_agreement_period_to"],
                $row["permanent_address"],
                $row["work_address"],
                $row["status_name"],
                $row["rental_closing_date"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'P';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function pdf($id = null, $view = null, $save_bufffer = null,$zipPdf = 0)
    {
        if(empty($id)){
            $response['success'] = false;
            $response['msg'] = lang('Rentals.rentals_data_required');
            echo json_encode($response);
            exit;
        }
        $filterData = array(
            "rentals_id" => $id,
            'is_multiple' => 1
        );
        $rentalsData = $this->rentals_model->getRentalsData($filterData);
        if(!empty($rentalsData)) {
            foreach ($rentalsData as $rkey => $rentals) {

                $rentalsMemberData = $this->rentals_model->getRentalsMemberData(array(
                    'type' => 'rentals',
                    'type_id' => $rentals['rentals_id'],
                    'is_multiple' => 1
                ));
                $data['rentals_member_data'] = $rentalsMemberData;

                $rentalsFlatOwnerData = $this->rentals_model->getRentalsFlatOwnerData(array(
                    'type' => 'rentals',
                    'type_id' => $rentals['rentals_id'],
                    'is_multiple' => 1
                ));
                $data['rentals_flat_owner_data'] = $rentalsFlatOwnerData;

                $rentalsEmergencyContactData = $this->rentals_model->getRentalsEmergencyData(array(
                    'type' => 'rentals',
                    'type_id' => $rentals['rentals_id'],
                    'is_multiple' => 1
                ));
                $rentalsParkingData = $this->rentals_model->getRentalsParkingData(array(
                    'type' => 'rentals',
                    'type_id' => $rentals['rentals_id'],
                    'is_multiple' => 1
                ));
                $data['rentals_emergency_contact_data'] = $rentalsEmergencyContactData;
                $data['rentals_parking_data'] = $rentalsParkingData;
                $societyData = $this->society_model->getSocietyData(array(
                    "society_id" => isset($societyData['society_id']) ? $societyData['society_id'] : "-1",
                ));
                $data['society_data'] = $societyData;
                $data['rentals_data'] = $rentals;
                $data['name'] = lang("Rentals.rentals_pdf") . "_" . str_replace('/', '_', $data['rentals_data']['flat_no']) . ".pdf";
                $printHeader = '';
                $printFooter = '';
                $signatureDetails = array(
                    "created_by" => isset($rentals['created_by']) ? $rentals['created_by'] : "",
                    "approved_by" =>  "",
                    "document_number" => isset($rentals['document_number'])  ? lang("Rentals.rentals")."# ".$rentals['document_number']  : "",
                    "document_date" => isset($rentals['created_at']) ? siteDateFormat($rentals['created_at']) : "",
                    "print_for" => "Rentals",
                );
                if (isset($rentals['rentals_id'])) {
                    $printFooter = pdfFooter( 1, $signatureDetails);
                }
                $html = view('Admin/Rentals/pdf/RentalsPdfView', $data);
                generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
            }
        }
    }


    public function getFlatOwnerTableRow()
    {
        $flatId = $this->request->getVar('flat_id');
        $flatOwnerData = $this->rentals_model->getFlatOwnerData(array(
            'flat_id' => $flatId,
            'is_owner' => 1,
            'is_latest' => 1,
            'is_multiple' => 1,
            'is_active' => 1,
        ));
        // printArray($flatOwnerData,1);
        $memberRowHtml = '';
        if (!empty($flatOwnerData)) {
            if (isset($flatOwnerData) && !empty($flatOwnerData)) {
                foreach ($flatOwnerData as $key => $ownerData) {
                    $data["row_number"] = $key + 1;
                    $data["rentals_flat_owner_data"] = $ownerData;
                    $memberRowHtml .= view('Admin/Rentals/RentalsFlatOwnerRowView', isset($data) ? $data : array());
                }
            }
            $response['success'] = true;
            $response['member_row_data'] = $memberRowHtml;
            echo json_encode($response);
            exit;
        } else {
            $memberRowHtml .= view('Admin/Rentals/RentalsFlatOwnerRowView', isset($data) ? $data : array());
            $response['success'] = false;
            $response['message'] = '';
            $response['member_row_data'] = $memberRowHtml;
            echo json_encode($response);
            exit;
        }
        $memberRow = view('Admin/Rentals/RentalsFlatOwnerRowView', isset($data) ? $data : array());
        echo $memberRow;
    }


    public function addRentalsAccessCardRow()
    {
        $data['access_card_row_number'] = $this->request->getVar("access_card_row_number");
        $accessCardRow = view('Admin/Rentals/RentalsAccessCardRowView', $data);
        echo $accessCardRow;
    }

    public function deleteRentalsAccessCardRow()
    {
        $this->db->transStart();
        $moduleAccessCardTokenId = $this->request->getVar('module_access_card_token_id');
        $rentalsId = $this->request->getVar('rentals_id');

        $rentalsParkingData = $this->ownership_flat_model->deleteModuleAccessCardTokenRecord($moduleAccessCardTokenId);

        if ($rentalsParkingData) {

            if(!empty($moduleAccessCardTokenId)){
                foreach($moduleAccessCardTokenId as $documentElement){
                    $deleteDataArray['module'] = 'Rentals Access Card';
                    $deleteDataArray['activity'] = "Rentals Access Card Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Rentals Access Card Deleted [RentalsAccessCardID: ' . $documentElement . ']',$this->data['userId'],'Rentals Access Card',$documentElement,json_encode($deleteDataArray),'','Rentals',$rentalsId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Rentals.rentals_access_card'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Rentals.rentals_access_card'));
            }            
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Rentals.rentals_access_card'));
        }
        echo json_encode($response);
        exit();
    }

}
