<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\VoucherModel;
use App\Models\CommonWebServiceModel;
use App\Models\ResourceTypeModel;
use App\Models\SocietyModel;

// use App\Models\VoucherModel;
class Receipt extends BaseController
{
    protected $voucher_model;
    public function __construct() {
        $this->voucher_model = new VoucherModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->voucher_model = new VoucherModel();
        $this->resource_type_model = new ResourceTypeModel();
        $this->society_model = new SocietyModel();
    }
    public function index()
    {
        // $moduleType = $this->request->getVar("type");
        $moduleType = "receipt";
        // printArray($type,1);
        if($moduleType == "receipt"){
            $title = "Receipts";
        } else {
            $title = "Receipt";
        }
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = $title;
        $dataFilters['filters'] = array(
            array(
                "type" => "month",
                "id" => "filter_month",
                "name" => "filter_month",
                "title" => "voucher.month",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['module_type'] = $moduleType;
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Voucher/VoucherView",$data);
    }
    public function manage($voucherId = '')
    {
        $moduleType = $this->request->getVar("type");
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/jquery-timepicker/jquery-timepicker.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
        );

        if ($voucherId != '') {
            $filterData = array(
                "voucher_id" => $voucherId
            );
            $data['voucher_data'] = $this->voucher_model->getVoucherData($filterData);

            $voucherTransactionData = $this->voucher_model->getVoucherTransactionData(array(
                "voucher_id" => $voucherId,
                'is_multiple' => 1
            ));
            $data['voucher_transaction_data'] = $voucherTransactionData;

            $voucherItemsData = $this->voucher_model->getVoucherItemsData(array(
                "voucher_id" => $voucherId,
                'is_multiple' => 1,
            ));

            $data['voucher_items_data'] = $voucherItemsData;

            if (empty($data['voucher_data'])) {
                return redirect()->to('Admin/Receipt?type='.$moduleType);
            }
        }
        if($moduleType == "receipt"){
            $title = "Receipts";
        } else {
            $title = "Cash Receipt";
        }
        $data['module_type'] = $moduleType;
        if ($voucherId != '') {
            $data['title'] = 'Edit '.$title;
        } else {
            $data['title'] = 'Add '.$title;
        }
        if ((isset($data['voucher_data']['society_id']) && $data['voucher_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Receipt');
        }

        $data['voucher_data']['view'] = (isset($view) && $view != '' ? 1 : 0);
        $data['voucher_transaction_table'] = view('Admin/Voucher/VoucherTransactionView', isset($data) ? $data : array());
        $data['voucher_item_table'] = view('Admin/Voucher/VoucherItemView', isset($data) ? $data : array());
        // $data['payment_modal_view'] = view('Admin/Voucher/VoucherUnitPaymentModalView', isset($data) ? $data : array());
        // $data['voucher_booking_slot_table'] = view('Admin/Voucher/VoucherBookingSlotView', isset($data) ? $data : array());
        
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        // printArray($data,1);
        $this->dt_ci_template->load("Admin","Voucher/VoucherManageView",$data);
    }

    public function getVoucherListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        // printArray($filterData,1);
        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $moduleType = $this->request->getVar("module_type");
        $societyId = $this->session->get('society_id');

        $this->datatables->table("tbl_voucher as ta");
        $this->datatables->select("ta.voucher_id,ta.voucher_type,ta.transaction_mode,ta.date,ta.reference_no,ta.society_id");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ta.updated_by AND tupdate.society_id = ta.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = ta.society_id","left");
        if($moduleType == 'receipt'){
            $this->datatables->whereIn("voucher_type",['bank_receipt','cash_receipt']);
        } else {
            $this->datatables->whereIn("voucher_type",['bank_payment','cash_payment']);
        }
        
        accessFilter($this->datatables, array("society" => "ta.society_id"));
        
        if(isset($societyId) && !empty($societyId)) {
            if (is_array($societyId)) {
                $this->datatables->whereIn('ta.society_id', $societyId);
            } else {
                $this->datatables->where('ta.society_id', $societyId);
            }
        }

        $this->datatables->groupBy("ta.voucher_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        $transactionMode = transactionMode();
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "voucher_id" => isset($displayData['voucher_id']) ? $displayData['voucher_id'] : "",
                    "module_type" => $moduleType,
                );
                $data[$key]['action_button'] = voucherActionButton($actionButtonFilter);
                $data[$key]['date'] = (isset($displayData['date']) && isValidDate($displayData['date'])) ? siteDateFormat($displayData['date']) : "";
                $data[$key]['voucher_type'] = (isset($displayData['voucher_type'])) ? underscoreToUcWord($displayData['voucher_type']) : "";
                $data[$key]['transaction_mode'] = (isset($displayData['transaction_mode'])) ? $transactionMode[$displayData['transaction_mode']] : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        // printArray($_POST,1);
        // $this->db->transStart();
        $validation = \Config\Services::validation();

        $voucherId = $this->request->getVar('voucher_id');
        $voucherType = $this->request->getVar('voucher_type');
        $transactionMode = $this->request->getVar('transaction_mode');
        $date = $this->request->getVar('date');
        $referenceNo = $this->request->getVar('reference_no');
        $narration = $this->request->getVar('narration');
        
        // transaction table
        $voucherTransactionIdArr = $this->request->getVar('voucher_transaction_id');
        $transactionDateArr = $this->request->getVar('transaction_date');
        $transactionRefNoArr = $this->request->getVar('ref_no');
        $bankArr = $this->request->getVar('bank');
        $branchArr = $this->request->getVar('branch');
        $cityArr = $this->request->getVar('city');
        $transactionAmountArr = $this->request->getVar('transaction_amount');
        $remarksArr = $this->request->getVar('remarks');

        // item table
        $voucherItemIdArr = $this->request->getVar('voucher_items_id');
        $itemArr = $this->request->getVar('item');
        $amountArr = $this->request->getVar('amount');

        $validation->setRule('voucher_type', lang('Receipt.voucher_type'), 'required');
        $validation->setRule('transaction_mode', lang('Receipt.transaction_mode'), 'required');
        $validation->setRule('date', lang('Receipt.date'), 'required');
        $validation->setRule('reference_no', lang('Receipt.reference_no'), 'required');
        $validation->setRule('narration', lang('Receipt.narration'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $voucherUpdateArray = array();
            $voucherArray = array(
                'voucher_id' => $voucherId,
                'voucher_type' => $voucherType,
                'transaction_mode' => $transactionMode,
                'date' => DMYToYMD($date),
                'reference_no' => $referenceNo,
                'narration' => $narration,
                'society_id' => $this->session->get('society_id'),
            );
            // printArray($voucherArray,1);

            if(!empty($voucherId)){
                $voucherUpdateData = $this->voucher_model->getVoucherData(array(
                    'voucher_id' => $voucherId,
                ));
                $voucherUpdateArray = compareArray($voucherArray,$voucherUpdateData);
            }

            $voucherData = $this->voucher_model->insertUpdateRecord($voucherArray,'voucher_id','tbl_voucher', 1);
            $lastVoucherId = $voucherData['lastInsertedId'];

            // printArray($voucherData,1);

            if (!empty($voucherTransactionIdArr)) {
                foreach ($voucherTransactionIdArr as $fkey => $voucherTransactionId) {
                    $transactionDate = array_key_exists($fkey, $transactionDateArr) ? $transactionDateArr[$fkey] : '';
                    $transactionRefNo = array_key_exists($fkey, $transactionRefNoArr) ? $transactionRefNoArr[$fkey] : '';
                    $bank = array_key_exists($fkey, $bankArr) ? $bankArr[$fkey] : '';
                    $branch = array_key_exists($fkey, $branchArr) ? $branchArr[$fkey] : '';
                    $city = array_key_exists($fkey, $cityArr) ? $cityArr[$fkey] : '';
                    $transactionAmount = array_key_exists($fkey, $transactionAmountArr) ? $transactionAmountArr[$fkey] : '';
                    $remarks = array_key_exists($fkey, $remarksArr) ? $remarksArr[$fkey] : '';

                        $transactionInsertUpdateArray = array(
                            'voucher_transaction_id' => $voucherTransactionId,
                            'voucher_id' => $lastVoucherId,
                            'transaction_date' => DMYToYMD($transactionDate),
                            'transaction_ref_no' => $transactionRefNo,
                            'bank' => $bank,
                            'branch' => $branch,
                            'city' => $city,
                            'transaction_amount' => $transactionAmount,
                            'remarks' => $remarks,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );

                        $voucherTransactionInsertUpdateData = $this->voucher_model->insertUpdateRecord($transactionInsertUpdateArray, 'voucher_transaction_id', 'tbl_voucher_transaction', 1,'',array(),array());
                        $lastVoucherTransactionId = $voucherTransactionInsertUpdateData['lastInsertedId'];
                }
            }

                if (!empty($voucherItemIdArr)) {
                    foreach ($voucherItemIdArr as $fkey => $voucherItemId) {
                        $item = array_key_exists($fkey, $itemArr) ? $itemArr[$fkey] : '';
                        $amount = array_key_exists($fkey, $amountArr) ? $amountArr[$fkey] : '';

                            $itemInsertUpdateArray = array(
                                'voucher_items_id' => $voucherItemId,
                                'voucher_id' => $lastVoucherId,
                                'item' => $item,
                                'amount' => $amount,
                                'created_by' => $this->data['userId'],
                                'updated_by' => $this->data['userId'],
                                'created_at' => date("Y-m-d H:i:s"),
                                'updated_at' => date("Y-m-d H:i:s"),
                            );

                            $voucherTransactionInsertUpdateData = $this->voucher_model->insertUpdateRecord($itemInsertUpdateArray, 'voucher_items_id', 'tbl_voucher_items', 1,'',array(),array());
                            $lastVoucherTransactionId = $voucherTransactionInsertUpdateData['lastInsertedId'];
                    }
                // $itemExtraDataArray = array();
                // $itemExtraDataArray['module_id'] = $lastVoucherId;
                // $itemExtraDataArray['module'] = 'Receipt Unit';
                // $itemExtraDataArray['type'] = 'Receipt';
                // $itemExtraDataArray['old_data'] = $oldVoucherUnitData;
                // $itemExtraDataArray['user_id'] = $this->data['userId'];
                // $itemExtraDataArray['society_id'] = $this->session->get('society_id');

                // if (!empty($itemInsertArray)) {
                //     $this->voucher_model->batchInsert($itemInsertArray, 'tbl_voucher_unit',$itemExtraDataArray);
                // }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($voucherId) && $voucherId != '') {
                if (($voucherData['success']) ) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Receipt.voucher'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Receipt.voucher'));
                }
            } else {
                if (($voucherData['success']) ) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Receipt.voucher'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Receipt.voucher'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $voucherId = $this->request->getVar('voucher_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->voucher_model->statusChange($voucherId,$status,'voucher_id','tbl_voucher');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Receipt.voucher'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Receipt.voucher'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $voucherId = $this->request->getVar('voucher_id');
        $ids = is_array($voucherId) ? implode(',', $voucherId) : $voucherId;
        // // if( isReferenceInTable( 'voucher_id','tbl_booking', $voucherId) ||
        // // isReferenceInTable( 'voucher_id','tbl_amc_detail', $voucherId) ||
        // // isReferenceInTable( 'voucher_id','tbl_module_access_card_token', $voucherId) 
        // // ){

        // //     if(!empty($voucherId)){
        // //         foreach($voucherId as $voucher){
        // //             $deleteDataArray['module'] = 'Receipt';
        // //             $deleteDataArray['activity'] = "Tried to delete Receipt ";
        // //             $deleteDataArray['module_id'] = $voucher;
        // //             logActivity('Tried to delete Receipt [VoucherID: ' . $voucher . ']',$this->data['userId'],'Receipt',$voucher,json_encode($deleteDataArray),'','Receipt',$voucher);
        // //         }
        // //     }

        // //     $response['success'] = false;
        // //     $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
        // //     echo json_encode($response);
        // //     exit;
        // // }
        // $this->voucher_model->deleteVoucherUnit($voucherId);
        // $this->voucher_model->deleteVoucherBookingSlotUnitPrice($voucherId,$this->data['userId']);
        // $this->voucher_model->deleteVoucherBookingSlotDay($voucherId);
        // $this->voucher_model->deleteCommonAreaRecord($voucherId);
        // $this->voucher_model->deleteVoucherBookingSlot($voucherId,$this->data['userId']);

        $voucherData = $this->voucher_model->deleteRecord($voucherId);
        $transactionStatus = $this->db->transComplete();
        if (($voucherData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Receipt.voucher'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Receipt.voucher'));
        }
        echo json_encode($response);
        exit;
    }

    public function addVoucherTransactionRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $transactionRow = view('Admin/Receipt/VoucherTransactionRowView', $data);
        echo $transactionRow;
    }

    public function deleteVoucherUnitRow()
    {
        $this->db->transStart();

        $voucherUnitId  = $this->request->getVar('voucher_unit_id');
        $voucherId = $this->request->getVar('voucher_id');

        $voucherUnitData = $this->voucher_model->deleteVoucherUnitRecord($voucherUnitId);
        
        if (($voucherUnitData)) {
            if(!empty($voucherUnitId)){
                foreach($voucherUnitId as $documentElement){
                    $deleteDataArray['module'] = 'Receipt Unit';
                    $deleteDataArray['activity'] = "Receipt Unit Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Receipt Unit Deleted [VoucherUnitID: ' . $documentElement . ']',$this->data['userId'],'Receipt Unit',$documentElement,json_encode($deleteDataArray),'','Receipt',$voucherId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Receipt.voucher_unit'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Receipt.voucher_unit'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Receipt.voucher_unit'));
        }
        echo json_encode($response);
        exit();
    }

    public function addVoucherItemRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $itemRow = view('Admin/Receipt/VoucherItemRowView', $data);
        echo $itemRow;
    }

    public function deleteVoucherBookingSlotRow()
    {
        $this->db->transStart();

        $voucherBookingSlotId  = $this->request->getVar('voucher_booking_slot_id');
        $voucherId = $this->request->getVar('voucher_id');
        $voucherBookingSlotData = $this->voucher_model->deleteVoucherBookingSlotRecord($voucherBookingSlotId,$this->data['userId']);
        $this->voucher_model->deleteVoucherBookingSlotDayRecord($voucherBookingSlotId);
        $this->voucher_model->deleteVoucherBookingSlotUnitPriceRecord($voucherBookingSlotId,$this->data['userId']);
        
        if (($voucherBookingSlotData)) {
            if(!empty($voucherBookingSlotId)){
                foreach($voucherBookingSlotId as $documentElement){
                    $deleteDataArray['module'] = 'Receipt Booking Slot';
                    $deleteDataArray['activity'] = "Receipt Booking Slot Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Receipt Booking Slot Deleted [VoucherBookingSlotID: ' . $documentElement . ']',$this->data['userId'],'Receipt Booking Slot',$documentElement,json_encode($deleteDataArray),'','Receipt',$voucherId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Receipt.voucher_booking_slot'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Receipt.voucher_booking_slot')); 
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Receipt.voucher_booking_slot'));
        }
        echo json_encode($response);
        exit();
    }

    public function getUnitPaymentData()
	{
		$data['row_number'] = $this->request->getVar("row_number");
		$data['voucher_booking_slot_id'] = $this->request->getVar("voucher_booking_slot_id");
		$unitNameArray = $this->request->getVar("unit_name");
		$priceJson = $this->request->getVar("unit_price_json");
		$priceJsonArray = json_decode($priceJson,true);
		$data['current_unit_price_json'] =$this->request->getVar("unit_price_json");
		$data['unit_price_data'] = $priceJsonArray;
		$itemRow = view('Admin/Receipt/VoucherUnitPaymentModalView', isset($data) ? $data : array());
		$response['success'] = true;
		$response['item_row_data'] = $itemRow;
		echo json_encode($response);
		exit;
	}
    
    public function getVoucherDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $voucherId = $this->request->getVar('voucher_id');
        // $type = $this->request->getVar('type');

        // echo($type);
        // die();

        $filterData = array(
            'voucher_id' => $voucherId,
            'filter_param' => $filterParameter,
            // 'type' => $type,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->voucher_model->getVoucher($filterData);
    }

    public function getVoucherUnitDd(){

        // printArray($_POST,1);
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $voucherId = $this->request->getVar('voucher_id');
        // $type = $this->request->getVar('type');

        // echo($type);
        // die();

        $filterData = array(
            'voucher_id' => $voucherId,
            'filter_param' => $filterParameter,
            // 'type' => $type,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->voucher_model->getVoucherUnit($filterData);
    }

    public function excelExportVoucher()
    {
        $fileName ='voucher-' . DATETIMEFORMAT;
        $sheetName = 'Receipt-' . DATEFORMAT;
        $excelHeaderName = 'Receipt';
        $tableData = $this->getVoucherListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Receipt.society'),
            // lang('Receipt.type'),
            lang('Receipt.voucher'),
            lang('Receipt.total_quantity'),
            lang('Receipt.common_area'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                // $row["type"],
                $row["voucher_name"],
                $row["total_quantity"],
                $row["common_area_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }


    public function view($id = null)
    {
        $voucherId = $this->request->getVar("view_id");
        if($voucherId == "" && $voucherId == null){
            return redirect()->to('Admin/Receipt');
        }
        else {
            $id = $voucherId;
            $filterData = array(
                "voucher_id" => $voucherId
            );
            $data['voucher_data'] = $this->voucher_model->getVoucherData($filterData);
            $voucherUnitData = $this->voucher_model->getVoucherUnitData(array(
                "voucher_id" => $voucherId,
                'is_multiple' => 1
            ));
            $data['voucher_unit_data'] = $voucherUnitData;

            $voucherBookingSlotData = $this->voucher_model->getVoucherBookingSlotData(array(
                "voucher_id" => $voucherId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            ));

            $voucherBookingSlotDayData =  $this->voucher_model->getVoucherBookingSlotDayData(array(
                "voucher_id" => $voucherId,
                'is_multiple' => 1,
            ));
            $absdDataBookingSlotIdWise = array();
            if(!empty($voucherBookingSlotDayData)){
                foreach ($voucherBookingSlotDayData as $resourceFlatWorkingDayElement){
                    $absdDataBookingSlotIdWise[$resourceFlatWorkingDayElement['voucher_booking_slot_id']][] = $resourceFlatWorkingDayElement;
                }
            }
            
            if(!empty($voucherBookingSlotData)){
                foreach ($voucherBookingSlotData as $rfKey => $resourceFlatElement){
                    //$voucherBookingSlotData[$rfKey]['unit_payment_json'] = json_encode($unitPaymentArray,true);
                    $voucherBookingSlotData[$rfKey]['day_data'] = !empty($absdDataBookingSlotIdWise) && array_key_exists($resourceFlatElement['voucher_booking_slot_id'],$absdDataBookingSlotIdWise) ? $absdDataBookingSlotIdWise[$resourceFlatElement['voucher_booking_slot_id']]: array();
                }
            }
            $data['voucher_booking_slot_data'] = $voucherBookingSlotData;

            $data['Receipt'] = $voucherUnitData;
            
            // Iterate through each voucher booking slot
            foreach ($data['voucher_booking_slot_data'] as $key => $slot) {
                if (!empty($slot['unit_price_json'])) {
                    // Decode JSON if it exists
                    $unitPriceArray = json_decode($slot['unit_price_json'], true);
                    $data['voucher_booking_slot_data'][$key]['unit_price_data'] = $unitPriceArray;
                } else {
                    // If unit_price_json is empty, set an empty array for unit_price_data
                    $data['voucher_booking_slot_data'][$key]['unit_price_data'] = [];
                }
                
                // Optionally remove the original unit_price_json if not needed
                unset($data['voucher_booking_slot_data'][$key]['unit_price_json']);
            }

            $data['common_area_data'] = $this->voucher_model->getVoucherCommonAreaData(array(
                'voucher_id' => $voucherId,
                'is_multiple' => 1
            ));

            if (empty($data['voucher_data'])) {
                return redirect()->to('Admin/Receipt');
            }
            
            // printArray($data,1);
            $voucherView = view("Admin/Receipt/VoucherModelView", $data);
            $response['view_title'] = "Receipt Details";
            $response['view_detail'] = $voucherView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function pdf($id = null, $view = null,$save_bufffer = null,$zipPdf = 0)
    {
        $moduleType = $this->request->getVar("type");
        if($moduleType == "receipt"){
                    $lang = "Receipt";
                } else {
                    $lang = "Receipt";
                }
        if(empty($id)){
            $response['success'] = false;
            $response['msg'] = lang('Receipt.voucher_data_required');
            echo json_encode($response);
            exit;
        }
        $filterData = array(
            "voucher_id" => $id,
            'is_multiple' => 1
        );
        $voucherData = $this->voucher_model->getVoucherData($filterData);

        if(!empty($voucherData)) {
            foreach ($voucherData as $ofkey => $voucher) {

                $voucherId = $voucher['voucher_id'];
                // if( ($voucher['is_latest'] == 1 && $voucher['type'] == TRANSFERRED) ){
                //     $langAilas = 'TransferredFlat.';
                // } else {
                //     $langAilas = 'Receipt.';
                // }

                $voucherTransactionData = $this->voucher_model->getVoucherTransactionData(array(
                    "voucher_id" => $voucherId,
                    'is_multiple' => 1
                ));
                $data['voucher_transaction_data'] = $voucherTransactionData;

                $voucherItemsData = $this->voucher_model->getVoucherItemsData(array(
                    "voucher_id" => $voucherId,
                    'is_multiple' => 1,
                ));

                // printArray($voucherItemsData,1);

                $data['voucher_items_data'] = $voucherItemsData;

                $societyData = $this->society_model->getSocietyData(array(
                    "society_id" => isset($voucher['society_id']) ? $voucher['society_id'] : "-1",
                ));
                $data['society_data'] = $societyData;

                $data['voucher_data'] = $voucher;
                // printArray($data['voucher_data'],1);
                $data['name'] = lang($lang.".voucher_pdf_name"). ".pdf";

                $printHeader = '';
                $printFooter = '';

                $signatureDetails = array(
                    "created_by" => isset($voucher['created_by']) ? $voucher['created_by'] : "",
                    "approved_by" =>  "",
                    "document_number" => isset($voucher['flat_no'])  ? lang("Receipt.voucher")."# ".$voucher['flat_no']  : "",
                    "document_date" => isset($voucher['created_at']) ? siteDateFormat($voucher['created_at']) : "",
                    "print_for" => "Receipt",
                );
                if (isset($voucher['voucher_id'])) {
                    $printFooter = pdfFooter( 1, $signatureDetails);
                }
                // $data['lang_name']= $langAilas;
                if($voucher['voucher_type'] == 'bank_payment' || $voucher['voucher_type'] == 'cash_payment'){
                    $html = view('Admin/Receipt/pdf/VoucherPdfView', $data);
                } else if ($voucher['voucher_type'] == 'cash_receipt' || $voucher['voucher_type'] == 'bank_receipt'){
                    $html = view('Admin/Receipt/pdf/VoucherReceiptPdfView', $data);
                } else {

                }
                // echo($html);
                // die();
                generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');

            }
        }
    }
    public function pdfExportCashBook()
    {
        $month = $this->request->getGet('filter_month');
        // printArray(array: $month,1);
        $filterData = array(
            "voucher_month" => $month,
            'is_multiple' => 1
        );
        $voucherItemsData = $this->voucher_model->getVoucherItemsData($filterData);
        // printArray($voucherItemsData,1);

        $data = array();
        // if(!empty($voucherItemsData)) {
            $data['voucher_items_data'] = $voucherItemsData;
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            $data['society_data'] = $societyData;
            $data['month'] = $month;
            $data['name'] = lang("Receipt.cash_book") . "_" .$month.".pdf";
            $printHeader = '';
            $printFooter = '';
            // $signatureDetails = array(
            //     "created_by" => isset($voucher['created_by']) ? $voucher['created_by'] : "",
            //     "approved_by" =>  "",
            //     "document_number" => isset($voucher['flat_no'])  ? lang("Receipt.voucher")."# ".$voucher['flat_no']  : "",
            //     "document_date" => isset($voucher['created_at']) ? siteDateFormat($voucher['created_at']) : "",
            //     "print_for" => "Receipt",
            // );
            // if (isset($voucher['voucher_id'])) {
            //     $printFooter = pdfFooter( 1, $signatureDetails);
            // }
        // }
        $html = view('Admin/Receipt/pdf/CashBookPdfView', $data);
        // echo($html);
        // die();
        generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
    }



}
