<?php
namespace App\Controllers\Admin;
use App\Models\PollVotesModel;
use App\Models\PollModel;
use CodeIgniter\Controller;
class PollVotesDetail extends BaseController
{
    protected $poll_votes_model;
    protected $poll_model;
    public function __construct() {
        $this->poll_model = new PollModel;
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Poll Votes Detail';
        $pollId = $this->request->getVar("poll_id");
        $pollOptionId = $this->request->getVar("poll_option_id");
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => false,
                "tbl_name" => "tbl_poll",
                "columns" => array("poll_id","poll_title"),
                "selected" => $pollId,
                "id" => "filter_poll_id",
                "name" => "filter_poll_id",
                "title" => "PollVotes.poll_title",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => false,
                "tbl_name" => "tbl_poll_option",
                "columns" => array("poll_option_id","poll_option"),
                "selected" => $pollOptionId,
                "id" => "filter_poll_option_id",
                "name" => "filter_poll_option_id",
                "title" => "PollVotes.poll_option",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","PollVotes/PollVotesDetailView",$data);
    }

    public function getPollVotesDetailListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $pollId = $this->request->getVar("filter_poll_id");
        $pollOptionId = $this->request->getVar("filter_poll_option_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $this->datatables->table("tbl_poll_option as tpo");
        $this->datatables->select("tp.poll_title,tpo.poll_option,tpo.poll_option_id");
        $this->datatables->select("(SELECT count(*) FROM tbl_poll_votes as tpv WHERE tpv.poll_option_id = tpo.poll_option_id AND tpv.poll_id = tpo.poll_id) as vote_count");
        $this->datatables->select("GROUP_CONCAT(distinct(tm.name) SEPARATOR ',') as member_name");
        $this->datatables->join("tbl_poll as tp","tp.poll_id = tpo.poll_id","left");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tpo.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tpo.created_at"); 
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tpo.updated_by AND tupdate.society_id = tp.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tpo.created_by AND tcreate.society_id = tp.society_id","left");       
        $this->datatables->join("tbl_poll_votes as tpv","tpv.poll_option_id = tpo.poll_option_id","left");        
        $this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tpv.ownership_flat_member_id","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $this->datatables->groupBy(array("tpo.poll_option_id","tpv.poll_votes_id"));
        if(isset($pollId)) {
            if(is_array($pollId)){
                $this->datatables->whereIn("tpo.poll_id",$pollId);
            } else {
                $this->datatables->where("tpo.poll_id",$pollId);
            }
        }
        if(isset($pollOptionId)) {
            if(is_array($pollOptionId)){
                $this->datatables->whereIn("tpo.poll_option_id",$pollOptionId);
            } else {
                $this->datatables->where("tpo.poll_option_id",$pollOptionId);
            }
        }
        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tpo.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tpo.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tpo.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tV.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tV.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tV.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        accessFilter($this->datatables, array("society" => "tp.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function getOptionData(){
        $pollId = $this->request->getVar('poll_id');
        $responseType = $this->request->getVar('response_type');
        $data['child_row'] = 1;
        $activityHtml = $this->poll_model->getPollOptionData(array(
            'poll_id' => $pollId,
            'is_multiple' => 1
        ));
        $response['option_data'] = $activityHtml;
        $response['title'] = "Order History";
        $response['success'] = true;
        if($responseType == 'json') {
            echo json_encode($response);
        } else {
            echo json_encode($response);
        }
    }
}
