<?php
namespace App\Controllers\Admin;

use App\Models\PollVotesModel;
use App\Models\PollModel;
use CodeIgniter\Controller;
class PollVotes extends BaseController
{
    protected $poll_votes_model;
    protected $poll_model;
    public function __construct() {
        $this->poll_model = new PollModel;
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Poll Votes';
        return $this->dt_ci_template->load("Admin","PollVotes/PollVotesView",$data);
    }

    public function getPollVotesListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_poll as tp");
        $this->datatables->select("tp.poll_id,tp.poll_title,tp.created_at,tp.updated_at");
        $this->datatables->select("(SELECT count(*) FROM tbl_poll_votes as tpv WHERE tpv.poll_id = tp.poll_id) as vote_count");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tp.updated_by AND tupdate.society_id = tp.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tp.created_by AND tcreate.society_id = tp.society_id","left");
        $this->datatables->groupBy("tp.poll_id");
        accessFilter($this->datatables, array("society" => "tp.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";

                $actionButtonFilter = array(
                    "poll_id" => isset($displayData['poll_id']) ? $displayData['poll_id'] : "",
                );
                $data[$key]['action_button'] = pollVotesActionButton($actionButtonFilter);
            }
        }

        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    // public function excelExportPollVotes()
    // {
    //     $fileName ='sos-' . DATETIMEFORMAT;
    //     $sheetName = 'PollVotes-' . DATEFORMAT;
    //     $excelHeaderName = 'PollVotes';
    //     $tableData = $this->getPollVotesListing(true, $_GET);
    //     $dataRows = array();
    //     $dataRows[] = array(
    //         // lang('PollVotes.society'),
    //         lang('PollVotes.poll_votes_name'),
    //         lang('CommonMessage.common_updated_by'),
    //         lang('CommonMessage.common_updated_at')
    //     );
    //     foreach ($tableData as $row) {
    //         $dataRows[] = array(
    //             // $row["society_name"],
    //             $row["poll_votes_name"],
    //             $row["excel_tower_name"],
    //             $row["updated_by"],
    //             $row["updated_at"]
    //         );
    //     }
    //     $subTotalCellValueArray = [];
    //     $toColumn = 'D';
    //     $excelFilterData = array(
    //         'file_name' => $fileName,
    //         'sheet_name' => $sheetName,
    //         'excel_header_name' => $excelHeaderName,
    //         'data_row' => $dataRows,
    //         'sub_total_cell_value_array' => $subTotalCellValueArray,
    //         'to_column' => $toColumn,
    //         'skip_header' => false,
    //         'ignore_currency_symbols_sub_total_cell_value_array' => array(),
    //         'row_cell_currency_format' => array()
    //     );
    //     excelExport($excelFilterData);
    // }

    public function getOptionData(){
        $pollId = $this->request->getVar('poll_id');
        $responseType = $this->request->getVar('response_type');
        $data['child_row'] = 1;
        $activityHtml = $this->poll_model->getPollOptionData(array(
            'poll_id' => $pollId,
            'is_multiple' => 1
        ));

        
        // printArray($activityHtml,1);
        $response['option_data'] = $activityHtml;
        $response['title'] = "Order History";
        $response['success'] = true;
        if($responseType == 'json') {
            echo json_encode($response);
        } else {
            echo json_encode($response);
        }
    }

}
