<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ParkingSlotModel;
use App\Models\ParkingAreaModel;
use App\Models\OwnershipFlatModel;
class ParkingSlot extends BaseController
{
    protected $parking_slot_model;
    protected $parking_area_model;
    protected $ownership_flat_model;
    public function __construct() {
        $this->parking_area_model = new ParkingAreaModel();
        $this->parking_slot_model = new ParkingSlotModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            //"js/vendor/tables/datatables/datatables.min.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Parking Slot';
        $data['v_parking_slot_modal'] = view('Admin/ParkingSlot/ParkingSlotModalView', $data);
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", array());
        return $this->dt_ci_template->load("Admin","ParkingSlot/ParkingSlotView",$data);
    }

    public function getParkingSlotListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $tabModule = $this->request->getVar('tab_module');
        $this->datatables->table("tbl_parking_slot as tps");
        $this->datatables->select("tps.parking_slot_id,tps.flat_id,tps.parking_area_id,tps.number,COALESCE(tpv.vehicle_type,'') as vehicle_type, tps.is_active,tps.society_id,ts.society_name,tps.is_visitor_parking,concat(COALESCE(ta.parking_area_name,''),'-',ConvertToTitleCase(tpv.vehicle_type)) as parking_area_vehicle_type_name,tm.name,tps.parking_vehicle_id,tofp.vehicle_no,tps.ownership_flat_parking_id");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tps.updated_at");
        $this->datatables->select("if(tps.is_visitor_parking = 1,'Yes','No') as is_visitor_parking_display");
        $this->datatables->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $this->datatables->select("concat(COALESCE(ta.parking_area_name,''),'-',ConvertToTitleCase(tpv.vehicle_type)) as parking_area_name");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tps.flat_id","left");
        $this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tps.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tps.updated_by AND tupdate.society_id = tps.society_id","left");
        $this->datatables->join("tbl_parking_area as ta","ta.parking_area_id = tps.parking_area_id","left");
        $this->datatables->join("tbl_parking_vehicle as tpv","tps.parking_vehicle_id = tpv.parking_vehicle_id","left");
        $this->datatables->join("tbl_ownership_flat_parking as tofp","tofp.parking_slot_id = tps.parking_slot_id AND tofp.is_delete = 0","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm", "tofm.ownership_flat_id = tofp.ownership_flat_id AND tofp.type = tofm.type ",  "left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $this->datatables->groupBy("tps.parking_slot_id");

        if(isset($tabModule) && $tabModule != ''){
            if ($tabModule == 'free_parking') {
                $this->datatables->where("tps.parking_slot_id NOT IN (SELECT tv.parking_slot_id FROM tbl_visitor as tv WHERE tv.status = 'entered' AND tv.is_deleted = 0 AND tv.society_id = tps.society_id)", null, false);
                $this->datatables->where("tps.parking_slot_id NOT IN (SELECT tofp.parking_slot_id FROM tbl_ownership_flat_parking as tofp WHERE tofp.is_delete = 0)", null, false);
                $this->datatables->where("tps.parking_slot_id NOT IN (SELECT tv.parking_slot_id FROM tbl_visitor as tv WHERE (tv.status = 'entry_pre_approve' OR tv.status = 'approval_pending' OR tv.status = 'waiting_for_approval') AND tv.is_deleted = 0 AND tv.society_id = tps.society_id)", null, false);
            }
            if($tabModule == 'allocated_parking'){
                 $this->datatables->groupStart();
                $this->datatables->where('tps.parking_slot_id  IN(SELECT tv.parking_slot_id FROM tbl_visitor as tv where (tv.status ="entered") AND (tv.is_deleted = 0) AND tv.society_id = tps.society_id)',null,false);
                $this->datatables->orWhere('tps.parking_slot_id  IN(SELECT tofp.parking_slot_id FROM tbl_ownership_flat_parking as tofp where (tofp.is_delete = 0))',null,false);
                $this->datatables->orWhere('tps.parking_slot_id  IN(SELECT tv.parking_slot_id FROM tbl_visitor as tv where (tv.status ="entry_pre_approve" OR tv.status ="approval_pending" OR tv.status = "waiting_for_approval") AND (tv.is_deleted = 0) AND tv.society_id = tps.society_id)',null,false);
                $this->datatables->groupEnd();
            }
        }
        accessFilter($this->datatables, array("society" => "tps.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "parking_slot_id" => isset($displayData['parking_slot_id']) ? $displayData['parking_slot_id'] : "",
                );
                $data[$key]['action_button'] = parkingSlotActionButton($actionButtonFilter);
                $data[$key]['excel_flat_no'] = isset($displayData['flat_no']) ?  $displayData['flat_no'] : "";
                $data[$key]['display_flat_no'] = isset($displayData['flat_no']) ?  flatDocumentToHtml($displayData['flat_no'],$displayData['flat_id']) : "";
                $data[$key]['display_vehicle_type'] = isset($displayData['vehicle_type']) ?  underscoreToUcWord($displayData['vehicle_type']) : "";
                // $data[$key]['is_visitor_parking_display'] = (isset($displayData['is_visitor_parking']) && $displayData['is_visitor_parking'] != 0) ?  "Yes" : "No";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $parkingAreaId = $this->request->getVar('parking_area_id');
        $parkingVehicleId = $this->request->getVar('parking_vehicle_id');
        $number = $this->request->getVar('number');
        $flatId = $this->request->getVar('flat_id');
        $vehicleType = $this->request->getVar('vehicle_type');
        $isActive = $this->request->getVar('is_active');
        $isVisitorParking = $this->request->getVar('is_visitor_parking');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');

        $parkingAreaData =  $this->parking_area_model->getParkingAreaData(array('parking_area_id' => $parkingAreaId));

        $filterData = array(
            "flat_id" => $flatId,
            "parking_area_id" => $parkingAreaId,
            "number" => $number,
            "vehicle_type" => $vehicleType,
            "society_id" => $this->session->get('society_id'),
            'parking_slot_id_not' => $parkingSlotId,
            "is_multiple" => 1
        );
        $parkingSlotData = $this->parking_slot_model->getParkingSlotData($filterData);
        if(!empty($parkingSlotData)){
            $response['success'] = false;
            //$response['msg'] = "Can/t Select Same Area For Same Flat";
            $response['msg'] = "Can't Enter Same Parking number for Same Parking Area And Same Flat";
            echo json_encode($response);
            die();
        }
        $parkingAreaSlot = 0;
        $parkingAreaSlot = isset($parkingAreaData['slot']) ? $parkingAreaData['slot'] : 0;

//        $totalAreaWiseSlotData = $this->parking_slot_model->getTotalAreaParkingData(array(
//            "area_id" => $areaId,
//            "society_id" => $this->session->get('society_id'),
//            'parking_slot_id_not' => $parkingSlotId,
//        ));
//        $areaWiseAssignSlot =  isset($totalAreaWiseSlotData['total_assign_slot']) ? $totalAreaWiseSlotData['total_assign_slot'] : 0;
//
//        if($areaSlot < $areaWiseAssignSlot){
//            $response['success'] = false;
//            $response['msg'] = "Area Already Assign " . $areaSlot ." Slot For Other Flat";
//            echo json_encode($response);
//            die();
//        }
        $validation->setRule('parking_area_id', lang('ParkingSlot.parking_area'), 'required');
        $validation->setRule('number', lang('ParkingSlot.number'), 'required');
        // if(!isset($isVisitorParking)){
        //     $validation->setRule('flat_id', lang('ParkingSlot.flat_no'), 'required');
        // }

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            if(!empty($parkingSlotId)){
                $filterData = array(
                    'parking_slot_id' => $parkingSlotId,
                );
                $parkingSlotDataArray = $this->parking_slot_model->getParkingSlotData($filterData);
                if($parkingSlotDataArray['flat_id'] != $flatId){
                    $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                        'parking_slot_id' => $parkingSlotId,
                    ));
                    if(!empty($ownershipFlatParkingData)){
                        $response['success'] = false;
                        $response['msg'] = "This Parking is already assign to " . underscoreToUcWord($ownershipFlatParkingData['type']) . ' ' . $ownershipFlatParkingData['flat_no'];
                        echo json_encode($response);
                        die();
                    }
                }
            }

            $parkingSlotUpdateArray = array();
            $parkingSlotArray = array(
                'parking_slot_id' => $parkingSlotId,
                'parking_area_id' => $parkingAreaId,
                'parking_vehicle_id' => $parkingVehicleId,
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'number' => $number,
                'society_id' => $this->session->get('society_id'),
                'flat_id' => $flatId,
                'is_active' => isset($isActive) ? 1 : 0,
                'is_visitor_parking' => isset($isVisitorParking) ? 1 : 0,
            );
            if(!empty($parkingSlotId)){
                $parkingSlotUpdateData = $this->parking_slot_model->getParkingSlotData(array(
                    'parking_slot_id' => $parkingSlotId,
                ));
                $parkingSlotUpdateArray = compareArray($parkingSlotArray,$parkingSlotUpdateData);
            }
            $parkingSlotData = $this->parking_slot_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),$parkingSlotUpdateArray);

            $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                'parking_slot_id' => $parkingSlotId,
            ));

            // printArray($ownershipFlatParkingData,1);

            if(!empty($ownershipFlatParkingData)){
                $parkingUpdateArray = array(
                    'ownership_flat_parking_id' => $ownershipFlatParkingData['ownership_flat_parking_id'],
                    'parking_slot_id' => 0,
                );

                $this->parking_slot_model->insertUpdateRecord($parkingUpdateArray,'ownership_flat_parking_id','tbl_ownership_flat_parking', 1,'',array(),array(),array());

                $parkingInsertArray = array(
                    'ownership_flat_parking_id' => $ownershipFlatParkingId,
                    'parking_slot_id' => $parkingSlotId,
                ); 

                $this->parking_slot_model->insertUpdateRecord($parkingInsertArray,'ownership_flat_parking_id','tbl_ownership_flat_parking', 1,'',array(),array(),array());
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($parkingSlotId) && $parkingSlotId != '') {
                if (($parkingSlotData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('ParkingSlot.parking_slot'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('ParkingSlot.parking_slot'));
                }
            } else {
                if (($parkingSlotData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('ParkingSlot.parking_slot'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('ParkingSlot.parking_slot'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->parking_slot_model->statusChange($parkingSlotId,$status,'parking_slot_id','tbl_parking_slot');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('ParkingSlot.parking_slot'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('ParkingSlot.parking_slot'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $parkingSlotId = $this->request->getVar('parking_slot_id');
         if( isReferenceInTable( 'parking_slot_id','tbl_rentals_parking', $parkingSlotId) ||
             isReferenceInTable( 'parking_slot_id','tbl_visitor', $parkingSlotId) ||
             isReferenceInTable( 'parking_slot_id','tbl_ownership_flat_parking', $parkingSlotId)){

             if(!empty($parkingSlotId)){
                 foreach($parkingSlotId as $parkingSlot){
                     $deleteDataArray['module'] = 'Parking Slot';
                     $deleteDataArray['activity'] = "Tried to delete Parking Slot ";
                     $deleteDataArray['module_id'] = $parkingSlot;
                     logActivity('Tried to delete Parking Slot [ParkingSlotID: ' . $parkingSlot . ']',$this->data['userId'],'Parking Slot',$parkingSlot,json_encode($deleteDataArray),'','Parking Slot',$parkingSlot);
                 }
             }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
        $parkingSlotData = $this->parking_slot_model->deleteRecord($parkingSlotId);
        $transactionStatus = $this->db->transComplete();
        if (($parkingSlotData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('ParkingSlot.parking_slot'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('ParkingSlot.parking_slot'));
        }
        echo json_encode($response);
        exit;
    }

    public function getParkingSlotDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $vehicleType = $this->request->getVar('vehicle_type');
        $flatId = $this->request->getVar('flat_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'parking_slot_id' => $parkingSlotId,
            'vehicle_type' => $vehicleType,
            'flat_id' => $flatId,

        );
        echo $this->parking_slot_model->getParkingSlot($filterData);
    }

    public function excelExportParkingSlot()
    {
        $fileName ='pp-' . DATETIMEFORMAT;
        $sheetName = 'PP-' . DATEFORMAT;
        $excelHeaderName = 'Parking Slot';
        $tableData = $this->getParkingSlotListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('ParkingSlot.society'),
            lang('ParkingSlot.flat_no'),
            lang('ParkingSlot.parking_area'),
            lang('ParkingSlot.number'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["excel_flat_no"],
                $row["parking_area_name"],
                $row["number"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
