<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\OwnershipFlatModel;
use App\Models\SocietyModel;
use App\Models\FlatModel;
use App\Models\DocumentModel;
use App\Models\StaffModel;
use App\Models\RentalsModel;
use App\Models\ManagementCommitteeModel;
use App\Models\CommonWebServiceModel;
use App\Models\IonAuthModel;
use App\Models\ResourceModel;
use App\Models\ResourceTypeModel;
helper('text');

class OwnershipFlat extends BaseController
{
    protected $ownership_flat_model;
    protected $resource_model;
    public function __construct() {
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->resource_model = new ResourceModel();
        $this->resource_type_model = new ResourceTypeModel();
        $this->society_model = new SocietyModel();
        $this->flat_model = new FlatModel();
        $this->document_model = new DocumentModel();
        $this->staff_model = new StaffModel();
        $this->rentals_model = new RentalsModel();
        $this->management_committee_model = new ManagementCommitteeModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ionAuthModel = new IonAuthModel();
        // checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);
        // checkAndCreatePath(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
        // checkAndCreatePath(THUMBNAIL_VEHICLE_IMAGE_PATH);

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Ownership Flat';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "flatDd",
                "id" => "filter_flat_id",
                "name" => "filter_flat_id",
                "title" => "OwnershipFlat.flat_no",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_date_of_registry",
                "name" => "filter_date_of_registry",
                "title" => "OwnershipFlat.date_of_registry",
                // "selected" => currentFinancialYear(),
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        $data['lang_name'] = 'OwnershipFlat.';
        return $this->dt_ci_template->load("Admin","OwnershipFlat/OwnershipFlatView",$data);
    }

    public function getOwnershipFlatListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $flatId = $this->request->getVar("filter_flat_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $dateOfRegistry = $this->request->getVar("filter_date_of_registry");
        $type = $this->request->getVar("type");

        $this->datatables->table("tbl_ownership_flat as tof");
        $this->datatables->select("tof.ownership_flat_id, tof.index_no,tof.date_of_registry, tof.is_active,tof.society_id,ts.society_name,tof.type");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tof.updated_at");
        $this->datatables->select("tf.flat_no as flat_nos,concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no,tof.flat_id");
        $this->datatables->select("tt.tower_name");
        $this->datatables->select("if(tof.type='transferred',1,0) as is_transferred");
        $this->datatables->select("if(COALESCE(tm.name,'') ='',IF(tof.purchased_from_id = '-1','".BUILDER."',COALESCE(tm.name,'')),COALESCE(tm.name,'')) as purchased_from");
        $this->datatables->select("GROUP_CONCAT(distinct(COALESCE(tbm.name,'')) SEPARATOR ', ') as buyer_name");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tof.society_id","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
        $this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tof.updated_by AND tupdate.society_id = tof.society_id","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tof.purchased_from_id","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");
        $this->datatables->join("tbl_ownership_flat_member as btofm","btofm.type_id = tof.ownership_flat_id AND btofm.type = 'ownership_flat' AND btofm.is_owner = 1","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tbm","tbm.member_id = btofm.member_id","left");
        $this->datatables->where("tof.is_delete = 0");

        if($type == TRANSFERRED) {
            //$this->datatables->where("tof.type",TRANSFERRED);
            $this->datatables->where("tof.is_latest",0);
        }
        else{
            $this->datatables->where("tof.is_latest",1);
            //$this->datatables->where("tof.type !=",TRANSFERRED);
        }


        if(isset($flatId)) {
            if(is_array($flatId)){
                $this->datatables->whereIn("tof.flat_id",$flatId);
            } else {
                $this->datatables->where("tof.flat_id",$flatId);
            }
        }

        if($dateOfRegistry != ''){
            list($fromDate,$toDate) = explode(" - ",$dateOfRegistry);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tof.date_of_registry,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tof.date_of_registry,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tof.date_of_registry,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tof.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tof.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tof.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tof.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tof.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tof.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        accessFilter($this->datatables, array("society" => "tof.society_id"));
        $this->datatables->groupBy("tof.ownership_flat_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "ownership_flat_id" => isset($displayData['ownership_flat_id']) ? $displayData['ownership_flat_id'] : "",
                    "type" => isset($type) ? $type : ""
                );
                $data[$key]['action_button'] = ownershipFlatActionButton($actionButtonFilter);
                $data[$key]['date_of_registry'] = (isset($displayData['date_of_registry']) && isValidDate($displayData['date_of_registry'])) ? siteDateFormat($displayData['date_of_registry']) : "";
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['excel_flat_no'] = isset($displayData['flat_no']) ?  $displayData['flat_no'] : "";
                $data[$key]['flat_no'] = isset($displayData['flat_no']) ?  flatDocumentToHtml($displayData['flat_no'],$displayData['flat_id']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($ownershipFlatId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        $type = $this->request->getGet('type');
        if($type == TRANSFERRED) {
            $langAlias = 'TransferredFlat.';
            if (!$this->dt_ci_acl->checkAccess("TransferredFlat|manage")) {
                return redirect()->to('Admin/Dashboard');
            }
        }
        else{
            $langAlias = 'OwnershipFlat.';
        }


        if ($ownershipFlatId != '') {
            $filterData = array(
                "ownership_flat_id" => $ownershipFlatId
            );
            $data['ownership_flat_data'] = $this->ownership_flat_model->getOwnershipFlatData($filterData);

            //printArray($data['ownership_flat_data'],1);

            if (empty($data['ownership_flat_data'])) {
                return redirect()->to('Admin/OwnershipFlat?type=first_owner');
            }

            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1,
            ));

            // printArray($ownershipFlatMemberData,1);
            $data['ownership_flat_member_data'] = $ownershipFlatMemberData;

            $ownershipFlatEmergencyContactData = $this->ownership_flat_model->getOwnershipFlatEmergencyData(array(
                //'ownership_flat_id' => $ownershipFlatId,
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));
            $data['ownership_flat_emergency_contact_data'] = $ownershipFlatEmergencyContactData;

            $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                //'ownership_flat_id' => $ownershipFlatId,
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));
            $data['ownership_flat_parking_data'] = $ownershipFlatParkingData;


            // $ownershipFlatAccessCardData = $this->ownership_flat_model->getModuleAccessCardData(array(
            //     'type' => 'ownership_flat',
            //     'type_id' => $ownershipFlatId,
            //     'is_multiple' => 1
            // ));

            // $moduleAccessCardTokenIdArray = array();
            // if (!empty($ownershipFlatAccessCardData)) {
            //     foreach ($ownershipFlatAccessCardData as $accessCardElement) {
            //         array_push($moduleAccessCardTokenIdArray,$accessCardElement['module_access_card_token_id']);
            //     }
            // }

            // $ownershipFlatAccessCardVehicleTypeData = array();
            // $ofacvtTypeIdWiseArray = array();
            // if(!empty($moduleAccessCardTokenIdArray)){
            //     $ownershipFlatAccessCardVehicleTypeData = $this->ownership_flat_model->getModuleAccessCardVehicleTypeData(array(
            //         'module_access_card_token_id' => $moduleAccessCardTokenIdArray,
            //         'is_multiple' => 1
            //     ));


            //     if(!empty($ownershipFlatAccessCardVehicleTypeData)){
            //         foreach($ownershipFlatAccessCardVehicleTypeData  as $ofacvKey => $ownershipFlatAccessCardVehicleTypeElement){
            //             $ofacvtTypeIdWiseArray[$ownershipFlatAccessCardVehicleTypeElement['module_access_card_token_id']][] = $ownershipFlatAccessCardVehicleTypeElement;
            //         }
            //     }
            // }

            // if(!empty($ownershipFlatAccessCardData)){
            //     foreach($ownershipFlatAccessCardData as $ofacKey => $ownershipFlatAccessCardElement){
            //         $ownershipFlatAccessCardData[$ofacKey]['vehicle_data'] = array_key_exists($ownershipFlatAccessCardElement['module_access_card_token_id'],$ofacvtTypeIdWiseArray) ? $ofacvtTypeIdWiseArray[$ownershipFlatAccessCardElement['module_access_card_token_id']]: array();
            //     }
            // }

            // $data['ownership_flat_access_card_data'] = $ownershipFlatAccessCardData;
            // printArray($ownershipFlatAccessCardData,1);

            $documentData = $this->document_model->getDocumentData(array(
                'document_for' => 'ownership_flat',
                'is_active' => 1,
                'is_multiple' => 1,

            ));
            if(!empty($documentData)){
                foreach ($documentData as $key => $displayData) {
                    $document = $this->staff_model->getDocument(array(
                        'document_id' => $displayData['document_id'],
                    ));
                    if(!empty($document)){
                        $documentData[$key]['module_document_id'] = $document['module_document_id'];
                        $documentData[$key]['input_box'] = $document['input_box'];
                        $documentData[$key]['document_expiry_date'] = $document['document_expiry_date'];
                    }
                    $documentImageData = $this->staff_model->getDocumentImage(array(
                        "document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
                        'module_id' => $ownershipFlatId,
                        'module' => 'ownership_flat',
                        "is_multiple" => 1,
                    ));
                    $documentData[$key]['module_image_data'] = $documentImageData;
                }
            }
            $data['document_data'] = $documentData;
        }
        else{
            $documentType = $this->document_model->getDocumentData(array(
                'document_for' => 'ownership_flat',
                'is_active' => 1,
                'is_multiple' => 1,

            ));
            $iKey = 0;
            if(!empty($documentType)){
                foreach($documentType as $imageType){
                    $documentTypeData[$iKey] = $imageType;
                    $iKey = $iKey + 1;
                }
            }
            if(!empty($documentTypeData)){
                $data['document_data'] = $documentTypeData;
            }
        }
        if ($ownershipFlatId != '') {
            $data['title'] = lang('OwnershipFlat.edit_ownership_flat');
        } else {
            $data['title'] = lang('OwnershipFlat.add_ownership_flat');
        }
        $data['ownership_flat_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

        $select2Ajax = array(
            'isOwnershipFlat' => true,
        );
        if(isset($data['ownership_flat_data']['type']) && $data['ownership_flat_data']['type'] == TRANSFERRED){
            $select2Ajax['isParentPurchaseFrom'] = $data['ownership_flat_data']['parent_ownership_flat_id'];
        }

        $data['document_table'] = view('Admin/Staff/DocumentView', isset($data) ? $data : array());
        $data['request']= $request;
        $data['ownership_flat_member_table'] = view('Admin/OwnershipFlat/OwnershipFlatMemberView', isset($data) ? $data : array());
        $data['verify_otp_view'] = view('Admin/OwnershipFlat/VerifyOtpModalView', isset($data) ? $data : array());
        $data['ownership_flat_emergency_contact_table'] = view('Admin/OwnershipFlat/OwnershipFlatEmergencyContactView', isset($data) ? $data : array());
        $data['ownership_flat_parking_table'] = view('Admin/OwnershipFlat/OwnershipFlatParkingView', isset($data) ? $data : array());
        // $data['ownership_flat_access_card_table'] = view('Admin/OwnershipFlat/OwnershipFlatAccessCardView', isset($data) ? $data : array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax) ? $select2Ajax : array());

        if ((isset($data['flat_data']['society_id']) && $data['flat_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Flat');
        }
        if ((isset($data['ownership_flat_data']['society_id']) && $data['ownership_flat_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/OwnershipFlat?type=first_owner');
        }
        $data['lang_name'] = $langAlias;
        $this->dt_ci_template->load("Admin","OwnershipFlat/OwnershipFlatManageView",$data);
    }
    public function save()
    {
        // printArray($_POST,1);
        // printArray($_FILES,1);
        $validation = \Config\Services::validation();
        $this->db->transStart();
        $this->centralDB->transStart();
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $parentOwnershipFlatId = $this->request->getVar('parent_ownership_flat_id');
        $flatId = $this->request->getVar('flat_id');
        $indexNo = $this->request->getVar('index_no');
        $dateOfRegistry = $this->request->getVar('date_of_registry');
        //$purchasedFrom = $this->request->getVar('purchased_from');
        $purchasedFromId = $this->request->getVar('purchased_from_id');
        $isActive = $this->request->getVar('is_active');
        $type = $this->request->getVar('type');
        $resident = $this->request->getVar('resident');


       $validation->setRule('flat_id', lang('OwnershipFlat.flat'), 'required');
       $validation->setRule('index_no', lang('OwnershipFlat.index_no'), 'required');
       // $validation->setRule('date_of_registry', lang('OwnershipFlat.date_of_registry'), 'required');
        //if($type == TRANSFERRED){
            $validation->setRule('purchased_from_id', lang('OwnershipFlat.purchased_from'), 'required');
        //        } else {
        //            $validation->setRule('purchased_from', lang('OwnershipFlat.purchased_from'), 'required');
        //        }

       $validation->setRule('name.*', lang('OwnershipFlat.name'), 'required');
      // $validation->setRule('mobile_no.*', lang('OwnershipFlat.mobile_no'), 'required');
       $validation->setRule('gender.*', lang('OwnershipFlat.gender'), 'required');
       $validation->setRule('relation.*', lang('OwnershipFlat.relation'), 'required');
       // $validation->setRule('birth_date.*', lang('OwnershipFlat.birth_date'), 'required');

       $validation->setRule('ec_name.*', lang('OwnershipFlat.e_name'), 'required');
       $validation->setRule('ec_place.*', lang('OwnershipFlat.e_place'), 'required');
       $validation->setRule('ec_relation.*', lang('OwnershipFlat.e_relation'), 'required');
       $validation->setRule('ec_mobile_no.*', lang('OwnershipFlat.e_mobile'), 'required');


        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            if(isset($ownershipFlatId) && $ownershipFlatId != "") {
                $oldOwnershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                    'type' => array('ownership_flat','transferred'),
                    'type_id' => $ownershipFlatId,
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'society_id' => $this->session->get('society_id'),
                ));
            }

            // printArray($filterMobileNoArray);

            $filterMobileNoArray = $this->request->getVar('mobile_no');

            if(isset($oldOwnershipFlatMemberData) && !empty($oldOwnershipFlatMemberData)){
                foreach($oldOwnershipFlatMemberData as $oldMemberData){
                    if(isset($oldMemberData['mobile_no'])) {
                        $filterMobileNoArray[] = $oldMemberData['mobile_no'];
                    }
                }
            }

            $filterMobileNoArray = array_filter($filterMobileNoArray, function($value, $key) {
                return !empty($value);
            }, ARRAY_FILTER_USE_BOTH);

            // printArray($filterMobileNoArray,1);

            $mobileNoErrorArray = array();
            // Resource Validation
            $resourceData = $this->resource_model->getResourceData(array(
                'resource_mobile_no' => $filterMobileNoArray,
                'is_multiple' => 1,
                'society_id' => $this->session->get('society_id'),
            ));

            if(!empty($resourceData)){
                foreach($resourceData as $resource){
                    if(in_array($resource['resource_mobile_no'], $filterMobileNoArray)){ 
                        $mobileNoErrorArray[] = $resource['resource_mobile_no']." Already Exists in this Society as Resource.";
                    }
                }
            }

            if(!empty($mobileNoErrorArray)){
                $response['success'] = false;
                $response['msg'] = implode("\n", $mobileNoErrorArray);
                echo json_encode($response);
                exit;
            }

            // Manager Validation
            $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER);
            $managerData = $this->common_web_service_model->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                'resource_type_id' => $resourceTypeManagerId,
                'society_id' => $this->session->get('society_id'),
                'is_multiple' => 1
            ));

            if(!empty($managerData)){
                foreach($managerData as $member){
                    if(in_array($member['phone'], $filterMobileNoArray)){ 
                        $mobileNoErrorArray[] = $member['phone']." Already Exists in this Society as Manager.";
                    }
                }
            }

            if(!empty($mobileNoErrorArray)) {
                $response['success'] = false;
                $response['msg'] = implode("\n", $mobileNoErrorArray);
                echo json_encode($response);
                exit;
            }

            // Exists Member-Data
            $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

            $existsUserData = $this->common_web_service_model->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                // 'resource_type_id' => $resourceTypeMemberId,
                'is_multiple' => 1
            ));

            $existsUserMemberData = $this->common_web_service_model->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                // 'resource_type_id' => $resourceTypeMemberId,
                'is_multiple' => 1,
                'is_member' => 1,
            ));

            $resourceTypeMemberData = $this->resource_type_model->getResourceTypeData(array(
                "resource_type_name" => RESOURCE_TYPE_MEMBER,
                "society_id" => $this->session->get('society_id'),
            ));

            $oldOwnershipFlatMemberData = array();
            $oldOwnershipFlatEmergencyContactData = array();
            $oldOwnershipFlatParkingData = array();
            if(!empty($ownershipFlatId)){
                $oldOwnershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                    //'ownership_flat_id' => $ownershipFlatId,
                    'type' => 'ownership_flat',
                    'type_id' => $ownershipFlatId,
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'society_id' => $this->session->get('society_id'),
                ));

                $oldOwnershipFlatEmergencyContactData = $this->ownership_flat_model->getOwnershipFlatEmergencyData(array(
                    //'ownership_flat_id' => $ownershipFlatId,
                    'type' => 'ownership_flat',
                    'type_id' => $ownershipFlatId,
                    'is_multiple' => 1,
                    // 'society_id' => $this->session->get('society_id'),
                ));

                $oldOwnershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                    //'ownership_flat_id' => $ownershipFlatId,
                    'type' => 'ownership_flat',
                    'type_id' => $ownershipFlatId,
                    'is_multiple' => 1,
                    // 'society_id' => $this->session->get('society_id'),
                ));

                $documentData = $this->document_model->getDocumentData(array(
                    'document_for' => 'ownership_flat',
                    'is_active' => 1,
                    'is_multiple' => 1,
                    // 'society_id' => $this->session->get('society_id'),
                ));
            }

            $moduleDocumentResult = array();
            if (isset($_FILES["document_image"])) {
                $moduleDocumentResult  = $this->dt_ci_file_upload->MultipleFileUpload('document_image', MAX_IMAGE_SIZE_LIMIT, DOCUMENT_IMAGE_PATH, true, true, array('jpeg', 'png', 'jpg', 'JPG'));

                if ($moduleDocumentResult['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($moduleDocumentResult['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($moduleDocumentResult['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($moduleDocumentResult, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }


            $imageResultArray = array();
            if(!empty($moduleDocumentResult)){
                foreach ($moduleDocumentResult as $keyImage => $imageResultData){
                    list($fromKey) = explode("_",$keyImage);
                    $imageResultArray[$fromKey][] = $imageResultData;
                }
            }


            //get member data
            $ownershipFlatMemberIdArray = $this->request->getVar('ownership_flat_member_id');
            $memberIdArray = $this->request->getVar('member_id');
            $oldMemberIdArray = $this->request->getVar('old_member_id');
            $nameArray = $this->request->getVar('name');
            $emailIdArray = $this->request->getVar('email_id');
            $mobileNoArray = $this->request->getVar('mobile_no');
            $genderArray = $this->request->getVar('gender');
            $birthDateArray = $this->request->getVar('birth_date');
            $bloodGroupArray = $this->request->getVar('blood_group');
            $relationArray = $this->request->getVar('relation',);
            // $foodLikeArray = $this->request->getVar('food_like');
            $isOwnerArray = $this->request->getVar('is_owner');

            $mobileNoFilterArray = array_values($mobileNoArray);
            // $userDataFilter = $this->common_web_service_model->getUserData(array(
            //     'phone' => $mobileNoFilterArray,
            //     // 'user_type_not' => 'member',
            //     'resource_type_id_not' => $resourceTypeMemberData['resource_type_id'],
            //     'society_id' => $this->session->get('society_id'),
            // ));
            // if(!empty($userDataFilter)){
            //     $response['success'] = false;
            //     $response['msg'] = 'Duplicate Mobile No Exist';
            //     echo json_encode($response);
            //     exit;
            // }
            // printArray($mobileNoFilterArray,1);
            // $userDataMobileNoArray = $this->common_web_service_model->getUserData(array(
            //     'phone' => $mobileNoFilterArray,
            //     'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
            //     'society_id' => $this->session->get('society_id'),
            //     'is_multiple' => 1
            // ));

            $mobileNoDuplicateArray = array();
            $mobileNoUniqueArray = array();
            $memberKey = 0;
            if(!empty($ownershipFlatMemberIdArray)) {
                foreach ($ownershipFlatMemberIdArray as $mkey => $ownershipFlatMemberId) {
                    $memberKey = $memberKey + 1;
                    $mobileNo = array_key_exists($mkey, $mobileNoArray) ? $mobileNoArray[$mkey] : '';

                    if($mobileNo != ''){
                        if (!in_array($mobileNo, $mobileNoUniqueArray)) {
                            $mobileNoUniqueArray[$memberKey] = $mobileNo;
                        } else {
                            $mobileNoDuplicateObject = array();
                            $mobileNoDuplicateObject['row_no'] = $memberKey;
                            $mobileNoDuplicateArray[$memberKey] = $mobileNoDuplicateObject;
                        }
                    }
                }
            }
            $findDuplicatieMobileArray = array();
            if(!empty($mobileNoDuplicateArray)){
                foreach($mobileNoDuplicateArray as $mobileNoDuplicateElement){
                    $findDuplicatieMobileArray[] =  " Member Information Line Item ".$mobileNoDuplicateElement['row_no'] . "  Mobile Number Duplicate ";
                }
            }

            if(!empty($findDuplicatieMobileArray)){
                $response['success'] = false;
                $response['msg'] = implode("\n", $findDuplicatieMobileArray);
                echo json_encode($response);
                exit;
            }

            //get emergency contact data
            $ownershipFlatEmergencyContactIdArray = $this->request->getVar('ownership_flat_emergency_contact_id');
            $ecNameArray = $this->request->getVar('ec_name');
            $ecPlaceArray = $this->request->getVar('ec_place');
            $ecRelationArray = $this->request->getVar('ec_relation');
            $ecMobileNoArray = $this->request->getVar('ec_mobile_no');

            //get parking data
            $ownershipFlatParkingIdArray = $this->request->getVar('ownership_flat_parking_id');
            $vehicleTypeArray = $this->request->getVar('vehicle_type');
            $parkingSlotIdArray = $this->request->getVar('parking_slot_id');
            $vehicleNoArray = $this->request->getVar('vehicle_no');
            // $parkingSlotNoArray = $this->request->getVar('parking_slot_no');
            $tokenNoArray = $this->request->getVar('token_no');
            $isElectricArray = $this->request->getVar('is_electric');
            $commonMemberImageArray  = $this->request->getVar('common_member_image');


            //get access card data
            // $moduleAccessCardTokenIdArray = $this->request->getVar('module_access_card_token_id');
            // $remarksArray = $this->request->getVar('remarks');
            // $liftsAccessArray = $this->request->getVar('lifts_access');
            // $amenitiesIdArray = $this->request->getVar('amenities_id');
            // $accessCardVehicleTypeArray = $this->request->getVar('access_card_vehicle_type');

            $imageFormat = array('jpg','jpeg','png','JPG');
            $imageExtension = imageExtension($imageFormat);
            $ownershipFlatResult = array();
            if (isset($_FILES["member_image"])) {
                $ownershipFlatPath = FLAT_MEMBER_IMAGE_PATH;
                $ownershipFlatResult = $this->dt_ci_file_upload->UploadMultipleFile('member_image', MAX_IMAGE_SIZE_LIMIT, $ownershipFlatPath, true, true, $imageExtension, true);
                if ($ownershipFlatResult['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($ownershipFlatResult['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($ownershipFlatResult['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($ownershipFlatResult, FLAT_MEMBER_IMAGE_PATH, THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
                }
            }

            $ownershipParkingResult = array();
            if (isset($_FILES["vehicle_image"])) {
                $ownershipParkingPath = VEHICLE_IMAGE_PATH;
                $ownershipParkingResult = $this->dt_ci_file_upload->UploadMultipleFile('vehicle_image', MAX_IMAGE_SIZE_LIMIT, $ownershipParkingPath, true, true, $imageExtension, true);
                if ($ownershipParkingResult['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($ownershipParkingResult['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($ownershipParkingResult['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($ownershipParkingResult, VEHICLE_IMAGE_PATH, THUMBNAIL_VEHICLE_IMAGE_PATH);
                }
            }

            // printArray($ownershipParkingResult,1);

            $commonValidationArray = [];
            $towerId = 0;
            $getFlatData = $this->flat_model->getFlatData(array('flat_id'=>$flatId));

            if(!empty($getFlatData)){
                $towerId = isset($getFlatData['tower_id']) ? $getFlatData['tower_id'] : 0;
            }

            $filterData = array('ownership_flat_id' => $ownershipFlatId,'index_no' => $indexNo ,'is_latest' => 1,'tower_id'=> $towerId , 'society_id' =>$this->session->get('society_id'));

            $checkFlatWiseIndexNoData = $this->ownership_flat_model->checkFlatWiseIndexNoData($filterData);
            if(!empty($checkFlatWiseIndexNoData)){
                $commonValidationArray[] =  'Flat No '.$checkFlatWiseIndexNoData['flat_no'] . ' Index No '.$indexNo .' Already Assign';
            }

            if (!isset($isOwnerArray)) {
                $commonValidationArray[] =  'Atleast One Flat Member Should Be Selected As Owner';
            }

            $parkingSlotDuplicateArray = array();
            $parkingSlotUniqueArray = array();
            $memberKey = 0;
            if(!empty($parkingSlotIdArray)) {
                foreach ($parkingSlotIdArray as $mkey => $parkingSlotId) {
                    $memberKey = $memberKey + 1;
                    $parkingSlot = array_key_exists($mkey, $parkingSlotIdArray) ? $parkingSlotIdArray[$mkey] : '';

                    if($parkingSlot != ''){
                        if (!in_array($parkingSlot, $parkingSlotUniqueArray)) {
                            $parkingSlotUniqueArray[$memberKey] = $parkingSlot;
                        } else {
                            $parkingSlotDuplicateObject = array();
                            $parkingSlotDuplicateObject['row_no'] = $memberKey;
                            $parkingSlotDuplicateArray[$memberKey] = $parkingSlotDuplicateObject;
                        }
                    }
                }
            }
            $findDuplicatieParkingSlotArray = array();
            if(!empty($parkingSlotDuplicateArray)){
                foreach($parkingSlotDuplicateArray as $parkingSlotDuplicateElement){
                    $findDuplicatieParkingSlotArray[] =  "Vehicle & Parking Detail Line Item ".$parkingSlotDuplicateElement['row_no'] . "  Parking Slot Duplicate ";
                }
            }

            if(!empty($findDuplicatieParkingSlotArray)){
                $response['success'] = false;
                $response['msg'] = implode("\n", $findDuplicatieParkingSlotArray);
                echo json_encode($response);
                exit;
            }

            $parkingSlotValidationArray = array();
            $selectedParkingSlotArray = array();
            $selectedOwnershipSlotParkingArray = array();
            $aggreementPeriodClosedArray = array();
            $filteredAlreadyAssignedData = array();
            // printArray($parkingSlotIdArray,1);
            // foreach ($parkingSlotIdArray as $pkey => $pValue) {
            //     if(isReferenceInTable('parking_Slot_id', 'tbl_ownership_flat_parking', $pValue) && !empty($pValue)) {
            //         $parkingSlotValidationArray[] = 'Pakeing Slot Is Already Occupied For Row No '. $pkey;
            //     }
            // }

            foreach ($parkingSlotIdArray as $sppKey => $sppValue) {
                $parkingSlotId = array_key_exists($sppKey, $parkingSlotIdArray) ? $parkingSlotIdArray[$sppKey] : '';
                $ownerShipFlatParkingId = array_key_exists($sppKey, $ownershipFlatParkingIdArray) ? $ownershipFlatParkingIdArray[$sppKey] : '';

                if (!empty($parkingSlotId)) {
                    $selectedParkingSlotArray[] = $parkingSlotId;
                }
                if (!empty($ownerShipFlatParkingId)) {
                    $selectedOwnershipSlotParkingArray[] = $ownerShipFlatParkingId;
                }

            }
            $filterData = array(
                "ownership_flat_parking_not_id" => $selectedOwnershipSlotParkingArray,
                "parking_slot_id" => $selectedParkingSlotArray,
                "check_rental_start" => 1,
                "is_multiple" => 1
            );
            if(!empty($selectedParkingSlotArray)){
                $alreadyAssignedData = $this->ownership_flat_model->checkAssignedParking($filterData);
                $aggreementPeriodClosedArray = $this->ownership_flat_model->checkAggrementClosed(array("is_multiple" =>1));
                // lastQuery();
                // printArray($alreadyAssignedData);
                // printArray($aggreementPeriodClosedArray,1);
                if (!empty($alreadyAssignedData) && !empty($aggreementPeriodClosedArray)) {
                    foreach ($alreadyAssignedData as $key => $assignedData) {
                        $isDuplicate = false;
                        // Only proceed if type is 'rentals'
                        if ($assignedData['type'] == 'rentals') {
                            foreach ($aggreementPeriodClosedArray as $closedData) {
                                // Check if type_id matches rentals_id
                                if ($assignedData['type_id'] == $closedData['rentals_id']) {
                                    // echo "f";
                                    $isDuplicate = true;
                                    break; // No need to check further if we found a match
                                }
                            }
                        }
                        // If no duplicate is found, or the type is not 'rentals', add the item to the filtered list
                        if (!$isDuplicate) {
                            $filteredAlreadyAssignedData[] = $assignedData;
                        }
                    }
                } else {
                    // If either array is empty, no need to filter
                    $filteredAlreadyAssignedData = $alreadyAssignedData;
                }

                // printArray($filteredAlreadyAssignedData,1);
                if(!empty($filteredAlreadyAssignedData)){
                    foreach ($filteredAlreadyAssignedData as $aKey => $value) {
                        $parkingSlotValidationArray[] = 'Parking Slot '. $value['parking_area'] .' Is Already Occupied';
                    }

                }
                if(!empty($parkingSlotValidationArray)){
                    $response['success'] = false;
                    $response['msg'] = implode("\n", $parkingSlotValidationArray);
                    echo json_encode($response);
                    exit;
                }
            }
            foreach ($ownershipFlatParkingIdArray as  $vKey => $ownershipFlatParkingIdElement) {
                $vehicleType = isset($vehicleTypeArray) && array_key_exists($vKey, $vehicleTypeArray) ? $vehicleTypeArray[$vKey] : '';
                $parkingSlotId = array_key_exists($vKey, $parkingSlotIdArray) ? $parkingSlotIdArray[$vKey] : '';
                $vehicleNo = array_key_exists($vKey, $vehicleNoArray) ? $vehicleNoArray[$vKey] : '';
                // $parkingSlotNo = array_key_exists($vKey, $parkingSlotNoArray) ? $parkingSlotNoArray[$vKey] : '';
                $tokenNo = array_key_exists($vKey, $tokenNoArray) ? $tokenNoArray[$vKey] : '';

                if ($vehicleType == '') {
                    $commonValidationArray[] = lang('OwnershipFlat.parking_information') ." " . lang('CommonMessage.common_sr_no'). $vKey .' '. lang('OwnershipFlat.vehicle_type'). ' ' . lang('CommonMessage.common_is_required');
                }

                // if ($parkingSlotId == '') {
                //     $commonValidationArray[] = lang('OwnershipFlat.parking_information')  ." " . lang('CommonMessage.common_sr_no'). $vKey .' '. lang('OwnershipFlat.parking_Slot'). ' ' . lang('CommonMessage.common_is_required');
                // }

                if($vehicleType == '4_wheelers'){
                    // if ($parkingSlotNo == '') {
                    //     $commonValidationArray[] = lang('OwnershipFlat.parking_information')  ." " . lang('CommonMessage.common_sr_no'). $vKey .' '. lang('OwnershipFlat.parking_slot_no'). ' ' . lang('CommonMessage.common_is_required');
                    // }

                    // if ($tokenNo == '') {
                    //     $commonValidationArray[] = lang('OwnershipFlat.parking_information')  ." " . lang('CommonMessage.common_sr_no'). $vKey .' '. lang('OwnershipFlat.token_no'). ' ' . lang('CommonMessage.common_is_required');
                    // }
                }
            }


            if (!empty($commonValidationArray)) {
                $response['success'] = false;
                $response['msg'] = implode("\n", $commonValidationArray);
                echo json_encode($response);
                exit();
            }


            $ownershipFlatUpdateArray = array();
            $ownershipFlatArray = array(
                'ownership_flat_id' => $ownershipFlatId,
                'society_id' => $this->session->get('society_id'),
                //'tower_id'=> $towerId,
                'flat_id' => $flatId,
                'index_no' => $indexNo,
                'date_of_registry' => DMYToYMD($dateOfRegistry),
                //'purchased_from' => $purchasedFrom,
                'purchased_from_id' => $purchasedFromId,
                'type' => $type,
                'resident' => $resident,
                'is_active' => isset($isActive) ? 1 : 0,
            );
            if($type == 'first_owner' && $ownershipFlatId == ''){
                $ownershipFlatArray['is_latest'] = 1;
            }

            if($type == TRANSFERRED && $ownershipFlatId == ''){
                $ownershipFlatArray['parent_ownership_flat_id'] = $parentOwnershipFlatId;
                $ownershipFlatArray['is_latest'] = 1;
            }


            if(!empty($ownershipFlatId)){
                $ownershipFlatUpdateData = $this->ownership_flat_model->getOwnershipFlatData(array(
                    'ownership_flat_id' => $ownershipFlatId,
                ));
                $ownershipFlatUpdateArray = compareArray($ownershipFlatArray,$ownershipFlatUpdateData);
            }

            $ownershipFlatData = $this->flat_model->insertUpdateRecord($ownershipFlatArray, 'ownership_flat_id', 'tbl_ownership_flat', 1,'',array(),array(),$ownershipFlatUpdateArray);
            $lastOwnershipFlatId = $ownershipFlatData['lastInsertedId'];

            if($type == 'first_owner' && $ownershipFlatId == ''){

                $updateOwnershipFlatArray['ownership_flat_id'] = $lastOwnershipFlatId;
                $updateOwnershipFlatArray['main_ownership_flat_id'] = $lastOwnershipFlatId;

                $ownershipFlatUpdateData = array();
                if(!empty($lastOwnershipFlatId)){
                    $ownershipFlatUpdateData = $this->ownership_flat_model->getOwnershipFlatData(array(
                        'ownership_flat_id' => $lastOwnershipFlatId,
                    ));
                    $ownershipFlatUpdateArray = compareArray($updateOwnershipFlatArray,$ownershipFlatUpdateData);
                }


                $this->ownership_flat_model->insertUpdateRecord($updateOwnershipFlatArray, 'ownership_flat_id', 'tbl_ownership_flat', 1,'',array(),array(),$ownershipFlatUpdateArray);
            }


            if($type == TRANSFERRED && $ownershipFlatId == ''){
                $parentOwnershipFlatData = $this->ownership_flat_model->getOwnershipFlatData(array(
                    'ownership_flat_id' => $parentOwnershipFlatId
                ));
                if(!empty($parentOwnershipFlatData)){
                    $updateMainOwnershipFlatArray['ownership_flat_id'] = $lastOwnershipFlatId;
                    $updateMainOwnershipFlatArray['main_ownership_flat_id'] = isset($parentOwnershipFlatData['main_ownership_flat_id']) ? $parentOwnershipFlatData['main_ownership_flat_id'] : 0;

                    $ownershipFlatUpdateData = array();
                    if(!empty($lastOwnershipFlatId)){
                        $ownershipFlatUpdateData = $this->ownership_flat_model->getOwnershipFlatData(array(
                            'ownership_flat_id' => $lastOwnershipFlatId,
                        ));
                        $ownershipFlatUpdateArray = compareArray($updateMainOwnershipFlatArray,$ownershipFlatUpdateData);
                    }


                    $this->ownership_flat_model->insertUpdateRecord($updateMainOwnershipFlatArray, 'ownership_flat_id', 'tbl_ownership_flat', 1,'',array(),array(),$ownershipFlatUpdateArray);
                }
            }

            if($type == TRANSFERRED && $ownershipFlatId == ''){

                $updateParentOwnershipFlatArray = array('is_latest' => 0, 'ownership_flat_id' => $parentOwnershipFlatId);

                $ownershipFlatUpdateData = array();
                if(!empty($parentOwnershipFlatId)){
                    $ownershipFlatUpdateData = $this->ownership_flat_model->getOwnershipFlatData(array(
                        'ownership_flat_id' => $parentOwnershipFlatId,
                    ));
                    $ownershipFlatUpdateArray = compareArray($updateParentOwnershipFlatArray,$ownershipFlatUpdateData);

                    $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                        'ownership_flat_id' => $parentOwnershipFlatId,
                        'is_multiple' => 1
                    ));

                    if(!empty($ownershipFlatMemberData)){
                        $ownerFlatArray = array();
                        foreach($ownershipFlatMemberData as $ownershipFlatMemberElement){
                            $ownerFlatArray[] = array(
                                'ownership_flat_member_id' => $ownershipFlatMemberElement['ownership_flat_member_id'],
                                'is_transferred' => 1,
                            );
                        }
                        if(!empty($ownerFlatArray)){
                            $this->ownership_flat_model->batchUpdate($ownerFlatArray, "ownership_flat_member_id", 'tbl_ownership_flat_member');
                        }
                        $ownershipFlatMemberIdArray = array_column($ownershipFlatMemberData, 'ownership_flat_member_id');
                        $deviceData = $this->common_web_service_model->deviceData(array(
                            'user_type_id' => $ownershipFlatMemberIdArray,
                            'user_type' => MEMBER_APP,
                            'is_multiple' => 1
                        ));
                        $deviceArray = array();
                        if(!empty($deviceData)){
                            foreach($deviceData as $deviceElement){
                                $deviceArray[] = array(
                                    'user_device_info_id' => $deviceElement['user_device_info_id'],
                                    'is_deleted' => 1,
                                );
                            }
                            if(!empty($deviceArray)){
                                $this->ownership_flat_model->batchUpdate($deviceArray, "user_device_info_id", MASTER_DB.'.tbl_user_device_info');
                            }
                        }
                    }
                }

                $this->ownership_flat_model->insertUpdateRecord($updateParentOwnershipFlatArray, 'ownership_flat_id', 'tbl_ownership_flat', 1,'',array(),array(),$ownershipFlatUpdateArray);

                $parentMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                    'type' => array('ownership_flat','transferred'),
                    'type_id' => $parentOwnershipFlatId,
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'society_id' => $this->session->get('society_id'),
                ));

                $parentMemberIdArr = array();
                if(!empty($parentMemberData)){
                    foreach ($parentMemberData as $pKey => $pValue) {
                        $parentMemberIdArr['member_id'][] = $pValue['member_id'];
                    }
                }

                // printArray($parentMemberIdArr,1);

                if(!empty($parentMemberIdArr)){
                    // delete old member data
                    $this->ownership_flat_model->deleteUserIdRecords($parentMemberIdArr);
                }

                // update rentals id if flat is on rental
                $rentalsData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                    'type' => 'rentals',
                    'type_id' => $parentOwnershipFlatId,
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'society_id' => $this->session->get('society_id'),
                ));

                $rentalsUpdateArr = array();
                if(!empty($rentalsData)){
                    foreach ($rentalsData as $key => $value) {
                        $rentalsUpdateArr[] = array(
                            'ownership_flat_member_id' => $value['ownership_flat_member_id'],
                            // 'society_id' => $value['society_id'],
                            'type_id' => $lastOwnershipFlatId,
                        );
                    }
                }

                if(!empty($rentalsUpdateArr)){
                    $this->ownership_flat_model->batchUpdate($rentalsUpdateArr, "ownership_flat_member_id", 'tbl_ownership_flat_member',$rentalsUpdateArr);
                }
            }

            // member-Data 
            $filterMemberIdArr = array_filter($filterMobileNoArray, function($value, $key) {
                return !empty($value);
            }, ARRAY_FILTER_USE_BOTH);

            $memberDetailsData = array();
            if($filterMemberIdArr) {
                $memberDetailsData = array_reduce($this->ownership_flat_model->getMemberData(array(
                    'phone' => $filterMemberIdArr,
                    'is_multiple' => 1
                )), function($carry, $item) {
                    $carry[$item['member_id']] = $item;
                    return $carry;
                }, []);
            }

            // printArray($memberDetailsData,1);

            $memberDetailUpdateArray = array();
            $memberDetailInsertArray = array();
            $ownershipFlatMemberDetailInsertArray = array();
            $ownershipFlatMemberDetailUpdateArray = array();
            $insertUpdateOwnershipFlatMemberDetailArr = array();
            if (!empty($memberIdArray)) {
                foreach ($memberIdArray as $mkey => $memberId) {
                    $ownershipFlatMemberId = array_key_exists($mkey, $ownershipFlatMemberIdArray) ? $ownershipFlatMemberIdArray[$mkey] : '';
                    $name = array_key_exists($mkey, $nameArray) ? $nameArray[$mkey] : '';
                    $emailId = array_key_exists($mkey, $emailIdArray) ? $emailIdArray[$mkey] : '';
                    $mobileNo = array_key_exists($mkey, $mobileNoArray) ? $mobileNoArray[$mkey] : '';
                    $gender = array_key_exists($mkey, $genderArray) ? $genderArray[$mkey] : '';
                    $birthDate = array_key_exists($mkey, $birthDateArray) ? $birthDateArray[$mkey] : '';
                    $bloodGroup = array_key_exists($mkey, $bloodGroupArray) ? $bloodGroupArray[$mkey] : '';
                    $relation = array_key_exists($mkey, $relationArray) ? $relationArray[$mkey] : '';
                    $commonMemberImage = array_key_exists($mkey, $commonMemberImageArray) ? $commonMemberImageArray[$mkey] : '';
                    // $foodLike = array_key_exists($mkey, $foodLikeArray) ? $foodLikeArray[$mkey] : '';
                    $isOwner = isset($isOwnerArray) && array_key_exists($mkey, $isOwnerArray) ? $isOwnerArray[$mkey] : '';

                    if ($memberId == '' && array_key_exists($mkey, $nameArray)) {
                        $memberSlug = random_string();
                        $memberDetailInsertArray[$mkey] = array(
                            'member_id' => '',
                            'name' => $name,
                            'email_id' => $emailId,
                            // 'mobile_no' => $mobileNo,
                            'gender' => $gender,
                            'birth_date' => DMYToYMD($birthDate),
                            'blood_group' => $bloodGroup,
                            // 'relation' => $relation,
                            // 'food_like' => $foodLike,
                            // 'is_owner' => isset($isOwner) ? $isOwner : 0,
                            'member_image' => array_key_exists($mkey, $ownershipFlatResult) ? $ownershipFlatResult[$mkey]['file_name'] : '',
                            'member_slug' => $memberSlug,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );


                        // printArray($memberDetailInsertArray,1);
                        
                    } else {
                        if(isset($memberDetailsData[$memberId])){
                            $memberSlug = $memberDetailsData[$memberId]['member_slug'];
                        }

                        $memberDetailUpdateArray[$mkey] = array(
                            'member_id' => $memberId,
                            'member_slug' => $memberSlug,
                            'name' => $name,
                            'email_id' => $emailId,
                            // 'mobile_no' => $mobileNo,
                            'gender' => $gender,
                            'birth_date' => DMYToYMD($birthDate),
                            'blood_group' => $bloodGroup,
                            // 'relation' => $relation,
                            // 'status' => 'approved',
                            // 'food_like' => $foodLike,
                            // 'is_owner' => isset($isOwner) ? $isOwner : 0,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d H:i:s"),
                        );

                        if (array_key_exists($mkey, $ownershipFlatResult)) {
                            $ownershipFlatResponse = $this->ownership_flat_model->getMemberData(array("member_id" => $memberId));
                            $imageUrl = '';
                            if (isset($ownershipFlatResponse['member_image']) && $ownershipFlatResponse['member_image'] != '') {
                                $imageUrl = FLAT_MEMBER_IMAGE_PATH . $ownershipFlatResponse['member_image'];
                            }
                            if (file_exists($imageUrl)) {
                                unlink($imageUrl);
                            }
                            $thumbnailImageUrl = '';
                            if (isset($ownershipFlatResponse['member_image']) && $ownershipFlatResponse['member_image'] != '') {
                                $thumbnailImageUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatResponse['member_image'];
                            }
                            if (file_exists($thumbnailImageUrl)) {
                                unlink($thumbnailImageUrl);
                            }
                            $memberDetailUpdateArray[$mkey]['member_image'] = $ownershipFlatResult[$mkey]['file_name'];
                        }
                        else{
                            $memberDetailUpdateArray[$mkey]['member_image'] = $commonMemberImage; 
                        }

                        // if (array_key_exists($mkey, $ownershipFlatResult)) {
                        //     $ownershipFlatResponse = $this->ownership_flat_model->getMemberData(array("member_id" => $memberId));
                        //     $imageUrl = '';
                        //     if (isset($ownershipFlatResponse['member_image']) && $ownershipFlatResponse['member_image'] != '') {
                        //         $imageUrl = FLAT_MEMBER_IMAGE_PATH . $ownershipFlatResponse['member_image'];
                        //     }
                        //     if (file_exists($imageUrl)) {
                        //         unlink($imageUrl);
                        //     }

                        //     $thumbnailImageUrl = '';
                        //     if (isset($ownershipFlatResponse['member_image']) && $ownershipFlatResponse['member_image'] != '') {
                        //         $thumbnailImageUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatResponse['member_image'];
                        //     }
                        //     if (file_exists($thumbnailImageUrl)) {
                        //         unlink($thumbnailImageUrl);
                        //     }
                        //     $memberDetailUpdateArray[$mkey]['member_image'] = $ownershipFlatResult[$mkey]['file_name'];
                        // }
                    }

                    if($ownershipFlatMemberId == '' ){
                        $ownershipFlatMemberDetailInsertArray[$mkey] = array(
                            'ownership_flat_member_id' => '',
                            'ownership_flat_id' => $lastOwnershipFlatId,
                            'member_id' => $memberId,
                            'member_slug' => $memberSlug,
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type' => 'ownership_flat',
                            'type_id' => $lastOwnershipFlatId,
                            'is_owner' => isset($isOwner) ? $isOwner : 0,
                            'relation' => $relation,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $ownershipFlatMemberDetailUpdateArray[$mkey] = array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'ownership_flat_id' => $lastOwnershipFlatId,
                            'member_id' => $memberId,
                            'member_slug' => $memberSlug,
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type' => 'ownership_flat',
                            'type_id' => $lastOwnershipFlatId,
                            'is_owner' => isset($isOwner) ? $isOwner : 0,
                            'relation' => $relation,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    }

                    $insertUpdateOwnershipFlatMemberDetailArr[$memberSlug] = array(
                        'member_slug' => $memberSlug,
                        'mobile_no' => $mobileNo,
                    );

                        
                    }
                }

                 // printArray($memberDetailUpdateArray,1);
                $memberExtraDataArray = array();
                $memberExtraDataArray['module_id'] = $lastOwnershipFlatId;
                $memberExtraDataArray['module'] = 'Ownership Flat Member';
                $memberExtraDataArray['type'] = 'Ownership Flat';
                // $memberExtraDataArray['old_data'] = ;
                $memberExtraDataArray['user_id'] = $this->data['userId'];
                // $memberExtraDataArray['society_id'] = $this->session->get('society_id');

                // printArray($memberDetailInsertArray);
                // printArray($memberDetailUpdateArray);
                // printArray($ownershipFlatMemberDetailInsertArray);
                // printArray($ownershipFlatMemberDetailUpdateArray,1);

                if (!empty($memberDetailInsertArray)) {
                    $this->ownership_flat_model->batchInsert($memberDetailInsertArray, MASTER_DB.'.tbl_member',$memberExtraDataArray);
                }
                if (!empty($memberDetailUpdateArray)) {
                    $this->ownership_flat_model->batchUpdate($memberDetailUpdateArray, 'member_id', MASTER_DB.'.tbl_member');
                }

                if (!empty($ownershipFlatMemberDetailInsertArray)) {
                    $this->ownership_flat_model->batchInsert($ownershipFlatMemberDetailInsertArray, 'tbl_ownership_flat_member',$memberExtraDataArray);
                }
                if (!empty($ownershipFlatMemberDetailUpdateArray)) {
                    $this->ownership_flat_model->batchUpdate($ownershipFlatMemberDetailUpdateArray, "ownership_flat_member_id", 'tbl_ownership_flat_member',$memberExtraDataArray);
                }

                $this->ownership_flat_model->updateMemberId();

            $oldOwnershipFlatMobileNoArray = array();
            $memberMobileMap = [];
            $oldOwnershipFlatMemberIdArray = array();

            $groupData = $this->common_web_service_model->getGroupsData([
                'group_id' => $resourceTypeMemberData['group_id'],
                'society_id' => $this->session->get('society_id'),
            ]);
            $groupId = $groupData['id'] ?? '';
            $permissions = $groupData['permissions'] ?? '';
            $permissionArray = unserialize($permissions);
            $permissionLabel = [];
            $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
            
            foreach ($controllers_methods as $controller_name => $methods_arr) {
                foreach ($methods_arr as $method) {
                    $methodDisplay = is_array($method) ? reset($method) : $method;
                    $methodActual = is_array($method) ? key($method) : $method;
                    $inputName = "$controller_name|$methodActual";
                    $permissionLabel[] = "$inputName|dt|$controller_name|dt|$methodDisplay";
                }
            }

            $ownershipFlatMemberInsertData = $this->ownership_flat_model->getOwnershipFlatMemberData([
                'ownership_flat_id' => $lastOwnershipFlatId,
                'type' => 'ownership_flat',
                'is_multiple' => 1,
                'society_id' => $this->session->get('society_id'),
            ]);

            // 

            // printArray($ownershipFlatMemberInsertData,1);
            // adding mobile No's
            foreach ($ownershipFlatMemberInsertData as $key => $value) {
                $ownershipFlatMemberInsertData[$key]['mobile_no'] = $insertUpdateOwnershipFlatMemberDetailArr[$value['member_slug']]['mobile_no'];
            }

            $oldMemberArr = array();
            foreach ($oldOwnershipFlatMemberData as $oKey => $oldMember) {
                $oldmemberComboKey = $oldMember['society_id'].'|'.$oldMember['ownership_flat_member_id'];
                $oldMemberArr[$oldmemberComboKey] = $oldMember;
            }
            

            $tblUsrInsertArr = [];
            $tblUsrUpdateArr = [];
            $tblUsrSocietyInsertArr = [];
            $tblUsrSocietyUpadteArr = [];
            $tblUsrGroupArr = [];
            $tblUsrPermissionArr = [];
            $deleteUserArr = [];
            $deleteMemberIdArr = [];
            $deleteUserIdArr = [];
            $deleteUserSocietyIdArr = [];

            $existsUserDataArr = array();
            $existsUserMobileNoWiseArr = array();
            if(!empty($existsUserData)){
                foreach($existsUserData as $existsUser) {
                    $comboKey = $existsUser['society_id']."|".$existsUser['resource_type_id']."|".$existsUser['type_id'];
                    $existsUserDataArr[$comboKey] = $existsUser;
                    $existsUserMobileNoWiseArr[$existsUser['phone']][] = $existsUser;
                }
            }

            $existsUserMemberDataArr = array();
            if(!empty($existsUserMemberData)){
                foreach($existsUserMemberData as $existsUserMember){
                    $comboKey=$existsUserMember['society_id']."|".$existsUserMember['resource_type_id']."|".$existsUserMember['type_id'];
                    $existsUserMemberDataArr[$comboKey] = $existsUserMember;
                }
            }

            foreach($ownershipFlatMemberInsertData as $newMember){
                $newMemberComboKey = $newMember['society_id']."|".$newMember['resource_type_id']."|".$newMember['member_id'];
                $newComboKey = $newMember['society_id']."|".$newMember['ownership_flat_member_id'];

                if(empty($existsUserData)){
                    // New User
                    $password = PASSWORD;
                    $slug = random_string();
                    $slugSociety = random_string();
                    if(!empty($newMember['mobile_no'])){
                        $tblUsrInsertArr[] = [
                            'username' => $newMember['email_id'],
                            'email' => $newMember['email_id'],
                            'first_name' => $newMember['name'],
                            // 'phone' => $newMember['mobile_no'],
                            'user_type_id' => $newMember['member_id'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'password' => $this->ionAuthModel->hashPassword($password),
                            'active' => 1,
                            'slug' => $slug,
                        ];
                
                        $tblUsrGroupArr[] = [
                            'id' => '',
                            'group_id' => $groupId,
                            'slug' => $slug,
                            'society_slug' => $slugSociety,
                        ];
                
                        $tblUsrSocietyInsertArr[] = [
                            'user_society_id' => '',
                            'society_id' => $this->session->get('society_id'),
                            'phone' => $newMember['mobile_no'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type_id' => $newMember['member_id'],
                            'slug' => $slug,
                            'is_active' => 1,
                            'society_slug' => $slugSociety,
                        ];
                
                        foreach ($permissionLabel as $labelData) {
                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                            if (in_array($permissionValue, $permissionArray)) {
                                $tblUsrPermissionArr[] = [
                                    'controller_name' => $controller,
                                    'permission_name' => $permissionValue,
                                    'permission_label' => $label,
                                    'group_id' => $resourceTypeMemberData['group_id'],
                                    'slug' => $slug,
                                    'society_slug' => $slugSociety,
                                    'created_at' => date('Y-m-d H:i:s'),
                                    'created_by' => $this->session->get('user_id'),
                                    'updated_at' => date('Y-m-d H:i:s'),
                                    'updated_by' => $this->session->get('user_id'),
                                ];
                            }
                        }
                    }
                }
                else {
                    // phone no update
                    if(isset($existsUserDataArr[$newMemberComboKey])){
                        $userSocietyId = $existsUserDataArr[$newMemberComboKey]['user_society_id'];
                        $userSocietyMemberId = $existsUserDataArr[$newMemberComboKey]['type_id'];
                        if($newMember['mobile_no'] != $existsUserDataArr[$newMemberComboKey]['phone']){
                            if(empty($newMember['mobile_no'])){
                                $deleteUserSocietyIdArr[] = $userSocietyMemberId;
                            } else {
                                $tblUsrSocietyUpadteArr[] = array(
                                    'user_society_id' => $userSocietyId,
                                    'phone' => $newMember['mobile_no'],
                                );
                            }
                        }
                        continue;
                    }

                    // member id changed
                    if(isset($oldMemberArr[$newComboKey])){
                        $oldMemberId = $oldMemberArr[$newComboKey]['member_id'];
                        $newMemberId = $newMember['member_id'];
                        // $oldMemberComboKey = $oldMemberArr[$newComboKey]['society_id'].'|'.$oldMemberArr[$newComboKey]['resource_type_id'].'|'.$oldMemberArr[$newComboKey]['member_id'];
                        // $oldUserSocietyId = $existsUserDataArr[$oldMemberComboKey]['user_society_id'];
                        if($oldMemberId != $newMemberId){
                            $deleteUserSocietyIdArr[] = $oldMemberId;
                        }
                    }

                    if(isset($existsUserMobileNoWiseArr[$newMember['mobile_no']])){
                        // new entry if not in user society
                        if(!isset($existsUserMemberDataArr[$newMemberComboKey])) {
                            $password = PASSWORD;
                            $slugSociety = random_string();
                            // $slug = $existsUserMemberDataArr[$newMemberComboKey]['slug'];
                            $slug = $existsUserMobileNoWiseArr[$newMember['mobile_no']][0]['slug'];
                            $tblUsrGroupArr[] = [
                                'id' => '',
                                'group_id' => $groupId,
                                'slug' => $slug,
                                'society_slug' => $slugSociety,
                            ];
                    
                            $tblUsrSocietyInsertArr[] = [
                                'user_society_id' => '',
                                'society_id' => $this->session->get('society_id'),
                                'phone' => $newMember['mobile_no'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $newMember['member_id'],
                                'slug' => $slug,
                                'is_active' => 1,
                                'society_slug' => $slugSociety,
                            ];
                    
                            foreach ($permissionLabel as $labelData) {
                                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                if (in_array($permissionValue, $permissionArray)) {
                                    $tblUsrPermissionArr[] = [
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'group_id' => $resourceTypeMemberData['group_id'],
                                        'slug' => $slug,
                                        'society_slug' => $slugSociety,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'created_by' => $this->session->get('user_id'),
                                        'updated_at' => date('Y-m-d H:i:s'),
                                        'updated_by' => $this->session->get('user_id'),
                                    ];
                                }
                            }
                        }
                    } else {
                        // New User
                        $password = PASSWORD;
                        $slug = random_string();
                        $slugSociety = random_string();
                        if(!empty($newMember['mobile_no'])){
                            $tblUsrInsertArr[] = [
                                'username' => $newMember['email_id'],
                                'email' => $newMember['email_id'],
                                'first_name' => $newMember['name'],
                                // 'phone' => $newMember['mobile_no'],
                                'user_type_id' => $newMember['member_id'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'password' => $this->ionAuthModel->hashPassword($password),
                                'active' => 1,
                                'slug' => $slug,
                            ];
                    
                            $tblUsrGroupArr[] = [
                                'id' => '',
                                'group_id' => $groupId,
                                'slug' => $slug,
                                'society_slug' => $slugSociety,
                            ];
                    
                            $tblUsrSocietyInsertArr[] = [
                                'user_society_id' => '',
                                'society_id' => $this->session->get('society_id'),
                                'phone' => $newMember['mobile_no'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $newMember['member_id'],
                                'slug' => $slug,
                                'is_active' => 1,
                                'society_slug' => $slugSociety,
                            ];
                    
                            foreach ($permissionLabel as $labelData) {
                                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                if (in_array($permissionValue, $permissionArray)) {
                                    $tblUsrPermissionArr[] = [
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'group_id' => $resourceTypeMemberData['group_id'],
                                        'slug' => $slug,
                                        'society_slug' => $slugSociety,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'created_by' => $this->session->get('user_id'),
                                        'updated_at' => date('Y-m-d H:i:s'),
                                        'updated_by' => $this->session->get('user_id'),
                                    ];
                                }
                            }
                        }
                    }
                }
            }
            

            // Execute all batch operations
            if (!empty($tblUsrUpdateArr)) {
                $this->resource_model->batchUpdate($tblUsrUpdateArr, 'id', MASTER_DB.'.tbl_users');
            }
            if (!empty($tblUsrInsertArr)) {
                $this->resource_model->batchInsert($tblUsrInsertArr, MASTER_DB.'.tbl_users');
            }
            if (!empty($tblUsrGroupArr)) {
                $this->resource_model->batchInsert($tblUsrGroupArr, MASTER_DB.'.tbl_users_groups');
            }
            if (!empty($tblUsrSocietyInsertArr)) {
                $this->resource_model->batchInsert($tblUsrSocietyInsertArr, MASTER_DB.'.tbl_user_society');
            }
            if (!empty($tblUsrSocietyUpadteArr)) {
                $this->resource_model->batchUpdate($tblUsrSocietyUpadteArr,'user_society_id', MASTER_DB.'.tbl_user_society');
            }
            if (!empty($tblUsrPermissionArr)) {
                $this->resource_model->batchInsert($tblUsrPermissionArr, MASTER_DB.'.tbl_user_permission');
            }
            if (!empty($deleteUserSocietyIdArr)) {
                $this->ownership_flat_model->deleteUserIdRecords(array(
                    'member_id' => $deleteUserSocietyIdArr,
                ));
            }
            
            // Refresh mapping IDs
            $this->resource_type_model->updateUserGroupId();
            $this->resource_type_model->updateUserSocietyId();
            $this->resource_type_model->updateUserPermissionId();
            $this->resource_type_model->updateUserPermissionSocietyId();
            $this->resource_type_model->updateUserSocietyGroupId();



            if (!empty($ownershipFlatEmergencyContactIdArray)) {
                foreach ($ownershipFlatEmergencyContactIdArray as $ecKey => $ownershipFlatEmergencyContactId) {
                    $ecName = array_key_exists($ecKey, $ecNameArray) ? $ecNameArray[$ecKey] : '';
                    $ecPlace = array_key_exists($ecKey, $ecPlaceArray) ? $ecPlaceArray[$ecKey] : '';
                    $ecRelation = array_key_exists($ecKey, $ecRelationArray) ? $ecRelationArray[$ecKey] : '';
                    $ecMobileNo = array_key_exists($ecKey, $ecMobileNoArray) ? $ecMobileNoArray[$ecKey] : '';

                    if ($ownershipFlatEmergencyContactId == '' && array_key_exists($ecKey, $ecNameArray)) {
                        $contactDetailInsertArray[$ecKey] = array(
                            'ownership_flat_emergency_contact_id' => '',
                            // 'ownership_flat_id' => $lastOwnershipFlatId,
                            'type' => 'ownership_flat',
                            'type_id' => $lastOwnershipFlatId,
                            'name' => $ecName,
                            'place' => $ecPlace,
                            'relation' => $ecRelation,
                            'mobile_no' => $ecMobileNo,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $contactDetailUpdateArray[$ecKey] = array(
                            'ownership_flat_emergency_contact_id' => $ownershipFlatEmergencyContactId,
                            // 'ownership_flat_id' => $lastOwnershipFlatId,
                            'type' => 'ownership_flat',
                            'type_id' => $lastOwnershipFlatId,
                            'name' => $ecName,
                            'place' => $ecPlace,
                            'relation' => $ecRelation,
                            'mobile_no' => $ecMobileNo,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    }
                }

                $emergencyContactExtraDataArray = array();
                $emergencyContactExtraDataArray['module_id'] = $lastOwnershipFlatId;
                $emergencyContactExtraDataArray['module'] = 'Ownership Flat Emergency Contact';
                $emergencyContactExtraDataArray['type'] = 'Ownership Flat';
                $emergencyContactExtraDataArray['old_data'] = $oldOwnershipFlatEmergencyContactData;
                $emergencyContactExtraDataArray['user_id'] = $this->data['userId'];
                $emergencyContactExtraDataArray['society_id'] = $this->session->get('society_id');
                if (!empty($contactDetailInsertArray)) {
                    $this->ownership_flat_model->batchInsert($contactDetailInsertArray, 'tbl_ownership_flat_emergency_contact',$emergencyContactExtraDataArray);
                }
                if (!empty($contactDetailUpdateArray)) {
                    $this->ownership_flat_model->batchUpdate($contactDetailUpdateArray, "ownership_flat_emergency_contact_id", 'tbl_ownership_flat_emergency_contact',$emergencyContactExtraDataArray);
                }
            }

            if (!empty($ownershipFlatParkingIdArray)) {
                foreach ($ownershipFlatParkingIdArray as $pKey => $ownershipFlatParkingId) {
                    $vehicleType = isset($vehicleTypeArray) && array_key_exists($pKey, $vehicleTypeArray) ? $vehicleTypeArray[$pKey] : '';
                    $parkingSlotId = array_key_exists($pKey, $parkingSlotIdArray) ? $parkingSlotIdArray[$pKey] : '';
                    $vehicleNo = array_key_exists($pKey, $vehicleNoArray) ? $vehicleNoArray[$pKey] : '';
                    // $parkingSlotNo = array_key_exists($pKey, $parkingSlotNoArray) ? $parkingSlotNoArray[$pKey] : '';
                    $tokenNo = array_key_exists($pKey, $tokenNoArray) ? $tokenNoArray[$pKey] : '';
                    $isElectric = array_key_exists($pKey, $isElectricArray) ? $isElectricArray[$pKey] : '';

                    if ($ownershipFlatParkingId == '' && (isset($vehicleTypeArray) && array_key_exists($pKey, $vehicleTypeArray))) {
                        $parkingDetailInsertArray[$pKey] = array(
                            'ownership_flat_parking_id' => '',
                            'ownership_flat_id' => $lastOwnershipFlatId,
                            'type' => 'ownership_flat',
                            'type_id' => $lastOwnershipFlatId,
                            'vehicle_type' => $vehicleType,
                            'parking_slot_id' => $parkingSlotId,
                            'vehicle_no' => $vehicleNo,
                            // 'parking_slot_no' => $parkingSlotNo,
                            'token_no' => $tokenNo,
                            'is_electric' => $isElectric,
                            'vehicle_image' => array_key_exists($pKey, $ownershipParkingResult) ? $ownershipParkingResult[$pKey]['file_name'] : 0,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $parkingDetailUpdateArray[$pKey] = array(
                            'ownership_flat_parking_id' => $ownershipFlatParkingId,
                            'ownership_flat_id' => $lastOwnershipFlatId,
                            'type' => 'ownership_flat',
                            'type_id' => $lastOwnershipFlatId,
                            'vehicle_type' => $vehicleType,
                            'parking_slot_id' => $parkingSlotId,
                            'vehicle_no' => $vehicleNo,
                            // 'parking_slot_no' => $parkingSlotNo,
                            'token_no' => $tokenNo,
                            'is_electric' => $isElectric,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        if (array_key_exists($pKey, $ownershipParkingResult)) {
                            $ownershipFlatParkingResponse = $this->ownership_flat_model->getOwnershipFlatParkingData(array("ownership_flat_parking_id" => $ownershipFlatParkingId));
                            $imageUrl = '';
                            if (isset($ownershipFlatParkingResponse['vehicle_image']) && $ownershipFlatParkingResponse['vehicle_image'] != '') {
                                $imageUrl = VEHICLE_IMAGE_PATH . $ownershipFlatParkingResponse['vehicle_image'];
                            }
                            if (file_exists($imageUrl)) {
                                unlink($imageUrl);
                            }
                            $thumbnailImageUrl = '';
                            if (isset($ownershipFlatParkingResponse['vehicle_image']) && $ownershipFlatParkingResponse['vehicle_image'] != '') {
                                $thumbnailImageUrl = THUMBNAIL_VEHICLE_IMAGE_PATH . $ownershipFlatParkingResponse['vehicle_image'];
                            }
                            if (file_exists($thumbnailImageUrl)) {
                                unlink($thumbnailImageUrl);
                            }
                            $parkingDetailUpdateArray[$pKey]['vehicle_image'] = $ownershipParkingResult[$pKey]['file_name'];
                        }

                        $parkingSlotUpdateArray = array(
                            'parking_slot_id' => $parkingSlotId,
                            'ownership_flat_parking_id' => $ownershipFlatParkingId,
                        );

                        $this->ownership_flat_model->insertUpdateRecord($parkingSlotUpdateArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
                    }

                }
                $parkingExtraDataArray = array();
                $parkingExtraDataArray['module_id'] = $lastOwnershipFlatId;
                $parkingExtraDataArray['module'] = 'Ownership Flat Parking Detail';
                $parkingExtraDataArray['type'] = 'Ownership Flat';
                $parkingExtraDataArray['old_data'] = $oldOwnershipFlatParkingData;
                $parkingExtraDataArray['user_id'] = $this->data['userId'];
                $parkingExtraDataArray['society_id'] = $this->session->get('society_id');

                if (!empty($parkingDetailInsertArray)) {
                    $this->ownership_flat_model->batchInsert($parkingDetailInsertArray, 'tbl_ownership_flat_parking',$parkingExtraDataArray);
                }
                if (!empty($parkingDetailUpdateArray)) {
                    $this->ownership_flat_model->batchUpdate($parkingDetailUpdateArray, "ownership_flat_parking_id", 'tbl_ownership_flat_parking',$parkingExtraDataArray);
                }
            }


            $moduleDocumentUpdateArray = array();
            $documentIdArray = $this->request->getVar('document_id');
            $moduleDocumentIdArray = $this->request->getVar('module_document_id');
            $inputBoxArray = $this->request->getVar('input_box');
            $documentExpiryDateArray = $this->request->getVar('document_expiry_date');
            if (!empty($moduleDocumentIdArray)) {
                foreach ($moduleDocumentIdArray as $fkey => $moduleDocumentId) {
                    $moduleDocumentsId = array_key_exists($fkey, $moduleDocumentIdArray) ? $moduleDocumentIdArray[$fkey] : 0;
                    $documentId = array_key_exists($fkey, $documentIdArray) ? $documentIdArray[$fkey] : 0;
                    $moduleDocumentImage = array_key_exists($fkey, $imageResultArray) ? $imageResultArray[$fkey] : [];
                    $inputBox = (isset($inputBoxArray) && array_key_exists($fkey, $inputBoxArray)) ? $inputBoxArray[$fkey] : 0;
                    $documentExpiryDate = (isset($documentExpiryDateArray) && array_key_exists($fkey, $documentExpiryDateArray)) ? $documentExpiryDateArray[$fkey] : 0;
                    $moduleDocumentInsertArray = array(
                        'module_document_id' => $moduleDocumentsId,
                        'module_id' => $lastOwnershipFlatId,
                        'module' => 'ownership_flat',
                        'document_id' => $documentId,
                        'input_box' => $inputBox,
                        'document_expiry_date' => $documentExpiryDate,
                    );
                    if(!empty($moduleDocumentId)){
                        $documentUpdateData = $this->staff_model->getDocument(array(
                            'module_document_id' => $moduleDocumentId,
                        ));
                        $moduleDocumentUpdateArray = compareArray($moduleDocumentInsertArray,$documentUpdateData);
                        $moduleDocumentUpdateArray['type'] = 'Ownership Flat';
                        $moduleDocumentUpdateArray['type_id']  = $lastOwnershipFlatId;
                    }


                    $moduleDocumentData = $this->ownership_flat_model->insertUpdate($moduleDocumentInsertArray, 'module_document_id', 'tbl_module_document', 1,$moduleDocumentUpdateArray);

                    $lastModuleDocumentId = $moduleDocumentData['lastInsertedId'];

                    // printArray($moduleDocumentImage);
                    $imageDataArray = array();
                    if(!empty($moduleDocumentImage)){
                        unset($imageResultArray['success']);
                        foreach ($moduleDocumentImage as  $mdImageElement){
                            $imageDataArray[] = array(
                                'module_document_image_id' =>   '',
                                'module_id' => $lastOwnershipFlatId,
                                'module' => 'ownership_flat',
                                'module_document_id' => $lastModuleDocumentId,
                                'document_id' => $documentId,
                                'document_image' => isset($mdImageElement['file_name']) ? $mdImageElement['file_name'] : "",
                                'created_at' => date('Y-m-d H:i:s'),
                                'updated_at' => date('Y-m-d H:i:s'),
                                'created_by' => $this->data['userId'],
                                'updated_by' => $this->data['userId']
                            );
                        }

                        $mediaExtraDataArray = array();
                        $mediaExtraDataArray['module_id'] = $lastOwnershipFlatId;
                        $mediaExtraDataArray['module'] = 'Ownership Flat Document Image';
                        $mediaExtraDataArray['type'] = 'Ownership Flat';
                        $mediaExtraDataArray['old_data'] = array();
                        $mediaExtraDataArray['user_id'] = $this->data['userId'];
                        $mediaExtraDataArray['society_id'] = $this->session->get('society_id');
                        $this->ownership_flat_model->batchInsert($imageDataArray, 'tbl_module_document_image',$mediaExtraDataArray);
                    }
                }
            }


            $transactionStatus = $this->db->transComplete();
            $transactionCentralStatus = $this->centralDB->transComplete();
            if (isset($ownershipFlatId) && $ownershipFlatId != '') {
                if (($ownershipFlatData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('OwnershipFlat.ownership_flat'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('OwnershipFlat.ownership_flat'));
                }
            } else {
                if (($ownershipFlatData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('OwnershipFlat.ownership_flat'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('OwnershipFlat.ownership_flat'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $ownershipFlatId  = $this->request->getVar('ownership_flat_id');
        $type = $this->request->getVar('type');
        $status = $this->request->getVar('status');
        if($type == TRANSFERRED) {
            //$this->lang->load("transferred_flat");
        }
        else{
            //$this->lang->load("ownership_flat");
        }

        $return = $this->ownership_flat_model->statusChange($ownershipFlatId,$status,'ownership_flat_id','tbl_ownership_flat');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('OwnershipFlat.ownership_flat'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('OwnershipFlat.ownership_flat'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $this->centralDB->transStart();
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $ids = is_array($ownershipFlatId) ? implode(',', $ownershipFlatId) : $ownershipFlatId;
        $type = $this->request->getVar('type');

        if($type == TRANSFERRED) {
            if (!$this->dt_ci_acl->checkAccess("TransferredFlat|delete")) {
                return redirect()->to('Admin/Dashboard');
            }
        }
        else{
        }

        $ownershipFlatCheck = $this->ownership_flat_model->getOwnershipFlatData(array(
            'ownership_flat_id' => $ownershipFlatId,
            "is_multiple"=>1,
        ));

        $flatIdArray = array();

        $transferredFlatDeleteArrar = array();
        if(!empty($ownershipFlatCheck)){
            foreach($ownershipFlatCheck as $ownershipFlatElement){
                $flatIdArray[] = $ownershipFlatElement['flat_id'];
                if($ownershipFlatElement['type'] == TRANSFERRED){
                    $transferredFlatDeleteArrar[]= $ownershipFlatElement['flat_no'];
                }
            }
        }

        if (!empty($transferredFlatDeleteArrar)) {
            $flatNo = implode(",", $transferredFlatDeleteArrar);
            $response['success'] = false;
            $response['msg'] = 'Flat '. $flatNo . " Transferred So Can't Deleted." ;
            echo json_encode($response);
            exit;
        }


        $ownerRentalCreateArr = array();
        if(!empty($flatIdArray)){
            $flatIdArray = array_unique($flatIdArray);

            $rentalFlatData = $this->rentals_model->getRentalsData(array(
                'flat_id'=> $flatIdArray,
                'is_multiple' => 1
            ));

            if(!empty($rentalFlatData)){
                foreach($rentalFlatData as $rentalFlatElement){
                    $ownerRentalCreateArr[]= $rentalFlatElement['flat_no'];
                }
            }
        }

        if (!empty($ownerRentalCreateArr)) {
            $flatNo = implode(",", $ownerRentalCreateArr);
            $response['success'] = false;
            $response['msg'] = 'Flat '. $flatNo . " Rental Created So Can't Deleted." ;
            echo json_encode($response);
            exit;
        }

        $moduleDocumentImageData = $this->staff_model->getDocumentImage(array(
            "module_id" => $ownershipFlatId,
            "module" => 'ownership_flat',
            "is_multiple" =>1,
        ));
        if(is_array($moduleDocumentImageData) && !empty($moduleDocumentImageData)){
            foreach ($moduleDocumentImageData as $image){
                $FileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }

        $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
            //'ownership_flat_id' => $ownershipFlatId,
            'type' => 'ownership_flat',
            'type_id' => $ownershipFlatId,
            'is_multiple' => 1,
            'is_active' => 1
        ));

        $deleteMemberIdArr = array(); 

        if(is_array($ownershipFlatMemberData) && !empty($ownershipFlatMemberData)){
            foreach ($ownershipFlatMemberData as $image){
                $FileUrl = '';
                if(isset($image['member_image']) && $image['member_image'] != '') {
                    $FileUrl = FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['member_image']) && $image['member_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }

                $deleteMemberIdArr[] = $image['member_id'];
            }
        }

        $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
            //'ownership_flat_id' => $ownershipFlatId,
            'type' => 'ownership_flat',
            'type_id' => $ownershipFlatId,
            'is_multiple' => 1
        ));

        if(is_array($ownershipFlatParkingData) && !empty($ownershipFlatParkingData)){
            foreach ($ownershipFlatParkingData as $image){
                $FileUrl = '';
                if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                    $FileUrl = VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }


        $ownershipFlat=$this->ownership_flat_model->getOwnershipFlatData(array(
            "type"=>'transferred',
            "ownership_flat_id" => $ids,
            "is_multiple"=>1,
        ));
        if(count($ownershipFlat) > 0){
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.reference_other_module');
            echo json_encode($response);
            exit;
        };

        $ownershipFlatData = $this->ownership_flat_model->deleteRecord($ownershipFlatId);
        $deleteUserData = $this->ownership_flat_model->deleteUserIdRecords(array(
            'member_id' => $deleteMemberIdArr,
        ));
        $transactionStatus = $this->db->transComplete();
        $transactionCentralStatus = $this->centralDB->transComplete();
        if (($deleteUserData && $ownershipFlatData) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("OwnershipFlat.ownership_flat"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("OwnershipFlat.ownership_flat"));
        }
        echo json_encode($response);
        exit;
    }

    public function addOwnershipFlatMemberRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $memberRow = view('Admin/OwnershipFlat/OwnershipFlatMemberRowView', $data);
        echo $memberRow;
    }

    public function deleteOwnershipFlatMemberRow()
    {
        $this->db->transBegin();
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');

        $isOwnerMemberIdArray = array();
        $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
            'type_id' => $ownershipFlatId,
            'type' => 'ownership_flat',
            'is_owner' => 1,
            'is_multiple' => 1
        ));
        if(!empty($ownershipFlatMemberData)){
            foreach($ownershipFlatMemberData as $ownershipFlatMemberElement){
                array_push($isOwnerMemberIdArray,$ownershipFlatMemberElement['ownership_flat_member_id']);
            }
        }
        $isOwnerResultArray = array_diff($isOwnerMemberIdArray, $ownershipFlatMemberId);

        if(count($isOwnerResultArray) == 0){
            $response['success'] = false;
            $response['msg'] = "You Can't Delete These Record Atleast One Flat Member Should Be Selected As Owner";
            echo json_encode($response);
            exit;
        }

        $ownershipFlatMemberDeleteData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
            'ownership_flat_member_id' => $ownershipFlatMemberId,
            'is_multiple' => 1
        ));

        if(is_array($ownershipFlatMemberDeleteData) && !empty($ownershipFlatMemberDeleteData)){
            foreach ($ownershipFlatMemberDeleteData as $image){
                $FileUrl = '';
                if(isset($image['member_image']) && $image['member_image'] != '') {
                    $FileUrl = FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['member_image']) && $image['member_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }

        $type = $this->request->getVar('type');
        if($type == TRANSFERRED) {
            //$this->lang->load("transferred_flat");
        }
        else{
           // $this->lang->load("ownership_flat");
        }
        $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
            'type' => 'member',
            'type_id' => $ownershipFlatMemberId,
            'society_id' => $this->session->get('society_id'),
            // 'is_multiple' => 1
        ));

        // printArray($userSocietyData,1);

        if(!empty($userSocietyData)){  
            // if(count($userSocietyData) == 1){
                $this->common_web_service_model->deleteUserSocietyFlatRecord($userSocietyData['user_society_id'],$this->data['userId']);
            // }
        }
        $ownershipFlatMemberData = $this->ownership_flat_model->deleteOwnershipFlatMemberRecord($ownershipFlatMemberId);

        if ($ownershipFlatMemberData) {
            if(!empty($ownershipFlatMemberId)){
                foreach($ownershipFlatMemberId as $documentElement){
                    $deleteDataArray['module'] = 'Ownership Flat Member';
                    $deleteDataArray['activity'] = "Ownership Flat Member Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Ownership Flat Member Deleted [OwnershipFlatMemberID: ' . $documentElement . ']',$this->data['userId'],'Ownership Flat Member',$documentElement,json_encode($deleteDataArray),'','Ownership Flat',$ownershipFlatId);
                }
            }
            $this->db->transCommit();
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('OwnershipFlat.ownership_flat_member'));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('OwnershipFlat.ownership_flat_member'));
        }
        echo json_encode($response);
        exit();
    }

    public function addOwnershipFlatEmergencyContactRow()
    {
        $data['contact_row_number'] = $this->request->getVar("contact_row_number");
        $contactRow = view('Admin/OwnershipFlat/OwnershipFlatEmergencyContactRowView', $data);
        echo $contactRow;
    }

    public function deleteOwnershipFlatEmergencyContactRow()
    {
        $this->db->transBegin();
        $ownershipFlatEmergencyContactId = $this->request->getVar('ownership_flat_emergency_contact_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $type = $this->request->getVar('type');
        if($type == TRANSFERRED) {
            //$this->lang->load("transferred_flat");
        }
        else{
            //$this->lang->load("ownership_flat");
        }
        $ownershipFlatEmergencyData = $this->ownership_flat_model->deleteOwnershipFlatContactRecord($ownershipFlatEmergencyContactId);

        if ($ownershipFlatEmergencyData) {
            if(!empty($ownershipFlatEmergencyContactId)){
                foreach($ownershipFlatEmergencyContactId as $documentElement){
                    $deleteDataArray['module'] = 'Ownership Flat Emergency Contact';
                    $deleteDataArray['activity'] = "Ownership Flat Emergency Contact Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Ownership Flat Emergency Contact Deleted [OwnershipFlatEmergencyContactID: ' . $documentElement . ']',$this->data['userId'],'Ownership Flat Emergency Contact',$documentElement,json_encode($deleteDataArray),'','Ownership Flat',$ownershipFlatId);
                }
            }
            $this->db->transCommit();
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('OwnershipFlat.ownership_flat_contact'));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('OwnershipFlat.ownership_flat_contact'));
        }
        echo json_encode($response);
        exit();
    }

    public function addOwnershipFlatParkingRow()
    {
        $data['parking_row_number'] = $this->request->getVar("parking_row_number");
        $parkingRow = view('Admin/OwnershipFlat/OwnershipFlatParkingRowView', $data);
        echo $parkingRow;
    }

    public function deleteOwnershipFlatParkingRow()
    {
        $this->db->transBegin();
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');

        $ownershipFlatParkingDeleteData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
            //'ownership_flat_id' => $ownershipFlatId,
            // 'type' => 'ownership_flat',
            'ownership_flat_parking_id' => $ownershipFlatParkingId,
            'is_multiple' => 1
        ));

        if(is_array($ownershipFlatParkingDeleteData) && !empty($ownershipFlatParkingDeleteData)){
            foreach ($ownershipFlatParkingDeleteData as $image){
                $FileUrl = '';
                if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                    $FileUrl = VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }
        $type = $this->request->getVar('type');
        if($type == TRANSFERRED) {
            //$this->lang->load("transferred_flat");
        }
        else{
            //$this->lang->load("ownership_flat");
        }
        $ownershipFlatParkingData = $this->ownership_flat_model->deleteOwnershipFlatParkingRecord($ownershipFlatParkingId);

        if ($ownershipFlatParkingData) {

            if(!empty($ownershipFlatParkingId)){
                foreach($ownershipFlatParkingId as $documentElement){
                    $deleteDataArray['module'] = 'Ownership Flat Parking';
                    $deleteDataArray['activity'] = "Ownership Flat Parking Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Ownership Flat Parking Deleted [OwnershipFlatParkingID: ' . $documentElement . ']',$this->data['userId'],'Ownership Flat Parking',$documentElement,json_encode($deleteDataArray),'','Ownership Flat',$ownershipFlatId);
                }
            }

            $this->db->transCommit();
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('OwnershipFlat.ownership_flat_parking'));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('OwnershipFlat.ownership_flat_parking'));
        }
        echo json_encode($response);
        exit();
    }

    public function addOwnershipFlatAccessCardRow()
    {
        $data['access_card_row_number'] = $this->request->getVar("access_card_row_number");
        $accessCardRow = view('Admin/OwnershipFlat/OwnershipFlatAccessCardRowView', $data);
        echo $accessCardRow;
    }

    public function deleteOwnershipFlatAccessCardRow()
    {
        $this->db->transBegin();
        $moduleAccessCardTokenId = $this->request->getVar('module_access_card_token_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $type = $this->request->getVar('type');

        $ownershipFlatParkingData = $this->ownership_flat_model->deleteModuleAccessCardTokenRecord($moduleAccessCardTokenId);

        if ($ownershipFlatParkingData) {

            if(!empty($moduleAccessCardTokenId)){
                foreach($moduleAccessCardTokenId as $documentElement){
                    $deleteDataArray['module'] = 'Ownership Flat Access Card';
                    $deleteDataArray['activity'] = "Ownership Flat Access Card Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Ownership Flat Access Card Deleted [OwnershipFlatAccessCardID: ' . $documentElement . ']',$this->data['userId'],'Ownership Flat Access Card',$documentElement,json_encode($deleteDataArray),'','Ownership Flat',$ownershipFlatId);
                }
            }

            $this->db->transCommit();
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('OwnershipFlat.ownership_flat_access_card'));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('OwnershipFlat.ownership_flat_access_card'));
        }
        echo json_encode($response);
        exit();
    }

    public function getOwnershipFlatMemberDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $flatId = $this->request->getVar('flat_id');
        $parentOwnershipFlatId = $this->request->getVar('parent_ownership_flat_id');
        $filterData = array(
            'ownership_flat_member_id' => $ownershipFlatMemberId,
            'flat_id' => $flatId,
            'filter_param' => $filterParameter,
            'parent_ownership_flat_id' => $parentOwnershipFlatId,
            'page' => $page,
            'is_active'=> 1,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->ownership_flat_model->getOwnershipFlatMember($filterData);
    }

    public function getOwnershipMemberDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $flatId = $this->request->getVar('flat_id');
        $filterData = array(
            'ownership_flat_member_id' => $ownershipFlatMemberId,
            'flat_id' => $flatId,
            'filter_param' => $filterParameter,
            'is_latest' => 1,
            'is_owner' => 1,
            'page' => $page,
            'is_active'=> 1,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->ownership_flat_model->getOwnerMember($filterData);
    }

    public function getAllOwnershipFlatMemberDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $flatId = $this->request->getVar('flat_id');
        $parentOwnershipFlatId = $this->request->getVar('parent_ownership_flat_id');
        $filterData = array(
            'ownership_flat_member_id' => $ownershipFlatMemberId,
            'flat_id' => $flatId,
            'filter_param' => $filterParameter,
            'parent_ownership_flat_id' => $parentOwnershipFlatId,
            'page' => $page,
            'is_active'=> 1,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->ownership_flat_model->getAllOwnershipFlatMember($filterData);
    }

    public function getOwnershipFlatParkingDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $flatId = $this->request->getVar('flat_id');
        $vehicleType = $this->request->getVar('vehicle_type');
        $filterData = array(
            'ownership_flat_parking_id' => $ownershipFlatParkingId,
            'flat_id' => $flatId,
            'filter_param' => $filterParameter,
            'vehicle_type' => $vehicleType,
            'page' => $page,
            'is_active'=> 1,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->ownership_flat_model->getOwnershipFlatParking($filterData);
    }

    public function getOwnershipFlatDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');

        $rentalId = $this->request->getVar('rental_id');
        $isRentalFlat = $this->request->getVar('is_rental_flat');

        $filterData = array(
            'ownership_flat_id' => $ownershipFlatId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active'=> 1,
            'is_rental_flat' =>  $isRentalFlat,
            'rental_id' =>  $rentalId,
        );

        echo $this->ownership_flat_model->getOwnershipFlat($filterData);
    }

    public function flatData()
    {
        $validation = \Config\Services::validation();
        $flatId = $this->request->getVar('flat_id');
        $validation->setRule('flat_id', lang('OwnershipFlat.flat'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $response['success'] = false;
            $response['msg'] = "Please Select  ".lang('flat')." First";
            echo json_encode($response);
            exit;
        } else {

            $flatData = $this->flat_model->getFlatData(array('flat_id' => $flatId ));

            $data['flat_data'] = $flatData;
            $flatDataModal = view('Admin/OwnershipFlat/FlatDetailView', isset($data) ? $data : array());
            $response['success'] = true;
            $response['flat_modal_data'] = $flatDataModal;
            echo json_encode($response);
            exit;

        }
    }

    public function view($id = null)
    {
        $ownershipFlatId = $this->request->getVar("view_id");
        $type = $this->request->getVar("view_module");

        if($type == TRANSFERRED) {
            $langAlias = 'TransferredFlat.';
        }
        else{
            $langAlias = 'OwnershipFlat.';
        }
        if(($ownershipFlatId == "" && $ownershipFlatId == null) && $type != TRANSFERRED){
            return redirect()->to('Admin/OwnershipFlat?type=first_owner');
        }
        else if(($ownershipFlatId == "" && $ownershipFlatId == null) && $type == TRANSFERRED){
            return redirect()->to('Admin/OwnershipFlat?type=transferred');
        }
        else {
            $id = $ownershipFlatId;
            $filterData = array(
                "ownership_flat_id" => $ownershipFlatId
            );
            $ownershipFlatData = $this->ownership_flat_model->getOwnershipFlatData($filterData);

            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));

            $ownershipFlatEmergencyContactData = $this->ownership_flat_model->getOwnershipFlatEmergencyData(array(
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));
            $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));
            // $ownershipFlatAccessCardData = $this->ownership_flat_model->getModuleAccessCardData(array(
            //     'type' => 'ownership_flat',
            //     'type_id' => $ownershipFlatId,
            //     'is_multiple' => 1
            // ));

            // $moduleAccessCardTokenIdArray = array();
            // if (!empty($ownershipFlatAccessCardData)) {
            //     foreach ($ownershipFlatAccessCardData as $accessCardElement) {
            //         array_push($moduleAccessCardTokenIdArray,$accessCardElement['module_access_card_token_id']);
            //     }
            // }

            // $ownershipFlatAccessCardVehicleTypeData = array();
            // $ofacvtTypeIdWiseArray = array();
            // if(!empty($moduleAccessCardTokenIdArray)){
            //     $ownershipFlatAccessCardVehicleTypeData = $this->ownership_flat_model->getModuleAccessCardVehicleTypeData(array(
            //         'module_access_card_token_id' => $moduleAccessCardTokenIdArray,
            //         'is_multiple' => 1
            //     ));


            //     if(!empty($ownershipFlatAccessCardVehicleTypeData)){
            //         foreach($ownershipFlatAccessCardVehicleTypeData  as $ofacvKey => $ownershipFlatAccessCardVehicleTypeElement){
            //             $ofacvtTypeIdWiseArray[$ownershipFlatAccessCardVehicleTypeElement['module_access_card_token_id']][] = $ownershipFlatAccessCardVehicleTypeElement;
            //         }
            //     }
            // }

            // if(!empty($ownershipFlatAccessCardData)){
            //     foreach($ownershipFlatAccessCardData as $ofacKey => $ownershipFlatAccessCardElement){
            //         $ownershipFlatAccessCardData[$ofacKey]['vehicle_data'] = array_key_exists($ownershipFlatAccessCardElement['module_access_card_token_id'],$ofacvtTypeIdWiseArray) ? $ofacvtTypeIdWiseArray[$ownershipFlatAccessCardElement['module_access_card_token_id']]: array();
            //     }
            // }

            // $data['ownership_flat_access_card_data'] = $ownershipFlatAccessCardData;
            // printArray($data['ownership_flat_access_card_data'],1);

            $documentData = $this->document_model->getDocumentData(array(
                'document_for' => 'ownership_flat',
                'is_active' => 1,
                'is_multiple' => 1,
            ));
            if(!empty($documentData)){
                foreach ($documentData as $key => $displayData) {
                    $documentImageData = $this->staff_model->getDocumentImage(array(
                        "document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
                        'module_id' => $ownershipFlatId,
                        'module' => 'ownership_flat',
                        "is_multiple" => 1,
                    ));
                    $documentData[$key]['module_image_data'] = $documentImageData;
                }
            }
            $data['document_data'] = $documentData;
            $data['type'] = $type;
            $data['ownership_flat_data'] = $ownershipFlatData;
            $data['ownership_flat_emergency_contact_data'] = $ownershipFlatEmergencyContactData;
            $data['ownership_flat_parking_data'] = $ownershipFlatParkingData;
            // $data['ownership_flat_access_card_data'] = $ownershipFlatAccessData;
            $data['ownership_flat_member_data'] = $ownershipFlatMemberData;
            $ownershipFlatView = view("Admin/OwnershipFlat/OwnershipFlatModelView", $data);

            $response['view_title'] = lang($langAlias.'ownership_flat_detail');
            $response['view_detail'] = $ownershipFlatView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }


    public function excelExportOwnershipFlat()
    {
        $type = $this->request->getVar('type');
        $purchasedFrom = '';
        if($type == TRANSFERRED) {
            $ownershipFlatLang = 'TransferredFlat.';
            $purchasedFrom = 'TransferredFlat.seller';
        }
        else{
            $ownershipFlatLang = 'OwnershipFlat.';
            $purchasedFrom = 'OwnershipFlat.purchased_from';
        }

        $fileName =lang($ownershipFlatLang.'file_name') . DATETIMEFORMAT;
        $sheetName = lang($ownershipFlatLang.'sheet_name') . DATEFORMAT;
        $excelHeaderName = lang($ownershipFlatLang.'ownership_flat');
        $tableData = $this->getOwnershipFlatListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang($ownershipFlatLang.'flat_no'),
            lang($ownershipFlatLang.'index_no'),
            lang($ownershipFlatLang.'date_of_registry'),
            lang($ownershipFlatLang.'buyer'),
            lang($purchasedFrom),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["excel_flat_no"],
                $row["index_no"],
                $row["date_of_registry"],
                $row["buyer_name"],
                $row["purchased_from"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'G';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function pdf($id = null, $view = null,$save_bufffer = null,$zipPdf = 0)
    {
        if(empty($id)){
            $response['success'] = false;
            $response['msg'] = lang('OwnershipFlat.ownership_flat_data_required');
            echo json_encode($response);
            exit;
        }
        $filterData = array(
            "ownership_flat_id" => $id,
            'is_multiple' => 1
        );
        $ownershipFlatData = $this->ownership_flat_model->getOwnershipFlatData($filterData);

        if(!empty($ownershipFlatData)) {
            foreach ($ownershipFlatData as $ofkey => $ownershipFlat) {

                if( ($ownershipFlat['is_latest'] == 1 && $ownershipFlat['type'] == TRANSFERRED) ){
                    $langAilas = 'TransferredFlat.';
                } else {
                    $langAilas = 'OwnershipFlat.';
                }

                $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                    'type_id' => $ownershipFlat['ownership_flat_id'],
                    'type'=> 'ownership_flat',
                    'is_multiple' => 1
                ));
                $data['ownership_flat_member_data'] = $ownershipFlatMemberData;


                $ownershipFlatEmergencyContactData = $this->ownership_flat_model->getOwnershipFlatEmergencyData(array(
                    'type_id' => $ownershipFlat['ownership_flat_id'],
                    'type'=> 'ownership_flat',
                    'is_multiple' => 1
                ));
                $data['ownership_flat_emergency_contact_data'] = $ownershipFlatEmergencyContactData;

                $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                    'type_id' => $ownershipFlat['ownership_flat_id'],
                    'type'=> 'ownership_flat',
                    'is_multiple' => 1
                ));
                
                $data['ownership_flat_parking_data'] = $ownershipFlatParkingData;

                $societyData = $this->society_model->getSocietyData(array(
                    "society_id" => isset($societyData['society_id']) ? $societyData['society_id'] : "-1",
                ));
                $data['society_data'] = $societyData;

                $data['ownership_flat_data'] = $ownershipFlat;
                // printArray($data['ownership_flat_data'],1);
                $data['name'] = lang("OwnershipFlat.ownership_flat_pdf_name") . "_" . str_replace('/', '_', $data['ownership_flat_data']['flat_no']) . ".pdf";

                $printHeader = '';
                $printFooter = '';

                $signatureDetails = array(
                    "created_by" => isset($ownershipFlat['created_by']) ? $ownershipFlat['created_by'] : "",
                    "approved_by" =>  "",
                    "document_number" => isset($ownershipFlat['flat_no'])  ? lang("OwnershipFlat.ownership_flat")."# ".$ownershipFlat['flat_no']  : "",
                    "document_date" => isset($ownershipFlat['created_at']) ? siteDateFormat($ownershipFlat['created_at']) : "",
                    "print_for" => "Ownership Flat",
                );
                if (isset($ownershipFlat['ownership_flat_id'])) {
                    $printFooter = pdfFooter( 1, $signatureDetails);
                }
                $data['lang_name']= $langAilas;
                $html = view('Admin/OwnershipFlat/pdf/OwnershipFlatPdfView', $data);
                // echo($html);
                // die();
                generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');

            }
        }
    }

    public function transferredFlatPdf($id = null, $view = null,$save_bufffer = null,$zipPdf = 0)
    {
        if(empty($id)){
            $response['success'] = false;
            $response['msg'] = lang('TransferredFlat.ownership_flat_data_required');
            echo json_encode($response);
            exit;
        }
        $filterData = array(
            "ownership_flat_id" => $id,
            'is_multiple' => 1
        );
        $ownershipFlatData = $this->ownership_flat_model->getOwnershipFlatData($filterData);
        if(!empty($ownershipFlatData)) {
            foreach ($ownershipFlatData as $ofkey => $ownershipFlat) {

                if( ($ownershipFlat['is_latest'] == 1 && $ownershipFlat['type'] == TRANSFERRED)  ){
                    $langAilas = 'TransferredFlat.';
                } else {
                    $langAilas = 'OwnershipFlat.';
                }

                $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                    'type_id' => $ownershipFlat['ownership_flat_id'],
                    'type'=> 'ownership_flat',
                    'is_multiple' => 1
                ));
                $data['ownership_flat_member_data'] = $ownershipFlatMemberData;


                $ownershipFlatEmergencyContactData = $this->ownership_flat_model->getOwnershipFlatEmergencyData(array(
                    'type_id' => $ownershipFlat['ownership_flat_id'],
                    'type'=> 'ownership_flat',
                    'is_multiple' => 1
                ));
                $data['ownership_flat_emergency_contact_data'] = $ownershipFlatEmergencyContactData;

                $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                    'type_id' => $ownershipFlat['ownership_flat_id'],
                    'type'=> 'ownership_flat',
                    'is_multiple' => 1
                ));
                $data['ownership_flat_parking_data'] = $ownershipFlatParkingData;

                $societyData = $this->society_model->getSocietyData(array(
                    "society_id" => isset($societyData['society_id']) ? $societyData['society_id'] : "-1",
                ));
                $data['society_data'] = $societyData;

                $data['ownership_flat_data'] = $ownershipFlat;
                $data['name'] = lang("OwnershipFlat.ownership_flat_pdf_name") . "_" . str_replace('/', '_', $data['ownership_flat_data']['flat_no']) . ".pdf";

                $printHeader = '';
                $printFooter = '';

                $signatureDetails = array(
                    "created_by" => isset($ownershipFlat['created_by']) ? $ownershipFlat['created_by'] : "",
                    "approved_by" =>  "",
                    "document_number" => isset($ownershipFlat['flat_no'])  ? lang("TransferredFlat.ownership_flat")."# ".$ownershipFlat['flat_no']  : "",
                    "document_date" => isset($ownershipFlat['created_at']) ? siteDateFormat($ownershipFlat['created_at']) : "",
                    "print_for" => "Ownership Flat",
                );
                if (isset($ownershipFlat['ownership_flat_id'])) {
                    $printFooter = pdfFooter( 1, $signatureDetails);
                }
                $data['lang_name']= $langAilas;
                $html = view('Admin/OwnershipFlat/pdf/OwnershipFlatPdfView', $data);

                generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');

            }
        }
    }

    public function addEditMember(){
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $userId = $this->request->getVar('user_id');
        $mobileNo = $this->request->getVar('mobile_no');
        if(!empty($mobileNo)){
            $existsResourceData = $this->resource_model->getResourceData(array(
                "resource_mobile_no" => $mobileNo,
                "society_id" => $this->session->get('society_id'),
            ));
            
            if(!empty($existsResourceData)) {
                $response['success'] = false;
                $response['msg'] = lang('OwnershipFlat.mobile_no_already_used_resource');
                echo json_encode($response);
                exit;
            }
    
            // Get manager Data
            $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER);
            $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

            if(!empty($resourceTypeManagerData)){
                $userManagerDataArray = $this->common_web_service_model->getUserSocietyData(array(
                    'phone' => $mobileNo,
                    'resource_type_id' => $resourceTypeManagerId,
                    'is_multiple' => 1 
                ));
            }
    
            if(!empty($userManagerDataArray)){
                $response['success'] = false;
                $response['msg'] = lang('OwnershipFlat.mobile_no_already_used_manager');
                echo json_encode($response);
                exit;
            }
    
            // get member data
            $userMemberDataArray = $this->common_web_service_model->getUserSocietyData(array(
                'phone' => $mobileNo,
                'is_member' => 1,
                // 'is_multiple' => 1,
            ));

            // printArray($userMemberDataArray,1);
        }

        if(!empty($userMemberDataArray)) {
            $response['success'] = false;
            $response['msg'] = lang('OwnershipFlat.mobile_no_already_used_member');
            $response['data'] = $userMemberDataArray;
            echo json_encode($response);
            exit;
        }

        $response['success'] = true;
        $response['msg'] = "No Data Found";
        echo json_encode($response);
        exit;
    }

    public function sendOtp(){

        $memberId = $this->request->getVar('member_id');
        $mobileNo = $this->request->getVar('mobile_no');

        $memberInsertUpdateArr = array(
            "member_id" => $memberId,
            "mobile_no" => $mobileNo,
            "otp" => OTP_CODE,
            "otp_validity" => OTP_VALIDITY,
            "is_otp_verified" => 0,
        );

        if(!empty($memberInsertUpdateArr)) {
            $memberInsertData = $this->ownership_flat_model->insertUpdateRecord($memberInsertUpdateArr, 'member_id', MASTER_DB.'.tbl_member', 1,'',array(),array());
            $lastMemberInsertId = $memberInsertData['lastInsertedId'];
        }

        if($memberInsertData['success']){
            $response['success'] = true;
            $response['msg'] = "OTP Send Successfully";
            echo json_encode($response);
            exit;
        } else {
            $response['success'] = false;
            $response['msg'] = "OTP Not sent!!";
            echo json_encode($response);
            exit;
        }
    }

    public function verifyOtp(){

        $memberId = $this->request->getVar('member_id');
        $otp = $this->request->getVar('otp');

        if(empty($otp)){
            $response['success'] = false;
            $response['msg'] = "OTP Is Required!";
            echo json_encode($response);
            exit;
        }

        $otpData = $this->ownership_flat_model->getMemberData(array(
            "member_id" => $memberId,
        ));

        if(!empty($otpData)){
            if($otpData['otp'] == $otp && (date('Y-m-d H:i:s') <= $otpData['otp_validity'])){
                $memberInsertUpdateArr = array(
                    "member_id" => $memberId,
                    "is_otp_verified" => 1,
                );
            } else {
                $response['success'] = false;
                $response['msg'] = "Invalid OTP!!";
                echo json_encode($response);
                exit;
            }
        } else {
            $response['success'] = false;
            $response['msg'] = "Member Not Found!!";
            echo json_encode($response);
            exit;
        }

        $lastMemberInsertId = "";
        if(!empty($memberInsertUpdateArr)) {
            $memberInsertData = $this->ownership_flat_model->insertUpdateRecord($memberInsertUpdateArr, 'member_id', MASTER_DB.'.tbl_member', 1,'',array(),array());
            $lastMemberInsertId = $memberInsertData['lastInsertedId'];
            
            $memberData =  $this->ownership_flat_model->getMemberData(array(
                "member_id" => $lastMemberInsertId,
            ));
        }


        if($memberInsertData['success']){
            $response['success'] = true;
            $response['msg'] = "OTP Verified Successfully";
            $response['member_data'] = $memberData;
            echo json_encode($response);
            exit;
        } else {
            $response['success'] = true;
            $response['msg'] = "OTP Not Verified!!";
            echo json_encode($response);
            exit;
        }
    }
}
