<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
class Notification extends BaseController
{
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Notification';
        $notificationType = $this->request->getVar("type");
        $actionType = $this->request->getVar("action_type");
        $notificationTypeId = $this->request->getVar("type_id");
        $dataFilters['filters'] = array(
            array(
                "type" => "notification_type",
                "id" => "notification_type",
                "name" => "notification_type",
                "title" => "Notification.notification_type",
                "selected" => $notificationType,
            ),
            array(
                "type" => "action_type",
                "id" => "action_type",
                "name" => "action_type",
                "title" => "Notification.action_type",
                "selected" => $actionType,
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['type_id'] = $notificationTypeId;
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Notification/NotificationView",$data);
    }

    public function getNotificationListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $actionType = $this->request->getVar("action_type");
        $notificationType = $this->request->getVar("notification_type");
        $notificationTypeId = $this->request->getVar("notification_type_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $updatedAt = $this->request->getVar("filter_updated_at");

        $this->datatables->table("tbl_notification as tn");
        $this->datatables->select("tn.notification_id,tn.notification_title,tn.created_at,tn.updated_at,tn.description,tn.notification_date,tn.notification_for,tn.send_for_notification, tn.receive_for_notification,tn.type");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tn.action_type");

        $this->datatables->select("(CASE WHEN tn.receive_for_notification = 'gate_keeper' THEN COALESCE(tresource.resource_name, '') 
                                    WHEN tn.receive_for_notification = 'member' THEN  COALESCE(tm.name, '') 
                                    WHEN tn.receive_for_notification = 'admin' THEN  COALESCE(tuser.first_name, '') 
                                    END) as receive_for_notification_name");

        $this->datatables->select("(CASE WHEN tn.send_for_notification = 'gate_keeper' THEN COALESCE(tresourcesend.resource_name, '') 
                                    WHEN tn.send_for_notification = 'member' THEN  COALESCE(tmsend.name, '') 
                                    WHEN tn.send_for_notification = 'admin' THEN  COALESCE(tusersend.first_name, '') 
                                    END) as send_for_notification_name");

        $this->datatables->select("(CASE 
                                    WHEN tn.type = 'banner' THEN COALESCE(tb.banner_title, '') 
                                    WHEN tn.type = 'poll' THEN COALESCE(tp.poll_title, '') 
                                    WHEN tn.type = 'forum' THEN COALESCE(tf.title, '') 
                                    WHEN tn.type = 'amenities' THEN COALESCE(ta.amenities_name, '') 
                                    WHEN tn.type = 'sos_emergency' THEN COALESCE(tse.description, '') 
                                    WHEN tn.type = 'Test Notification' THEN 'Test Notification'
                                    WHEN tn.type = 'resource' THEN COALESCE(tr.resource_name, '') 
                                    WHEN tn.type = 'complain' THEN COALESCE(tc.complain_title, '') 
                                    WHEN tn.type IN ('visitor', 'delivery_boy', 'taxi') THEN COALESCE(tv.visitor_name, '')
                                    END) as type_name");

        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tn.updated_by AND tupdate.society_id = tn.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tn.created_by AND tcreate.society_id = tn.society_id","left");

        $this->datatables->join("tbl_resource as tresource","tresource.resource_id = tn.receive_for_notification_id AND tn.receive_for_notification='gate_keeper'","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tuser","tuser.id = tn.receive_for_notification_id AND tn.receive_for_notification='admin' AND tuser.society_id = tn.society_id","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tn.receive_for_notification_id AND tn.receive_for_notification='member'","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");

        $this->datatables->join("tbl_resource as tresourcesend","tresourcesend.resource_id = tn.send_for_notification_id AND tn.send_for_notification='gate_keeper'","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tusersend","tusersend.id = tn.send_for_notification_id AND tn.send_for_notification='admin' AND tusersend.society_id = tn.society_id","left");
        $this->datatables->join("tbl_ownership_flat_member as tofmsend","tofmsend.ownership_flat_member_id = tn.send_for_notification_id AND tn.send_for_notification='member'","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tmsend", "tmsend.member_id = tofmsend.member_id",  "left");

        $this->datatables->join("tbl_banner as tb", "tb.banner_id = tn.type_id AND tn.type = 'banner'", "left");
        $this->datatables->join("tbl_poll as tp", "tp.poll_id = tn.type_id AND tn.type = 'poll'", "left");
        $this->datatables->join("tbl_forum as tf", "tf.forum_id = tn.type_id AND tn.type = 'forum'", "left");
        $this->datatables->join("tbl_amenities as ta", "ta.amenities_id = tn.type_id AND tn.type = 'amenities'", "left");
        $this->datatables->join("tbl_sos_emergency as tse", "tse.sos_emergency_id = tn.type_id AND tn.type = 'sos_emergency'", "left");
        $this->datatables->join("tbl_complain as tc", "tc.complain_id = tn.type_id AND tn.type = 'complain'", "left");
        $this->datatables->join("tbl_visitor as tv", "tv.visitor_id = tn.type_id AND tn.type IN ('delivery_boy', 'visitor', 'taxi')", "left");
        $this->datatables->join("tbl_resource as tr", "tr.resource_id = tn.type_id AND tn.type = 'resource'", "left");
        $this->datatables->groupBy("tn.notification_id");
        accessFilter($this->datatables, array("society" => "tn.society_id"));

        if (isset($actionType) && !empty($actionType)) {
            $this->datatables->where("tn.action_type", $actionType);
        }

        if (isset($notificationType) && !empty($notificationType)) {
            $this->datatables->where("tn.type", $notificationType);
        }
        
        if(isset($notificationTypeId) && !empty($notificationTypeId)) {
            if(is_array($notificationTypeId)){
                $this->datatables->whereIn("tn.type_id",$notificationTypeId);
            } else {
                $this->datatables->where("tn.type_id",$notificationTypeId);
            }
        }
        
        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tn.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tn.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tn.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tn.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tn.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tn.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }


        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
                $data[$key]['notification_date'] = isValidDate($displayData['notification_date']) ? siteDateFormat($displayData['notification_date']) : "";
                $data[$key]['type'] = underscoreToUcWord($displayData['type']);
                $data[$key]['action_type'] = underscoreToUcWord($displayData['action_type']);
                $data[$key]['send_for_notification'] = underscoreToUcWord($displayData['send_for_notification']);
                $data[$key]['receive_for_notification'] = underscoreToUcWord($displayData['receive_for_notification']);
                $data[$key]['notification_for'] = underscoreToUcWord($displayData['notification_for']);
            }
        }

        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
}
