<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\MemberModel;
use App\Models\SocietyModel;

class Member extends BaseController
{
    protected $member_model;
    public function __construct() {
        $this->member_model = new MemberModel();
        $this->society_model = new SocietyModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Member';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonAreaDd",
                "id" => "filter_common_area_id",
                "name" => "filter_common_area_id",
                "title" => "Member.common_area",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "itemDd",
                "id" => "filter_item_id",
                "name" => "filter_item_id",
                "title" => "Member.item",
            ),
        
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Member/MemberView",$data);
    }

    public function getMemberListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $itemId = $this->request->getVar("filter_item_id");
        $societyId = $this->session->get("society_id");

        $this->datatables->table(MASTER_DB.".tbl_member as tm");

        $this->datatables->select("tm.member_id,tm.name,tm.email_id,tus.phone,tm.gender,tm.birth_date");
        $this->datatables->select("tus.phone");
        $this->datatables->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tm.member_id AND tus.society_id = $societyId","left");
        
        $this->datatables->groupBy("tm.member_id");
        $this->datatables->where("tus.society_id",$societyId);

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData) {
                $data[$key]['gender'] = isset($displayData['gender']) ? underscoreToUcWord($displayData['gender']) : "-";
                $data[$key]['birth_date'] = isValidDate($displayData['birth_date']) ? siteDateFormat($displayData['birth_date']) : "-";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function excelExportMember()
    {
        $fileName ='itembalance-' . DATETIMEFORMAT;
        $sheetName = 'Member-' . DATEFORMAT;
        $excelHeaderName = 'Member';
        $tableData = $this->getMemberListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Member.item_name'),
            lang('Member.common_area_name'),
            lang('Member.actual_quantity'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["item_name"],
                $row["common_area_name"],
                $row["actual_quantity"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function itemBalancePdf()
    {
        if(!$this->dt_ci_acl->checkAccess('Member|pdf')){
            return show_error(NO_ACCESS_SECTION);
        } else {
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            
            $filterData = array(
                'member_id' => $this->session->get('member_id'),
                'is_multiple' => 1, 
            );
            $itemBalanceData = $this->member_model->getMemberData($filterData);
            $groupedData = array();
            foreach ($itemBalanceData as $item) {
            $commonAreaName = $item['common_area_name'];
            if (!isset($groupedData[$commonAreaName])) {
                $groupedData[$commonAreaName] = array();
            }
            $groupedData[$commonAreaName][] = $item;
            }

            $data['society_data'] = $societyData;
            $data['member_data'] = $groupedData;
            // printArray($groupedData,1);

            $data['name'] = lang("Member.member_pdf") . ".pdf";
            $printHeader = '';
            $printFooter = '';
            $printFooter = pdfFooter( 0, array());
            $html = view('Admin/Member/pdf/MemberPdfView', $data);
            // echo($html);
            // die();
            generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
        }
    }
}