<?php

namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\MeetingModel;
use App\Models\OwnershipFlatModel;
use App\Models\RentalsModel;

class Meeting extends BaseController
{
    protected $meeting_model;
    protected $ownership_flat_model;
    protected $rental_model;
    public function __construct() {
        $this->meeting_model = new MeetingModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->rental_model = new RentalsModel();
    }
	public function index()
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Meeting';
        return $this->dt_ci_template->load("Admin","Meeting/MeetingView",$data);
	}

    public function manage($meetingId = '')
    {

        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($meetingId != '') {
            $filterData = array(
                "meeting_id" => $meetingId
            );
            $data['meeting_data'] = $this->meeting_model->getMeetingData($filterData);

            $data['record_data'] = $this->meeting_model->getMeetingRecordData(array(
                "meeting_id" => $meetingId,
                "is_multiple" => 1
            ));

            if (empty($data['meeting_data'])) {
                return redirect()->to('Admin/Meeting');
            }
        }
        if ($meetingId != '') {
            $data['title'] = 'Edit Meeting';
        } else {
            $data['title'] = 'Add Meeting';
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        if ((isset($data['meeting_data']['society_id']) && $data['meeting_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Meeting');
        }
        return $this->dt_ci_template->load("Admin","Meeting/MeetingManageView",$data);
    }
    public function getMeetingListing($return = false,$filterData=array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_meeting as tm");
		$this->datatables->select("tm.meeting_id,tm.meeting_title,tm.meeting_agenda,tm.meeting_date_time,tm.society_id,ts.society_name,tm.is_active");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tm.created_at,tm.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tm.updated_by AND tupdate.society_id = tm.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tm.created_by AND tcreate.society_id = tm.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tm.society_id","left");
        accessFilter($this->datatables, array("society" => "tm.society_id"));
		$this->datatables->groupBy("tm.meeting_id");
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"meeting_id" => isset($data[$key]['meeting_id']) ? $data[$key]['meeting_id'] : ""
				);
				$data[$key]['action_button'] = meetingActionButton($actionButtonFilter);
                $data[$key]['meeting_date_time'] = isValidDate($data[$key]['meeting_date_time']) ? siteDateFormat($data[$key]['meeting_date_time'],true) : "";
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
                // $data[$key]['meeting_record'] = ($data[$key]['meeting_record'] != '' && file_exists(MEETING_RECORD_PATH . $data[$key]['meeting_record'])) ? base_url() . MEETING_RECORD_PATH . $data[$key]['meeting_record'] : "";
			}
		}
		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}   
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $meetingId = $this->request->getVar('meeting_id');
        $meetingTitle = $this->request->getVar('meeting_title');
        $meetingDateTime = $this->request->getVar('meeting_date_time');
        $meetingAgenda = $this->request->getVar('meeting_agenda');
        $isActive = $this->request->getVar('is_active');

        
        $validation->setRule('meeting_title', lang('Meeting.meeting_title'), 'required');
        $validation->setRule('meeting_agenda', lang('Meeting.meeting_agenda'), 'required');
        $validation->setRule('meeting_date_time', lang('Meeting.meeting_date_time'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $meetingRecord = array();
            if (isset($_FILES["meeting_record"])) {
                $meetingRecordPath = MEETING_RECORD_PATH;
                $meetingRecord = $this->dt_ci_file_upload->UploadMultipleFile('meeting_record', MAX_IMAGE_SIZE_LIMIT, $meetingRecordPath, true, true, array('mp3', 'ogg', 'pdf', 'jpg', 'jpeg' , 'png'));
                if ($meetingRecord['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($meetingRecord['message']);
                    echo json_encode($response);
                    die();
                }
            }
            $meetingUpdateArray = array();
            $meetingArray = array(
                'meeting_id' => $meetingId,
                'meeting_title' => $meetingTitle,
                'meeting_agenda' => $meetingAgenda,
                'meeting_date_time' => DMYToYMD($meetingDateTime,true,true),
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );
            if(!empty($meetingId)){
                $meetingUpdateData = $this->meeting_model->getMeetingData(array(
                    'meeting_id' => $meetingId,
                ));
                $meetingUpdateArray = compareArray($meetingArray,$meetingUpdateData);
            }
            $meetingData = $this->meeting_model->insertUpdateRecord($meetingArray,'meeting_id','tbl_meeting', 1,'',array(),array(),$meetingUpdateArray);
            $lastMeetingId = $meetingData['lastInsertedId'];
            
            if($lastMeetingId != ''){
                if(isset($meetingRecord) && count($meetingRecord) > 0){
                    $batchArray = array();
                    unset($meetingRecord['success']);
                    foreach ($meetingRecord as $key => $recordData) {
                        $dataArray = array(
                            'meeting_record_id' =>   '',
                            'meeting_id' => $lastMeetingId,
                            'meeting_record' => isset($recordData['file_name']) ? $recordData['file_name'] : "",
                        );
                        array_push($batchArray, $dataArray);
                    }

                    $meetingExtraDataArray = array();
                    $meetingExtraDataArray['module_id'] = $lastMeetingId;
                    $meetingExtraDataArray['module'] = 'Meeting Record';
                    $meetingExtraDataArray['type'] = 'Meeting';
                    $meetingExtraDataArray['old_data'] = array();
                    $meetingExtraDataArray['user_id'] = $this->data['userId'];
                    $meetingExtraDataArray['society_id'] = $this->session->get('society_id');
                    $this->meeting_model->batchInsert($batchArray, 'tbl_meeting_record',$meetingExtraDataArray);
                }
            }

            if(empty($meetingId)){
                // $memberData = $

                $flatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                    "society_id" => $this->session->get('society_id'),
                    "is_multiple" => 1,
                    "is_show_all_member" => 1,
                ));

                // printArray($flatMemberData,1);

                $rentalsWiseData = array();

                if(!empty($flatMemberData)){
                    foreach($flatMemberData as $flatMemberElement){
                        if($flatMemberElement['type'] == 'rentals'){
                            $rentalsWiseData[] = $flatMemberElement['type_id'];
                        }
                    }
                }
                // printArray($rentalsWiseData);
                $rentalsAgreementPeriodCheck = $this->rental_model->getRentalsData(array(
                    'rentals_id' => $rentalsWiseData,
                    'is_api_call' => 1,
                    'check_flat_rent' => 1,
                    "society_id" => $this->session->get('society_id'),
                    'is_multiple' => 1
                ));

                if (!empty($flatMemberData)) {
                    if (!empty($rentalsAgreementPeriodCheck)) {
                        $validRentalsAgreementPeriod = array_column($rentalsAgreementPeriodCheck, 'rentals_id');
                        foreach ($flatMemberData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals' && !in_array($flatMemberElement['type_id'], $validRentalsAgreementPeriod)) {
                                unset($flatMemberData[$key]); // Agar agreement me nahi hai toh remove karo
                            }
                        }
                        $flatMemberData = array_values($flatMemberData);
                    } else {
                        // Agr rentalsAgreementPeriodCheck empty hai, toh koi bhi rentals nahi ana chahiye
                        foreach ($flatMemberData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals') {
                                unset($flatMemberData[$key]);
                            }
                        }
                        $flatMemberData = array_values($flatMemberData);
                    }
                }

                // printArray($flatMemberData,1);

                $rsvpInsertArr = array();
                if(!empty($flatMemberData)){
                    foreach ($flatMemberData as $key => $member) {
                        $intMetArr = array(
                            "rsvp_meeting_id" => "",
                            "meeting_id" => $lastMeetingId,
                            "ownership_flat_member_id" => $member['ownership_flat_member_id'],
                            "rsvp_status" => 0,
                            "society_id" => $this->session->get('society_id'),
                        );
                        createdInfoMerge($intMetArr,$this->data['userId']);
                        $rsvpInsertArr[] = $intMetArr;
                    }
                }
                if(!empty($rsvpInsertArr)){
                    $this->meeting_model->batchInsert($rsvpInsertArr,"tbl_rsvp_meeting");
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($meetingId) && $meetingId != '') {
                if (($meetingData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Meeting.meeting"));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Meeting.meeting"));
                }
            } else {
                if (($meetingData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Meeting.meeting"));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Meeting.meeting"));
                }
            }
            echo json_encode($response);
            exit;
        }
    }
    public function changeStatus(){
        $meetingId = $this->request->getVar('meeting_id');
        $status = $this->request->getVar('status');
        $return = $this->meeting_model->statusChange($meetingId,$status,'meeting_id','tbl_meeting');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Meeting.meeting'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Meeting.meeting'));
        }
        echo json_encode($response);
        exit;
    }
    public function delete()
    {
        $this->db->transStart();
        $meetingId = $this->request->getVar('meeting_id');
        $meetingRecordData = $this->meeting_model->getMeetingRecordData(array(
            "meeting_id" => $meetingId,
            "is_multiple" => 1
        ));
        if(is_array($meetingRecordData) && !empty($meetingRecordData)){
            foreach ($meetingRecordData as $meeting){
                $FileUrl = '';
                if(isset($meeting['meeting_record']) && $meeting['meeting_record'] != '') {
                    $FileUrl = MEETING_RECORD_PATH . $meeting['meeting_record'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }
            }
        }
        $meetingData = $this->meeting_model->deleteRecord($meetingId);
        $transactionStatus = $this->db->transComplete();
        if (($meetingData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Meeting.meeting"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Meeting.meeting"));
        }
        echo json_encode($response);
        exit;
    }

    public function excelExportMeeting()
    {
        $fileName ='meeting-' . DATETIMEFORMAT;
        $sheetName = 'Meeting-' . DATEFORMAT;
        $excelHeaderName = 'Meeting';
        $tableData = $this->getMeetingListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Meeting.society'),
            lang('Meeting.meeting_title'),
            lang('Meeting.meeting_date'),
            lang('Meeting.meeting_agenda'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["meeting_title"],
                $row["meeting_date_time"],
                $row["meeting_agenda"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function deleteMeetingRecord()
    {
        $this->db->transStart();
        $meetingRecordId = $this->request->getVar('meeting_record_id');
        $meetingId = $this->request->getVar('meeting_id');
        $recordData = $this->meeting_model->getMeetingRecordData(array(
            "meeting_record_id" => $meetingRecordId,
            "is_multiple" => 1
        ));
        if(is_array($recordData) && !empty($recordData)){
            foreach ($recordData as $record){
                $FileUrl = '';
                if(isset($record['meeting_record']) && $record['meeting_record'] != '') {
                    $FileUrl = MEETING_RECORD_PATH . $record['meeting_record'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 
            }
        }
        //delete setting location
        $recordData = $this->meeting_model->deleteMeetingRecord($meetingRecordId); 

        // printArray($recordData,1);     
        if ($recordData) {
            $ids = is_array($meetingRecordId) ? implode(',',$meetingRecordId) : $meetingRecordId;
            $deleteDataArray['module'] = 'Meeting Record';
            $deleteDataArray['activity'] = "Meeting Record Deleted";
            $deleteDataArray['module_id'] = $meetingRecordId;
            logActivity('Meeting Record Deleted [MeetingRecordId: ' . $ids . ']',$this->data['userId'],'Meeting Record',$ids,json_encode($deleteDataArray),'','Meeting',$meetingId);
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Meeting.meeting_record'));
            }
            else{
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Meeting.meeting_record'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Meeting.meeting_record'));
        }
        echo json_encode($response);
        exit();
    }
}
