<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\KeyIssueModel;
class KeyIssue extends BaseController
{
    protected $key_issue_model;
    public function __construct() {
        $this->key_issue_model = new KeyIssueModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Key Issue';
        $commonKeysId = $this->request->getVar("ck_id");
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => false,
                "tbl_name" => "tbl_common_keys",
                "columns" => array("common_keys_id","description"),
                "selected" => $commonKeysId,
                "id" => "filter_common_keys_id",
                "name" => "filter_common_keys_id",
                "title" => "KeyIssue.common_keys",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonKeyAvailabilityDd",
                "id" => "filter_common_keys_availability_id",
                "name" => "filter_common_keys_availability_id",
                "title" => "KeyIssue.key_name",
            ),

            array(
                "type" => "daterange",
                "id" => "filter_key_issue_date",
                "name" => "filter_key_issue_date",
                "title" => "KeyIssue.key_issue_date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","KeyIssue/KeyIssueView",$data);
    }

    public function manage($keyIssueId = '',$view = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($keyIssueId != '') {
            $filterData = array(
                "key_issue_id" => $keyIssueId
            );
            $data['key_issue_data'] = $this->key_issue_model->getKeyIssueData($filterData);
        }
        if ($keyIssueId != '') {
            $data['title'] = 'Edit Key Issue';
        } else {
            $data['title'] = 'Add Key Issue';
        }
        $data['key_issue_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

        if ((isset($data['key_issue_data']['society_id']) && $data['key_issue_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/KeyIssue');
        }
        if (((isset($data['key_issue_data']['form_submit']) && $data['key_issue_data']['form_submit'] == 'approved')  && $data['key_issue_data']['view'] != 1)) {
            return redirect()->to('Admin/KeyIssue');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        return $this->dt_ci_template->load("Admin","KeyIssue/KeyIssueManageView",$data);
    }

    public function getKeyIssueListing($return = false,$filterData=array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $commonKeysId = $this->request->getVar("filter_common_keys_id");
        $commonKeysAvailabilityId = $this->request->getVar("filter_common_keys_availability_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $keyIssueDate = $this->request->getVar("filter_key_issue_date");

        $this->datatables->table("tbl_key_issue as tki");
        $this->datatables->select("tki.key_issue_id,ts.society_name,ts.society_name,tki.key_issue_date,tck.description,tcka.keys_name,tki.key_issue,tki.form_submit");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tki.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tki.society_id","left");
        $this->datatables->join("tbl_common_keys as tck","tck.common_keys_id = tki.common_keys_id","left");
        $this->datatables->join("tbl_common_keys_availability as tcka","tcka.common_keys_availability_id = tki.common_keys_availability_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tki.updated_by AND tupdate.society_id = tki.society_id","left");

        if(isset($commonKeysId)) {
            if(is_array($commonKeysId)){
                $this->datatables->whereIn("tki.common_keys_id",$commonKeysId);
            } else {
                $this->datatables->where("tki.common_keys_id",$commonKeysId);
            }
        }
        if(isset($commonKeysAvailabilityId)) {
            if(is_array($commonKeysAvailabilityId)){
                $this->datatables->whereIn("tki.common_keys_availability_id",$commonKeysAvailabilityId);
            } else {
                $this->datatables->where("tki.common_keys_availability_id",$commonKeysAvailabilityId);
            }
        }

        if($keyIssueDate != ''){
            list($fromDate,$toDate) = explode(" - ",$keyIssueDate);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tki.key_issue_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tki.key_issue_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tki.key_issue_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$fromDate);
                $this->datatables->where("date_format(tki.key_issue_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tki.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tki.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tki.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tki.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tki.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tki.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }


        $this->datatables->groupBy("tki.key_issue_id");
        accessFilter($this->datatables, array("society" => "tki.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){

                $approvedButtonFilter = array(
                    "button_id" => isset($displayData['key_issue_id']) ? $displayData['key_issue_id'] : "",
                    "form_submit" => isset($displayData['form_submit']) ? $displayData['form_submit'] : "",
                    "permission_label" => 'KeyIssue',
                    "permission_name" => $this->dt_ci_acl->checkAccess("KeyIssue|submitForm"),
                    "approved_module" => "key_issue",
                );
                $data[$key]['approved_button'] = approvedButton($approvedButtonFilter);

                $actionButtonFilter = array(
                    "key_issue_id" => isset($displayData['key_issue_id']) ? $displayData['key_issue_id'] : "",
                    "form_submit" => isset($displayData['form_submit']) ? $displayData['form_submit'] : "",
                );
                $data[$key]['action_button'] = keyIssueActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
                $data[$key]['key_issue_date'] = isValidDate($data[$key]['key_issue_date']) ? siteDateFormat($data[$key]['key_issue_date']) : "";
            }
        }

        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
        
    }

    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $keyIssueId = $this->request->getVar('key_issue_id');
        $keyIssueDate = $this->request->getVar("key_issue_date");
        $commonKeysId = $this->request->getVar("common_keys_id");
        $commonKeysAvailabilityId = $this->request->getVar("common_keys_availability_id");
        $keyIssue = $this->request->getVar("key_issue");

        $validation->setRule('key_issue_date', lang('KeyIssue.key_issue_date'), 'required');
        $validation->setRule('common_keys_id', lang('KeyIssue.common_keys_id'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $keyIssueUpdateArray = array();
            $keyIssueArray = array(
                'key_issue_id' => $keyIssueId,
                'key_issue_date' => DMYToYMD($keyIssueDate),
                'common_keys_id' => $commonKeysId,
                'common_keys_availability_id' => $commonKeysAvailabilityId,
                'key_issue' => $keyIssue,
                'society_id' => $this->session->get('society_id'),
            );
            if(!empty($keyIssueId)){
                $keyIssueUpdateData = $this->key_issue_model->getKeyIssueData(array(
                    'key_issue_id' => $keyIssueId,
                ));
                $keyIssueUpdateArray = compareArray($keyIssueArray,$keyIssueUpdateData);
            }
            $keyIssueData = $this->key_issue_model->insertUpdateRecord($keyIssueArray, 'key_issue_id', 'tbl_key_issue', 1,'',array(),array(),$keyIssueUpdateArray);
            $lastKeyIssueId = $keyIssueData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
            if (isset($keyIssueId) && $keyIssueId != '') {
                if (($keyIssueData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('KeyIssue.key_issue'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('KeyIssue.key_issue'));
                }
            } else {
                if (($keyIssueData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('KeyIssue.key_issue'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('KeyIssue.key_issue'));
                }
            }
            echo json_encode($response);
            exit;
        }
    }

    public function delete()
    {
        $this->db->transStart();
        $keyIssueId = $this->request->getVar('key_issue_id');

        $keyIssueDataArray = $this->key_issue_model->getKeyIssueData(array(
            'key_issue_id' => $keyIssueId,
            'is_multiple' => 1
        ));
        $keyIssueApprovedError = array();
        if(!empty($keyIssueDataArray)){
            foreach ($keyIssueDataArray as $keyIssueDataElement){
                if($keyIssueDataElement['form_submit'] == 'approved') {
                    $keyIssueApprovedError[] =  $keyIssueDataElement['description']."/".$keyIssueDataElement['keys_name'];
                }
            }
        }
        if(!empty($keyIssueApprovedError)){
            $keyIssueNumber = implode(',', $keyIssueApprovedError);
            $response['success'] = false;
            $response['msg'] = "You Can't Deleted This Key Issue ". $keyIssueNumber ." Because Already Approved";
            echo json_encode($response);
            exit;
        };


        $keyIssueData = $this->key_issue_model->deleteRecord($keyIssueId);
        $transactionStatus = $this->db->transComplete();
        if (($keyIssueData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("KeyIssue.key_issue"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("KeyIssue.key_issue"));
        }
        echo json_encode($response);
        exit;
    }
    public function excelExportKeyIssue()
    {
        $fileName ='KI-' . DATETIMEFORMAT;
        $sheetName = 'KI-' . DATEFORMAT;
        $excelHeaderName = 'Key Issues';
        $tableData = $this->getKeyIssueListing(true, $_GET);
        // printArray($tableData,1);
        $dataRows = array();
        $dataRows[] = array(
            // lang('KeyIssue.society'),
            lang('KeyIssue.common_keys'),
            lang('KeyIssue.key_name'),
            lang('KeyIssue.key_issue'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["description"],
                $row["keys_name"],
                $row["key_issue"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function submitForm()
    {

        $keyIssueId = $this->request->getVar('key_issue_id');
        $formStatus = $this->request->getVar('form_status');
        $checkStatus = checkFormStatus('tbl_key_issue', 'key_issue_id', $keyIssueId, 'approved');
        if ($checkStatus) {
        $this->db->transBegin();

        if ($formStatus == 'approved') {
            $keyIssueDataArray = $this->key_issue_model->getKeyIssueData(array(
                'key_issue_id' => $keyIssueId,
                'is_multiple' => 1
            ));


            $keyIssueArray = array();
            foreach ($keyIssueDataArray as $keyIssueData) {
                if (isset($keyIssueData['form_submit']) && ($keyIssueData['form_submit'] == $formStatus)) {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('KeyIssue.key_issue'));
                    echo json_encode($response);
                    exit;
                }

                $keyIssueArray[] = array(
                    'key_issue_id' => $keyIssueData['key_issue_id'],
                    'form_submit' => $formStatus,
                    'approved_by' => $this->data['userId'],
                    'approved_at' => DATE_TIME_DATABASE,
                    'updated_by' => $this->data['userId'],
                    'updated_at' => DATE_TIME_DATABASE
                );
            }
        }



        $keyIssueResponse = $this->key_issue_model->batchUpdate($keyIssueArray, 'key_issue_id', 'tbl_key_issue');

        if (isset($keyIssueResponse['success']) && $keyIssueResponse['success']) {
            $this->db->transCommit();
            $response['title'] = lang('CommonMessage.common_success');
            $response['msg'] = lang('CommonMessage.common_approved_success');
            $response['success'] = true;
        } else {
            $this->db->transRollback();
            $response['title'] = lang('common_error');
            $response['success'] = false;
            $response['msg'] = lang('common_approved_error');
        }
        } else {
            $response['title'] = lang('CommonMessage.common_error');
            $response['success'] = false;
            $response['msg'] = lang('common_approved_already_error');
        }
        echo json_encode($response);
    }


}
