<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\GeneratorModel;
class Generator extends BaseController
{
    public function __construct() {
        $this->generator_model = new GeneratorModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
		$data['title'] = lang('Generator.generator');
		$data['v_generator_modal'] = view('Admin/Generator/GeneratorModalView', $data);
		$this->dt_ci_template->load("Admin","Generator/GeneratorView",$data);
	}

    public function getGeneratorListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_generator as tg");
		$this->datatables->select("tg.generator_id,tg.generator_name");
		$this->datatables->select("(select count(*) from tbl_generator_reading as tgr where tgr.generator_id = tg.generator_id) as no_of_reading");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tg.created_at,tg.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tg.updated_by AND tupdate.society_id = tg.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tg.created_by AND tcreate.society_id = tg.society_id","left");
        accessFilter($this->datatables, array("society" => "tg.society_id"));
		$this->datatables->groupBy("tg.generator_id");
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"generator_id" => isset($data[$key]['generator_id']) ? $data[$key]['generator_id'] : ""
				);
				$data[$key]['action_button'] = generatorActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
    }

 
    public function addEdit()
	{
        $this->db->transStart();
		$validation = \Config\Services::validation();
		$generatorId = $this->request->getVar('generator_id');
		$generatorName = $this->request->getVar('generator_name');
        
		$validation->setRule('generator_name', lang('Generator.generator_name'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			$generatorUpdateArray = array();
            $generatorArray = array(
				'generator_id' => $generatorId,
				'generator_name' => $generatorName,
                'society_id' => $this->session->get('society_id')
			);
			if(!empty($generatorId)){
                $generatorUpdateData = $this->generator_model->getGeneratorData(array(
                    'generator_id' => $generatorId,
                    'society_id' => $this->session->get('society_id')
                ));
                $generatorUpdateArray = compareArray($generatorArray,$generatorUpdateData);
            }
			$generatorData = $this->generator_model->insertUpdateRecord($generatorArray, 'generator_id', 'tbl_generator', 1,'',array(),$generatorUpdateArray);
			$lastCategoryId = $generatorData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
			if (isset($generatorId) && $generatorId != '') {
				if (($generatorData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Generator.generator"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Generator.generator"));
				}
			} else {
				if (($generatorData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Generator.generator"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Generator.generator"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $generatorId = $this->request->getVar('generator_id');

        if( isReferenceInTable( 'generator_id','tbl_generator_reading', $generatorId)){
            if(!empty($generatorId)){
                foreach($generatorId as $generator){
                    $deleteDataArray['module'] = 'Generator';
                    $deleteDataArray['activity'] = "Generator Deleted";
                    $deleteDataArray['module_id'] = $generator;
                    logActivity('Generator Deleted [GeneratorID: ' . $generator . ']',$this->data['userId'],'Generator',$generator,json_encode($deleteDataArray),'','Generator',$generator);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }

        $generatorData = $this->generator_model->deleteRecord($generatorId);
        $transactionStatus = $this->db->transComplete();
        if (($generatorData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Generator.generator"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Generator.generator"));
        }
        echo json_encode($response);
        exit;
    }

    public function getGeneratorDd(){
    	$filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $generatorId = $this->request->getVar('generator_id');
        $filterData = array(
            'generator_id' => $generatorId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );
        echo $this->generator_model->getGenerator($filterData);
    }

	public function excelExportGenerator()
    {
        $fileName ='generator-' . DATETIMEFORMAT;
        $sheetName = 'Generator-' . DATEFORMAT;
        $excelHeaderName = 'Generator';
        $tableData = $this->getGeneratorListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Generator.generator_name'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["generator_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

}
