<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\EventBookingModel;
use App\Models\DocumentModel;
use App\Models\EventModel;
use App\Models\OwnershipFlatModel;
use App\Models\RentalsModel;

class EventBooking extends BaseController
{
    protected $event_booking_model;
    protected $event_model;
    protected $ownership_flat_model;
    protected $rental_model;
    public function __construct() {
        $this->event_booking_model = new EventBookingModel();
        $this->event_model = new EventModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->rental_model = new RentalsModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'EventBooking Booking';
		
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        // $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        $data['cancel_event_booking_modal'] = view('Admin/EventBooking/CancelEventBookingModalView', array());
		$this->dt_ci_template->load("Admin","EventBooking/EventBookingView",$data);
	}

	public function manage($eventBookingId = '', $view = '')
	{
		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
			"vendor/libs/ckeditor/ckeditor_classic.js",
			"vendor/libs/jquery-timepicker/jquery-timepicker.js",
        );

        if ($eventBookingId != '') {
			$filterData = array(
				"event_booking_id" => $eventBookingId
			);
			$data['event_booking_data'] = $this->event_booking_model->getEventBookingData($filterData);
			// printArray($data['event_booking_data'],1);
			if (empty($data['event_booking_data'])) {
                return redirect()->to('Admin/EventBooking');
            }

		}

		if ($eventBookingId != '') {
			$data['title'] = 'Edit EventBooking Booking';
		} else {
			$data['title'] = 'Add EventBooking Booking';
		}

		$data['event_booking_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

		if (((isset($data['event_booking_data']['form_submit']) && $data['event_booking_data']['form_submit'] == 'approved') && $data['event_booking_data']['view'] != 1)) {
            return redirect()->to('Admin/EventBooking');
        }
		
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['event_booking_data']['society_id']) && $data['event_booking_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/EventBooking');
        }
		$this->dt_ci_template->load("Admin","EventBooking/EventBookingManageView",$data);
	}

    public function getEventBookingListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

        $this->datatables->table("tbl_event_booking as teb");

		$this->datatables->select("teb.event_booking_id,teb.event_type,teb.start_date,teb.end_date,teb.total_adult,teb.total_child,teb.total_guest,teb.total_payment,teb.updated_at,teb.created_at,teb.is_cancel");
        $this->datatables->select("te.event_name,tm.name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = teb.updated_by AND tupdate.society_id = teb.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = teb.created_by AND tcreate.society_id = teb.society_id","left");
        $this->datatables->join("tbl_event as te","te.event_id = teb.event_id","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = teb.ownership_flat_member_id","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");

		$this->datatables->groupBy("teb.event_booking_id");
		accessFilter($this->datatables, array("society" => "teb.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"event_booking_id" => isset($data[$key]['event_booking_id']) ? $data[$key]['event_booking_id'] : "",
				);
				$data[$key]['action_button'] = eventBookingActionButton($actionButtonFilter);

    			$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['start_date'] = isValidDate($displayData['start_date']) ? siteDateFormat($displayData['start_date']) : "";
				$data[$key]['end_date'] = isValidDate($displayData['end_date']) ? siteDateFormat($displayData['end_date']) : "";
				$data[$key]['event_type'] = isset($displayData['event_type']) ? underscoreToUcWord($displayData['event_type']) : "";
				$data[$key]['is_cancel'] = (isset($displayData['is_cancel']) && $displayData['is_cancel'] != 0) ? "Yes" : "No";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function save()
	{
       	$this->db->transStart();
		$validation = \Config\Services::validation();
		$eventBookingId = $this->request->getVar('event_booking_id');
		$eventId = $this->request->getVar('event_id');
		$startDate = $this->request->getVar('start_date');
		$endDate = $this->request->getVar('end_date');
		$ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
		$totalAdult = $this->request->getVar('total_adult');
		$totalChild = $this->request->getVar('total_child');
		$totalGuest = $this->request->getVar('total_guest');
		
		$validation->setRule('event_id', lang('EventBooking.event_id'), 'required');
		$validation->setRule('start_date', lang('EventBooking.start_date'), 'required');
		$validation->setRule('end_date', lang('EventBooking.end_date'), 'required');
		$validation->setRule('ownership_flat_member_id', lang('EventBooking.ownership_flat_member_id'), 'required');
		$validation->setRule('total_adult', lang('EventBooking.total_adult'), 'required');
		$validation->setRule('total_child', lang('EventBooking.total_child'), 'required');
		// $validation->setRule('total_guest', lang('EventBooking.total_guest'), 'required');
		$validation->setRule('total_payment', lang('EventBooking.total_payment'), 'required');

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			
			// if(strtotime($startDate) >= strtotime($endDate)) {
			// 	$response['success'] = false;
			// 	$response['msg'] = "Start Date Can't Be Greater Then End Date";
			// 	echo json_encode($response);
			// 	exit;
			// }

			$eventData = $this->event_model->getEventData(array("event_id" => $eventId));
			// if(!empty($eventData)){
            //     $eventStartDate = date('Y-m-d', strtotime($eventData['start_date']));
            //     $eventEndDate = date('Y-m-d', strtotime($eventData['end_date']));

			// 	if (($startDate < $eventStartDate) || ($endDate > $eventEndDate)) {
            //         $response['success'] = false;
            //         $response['msg'] = "Booking Start Date And End Date Is Beyond Event Timings";
            //         echo json_encode($response);
            //         exit;
            //     }
			// }
            if(!empty($eventData)){
                $endDate = $eventData['end_date'];
                $bookingDeadline = date('Y-m-d H:i:s', strtotime($endDate . ' -15 minutes'));
                $currentTime = date('Y-m-d H:i:s');

                if ($currentTime > $bookingDeadline) {
                    $response['success'] = false;
                    $response['msg'] = lang('CommonWebService.booking_is_no_longer_allowed') . date('d-m-Y H:i:s A', strtotime($endDate . ' -15 minutes'));
                    echo json_encode($response);
                    exit;
                }
            }

			if(!empty($eventData)){
                $isGuestAllowed = $eventData['is_guest_allowed'];
                $maxGuestAllowed = $eventData['max_guest_allowed'];
            }
            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            ));

            if(!empty($ownershipFlatMemberData)){
                if($ownershipFlatMemberData['type'] == 'ownership_flat'){
                    $ownershipFlatData = $this->ownership_flat_model->getOwnershipFlatData(array(
                        'ownership_flat_id' => $ownershipFlatMemberData['type_id'],
                    ));
                }
                elseif($ownershipFlatMemberData['type'] == 'rentals'){
                    $ownershipFlatData = $this->rental_model->getRentalsData(array(
                        'rentals_id' => $ownershipFlatMemberData['type_id'],
                    ));
                }

                if(!empty($ownershipFlatData)){
                    $ownershipFlatMemberMultipleData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                        'type_id' => $ownershipFlatMemberData['type_id'],
                        'type' => $ownershipFlatMemberData['type'],
                        'is_show_all_member' => 1,
                        'is_multiple' => 1,
                    ));

                     // printArray($ownershipFlatMemberMultipleData,1);
                    $ownershipFlatMemberIdArray = array();
                    if(!empty($ownershipFlatMemberMultipleData)){
                        foreach($ownershipFlatMemberMultipleData as $ownershipFlat){
                            $ownershipFlatMemberIdArray[] = $ownershipFlat['ownership_flat_member_id'];
                        }
                    }

                    $eventFilterArray = array(
                        'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                        'is_multiple' => 1,
                    );

                    if(!empty($startDate)){
                        $eventFilterArray['start_date'] = DMYToYMD($startDate);
                    }

                    if(!empty($endDate)){
                        $eventFilterArray['end_date'] = DMYToYMD($endDate);
                    }
                    $eventBookingData = $this->event_model->getEventBookingData($eventFilterArray);
                    $memberName = [];
                    $totalStoreAdultCount = 0;
                    $totalStoreChildCount = 0;
                    $totalStoreAdultChildCount = 0;
                    $totalStoreGuestCount = 0;
                    if(!empty($eventBookingData)){
                        foreach($eventBookingData as $eventBooking){
                            $adult = $eventBooking['total_adult'];
                            $child = $eventBooking['total_child'];
                            $guest = $eventBooking['total_guest'];
                            $memberName[] = $eventBooking['member_name'];
                            // $totalStoreAdultChildCount += ($adult + $child);
                            $totalStoreGuestCount += ($guest);
                            $totalStoreAdultCount += ($adult);
                            $totalStoreChildCount += ($child);
                        }
                    }
                    $totalMember = $ownershipFlatData['total_member'];
                }
            }
            $uniqueMemberNames = array_unique($memberName);
            
            $totalStoreAdultChildCount = ($totalStoreAdultCount + $totalStoreChildCount);
            $countAdultChild = $totalAdult + $totalChild;
            if(!empty($countAdultChild)){
                if($totalStoreAdultChildCount >= $totalMember){
					$response['success'] = false;
					$response['msg'] = 'Your Event Is Already Booked By ' . implode(", ", $uniqueMemberNames);
					echo json_encode($response);
					exit;
                }
                $countAdult = abs($totalStoreAdultChildCount + $countAdultChild);

                if($countAdult > $totalMember){
					$response['success'] = false;
					$response['msg'] = 'You can add only '. abs($totalMember - $totalStoreAdultChildCount ) . " Child or Member";
					echo json_encode($response);
					exit;
                }
            }
            $currentGuestAllowed = abs($totalStoreGuestCount + (int) $totalGuest);
            if($isGuestAllowed == 1 && !empty($totalGuest)){

                if(($totalStoreGuestCount >= $maxGuestAllowed)){
					$response['success'] = false;
					$response['msg'] = 'You Already Add Guest';
					echo json_encode($response);
					exit;
                }

                if($currentGuestAllowed > $maxGuestAllowed){
					$response['success'] = false;
					$response['msg'] = 'You can add only '. abs($maxGuestAllowed - $totalStoreGuestCount ) . " Guest";
					echo json_encode($response);
					exit;
                }
            }

			if($eventData['booking_type'] == 'event_wise'){
                $filterEventArray = array(
                    'event_id' => $eventId,
                    'is_multiple' => 1,
                );
            }
            else {
                $filterEventArray = array(
                    'start_date' => DMYToYMD($startDate),
                    'end_date' => DMYToYMD($endDate),
                    'event_id' => $eventId,
                    'is_multiple' => 1,
                );
            }

            $eventRateData = $this->event_model->getEventRateData($filterEventArray);
			$adultRate = 0;
            $childRate = 0;
            $guestRate = 0;
            if(!empty($eventRateData)){
                foreach($eventRateData as $eKey => $eventRateElement){
                    $adultRate += $eventRateElement['adult_rate'];
                    $childRate += $eventRateElement['child_rate'];
                    $guestRate += $eventRateElement['guest_rate'];
                }
            }

			if($isGuestAllowed == 1 && !empty($totalGuest)){
				$totalPayment = ($adultRate * $totalAdult) + ($childRate * $totalChild) + ($guestRate * $totalGuest);
			} else {
				$totalPayment = ($adultRate * $totalAdult) + ($childRate * $totalChild);
				$totalGuest = 0;
			}
			$eventBookingUpdateArray = array();
			$eventBookingArray = array(
				'event_booking_id' => $eventBookingId,
                'event_id' => $eventId,
                'total_adult' => $totalAdult,
                'total_guest' => $totalGuest,
                'start_date' => DMYToYMD($startDate),
                'end_date' => DMYToYMD($endDate),
                'total_child' => $totalChild,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'type' => $ownershipFlatMemberData['type'],
                'type_id' => $ownershipFlatMemberData['type_id'],
                'total_payment' => $totalPayment,
                'event_type' => $eventData['rate_type'],
				'society_id' => $this->session->get('society_id'),
			);

			if(!empty($eventBookingId)){
                $eventBookingUpdateData = $this->event_booking_model->getEventBookingData(array(
                    'event_booking_id' => $eventBookingId,
                ));
                $eventBookingUpdateArray = compareArray($eventBookingArray,$eventBookingUpdateData);
            }

			$eventBookingData = $this->event_booking_model->insertUpdateRecord($eventBookingArray, 'event_booking_id', 'tbl_event_booking', 1,'',array(),array(),$eventBookingUpdateArray);
			$lastEventBookingId = $eventBookingData['lastInsertedId'];

			$eventBookingDisplayData = $this->event_model->getEventBookingData(array(
                'event_booking_id' => $lastEventBookingId,
            ));
                        
            $batchArray = array();
            if(!empty($totalAdult)){
                for($i = 0; $i< $eventBookingDisplayData['total_adult']; $i++){
                    $dataArray = array(
                        'event_booking_registration_id' =>   '',
                        'event_id' => $eventId,
                        'event_booking_id' => $lastEventBookingId,
                        'type' => 'adult',
                        'qr_code_number' => GenRandomNumber(6),

                    );
                    $combineQRCodeType = $dataArray['qr_code_number'];
                    $codeContents = $combineQRCodeType;
                    qrcodeEvent('text', $codeContents, 4, '', $combineQRCodeType);
                    $dataArray['qr_code_image'] = $combineQRCodeType . '.png';
                    array_push($batchArray, $dataArray);
                }
            }
            if(!empty($totalChild)){
                for($i = 0; $i< $eventBookingDisplayData['total_child']; $i++){
                    $dataArray = array(
                        'event_booking_registration_id' =>   '',
                        'event_id' => $eventId,
                        'event_booking_id' => $lastEventBookingId,
                        'type' => 'child',
                        'qr_code_number' => GenRandomNumber(6),

                    );
                    $combineQRCodeType = $dataArray['qr_code_number'];
                    $codeContents = $combineQRCodeType;
                    qrcodeEvent('text', $codeContents, 4, '', $combineQRCodeType);
                    $dataArray['qr_code_image'] = $combineQRCodeType . '.png';

                    array_push($batchArray, $dataArray);
                }
            }

            if(!empty($totalGuest)){
                for($i = 0; $i< $eventBookingDisplayData['total_guest']; $i++){
                    $dataArray = array(
                        'event_booking_registration_id' =>   '',
                        'event_id' => $eventId,
                        'event_booking_id' => $lastEventBookingId,
                        'type' => 'guest',
                        'qr_code_number' => GenRandomNumber(6),

                    );
                    $combineQRCodeType = $dataArray['qr_code_number'];
                    $codeContents = $combineQRCodeType;
                    qrcodeEvent('text', $codeContents, 4, '', $combineQRCodeType);
                    $dataArray['qr_code_image'] = $combineQRCodeType . '.png';
                    array_push($batchArray, $dataArray);
                }
            }

            if (!empty($batchArray)) {
                $this->event_model->batchInsert($batchArray, 'tbl_event_booking_registration');
            }
		}
        $transactionStatus = $this->db->transComplete();
			if (isset($eventBookingId) && $eventBookingId != '') {
				if (($eventBookingData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("EventBooking.event_booking"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("EventBooking.event_booking"));
				}
			} else {
				if (($eventBookingData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("EventBooking.event_booking"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("EventBooking.event_booking"));
				}
			}
			echo json_encode($response);
			exit;
	}

    public function delete()
    {
        $this->db->transStart();
        $eventId = $this->request->getVar('event_id');
        //  if( isReferenceInTable( 'event_id','tbl_men_power_attendance', $eventId)){
		// 	 if(!empty($eventId)){
		// 	 	foreach($eventId as $documentElement){
		// 	 		$deleteDataArray['module'] = 'EventBooking';
		// 	 		$deleteDataArray['activity'] = "Tried to Delete EventBooking ";
		// 	 		$deleteDataArray['module_id'] = $documentElement;
		// 	 		logActivity('Tried to delete EventBooking [EventBookingID: ' . $documentElement . ']',$this->data['userId'],'EventBooking',$documentElement,json_encode($deleteDataArray),'','EventBooking',$documentElement);
		// 	 	}
		// 	 }
        //      $response['success'] = false;
        //      $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
        //      echo json_encode($response);
        //      exit;
        //  }
		$eventImageData = $this->event_model->getEventBookingImageData(array(
			"event_id" => $eventId,
			"is_multiple" => 1
		));
		if(is_array($eventImageData) && !empty($eventImageData)){
			foreach ($eventImageData as $image){
				$FileUrl = '';
				if(isset($image['event_image']) && $image['event_image'] != '') {
					$FileUrl = EVENT_IMAGE_PATH . $image['event_image'];
				}
				if (file_exists($FileUrl)) {
					unlink($FileUrl);
				}
			}
		}
        $eventData = $this->event_model->deleteRecord($eventId);
		$this->event_model->deleteCategoryRecord($eventId);
        $transactionStatus = $this->db->transComplete();
        if (($eventData) && ($transactionStatus == 1)) {
            $this->db->transCommit();
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("EventBooking.event"));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("EventBooking.event"));
        }
        echo json_encode($response);
        exit;
    }

	public function getTotalPayment() {
		// printArray($_POST,1);
		$validation = \Config\Services::validation();
		// $data['row_number'] = $this->request->getVar("row_number");
		$eventId = $this->request->getVar('event_id');
		$startDate = $this->request->getVar('start_date');
		$endDate = $this->request->getVar('end_date');
		$totalAdult = $this->request->getVar('total_adult');
		$totalChild = $this->request->getVar('total_child');
		$totalGuest = $this->request->getVar('total_guest');
		
		// Validation rules
		$validation->setRule('event_id', lang('EventBooking.event_id'), 'required',array("required" => lang('EventBooking.event_id')." Is Required"));

		// Validate the input
		if (!$validation->withRequest($this->request)->run()) {
			$errors = $validation->getErrors();
			$response['success'] = false;
			$response['msg'] = implode("\n", $errors);
			echo json_encode($response);
			exit;
		} else {

            if(strtotime($startDate) >= strtotime($endDate)) {
                $response['success'] = false;
                $response['msg'] = "Start Date Can't Be Greater Then End Date";
                echo json_encode($response);
                exit;
            }

			$eventData = $this->event_model->getEventData(array('event_id' => $eventId));
			// printArray($eventData,1);
			if($eventData['rate_type'] == 'date_wise'){
				$filterArray = array(
					'is_multiple' => 1,
					'event_id' => $eventId,
					'start_date' => DMYToYMD($startDate),
					'end_date' => DMYToYMD($endDate),
				);
				$eventRateData = $this->event_model->getEventRateData($filterArray);
			} else {
				$filterArray = array(
					'is_multiple' => 1,
					'event_id' => $eventId,
				);
				$eventRateData = $this->event_model->getEventRateData($filterArray);
			}
			// printArray($eventRateData,1);
			$adultRate = 0;
            $childRate = 0;
            $guestRate = 0;
            if(!empty($eventRateData)){
                foreach($eventRateData as $eKey => $eventRateElement){
                    $adultRate += $eventRateElement['adult_rate'];
                    $childRate += $eventRateElement['child_rate'];
                    $guestRate += $eventRateElement['guest_rate'];
                }
            }
            // printArray($adultRate);
            // printArray($childRate);
            // printArray($guestRate,1);

			$totalPayment = ($adultRate * (int) $totalAdult) + ($childRate * (int) $totalChild) + ($guestRate * (int) $totalGuest);
			// printArray($adultRate);
			// printArray($childRate);
			// printArray($guestRate);
			// printArray($totalPayment,1);
			$response['success'] = true;
			$response['total_payment'] = $totalPayment;
			echo json_encode($response);
			exit;
		}
	}

	public function submitForm()
    {
        $eventId = $this->request->getVar('event_id');
        $formStatus = $this->request->getVar('form_status');
        $this->db->transBegin();

        if ($formStatus == 'approved') {
            $eventDataArray = $this->event_model->getEventBookingData(array(
                'event_id' => $eventId,
                'is_multiple' => 1
            ));

            $eventArray = array();

            foreach ($eventDataArray as $eventData) {

                if (isset($eventData['form_submit']) && ($eventData['form_submit'] == $formStatus)) {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('EventBooking.event'));
                    echo json_encode($response);
                    exit;
                }

                $eventArray[] = array(
                    'event_id' => $eventData['event_id'],
                    'form_submit' => $formStatus,
                    'approved_by' => $this->data['userId'],
                    'approved_at' => DATE_TIME_DATABASE,
                    'updated_by' => $this->data['userId'],
                    'updated_at' => DATE_TIME_DATABASE
                );
            }
        }

        if ($formStatus == 'saved') {

            $eventDataArray = $this->event_model->getEventBookingData(array(
                'event_id' => $eventId,
                'is_multiple' => 1
            ));

            foreach ($eventDataArray as $eventData) {
                
                if (isset($eventData['form_submit']) && ($eventData['form_submit'] == $formStatus)) {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('EventBooking.event'));
                    echo json_encode($response);
                    exit;
                }

                $eventArray[] = array(
                    'event_id' => $eventData['event_id'],
                    'form_submit' => $formStatus,
                    'unapproved_by' => $this->data['userId'],
                    'unapproved_at' => DATE_TIME_DATABASE,
                    'updated_by' => $this->data['userId'],
                    'updated_at' => DATE_TIME_DATABASE
                );

            }
        }

        $eventResponse = $this->event_model->batchUpdate($eventArray, 'event_id', 'tbl_event');

        if (isset($eventResponse['success']) && $eventResponse['success']) {
            $this->db->transCommit();
            $response['title'] = lang('CommonMessage.common_success');
            $response['msg'] = lang('CommonMessage.common_approved_success');
            $response['success'] = true;
        } else {
            $this->db->transRollback();
            $response['title'] = lang('common_error');
            $response['success'] = false;
            $response['msg'] = lang('common_approved_error');
        }
        echo json_encode($response);
    }


	public function getFlatMemberDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'is_active'=> 1,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->event_booking_model->getFlatMember($filterData);
    }

    public function cancelEventBooking()
	{
		$validation = \Config\Services::validation();
		$this->db->transBegin();
		$modalEventBookingId    = $this->request->getVar('modal_event_booking_id');
		$cancelReason = $this->request->getVar('cancel_reason');

		// $validation->setRule('modal_complaint_id', lang('Complaint.complaint_id'), 'required');
		// $validation->setRule('status_id', lang('Complaint.status'), 'required');
		// $validation->setRule('remarks', lang('Complaint.remarks'), 'required');
		
		// if (!$validation->withRequest($this->request)->run()) {
        //     $errors = $validation->getErrors();
        //     $response['success'] = false;
        //     $response['msg'] = implode("\n", $errors);
        //     echo json_encode($response);
        //     exit;
        // } else {

			$eventBookingIdArray = explode(',', $modalEventBookingId);

			if (!empty($eventBookingIdArray)) {
				foreach($eventBookingIdArray as $eventBookingId){
					$eventBookingData = $this->event_booking_model->getEventBookingData(array('event_booking_id'=>$eventBookingId));
                    // printArray($eventBookingData,1);
                    $eventBookingRegistrationData = $this->event_model->getEventBookingRegistrationData(array(
                        'event_booking_id' => $eventBookingId,
                        'is_enter' => 1,
                    ));
                    if(!empty($eventBookingRegistrationData)){
                        $response['success'] = false;
						$response['msg'] = "You Already Entered Event Can/t Cancel";
						echo json_encode($response);
						exit();
                    }
					if($eventBookingData['is_cancel'] == 1){
						$response['success'] = false;
						$response['msg'] = "Booking Is Already Cancelled";
						echo json_encode($response);
						exit();
					}
                    $filterArray = array(
                        'is_active' => 1,
                        'event_id' => $eventBookingData['event_id'],
                        'society_id' => $this->session->get('society_id'),
                    );
                    $eventData = $this->event_model->getEventData($filterArray);
                    $todayDate = date('Y-m-d H:i:s');
                    $todayDateTimeStamp = strtotime($todayDate);
                    $eventStartTimeStamp = strtotime($eventData['start_date']);
                    $beforeMinutes = (int)($eventData['before_minutes']); // Event start time
                    $allowedCancelTimeStamp = $eventStartTimeStamp - ($beforeMinutes * 60);
                    if ($eventData['is_cancellation_allowed'] != 0) {
                        if ($todayDateTimeStamp > $eventStartTimeStamp) {
                            $response['success'] = false;
						    $response['msg'] = "No Cancellation Allowed";
						    echo json_encode($response);
						    exit();
                        } elseif ($todayDateTimeStamp < $allowedCancelTimeStamp) {
                            $response['success'] = false;
						    $response['msg'] = lang('CommonWebService.cancellation_is_allowed_between') . date('d-m-Y H:i:s', $allowedCancelTimeStamp) . " and " . date('d-m-Y H:i:s', $eventStartTimeStamp);
						    echo json_encode($response);
						    exit();
                        }
                    } else {
                        $response['success'] = false;
                        $response['msg'] = "No Cancellation Allowed";
                        echo json_encode($response);
                        exit();
                    }
					$eventBookingUpdateArray = array(
						'event_booking_id' => $eventBookingId,
                        'is_cancel' => 1,
						'cancel_reason' => $cancelReason,
					);
					$eventBookingExtraDataArray = array();
	                $eventBookingExtraDataArray['module_id'] = $eventBookingId;
	                $eventBookingExtraDataArray['module'] = 'Event Booking Cancel';
	                $eventBookingExtraDataArray['type'] = 'Event';
	                $eventBookingExtraDataArray['old_data'] = $eventBookingData;
	                $eventBookingExtraDataArray['user_id'] = $this->data['userId'];
	                $eventBookingExtraDataArray['society_id'] = $this->session->get('society_id');
					$closingUpdateData = $this->event_booking_model->insertUpdateRecord($eventBookingUpdateArray, "event_booking_id",  'tbl_event_booking',1,$eventBookingExtraDataArray);
				}	
			}
			if ($closingUpdateData['success']) {
				$this->db->transCommit();
				$response['success']  = true;
				$response['msg']      = "Event Booking Cancelled Successfully";
			} else {
				$this->db->transRollback();
				$response['success']  = false;
				$response['msg']      = "Event Booking Cancel Error!";
			}
			echo json_encode($response);
			exit();
		// }
	}
}
