<?php
namespace App\Controllers\Admin;

use CodeIgniter\Controller;
use App\Models\EmergencyContactModel;

class EmergencyContact extends BaseController
{
    protected $emergency_contact_model;
    public function __construct() {
        $this->emergency_contact_model = new EmergencyContactModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Emergency Contact';
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","EmergencyContact/EmergencyContactView",$data);
    }

    public function manage($emergencyNumberId = '')
	{
		$data['extra_js'] = array(
			"js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
		);

        if ($emergencyNumberId != '') {
			$filterData = array(
				"emergency_number_id" => $emergencyNumberId
			);
			$data['emergency_contact_data'] = $this->emergency_contact_model->getEmergencyContactData($filterData);
            
            if ((isset($data['emergency_contact_data']['is_deleted']) && $data['emergency_contact_data']['is_deleted'] != 0)) {
                return redirect()->to('Admin/EmergencyContact');
            }

			if (empty($data['emergency_contact_data'])) {
                return redirect()->to('Admin/EmergencyContact');
            }
		}
		if ($emergencyNumberId != '') {
			$data['title'] = 'Edit EmergencyContact';
		} else {
			$data['title'] = 'Add EmergencyContact';
		}
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
		if ((isset($data['emergency_contact_data']['society_id']) && $data['emergency_contact_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/EmergencyContact');
        }
		$this->dt_ci_template->load("Admin","EmergencyContact/EmergencyContactManageView",$data);
	}

    public function getEmergencyContactListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $this->datatables->table('tbl_emergency_number as ten');

        $this->datatables->select("ten.emergency_number_id,ten.name,ten.description,ten.emergency_contact_number,ten.society_id,ten.is_active,ts.society_name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ten.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,ten.created_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ten.updated_by AND tupdate.society_id = ten.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = ten.created_by AND tcreate.society_id = ten.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = ten.society_id","left");
        $this->datatables->where("ten.is_deleted = 0");
        $this->datatables->groupBy("ten.emergency_number_id");

        accessFilter($this->datatables, array("society" => "ten.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
					"emergency_number_id" => isset($displayData['emergency_number_id']) ? $displayData['emergency_number_id'] : ""
				);
                $data[$key]['action_button'] = emergencyContactActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : '-';
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function changeStatus(){
        $emergencyNumberId = $this->request->getVar('emergency_number_id');
        $status = $this->request->getVar('status');
        $return = $this->emergency_contact_model->statusChange($emergencyNumberId,$status,'emergency_number_id','tbl_emergency_number');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('EmergencyContact.emergency_contact'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('EmergencyContact.emergency_contact'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
        $this->db->transStart();
		$validation = \Config\Services::validation();
		$emergencyNumberId = $this->request->getVar('emergency_number_id');
		$name = $this->request->getVar('name');
		$emergencyContactNummber = $this->request->getVar('emergency_contact_number');
		$description = $this->request->getVar('description');
		$isActive = $this->request->getVar('is_active');

		$validation->setRule('name', lang('EmergencyContact.name'), 'required');
		$validation->setRule('emergency_contact_number', lang('EmergencyContact.emergency_contact_number'), 'required');
		$validation->setRule('description', lang('EmergencyContact.description'), 'required');

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			$emerygencyContactUpdateArray = array();
			$emerygencyContactArray = array(
				'emergency_number_id' => $emergencyNumberId,
				'name' => $name,
				'emergency_contact_number' => $emergencyContactNummber,
				'description' => $description,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
			);
			if(!empty($emergencyNumberId)){
                $emerygencyContactUpdateData = $this->emergency_contact_model->getEmergencyContactData(array(
                    'emergency_number_id' => $emergencyNumberId,
                ));
                $emerygencyContactUpdateArray = compareArray($emerygencyContactArray,$emerygencyContactUpdateData);
            }
			$emerygencyContactData = $this->emergency_contact_model->insertUpdateRecord($emerygencyContactArray, 'emergency_number_id', 'tbl_emergency_number', 1,'',array(),array(),$emerygencyContactUpdateArray);
			$lastEmergencyContactId = $emerygencyContactData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
			if (isset($emergencyNumberId) && $emergencyNumberId != '') {
				if (($emerygencyContactData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("EmergencyContact.emergency_contact"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("EmergencyContact.emergency_contact"));
				}
			} else {
				if (($emerygencyContactData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("EmergencyContact.emergency_contact"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("EmergencyContact.emergency_contact"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
		$emergencyNumberId = $this->request->getVar('emergency_number_id');
        $userId =  $this->data['userId'];
		$emergencyContactData = $this->emergency_contact_model->deleteRecord($emergencyNumberId,$userId);
        $transactionStatus = $this->db->transComplete();
        if (($emergencyContactData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("EmergencyContact.emergency_contact"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("EmergencyContact.emergency_contact"));
        }
        echo json_encode($response);
        exit;
    }

    public function excelExportEmergencyContact()
    {
        $fileName ='emergency-contact-' . DATETIMEFORMAT;
        $sheetName = 'EmergencyCon-' . DATEFORMAT;
        $excelHeaderName = 'EmergencyContact';
        $tableData = $this->getEmergencyContactListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('EmergencyContact.name'),
            lang('EmergencyContact.contact_number'),
            lang('EmergencyContact.description'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["name"],
                $row["emergency_contact_number"],
                $row["description"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    // public function view($id = null)
    // {
    //     $emergencyNumberId = $this->request->getVar("view_id");
    //     if($emergencyNumberId == "" && $emergencyNumberId == null){
    //         return redirect()->to('Admin/EmergencyContact');
    //     }
    //     else {
    //         $id = $emergencyNumberId;
    //         $filterData = array(
    //             "emergency_number_id" => $emergencyNumberId
    //         );
    //         $data['emergency_contact_data'] = $this->emergency_contact_model->getEmergencyContactData($filterData);
    //         if (empty($data['emergency_contact_data'])) {
    //             return redirect()->to('Admin/EmergencyContact');
    //         }

    //         $data['image_data'] = $this->visitor_model->getDocumentImageData(array(
    //             "document_type_id" => $emergencyNumberId,
    //             "document_type" => 'forum',
    //             "is_multiple" => 1
    //         ));
    //         // printArray($data['image_data'],1);

    //         $forumView = view("Admin/EmergencyContact/EmergencyContactModelView", $data);
    //         $response['view_title'] = "EmergencyContact Details";
    //         $response['view_detail'] = $forumView;
    //         $response['success'] = true;
    //         echo json_encode($response);
    //     }
    // }
}