<?php
namespace App\Controllers\Admin;

use App\Models\BannerModel;
use CodeIgniter\Controller;
use App\Models\DocumentFolderModel;
use App\Libraries\ZipLibrary;
class DocumentFolder extends BaseController
{
    protected $document_folder_model;
    public function __construct() {
        $this->document_folder_model = new DocumentFolderModel();
        $this->banner_model = new BannerModel();
        // checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);
           
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Document Folder';
        return $this->dt_ci_template->load("Admin","DocumentFolder/DocumentFolderView",$data);
    }

	public function manage($documentFolderId = '')
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($documentFolderId != '') {
			$filterData = array(
				"document_folder_id" => $documentFolderId
			);
			$data['document_folder_data'] = $this->document_folder_model->getDocumentFolderData($filterData);

            $data['document_folder_item_data'] = $this->document_folder_model->getDocumentFolderItemData(array(
                'document_folder_id' => $documentFolderId,
                'is_multiple' => 1
            ));

            // printArray($data['document_folder_item_data'],1);
		}
		if ($documentFolderId != '') {
			$data['title'] = 'Edit Document';
		} else {
			$data['title'] = 'Add Document';
		}
		if ((isset($data['document_folder_data']['society_id']) && $data['document_folder_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/DocumentFolder');
        }
        $data['document_folder_item_table'] = view('Admin/DocumentFolder/DocumentFolderItemView', isset($data) ? $data : array());
		return $this->dt_ci_template->load("Admin","DocumentFolder/DocumentFolderManageView",$data);
	}

    public function getDocumentFolderListing($return = false)
    {
        // printArray($this->datatables,1);
        $this->datatables->table("tbl_document_folder tdf");
		$this->datatables->select("tdf.document_folder_id,tdf.folder_name");
        $this->datatables->select("(select count(*) from tbl_document_folder_item as tdfi where tdfi.document_folder_id = tdf.document_folder_id) as no_of_document");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tdf.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tdf.created_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tdf.updated_by AND tupdate.society_id = tdf.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tdf.created_by AND tcreate.society_id = tdf.society_id","left");

		$this->datatables->groupBy("tdf.document_folder_id");
        accessFilter($this->datatables, array("society" => "tdf.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"document_folder_id" => isset($data[$key]['document_folder_id']) ? $data[$key]['document_folder_id'] : ""
				);
				$data[$key]['action_button'] = documentFolderActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $documentFolderId = $this->request->getVar('document_folder_id');
        $status = $this->request->getVar('status');
        $return = $this->document_folder_model->statusChange($documentFolderId,$status,'document_folder_id','tbl_document_folder');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Document.document'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Document.document'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
        $this->db->transStart();
		$validation = \Config\Services::validation();
        
		$documentFolderId = $this->request->getVar('document_folder_id');
		$folderName = $this->request->getVar('folder_name');
		
        $validation->setRule('folder_name',lang('DocumentFolder.folder_name'),'required');
		$validation->setRule('document_folder_title.*', lang('DocumentFolder.document_folder_title'), 'required');
		$validation->setRule('description.*', lang('DocumentFolder.description'), 'required');
		$validation->setRule('effective_date.*', lang('DocumentFolder.effective_date'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $imageFormatsForThumbnail = array('jpg', 'jpeg', 'png', 'JPG'); // Only these formats will have thumbnails
            $documentFolderItemImage = array();
			if (isset($_FILES["document_image"])) {
				$documentFolderItemImagePath = DOCUMENT_IMAGE_PATH;
				$documentFolderItemImage = $this->dt_ci_file_upload->UploadMultipleFile('document_image', MAX_IMAGE_SIZE_LIMIT, $documentFolderItemImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG','pdf'));
				if ($documentFolderItemImage['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($documentFolderItemImage['message']);
					echo json_encode($response);
					die();
				}
                else{
                    unset($documentFolderItemImage['success']);
                    foreach ($documentFolderItemImage as $file) {
                        $extension = pathinfo($file['file_name'], PATHINFO_EXTENSION);
                        if (in_array(strtolower($extension), $imageFormatsForThumbnail)) {
                            $thumbnailResult = $this->dt_ci_file_upload->ThumbnailUploadFile($file, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                        }
                    }
                }
			}
			$documentFolderUpdateArray = array();
			$documentFolderArray = array(
				'document_folder_id' => $documentFolderId,
                'society_id' => $this->session->get('society_id'),
				'folder_name' => $folderName,
			);

			if(!empty($documentFolderId)){
                $documentFolderUpdateData = $this->document_folder_model->getDocumentFolderData(array(
                    'document_folder_id' => $documentFolderId,
                ));
				$documentFolderUpdateArray = compareArray($documentFolderArray,$documentFolderUpdateData);
            }
			$documentData = $this->document_folder_model->insertUpdateRecord($documentFolderArray, 'document_folder_id', 'tbl_document_folder', 1,'',array(),array(),$documentFolderUpdateArray);
			$lastDocumentFolderId = $documentData['lastInsertedId'];
            
            $documentFolderItemIdArray = $this->request->getVar('document_folder_item_id');
            $documentFolderTitleArray = $this->request->getVar('document_folder_title');
            $effectiveDateArray = $this->request->getVar('effective_date');
            $descriptionArray = $this->request->getVar('description');

            if(!empty($documentFolderItemIdArray)){
                foreach($documentFolderItemIdArray as $key => $documentFolderItemId){
                    $documentFolderTitle = array_key_exists($key, $documentFolderTitleArray) ? $documentFolderTitleArray[$key] : '';
                    $effectiveDate = array_key_exists($key, $effectiveDateArray) ? $effectiveDateArray[$key] : '';
                    $description = array_key_exists($key, $descriptionArray) ? $descriptionArray[$key] : '';

                    $itemDetailInsertUpdateArray = array(
                        'document_folder_item_id' => $documentFolderItemId,
                        'document_folder_id' => $lastDocumentFolderId,
                        'document_folder_title' => $documentFolderTitle,
                        'effective_date' => DMYToYMD($effectiveDate),
                        'description' => $description,
                    );
                
                    $documentFolderItemData = $this->document_folder_model->insertUpdateRecord($itemDetailInsertUpdateArray, 'document_folder_item_id', 'tbl_document_folder_item', 1,'',array(),array(),array());
                    $lastDocumentFolderItemId = $documentFolderItemData['lastInsertedId'];

                    if($lastDocumentFolderId != ''){
                        if(isset($documentFolderItemImage) && count($documentFolderItemImage) > 0 && array_key_exists($key, $documentFolderItemImage)){
                        $this->banner_model->deleteDocumentImageRecord(array('document_type' => 'document_folder','document_type_id' => $lastDocumentFolderItemId));
                            $dataArray = array(
                                'document_image_id' =>   '',
                                'document_type' =>   'document_folder',
                                'document_type_id' => $lastDocumentFolderItemId,
                                'document_image' => array_key_exists($key, $documentFolderItemImage) ? $documentFolderItemImage[$key]['file_name'] : "",
                            );
                           $documentFolderItemImageData =  $this->document_folder_model->insertUpdateRecord($dataArray,'document_image_id', 'tbl_document_image', 1,'',array(),array(),array());
                        }
                    }
                }
            }
            $transactionStatus = $this->db->transComplete();
			if (isset($documentFolderId) && $documentFolderId != '') {
                if (($documentData['success']) && $transactionStatus == 1) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('DocumentFolder.document_folder'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('DocumentFolder.document_folder'));
                }
            } else {
                if (($documentData['success']) && $transactionStatus == 1) {
                        $response['success']  = true;
                        $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('DocumentFolder.document_folder'));
                    // }
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('DocumentFolder.document_folder'));
                }
            }
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $documentFolderId = $this->request->getVar('document_folder_id');
        $ids = is_array($documentFolderId) ? implode(',', $documentFolderId) : $documentFolderId;
        //  if( isReferenceInTable( 'document_folder_id','tbl_module_document', $documentFolderId)
        //  ){
		// 	 if(!empty($documentFolderId)){
		// 	 	foreach($documentFolderId as $documentElement){
		// 	 		$deleteDataArray['module'] = 'Document';
		// 	 		$deleteDataArray['activity'] = "Tried to delete Document ";
		// 	 		$deleteDataArray['module_id'] = $documentElement;
		// 	 		logActivity('Tried to delete Document [DocumentID: ' . $documentElement . ']',$this->data['userId'],'Document',$documentElement,json_encode($deleteDataArray),'','Document',$documentElement);
		// 	 	}
		// 	 }
        //      $response['success'] = false;
        //      $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
        //      echo json_encode($response);
        //      exit;
        //  }

        $imageData = $this->document_folder_model->getDocumentFolderItemData(array(
            'document_folder_id' => $documentFolderId,
            'is_multiple' => 1
        ));


        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 

                $thumbnailFileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                } 
            }
        }

        $filterData = array(
            'document_folder_id' => $documentFolderId,
            'is_multiple' => 1,
        );
        $documentFolderItemData = $this->document_folder_model->getDocumentFolderItemData($filterData);
        // printArray($documentFolderItemData);
        foreach ($documentFolderItemData as $key => $documentFolderItem) {
            // printArray($documentFolderItem,1);
            $this->banner_model->deleteDocumentImageRecord(array('document_type' => 'document_folder','document_type_id' => $documentFolderItem['document_folder_item_id']));
        }
        $documentData = $this->document_folder_model->deleteRecord($documentFolderId);
        $transactionStatus = $this->db->transComplete();
        if (($documentData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("DocumentFolder.document_folder"));
        } else {    
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("DocumentFolder.document_folder"));
        }
        echo json_encode($response);
        exit;
    }

    // public function getDocumentDd(){
    //     $filterParameter = $this->request->getVar('filter_param');
    //     $page            = $this->request->getVar('page');
    //     $documentFolderId            = $this->request->getVar('document_folder_id');
    //     $documentFolder		= $this->request->getVar('document_folder_for');
    //     $filterData = array(
    //         'filter_param' => $filterParameter,
    //         'page' => $page,
    //         'start' => 0,
    //         'limit' => DATA_LIMIT,
    //         'document_folder_id' => $documentFolderId,
    //         'document_folder_for' => $documentFolder,
    //         'is_active' => 1,
    //     );
    //     echo $this->document_folder_model->getDocument($filterData);
    // }

    public function addDocumentFolderItemRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $itemRow = view('Admin/DocumentFolder/DocumentFolderItemRowView', $data);
        echo $itemRow;
    }

    public function deleteDocumentFolderItemRow()
    {
        $this->db->transStart();
        $documentFolderItemId  = $this->request->getVar('document_folder_item_id');
        $documentFolderId = $this->request->getVar('document_folder_id');

        $imageData = $this->document_folder_model->getDocumentFolderItemData(array(
            'document_folder_item_id' => $documentFolderItemId,
            'is_multiple' => 1
        ));


        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 

                $thumbnailFileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                } 
            }
        }

        $this->banner_model->deleteDocumentImageRecord(array('document_type' => 'document_folder','document_type_id' => $documentFolderItemId));
        $documentFolderItemData = $this->document_folder_model->deleteDocumentFolderItemRecord($documentFolderItemId);
        // $resourceFaltData = $this->document_folder_model->deleteAdminPanelFlatRecord($documentFolderItemId);
        
        if (($documentFolderItemData)) {
            if(!empty($documentFolderItemData)){
                foreach($documentFolderItemData as $documentElement){
                    $deleteDataArray['module'] = 'Document Folder Item';
                    $deleteDataArray['activity'] = "Document Folder Item Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Document Folder Item Deleted [DocumentFolderItemID: ' . $documentElement . ']',$this->data['userId'],'Document Folder Item',$documentElement,json_encode($deleteDataArray),'','Document Folder',$documentFolderId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Material.material_item'));
            }
            else{
               $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Material.material_item')); 
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Material.material_item'));
        }
        echo json_encode($response);
        exit();
    }

    public function view($id = null)
    {
        $documentFolderId = $this->request->getVar("view_id");
        if($documentFolderId == "" && $documentFolderId == null){
            return redirect()->to('Admin/DocumentFolder');
        }
        else {
            $id = $documentFolderId;
            $filterData = array(
                "document_folder_id" => $documentFolderId
            );
            $data['document_folder_data'] = $this->document_folder_model->getDocumentFolderData($filterData);
            $data['document_folder_item_data'] = $this->document_folder_model->getDocumentFolderItemData(array(
                'document_folder_id' => $documentFolderId,
                'is_multiple' => 1
            ));
            $documentFolderView = view("Admin/DocumentFolder/DocumentFolderModelView", $data);
            $response['view_title'] = "Document Folder Details";
            $response['view_detail'] = $documentFolderView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function documentZip($documentFolderId)
    {
        $documentFolderData = $this->document_folder_model->getDocumentFolderData([
            "document_folder_id" => $documentFolderId
        ]);
        $zipFileName = $documentFolderData['folder_name'] . '.zip';
        $zip = new ZipLibrary('documents.zip');
        $filesAdded = false;
        $documentFolderItemData = $this->document_folder_model->getDocumentFolderItemData([
            "document_folder_id" => $documentFolderId,
            'is_multiple' => 1
        ]);
        if (!empty($documentFolderItemData)) {
            foreach ($documentFolderItemData as $documentElement) {
                $filePath = DOCUMENT_IMAGE_PATH . $documentElement['document_image'];
                if (file_exists($filePath)) {
                    $zip->addFile($filePath, $documentElement['document_image']);
                    $filesAdded = true;
                }
            }
        }
        if (!$filesAdded) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'No documents found to create a ZIP file.'
            ]);
        }
        return $zip->download();
    }
}
