<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\CommonAreaModel;
class CommonArea extends BaseController
{
    protected $common_area_model;
    public function __construct() {
        $this->common_area_model = new CommonAreaModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Common Area';
        $data['common_area_modal_view'] = view('Admin/CommonArea/CommonAreaModalView', $data);
        return $this->dt_ci_template->load("Admin","CommonArea/CommonAreaView",$data);
    }

    public function getCommonAreaListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_common_area as tca");
        $this->datatables->select("tca.common_area_id, tca.common_area_name, tca.is_active");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tca.created_at,tca.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tca.updated_by AND tupdate.society_id = tca.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tca.created_by AND tcreate.society_id = tca.society_id","left");
        $this->datatables->groupBy("tca.common_area_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "common_area_id" => isset($displayData['common_area_id']) ? $displayData['common_area_id'] : "",
                );
                $data[$key]['action_button'] = commonAreaActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $commonAreaId = $this->request->getVar('common_area_id');
        $commonAreaName = $this->request->getVar('common_area_name');
        $isActive = $this->request->getVar('is_active');

        if (isset($commonAreaId) && $commonAreaId == '') {
			$validation->setRule('common_area_name', lang('CommonArea.common_area_name'), 'required|combination_unique[tbl_common_area.common_area_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			$validation->setRule('common_area_name', lang('CommonArea.common_area_name'), 'required|edit_unique[tbl_common_area.common_area_name.' . $commonAreaId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $commonAreaUpdateArray = array();
            $commonAreaArray = array(
                'common_area_id' => $commonAreaId,
                'common_area_name' => $commonAreaName,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );
            // $commonAreaData = $this->common_area_model->insertUpdateRecord($commonAreaArray,'common_area_id','tbl_common_area', 1,'',array());
            if(!empty($commonAreaId)){
                $commonAreaUpdateData = $this->common_area_model->getCommonAreaData(array(
                    'common_area_id' => $commonAreaId,
                ));
                $commonAreaUpdateArray = compareArray($commonAreaArray,$commonAreaUpdateData);
            }
            $commonAreaData = $this->common_area_model->insertUpdateRecord($commonAreaArray,'common_area_id','tbl_common_area', 1,'',array(),array(),$commonAreaUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($commonAreaId) && $commonAreaId != '') {
                if (($commonAreaData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('CommonArea.common_area'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('CommonArea.common_area'));
                }
            } else {
                if (($commonAreaData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('CommonArea.common_area'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('CommonArea.common_area'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $commonAreaId = $this->request->getVar('common_area_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->common_area_model->statusChange($commonAreaId,$status,'common_area_id','tbl_common_area');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('CommonArea.common_area'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('CommonArea.common_area'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $commonAreaId = $this->request->getVar('common_area_id');
        if( isReferenceInTable('common_area_id', 'tbl_intercom', $commonAreaId) ||
            isReferenceInTable('common_area_id', 'tbl_amenities_common_area', $commonAreaId)||
            isReferenceInTable('common_area_id', 'tbl_event', $commonAreaId)||
            isReferenceInTable('common_area_id', 'tbl_intercom', $commonAreaId)||
            isReferenceInTable('common_area_id', 'tbl_item', $commonAreaId) ||
            isReferenceInTable('common_area_id', 'tbl_item_balance', $commonAreaId) ||
            isReferenceInTable('common_area_id', 'tbl_item_ledger', $commonAreaId) ||
            isReferenceInTable('common_area_id', 'tbl_material', $commonAreaId)
        ) {

            if (!empty($commonAreaId)) {
                foreach ($commonAreaId as $commonArea) {
                    $deleteDataArray['module'] = 'CommonArea';
                    $deleteDataArray['activity'] = "Tried to delete Common Area ";
                    $deleteDataArray['module_id'] = $commonArea;
                    logActivity('Tried to delete Common Area [CommonAreaID: ' . $commonArea . ']', $this->data['userId'], 'CommonArea', $commonArea, json_encode($deleteDataArray), '', 'CommonArea', $commonArea);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $commonAreaData = $this->common_area_model->deleteRecord($commonAreaId);
        $transactionStatus = $this->db->transComplete();
        if (($commonAreaData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('CommonArea.common_area'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('CommonArea.common_area'));
        }
        echo json_encode($response);
        exit;
    }

    public function getCommonAreaDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $commonAreaId = $this->request->getVar('common_area_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'common_area_id' => $commonAreaId,

        );
        echo $this->common_area_model->getCommonArea($filterData);
    }

    public function excelExportCommonArea()
    {
        $fileName ='common_area-' . DATETIMEFORMAT;
        $sheetName = 'CommonArea-' . DATEFORMAT;
        $excelHeaderName = 'CommonArea';
        $tableData = $this->getCommonAreaListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('CommonArea.common_area'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["common_area_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
