<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ChargesModel;
class Charges extends BaseController
{
    protected $charges_model;
    public function __construct() {
        $this->charges_model = new ChargesModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Charges';
        return $this->dt_ci_template->load("Admin","Charges/ChargesView",$data);
    }

    public function getChargesListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_charges as tc");
        $this->datatables->select("tc.charges_id,tc.charges_name,tc.fee_type,tc.amount,tc.tax_id,tc.remarks,tc.society_id,tc.is_active,ts.society_name,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tc.updated_at,tc.charges_name,tt.tax_name,tc.deposit");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tc.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tc.updated_by AND tupdate.society_id = tc.society_id","left");
        $this->datatables->join("tbl_tax as tt","tt.tax_id = tc.tax_id","left");
        $this->datatables->groupBy("tc.charges_id");
        accessFilter($this->datatables, array("society" => "tc.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "charges_id" => isset($displayData['charges_id']) ? $displayData['charges_id'] : ""
                );
                $data[$key]['action_button'] = chargesActionButton($actionButtonFilter);
                $data[$key]['fee_type'] = underscoreToUcWord($displayData['fee_type']);
                $data[$key]['amount'] = isset($displayData['amount']) ? indianMoneyFormat($displayData['amount'],2,1) : '-';
                $data[$key]['deposit'] = isset($displayData['deposit']) ? indianMoneyFormat($displayData['deposit'],2,1) : '-';
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($chargesId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($chargesId != '') {
            $filterData = array(
                "charges_id" => $chargesId
            );
            $data['charges_data'] = $this->charges_model->getChargesData($filterData);

            if (empty($data['charges_data'])) {
                return redirect()->to('Admin/Charges');
            }
        }
        if ($chargesId != '') {
            $data['title'] = 'Edit Charges';
        } else {
            $data['title'] = 'Add Charges';
        }
        if ((isset($data['charges_data']['society_id']) && $data['charges_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Charges');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $this->dt_ci_template->load("Admin","Charges/ChargesManageView",$data);
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $chargesId = $this->request->getVar('charges_id');
        $chargesName = $this->request->getVar('charges_name');
        $feeType = $this->request->getVar('fee_type');
        $amount = $this->request->getVar('amount');
        $deposit = $this->request->getVar('deposit');
        $taxId = $this->request->getVar('tax_id');
        $remarks = $this->request->getVar('remarks');
        $isActive = $this->request->getVar('is_active');

       $validation->setRule('fee_type', lang('Charges.fee_type'), 'required');
       $validation->setRule('amount', lang('Charges.amount'), 'required');
       // $validation->setRule('tax_id', lang('Charges.gst'), 'required');
       

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $chargesForNameCheck = $this->charges_model->checkChargesNameExist(array('charges_id' => $chargesId,'charges_name' => $chargesName,'fee_type' => $feeType,'society_id' => $this->session->get('society_id')));

            if(!empty($chargesForNameCheck)){
                $response['success'] = false;
                $response['msg'] = "This Fee Type ".underscoreToUcWord($chargesForNameCheck['fee_type']). " Charges Name ". $chargesName. " Already Exists";
                echo json_encode($response);
                exit();
            }

            $chargesUpdateArray = array();
            $chargesArray = array(
                'charges_id' => $chargesId,
                'charges_name' => $chargesName,
                'fee_type' => $feeType,
                'amount' => $amount,
                'deposit' => $deposit,
                'tax_id' => $taxId,
                'remarks' => $remarks,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );

            if(!empty($chargesId)){
                $chargesUpdateData = $this->charges_model->getChargesData(array(
                    'charges_id' => $chargesId,
                ));
                $chargesUpdateArray = compareArray($chargesArray,$chargesUpdateData);
            }

            $chargesData = $this->charges_model->insertUpdateRecord($chargesArray,'charges_id','tbl_charges', 1,'',array(),array(),$chargesUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($chargesId) && $chargesId != '') {
                if (($chargesData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Charges.charges'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Charges.charges'));
                }
            } else {
                if (($chargesData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Charges.charges'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Charges.charges'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $chargesId = $this->request->getVar('charges_id');
        $status = $this->request->getVar('status');

        $return = $this->charges_model->statusChange($chargesId,$status,'charges_id','tbl_charges');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Charges.charges'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Charges.charges'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $chargesId = $this->request->getVar('charges_id');
        $chargesData  = $this->charges_model->deleteRecord($chargesId);
        $transactionStatus = $this->db->transComplete();
        if (($chargesData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Charges.charges'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Charges.charges'));
        }
        echo json_encode($response);
        exit;
    }
    public function view($id = null)
    {
        $chargesId = $this->request->getVar("view_id");
        if($chargesId == "" && $chargesId == null){
            return redirect()->to('Admin/Charges');
        }
        else {
            $id = $chargesId;
            $filterData = array(
                "charges_id" => $chargesId
            );
            $data['charges_data'] = $this->charges_model->getChargesData($filterData);
            $chargesView = view("Admin/Charges/ChargesModelView", $data);
            $response['view_title'] = "Charges Details";
            $response['view_detail'] = $chargesView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function excelExportCharges()
    {
        $fileName ='charges-' . DATETIMEFORMAT;
        $sheetName = 'Charges-' . DATEFORMAT;
        $excelHeaderName = 'Charges';
        $tableData = $this->getChargesListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Charges.society'),
            lang('Charges.fee_type'),
            lang('Charges.charges_name'),
            lang('Charges.amount'),
            lang('Charges.deposit'),
            lang('Charges.gst'),
            lang('Charges.remarks'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["fee_type"],
                $row["charges_name"],
                $row["amount"],
                $row["deposit"],
                $row["tax_name"],
                $row["remarks"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'H';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
