<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\BudgetModel;
use App\Models\DocumentModel;
class Budget extends BaseController
{
    protected $budget_model;
    public function __construct() {
        $this->budget_model = new BudgetModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/toastr/toastr.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Budget';
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","Budget/BudgetView",$data);
	}

	public function manage($budgetId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"vendor/libs/toastr/toastr.js",
			"js/additional_methods.min.js",
        );
		if ($budgetId != '') {
		    $filterData = array("budget_id" => $budgetId,"society_id" => $this->session->get('society_id'),);
		    $data['budget_data'] = $this->budget_model->getBudgetData($filterData);
		    if (empty($data['budget_data'])) {
		        return redirect()->to('Admin/Budget');
		    }

		    // Fetch saved expense data (Edit mode)
		    $expBudgetSubLedData = $this->budget_model->getBudgetAccountSubAccountData(array(
		        "is_multiple" => 1,
		        "budget_id" => $budgetId,
		        "account_type" => "expense"
		    ));
		    
		    // Fetch all available expense data (Add mode)
		    $expenseData = $this->budget_model->getAccountSubAccountData(array(
		        "is_multiple" => 1,
				"society_id" => $this->session->get('society_id'),
		        "account_type" => "expense"
		    ));
		    
		    $expenseFilterData = array();
		    $expenseAccountWiseData = array();
		    $expenseSavedData = array();
		    
		    if (!empty($expBudgetSubLedData)) {
		        foreach ($expBudgetSubLedData as $expenseElement) {
		            $expenseSavedData[$expenseElement['sub_account_id']] = $expenseElement['amount'];
		        }
		    }
		    
		    if (!empty($expenseData)) {
		        foreach ($expenseData as $expenseElement) {
		            $subAccountObjectArray = array();
		            $subAccountObjectArray['sub_account_id'] = $expenseElement['sub_account_id'];
		            $subAccountObjectArray['sub_account_code_name'] = $expenseElement['sub_account_code_name'];
		            $subAccountObjectArray['amount'] = isset($expenseSavedData[$expenseElement['sub_account_id']])
		                ? $expenseSavedData[$expenseElement['sub_account_id']]
		                : 0;
		            
		            $expenseAccountWiseData[$expenseElement['account_code_name']][] = $subAccountObjectArray;
		            
		            if (!isset($expenseFilterData[$expenseElement['account_code_name']])) {
		                $expenseFilterData[$expenseElement['account_code_name']]['account_code_name'] = $expenseElement['account_code_name'];
		                $expenseFilterData[$expenseElement['account_code_name']]['account_id'] = $expenseElement['account_id'];
		            }
		        }
		    }

		    $expenseFilterData = array_values($expenseFilterData);
		    foreach ($expenseFilterData as $expKey => $expenseFilterElement) {
		        $expenseFilterData[$expKey]['sub_account_data'] = $expenseAccountWiseData[$expenseFilterElement['account_code_name']] ?? array();
		    }
		    
		    // Repeat the same logic for income data
		    $incBudgetSubLedData = $this->budget_model->getBudgetAccountSubAccountData(array(
		        "is_multiple" => 1,
		        "budget_id" => $budgetId,
		        "account_type" => "income"
		    ));
		    
		    $incomeData = $this->budget_model->getAccountSubAccountData(array(
		        "is_multiple" => 1,
				"society_id" => $this->session->get('society_id'),
		        "account_type" => "income"
		    ));
		    
		    $incomeFilterData = array();
		    $incomeAccountWiseData = array();
		    $incomeSavedData = array();
		    
		    if (!empty($incBudgetSubLedData)) {
		        foreach ($incBudgetSubLedData as $incomeElement) {
		            $incomeSavedData[$incomeElement['sub_account_id']] = $incomeElement['amount'];
		        }
		    }
		    
		    if (!empty($incomeData)) {
		        foreach ($incomeData as $incomeElement) {
		            $subAccountObjectArray = array();
		            $subAccountObjectArray['sub_account_id'] = $incomeElement['sub_account_id'];
		            $subAccountObjectArray['sub_account_code_name'] = $incomeElement['sub_account_code_name'];
		            $subAccountObjectArray['amount'] = isset($incomeSavedData[$incomeElement['sub_account_id']])
		                ? $incomeSavedData[$incomeElement['sub_account_id']]
		                : 0;
		            
		            $incomeAccountWiseData[$incomeElement['account_code_name']][] = $subAccountObjectArray;
		            
		            if (!isset($incomeFilterData[$incomeElement['account_code_name']])) {
		                $incomeFilterData[$incomeElement['account_code_name']]['account_code_name'] = $incomeElement['account_code_name'];
		                $incomeFilterData[$incomeElement['account_code_name']]['account_id'] = $incomeElement['account_id'];
		            }
		        }
		    }
		    
		    $incomeFilterData = array_values($incomeFilterData);
		    foreach ($incomeFilterData as $incKey => $incomeFilterElement) {
		        $incomeFilterData[$incKey]['sub_account_data'] = $incomeAccountWiseData[$incomeFilterElement['account_code_name']] ?? array();
		    }
		}
		else {
			$expenseData = $this->budget_model->getAccountSubAccountData(array(
				"is_multiple" => 1,
				"society_id" => $this->session->get('society_id'),
				"account_type" => "expense"
			));
			$expenseFilterData = array();
			$expenseAccountWiseData = array();
			if(!empty($expenseData)){
				foreach ($expenseData as $expenseElement) {
					$subAccountObjectArray = array();
					$subAccountObjectArray['sub_account_id'] = $expenseElement['sub_account_id'];
					$subAccountObjectArray['sub_account_code_name'] = $expenseElement['sub_account_code_name'];
					$expenseAccountWiseData[$expenseElement['account_code_name']][] = $subAccountObjectArray;
					if(!isset($expenseFilterData[$expenseElement['account_code_name']])) {
						$expenseFilterData[$expenseElement['account_code_name']]['account_code_name'] = $expenseElement['account_code_name'];
						$expenseFilterData[$expenseElement['account_code_name']]['account_id'] = $expenseElement['account_id']; // Added account_id
					} 
				}
			}
	
			if(!empty($expenseFilterData)){
				$expenseFilterData = array_values($expenseFilterData);
				foreach ($expenseFilterData as $expKey => $expenseFilterElement){
					$expenseFilterData[$expKey]['sub_account_data'] = array_key_exists($expenseFilterElement['account_code_name'],$expenseAccountWiseData) ?$expenseAccountWiseData[$expenseFilterElement['account_code_name']] : array();
				}
			}
			// printArray($expenseFilterData,1);
	
			$incomeData = $this->budget_model->getAccountSubAccountData(array(
				"is_multiple" => 1,
				"society_id" => $this->session->get('society_id'),
				"account_type" => "income"
			));
			$incomeFilterData = array();
			$incomeAccountWiseData = array();
			if(!empty($incomeData)){
				foreach ($incomeData as $incomeElement) {
					$subAccountObjectArray = array();
					$subAccountObjectArray['sub_account_id'] = $incomeElement['sub_account_id'];
					$subAccountObjectArray['sub_account_code_name'] = $incomeElement['sub_account_code_name'];
					$incomeAccountWiseData[$incomeElement['account_code_name']][] = $subAccountObjectArray;
					if(!isset($incomeFilterData[$incomeElement['account_code_name']])) {
						$incomeFilterData[$incomeElement['account_code_name']]['account_code_name'] = $incomeElement['account_code_name'];
						$incomeFilterData[$incomeElement['account_code_name']]['account_id'] = $incomeElement['account_id']; // Added account_id
					} 
				}
			}
			if(!empty($incomeFilterData)){
				$incomeFilterData = array_values($incomeFilterData);
				foreach ($incomeFilterData as $incKey => $incomeFilterElement){
					$incomeFilterData[$incKey]['sub_account_data'] = array_key_exists($incomeFilterElement['account_code_name'],$incomeAccountWiseData) ?$incomeAccountWiseData[$incomeFilterElement['account_code_name']] : array();
				}
			}
		}

		// printArray($incomeFilterData,1);

		if ($budgetId != '') {
			$data['title'] = 'Edit Budget';
		} else {
			$data['title'] = 'Add Budget';
		}

		$data['expense_data'] = $expenseFilterData;
		$data['income_data'] = $incomeFilterData;
		// printArray($data,1);
		$budgetTableView = view('Admin/Budget/BudgetAccountTableView', $data);
		// echo($budgetTableView);
		// die();
		$data['budget_account_table'] = $budgetTableView;
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['budget_data']['society_id']) && $data['budget_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Budget');
        }
		$this->dt_ci_template->load("Admin","Budget/BudgetManageView",$data);
	}

    public function getBudgetListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

        $this->datatables->table("tbl_budget as tb");
		$this->datatables->select("tb.budget_id,tfy.financial_year_prefix");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tb.updated_at");
		$this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tb.created_at");
		$this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = tb.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tb.updated_by AND tupdate.society_id = tb.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tb.created_by AND tcreate.society_id = tb.society_id","left");
		$this->datatables->join("tbl_financial_year as tfy","tfy.financial_year_id = tb.financial_year_id","left");
		$this->datatables->groupBy("tb.budget_id");
		accessFilter($this->datatables, array("society" => "tb.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"budget_id" => isset($data[$key]['budget_id']) ? $data[$key]['budget_id'] : ""
				);
				$data[$key]['action_button'] = budgetActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
				$data[$key]['created_at'] = isValidDate($data[$key]['created_at']) ? siteDateFormat($data[$key]['created_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$budgetId = $this->request->getVar('budget_id');
		$FyId = $this->request->getVar('financial_year_id');

		$validation->setRule('financial_year_id', lang('Budget.financial_year_id'), 'required');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$existsBudgetData = $this->budget_model->getBudgetData(array(
				"financial_year_id" => $FyId,
				"budget_id_not" => $budgetId
			));

			if(!empty($existsBudgetData)){
				$response['success'] = false;
				$response['msg'] = lang("Budget Already Exists For ".$existsBudgetData['financial_year_prefix']);
				echo json_encode($response);
				exit;
			}

			$budgetUpdateArray = array();
			$budgetArray = array(
				'budget_id' => $budgetId,
				'financial_year_id' => $FyId,
				'society_id' => $this->session->get('society_id'),
			);

			if(!empty($budgetId)){
                $budgetUpdateData = $this->budget_model->getBudgetData(array(
                    'budget_id' => $budgetId,
                ));
                $budgetUpdateArray = compareArray($budgetArray,$budgetUpdateData);
            }

			$budgetData = $this->budget_model->insertUpdateRecord($budgetArray, 'budget_id', 'tbl_budget', 1,'',array(),array(),$budgetUpdateArray);
			$lastBudgetId = $budgetData['lastInsertedId'];

			$budgetSubBudgetData = array();
            if(!empty($budgetId)) {
                $budgetSubBudgetData = $this->budget_model->getBudgetSubBudgetData(array(
                    'budget_id' => $budgetId,
                    'is_multiple' => 1
                ));
            }

			$expenseSubAccountIdArray = $this->request->getVar('expense_sub_account_id[]');
			$expenseAmountArray = $this->request->getVar('expense_amount[]');
			$expenseAccountIdArray = $this->request->getVar('expense_account_id[]');
            if(isset($budgetId) && $budgetId != ''){
                $this->budget_model->deleteBudgetSubAccountRecord($budgetId);
            }
            if(isset($expenseSubAccountIdArray)&& $expenseSubAccountIdArray != ''){
                $expSubAccountArray = array();
                foreach($expenseSubAccountIdArray as $eSBKey => $expSubBudgetId){
					$expAmount = array_key_exists($eSBKey, $expenseAmountArray) ? $expenseAmountArray[$eSBKey] : '';
					$expAccountId = array_key_exists($eSBKey, $expenseAccountIdArray) ? $expenseAccountIdArray[$eSBKey] : '';
                    $expSubAccountArray[] = array(
                        'budget_sub_account_id' => '',
                        'budget_id' => $lastBudgetId,
                        'account_id' => $expAccountId,
                        'sub_account_id' => $expSubBudgetId,
                        'amount' => $expAmount,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $budgetSocietyExtraDataArray = array();
                // $budgetSocietyExtraDataArray['module_id'] = $lastBudgetId;
                // $budgetSocietyExtraDataArray['module'] = 'Budget Sub Budget';
                // $budgetSocietyExtraDataArray['type'] = 'Budget';
                // $budgetSocietyExtraDataArray['old_data'] = $budgetSubBudgetData;
                // $budgetSocietyExtraDataArray['user_id'] = $this->data['userId'];
                // $budgetSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($expSubAccountArray)){
                    $this->budget_model->batchInsert($expSubAccountArray,'tbl_budget_sub_account',$budgetSocietyExtraDataArray);
                }
            }

			$incomeSubAccountIdArray = $this->request->getVar('income_sub_account_id[]');
			$incomeAmountArray = $this->request->getVar('income_amount[]');
			$incomeAccountIdArray = $this->request->getVar('income_account_id[]');
            if(isset($incomeSubAccountIdArray)&& $incomeSubAccountIdArray != ''){
                $incSubAccountArray = array();
                foreach($incomeSubAccountIdArray as $iSBKey => $incSubBudgetId){
					$incAmount = array_key_exists($iSBKey, $incomeAmountArray) ? $incomeAmountArray[$iSBKey] : '';
					$incLederId = array_key_exists($iSBKey, $incomeAccountIdArray) ? $incomeAccountIdArray[$iSBKey] : '';
                    $incSubAccountArray[] = array(
                        'budget_sub_account_id' => '',
                        'budget_id' => $lastBudgetId,
                        'sub_account_id' => $incSubBudgetId,
                        'account_id' => $incLederId,
                        'amount' => $incAmount,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $budgetSocietyExtraDataArray = array();
                $budgetSocietyExtraDataArray['module_id'] = $lastBudgetId;
                $budgetSocietyExtraDataArray['module'] = 'Budget Sub Account';
                $budgetSocietyExtraDataArray['type'] = 'Budget';
                $budgetSocietyExtraDataArray['old_data'] = $budgetSubBudgetData;
                $budgetSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $budgetSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($incSubAccountArray)){
                    $this->budget_model->batchInsert($incSubAccountArray,'tbl_budget_sub_account',$budgetSocietyExtraDataArray);
                }
            }
            $transactionStatus = $this->db->transComplete();
			if (isset($budgetId) && $budgetId != '') {
				if (($budgetData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Budget.budget"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Budget.budget"));
				}
			} else {
				if (($budgetData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Budget.budget"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Budget.budget"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $budgetId = $this->request->getVar('budget_id');
        //  if( isReferenceInTable( 'budget_id','tbl_men_power_attendance', $budgetId)){
		// 	 if(!empty($budgetId)){
		// 	 	foreach($budgetId as $documentElement){
		// 	 		$deleteDataArray['module'] = 'Budget';
		// 	 		$deleteDataArray['activity'] = "Tried to Delete Budget ";
		// 	 		$deleteDataArray['module_id'] = $documentElement;
		// 	 		logActivity('Tried to delete Budget [BudgetID: ' . $documentElement . ']',$this->data['userId'],'Budget',$documentElement,json_encode($deleteDataArray),'','Budget',$documentElement);
		// 	 	}
		// 	 }
        //      $response['success'] = false;
        //      $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
        //      echo json_encode($response);
        //      exit;
        //  }

        $budgetData = $this->budget_model->deleteRecord($budgetId);
		$this->budget_model->deleteBudgetSubAccountRecord($budgetId);
		$transactionStatus = $this->db->transComplete();
        if (($budgetData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Budget.budget"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Budget.budget"));
        }
        echo json_encode($response);
        exit;
    }

    public function getBudgetDd(){
    	$filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $budgetId = $this->request->getVar('budget_id');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'budget_id' => $budgetId,
            'society_id' => $this->session->get('society_id'),
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );

        echo $this->budget_model->getBudget($filterData);
    }

	public function pdf($id = null, $view = null, $save_bufffer = null,$zipPdf = 0)
	{
		if(empty($id)){
			$response['success'] = false;
			$response['msg'] = lang('Budget.Budget_data_required');
			echo json_encode($response);
			exit;
		}
		$filterData = array(
			"budget_id" => $id
		);
		$budgetData = $this->budget_model->getBudgetData($filterData);
		$expBudgetSubLedderData = $this->budget_model->getBudgetAccountSubAccountData(array(
			"is_multiple" => 1,
			"budget_id" => $id,
			"account_type" => "expense"
		));
		$expenseFilterData = array();
		$expenseAccountWiseData = array();
		if(!empty($expBudgetSubLedderData)){
			foreach ($expBudgetSubLedderData as $expenseElement) {
				$subAccountObjectArray = array();
				$subAccountObjectArray['sub_account_id'] = $expenseElement['sub_account_id'];
				$subAccountObjectArray['sub_account_code_name'] = $expenseElement['sub_account_code_name'];
				$subAccountObjectArray['amount'] = $expenseElement['amount'];
				$expenseAccountWiseData[$expenseElement['account_code_name']][] = $subAccountObjectArray;
				if(!isset($expenseFilterData[$expenseElement['account_code_name']])) {
					$expenseFilterData[$expenseElement['account_code_name']]['account_code_name'] = $expenseElement['account_code_name'];
					$expenseFilterData[$expenseElement['account_code_name']]['account_id'] = $expenseElement['account_id'];
				} 
			}
		}

		if(!empty($expenseFilterData)){
			$expenseFilterData = array_values($expenseFilterData);
			foreach ($expenseFilterData as $expKey => $expenseFilterElement){
				$expenseFilterData[$expKey]['sub_account_data'] = array_key_exists($expenseFilterElement['account_code_name'],$expenseAccountWiseData) ?$expenseAccountWiseData[$expenseFilterElement['account_code_name']] : array();
			}
		}

		$incBudgetSubLedderData = $this->budget_model->getBudgetAccountSubAccountData(array(
			"is_multiple" => 1,
			"budget_id" => $id,
			"account_type" => "income"
		));
		$incomeFilterData = array();
		$incomeAccountWiseData = array();
		if(!empty($incBudgetSubLedderData)){
			foreach ($incBudgetSubLedderData as $incomeElement) {
				$subAccountObjectArray = array();
				$subAccountObjectArray['sub_account_id'] = $incomeElement['sub_account_id'];
				$subAccountObjectArray['sub_account_code_name'] = $incomeElement['sub_account_code_name'];
				$subAccountObjectArray['amount'] = $incomeElement['amount'];
				$incomeAccountWiseData[$incomeElement['account_code_name']][] = $subAccountObjectArray;
				if(!isset($incomeFilterData[$incomeElement['account_code_name']])) {
					$incomeFilterData[$incomeElement['account_code_name']]['account_code_name'] = $incomeElement['account_code_name'];
					$incomeFilterData[$incomeElement['account_code_name']]['account_id'] = $incomeElement['account_id'];
				} 
			}
		}
		if(!empty($incomeFilterData)){
			$incomeFilterData = array_values($incomeFilterData);
			foreach ($incomeFilterData as $incKey => $incomeFilterElement){
				$incomeFilterData[$incKey]['sub_account_data'] = array_key_exists($incomeFilterElement['account_code_name'],$incomeAccountWiseData) ?$incomeAccountWiseData[$incomeFilterElement['account_code_name']] : array();
			}
		}

		if(!empty($budgetData)) {
				$data['budget_data'] = $budgetData;
				$data['expense_data'] = $expenseFilterData;
				$data['income_data'] = $incomeFilterData;
				$data['name'] = lang("Budget.pdf_budget") . "_" . str_replace('/', '_', $data['budget_data']['financial_year_prefix']) . ".pdf";
				$printHeader = '';
				$printFooter = '';
				$html = view('Admin/Budget/Pdf/BudgetPdfView', $data);
				// printArray($html,1);

				generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
		}
	}

}
